/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceUtil;
import com.android.tools.idea.editors.gfxtrace.UiErrorCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.Controller;
import com.android.tools.idea.editors.gfxtrace.service.ErrDataUnavailable;
import com.android.tools.idea.editors.gfxtrace.service.MemoryInfo;
import com.android.tools.idea.editors.gfxtrace.service.memory.MemoryRange;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomRangePath;
import com.android.tools.idea.editors.gfxtrace.service.path.MemoryRangePath;
import com.android.tools.idea.editors.gfxtrace.service.path.MemoryType;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.idea.editors.gfxtrace.service.path.PathProtos;
import com.android.tools.idea.editors.gfxtrace.service.path.TypedMemoryPath;
import com.android.tools.idea.editors.gfxtrace.widgets.LoadablePanel;
import com.android.tools.rpclib.rpccore.Rpc;
import com.android.tools.rpclib.rpccore.RpcException;
import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.reference.SoftReference;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Range;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Segment;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryController
extends Controller {
    private static final int DEFAULT_MEMORY_SIZE = 65536;
    private static final char UNKNOWN_CHAR = '?';
    @NotNull
    private static final Logger LOG = Logger.getInstance(MemoryController.class);
    @NotNull
    private final JPanel myPanel = new JPanel(new BorderLayout());
    @NotNull
    private final LoadablePanel myLoading = new LoadablePanel(new BorderLayout());
    @NotNull
    private final EmptyPanel myEmptyPanel = new EmptyPanel();
    @NotNull
    private final JScrollPane myScrollPane = new JBScrollPane((Component)this.myEmptyPanel);
    @NotNull
    private DataType myDataType = DataType.Bytes;
    @NotNull
    private ComboBox myCombo;
    private AtomPath myAtomPath;
    private MemoryDataModel myMemoryData;

    public static JComponent createUI(@NotNull GfxTraceEditor editor) {
        return new MemoryController((GfxTraceEditor)editor).myPanel;
    }

    private MemoryController(@NotNull GfxTraceEditor editor) {
        super(editor);
        this.myLoading.getContentLayer().add((Component)this.myScrollPane, "Center");
        this.myCombo = new ComboBox((Object[])DataType.values()){
            {
                this.setSelectedIndex(1);
                this.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        MemoryController.this.setDataType((DataType)((Object)e.getItem()));
                    }
                });
            }
        };
        this.myPanel.add((Component)this.myCombo, "North");
        this.myPanel.add((Component)((Object)this.myLoading), "Center");
        this.myScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    private void setDataType(DataType dataType) {
        if (this.myDataType != dataType) {
            this.myDataType = dataType;
            Component component = this.myScrollPane.getViewport().getView();
            if (component instanceof MemoryPanel) {
                ((MemoryPanel)component).setModel(dataType.getMemoryModel(this.myMemoryData));
            }
        }
    }

    private DataType dataTypeFromMemoryType(MemoryType type) {
        long size = type.getByteSize();
        if (size == 0L) {
            return this.myDataType;
        }
        PathProtos.MemoryKind kind = type.getKind();
        if (kind.equals((Object)PathProtos.MemoryKind.Integer)) {
            if (size == 1L) {
                return DataType.Bytes;
            }
            if (size == 2L) {
                return DataType.Shorts;
            }
            if (size == 4L) {
                return DataType.Ints;
            }
            if (size == 8L) {
                return DataType.Longs;
            }
        } else {
            if (size == 1L && kind.equals((Object)PathProtos.MemoryKind.Char)) {
                return DataType.Text;
            }
            if (kind.equals((Object)PathProtos.MemoryKind.Address)) {
                if (size == 4L) {
                    return DataType.Ints;
                }
                if (size == 8L) {
                    return DataType.Longs;
                }
            } else if (kind.equals((Object)PathProtos.MemoryKind.Float)) {
                if (size == 4L) {
                    return DataType.Floats;
                }
                if (size == 8L) {
                    return DataType.Doubles;
                }
            }
        }
        return this.myDataType;
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
        MemoryRangePath memoryPath;
        TypedMemoryPath typedMemoryPath = event.findTypedMemoryPath();
        MemoryRangePath memoryRangePath = memoryPath = typedMemoryPath != null ? typedMemoryPath.getRange() : event.findMemoryPath();
        if (memoryPath != null) {
            DataType dataType;
            GfxTraceUtil.trackEvent("gfxTraceMemoryViewed", null, null);
            DataType dataType2 = dataType = typedMemoryPath != null ? this.dataTypeFromMemoryType(typedMemoryPath.getType()) : this.myDataType;
            if (memoryPath.getSize() == 0L) {
                memoryPath.setSize(65536L);
            }
            this.myLoading.startLoading();
            PagedMemoryDataModel.MemoryFetcher fetcher = new PagedMemoryDataModel.MemoryFetcher(){

                @Override
                public ListenableFuture<MemoryInfo> get(long address, long count) {
                    return MemoryController.this.myEditor.getClient().get(new MemoryRangePath().setAfter(memoryPath.getAfter()).setPool(memoryPath.getPool()).setAddress(address).setSize(count));
                }
            };
            if (PagedMemoryDataModel.shouldUsePagedModel(memoryPath.getSize())) {
                this.myMemoryData = new PagedMemoryDataModel(fetcher, memoryPath.getAddress(), memoryPath.getSize());
                this.myDataType = dataType;
                this.myCombo.setSelectedItem((Object)dataType);
                this.update();
            } else {
                Rpc.listen(fetcher.get(memoryPath.getAddress(), memoryPath.getSize()), (Logger)LOG, (Rpc.Callback)new UiErrorCallback<MemoryInfo, MemoryDataModel, String>(){

                    @Override
                    protected UiErrorCallback.ResultOrError<MemoryDataModel, String> onRpcThread(Rpc.Result<MemoryInfo> result) throws RpcException, ExecutionException {
                        MemoryInfo info;
                        try {
                            info = (MemoryInfo)result.get();
                        }
                        catch (ErrDataUnavailable e) {
                            return this.error(e.getMessage());
                        }
                        if (info == null) {
                            return this.error("No memory data");
                        }
                        return this.success(new ImmediateMemoryDataModel(memoryPath.getAddress(), info));
                    }

                    @Override
                    protected void onUiThreadSuccess(MemoryDataModel result) {
                        MemoryController.this.myMemoryData = result;
                        MemoryController.this.myDataType = dataType;
                        MemoryController.this.myCombo.setSelectedItem((Object)dataType);
                        MemoryController.this.update();
                    }

                    @Override
                    protected void onUiThreadError(String message) {
                        MemoryController.this.myEmptyPanel.setText(message);
                        MemoryController.this.myScrollPane.setViewportView(MemoryController.this.myEmptyPanel);
                    }
                });
            }
            this.myAtomPath = memoryPath.getAfter();
        } else {
            AtomRangePath atomPath = event.findAtomPath();
            if (this.myAtomPath == null || atomPath == null || !this.myAtomPath.equals(atomPath.getPathToLast())) {
                this.myAtomPath = atomPath == null ? null : atomPath.getPathToLast();
                this.myEmptyPanel.resetText();
                this.myScrollPane.setViewportView(this.myEmptyPanel);
            }
        }
    }

    private void update() {
        this.myLoading.stopLoading();
        this.myScrollPane.setViewportView(new MemoryPanel(this.myDataType.getMemoryModel(this.myMemoryData)));
    }

    private static BitSet computeKnown(MemoryInfo data) {
        BitSet known = new BitSet(data.getData().length);
        for (MemoryRange rng : data.getObserved()) {
            known.set((int)rng.getBase(), (int)rng.getBase() + (int)rng.getSize());
        }
        return known;
    }

    private static class TextMemoryModel
    implements MemoryModel {
        private static final int UNKNOWN_LINE_LENGTH = 100;
        private static final int SCAN_SIZE = 65536;
        private static final char PLACE_HOLDER = '\u25af';
        private final MemoryDataModel myMemory;
        private final List<String> myLines = Lists.newArrayList();
        private int myLineLength;
        private Runnable myListener;

        public TextMemoryModel(MemoryDataModel memory) {
            this.myMemory = memory;
            this.scan();
        }

        private void scan() {
            ListenableFuture lines = Futures.transform(this.myMemory.get(0, Math.min(this.myMemory.getByteCount(), 65536)), (AsyncFunction)new AsyncFunction<MemorySegment, List<String>>(){
                private List<String> result = Lists.newArrayList();
                private int done = 0;
                private boolean prevWasCarriageRet = false;
                private StringBuilder current = new StringBuilder();
                private StringBuilder unknown = new StringBuilder();

                public ListenableFuture<List<String>> apply(MemorySegment data) throws Exception {
                    int i = 0;
                    int j = data.myOffset;
                    while (i < data.myLength) {
                        if (!data.getByteKnown(j)) {
                            if (this.current.length() != 0) {
                                this.result.add(this.current.toString());
                                this.current.delete(0, this.current.length());
                            }
                            if (this.unknown.length() == 100) {
                                this.result.add(this.unknown.toString());
                                this.unknown.delete(0, this.unknown.length());
                            } else {
                                this.unknown.append('?');
                            }
                            this.prevWasCarriageRet = false;
                        } else {
                            if (this.unknown.length() != 0) {
                                this.result.add(this.unknown.toString());
                                this.unknown.delete(0, this.unknown.length());
                            }
                            if (data.myData[j] == 13) {
                                this.result.add(this.current.toString());
                                this.current.delete(0, this.current.length());
                                this.prevWasCarriageRet = true;
                            } else {
                                if (data.myData[j] == 10) {
                                    if (!this.prevWasCarriageRet) {
                                        this.result.add(this.current.toString());
                                        this.current.delete(0, this.current.length());
                                    }
                                } else {
                                    int value = data.myData[j] & 0xFF;
                                    this.current.append(value >= 127 || value < 32 ? (char)'\u25af' : (char)value);
                                }
                                this.prevWasCarriageRet = false;
                            }
                        }
                        ++i;
                        ++j;
                    }
                    this.done += data.myLength;
                    if (this.done < myMemory.getByteCount()) {
                        return Futures.transform(myMemory.get(this.done, Math.min(myMemory.getByteCount() - this.done, 65536)), (AsyncFunction)this);
                    }
                    if (this.current.length() > 0) {
                        this.result.add(this.current.toString());
                    }
                    if (this.unknown.length() > 0) {
                        this.result.add(this.unknown.toString());
                    }
                    return Futures.immediateFuture(this.result);
                }
            });
            Futures.addCallback((ListenableFuture)lines, (FutureCallback)new FutureCallback<List<String>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(List<String> result) {
                    Runnable listener;
                    int maxLength = 0;
                    for (String line : result) {
                        maxLength = Math.max(maxLength, line.length());
                    }
                    2 var4_4 = this;
                    synchronized (var4_4) {
                        myLines.addAll(result);
                        myLineLength = maxLength;
                        listener = myListener;
                        myListener = null;
                    }
                    if (listener != null) {
                        ApplicationManager.getApplication().invokeLater(listener);
                    }
                }

                public void onFailure(Throwable t) {
                    LOG.error("Failed to read memory", t);
                }
            });
        }

        @Override
        public synchronized int getLineCount() {
            return this.myLines.size();
        }

        @Override
        public synchronized int getLineLength() {
            return this.myLineLength;
        }

        @Override
        public synchronized Iterator<Segment> getLines(int start, int end, Runnable onChange) {
            if (start < 0 || end < start || end > this.getLineCount()) {
                throw new IndexOutOfBoundsException("[" + start + ", " + end + ") outside of [0, " + this.getLineCount() + ")");
            }
            if (this.myLines.isEmpty()) {
                this.myListener = onChange;
                return Iterators.emptyIterator();
            }
            return Iterators.transform(this.myLines.subList(start, end).iterator(), (Function)new Function<String, Segment>(){
                private final Segment segment;
                {
                    this.segment = new Segment(new char[this.getLineLength()], 0, this.getLineLength());
                }

                public Segment apply(String input) {
                    input.getChars(0, input.length(), this.segment.array, 0);
                    Arrays.fill(this.segment.array, input.length(), this.segment.array.length, ' ');
                    return this.segment;
                }
            });
        }

        @Override
        public Range<Integer> getSelectableRegion(int column) {
            if (column >= 0 && column < this.getLineLength()) {
                return new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.getLineLength()));
            }
            return null;
        }

        @Override
        public synchronized ListenableFuture<Transferable> getTransferable(Range<Integer> selectionRange, Point start, Point end) {
            if (start.y >= this.myLines.size() || end.y >= this.myLines.size() || start.y > end.y || start.y == end.y && (start.x >= end.x || start.x >= this.myLines.get(start.y).length())) {
                return Futures.immediateFuture((Object)new StringSelection(""));
            }
            StringBuilder result = new StringBuilder();
            if (start.x < this.myLines.get(start.y).length()) {
                String first = this.myLines.get(start.y);
                if (start.y == end.y) {
                    result.append(first.substring(start.x, Math.min(first.length(), end.x)));
                } else {
                    result.append(first.substring(start.x)).append('\n');
                }
            }
            for (int i = start.y + 1; i < end.y; ++i) {
                result.append(this.myLines.get(i)).append('\n');
            }
            if (end.y != start.y) {
                String last = this.myLines.get(end.y);
                if (end.x > last.length()) {
                    result.append(last).append('\n');
                } else {
                    result.append(last.substring(0, end.x));
                }
            }
            return Futures.immediateFuture((Object)new StringSelection(result.toString()));
        }
    }

    private static class DoublesMemoryModel
    extends CharBufferMemoryModel {
        private static final int DOUBLES_PER_ROW = 2;
        private static final int CHARS_PER_DOUBLE = 24;
        private static final int DOUBLE_SEPARATOR = 1;
        private static final int DOUBLES_CHARS = 50;
        private static final int CHARS_PER_ROW = 67;
        private static final Range<Integer> DOUBLES_RANGE = new Range((Comparable)Integer.valueOf(18), (Comparable)Integer.valueOf(67));

        public DoublesMemoryModel(MemoryDataModel data) {
            super(data.align(8), 67, DOUBLES_RANGE);
        }

        @Override
        protected void formatMemory(char[] buffer, MemorySegment memory) {
            StringBuilder sb = new StringBuilder(50);
            int i = 0;
            int j = 17;
            while (i + 7 < memory.myLength) {
                sb.setLength(0);
                if (memory.getLongKnown(i)) {
                    sb.append(Double.longBitsToDouble(memory.getLong(i)));
                } else {
                    DoublesMemoryModel.appendUnknown(sb, 24);
                }
                int count = Math.min(24, sb.length());
                sb.getChars(0, count, buffer, j + 24 - count + 1);
                i += 8;
                j += 25;
            }
        }
    }

    private static class FloatsMemoryModel
    extends CharBufferMemoryModel {
        private static final int FLOATS_PER_ROW = 4;
        private static final int CHARS_PER_FLOAT = 15;
        private static final int FLOAT_SEPARATOR = 1;
        private static final int FLOATS_CHARS = 64;
        private static final int CHARS_PER_ROW = 81;
        private static final Range<Integer> FLOATS_RANGE = new Range((Comparable)Integer.valueOf(18), (Comparable)Integer.valueOf(81));

        public FloatsMemoryModel(MemoryDataModel data) {
            super(data.align(4), 81, FLOATS_RANGE);
        }

        @Override
        protected void formatMemory(char[] buffer, MemorySegment memory) {
            StringBuilder sb = new StringBuilder(50);
            int i = 0;
            int j = 17;
            while (i + 3 < memory.myLength) {
                sb.setLength(0);
                if (memory.getIntKnown(i)) {
                    sb.append(Float.intBitsToFloat(memory.getInt(i)));
                } else {
                    FloatsMemoryModel.appendUnknown(sb, 15);
                }
                int count = Math.min(15, sb.length());
                sb.getChars(0, count, buffer, j + 15 - count + 1);
                i += 4;
                j += 16;
            }
        }
    }

    private static class LongsMemoryModel
    extends IntegersMemoryModel {
        public LongsMemoryModel(MemoryDataModel data) {
            super(data, 8);
        }
    }

    private static class IntsMemoryModel
    extends IntegersMemoryModel {
        public IntsMemoryModel(MemoryDataModel data) {
            super(data, 4);
        }
    }

    private static class ShortsMemoryModel
    extends IntegersMemoryModel {
        public ShortsMemoryModel(MemoryDataModel data) {
            super(data, 2);
        }
    }

    private static class IntegersMemoryModel
    extends CharBufferMemoryModel {
        private static final ByteOrder ENDIAN = ByteOrder.LITTLE_ENDIAN;
        private static final int ITEM_SEPARATOR = 1;
        private final int mySize;

        private static int charsPerItem(int size) {
            return size * 2;
        }

        private static int itemChars(int size) {
            int itemsPerRow = 16 / size;
            int charsPerItem = IntegersMemoryModel.charsPerItem(size);
            return (charsPerItem + 1) * itemsPerRow;
        }

        private static int charsPerRow(int size) {
            return 17 + IntegersMemoryModel.itemChars(size);
        }

        private static Range<Integer> itemsRange(int size) {
            return new Range((Comparable)Integer.valueOf(18), (Comparable)Integer.valueOf(17 + IntegersMemoryModel.itemChars(size)));
        }

        protected IntegersMemoryModel(MemoryDataModel data, int size) {
            super(data.align(size), IntegersMemoryModel.charsPerRow(size), IntegersMemoryModel.itemsRange(size));
            this.mySize = size;
        }

        @Override
        protected void formatMemory(char[] buffer, MemorySegment memory) {
            int charsPerItem = IntegersMemoryModel.charsPerItem(this.mySize);
            int i = 0;
            int j = 17;
            while (i + this.mySize <= memory.myLength) {
                int k;
                if (memory.getByteKnown(i, this.mySize)) {
                    for (k = 0; k < this.mySize; ++k) {
                        int val = memory.getByte(i + k);
                        int chOff = ENDIAN.equals(ByteOrder.LITTLE_ENDIAN) ? IntegersMemoryModel.charsPerItem(this.mySize - 1 - k) : IntegersMemoryModel.charsPerItem(k);
                        buffer[j + chOff + 1] = HEX_DIGITS[val >> 4 & 0xF];
                        buffer[j + chOff + 2] = HEX_DIGITS[val & 0xF];
                    }
                } else {
                    for (k = 0; k < charsPerItem; ++k) {
                        buffer[j + k + 1] = 63;
                    }
                }
                i += this.mySize;
                j += charsPerItem + 1;
            }
        }
    }

    private static class BytesMemoryModel
    extends CharBufferMemoryModel {
        private static final int CHARS_PER_BYTE = 2;
        private static final int BYTE_SEPARATOR = 1;
        private static final int ASCII_SEPARATOR = 2;
        private static final int BYTES_CHARS = 48;
        private static final int ASCII_CHARS = 18;
        private static final int CHARS_PER_ROW = 83;
        private static final Range<Integer> BYTES_RANGE = new Range((Comparable)Integer.valueOf(18), (Comparable)Integer.valueOf(65));
        private static final Range<Integer> ASCII_RANGE = new Range((Comparable)Integer.valueOf(67), (Comparable)Integer.valueOf(83));

        public BytesMemoryModel(MemoryDataModel data) {
            super(data, 83, BYTES_RANGE);
        }

        @Override
        public Range<Integer> getSelectableRegion(int column) {
            if (ASCII_RANGE.isWithin((Comparable)Integer.valueOf(column))) {
                return ASCII_RANGE;
            }
            return super.getSelectableRegion(column);
        }

        @Override
        public ListenableFuture<Transferable> getTransferable(Range<Integer> selectionRange, final Point start, final Point end) {
            if (selectionRange == ASCII_RANGE) {
                return Futures.transform(this.myData.get(start.y * 16, (end.y - start.y + 1) * 16), (Function)new Function<MemorySegment, Transferable>(){

                    public Transferable apply(MemorySegment s) {
                        return new StringSelection(s.asString(start.x - (Integer)ASCII_RANGE.getFrom(), s.myLength - start.x + (Integer)ASCII_RANGE.getFrom() - (Integer)ASCII_RANGE.getTo() + end.x));
                    }
                });
            }
            return super.getTransferable(selectionRange, start, end);
        }

        @Override
        protected void formatMemory(char[] buffer, MemorySegment memory) {
            int b;
            int i = 0;
            int j = 17;
            while (i < memory.myLength) {
                b = memory.getByte(i);
                if (memory.getByteKnown(i)) {
                    buffer[j + 1] = HEX_DIGITS[b >> 4 & 0xF];
                    buffer[j + 2] = HEX_DIGITS[b >> 0 & 0xF];
                } else {
                    buffer[j + 1] = 63;
                    buffer[j + 2] = 63;
                }
                ++i;
                j += 3;
            }
            i = 0;
            j = 67;
            while (i < memory.myLength) {
                b = memory.getByte(i);
                buffer[j] = memory.getByteKnown(i) && b >= 32 && b < 127 ? (int)b : 46;
                ++i;
                ++j;
            }
        }
    }

    private static abstract class CharBufferMemoryModel
    extends FixedMemoryModel {
        protected static final int CHARS_PER_ADDRESS = 16;
        protected static final int ADDRESS_SEPARATOR = 1;
        protected static final int ADDRESS_CHARS = 17;
        protected static final Range<Integer> ADDRESS_RANGE = new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(16));
        protected static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
        protected final int myCharsPerRow;
        protected final Range<Integer> myMemoryRange;

        public CharBufferMemoryModel(MemoryDataModel data, int charsPerRow, Range<Integer> memoryRange) {
            super(data);
            this.myCharsPerRow = charsPerRow;
            this.myMemoryRange = memoryRange;
        }

        @Override
        public int getLineLength() {
            return this.myCharsPerRow;
        }

        protected static void appendUnknown(StringBuilder str, int n) {
            for (int i = 0; i < n; ++i) {
                str.append('?');
            }
        }

        @Override
        protected void getLine(Segment segment, MemorySegment memory, int line) {
            segment.array = new char[this.myCharsPerRow];
            segment.offset = 0;
            segment.count = this.myCharsPerRow;
            this.formatLine(segment.array, memory, line);
        }

        private void formatLine(char[] array, MemorySegment memory, int line) {
            Arrays.fill(array, ' ');
            long address = this.myData.getAddress() + (long)(line * 16);
            int i = 15;
            while (i >= 0) {
                array[i] = HEX_DIGITS[(int)address & 0xF];
                --i;
                address >>>= 4;
            }
            array[16] = 58;
            this.formatMemory(array, memory);
        }

        protected abstract void formatMemory(char[] var1, MemorySegment var2);

        @Override
        public Range<Integer> getSelectableRegion(int column) {
            if (ADDRESS_RANGE.isWithin((Comparable)Integer.valueOf(column))) {
                return ADDRESS_RANGE;
            }
            if (this.myMemoryRange.isWithin((Comparable)Integer.valueOf(column))) {
                return this.myMemoryRange;
            }
            return null;
        }

        @Override
        public ListenableFuture<Transferable> getTransferable(final Range<Integer> selectionRange, final Point start, final Point end) {
            return Futures.transform(this.myData.get(start.y * 16, (end.y - start.y + 1) * 16), (Function)new Function<MemorySegment, Transferable>(){

                public Transferable apply(MemorySegment memory) {
                    StringBuilder buffer = new StringBuilder();
                    Iterator<Segment> lines = this.getLines(start.y, end.y + 1, memory);
                    if (lines.hasNext()) {
                        Segment segment = lines.next();
                        if (start.y == end.y) {
                            buffer.append(segment.array, segment.offset + start.x, end.x - start.x);
                        } else {
                            buffer.append(segment.array, segment.offset + start.x, (Integer)selectionRange.getTo() - start.x).append('\n');
                        }
                    }
                    int rangeWidth = (Integer)selectionRange.getTo() - (Integer)selectionRange.getFrom();
                    for (int line = start.y + 1; lines.hasNext() && line < end.y; ++line) {
                        Segment segment = lines.next();
                        buffer.append(segment.array, segment.offset + (Integer)selectionRange.getFrom(), rangeWidth).append('\n');
                    }
                    if (lines.hasNext()) {
                        Segment segment = lines.next();
                        buffer.append(segment.array, segment.offset + (Integer)selectionRange.getFrom(), end.x - (Integer)selectionRange.getFrom()).append('\n');
                    }
                    return new StringSelection(buffer.toString());
                }
            });
        }
    }

    private static abstract class FixedMemoryModel
    implements MemoryModel {
        protected static final int BYTES_PER_ROW = 16;
        protected final MemoryDataModel myData;
        protected final int myRows;

        public FixedMemoryModel(MemoryDataModel data) {
            this.myData = data;
            this.myRows = (data.getByteCount() + 16 - 1) / 16;
        }

        @Override
        public int getLineCount() {
            return this.myRows;
        }

        @Override
        public Iterator<Segment> getLines(int start, int end, Runnable onChange) {
            if (start < 0 || end < start || end > this.getLineCount()) {
                throw new IndexOutOfBoundsException("[" + start + ", " + end + ") outside of [0, " + this.getLineCount() + ")");
            }
            ListenableFuture<MemorySegment> future = this.myData.get(start * 16, (end - start) * 16);
            if (future.isDone()) {
                return this.getLines(start, end, (MemorySegment)Futures.getUnchecked(future));
            }
            future.addListener(onChange, (Executor)EdtExecutor.INSTANCE);
            return EmptyIterator.getInstance();
        }

        protected Iterator<Segment> getLines(final int start, final int end, final MemorySegment memory) {
            return new Iterator<Segment>(){
                private int pos;
                private int offset;
                private final Segment segment;
                {
                    this.pos = start;
                    this.offset = 0;
                    this.segment = new Segment(null, 0, 0);
                }

                @Override
                public boolean hasNext() {
                    return this.pos < end;
                }

                @Override
                public Segment next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.getLine(this.segment, memory.subSegment(this.offset, 16), this.pos);
                    ++this.pos;
                    this.offset += 16;
                    return this.segment;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        protected abstract void getLine(Segment var1, MemorySegment var2, int var3);
    }

    private static interface MemoryModel {
        public int getLineCount();

        public int getLineLength();

        public Iterator<Segment> getLines(int var1, int var2, Runnable var3);

        public Range<Integer> getSelectableRegion(int var1);

        public ListenableFuture<Transferable> getTransferable(Range<Integer> var1, Point var2, Point var3);
    }

    private static class MemorySegment {
        private final byte[] myData;
        private final BitSet myKnown;
        private final int myOffset;
        private final int myLength;

        private MemorySegment(byte[] data, BitSet known, int offset, int length) {
            this.myData = data;
            this.myOffset = offset;
            this.myLength = length;
            this.myKnown = known;
        }

        public MemorySegment(List<MemorySegment> segments, int length) {
            int done;
            int count;
            byte[] data = new byte[length];
            BitSet known = new BitSet(length);
            Iterator<MemorySegment> it = segments.iterator();
            for (done = 0; it.hasNext() && done < length; done += count) {
                MemorySegment segment = it.next();
                count = Math.min(length - done, segment.myLength);
                System.arraycopy(segment.myData, segment.myOffset, data, done, count);
                for (int i = 0; i < count; ++i) {
                    known.set(done + i, segment.myKnown.get(segment.myOffset + i));
                }
            }
            this.myData = data;
            this.myKnown = known;
            this.myOffset = 0;
            this.myLength = done;
        }

        public MemorySegment(MemoryInfo info) {
            this.myData = info.getData();
            this.myOffset = 0;
            this.myKnown = MemoryController.computeKnown(info);
            this.myLength = info.getData().length;
        }

        public MemorySegment subSegment(int start, int count) {
            return new MemorySegment(this.myData, this.myKnown, this.myOffset + start, Math.min(count, this.myLength - start));
        }

        public String asString(int start, int count) {
            return new String(this.myData, this.myOffset + start, Math.min(count, this.myLength - start), Charset.forName("US-ASCII"));
        }

        private boolean getByteKnown(int offset, int size) {
            if (offset < 0 || size < 0 || this.myOffset + offset + size > this.myData.length) {
                return false;
            }
            if (this.myKnown == null) {
                return true;
            }
            for (int o = offset; o < offset + size; ++o) {
                if (this.myKnown.get(this.myOffset + o)) continue;
                return false;
            }
            return true;
        }

        public boolean getByteKnown(int off) {
            return this.getByteKnown(off, 1);
        }

        public int getByte(int off) {
            return this.myData[this.myOffset + off] & 0xFF;
        }

        public boolean getIntKnown(int off) {
            return this.getByteKnown(off, 4);
        }

        public int getInt(int off) {
            return this.myData[(off += this.myOffset) + 0] & 0xFF | (this.myData[off + 1] & 0xFF) << 8 | (this.myData[off + 2] & 0xFF) << 16 | this.myData[off + 3] << 24;
        }

        public boolean getLongKnown(int off) {
            return this.getByteKnown(off, 8);
        }

        public long getLong(int off) {
            return (long)this.getInt(off) & 0xFFFFFFFFL | (long)this.getInt(off + 4) << 32;
        }
    }

    private static class PagedMemoryDataModel
    implements MemoryDataModel {
        private static final int PAGE_SIZE = 65536;
        private static final int PAGE_SHIFT = 16;
        private final MemoryFetcher fetcher;
        private final long address;
        private final int size;
        private final Map<Integer, SoftReference<MemoryInfo>> pageCache = Maps.newHashMap();

        public PagedMemoryDataModel(MemoryFetcher fetcher, long address, long size) {
            this.fetcher = fetcher;
            this.address = address;
            this.size = (int)size;
        }

        public static boolean shouldUsePagedModel(long size) {
            return size >= 131072L;
        }

        @Override
        public long getAddress() {
            return this.address;
        }

        @Override
        public int getByteCount() {
            return this.size;
        }

        @Override
        public ListenableFuture<MemorySegment> get(int offset, int length) {
            int lastPage;
            offset = Math.min(this.size - 1, offset);
            length = Math.min(this.size - offset, length);
            int firstPage = PagedMemoryDataModel.getPageForOffset(offset);
            if (firstPage == (lastPage = PagedMemoryDataModel.getPageForOffset(offset + length))) {
                return this.getPage(firstPage, PagedMemoryDataModel.getOffsetInPage(offset), length);
            }
            ArrayList futures = Lists.newArrayList();
            futures.add(this.getPage(firstPage, PagedMemoryDataModel.getOffsetInPage(offset), 65536 - PagedMemoryDataModel.getOffsetInPage(offset)));
            int page = firstPage + 1;
            int left = length - 65536 + PagedMemoryDataModel.getOffsetInPage(offset);
            while (page <= lastPage) {
                futures.add(this.getPage(page, 0, Math.min(left, 65536)));
                ++page;
                left -= 65536;
            }
            final int totalLength = length;
            return Futures.transform((ListenableFuture)Futures.allAsList((Iterable)futures), (Function)new Function<List<MemorySegment>, MemorySegment>(){

                public MemorySegment apply(List<MemorySegment> segments) {
                    return new MemorySegment(segments, totalLength);
                }
            });
        }

        private static int getPageForOffset(int offset) {
            return offset >>> 16;
        }

        private static int getOffsetForPage(int page) {
            return page << 16;
        }

        private static int getOffsetInPage(int offset) {
            return offset & 0xFFFF;
        }

        private ListenableFuture<MemorySegment> getPage(final int page, int offset, int length) {
            MemoryInfo mem = this.getFromCache(page);
            if (mem != null) {
                return Futures.immediateFuture((Object)new MemorySegment(mem).subSegment(offset, length));
            }
            long base = this.address + (long)PagedMemoryDataModel.getOffsetForPage(page);
            return Futures.transform(this.fetcher.get(base, (int)Math.min(this.address + (long)this.size - base, 65536L)), (Function)new Function<MemoryInfo, MemorySegment>(){

                public MemorySegment apply(MemoryInfo mem) {
                    this.addToCache(page, mem);
                    return new MemorySegment(mem);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MemoryInfo getFromCache(int page) {
            MemoryInfo result = null;
            Map<Integer, SoftReference<MemoryInfo>> map = this.pageCache;
            synchronized (map) {
                SoftReference<MemoryInfo> reference = this.pageCache.get(page);
                if (reference != null && (result = (MemoryInfo)reference.get()) == null) {
                    this.pageCache.remove(page);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addToCache(int page, MemoryInfo data) {
            Map<Integer, SoftReference<MemoryInfo>> map = this.pageCache;
            synchronized (map) {
                this.pageCache.put(page, (SoftReference<MemoryInfo>)new SoftReference((Object)data));
            }
        }

        @Override
        public MemoryDataModel align(int byteAlign) {
            return this;
        }

        public static interface MemoryFetcher {
            public ListenableFuture<MemoryInfo> get(long var1, long var3);
        }
    }

    private static class ImmediateMemoryDataModel
    implements MemoryDataModel {
        private final long address;
        private final MemorySegment memory;

        public ImmediateMemoryDataModel(long address, MemoryInfo info) {
            this.address = address;
            this.memory = new MemorySegment(info.getData(), MemoryController.computeKnown(info), 0, info.getData().length);
        }

        private ImmediateMemoryDataModel(long address, MemorySegment data) {
            this.address = address;
            this.memory = data;
        }

        @Override
        public long getAddress() {
            return this.address;
        }

        @Override
        public int getByteCount() {
            return this.memory.myLength;
        }

        @Override
        public ListenableFuture<MemorySegment> get(int offset, int length) {
            return Futures.immediateFuture((Object)this.memory.subSegment(offset, length));
        }

        @Override
        public MemoryDataModel align(int align) {
            int remainder = this.getByteCount() % align;
            return remainder == 0 ? this : new ImmediateMemoryDataModel(this.address, this.memory.subSegment(0, this.getByteCount() + align - remainder));
        }
    }

    private static interface MemoryDataModel {
        public long getAddress();

        public int getByteCount();

        public ListenableFuture<MemorySegment> get(int var1, int var2);

        public MemoryDataModel align(int var1);
    }

    private static class MemoryPanel
    extends JComponent
    implements Scrollable,
    DataProvider,
    CopyProvider {
        private MemoryModel myModel;
        private final EditorColorsScheme myTheme;
        private Range<Integer> mySelectionRange = null;
        private final Point mySelectionStart = new Point();
        private final Point mySelectionEnd = new Point();
        private final Runnable myRepainter = new Runnable(){

            @Override
            public void run() {
                this.revalidate();
                this.repaint();
            }
        };
        private int myLineHeight;
        private int myAscent;
        private int myCharWidth;

        public MemoryPanel(MemoryModel model) {
            this.myModel = model;
            this.myTheme = EditorColorsManager.getInstance().getGlobalScheme();
            this.setCursor(new Cursor(2));
            this.setFocusable(true);
            MouseAdapter mouseHandler = new MouseAdapter(){
                private final Point mySelectionInitiation = new Point();
                private boolean mySelecting;

                @Override
                public void mousePressed(MouseEvent e) {
                    this.requestFocus();
                    if (this.isSelectionButton(e)) {
                        if ((e.getModifiersEx() & 0x40) != 0 && mySelectionRange != null) {
                            this.mySelecting = true;
                            this.updateSelection(e);
                        } else {
                            this.startSelecting(e);
                        }
                        this.repaint();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (!this.isSelectionButton(e)) {
                        this.mySelecting = false;
                        if (mySelectionRange != null && mySelectionStart.equals(mySelectionEnd)) {
                            mySelectionRange = null;
                            this.repaint();
                        }
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (this.isSelectionButton(e)) {
                        if (mySelectionRange == null) {
                            this.startSelecting(e);
                        } else {
                            this.updateSelection(e);
                        }
                    }
                }

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    JBScrollPane ancestor;
                    if (this.mySelecting) {
                        if (mySelectionRange == null) {
                            this.startSelecting(e);
                        } else {
                            this.updateSelection(e);
                        }
                    }
                    if ((ancestor = (JBScrollPane)SwingUtilities.getAncestorOfClass(JBScrollPane.class, this)) != null) {
                        MouseWheelEvent converted = (MouseWheelEvent)SwingUtilities.convertMouseEvent(this, e, (Component)ancestor);
                        for (MouseWheelListener listener : ancestor.getMouseWheelListeners()) {
                            listener.mouseWheelMoved(converted);
                        }
                    }
                }

                private void startSelecting(MouseEvent e) {
                    this.mySelecting = true;
                    int y = e.getY() / this.getLineHeight();
                    if (y < 0 || y >= myModel.getLineCount()) {
                        mySelectionRange = null;
                        return;
                    }
                    this.mySelectionInitiation.setLocation(this.getX(e), e.getY() / this.getLineHeight());
                    mySelectionStart.setLocation(this.mySelectionInitiation);
                    mySelectionEnd.setLocation(mySelectionStart);
                    mySelectionRange = myModel.getSelectableRegion(((MemoryPanel)this).mySelectionStart.x);
                }

                private void updateSelection(MouseEvent e) {
                    int x = Math.max((Integer)mySelectionRange.getFrom(), Math.min((Integer)mySelectionRange.getTo(), this.getX(e)));
                    int y = Math.max(0, e.getY() / this.getLineHeight());
                    if (y >= myModel.getLineCount()) {
                        y = myModel.getLineCount() - 1;
                        x = (Integer)mySelectionRange.getTo();
                    }
                    if (y < this.mySelectionInitiation.y || y == this.mySelectionInitiation.y && x < this.mySelectionInitiation.x) {
                        mySelectionStart.setLocation(x, y);
                        mySelectionEnd.setLocation(this.mySelectionInitiation);
                    } else {
                        mySelectionStart.setLocation(this.mySelectionInitiation);
                        mySelectionEnd.setLocation(x, y);
                    }
                    this.repaint();
                }

                private int getX(MouseEvent e) {
                    int charWidth = this.getCharWidth();
                    return (e.getX() + charWidth / 2) / charWidth;
                }

                private boolean isSelectionButton(MouseEvent e) {
                    return (e.getModifiersEx() & 0x400) != 0;
                }
            };
            this.addMouseListener(mouseHandler);
            this.addMouseMotionListener(mouseHandler);
            this.addMouseWheelListener(mouseHandler);
        }

        public void setModel(MemoryModel model) {
            this.myModel = model;
            this.mySelectionRange = null;
            this.revalidate();
            this.repaint();
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return this;
            }
            return null;
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            return this.mySelectionRange != null && !this.mySelectionStart.equals(this.mySelectionEnd);
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            return true;
        }

        public void performCopy(@NotNull DataContext dataContext) {
            if (this.isCopyEnabled(dataContext)) {
                Futures.addCallback(this.myModel.getTransferable(this.mySelectionRange, this.mySelectionStart, this.mySelectionEnd), (FutureCallback)new FutureCallback<Transferable>(){

                    public void onFailure(Throwable t) {
                        LOG.error("Failed to load memory", t);
                    }

                    public void onSuccess(Transferable result) {
                        CopyPasteManager.getInstance().setContents(result);
                    }
                });
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension result = new Dimension(this.myModel.getLineLength() * this.getCharWidth(), this.myModel.getLineCount() * this.getLineHeight());
            if (this.getParent() instanceof JViewport) {
                Dimension parent = ((JViewport)this.getParent()).getExtentSize();
                result.width = Math.max(parent.width, result.width);
                result.height = Math.max(parent.height, result.height);
            }
            return result;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.setFont(this.myTheme.getFont(EditorFontType.PLAIN));
            g.setFont(this.myTheme.getFont(EditorFontType.PLAIN));
            this.initMeasurements();
            this.setBackground(this.myTheme.getDefaultBackground());
            this.setForeground(this.myTheme.getDefaultForeground());
            Rectangle clip = g.getClipBounds();
            g.setColor(this.getBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            g.setColor(this.getForeground());
            int lineHeight = this.getLineHeight();
            int charWidth = this.getCharWidth();
            int startRow = Math.max(0, Math.min(this.myModel.getLineCount() - 1, clip.y / lineHeight));
            int endRow = Math.max(0, Math.min(this.myModel.getLineCount(), (clip.y + clip.height + lineHeight - 1) / lineHeight));
            boolean selectionVisible = false;
            if (this.mySelectionRange != null && startRow <= this.mySelectionEnd.y && this.mySelectionStart.y <= endRow) {
                selectionVisible = true;
                g.setColor(this.myTheme.getColor(EditorColors.SELECTION_BACKGROUND_COLOR));
                if (this.mySelectionStart.y == this.mySelectionEnd.y) {
                    g.fillRect(this.mySelectionStart.x * charWidth, this.mySelectionStart.y * lineHeight, (this.mySelectionEnd.x - this.mySelectionStart.x) * charWidth, lineHeight);
                } else {
                    g.fillRect(this.mySelectionStart.x * charWidth, this.mySelectionStart.y * lineHeight, ((Integer)this.mySelectionRange.getTo() - this.mySelectionStart.x) * charWidth, lineHeight);
                    g.fillRect((Integer)this.mySelectionRange.getFrom() * charWidth, this.mySelectionEnd.y * lineHeight, (this.mySelectionEnd.x - (Integer)this.mySelectionRange.getFrom()) * charWidth, lineHeight);
                    g.fillRect((Integer)this.mySelectionRange.getFrom() * charWidth, (this.mySelectionStart.y + 1) * lineHeight, ((Integer)this.mySelectionRange.getTo() - (Integer)this.mySelectionRange.getFrom()) * charWidth, (this.mySelectionEnd.y - this.mySelectionStart.y - 1) * lineHeight);
                }
                g.setColor(this.getForeground());
            }
            g.translate(0, startRow * lineHeight);
            int y = this.getAscent();
            if (!selectionVisible) {
                Iterator<Segment> it = this.myModel.getLines(startRow, endRow, this.myRepainter);
                while (it.hasNext()) {
                    Segment segment = it.next();
                    g.drawChars(segment.array, segment.offset, segment.count, 0, y);
                    y += lineHeight;
                }
            } else {
                Segment segment;
                int row = startRow;
                int rangeWidth = (Integer)this.mySelectionRange.getTo() - (Integer)this.mySelectionRange.getFrom();
                int fromWidth = (Integer)this.mySelectionRange.getFrom() * charWidth;
                int toWidth = (Integer)this.mySelectionRange.getTo() * charWidth;
                Iterator<Segment> it = this.myModel.getLines(startRow, endRow, this.myRepainter);
                while (it.hasNext() && row < this.mySelectionStart.y) {
                    segment = it.next();
                    g.drawChars(segment.array, segment.offset, segment.count, 0, y);
                    ++row;
                    y += lineHeight;
                }
                while (it.hasNext() && row == this.mySelectionStart.y) {
                    segment = it.next();
                    g.drawChars(segment.array, segment.offset, this.mySelectionStart.x, 0, y);
                    g.setColor(this.myTheme.getColor(EditorColors.SELECTION_FOREGROUND_COLOR));
                    if (this.mySelectionStart.y == this.mySelectionEnd.y) {
                        g.drawChars(segment.array, segment.offset + this.mySelectionStart.x, this.mySelectionEnd.x - this.mySelectionStart.x, this.mySelectionStart.x * charWidth, y);
                        g.setColor(this.getForeground());
                        g.drawChars(segment.array, segment.offset + this.mySelectionEnd.x, segment.count - this.mySelectionEnd.x, this.mySelectionEnd.x * charWidth, y);
                    } else {
                        g.drawChars(segment.array, segment.offset + this.mySelectionStart.x, (Integer)this.mySelectionRange.getTo() - this.mySelectionStart.x, this.mySelectionStart.x * charWidth, y);
                        g.setColor(this.getForeground());
                        g.drawChars(segment.array, segment.offset + (Integer)this.mySelectionRange.getTo(), segment.count - (Integer)this.mySelectionRange.getTo(), toWidth, y);
                    }
                    ++row;
                    y += lineHeight;
                }
                while (it.hasNext() && row < this.mySelectionEnd.y) {
                    segment = it.next();
                    g.drawChars(segment.array, segment.offset, (Integer)this.mySelectionRange.getFrom(), 0, y);
                    g.setColor(this.myTheme.getColor(EditorColors.SELECTION_FOREGROUND_COLOR));
                    g.drawChars(segment.array, segment.offset + (Integer)this.mySelectionRange.getFrom(), rangeWidth, fromWidth, y);
                    g.setColor(this.getForeground());
                    g.drawChars(segment.array, segment.offset + (Integer)this.mySelectionRange.getTo(), segment.count - (Integer)this.mySelectionRange.getTo(), toWidth, y);
                    ++row;
                    y += lineHeight;
                }
                while (it.hasNext() && row == this.mySelectionEnd.y) {
                    segment = it.next();
                    g.drawChars(segment.array, segment.offset, (Integer)this.mySelectionRange.getFrom(), 0, y);
                    g.setColor(this.myTheme.getColor(EditorColors.SELECTION_FOREGROUND_COLOR));
                    g.drawChars(segment.array, segment.offset + (Integer)this.mySelectionRange.getFrom(), this.mySelectionEnd.x - (Integer)this.mySelectionRange.getFrom(), fromWidth, y);
                    g.setColor(this.getForeground());
                    g.drawChars(segment.array, segment.offset + this.mySelectionEnd.x, segment.count - this.mySelectionEnd.x, this.mySelectionEnd.x * charWidth, y);
                    ++row;
                    y += lineHeight;
                }
                while (it.hasNext()) {
                    segment = it.next();
                    g.drawChars(segment.array, segment.offset, segment.count, 0, y);
                    ++row;
                    y += lineHeight;
                }
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return orientation == 1 ? this.getLineHeight() : this.getCharWidth();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return orientation == 1 ? visibleRect.height - visibleRect.height % this.getLineHeight() : visibleRect.width - visibleRect.width % this.getCharWidth();
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        private int getLineHeight() {
            if (this.myLineHeight <= 0) {
                this.initMeasurements();
            }
            return this.myLineHeight;
        }

        public int getAscent() {
            if (this.myAscent <= 0) {
                this.initMeasurements();
            }
            return this.myAscent;
        }

        private int getCharWidth() {
            if (this.myCharWidth <= 0) {
                this.initMeasurements();
            }
            return this.myCharWidth;
        }

        private void initMeasurements() {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.myLineHeight = metrics.getHeight();
            this.myAscent = metrics.getAscent();
            this.myCharWidth = metrics.charWidth(' ');
        }
    }

    private static class EmptyPanel
    extends JComponent {
        private final StatusText myEmptyText = new StatusText(){

            protected boolean isStatusVisible() {
                return true;
            }
        };

        public void resetText() {
            this.myEmptyText.setText("Select a memory range or pointer in the command list");
        }

        public void setText(String message) {
            this.myEmptyText.setText(message);
        }

        public EmptyPanel() {
            this.myEmptyText.setText("Select a memory range or pointer in the command list");
            this.myEmptyText.attachTo((Component)this);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.myEmptyText.paint((Component)this, graphics);
        }
    }

    private static enum DataType {
        Text{

            @Override
            public MemoryModel getMemoryModel(MemoryDataModel memory) {
                return new TextMemoryModel(memory);
            }
        }
        ,
        Bytes{

            @Override
            public MemoryModel getMemoryModel(MemoryDataModel memory) {
                return new BytesMemoryModel(memory);
            }
        }
        ,
        Shorts{

            @Override
            public MemoryModel getMemoryModel(MemoryDataModel memory) {
                return new ShortsMemoryModel(memory);
            }
        }
        ,
        Ints{

            @Override
            public MemoryModel getMemoryModel(MemoryDataModel memory) {
                return new IntsMemoryModel(memory);
            }
        }
        ,
        Longs{

            @Override
            public MemoryModel getMemoryModel(MemoryDataModel memory) {
                return new LongsMemoryModel(memory);
            }
        }
        ,
        Floats{

            @Override
            public MemoryModel getMemoryModel(MemoryDataModel memory) {
                return new FloatsMemoryModel(memory);
            }
        }
        ,
        Doubles{

            @Override
            public MemoryModel getMemoryModel(MemoryDataModel memory) {
                return new DoublesMemoryModel(memory);
            }
        };


        public abstract MemoryModel getMemoryModel(MemoryDataModel var1);
    }
}

