/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.controllers.Controller;
import com.android.tools.idea.editors.gfxtrace.models.AtomStream;
import com.android.tools.idea.editors.gfxtrace.service.gfxapi.GfxAPIProtos;
import com.android.tools.idea.editors.gfxtrace.service.gfxapi.Mesh;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomRangePath;
import com.android.tools.idea.editors.gfxtrace.service.path.MeshPath;
import com.android.tools.idea.editors.gfxtrace.service.path.MeshPathOptions;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.idea.editors.gfxtrace.service.vertex.FmtFloat32;
import com.android.tools.idea.editors.gfxtrace.service.vertex.VertexBuffer;
import com.android.tools.idea.editors.gfxtrace.service.vertex.VertexProtos;
import com.android.tools.idea.editors.gfxtrace.service.vertex.VertexStream;
import com.android.tools.idea.editors.gfxtrace.service.vertex.VertexStreamData;
import com.android.tools.idea.editors.gfxtrace.viewer.Geometry;
import com.android.tools.idea.editors.gfxtrace.viewer.Viewer;
import com.android.tools.idea.editors.gfxtrace.viewer.camera.CylindricalCameraModel;
import com.android.tools.idea.editors.gfxtrace.viewer.camera.IsoSurfaceCameraModel;
import com.android.tools.idea.editors.gfxtrace.viewer.geo.Model;
import com.android.tools.idea.editors.gfxtrace.widgets.LoadablePanel;
import com.android.tools.rpclib.rpccore.Rpc;
import com.android.tools.rpclib.rpccore.RpcException;
import com.google.common.base.Function;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.StatusText;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeometryController
extends Controller
implements AtomStream.Listener {
    private static final Logger LOG = Logger.getInstance(GeometryController.class);
    private static final String CARD_EMPTY = "empty";
    private static final String CARD_GEOMETRY = "geometry";
    private static final FmtFloat32 FMT_XYZ_F32 = new FmtFloat32().setOrder(new VertexProtos.VectorElement[]{VertexProtos.VectorElement.X, VertexProtos.VectorElement.Y, VertexProtos.VectorElement.Z});
    private final JPanel myPanel = new JPanel(new CardLayout());
    private final LoadablePanel myLoading = new LoadablePanel(new BorderLayout());
    private final EmptyPanel myEmptyPanel = new EmptyPanel();
    private final GLJPanel myCanvas;
    private final IsoSurfaceCameraModel myCamera = new IsoSurfaceCameraModel(new CylindricalCameraModel());
    private final Viewer myViewer = new Viewer(this.myCamera);
    private Geometry myGeometry = new Geometry();
    private Geometry.DisplayMode myDisplayMode = Geometry.DisplayMode.TRIANGLES;
    private boolean myZUp = false;
    private Model myOriginalModel = null;
    private Model myFacetedModel = null;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new GeometryController((GfxTraceEditor)editor).myPanel;
    }

    public GeometryController(@NotNull GfxTraceEditor editor) {
        super(editor);
        editor.getAtomStream().addListener(this);
        GLProfile profile = GLProfile.getDefault();
        GLCapabilities caps = new GLCapabilities(profile);
        caps.setDoubleBuffered(true);
        caps.setHardwareAccelerated(true);
        caps.setSampleBuffers(true);
        this.myCanvas = new GLJPanel((GLCapabilitiesImmutable)caps);
        this.myCanvas.addGLEventListener((GLEventListener)this.myViewer);
        this.myViewer.addMouseListeners((Component)this.myCanvas);
        JPanel geoPanel = new JPanel(new BorderLayout());
        geoPanel.add((Component)this.myCanvas, "Center");
        geoPanel.add((Component)ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)this.getToolbarActions(), false).getComponent(), "West");
        this.myLoading.getContentLayer().add((Component)geoPanel, "Center");
        this.myPanel.add((Component)this.myEmptyPanel, CARD_EMPTY);
        this.myPanel.add((Component)((Object)this.myLoading), CARD_GEOMETRY);
    }

    private DefaultActionGroup getToolbarActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ToggleAction("Y-Up", "Toggle Y-Up/Z-Up", AndroidIcons.GfxTrace.YUp){

            public boolean isSelected(AnActionEvent e) {
                return GeometryController.this.myZUp;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                GeometryController.this.myZUp = state;
                Presentation presentation = e.getPresentation();
                presentation.setIcon(GeometryController.this.myZUp ? AndroidIcons.GfxTrace.ZUp : AndroidIcons.GfxTrace.YUp);
                presentation.setText(GeometryController.this.myZUp ? "Z-Up" : "Y-Up");
                if (GeometryController.this.myGeometry != null) {
                    GeometryController.this.myGeometry.setZUp(GeometryController.this.myZUp);
                    GeometryController.this.updateViewer();
                }
            }
        });
        group.add((AnAction)new ToggleAction("Triangle Winding", "Toggle triangle winding", AndroidIcons.GfxTrace.WindingCCW){

            public boolean isSelected(AnActionEvent e) {
                return GeometryController.this.myViewer.getWinding() == Viewer.Winding.CW;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                GeometryController.this.myViewer.setWinding(state ? Viewer.Winding.CW : Viewer.Winding.CCW);
                Presentation presentation = e.getPresentation();
                presentation.setIcon(state ? AndroidIcons.GfxTrace.WindingCW : AndroidIcons.GfxTrace.WindingCCW);
                if (GeometryController.this.myGeometry != null) {
                    GeometryController.this.updateViewer();
                }
            }
        });
        group.add((AnAction)new Separator());
        group.add((AnAction)new DisplayModeAction("Shaded", "Display the goemetry with shading", AndroidIcons.GfxTrace.WireframeNone, Geometry.DisplayMode.TRIANGLES));
        group.add((AnAction)new DisplayModeAction("Wireframe", "Display the geometry with wireframes", AndroidIcons.GfxTrace.WireframeAll, Geometry.DisplayMode.LINES));
        group.add((AnAction)new DisplayModeAction("Point Cloud", "Display the geometry as a point cloud", AndroidIcons.GfxTrace.PointCloud, Geometry.DisplayMode.POINTS));
        group.add((AnAction)new Separator());
        group.add((AnAction)new NormalsAction("Original", "Original vertex normals", AndroidIcons.GfxTrace.Smooth, 0));
        group.add((AnAction)new NormalsAction("Faceted", "Per-face normals", AndroidIcons.GfxTrace.Faceted, 1));
        group.add((AnAction)new Separator());
        group.add((AnAction)new ToggleAction("Backface Culling", "Toggle culling of backfaces", AndroidIcons.GfxTrace.CullingDisabled){

            public boolean isSelected(AnActionEvent e) {
                return GeometryController.this.myViewer.getCulling() != Viewer.Culling.OFF;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                GeometryController.this.myViewer.setCulling(state ? Viewer.Culling.ON : Viewer.Culling.OFF);
                Presentation presentation = e.getPresentation();
                presentation.setIcon(state ? AndroidIcons.GfxTrace.CullingEnabled : AndroidIcons.GfxTrace.CullingDisabled);
                if (GeometryController.this.myGeometry != null) {
                    GeometryController.this.updateViewer();
                }
            }
        });
        group.add((AnAction)new Separator());
        group.add((AnAction)new ShadingAction("Lit", "Lit shading", AndroidIcons.GfxTrace.Lit, Viewer.Shading.LIT));
        group.add((AnAction)new ShadingAction("Flat", "Flat shading", AndroidIcons.GfxTrace.Flat, Viewer.Shading.FLAT));
        group.add((AnAction)new ShadingAction("Normals", "Show face normals", AndroidIcons.GfxTrace.Normals, Viewer.Shading.NORMALS));
        return group;
    }

    @Override
    public void onAtomLoadingStart(AtomStream atoms) {
    }

    @Override
    public void onAtomLoadingComplete(AtomStream atoms) {
    }

    @Override
    public void onAtomsSelected(AtomRangePath path) {
        CardLayout layout = (CardLayout)this.myPanel.getLayout();
        if (!this.myEditor.getFeatures().hasMeshes()) {
            this.myEmptyPanel.setEmptyText("Not supported in this version.");
        } else if (this.myEditor.getAtomStream().getLastSelectedAtom().isDrawCall()) {
            layout.show(this.myPanel, CARD_GEOMETRY);
            this.fetchMeshes(path.getPathToLast());
        } else {
            layout.show(this.myPanel, CARD_EMPTY);
        }
    }

    private void fetchMeshes(AtomPath path) {
        this.myLoading.startLoading();
        ListenableFuture<Model> originalFuture = this.fetchModel(path.mesh(null));
        ListenableFuture<Model> facetedFuture = this.fetchModel(path.mesh(new MeshPathOptions().setFaceted(true)));
        Rpc.listen((ListenableFuture)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{originalFuture, facetedFuture}), (Logger)LOG, (Rpc.Callback)new Rpc.Callback<List<Model>>(){

            public void onFinish(Rpc.Result<List<Model>> results) throws RpcException, ExecutionException {
                try {
                    List models = (List)results.get();
                    GeometryController.this.myOriginalModel = (Model)models.get(0);
                    GeometryController.this.myFacetedModel = (Model)models.get(1);
                    GeometryController.this.setModel(GeometryController.this.myOriginalModel != null ? GeometryController.this.myOriginalModel : GeometryController.this.myFacetedModel);
                }
                finally {
                    GeometryController.this.myLoading.stopLoading();
                }
            }
        });
    }

    private ListenableFuture<Model> fetchModel(MeshPath path) {
        ListenableFuture<Mesh> meshFuture = this.myEditor.getClient().get(path);
        return Futures.transform(meshFuture, (AsyncFunction)new AsyncFunction<Mesh, Model>(){

            public ListenableFuture<Model> apply(Mesh mesh) throws Exception {
                VertexBuffer vb = mesh.getVertexBuffer();
                ListenableFuture<VertexStreamData> positionsFuture = null;
                ListenableFuture<VertexStreamData> normalsFuture = null;
                for (VertexStream stream : vb.getStreams()) {
                    VertexProtos.SemanticType semantic = stream.getSemantic().getType();
                    if (positionsFuture == null && semantic == VertexProtos.SemanticType.Position) {
                        positionsFuture = GeometryController.this.myEditor.getClient().get(stream.getData(), FMT_XYZ_F32);
                        continue;
                    }
                    if (normalsFuture != null || semantic != VertexProtos.SemanticType.Normal) continue;
                    normalsFuture = GeometryController.this.myEditor.getClient().get(stream.getData(), FMT_XYZ_F32);
                }
                if (positionsFuture == null || normalsFuture == null) {
                    return Futures.immediateFuture(null);
                }
                final int[] indices = mesh.getIndexBuffer().getIndices();
                final GfxAPIProtos.DrawPrimitive primitive = mesh.getDrawPrimitive();
                return Futures.transform((ListenableFuture)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{positionsFuture, normalsFuture}), (Function)new Function<List<VertexStreamData>, Model>(){

                    public Model apply(List<VertexStreamData> inputs) {
                        float[] positions = (float[])inputs.get(0).getDataAndCast();
                        float[] normals = (float[])inputs.get(1).getDataAndCast();
                        return new Model(primitive, positions, normals, indices);
                    }
                });
            }
        });
    }

    private void setModel(Model model) {
        this.myGeometry.setModel(model);
        this.updateRenderable();
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
    }

    private void updateRenderable() {
        this.myViewer.setRenderable(this.myGeometry.asRenderable(this.myDisplayMode));
        this.updateViewer();
    }

    private void updateViewer() {
        this.myCamera.setEmitter(this.myGeometry.getEmitter());
        this.myPanel.repaint();
        this.myCanvas.display();
    }

    private class ShadingAction
    extends ToggleAction {
        private Viewer.Shading myTargetShading;

        public ShadingAction(@Nullable String text, @Nullable String description, Icon icon, Viewer.Shading targetShading) {
            super(text, description, icon);
            this.myTargetShading = targetShading;
        }

        public boolean isSelected(AnActionEvent e) {
            return GeometryController.this.myViewer.getShading() == this.myTargetShading;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            GeometryController.this.myViewer.setShading(this.myTargetShading);
            if (GeometryController.this.myGeometry != null) {
                GeometryController.this.updateViewer();
            }
        }
    }

    private class DisplayModeAction
    extends ToggleAction {
        private Geometry.DisplayMode myDisplayMode;

        public DisplayModeAction(@Nullable String text, @Nullable String description, Icon icon, Geometry.DisplayMode displayMode) {
            super(text, description, icon);
            this.myDisplayMode = displayMode;
        }

        public boolean isSelected(AnActionEvent e) {
            return GeometryController.this.myDisplayMode == this.myDisplayMode;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            GeometryController.this.myDisplayMode = this.myDisplayMode;
            GeometryController.this.updateRenderable();
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(GeometryController.this.myGeometry != null);
        }
    }

    private class NormalsAction
    extends ToggleAction {
        private static final int ORIGINAL = 0;
        private static final int FACETED = 1;
        private int myTargetMode;

        public NormalsAction(@Nullable String text, @Nullable String description, Icon icon, int targetMode) {
            super(text, description, icon);
            this.myTargetMode = targetMode;
        }

        public boolean isSelected(AnActionEvent e) {
            Model model = GeometryController.this.myGeometry.getModel();
            return model != null && model == this.getModel();
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(this.getModel() != null);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            GeometryController.this.setModel(this.getModel());
        }

        private Model getModel() {
            switch (this.myTargetMode) {
                case 0: {
                    return GeometryController.this.myOriginalModel;
                }
                case 1: {
                    return GeometryController.this.myFacetedModel;
                }
            }
            return null;
        }
    }

    private static class EmptyPanel
    extends JComponent {
        private final StatusText myEmptyText = new StatusText(){

            protected boolean isStatusVisible() {
                return true;
            }
        };

        public EmptyPanel() {
            this.myEmptyText.setText("Select a draw call");
            this.myEmptyText.attachTo((Component)this);
        }

        public void setEmptyText(String text) {
            this.myEmptyText.setText(text);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.myEmptyText.paint((Component)this, graphics);
        }
    }
}

