/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceUtil;
import com.android.tools.idea.editors.gfxtrace.UiErrorCallback;
import com.android.tools.idea.editors.gfxtrace.actions.EditAtomParametersAction;
import com.android.tools.idea.editors.gfxtrace.controllers.TreeController;
import com.android.tools.idea.editors.gfxtrace.models.AtomStream;
import com.android.tools.idea.editors.gfxtrace.renderers.Render;
import com.android.tools.idea.editors.gfxtrace.service.Context;
import com.android.tools.idea.editors.gfxtrace.service.ContextID;
import com.android.tools.idea.editors.gfxtrace.service.Hierarchy;
import com.android.tools.idea.editors.gfxtrace.service.RenderSettings;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.ServiceProtos;
import com.android.tools.idea.editors.gfxtrace.service.atom.Atom;
import com.android.tools.idea.editors.gfxtrace.service.atom.AtomGroup;
import com.android.tools.idea.editors.gfxtrace.service.atom.Observation;
import com.android.tools.idea.editors.gfxtrace.service.atom.Range;
import com.android.tools.idea.editors.gfxtrace.service.image.FetchedImage;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomRangePath;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomsPath;
import com.android.tools.idea.editors.gfxtrace.service.path.ContextPath;
import com.android.tools.idea.editors.gfxtrace.service.path.DevicePath;
import com.android.tools.idea.editors.gfxtrace.service.path.FieldPath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.android.tools.idea.editors.gfxtrace.widgets.LoadableIcon;
import com.android.tools.idea.logcat.RegexFilterComponent;
import com.android.tools.rpclib.rpccore.Rpc;
import com.android.tools.rpclib.rpccore.RpcException;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AtomController
extends TreeController
implements AtomStream.Listener {
    @NotNull
    private static final Logger LOG = Logger.getInstance(GfxTraceEditor.class);
    private final PathStore<DevicePath> myRenderDevice = new PathStore();
    @NotNull
    private RegexFilterComponent mySearchField = new RegexFilterComponent(AtomController.class.getName(), 10);
    @NotNull
    private Map<ContextID, Hierarchy> mySelectedHierarchies = Maps.newHashMap();
    @NotNull
    private Context mySelectedContext = Context.ALL;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new AtomController((GfxTraceEditor)editor).myPanel;
    }

    private AtomController(@NotNull GfxTraceEditor editor) {
        super(editor, "Loading capture...");
        this.myEditor.getAtomStream().addListener(this);
        this.myPanel.add((Component)((Object)this.mySearchField), "North");
        this.myScrollPane.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        this.myTree.setLargeModel(true);
        this.myTree.addTreeSelectionListener(treeSelectionEvent -> {
            if (treeSelectionEvent.isAddedPath()) {
                AtomStream atoms = this.myEditor.getAtomStream();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.myTree.getLastSelectedPathComponent();
                if (node == null || node.getUserObject() == null) {
                    return;
                }
                Object object = node.getUserObject();
                GfxTraceUtil.trackEvent("gfxTraceCommandSelected", object.getClass().getSimpleName(), null);
                if (object instanceof Group) {
                    atoms.selectAtoms(((Group)object).group.getRange(), this);
                } else if (object instanceof Node) {
                    atoms.selectAtoms(((Node)object).index, 1L, this);
                } else if (object instanceof Memory) {
                    Memory memory = (Memory)object;
                    this.myEditor.activatePath(atoms.getPath().index(memory.index).memoryAfter(0, memory.observation.getRange()), this);
                }
            }
        });
        this.mySearchField.getTextEditor().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    AtomController.this.findNextNode(AtomController.this.mySearchField.getPattern());
                }
            }
        });
        MouseAdapter mouseHandler = new MouseAdapter(){
            private static final int PREVIEW_HOVER_DELAY_MS = 500;
            private final ScheduledExecutorService scheduler = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"PreviewHover");
            private Group lastHoverGroup;
            private Node lastHoverNode;
            private Future<?> lastScheduledFuture = Futures.immediateFuture(null);
            private Balloon lastShownBalloon;
            private JPopupMenu popupMenu = new JPopupMenu();

            @Override
            public void mouseEntered(MouseEvent event) {
                this.updateHovering(event.getX(), event.getY());
            }

            @Override
            public void mouseExited(MouseEvent event) {
                this.clearHovering();
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                this.updateHovering(event.getX(), event.getY());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                EditAtomParametersAction editAction;
                DefaultMutableTreeNode treeNode;
                Object userObject;
                TreePath path;
                if (e.isPopupTrigger() && (path = AtomController.this.myTree.getPathForLocation(e.getX(), e.getY())) != null && (userObject = (treeNode = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof Node && (editAction = EditAtomParametersAction.getEditActionFor((Node)userObject, AtomController.this.myEditor)) != null) {
                    this.popupMenu.removeAll();
                    this.popupMenu.add(editAction);
                    this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent event) {
                this.clearHovering();
                JBScrollPane ancestor = (JBScrollPane)SwingUtilities.getAncestorOfClass(JBScrollPane.class, (Component)((Object)AtomController.this.myTree));
                if (ancestor != null) {
                    MouseWheelEvent converted = (MouseWheelEvent)SwingUtilities.convertMouseEvent((Component)((Object)AtomController.this.myTree), event, (Component)ancestor);
                    for (MouseWheelListener listener : ancestor.getMouseWheelListeners()) {
                        listener.mouseWheelMoved(converted);
                    }
                }
                Point location = new Point(MouseInfo.getPointerInfo().getLocation());
                SwingUtilities.convertPointFromScreen(location, (Component)((Object)AtomController.this.myTree));
                this.updateHovering(location.x, location.y);
            }

            private void updateHovering(int mouseX, int mouseY) {
                Rectangle bounds;
                TreePath path = AtomController.this.myTree.getClosestPathForLocation(mouseX, mouseY);
                if (path != null && (bounds = AtomController.this.myTree.getPathBounds(path)) != null) {
                    int x = mouseX - bounds.x;
                    int y = mouseY - bounds.y;
                    if (x >= 0 && x < bounds.width && y >= 0 && y < bounds.height) {
                        this.updateHovering((DefaultMutableTreeNode)path.getLastPathComponent(), bounds, x, y);
                        return;
                    }
                }
                this.clearHovering();
            }

            private void updateHovering(@NotNull DefaultMutableTreeNode node, @NotNull Rectangle bounds, int x, int y) {
                Object userObject = node.getUserObject();
                TreeController.hoverHand((Component)((Object)AtomController.this.myTree), AtomController.this.myEditor.getAtomStream().getPath(), null);
                if (userObject instanceof Group && AtomController.shouldShowPreview((Group)userObject) && x < Group.THUMBNAIL_SIZE && y < Group.THUMBNAIL_SIZE) {
                    this.setHoveringGroup((Group)userObject, bounds.x + Group.THUMBNAIL_SIZE, bounds.y + Group.THUMBNAIL_SIZE / 2);
                    this.setHoveringNode(null, 0);
                } else {
                    this.setHoveringGroup(null, 0, 0);
                    int index = -1;
                    if (userObject instanceof Node) {
                        index = Render.getNodeFieldIndex((JTree)((Object)AtomController.this.myTree), node, x, false);
                    }
                    if (index >= 0) {
                        this.setHoveringNode((Node)userObject, index);
                    } else {
                        this.setHoveringNode(null, 0);
                    }
                }
            }

            private void clearHovering() {
                this.setHoveringGroup(null, 0, 0);
                this.setHoveringNode(null, 0);
            }

            private synchronized void setHoveringGroup(final @Nullable Group group, final int x, final int y) {
                if (group != this.lastHoverGroup) {
                    this.lastScheduledFuture.cancel(true);
                    this.lastHoverGroup = group;
                    if (group != null) {
                        this.lastScheduledFuture = this.scheduler.schedule(new Runnable(){

                            @Override
                            public void run() {
                                this.hover(group, x, y);
                            }
                        }, 500L, TimeUnit.MILLISECONDS);
                    }
                }
                if (group == null && this.lastShownBalloon != null) {
                    this.lastShownBalloon.hide();
                    this.lastShownBalloon = null;
                }
            }

            private void setHoveringNode(@Nullable Node node, int index) {
                if (node != this.lastHoverNode && this.lastHoverNode != null) {
                    this.lastHoverNode.hoveredParameter = -1;
                }
                this.lastHoverNode = node;
                Path followPath = Path.EMPTY;
                if (node != null) {
                    node.computeFollowPath(AtomController.this.myEditor.getClient(), AtomController.this.myEditor.getAtomStream().getPath(), index, new Runnable(){

                        @Override
                        public void run() {
                            AtomController.this.myTree.repaint();
                        }
                    });
                    followPath = node.getFollowPath(index);
                }
                if (followPath != Path.EMPTY) {
                    node.hoveredParameter = index;
                }
                TreeController.hoverHand((Component)((Object)AtomController.this.myTree), AtomController.this.myEditor.getAtomStream().getPath(), followPath);
                AtomController.this.myTree.repaint();
            }

            private void hover(final Group group, final int x, final int y) {
                final 2 lock = this;
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = lock;
                        synchronized (object) {
                            if (group == lastHoverGroup) {
                                if (lastShownBalloon != null) {
                                    lastShownBalloon.hide();
                                }
                                DevicePath device = (DevicePath)AtomController.this.myRenderDevice.getPath();
                                AtomsPath atoms = AtomController.this.myEditor.getAtomStream().getPath();
                                if (device != null && atoms != null) {
                                    lastShownBalloon = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)group.getPreview(AtomController.this.myEditor.getClient(), device, atoms)).setAnimationCycle(100).createBalloon();
                                    lastShownBalloon.show(new RelativePoint((Component)((Object)AtomController.this.myTree), new Point(x, y)), Balloon.Position.atRight);
                                }
                            }
                        }
                    }
                });
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                Object object = AtomController.this.getDataObjectAt(AtomController.this.myTree.getPathForLocation(event.getX(), event.getY()));
                if (object instanceof Node) {
                    Node node = (Node)object;
                    if (node.hoveredParameter >= 0) {
                        Path path = node.getFollowPath(node.hoveredParameter);
                        GfxTraceUtil.trackEvent("gfxTraceLinkClicked", path.toString(), null);
                        AtomController.this.myEditor.activatePath(path, AtomController.this);
                    }
                }
            }
        };
        this.myTree.addMouseListener(mouseHandler);
        this.myTree.addMouseMotionListener(mouseHandler);
        this.myTree.addMouseWheelListener(mouseHandler);
    }

    @Override
    @NotNull
    protected TreeCellRenderer getRenderer() {
        return new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Group group;
                if (value instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
                    Object obj = treeNode.getUserObject();
                    if (obj instanceof Renderable) {
                        Renderable renderable = (Renderable)obj;
                        renderable.render((SimpleColoredComponent)this, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else assert (false);
                } else assert (false);
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                DevicePath device = (DevicePath)AtomController.this.myRenderDevice.getPath();
                AtomsPath atoms = AtomController.this.myEditor.getAtomStream().getPath();
                if (userObject instanceof Group && device != null && atoms != null && AtomController.shouldShowPreview(group = (Group)userObject)) {
                    this.setIcon(group.getThumbnail(AtomController.this.myEditor.getClient(), device, atoms).withRepaintComponent(tree));
                }
            }
        };
    }

    @Override
    @NotNull
    public String[] getColumns(TreePath path) {
        Object object = this.getDataObjectAt(path);
        if (object instanceof Group) {
            AtomGroup group = ((Group)object).group;
            Range range = group.getRange();
            return new String[]{group.getName(), "(" + range.getStart() + " - " + range.getLast() + ")"};
        }
        if (object instanceof Node) {
            Node node = (Node)object;
            SimpleColoredComponent component = new SimpleColoredComponent();
            Render.render(node.atom, component, node.hoveredParameter);
            return new String[]{node.index + ":", component.toString()};
        }
        return new String[]{object.toString()};
    }

    @Nullable
    private Object getDataObjectAt(@Nullable TreePath path) {
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        return treeNode.getUserObject();
    }

    private void findNextNode(Pattern pattern) {
        DefaultMutableTreeNode change;
        DefaultMutableTreeNode start = (DefaultMutableTreeNode)this.myTree.getLastSelectedPathComponent();
        if (start == null) {
            start = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        }
        if ((change = this.findMatchingChild(start, pattern)) == null) {
            for (DefaultMutableTreeNode node = start; change == null && node != null; node = (DefaultMutableTreeNode)node.getParent()) {
                change = this.findMatchingSibling(node, pattern);
            }
        }
        if (change == null && start != this.myTree.getModel().getRoot()) {
            change = this.findMatchingChild((DefaultMutableTreeNode)this.myTree.getModel().getRoot(), pattern);
        }
        if (change != null) {
            this.myTree.setSelectionPath(new TreePath(change.getPath()));
        }
    }

    private DefaultMutableTreeNode findMatchingChild(DefaultMutableTreeNode node, Pattern pattern) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (this.matches(child, pattern)) {
                return child;
            }
            DefaultMutableTreeNode result = this.findMatchingChild(child, pattern);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private DefaultMutableTreeNode findMatchingSibling(DefaultMutableTreeNode node, Pattern pattern) {
        for (DefaultMutableTreeNode sibling = node.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (this.matches(sibling, pattern)) {
                return sibling;
            }
            DefaultMutableTreeNode result = this.findMatchingChild(sibling, pattern);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private boolean matches(DefaultMutableTreeNode child, Pattern pattern) {
        Object node = child.getUserObject();
        if (node instanceof Node) {
            return pattern.matcher(((Node)node).atom.getName()).find();
        }
        return false;
    }

    private static boolean shouldShowPreview(Group group) {
        return group.lastLeaf.isEndOfFrame() || group.lastLeaf.isDrawCall();
    }

    private void updateTree(AtomStream atoms) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Stream", true);
        Hierarchy hierarchy = this.mySelectedHierarchies.get(this.mySelectedContext);
        if (hierarchy == null) {
            hierarchy = atoms.getHierarchies().firstWithContext(this.mySelectedContext.getID());
            this.mySelectedHierarchies.put(this.mySelectedContext.getID(), hierarchy);
        }
        hierarchy.getRoot().addChildren(root, atoms.getAtoms(), atoms.getContexts().count() > 1 ? this.mySelectedContext : Context.ALL);
        Enumeration treeState = this.myTree.getExpandedDescendants(new TreePath(this.myTree.getModel().getRoot()));
        this.setRoot(root);
        if (treeState != null) {
            while (treeState.hasMoreElements()) {
                this.myTree.expandPath(AtomController.getTreePathInTree((TreePath)treeState.nextElement(), (JTree)((Object)this.myTree)));
            }
        }
    }

    private void selectContext(@NotNull ContextID id) {
        AtomStream atoms = this.myEditor.getAtomStream();
        Context context = atoms.getContexts().find(id, Context.ALL);
        if (!context.equals(this.mySelectedContext)) {
            this.mySelectedContext = context;
            this.updateTree(atoms);
        }
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
        ContextPath contextPath = event.findContextPath();
        if (contextPath != null) {
            this.selectContext(contextPath.getID());
        }
        if (this.myRenderDevice.updateIfNotNull(event.findDevicePath())) {
            this.myTree.repaint();
        }
    }

    @Override
    public void onAtomLoadingStart(AtomStream atoms) {
        this.myTree.getEmptyText().setText("");
        this.myLoadingPanel.startLoading();
    }

    @Override
    public void onAtomLoadingComplete(AtomStream atoms) {
        if (atoms.isLoaded()) {
            this.myLoadingPanel.stopLoading();
            Maps.transformValues(this.mySelectedHierarchies, hierarchy -> atoms.getHierarchies().findSimilar((Hierarchy)hierarchy));
            this.updateTree(atoms);
        } else {
            this.myLoadingPanel.showLoadingError("Failed to load GPU commands");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable(value="if this path can not be found in this tree")
    public static TreePath getTreePathInTree(TreePath treePath, JTree tree) {
        Object root = tree.getModel().getRoot();
        Object[] path = treePath.getPath();
        ArrayList<Object> newPath = new ArrayList<Object>();
        Object found = null;
        for (Object node : path) {
            if (found == null) {
                if (!AtomController.treeNodeEquals(root, node)) return null;
                found = root;
            } else {
                Object foundChild = null;
                for (int i = 0; i < tree.getModel().getChildCount(found); ++i) {
                    Object child = tree.getModel().getChild(found, i);
                    if (!AtomController.treeNodeEquals(node, child)) continue;
                    foundChild = child;
                    break;
                }
                if (foundChild == null) {
                    return null;
                }
                found = foundChild;
            }
            newPath.add(found);
        }
        return new TreePath(newPath.toArray());
    }

    public static boolean treeNodeEquals(Object a, Object b) {
        if (a instanceof DefaultMutableTreeNode && b instanceof DefaultMutableTreeNode) {
            return Objects.equal((Object)((DefaultMutableTreeNode)a).getUserObject(), (Object)((DefaultMutableTreeNode)b).getUserObject());
        }
        return Objects.equal((Object)a, (Object)b);
    }

    @Override
    public void onAtomsSelected(AtomRangePath path) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        this.updateSelectionRange(root, new TreePath(root), path.getRange());
    }

    private void updateSelectionRange(DefaultMutableTreeNode node, TreePath path, Range range) {
        if (node.isLeaf()) {
            this.updateSelection(path);
            return;
        }
        Enumeration<TreeNode> it = node.children();
        while (it.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)it.nextElement();
            Object object = child.getUserObject();
            if (object instanceof Node && range.getLast() == ((Node)object).index) {
                this.updateSelection(path.pathByAddingChild(child));
                return;
            }
            if (!(object instanceof Group)) continue;
            Range groupRange = ((Group)object).group.getRange();
            if (groupRange.equals(range)) {
                this.updateSelection(path.pathByAddingChild(child));
                return;
            }
            if (!groupRange.contains(range.getLast())) continue;
            this.updateSelectionRange(child, path.pathByAddingChild(child), range);
            return;
        }
    }

    private void updateSelection(TreePath path) {
        this.myTree.expandPath(path.getParentPath());
        this.myTree.setSelectionPath(path, false);
        Rectangle bounds = this.myTree.getPathBounds(path);
        if (bounds != null) {
            bounds.width += bounds.x;
            bounds.x = 0;
            this.myTree.scrollRectToVisible(bounds);
        }
    }

    public static class Memory
    implements Renderable {
        public final long index;
        public final Observation observation;
        public final boolean isRead;

        public Memory(long index, Observation observation, boolean isRead) {
            this.index = index;
            this.observation = observation;
            this.isRead = isRead;
        }

        @Override
        public void render(@NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
            Render.render(this, component, attributes);
        }
    }

    public static class Group
    implements Renderable {
        public static final int THUMBNAIL_SIZE = JBUI.scale((int)18);
        public static final int PREVIEW_SIZE = JBUI.scale((int)200);
        private static final RenderSettings THUMBNAIL_SETTINGS = new RenderSettings().setMaxWidth(PREVIEW_SIZE).setMaxHeight(PREVIEW_SIZE).setWireframeMode(ServiceProtos.WireframeMode.None);
        public final AtomGroup group;
        public final Atom lastLeaf;
        public final long indexOfLastLeaf;
        private ListenableFuture<BufferedImage> previewFuture;
        private LoadableIcon thumbnail;
        private LoadableIcon preview;
        private DevicePath lastDevicePath;

        public Group(AtomGroup group, Atom lastLeaf, long indexOfLastLeaf) {
            this.group = group;
            this.lastLeaf = lastLeaf;
            this.indexOfLastLeaf = indexOfLastLeaf;
        }

        public LoadableIcon getThumbnail(ServiceClient client, @NotNull DevicePath devicePath, @NotNull AtomsPath atomsPath) {
            this.updateIcons(client, devicePath, atomsPath);
            return this.thumbnail;
        }

        public LoadableIcon getPreview(ServiceClient client, @NotNull DevicePath devicePath, @NotNull AtomsPath atomsPath) {
            this.updateIcons(client, devicePath, atomsPath);
            return this.preview;
        }

        private void updateIcons(ServiceClient client, @NotNull DevicePath devicePath, @NotNull AtomsPath atomsPath) {
            if (this.previewFuture == null || !Objects.equal((Object)this.lastDevicePath, (Object)devicePath)) {
                this.lastDevicePath = devicePath;
                this.previewFuture = FetchedImage.loadLevel(FetchedImage.load(client, client.getFramebufferColor(devicePath, new AtomPath().setAtoms(atomsPath).setIndex(this.indexOfLastLeaf), THUMBNAIL_SETTINGS)), 0);
                this.thumbnail = new LoadableIcon(THUMBNAIL_SIZE, THUMBNAIL_SIZE);
                this.preview = new LoadableIcon(PREVIEW_SIZE, PREVIEW_SIZE);
                Rpc.listen(this.previewFuture, (Logger)LOG, (Rpc.Callback)new UiErrorCallback<BufferedImage, BufferedImage, Void>(){

                    @Override
                    protected UiErrorCallback.ResultOrError<BufferedImage, Void> onRpcThread(Rpc.Result<BufferedImage> result) {
                        try {
                            return this.success(result.get());
                        }
                        catch (RpcException | ExecutionException e) {
                            LOG.warn("Failed to load image", e);
                            return this.error(null);
                        }
                    }

                    @Override
                    protected void onUiThreadSuccess(BufferedImage result) {
                        thumbnail.withImage(result, false);
                        preview.withImage(result, false);
                    }

                    @Override
                    protected void onUiThreadError(Void error) {
                        thumbnail.withImage(null, true);
                        preview.withImage(null, true);
                    }
                });
            }
        }

        @Override
        public void render(@NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
            Render.render(this, component, attributes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group group1 = (Group)o;
            if (this.indexOfLastLeaf != group1.indexOfLastLeaf) {
                return false;
            }
            return !(this.group != null ? !this.group.equals(group1.group) : group1.group != null);
        }

        public int hashCode() {
            int result = this.group != null ? this.group.hashCode() : 0;
            result = 31 * result + (int)(this.indexOfLastLeaf ^ this.indexOfLastLeaf >>> 32);
            return result;
        }

        public String toString() {
            return "Group{group=" + this.group + ", indexOfLastLeaf=" + this.indexOfLastLeaf + '}';
        }
    }

    public static class Node
    implements Renderable {
        public final long index;
        public final Atom atom;
        public int hoveredParameter = -1;
        private final Path[] followPaths;

        public Node(long index, Atom atom) {
            this.index = index;
            this.atom = atom;
            this.followPaths = new Path[atom.getFieldCount()];
            if (atom.getExtrasIndex() >= 0) {
                this.followPaths[atom.getExtrasIndex()] = Path.EMPTY;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Path getFollowPath(int parameter) {
            Path[] pathArray = this.followPaths;
            synchronized (this.followPaths) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return parameter >= 0 && parameter < this.followPaths.length && this.followPaths[parameter] != null ? this.followPaths[parameter] : Path.EMPTY;
            }
        }

        @NotNull
        public FieldPath getFieldPath(@NotNull AtomsPath atomsPath, int fieldIndex) {
            return atomsPath.index(this.index).field(this.atom.getFieldInfo(fieldIndex).getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void computeFollowPath(@NotNull ServiceClient client, @NotNull AtomsPath atomsPath, final int parameter, final Runnable onUpdate) {
            Path[] pathArray = this.followPaths;
            synchronized (this.followPaths) {
                if (parameter >= 0 && parameter < this.followPaths.length && this.followPaths[parameter] == null) {
                    this.followPaths[parameter] = Path.EMPTY;
                    FieldPath path = this.getFieldPath(atomsPath, parameter);
                    Futures.addCallback(client.follow(path), (FutureCallback)new FutureCallback<Path>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onSuccess(Path result) {
                            Path[] pathArray = followPaths;
                            synchronized (pathArray) {
                                ((Node)this).followPaths[parameter] = result;
                            }
                            if (onUpdate != null) {
                                onUpdate.run();
                            }
                        }

                        public void onFailure(Throwable t) {
                        }
                    });
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void render(@NotNull SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes) {
            Render.render(this, component, attributes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            if (this.index != node.index) {
                return false;
            }
            return !(this.atom != null ? !this.atom.equals(node.atom) : node.atom != null);
        }

        public int hashCode() {
            int result = (int)(this.index ^ this.index >>> 32);
            result = 31 * result + (this.atom != null ? this.atom.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Node{atom=" + this.atom + ", index=" + this.index + '}';
        }
    }

    private static interface Renderable {
        public void render(@NotNull SimpleColoredComponent var1, @NotNull SimpleTextAttributes var2);
    }
}

