/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.actions;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceUtil;
import com.android.tools.idea.editors.gfxtrace.UiCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.AtomController;
import com.android.tools.idea.editors.gfxtrace.renderers.Render;
import com.android.tools.idea.editors.gfxtrace.renderers.RenderUtils;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.snippets.Labels;
import com.android.tools.idea.editors.gfxtrace.service.snippets.SnippetObject;
import com.android.tools.rpclib.rpccore.Rpc;
import com.android.tools.rpclib.rpccore.RpcException;
import com.android.tools.rpclib.schema.Constant;
import com.android.tools.rpclib.schema.ConstantSet;
import com.android.tools.rpclib.schema.Dynamic;
import com.android.tools.rpclib.schema.Method;
import com.android.tools.rpclib.schema.Primitive;
import com.android.tools.rpclib.schema.Type;
import com.android.tools.swing.util.FloatFilter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.AbstractDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditAtomParametersAction
extends AbstractAction {
    @NotNull
    private static final Logger LOG = Logger.getInstance(EditAtomParametersAction.class);
    @NotNull
    private Editor[] myEditors;
    @NotNull
    private GfxTraceEditor myGfxTraceEditor;
    @NotNull
    private AtomController.Node myNode;

    private EditAtomParametersAction(@NotNull GfxTraceEditor traceEditor, @NotNull AtomController.Node node, @NotNull Editor[] editors) {
        super("Edit");
        this.myEditors = editors;
        this.myGfxTraceEditor = traceEditor;
        this.myNode = node;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent parent = this.myGfxTraceEditor.getComponent();
        final String title = "Edit " + this.myNode.atom.getName();
        int result = JOptionPane.showOptionDialog(parent, this.buildDialog(), title, 2, -1, null, null, null);
        if (result == 0) {
            Dynamic newAtom = ((Dynamic)this.myNode.atom.unwrap()).copy();
            for (Editor editor : this.myEditors) {
                if (!editor.hasEditComponent()) continue;
                newAtom.setFieldValue(editor.myFieldIndex, editor.getValue());
            }
            final AtomPath oldPath = this.myGfxTraceEditor.getAtomStream().getPath().index(this.myNode.index);
            GfxTraceUtil.trackEvent("gfxTraceParameterEdited", oldPath.toString(), null);
            Rpc.listen(this.myGfxTraceEditor.getClient().set(oldPath, newAtom), (Logger)LOG, (Rpc.Callback)new UiCallback<Path, Path>(){

                @Override
                protected Path onRpcThread(Rpc.Result<Path> result) throws RpcException, ExecutionException {
                    return (Path)result.get();
                }

                @Override
                protected void onUiThread(Path newPath) {
                    new ActivatePathCommand(title, oldPath, newPath).execute();
                }
            });
        }
    }

    @NotNull
    private JComponent buildDialog() {
        JPanel fields = new JPanel(new GridBagLayout());
        GridBag bag = new GridBag().setDefaultAnchor(13).setDefaultFill(2).setDefaultWeightX(1, 1.0).setDefaultPaddingX(5);
        for (Editor editor : this.myEditors) {
            String typeString = editor.myType instanceof Primitive ? " (" + ((Primitive)editor.myType).getMethod() + ")" : "";
            fields.add((Component)new JBLabel(this.myNode.atom.getFieldInfo(editor.myFieldIndex).getName() + typeString), bag.nextLine().next());
            fields.add((Component)editor.getComponent(), bag.next());
        }
        return fields;
    }

    @Nullable
    public static EditAtomParametersAction getEditActionFor(@NotNull AtomController.Node node, @NotNull GfxTraceEditor traceEditor) {
        ArrayList editors = Lists.newArrayList();
        int resultIndex = node.atom.getResultIndex();
        int extrasIndex = node.atom.getExtrasIndex();
        boolean found = false;
        for (int i = 0; i < node.atom.getFieldCount(); ++i) {
            if (i == resultIndex || i == extrasIndex) continue;
            SnippetObject snippetObject = SnippetObject.param(node.atom, i);
            Object value = node.atom.getFieldValue(i);
            Editor editor = Editor.getFor(node.atom.getFieldInfo(i).getType(), value, snippetObject, i);
            editors.add(editor);
            found |= editor.hasEditComponent();
        }
        return found ? new EditAtomParametersAction(traceEditor, node, editors.toArray(new Editor[editors.size()])) : null;
    }

    private static class FlagEditor
    extends Editor {
        private final CheckBoxList<Constant> myFlagList = new CheckBoxList();

        FlagEditor(@NotNull SnippetObject currentValue, @NotNull Type type, int fieldIndex, @NotNull List<Constant> constants, @NotNull Collection<Constant> constant) {
            super(currentValue, type, fieldIndex);
            this.myFlagList.setItems(constants, null);
            for (Constant con : constant) {
                this.myFlagList.setItemSelected((Object)con, true);
            }
        }

        @NotNull
        CheckBoxList<Constant> getComponent() {
            return this.myFlagList;
        }

        @Override
        @Nullable
        Number getValue() {
            long result = 0L;
            for (int c = 0; c < this.myFlagList.getItemsCount(); ++c) {
                if (!this.myFlagList.isItemSelected(c)) continue;
                Constant flag = (Constant)this.myFlagList.getItemAt(c);
                assert (flag != null);
                result |= ((Number)flag.getValue()).longValue();
            }
            return result;
        }
    }

    private static class EnumEditor
    extends Editor {
        private final JComboBox<Constant> myCombo;

        EnumEditor(@NotNull SnippetObject currentValue, @NotNull Type type, int fieldIndex, @NotNull List<Constant> constants, @NotNull Constant constant) {
            super(currentValue, type, fieldIndex);
            this.myCombo = new ComboBox(new DefaultComboBoxModel<Constant>(new Vector<Constant>(constants)));
            this.myCombo.setSelectedItem(constant);
        }

        @Override
        @NotNull
        JComboBox<Constant> getComponent() {
            return this.myCombo;
        }

        @Override
        @Nullable
        Object getValue() {
            Constant value = (Constant)this.myCombo.getSelectedItem();
            return value.getValue();
        }
    }

    private static class StringEditor
    extends Editor {
        private final JTextField textField;

        StringEditor(@NotNull SnippetObject currentValue, @NotNull Type type, int fieldIndex, @Nullable Object value) {
            super(currentValue, type, fieldIndex);
            this.textField = new JTextField(String.valueOf(value));
        }

        @Override
        @NotNull
        JTextField getComponent() {
            return this.textField;
        }

        @Override
        @Nullable
        String getValue() {
            return this.textField.getText();
        }
    }

    private static class FloatEditor
    extends Editor {
        private final JTextField myFloatBox;

        FloatEditor(@NotNull SnippetObject currentValue, @NotNull Type type, int fieldIndex, @NotNull Object value) {
            super(currentValue, type, fieldIndex);
            this.myFloatBox = new JTextField(String.valueOf(value));
            ((AbstractDocument)this.myFloatBox.getDocument()).setDocumentFilter(new FloatFilter());
        }

        @Override
        @NotNull
        JTextField getComponent() {
            return this.myFloatBox;
        }

        @Override
        @Nullable
        Number getValue() {
            String text = this.myFloatBox.getText();
            return Double.parseDouble(text);
        }
    }

    private static class IntEditor
    extends Editor {
        private final JSpinner mySpinner;

        IntEditor(@NotNull SnippetObject currentValue, @NotNull Type type, int fieldIndex, @NotNull Object value) {
            super(currentValue, type, fieldIndex);
            Method method = ((Primitive)type).getMethod();
            if (method == Method.Uint8 || method == Method.Uint16 || method == Method.Uint32 || method == Method.Uint64) {
                Number javaValue = RenderUtils.toJavaIntType(method, (Number)value);
                Comparable<? extends Number> zero = IntEditor.getZero(javaValue.getClass());
                Comparable<? extends Number> max = IntEditor.getUnsignedMax(method);
                this.mySpinner = new JSpinner(new SpinnerNumberModel(javaValue, zero, max, (Number)1));
            } else {
                this.mySpinner = new JSpinner();
                this.mySpinner.setValue(value);
            }
        }

        @Override
        @NotNull
        JSpinner getComponent() {
            return this.mySpinner;
        }

        @Override
        @Nullable
        Object getValue() {
            return this.mySpinner.getValue();
        }

        @NotNull
        private static Comparable<? extends Number> getZero(@NotNull Class<? extends Number> numberClass) {
            if (numberClass == Byte.class) {
                return (byte)0;
            }
            if (numberClass == Short.class) {
                return (short)0;
            }
            if (numberClass == Integer.class) {
                return 0;
            }
            if (numberClass == Long.class) {
                return 0L;
            }
            if (numberClass == BigInteger.class) {
                return BigInteger.ZERO;
            }
            throw new IllegalArgumentException("unknown number class " + numberClass);
        }

        @NotNull
        private static Comparable<? extends Number> getUnsignedMax(@NotNull Method type) {
            if (type == Method.Uint8) {
                return (short)255;
            }
            if (type == Method.Uint16) {
                return 65535;
            }
            if (type == Method.Uint32) {
                return 0xFFFFFFFFL;
            }
            if (type == Method.Uint64) {
                return new BigInteger("18446744073709551615");
            }
            throw new IllegalArgumentException("not unsigned type" + type);
        }
    }

    private static class BooleanEditor
    extends Editor {
        private final JCheckBox myCheckBox = new JCheckBox();

        BooleanEditor(@NotNull SnippetObject currentValue, @NotNull Type type, int fieldIndex, @Nullable Object value) {
            super(currentValue, type, fieldIndex);
            this.myCheckBox.setSelected(Boolean.parseBoolean(String.valueOf(value)));
        }

        @Override
        @NotNull
        JCheckBox getComponent() {
            return this.myCheckBox;
        }

        @Override
        @Nullable
        Boolean getValue() {
            return this.myCheckBox.isSelected();
        }
    }

    private static class NoEditor
    extends Editor {
        NoEditor(@NotNull SnippetObject currentValue, @NotNull Type type, int fieldIndex) {
            super(currentValue, type, fieldIndex);
        }

        @Override
        public boolean hasEditComponent() {
            return false;
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            SimpleColoredComponent result = new SimpleColoredComponent();
            Render.render(this.myCurrentValue, this.myType, result, SimpleTextAttributes.REGULAR_ATTRIBUTES, -1);
            return result;
        }

        @Override
        Object getValue() {
            throw new IllegalStateException();
        }
    }

    private static abstract class Editor {
        public final SnippetObject myCurrentValue;
        public final Type myType;
        public final int myFieldIndex;

        Editor(@NotNull SnippetObject currentValue, @NotNull Type type, int fieldIndex) {
            this.myCurrentValue = currentValue;
            this.myType = type;
            this.myFieldIndex = fieldIndex;
        }

        @NotNull
        public static Editor getFor(@NotNull Type type, @Nullable Object value, @NotNull SnippetObject snippetObject, int fieldIndex) {
            if (type instanceof Primitive) {
                Primitive primitive = (Primitive)type;
                Collection<Constant> constant = Render.findConstant(snippetObject, primitive);
                if (constant.size() >= 1) {
                    List<Constant> preferred;
                    List<Constant> constants = Arrays.asList(ConstantSet.lookup((Type)type).getEntries());
                    Labels labels = Labels.fromSnippets(snippetObject.getSnippets());
                    if (labels != null && (preferred = labels.preferred(constants)).containsAll(constant)) {
                        constants = preferred;
                    }
                    if (constant.size() == 1) {
                        return new EnumEditor(snippetObject, type, fieldIndex, constants, (Constant)Iterables.get(constant, (int)0));
                    }
                    return new FlagEditor(snippetObject, type, fieldIndex, constants, constant);
                }
                Method method = primitive.getMethod();
                if (method == Method.Bool) {
                    return new BooleanEditor(snippetObject, type, fieldIndex, value);
                }
                if (method == Method.Float32 || method == Method.Float64) {
                    assert (value != null);
                    return new FloatEditor(snippetObject, type, fieldIndex, value);
                }
                if (method == Method.String) {
                    return new StringEditor(snippetObject, type, fieldIndex, value);
                }
                assert (value != null);
                return new IntEditor(snippetObject, type, fieldIndex, value);
            }
            return new NoEditor(snippetObject, type, fieldIndex);
        }

        public boolean hasEditComponent() {
            return true;
        }

        @NotNull
        abstract JComponent getComponent();

        @Nullable
        abstract Object getValue();
    }

    class ActivatePathCommand
    implements Runnable,
    UndoableAction {
        @NotNull
        private final String myName;
        @NotNull
        private final Path myOldPath;
        @NotNull
        private final Path myNewPath;

        ActivatePathCommand(@NotNull String name, @NotNull Path oldPath, Path newPath) {
            this.myName = name;
            this.myOldPath = oldPath;
            this.myNewPath = newPath;
        }

        public void execute() {
            CommandProcessor.getInstance().executeCommand(EditAtomParametersAction.this.myGfxTraceEditor.getProject(), (Runnable)this, this.myName, null, UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION);
        }

        @Override
        public void run() {
            EditAtomParametersAction.this.myGfxTraceEditor.activatePath(this.myNewPath, EditAtomParametersAction.this);
            UndoManager.getInstance((Project)EditAtomParametersAction.this.myGfxTraceEditor.getProject()).undoableActionPerformed((UndoableAction)this);
        }

        public void undo() throws UnexpectedUndoException {
            EditAtomParametersAction.this.myGfxTraceEditor.activatePath(this.myOldPath, EditAtomParametersAction.this);
        }

        public void redo() throws UnexpectedUndoException {
            EditAtomParametersAction.this.myGfxTraceEditor.activatePath(this.myNewPath, EditAtomParametersAction.this);
        }

        @Nullable
        public DocumentReference[] getAffectedDocuments() {
            return null;
        }

        public boolean isGlobal() {
            return true;
        }
    }
}

