/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.actions;

import com.android.tools.idea.configurations.FlatComboAction;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.service.atom.Atom;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import icons.AndroidIcons;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AtomComboAction
extends FlatComboAction {
    @NotNull
    private final GfxTraceEditor myGfxTraceEditor;
    @NotNull
    private List<Long> myAtomIds = Collections.emptyList();

    public AtomComboAction(@NotNull GfxTraceEditor editor) {
        this.myGfxTraceEditor = editor;
    }

    public void setAtomIds(@NotNull List<Long> atomIds) {
        this.myAtomIds = atomIds;
    }

    @Override
    protected FlatComboAction.FlatComboButton createComboBoxButton(@NotNull Presentation presentation) {
        presentation.setIcon(AndroidIcons.GfxTrace.Jump);
        presentation.setDescription("Accesses / Modifications");
        return super.createComboBoxButton(presentation);
    }

    @Override
    @NotNull
    protected DefaultActionGroup createPopupActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (final Long atomIndex : this.myAtomIds) {
            AnAction action = new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    if (atomIndex != null) {
                        AtomComboAction.this.myGfxTraceEditor.getAtomStream().selectAtoms(atomIndex, 1L, (Object)this);
                    }
                }
            };
            actionGroup.add(action);
            Presentation presentation = action.getTemplatePresentation();
            Atom atom = this.myGfxTraceEditor.getAtomStream().getAtom(atomIndex);
            presentation.setText(atomIndex + ": " + atom.getName());
        }
        return actionGroup;
    }
}

