/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.tools.idea.debug.AndroidResolveHelper;
import com.android.tools.idea.debug.AnnotationsRenderer;
import com.android.tools.idea.debug.DynamicResourceIdResolver;
import com.android.tools.idea.debug.ResourceIdResolver;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.LocalVariableDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.ToStringCommand;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public class ResolveTypedIntegerCommand
extends ToStringCommand {
    private final ValueDescriptor myDescriptor;
    private final EvaluationContext myEvaluationContext;
    private final Value myValue;
    private final DescriptorLabelListener myListener;
    AnnotationsRenderer.Result myResult;

    public ResolveTypedIntegerCommand(@NotNull ValueDescriptor descriptor, @NotNull EvaluationContext evaluationContext, @NotNull Value value, @NotNull DescriptorLabelListener listener) {
        super(evaluationContext, value);
        this.myDescriptor = descriptor;
        this.myEvaluationContext = evaluationContext;
        this.myValue = value;
        this.myListener = listener;
    }

    public void action() {
        DebugProcess debugProcess = this.myEvaluationContext.getDebugProcess();
        if (!(debugProcess instanceof DebugProcessImpl)) {
            return;
        }
        final DebuggerContextImpl debuggerContext = ((DebugProcessImpl)debugProcess).getDebuggerContext();
        PsiAnnotation annotation = (PsiAnnotation)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiAnnotation>(){

            public PsiAnnotation compute() {
                PsiElement context = PositionUtil.getContextElement((StackFrameContext)debuggerContext);
                if (context == null) {
                    return null;
                }
                if (ResolveTypedIntegerCommand.this.myDescriptor instanceof LocalVariableDescriptor) {
                    return AndroidResolveHelper.getAnnotationForLocal(context, ResolveTypedIntegerCommand.this.myDescriptor.getName());
                }
                if (ResolveTypedIntegerCommand.this.myDescriptor instanceof FieldDescriptor) {
                    String className = ((FieldDescriptor)ResolveTypedIntegerCommand.this.myDescriptor).getField().declaringType().name();
                    return AndroidResolveHelper.getAnnotationForField(context, className, ResolveTypedIntegerCommand.this.myDescriptor.getName());
                }
                return null;
            }
        });
        if (annotation != null) {
            ResourceIdResolver resolver = (ResourceIdResolver)ServiceManager.getService((Project)this.myEvaluationContext.getProject(), ResourceIdResolver.class);
            DynamicResourceIdResolver resolver1 = new DynamicResourceIdResolver(this.myEvaluationContext, resolver);
            this.myResult = AnnotationsRenderer.render(resolver1, annotation, ((IntegerValue)this.myValue).value());
        }
        this.evaluationResult("");
    }

    public void evaluationResult(String message) {
        if (this.myResult == null) {
            return;
        }
        this.myDescriptor.setValueLabel(this.myResult.label);
        if (this.myResult.icon != null) {
            this.myDescriptor.setValueIcon(this.myResult.icon);
        }
        this.myListener.labelChanged();
    }

    public void evaluationError(String message) {
    }
}

