/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.tools.idea.debug.AndroidResolveHelper;
import com.android.tools.idea.debug.ResourceIdResolver;
import com.google.common.util.concurrent.Atomics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.util.ui.ColorIcon;
import java.awt.Color;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationsRenderer {
    @NotNull
    public static Result render(@Nullable ResourceIdResolver resolver, @NotNull PsiAnnotation annotation, int value) {
        String qualifiedName = AnnotationsRenderer.getQualifiedName(annotation);
        if (qualifiedName == null) {
            return AnnotationsRenderer.renderUnknown(null, value);
        }
        if ("android.support.annotation.ColorInt".equals(qualifiedName)) {
            return AnnotationsRenderer.renderColorInt(value);
        }
        if (qualifiedName.endsWith("Res")) {
            return AnnotationsRenderer.renderResourceRefAnnotation(resolver, value, qualifiedName);
        }
        if (qualifiedName.equals("android.support.annotation.IntDef")) {
            return AnnotationsRenderer.renderIntDefAnnotation(annotation, value);
        }
        return AnnotationsRenderer.renderUnknown(qualifiedName, value);
    }

    @NotNull
    private static Result renderIntDefAnnotation(final @NotNull PsiAnnotation annotation, int value) {
        final AtomicReference valuesRef = Atomics.newReference();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                valuesRef.set(AndroidResolveHelper.resolveIntDef(annotation));
            }
        });
        AndroidResolveHelper.IntDefResolution intDef = (AndroidResolveHelper.IntDefResolution)valuesRef.get();
        if (intDef.valuesMap == null) {
            AnnotationsRenderer.renderUnknown("IntDef", value);
        }
        return new Result(String.format(Locale.US, "0x%1$08x {%2$s}", value, AnnotationsRenderer.renderIntDef(value, intDef)), null);
    }

    @NotNull
    static String renderIntDef(int value, AndroidResolveHelper.IntDefResolution intDef) {
        if (intDef.valuesMap == null) {
            return "";
        }
        if (!intDef.canBeOred) {
            String name = intDef.valuesMap.get(value);
            return StringUtil.notNullize((String)name);
        }
        StringBuilder sb = new StringBuilder(20);
        for (Map.Entry<Integer, String> entry : intDef.valuesMap.entrySet()) {
            int key = entry.getKey();
            if ((value & key) == 0) continue;
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    @NotNull
    private static Result renderResourceRefAnnotation(@Nullable ResourceIdResolver resolver, int value, String qualifiedName) {
        String androidRes = null;
        if (resolver != null) {
            androidRes = resolver.getAndroidResourceName(value);
        }
        if (androidRes == null) {
            return AnnotationsRenderer.renderUnknown(qualifiedName, value);
        }
        String result = String.format(Locale.US, "0x%1$08x {%2$s}", value, androidRes);
        return new Result(result, null);
    }

    @NotNull
    private static Result renderColorInt(int value) {
        int alpha = value >>> 24;
        boolean hasAlpha = alpha != 0;
        Color color = new Color(value, hasAlpha);
        String result = String.format(Locale.US, "0x%1$08x {a=%2$02d r=%3$02d g=%4$02d b=%5$02d}", value, color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue());
        return new Result(result, (Icon)new ColorIcon(16, 12, color, true));
    }

    @NotNull
    private static Result renderUnknown(@Nullable String annotationName, int value) {
        return new Result(String.format("0x%1$08x {@%2$s ?}", value, annotationName == null ? "" : AnnotationsRenderer.getSimpleClassName(annotationName)), null);
    }

    @Nullable
    private static String getQualifiedName(final PsiAnnotation annotation) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return annotation.getQualifiedName();
            }
        });
    }

    private static String getSimpleClassName(@NotNull String fqcn) {
        int index = fqcn.lastIndexOf(46);
        return index < fqcn.length() - 1 ? fqcn.substring(index + 1) : fqcn;
    }

    public static class Result {
        @NotNull
        public final String label;
        @Nullable
        public final Icon icon;

        public Result(@NotNull String label, @Nullable Icon icon) {
            this.label = label;
            this.icon = icon;
        }
    }
}

