/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.screenshot;

import com.android.ddmlib.IDevice;
import com.android.resources.ScreenOrientation;
import com.android.tools.idea.ddms.screenshot.DeviceArtDescriptor;
import com.android.tools.idea.ddms.screenshot.DeviceArtPainter;
import com.android.tools.idea.ddms.screenshot.ScreenshotTask;
import com.android.tools.idea.rendering.ImageUtils;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.images.editor.ImageEditor;
import org.intellij.images.editor.ImageFileEditor;
import org.intellij.images.editor.ImageZoomModel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenshotViewer
extends DialogWrapper
implements DataProvider {
    @NonNls
    private static final String SCREENSHOT_VIEWER_DIMENSIONS_KEY = "ScreenshotViewer.Dimensions";
    @NonNls
    private static final String SCREENSHOT_SAVE_PATH_KEY = "ScreenshotViewer.SavePath";
    private final Project myProject;
    private final IDevice myDevice;
    private final VirtualFile myBackingVirtualFile;
    private final ImageFileEditor myImageFileEditor;
    private final FileEditorProvider myProvider;
    private final List<DeviceArtDescriptor> myDeviceArtDescriptors;
    private JPanel myPanel;
    private JButton myRefreshButton;
    private JButton myRotateButton;
    private JBScrollPane myScrollPane;
    private JCheckBox myFrameScreenshotCheckBox;
    private JComboBox<String> myDeviceArtCombo;
    private JCheckBox myDropShadowCheckBox;
    private JCheckBox myScreenGlareCheckBox;
    private int myRotationAngle = 0;
    private AtomicReference<BufferedImage> mySourceImageRef;
    private AtomicReference<BufferedImage> myDisplayedImageRef;
    private File myScreenshotFile;

    public ScreenshotViewer(@NotNull Project project, @NotNull BufferedImage image, @NotNull File backingFile, @Nullable IDevice device, @Nullable String deviceModel) {
        super(project, true);
        this.$$$setupUI$$$();
        this.mySourceImageRef = new AtomicReference();
        this.myDisplayedImageRef = new AtomicReference();
        this.myProject = project;
        this.myDevice = device;
        this.mySourceImageRef.set(image);
        this.myDisplayedImageRef.set(image);
        this.myBackingVirtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(backingFile);
        assert (this.myBackingVirtualFile != null);
        this.myRefreshButton.setIcon(AllIcons.Actions.Refresh);
        this.myRefreshButton.setEnabled(device != null);
        this.myRotateButton.setIcon(AllIcons.Actions.AllRight);
        this.myProvider = this.getImageFileEditorProvider();
        this.myImageFileEditor = (ImageFileEditor)this.myProvider.createEditor(this.myProject, this.myBackingVirtualFile);
        this.myScrollPane.getViewport().add(this.myImageFileEditor.getComponent());
        ActionListener l = actionEvent -> {
            if (actionEvent.getSource() == this.myRefreshButton) {
                this.doRefreshScreenshot();
            } else if (actionEvent.getSource() == this.myRotateButton) {
                this.doRotateScreenshot();
            } else if (actionEvent.getSource() == this.myFrameScreenshotCheckBox || actionEvent.getSource() == this.myDeviceArtCombo || actionEvent.getSource() == this.myDropShadowCheckBox || actionEvent.getSource() == this.myScreenGlareCheckBox) {
                this.doFrameScreenshot();
            }
        };
        this.myRefreshButton.addActionListener(l);
        this.myRotateButton.addActionListener(l);
        this.myFrameScreenshotCheckBox.addActionListener(l);
        this.myDeviceArtCombo.addActionListener(l);
        this.myDropShadowCheckBox.addActionListener(l);
        this.myScreenGlareCheckBox.addActionListener(l);
        this.myDeviceArtDescriptors = ScreenshotViewer.getDescriptorsToFrame(image);
        String[] titles = new String[this.myDeviceArtDescriptors.size()];
        for (int i = 0; i < this.myDeviceArtDescriptors.size(); ++i) {
            titles[i] = this.myDeviceArtDescriptors.get(i).getName();
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(titles);
        this.myDeviceArtCombo.setModel(model);
        this.myDeviceArtCombo.setSelectedIndex(ScreenshotViewer.getDefaultDescriptor(this.myDeviceArtDescriptors, image, deviceModel));
        this.setModal(false);
        this.init();
    }

    private static List<DeviceArtDescriptor> getDescriptorsToFrame(BufferedImage image) {
        double imgAspectRatio = (double)image.getWidth() / (double)image.getHeight();
        ScreenOrientation orientation = imgAspectRatio >= 0.99999 ? ScreenOrientation.LANDSCAPE : ScreenOrientation.PORTRAIT;
        List<DeviceArtDescriptor> allDescriptors = DeviceArtDescriptor.getDescriptors(null);
        return ContainerUtil.filter(allDescriptors, descriptor -> descriptor.canFrameImage(image, orientation));
    }

    private static int getDefaultDescriptor(List<DeviceArtDescriptor> deviceArtDescriptors, BufferedImage image, @Nullable String deviceModel) {
        int index = -1;
        if (deviceModel != null) {
            index = ScreenshotViewer.findDescriptorIndexForProduct(deviceArtDescriptors, deviceModel);
        }
        if (index < 0) {
            String defaultDevice = Math.min(image.getWidth(), image.getHeight()) > 1280 ? "Generic Tablet" : "Generic Phone";
            index = ScreenshotViewer.findDescriptorIndexForProduct(deviceArtDescriptors, defaultDevice);
        }
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    private static int findDescriptorIndexForProduct(List<DeviceArtDescriptor> descriptors, String deviceModel) {
        for (int i = 0; i < descriptors.size(); ++i) {
            DeviceArtDescriptor d = descriptors.get(i);
            if (!d.getName().equalsIgnoreCase(deviceModel)) continue;
            return i;
        }
        return -1;
    }

    protected void dispose() {
        this.myProvider.disposeEditor((FileEditor)this.myImageFileEditor);
        super.dispose();
    }

    private void doRefreshScreenshot() {
        assert (this.myDevice != null);
        new ScreenshotTask(this.myProject, this.myDevice){

            public void onSuccess() {
                String msg = this.getError();
                if (msg != null) {
                    Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)AndroidBundle.message("android.ddms.actions.screenshot", new Object[0]));
                    return;
                }
                BufferedImage image = this.getScreenshot();
                ScreenshotViewer.this.mySourceImageRef.set(image);
                ScreenshotViewer.this.processScreenshot(ScreenshotViewer.this.myFrameScreenshotCheckBox.isSelected(), ScreenshotViewer.this.myRotationAngle);
            }
        }.queue();
    }

    private void doRotateScreenshot() {
        this.myRotationAngle = (this.myRotationAngle + 90) % 360;
        this.processScreenshot(this.myFrameScreenshotCheckBox.isSelected(), 90);
    }

    private void doFrameScreenshot() {
        boolean shouldFrame = this.myFrameScreenshotCheckBox.isSelected();
        this.myDeviceArtCombo.setEnabled(shouldFrame);
        this.myDropShadowCheckBox.setEnabled(shouldFrame);
        this.myScreenGlareCheckBox.setEnabled(shouldFrame);
        if (shouldFrame) {
            this.processScreenshot(true, 0);
        } else {
            this.myDisplayedImageRef.set(this.mySourceImageRef.get());
            this.updateEditorImage();
        }
    }

    private void processScreenshot(boolean addFrame, int rotateByAngle) {
        DeviceArtDescriptor spec = addFrame ? this.myDeviceArtDescriptors.get(this.myDeviceArtCombo.getSelectedIndex()) : null;
        boolean shadow = addFrame && this.myDropShadowCheckBox.isSelected();
        boolean reflection = addFrame && this.myScreenGlareCheckBox.isSelected();
        new ImageProcessorTask(this.myProject, this.mySourceImageRef.get(), rotateByAngle, spec, shadow, reflection, this.myBackingVirtualFile){

            public void onSuccess() {
                ScreenshotViewer.this.mySourceImageRef.set(this.getRotatedImage());
                ScreenshotViewer.this.myDisplayedImageRef.set(this.getProcessedImage());
                ScreenshotViewer.this.updateEditorImage();
            }
        }.queue();
    }

    private void updateEditorImage() {
        BufferedImage image = this.myDisplayedImageRef.get();
        ImageEditor imageEditor = this.myImageFileEditor.getImageEditor();
        ImageZoomModel zoomModel = imageEditor.getZoomModel();
        double zoom = zoomModel.getZoomFactor();
        imageEditor.getDocument().setValue(image);
        this.pack();
        zoomModel.setZoomFactor(zoom);
    }

    private FileEditorProvider getImageFileEditorProvider() {
        FileEditorProvider[] providers = FileEditorProviderManager.getInstance().getProviders(this.myProject, this.myBackingVirtualFile);
        assert (providers.length > 0);
        for (FileEditorProvider p : providers) {
            if (!p.getEditorTypeId().equals("images")) continue;
            return p;
        }
        return providers[0];
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @NonNls
    @Nullable
    protected String getDimensionServiceKey() {
        return SCREENSHOT_VIEWER_DIMENSIONS_KEY;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return PlatformDataKeys.FILE_EDITOR.getName().equals(dataId) ? this.myImageFileEditor : null;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.getOKAction().putValue("Name", AndroidBundle.message("android.ddms.screenshot.save.ok.button.text", new Object[0]));
    }

    protected void doOKAction() {
        VirtualFile baseDir;
        FileSaverDescriptor descriptor = new FileSaverDescriptor(AndroidBundle.message("android.ddms.screenshot.save.title", new Object[0]), "", new String[]{"png"});
        FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, this.myProject);
        VirtualFileWrapper fileWrapper = saveFileDialog.save(baseDir = this.loadScreenshotPath(), this.getDefaultFileName());
        if (fileWrapper == null) {
            return;
        }
        this.myScreenshotFile = fileWrapper.getFile();
        try {
            ImageIO.write((RenderedImage)this.myDisplayedImageRef.get(), "png", this.myScreenshotFile);
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)AndroidBundle.message("android.ddms.screenshot.save.error", e), (String)AndroidBundle.message("android.ddms.actions.screenshot", new Object[0]));
            return;
        }
        VirtualFile virtualFile = fileWrapper.getVirtualFile();
        if (virtualFile != null) {
            PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
            properties.setValue(SCREENSHOT_SAVE_PATH_KEY, virtualFile.getParent().getPath());
        }
        super.doOKAction();
    }

    private String getDefaultFileName() {
        Calendar now = Calendar.getInstance();
        return String.format("%s-%tF-%tH%tM%tS.png", this.myDevice != null ? "device" : "layout", now, now, now, now);
    }

    public File getScreenshot() {
        return this.myScreenshotFile;
    }

    private VirtualFile loadScreenshotPath() {
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        String lastPath = properties.getValue(SCREENSHOT_SAVE_PATH_KEY);
        if (lastPath != null) {
            return LocalFileSystem.getInstance().findFileByPath(lastPath);
        }
        return this.myProject.getBaseDir();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBScrollPane jBScrollPane;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 7, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myRefreshButton = jButton2 = new JButton();
        jButton2.setText("Recapture");
        jPanel2.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 3, null, new Dimension(66, 26), null));
        this.myRotateButton = jButton = new JButton();
        ((Component)jButton).setEnabled(true);
        jButton.setText("Rotate");
        jPanel2.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myFrameScreenshotCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Frame Screenshot");
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myDeviceArtCombo = jComboBox;
        ((Component)jComboBox).setEnabled(false);
        jPanel2.add(jComboBox, new GridConstraints(0, 4, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myDropShadowCheckBox = jCheckBox2 = new JCheckBox();
        ((Component)jCheckBox2).setEnabled(false);
        jCheckBox2.setText("Drop Shadow");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 5, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myScreenGlareCheckBox = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setEnabled(false);
        jCheckBox.setText("Screen Glare");
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 6, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, new Dimension(400, 600), null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class ImageProcessorTask
    extends Task.Modal {
        private final BufferedImage mySrcImage;
        private final int myRotationAngle;
        private final DeviceArtDescriptor myDescriptor;
        private final boolean myAddShadow;
        private final boolean myAddReflection;
        private final VirtualFile myDestinationFile;
        private BufferedImage myRotatedImage;
        private BufferedImage myProcessedImage;

        public ImageProcessorTask(@Nullable Project project, @NotNull BufferedImage srcImage, int rotateByAngle, @Nullable DeviceArtDescriptor descriptor, boolean addShadow, boolean addReflection, VirtualFile writeToFile) {
            super(project, AndroidBundle.message("android.ddms.screenshot.image.processor.task.title", new Object[0]), false);
            this.mySrcImage = srcImage;
            this.myRotationAngle = rotateByAngle;
            this.myDescriptor = descriptor;
            this.myAddShadow = addShadow;
            this.myAddReflection = addReflection;
            this.myDestinationFile = writeToFile;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            this.myRotatedImage = this.myRotationAngle != 0 ? ImageUtils.rotateByRightAngle(this.mySrcImage, this.myRotationAngle) : this.mySrcImage;
            this.myProcessedImage = this.myDescriptor != null ? DeviceArtPainter.createFrame(this.myRotatedImage, this.myDescriptor, this.myAddShadow, this.myAddReflection) : this.myRotatedImage;
            this.myProcessedImage = ImageUtils.cropBlank(this.myProcessedImage, null);
            if (this.myDestinationFile != null) {
                File file = VfsUtilCore.virtualToIoFile((VirtualFile)this.myDestinationFile);
                try {
                    ImageIO.write((RenderedImage)this.myProcessedImage, "png", file);
                }
                catch (IOException e) {
                    Logger.getInstance(ImageProcessorTask.class).error("Unexpected error while writing to backing file", (Throwable)e);
                }
            }
        }

        protected BufferedImage getProcessedImage() {
            return this.myProcessedImage;
        }

        protected BufferedImage getRotatedImage() {
            return this.myRotatedImage;
        }
    }
}

