/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;

public class BrUtil {
    private static final Logger LOG = Logger.getInstance(BrUtil.class);

    static Set<String> collectIds(Collection<? extends PsiModifierListOwner> psiElements) {
        HashSet properties = new HashSet();
        for (PsiModifierListOwner psiModifierListOwner : psiElements) {
            String key = null;
            if (psiModifierListOwner instanceof PsiField) {
                key = BrUtil.stripPrefixFromField((PsiField)psiModifierListOwner);
            } else if (psiModifierListOwner instanceof PsiMethod) {
                key = BrUtil.stripPrefixFromMethod((PsiMethod)psiModifierListOwner);
            }
            if (key == null) continue;
            properties.add(key);
        }
        return properties;
    }

    static String stripPrefixFromMethod(PsiMethod psiMethod) {
        CharSequence propertyName;
        String name = psiMethod.getName();
        if (BrUtil.isGetter(psiMethod) || BrUtil.isSetter(psiMethod)) {
            propertyName = name.subSequence(3, name.length());
        } else if (BrUtil.isBooleanGetter(psiMethod)) {
            propertyName = name.subSequence(2, name.length());
        } else {
            LOG.warn("@Bindable associated with a method must follow JavaBeans convention: " + psiMethod.getName());
            return null;
        }
        char firstChar = propertyName.charAt(0);
        return String.valueOf(Character.toLowerCase(firstChar)) + propertyName.subSequence(1, propertyName.length());
    }

    public static boolean isGetter(PsiMethod psiMethod) {
        String name = psiMethod.getName();
        return BrUtil.prefixes(name, "get") && Character.isJavaIdentifierStart(name.charAt(3)) && psiMethod.getParameterList().getParametersCount() == 0 && !PsiType.VOID.equals((Object)psiMethod.getReturnType());
    }

    public static boolean isSetter(PsiMethod psiMethod) {
        String name = psiMethod.getName();
        return BrUtil.prefixes(name, "set") && Character.isJavaIdentifierStart(name.charAt(3)) && psiMethod.getParameterList().getParametersCount() == 1 && PsiType.VOID.equals((Object)psiMethod.getReturnType());
    }

    public static boolean isBooleanGetter(PsiMethod psiMethod) {
        String name = psiMethod.getName();
        return BrUtil.prefixes(name, "is") && Character.isJavaIdentifierStart(name.charAt(2)) && psiMethod.getParameterList().getParametersCount() == 0 && PsiType.BOOLEAN.equals((Object)psiMethod.getReturnType());
    }

    static String stripPrefixFromField(PsiField psiField) {
        return BrUtil.stripPrefixFromField(psiField.getName());
    }

    static boolean prefixes(CharSequence sequence, String prefix) {
        boolean prefixes = false;
        if (sequence.length() > prefix.length()) {
            int count = prefix.length();
            prefixes = true;
            for (int i = 0; i < count; ++i) {
                if (sequence.charAt(i) == prefix.charAt(i)) continue;
                prefixes = false;
                break;
            }
        }
        return prefixes;
    }

    static String stripPrefixFromField(String name) {
        if (name.length() >= 2) {
            char firstChar = name.charAt(0);
            char secondChar = name.charAt(1);
            if (name.length() > 2 && firstChar == 'm' && secondChar == '_') {
                char thirdChar = name.charAt(2);
                if (Character.isJavaIdentifierStart(thirdChar)) {
                    return String.valueOf(Character.toLowerCase(thirdChar)) + name.subSequence(3, name.length());
                }
            } else if (firstChar == 'm' && Character.isUpperCase(secondChar) || firstChar == '_' && Character.isJavaIdentifierStart(secondChar)) {
                return String.valueOf(Character.toLowerCase(secondChar)) + name.subSequence(2, name.length());
            }
        }
        return name;
    }
}

