/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrClassFinder
extends PsiElementFinder {
    private final DataBindingProjectComponent myComponent;
    private CachedValue<Map<String, PsiClass>> myClassByPackageCache;

    public BrClassFinder(DataBindingProjectComponent component) {
        this.myComponent = component;
        this.myClassByPackageCache = CachedValuesManager.getManager((Project)component.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, PsiClass>>(){

            @Nullable
            public CachedValueProvider.Result<Map<String, PsiClass>> compute() {
                HashMap<String, DataBindingUtil.LightBrClass> classes = new HashMap<String, DataBindingUtil.LightBrClass>();
                for (AndroidFacet facet : BrClassFinder.this.myComponent.getDataBindingEnabledFacets()) {
                    if (!facet.isDataBindingEnabled()) continue;
                    classes.put(DataBindingUtil.getBrQualifiedName(facet), DataBindingUtil.getOrCreateBrClassFor(facet));
                }
                return CachedValueProvider.Result.create(classes, (Object[])new Object[]{BrClassFinder.this.myComponent});
            }
        }, false);
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (!this.myComponent.hasAnyDataBindingEnabledFacet() || !qualifiedName.endsWith("BR")) {
            return null;
        }
        PsiClass psiClass = (PsiClass)((Map)this.myClassByPackageCache.getValue()).get(qualifiedName);
        if (psiClass == null) {
            return null;
        }
        PsiFile containingFile = psiClass.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (!scope.accept(virtualFile)) {
            return null;
        }
        return psiClass;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass aClass = this.findClass(qualifiedName, scope);
        if (aClass == null) {
            return PsiClass.EMPTY_ARRAY;
        }
        return new PsiClass[]{aClass};
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        return null;
    }
}

