/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Storage;
import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.ObjectProperty;
import com.android.tools.idea.ui.properties.core.ObjectValueProperty;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.EnumComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class StorageField
extends JPanel {
    private final Storage.Unit DEFAULT_UNIT = Storage.Unit.MiB;
    private final ComboBoxModel unitModel = new EnumComboBoxModel(Storage.Unit.class);
    private final ComboBox myUnitsCombo = new ComboBox(this.unitModel);
    private final JTextField myValueField = new JTextField();
    private Storage.Unit myCurrentUnit = this.DEFAULT_UNIT;
    private ObjectProperty<Storage> myStorage = new ObjectValueProperty<Storage>(new Storage(0L, this.DEFAULT_UNIT));

    public ObjectProperty<Storage> storage() {
        return this.myStorage;
    }

    public final Dimension getPreferredSizeOfUnitsDropdown() {
        return this.myUnitsCombo.getPreferredSize();
    }

    public StorageField() {
        this.setLayout(new BorderLayout(3, 0));
        this.add((Component)this.myValueField, "Center");
        this.add((Component)this.myUnitsCombo, "East");
        this.myUnitsCombo.setSelectedItem((Object)this.DEFAULT_UNIT);
        this.myUnitsCombo.setRenderer((ListCellRenderer)new ColoredListCellRenderer<Storage.Unit>(){

            protected void customizeCellRenderer(JList list, Storage.Unit value, int index, boolean selected, boolean hasFocus) {
                this.append(value.getDisplayValue());
            }
        });
        this.myUnitsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StorageField.this.myCurrentUnit = (Storage.Unit)StorageField.this.myUnitsCombo.getSelectedItem();
                String value = new DecimalFormat("0.####").format(((Storage)StorageField.this.myStorage.get()).getPreciseSizeAsUnit(StorageField.this.myCurrentUnit));
                StorageField.this.myValueField.setText(value);
            }
        });
        this.myValueField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                StorageField.this.updateStorage();
            }
        });
        this.storage().addListener(new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                String value = new DecimalFormat("0.####").format(((Storage)StorageField.this.myStorage.get()).getPreciseSizeAsUnit(StorageField.this.myCurrentUnit));
                StorageField.this.myValueField.setText(value);
            }
        });
    }

    private void updateStorage() {
        String text = this.myValueField.getText();
        if (text != null) {
            Storage storage;
            try {
                Double valueAsUnits = Double.parseDouble(text);
                storage = new Storage(valueAsUnits.longValue(), this.myCurrentUnit);
            }
            catch (NumberFormatException ex) {
                storage = new Storage(0L, this.DEFAULT_UNIT);
                this.myValueField.setText("0");
                this.myUnitsCombo.setSelectedItem((Object)this.DEFAULT_UNIT);
            }
            this.myStorage.set(storage);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myUnitsCombo.setEnabled(enabled);
        this.myValueField.setEnabled(enabled);
    }
}

