/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.ISystemImage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.EmulatorProcessHandler;
import com.android.tools.idea.run.ExternalToolRunner;
import com.android.tools.idea.stats.UsageTracker;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmulatorRunner
extends ExternalToolRunner {
    public EmulatorRunner(@NotNull Project project, @NotNull String consoleTitle, @NotNull GeneralCommandLine commandLine, @Nullable AvdInfo avdInfo) {
        super(project, consoleTitle, commandLine);
        ISystemImage image = avdInfo == null ? null : avdInfo.getSystemImage();
        String description = image == null ? null : image.toString();
        UsageTracker.getInstance().trackEvent("deployment", "emulatorLaunch", description, null);
        if (avdInfo != null) {
            UsageTracker.getInstance().trackEvent("avdInfo", "abi", AvdInfo.getPrettyAbiType((AvdInfo)avdInfo), null);
            String version = image == null ? "unknown" : image.getAndroidVersion().toString();
            UsageTracker.getInstance().trackEvent("avdInfo", "version", version, null);
        }
    }

    @Override
    @NotNull
    protected ProcessHandler createProcessHandler(Process process, @NotNull GeneralCommandLine commandLine) {
        return new EmulatorProcessHandler(process, commandLine);
    }

    @Override
    protected void fillToolBarActions(DefaultActionGroup toolbarActions) {
    }

    @Override
    protected ConsoleView initConsoleUi() {
        ConsoleView consoleView = super.initConsoleUi();
        String avdHome = System.getenv("ANDROID_SDK_HOME");
        if (!StringUtil.isEmpty((String)avdHome)) {
            consoleView.print("\nNote: The environment variable $ANDROID_SDK_HOME is set, and the emulator uses that variable to locate AVDs.\nThis may result in the emulator failing to start if it cannot find the AVDs in the folder pointed to by the\ngiven environment variable.\nANDROID_SDK_HOME=" + avdHome + "\n\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        return consoleView;
    }
}

