/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import org.jetbrains.annotations.NotNull;

public class AvdNameVerifier {
    private static final String ALLOWED_CHARS = "0-9a-zA-Z-_. ()";
    private static final String ALLOWED_CHARS_READABLE = "a-z A-Z 0-9 . _ - ( )";

    public static boolean isValid(@NotNull String candidateName) {
        return candidateName.matches("^[0-9a-zA-Z-_. ()]+$");
    }

    @NotNull
    public static String stripBadCharacters(@NotNull String candidateName) {
        return candidateName.replaceAll("[^0-9a-zA-Z-_. ()]", " ");
    }

    @NotNull
    public static String stripBadCharactersAndCollapse(@NotNull String candidateName) {
        return candidateName.replaceAll("[^0-9a-zA-Z-_. ()]", " ").trim().replaceAll("[ _]+", "_");
    }

    @NotNull
    public static String humanReadableAllowedCharacters() {
        return ALLOWED_CHARS_READABLE;
    }
}

