/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant.view;

import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.StatefulButtonNotifier;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.assistant.view.StatefulButtonUI;
import com.android.tools.idea.structure.services.DeveloperService;
import com.android.tools.idea.structure.services.DeveloperServiceMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ButtonUI;
import org.jetbrains.annotations.NotNull;

public class StatefulButton
extends JPanel {
    private ActionButton myButton;
    private String mySuccessMessage;
    private StatefulButtonMessage myMessage;
    private AssistActionStateManager myStateManager;
    private DeveloperServiceMap.DeveloperServiceList myServices;

    public StatefulButton(@NotNull ActionData action, @NotNull ActionListener listener, @NotNull DeveloperServiceMap.DeveloperServiceList services) {
        super((LayoutManager)new VerticalLayout(5, 2));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(false);
        this.myServices = services;
        this.mySuccessMessage = action.getSuccessMessage();
        this.myButton = new ActionButton(action, listener, this);
        this.myButton.setUI((ButtonUI)StatefulButtonUI.createUI(this.myButton));
        this.add(this.myButton);
        this.myButton.setVisible(false);
        for (AssistActionStateManager stateManager : (AssistActionStateManager[])AssistActionStateManager.EP_NAME.getExtensions()) {
            if (!stateManager.getId().equals(action.getKey())) continue;
            this.myStateManager = stateManager;
            break;
        }
        if (this.myStateManager != null) {
            this.myStateManager.init(this.myServices);
            this.myMessage = this.myStateManager.getStateDisplay(this.myServices, this.mySuccessMessage);
            this.add(this.myMessage);
            this.myMessage.setVisible(false);
            for (DeveloperService service : this.myServices) {
                Module module = service.getModule();
                MessageBusConnection connection = module.getMessageBus().connect((Disposable)module);
                connection.subscribe(StatefulButtonNotifier.BUTTON_STATE_TOPIC, () -> this.updateButtonState());
            }
        }
        this.updateButtonState();
    }

    public DeveloperServiceMap.DeveloperServiceList getServices() {
        return this.myServices;
    }

    public void updateButtonState() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.updateButtonState());
            return;
        }
        if (this.myStateManager == null) {
            this.myButton.setVisible(true);
            return;
        }
        AssistActionStateManager.ActionState state = this.myStateManager.getState(this.myServices);
        this.remove(this.myMessage);
        this.myMessage = this.myStateManager.getStateDisplay(this.myServices, this.mySuccessMessage);
        this.add(this.myMessage);
        this.revalidate();
        this.repaint();
        if (this.myMessage != null) {
            switch (state) {
                case ERROR: 
                case COMPLETE: {
                    this.myButton.setVisible(false);
                    this.myMessage.setVisible(true);
                    break;
                }
                case INCOMPLETE: {
                    this.myButton.setVisible(true);
                    this.myMessage.setVisible(false);
                    break;
                }
                default: {
                    this.myButton.setVisible(true);
                    this.myMessage.setVisible(true);
                }
            }
            return;
        }
        this.myButton.setEnabled(!state.equals((Object)AssistActionStateManager.ActionState.COMPLETE));
    }

    public static class ActionButton
    extends JButton {
        private String myKey;
        private String myActionArgument;
        private StatefulButton myButtonWrapper;

        public ActionButton(@NotNull ActionData action, @NotNull ActionListener listener, @NotNull StatefulButton wrapper) {
            super(action.getLabel());
            this.myKey = action.getKey();
            this.myActionArgument = action.getActionArgument();
            this.myButtonWrapper = wrapper;
            this.addActionListener(listener);
            this.setOpaque(false);
        }

        public String getKey() {
            return this.myKey;
        }

        public String getActionArgument() {
            return this.myActionArgument;
        }

        public void updateState() {
            this.myButtonWrapper.updateButtonState();
        }

        public DeveloperServiceMap.DeveloperServiceList getDeveloperServices() {
            return this.myButtonWrapper.getServices();
        }
    }
}

