/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.diff;

import com.android.tools.idea.apk.viewer.ApkEntry;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApkDiffEntry
implements ApkEntry {
    private String myName;
    @Nullable
    private final VirtualFile myOldFile;
    @Nullable
    private final VirtualFile myNewFile;
    private final long myOldSize;
    private final long myNewSize;

    ApkDiffEntry(@NotNull String name, @Nullable VirtualFile oldFile, @Nullable VirtualFile newFile, long oldSize, long newSize) {
        this.myName = name;
        this.myOldFile = oldFile;
        this.myNewFile = newFile;
        this.myOldSize = oldSize;
        this.myNewSize = newSize;
    }

    @Override
    public boolean isCompressedSizeKnown() {
        return false;
    }

    @Override
    public long getCompressedSize() {
        return 0L;
    }

    @Override
    public void setCompressedSize(long compressedSize) {
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        if (this.myOldFile == null) {
            assert (this.myNewFile != null);
            return this.myNewFile;
        }
        return this.myOldFile;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public String getPath() {
        return this.getFile().getPath();
    }

    @Override
    public long getSize() {
        return this.myNewSize - this.myOldSize;
    }

    public long getOldSize() {
        return this.myOldSize;
    }

    public long getNewSize() {
        return this.myNewSize;
    }

    public static long getOldSize(ApkEntry apkEntry) {
        if (apkEntry instanceof ApkDiffEntry) {
            return ((ApkDiffEntry)apkEntry).getOldSize();
        }
        return apkEntry.getSize();
    }

    public static long getNewSize(ApkEntry apkEntry) {
        if (apkEntry instanceof ApkDiffEntry) {
            return ((ApkDiffEntry)apkEntry).getNewSize();
        }
        return apkEntry.getSize();
    }
}

