/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.dex;

import com.android.tools.idea.apk.viewer.dex.PackageTreeNode;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.reference.DexBackedMethodReference;
import org.jf.dexlib2.iface.reference.MethodReference;

public class DexParser {
    private final ListeningExecutorService myExecutor;
    private final Future<DexBackedDexFile> myDexFileFuture;

    public DexParser(@NotNull ListeningExecutorService executorService, @NotNull VirtualFile file) {
        this.myExecutor = executorService;
        this.myDexFileFuture = this.myExecutor.submit(() -> DexParser.getDexFile(file));
    }

    public ListenableFuture<PackageTreeNode> constructMethodRefCountTree() {
        return this.myExecutor.submit(this::constructMethodRefTree);
    }

    public ListenableFuture<DexFileStats> getDexFileStats() {
        return this.myExecutor.submit(this::getDexStats);
    }

    @NotNull
    private PackageTreeNode constructMethodRefTree() {
        DexBackedDexFile dexFile;
        try {
            dexFile = this.myDexFileFuture.get();
        }
        catch (Exception e) {
            return new PackageTreeNode("Unknown", e.toString(), PackageTreeNode.NodeType.PACKAGE, null);
        }
        return DexParser.constructMethodRefTreeForDex(dexFile);
    }

    @NotNull
    static PackageTreeNode constructMethodRefTreeForDex(@NotNull DexBackedDexFile dexFile) {
        PackageTreeNode root = new PackageTreeNode("", "root", PackageTreeNode.NodeType.PACKAGE, null);
        Set classesWithDefinition = dexFile.getClasses().stream().map(DexBackedClassDef::getType).collect(Collectors.toSet());
        Multimap<String, MethodReference> methodsByClassName = DexParser.getMethodsByClassName(dexFile);
        for (String className : methodsByClassName.keySet()) {
            Collection methods = methodsByClassName.get((Object)className);
            for (MethodReference ref : methods) {
                root.insert("", DebuggerUtilsEx.signatureToName((String)className), ref, classesWithDefinition.contains(className));
            }
        }
        root.sortByCount();
        return root;
    }

    @NotNull
    private static Multimap<String, MethodReference> getMethodsByClassName(@NotNull DexBackedDexFile dexFile) {
        ArrayListMultimap methodsByClass = ArrayListMultimap.create();
        int m = dexFile.getMethodCount();
        for (int i = 0; i < m; ++i) {
            DexBackedMethodReference methodRef = new DexBackedMethodReference(dexFile, i);
            methodsByClass.put((Object)methodRef.getDefiningClass(), (Object)methodRef);
        }
        return methodsByClass;
    }

    @NotNull
    private DexFileStats getDexStats() {
        DexBackedDexFile dexFile;
        try {
            dexFile = this.myDexFileFuture.get();
        }
        catch (Exception e) {
            return new DexFileStats(-1, -1, -1);
        }
        int definedMethodCount = 0;
        Set classes = dexFile.getClasses();
        for (DexBackedClassDef dexBackedClassDef : classes) {
            definedMethodCount += Iterables.size((Iterable)dexBackedClassDef.getMethods());
        }
        return new DexFileStats(classes.size(), definedMethodCount, dexFile.getMethodCount());
    }

    @NotNull
    private static DexBackedDexFile getDexFile(@NotNull VirtualFile file) throws IOException {
        byte[] contents = file.contentsToByteArray();
        return DexParser.getDexFile(contents);
    }

    @NotNull
    static DexBackedDexFile getDexFile(@NotNull byte[] contents) {
        return new DexBackedDexFile(new Opcodes(15), contents);
    }

    public static class DexFileStats {
        public final int classCount;
        public final int definedMethodCount;
        public final int referencedMethodCount;

        private DexFileStats(int classCount, int definedMethodCount, int referencedMethodCount) {
            this.classCount = classCount;
            this.definedMethodCount = definedMethodCount;
            this.referencedMethodCount = referencedMethodCount;
        }
    }
}

