/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.sdk;

import com.android.SdkConstants;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.SdkLoader;
import com.android.builder.sdk.TargetInfo;
import com.android.repository.Revision;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repositoryv2.AndroidSdkHandler;
import com.android.sdklib.repositoryv2.LoggerProgressIndicatorWrapper;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class DefaultSdkLoader
implements SdkLoader {
    private static DefaultSdkLoader sLoader;
    private final File mSdkLocation;
    private AndroidSdkHandler mSdkHandler;
    private SdkInfo mSdkInfo;
    private final ImmutableList<File> mRepositories;

    public static synchronized SdkLoader getLoader(File sdkLocation) {
        if (sLoader == null) {
            sLoader = new DefaultSdkLoader(sdkLocation);
        } else if (!sdkLocation.equals(DefaultSdkLoader.sLoader.mSdkLocation)) {
            throw new IllegalStateException("Already created an SDK Loader with different SDK Path");
        }
        return sLoader;
    }

    public static synchronized void unload() {
        sLoader = null;
    }

    @Override
    public TargetInfo getTargetInfo(String targetHash, Revision buildToolRevision, ILogger logger) {
        this.init(logger);
        LoggerProgressIndicatorWrapper progress = new LoggerProgressIndicatorWrapper(logger);
        IAndroidTarget target = this.mSdkHandler.getAndroidTargetManager((ProgressIndicator)progress).getTargetFromHashString(targetHash, (ProgressIndicator)progress);
        if (target == null) {
            throw new IllegalStateException("failed to find target with hash string '" + targetHash + "' in: " + this.mSdkLocation);
        }
        BuildToolInfo buildToolInfo = this.mSdkHandler.getBuildToolInfo(buildToolRevision, (ProgressIndicator)progress);
        if (buildToolInfo == null) {
            throw new IllegalStateException("failed to find Build Tools revision " + buildToolRevision.toString());
        }
        return new TargetInfo(target, buildToolInfo);
    }

    @Override
    public SdkInfo getSdkInfo(ILogger logger) {
        this.init(logger);
        return this.mSdkInfo;
    }

    @Override
    public ImmutableList<File> getRepositories() {
        return this.mRepositories;
    }

    private DefaultSdkLoader(File sdkLocation) {
        this.mSdkLocation = sdkLocation;
        this.mRepositories = this.computeRepositories();
    }

    private synchronized void init(ILogger logger) {
        if (this.mSdkHandler == null) {
            this.mSdkHandler = new AndroidSdkHandler(this.mSdkLocation, FileOpUtils.create());
            File toolsFolder = new File(this.mSdkLocation, "tools");
            File supportToolsFolder = new File(toolsFolder, "support");
            File platformTools = new File(this.mSdkLocation, "platform-tools");
            this.mSdkInfo = new SdkInfo(new File(supportToolsFolder, "annotations.jar"), new File(platformTools, SdkConstants.FN_ADB));
        }
    }

    public ImmutableList<File> computeRepositories() {
        File m2Repo;
        File googleRepo;
        ArrayList repositories = Lists.newArrayListWithExpectedSize((int)3);
        File androidRepo = new File(this.mSdkLocation, "extras" + File.separator + "android" + File.separator + "m2repository");
        if (androidRepo.isDirectory()) {
            repositories.add(androidRepo);
        }
        if ((googleRepo = new File(this.mSdkLocation, "extras" + File.separator + "google" + File.separator + "m2repository")).isDirectory()) {
            repositories.add(googleRepo);
        }
        if ((m2Repo = new File(this.mSdkLocation, "extras" + File.separator + "m2repository")).isDirectory()) {
            repositories.add(m2Repo);
        }
        return ImmutableList.copyOf((Collection)repositories);
    }
}

