/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.service.internal;

import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.plugin.use.resolve.service.internal.ClientStatus;
import org.gradle.plugin.use.resolve.service.internal.PluginResolutionServiceClient;
import org.gradle.plugin.use.resolve.service.internal.PluginUseMetaData;
import org.gradle.util.DeprecationLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeprecationListeningPluginResolutionServiceClient
implements PluginResolutionServiceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeprecationListeningPluginResolutionServiceClient.class);
    private final PluginResolutionServiceClient delegate;
    private final Action<? super String> action;

    public DeprecationListeningPluginResolutionServiceClient(PluginResolutionServiceClient delegate) {
        this(delegate, (Action<? super String>)new Action<String>(){

            public void execute(String s) {
                DeprecationLogger.nagUserWith((String)s);
            }
        });
    }

    DeprecationListeningPluginResolutionServiceClient(PluginResolutionServiceClient delegate, Action<? super String> action) {
        this.delegate = delegate;
        this.action = action;
    }

    @Override
    public PluginResolutionServiceClient.Response<PluginUseMetaData> queryPluginMetadata(String portalUrl, boolean shouldValidate, PluginRequest pluginRequest) {
        PluginResolutionServiceClient.Response<PluginUseMetaData> response = this.delegate.queryPluginMetadata(portalUrl, shouldValidate, pluginRequest);
        String statusChecksum = response.getClientStatusChecksum();
        if (statusChecksum != null) {
            this.checkForDeprecation(portalUrl, shouldValidate, statusChecksum);
        }
        return response;
    }

    @Override
    public PluginResolutionServiceClient.Response<ClientStatus> queryClientStatus(String portalUrl, boolean shouldValidate, String checksum) {
        return this.delegate.queryClientStatus(portalUrl, shouldValidate, checksum);
    }

    private void checkForDeprecation(String portalUrl, boolean shouldValidate, String statusChecksum) {
        PluginResolutionServiceClient.Response<ClientStatus> response;
        try {
            response = this.delegate.queryClientStatus(portalUrl, shouldValidate, statusChecksum);
        }
        catch (Exception e) {
            LOGGER.debug("Exception thrown fetching client status", (Throwable)e);
            return;
        }
        if (response.isError()) {
            LOGGER.warn("Received error response fetching client status from {}: {}", (Object)response.getUrl(), (Object)response.getErrorResponse());
        } else {
            ClientStatus status = response.getResponse();
            String deprecationMessage = status.getDeprecationMessage();
            if (deprecationMessage != null) {
                String message = DeprecationListeningPluginResolutionServiceClient.toMessage(deprecationMessage, response.getUrl());
                this.action.execute((Object)message);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public static String toMessage(String deprecationMessage, String responseUrl) {
        return String.format("Plugin resolution service client status service %s reported that this client has been deprecated: %s", responseUrl, deprecationMessage);
    }
}

