/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.ui;

import com.google.gct.testrecorder.event.TestRecorderAssertion;
import com.google.gct.testrecorder.event.TestRecorderEvent;
import com.intellij.util.ui.UIUtil;
import groovy.json.StringEscapeUtils;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

public class TestRecorderListRenderer
extends DefaultListCellRenderer {
    private static final String OUTER_DIV_STYLE = "style='margin: 0; color: %s; padding: 2px 12px'";
    private static final String INNER_DIV_STYLE = "style='margin-top: 4px; display: block; border-left: 2px solid #dddddd; padding-left: 8px; margin-left: 16px'";
    private static final String TEXT_CHANGE_EVENT_FORMAT = "<html><div style='margin: 0; color: %s; padding: 2px 12px'>Type %s <div style='margin-top: 4px; display: block; border-left: 2px solid #dddddd; padding-left: 8px; margin-left: 16px'>%s</div></div></html>";
    private static final String CLICK_EVENT_FORMAT = "<html><div style='margin: 0; color: %s; padding: 2px 12px'>Tap %s</div></html>";
    private static final String LONG_CLICK_EVENT_FORMAT = "<html><div style='margin: 0; color: %s; padding: 2px 12px'>Long Tap %s</div></html>";
    private static final String PRESS_EVENT_FORMAT = "<html><div style='margin: 0; color: %s; padding: 2px 12px'>Press %s</div></html>";
    private static final String ASSERTION_FORMAT_ONE_LINE = "<html><div style='margin: 0; color: %s; padding: 2px 12px'>Assert %s %s</div></html>";
    private static final String ASSERTION_FORMAT_MULTI_LINE = "<html><div style='margin: 0; color: %s; padding: 2px 12px'>Assert %s %s<div style='margin-top: 4px; display: block; border-left: 2px solid #dddddd; padding-left: 8px; margin-left: 16px'>%s</div></div></html>";

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String renderString;
        String outerDivTextColor;
        String string = outerDivTextColor = UIUtil.isUnderDarcula() ? "#cccccc" : "#333333";
        if (value instanceof TestRecorderEvent) {
            TestRecorderEvent event = (TestRecorderEvent)value;
            renderString = event.isTextChange() ? String.format(TEXT_CHANGE_EVENT_FORMAT, outerDivTextColor, event.getRendererString(), StringEscapeUtils.escapeJava((String)event.getReplacementText())) : (event.isPressEvent() ? String.format(PRESS_EVENT_FORMAT, outerDivTextColor, event.getRendererString()) : (event.isViewLongClick() ? String.format(LONG_CLICK_EVENT_FORMAT, outerDivTextColor, event.getRendererString()) : String.format(CLICK_EVENT_FORMAT, outerDivTextColor, event.getRendererString())));
        } else if (value instanceof TestRecorderAssertion) {
            TestRecorderAssertion assertion = (TestRecorderAssertion)value;
            String assertedText = assertion.getText();
            renderString = assertedText == null ? String.format(ASSERTION_FORMAT_ONE_LINE, outerDivTextColor, assertion.getRendererString(), assertion.getRule()) : String.format(ASSERTION_FORMAT_MULTI_LINE, outerDivTextColor, assertion.getRendererString(), assertion.getRule(), StringEscapeUtils.escapeJava((String)assertedText));
        } else {
            throw new RuntimeException("Unsupported Test Recorder entity: " + value.toString());
        }
        Component component = super.getListCellRendererComponent((JList<?>)list, renderString, index, false, cellHasFocus);
        if (index % 2 != 0) {
            if (UIUtil.isUnderDarcula()) {
                component.setBackground(Color.decode("#333333"));
            } else {
                component.setBackground(Color.decode("#f6f6f6"));
            }
        }
        if (value instanceof TestRecorderAssertion) {
            if (UIUtil.isUnderDarcula()) {
                component.setBackground(Color.decode("#505050"));
            } else {
                component.setBackground(Color.decode("#fffae6"));
            }
        }
        ((JLabel)component).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return component;
    }
}

