/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.ui;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.stats.UsageTracker;
import com.android.tools.idea.templates.SupportLibrary;
import com.android.uiautomator.UiAutomatorModel;
import com.android.uiautomator.tree.BasicTreeNode;
import com.android.uiautomator.tree.UiNode;
import com.google.common.collect.ImmutableList;
import com.google.gct.testrecorder.codegen.TestCodeGenerator;
import com.google.gct.testrecorder.event.ElementDescriptor;
import com.google.gct.testrecorder.event.TestRecorderAssertion;
import com.google.gct.testrecorder.event.TestRecorderEvent;
import com.google.gct.testrecorder.event.TestRecorderEventListener;
import com.google.gct.testrecorder.ui.ScreenshotCallback;
import com.google.gct.testrecorder.ui.ScreenshotPanel;
import com.google.gct.testrecorder.ui.TestClassNameInputDialog;
import com.google.gct.testrecorder.ui.TestRecorderListRenderer;
import com.google.gct.testrecorder.ui.TestRecorderScreenshotTask;
import com.google.gct.testrecorder.util.TestRecorderTracking;
import com.google.gct.testrecorder.util.UiAutomatorNodeHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecordingDialog
extends DialogWrapper
implements TestRecorderEventListener {
    private static final long ANIMATION_INTERVAL = 400L;
    private static final int ANIMATION_TIMER_INTERVAL = 10;
    private static final String ESPRESSO_CORE_CUSTOM_ARTIFACT_NAME = "espresso";
    private static final String ESPRESSO_CORE_CUSTOM_GROUP_NAME = "com.jakewharton.espresso";
    public static final String TEST_INSTRUMENTATION_RUNNER = "android.support.test.runner.AndroidJUnitRunner";
    public static final String ESPRESSO_VERSION = "2.2.2";
    public static final ImmutableList<ArtifactDependencySpec> ESPRESSO_EXCLUDES = ImmutableList.of((Object)new ArtifactDependencySpec(SupportLibrary.SUPPORT_ANNOTATIONS.getArtifactId(), SupportLibrary.SUPPORT_ANNOTATIONS.getGroupId(), null));
    public static final ImmutableList<ArtifactDependencySpec> ESPRESSO_CONTRIB_EXCLUDES = ImmutableList.of((Object)new ArtifactDependencySpec(SupportLibrary.SUPPORT_ANNOTATIONS.getArtifactId(), SupportLibrary.SUPPORT_ANNOTATIONS.getGroupId(), null), (Object)new ArtifactDependencySpec(SupportLibrary.SUPPORT_V4.getArtifactId(), SupportLibrary.SUPPORT_V4.getGroupId(), null), (Object)new ArtifactDependencySpec(SupportLibrary.DESIGN.getArtifactId(), SupportLibrary.DESIGN.getGroupId(), null), (Object)new ArtifactDependencySpec(SupportLibrary.RECYCLERVIEW_V7.getArtifactId(), SupportLibrary.RECYCLERVIEW_V7.getGroupId(), null));
    private static final String RECORDING_DIALOG_TITLE = "Record Your Test";
    private static final String DEFAULT_MESSAGE = "Select an element from screenshot";
    private Project myProject;
    private AndroidFacet myFacet;
    private IDevice myDevice;
    private String myPackageName;
    private final GradleBuildModel myGradleBuildModel;
    private final AndroidGradleModel myAndroidGradleModel;
    private boolean myAssertionMode;
    private int myAssertionIndex;
    private LinkedHashMap<BasicTreeNode, Integer> myNodeIndentMap;
    private DefaultComboBoxModel myElementComboBoxModel;
    private DefaultListModel myEventListModel;
    private JPanel myRootPanel;
    private ScreenshotPanel myScreenshotPanel;
    private JPanel myEventListPanel;
    private JBScrollPane myScrollPane;
    private JBList myEventList;
    private JPanel myAssertionPanel;
    private JPanel myButtonsPanel;
    private JButton myAddAssertionButton;
    private JButton myTakeScreenshotButton;
    private JPanel myEditAssertionPanel;
    private JComboBox myAssertionElementComboBox;
    private JComboBox myAssertionRuleComboBox;
    private JPanel myTextFieldWrapper;
    private JTextField myAssertionTextField;
    private JButton mySaveAssertionButton;
    private JButton myCancelButton;
    private JButton mySaveAssertionAndAddAnotherButton;
    private JButton myCompleteRecordingButton;
    private JPanel myRecordingPanel;
    private JEditorPane myDisclaimerPane;

    public RecordingDialog(AndroidFacet facet, IDevice device, String packageName, final String launchedActivityName) {
        super(facet.getModule().getProject());
        this.$$$setupUI$$$();
        this.myProject = facet.getModule().getProject();
        this.myFacet = facet;
        this.myDevice = device;
        this.myPackageName = packageName;
        this.myAssertionMode = false;
        this.myGradleBuildModel = GradleBuildModel.get((Module)this.myFacet.getModule());
        this.myAndroidGradleModel = AndroidGradleModel.get((AndroidFacet)this.myFacet);
        this.init();
        this.setTitle(RECORDING_DIALOG_TITLE);
        this.getRootPane().setDefaultButton(this.myCompleteRecordingButton);
        this.myTakeScreenshotButton.setVisible(false);
        this.myEventList.setEmptyText("No events recorded yet.");
        this.myEventListModel = new DefaultListModel();
        this.myEventList.setModel((ListModel)this.myEventListModel);
        this.myEventList.setCellRenderer((ListCellRenderer)new TestRecorderListRenderer());
        this.myAddAssertionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new TestRecorderScreenshotTask(RecordingDialog.this.myProject, RecordingDialog.this.myDevice, RecordingDialog.this.myPackageName, new ScreenshotCallback(){

                    @Override
                    public void onSuccess(BufferedImage image, UiAutomatorModel model) {
                        RecordingDialog.this.myAssertionMode = true;
                        RecordingDialog.this.getRootPane().setDefaultButton(RecordingDialog.this.mySaveAssertionButton);
                        RecordingDialog.this.myScreenshotPanel.updateScreenShot(image, model);
                        BasicTreeNode root = RecordingDialog.this.myScreenshotPanel.getModel().getXmlRootNode();
                        RecordingDialog.this.myNodeIndentMap = UiAutomatorNodeHelper.createElementLevelMap(root);
                        RecordingDialog.this.myElementComboBoxModel = new DefaultComboBoxModel<Object>(RecordingDialog.this.myNodeIndentMap.keySet().toArray());
                        RecordingDialog.this.myElementComboBoxModel.insertElementAt(RecordingDialog.DEFAULT_MESSAGE, 0);
                        CardLayout cardLayout = (CardLayout)RecordingDialog.this.myAssertionPanel.getLayout();
                        cardLayout.show(RecordingDialog.this.myAssertionPanel, "myEditAssertionPanel");
                        RecordingDialog.this.setUpEmptyAssertionPanel();
                        RecordingDialog.this.myAssertionIndex = RecordingDialog.this.myEventListModel.size();
                        RecordingDialog.this.revealScreenshotPanel(image.getWidth(), image.getHeight());
                    }
                }).queue();
            }
        });
        this.myTakeScreenshotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.mySaveAssertionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordingDialog.this.exitAssertionMode(true);
                RecordingDialog.this.hideScreenshotPanel();
            }
        });
        this.mySaveAssertionAndAddAnotherButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordingDialog.this.myEventListModel.add(RecordingDialog.this.myAssertionIndex, RecordingDialog.this.buildAssertionForCurrentSelection());
                RecordingDialog.this.myEventList.ensureIndexIsVisible(RecordingDialog.this.myAssertionIndex);
                RecordingDialog.this.myAssertionIndex++;
            }
        });
        this.myCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordingDialog.this.exitAssertionMode(false);
                RecordingDialog.this.hideScreenshotPanel();
            }
        });
        this.myAssertionElementComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Object element = RecordingDialog.this.myAssertionElementComboBox.getSelectedItem();
                if (element instanceof BasicTreeNode) {
                    BasicTreeNode node = (BasicTreeNode)element;
                    RecordingDialog.this.myScreenshotPanel.setSelectedNodeAndRepaint(node);
                    if (UiAutomatorNodeHelper.isTextView(node)) {
                        CardLayout cardLayout = (CardLayout)RecordingDialog.this.myTextFieldWrapper.getLayout();
                        cardLayout.show(RecordingDialog.this.myTextFieldWrapper, "myAssertionTextField");
                        RecordingDialog.this.myAssertionTextField.setText(UiAutomatorNodeHelper.getText(node));
                        RecordingDialog.this.myAssertionRuleComboBox.setModel(new DefaultComboBoxModel<String>(TestRecorderAssertion.ASSERTION_RULES_WITH_TEXT));
                    } else {
                        CardLayout cardLayout = (CardLayout)RecordingDialog.this.myTextFieldWrapper.getLayout();
                        cardLayout.show(RecordingDialog.this.myTextFieldWrapper, "myPlaceHolder");
                        RecordingDialog.this.myAssertionRuleComboBox.setModel(new DefaultComboBoxModel<String>(TestRecorderAssertion.ASSERTION_RULES_WITHOUT_TEXT));
                    }
                    RecordingDialog.this.mySaveAssertionButton.setEnabled(true);
                    RecordingDialog.this.mySaveAssertionAndAddAnotherButton.setEnabled(true);
                    RecordingDialog.this.myAssertionTextField.setForeground((Color)JBColor.BLACK);
                } else {
                    RecordingDialog.this.myScreenshotPanel.clearSelectionAndRepaint();
                }
            }
        });
        this.myAssertionElementComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof BasicTreeNode) {
                    String resourceId;
                    BasicTreeNode node = (BasicTreeNode)value;
                    int indent = (Integer)RecordingDialog.this.myNodeIndentMap.get(node);
                    String prefix = StringUtils.repeat((String)"  ", (int)indent);
                    if (index == -1) {
                        prefix = "";
                    }
                    String nodeString = (resourceId = UiAutomatorNodeHelper.getResourceId(node)).isEmpty() ? UiAutomatorNodeHelper.getClassName(node) : resourceId;
                    return super.getListCellRendererComponent((JList<?>)list, prefix + nodeString, index, isSelected, cellHasFocus);
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this.myAssertionRuleComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String rule = RecordingDialog.this.myAssertionRuleComboBox.getSelectedItem().toString();
                if ("text is".equals(rule)) {
                    CardLayout cardLayout = (CardLayout)RecordingDialog.this.myTextFieldWrapper.getLayout();
                    cardLayout.show(RecordingDialog.this.myTextFieldWrapper, "myAssertionTextField");
                } else {
                    CardLayout cardLayout = (CardLayout)RecordingDialog.this.myTextFieldWrapper.getLayout();
                    cardLayout.show(RecordingDialog.this.myTextFieldWrapper, "myPlaceHolder");
                }
            }
        });
        this.myCompleteRecordingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestClassNameInputDialog chooser = new TestClassNameInputDialog(RecordingDialog.this.myFacet, launchedActivityName);
                chooser.show();
                if (!RecordingDialog.this.hasAllRequiredEspressoDependencies()) {
                    UsageTracker.getInstance().trackEvent("com.google.test.recorder", "missing.espresso.dependencies", TestRecorderTracking.SESSION_LABEL, null);
                    if (Messages.showDialog((Project)RecordingDialog.this.myProject, (String)"This app is missing some dependencies for running Espresso tests.\nWould you like to automatically add Espresso dependencies for this app?\nTo complete the set up, Gradle might ask you to install the missing libraries.\nPlease click on the corresponding link(s) to install them.", (String)"Missing Espresso dependencies", (String[])new String[]{Messages.NO_BUTTON, Messages.YES_BUTTON}, (int)1, null) != 0) {
                        RecordingDialog.this.setupEspresso();
                    }
                }
                ArrayList<Object> events = new ArrayList<Object>();
                for (int i = 0; i < RecordingDialog.this.myEventListModel.size(); ++i) {
                    events.add(RecordingDialog.this.myEventListModel.get(i));
                }
                PsiClass testClass = chooser.getTestClass();
                if (testClass != null) {
                    RecordingDialog.this.doOKAction();
                    new TestCodeGenerator(RecordingDialog.this.myFacet, testClass, events, launchedActivityName, RecordingDialog.this.hasCustomEspressoDependency()).generate();
                }
            }
        });
    }

    private void exitAssertionMode(boolean shouldAddAssertion) {
        this.myAssertionMode = false;
        this.getRootPane().setDefaultButton(this.myCompleteRecordingButton);
        CardLayout cardLayout = (CardLayout)this.myAssertionPanel.getLayout();
        cardLayout.show(this.myAssertionPanel, "myButtonsPanel");
        if (shouldAddAssertion) {
            this.myEventListModel.add(this.myAssertionIndex, this.buildAssertionForCurrentSelection());
            this.myEventList.ensureIndexIsVisible(this.myAssertionIndex);
        } else {
            this.myEventList.ensureIndexIsVisible(this.myEventListModel.size() - 1);
        }
    }

    private void revealScreenshotPanel(int imageWidth, int imageHeight) {
        this.myRecordingPanel.setMinimumSize(new Dimension(this.myRecordingPanel.getWidth(), this.myRecordingPanel.getHeight()));
        this.myScreenshotPanel.setVisible(true);
        final int screenshotPanelTotalHeight = this.myRootPanel.getHeight();
        final int screenshotPanelTotalWidth = imageHeight <= screenshotPanelTotalHeight ? imageWidth : (int)((double)(imageWidth * screenshotPanelTotalHeight) / (double)imageHeight);
        final Timer t = new Timer(10, null);
        final long start = System.currentTimeMillis();
        t.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long elapsed = System.currentTimeMillis() - start;
                if (elapsed > 400L) {
                    RecordingDialog.this.myScreenshotPanel.setMinimumSize(new Dimension(screenshotPanelTotalWidth, screenshotPanelTotalHeight));
                    t.stop();
                } else {
                    double percentRevealed = (double)elapsed / 400.0;
                    RecordingDialog.this.myScreenshotPanel.setMinimumSize(new Dimension((int)((double)screenshotPanelTotalWidth * percentRevealed), screenshotPanelTotalHeight));
                }
                RecordingDialog.this.myScreenshotPanel.clearSelectionAndRepaint();
                RecordingDialog.this.getWindow().pack();
            }
        });
        t.start();
    }

    private void hideScreenshotPanel() {
        final int screenshotPanelInitialWidth = this.myScreenshotPanel.getWidth();
        final int screenshotPanelInitialHeight = this.myScreenshotPanel.getHeight();
        final int marginWidth = ((FlowLayout)this.myScreenshotPanel.getLayout()).getHgap() * 2;
        final int windowInitialWidth = this.getWindow().getWidth();
        final Timer t = new Timer(10, null);
        final long start = System.currentTimeMillis();
        t.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long elapsed = System.currentTimeMillis() - start;
                if (elapsed > 400L) {
                    RecordingDialog.this.myScreenshotPanel.setVisible(false);
                    RecordingDialog.this.myScreenshotPanel.setMinimumSize(new Dimension(0, 0));
                    RecordingDialog.this.getWindow().setMinimumSize(new Dimension(windowInitialWidth - screenshotPanelInitialWidth - marginWidth, RecordingDialog.this.getWindow().getHeight()));
                    t.stop();
                } else {
                    double percentHidden = (double)elapsed / 400.0;
                    RecordingDialog.this.myScreenshotPanel.setMinimumSize(new Dimension((int)((double)screenshotPanelInitialWidth * (1.0 - percentHidden)), screenshotPanelInitialHeight));
                    RecordingDialog.this.getWindow().setMinimumSize(new Dimension(windowInitialWidth - (int)((double)screenshotPanelInitialWidth * percentHidden) - marginWidth, RecordingDialog.this.getWindow().getHeight()));
                }
                RecordingDialog.this.myScreenshotPanel.clearSelectionAndRepaint();
                RecordingDialog.this.getWindow().pack();
            }
        });
        t.start();
    }

    private void createUIComponents() {
        this.myScreenshotPanel = new ScreenshotPanel(this);
        this.myScreenshotPanel.setPreferredSize(new Dimension(0, 0));
        this.myScreenshotPanel.setVisible(false);
        this.myDisclaimerPane = new JEditorPane("text/html", "<html><a href='https://developer.android.com/r/studio-ui/test-recorder.html'>Espresso Test Recorder</a> is currently in beta. Please <a href='https://code.google.com/p/android/issues/entry?template=Espresso%20Test%20Recorder%20Bug'>report any issues</a>.</html>");
        this.myDisclaimerPane.setFont(this.myDisclaimerPane.getFont().deriveFont(12.0f));
        this.linkifyEditorPane(this.myDisclaimerPane, this.myScreenshotPanel.getBackground());
    }

    private void linkifyEditorPane(@NotNull JEditorPane editorPane, @NotNull Color backgroundColor) {
        editorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        editorPane.setEditable(false);
        editorPane.setBackground(backgroundColor);
        editorPane.addHyperlinkListener(this.getHyperlinkListener());
    }

    private HyperlinkListener getHyperlinkListener() {
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(final HyperlinkEvent linkEvent) {
                if (linkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Desktop.getDesktop().browse(linkEvent.getURL().toURI());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        };
    }

    @Nullable
    protected JComponent createSouthPanel() {
        return null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JBDimension initialSize = JBUI.size((int)450, (int)600);
        this.myRootPanel.setPreferredSize((Dimension)initialSize);
        this.myRecordingPanel.setMinimumSize((Dimension)initialSize);
        return this.myRootPanel;
    }

    private boolean hasAllRequiredEspressoDependencies() {
        return !(!this.hasEspressoCoreDependency() && !this.hasCustomEspressoDependency() || this.needsEspressoContribDependency() && !this.hasEspressoContribDependency() || !this.hasSetInstrumentationRunner());
    }

    private boolean needsEspressoContribDependency() {
        for (int i = 0; i < this.myEventListModel.size(); ++i) {
            Object event = this.myEventListModel.get(i);
            if (!(event instanceof TestRecorderEvent) || ((TestRecorderEvent)event).getRecyclerViewPosition() == -1) continue;
            return true;
        }
        return false;
    }

    private boolean hasCustomEspressoDependency() {
        String artifact = "com.jakewharton.espresso:espresso";
        return GradleUtil.dependsOnAndroidTest((AndroidGradleModel)this.myAndroidGradleModel, (String)artifact) || GradleUtil.dependsOn((AndroidGradleModel)this.myAndroidGradleModel, (String)artifact);
    }

    private boolean hasEspressoCoreDependency() {
        String artifact = SupportLibrary.ESPRESSO_CORE.getGroupId() + ":" + SupportLibrary.ESPRESSO_CORE.getArtifactId();
        return GradleUtil.dependsOnAndroidTest((AndroidGradleModel)this.myAndroidGradleModel, (String)artifact) || GradleUtil.dependsOn((AndroidGradleModel)this.myAndroidGradleModel, (String)artifact);
    }

    private boolean hasEspressoContribDependency() {
        String artifact = SupportLibrary.ESPRESSO_CONTRIB.getGroupId() + ":" + SupportLibrary.ESPRESSO_CONTRIB.getArtifactId();
        return GradleUtil.dependsOnAndroidTest((AndroidGradleModel)this.myAndroidGradleModel, (String)artifact) || GradleUtil.dependsOn((AndroidGradleModel)this.myAndroidGradleModel, (String)artifact);
    }

    private boolean hasSetInstrumentationRunner() {
        String testInstrumentationRunner = this.myGradleBuildModel.android().defaultConfig().testInstrumentationRunner();
        return testInstrumentationRunner != null && !testInstrumentationRunner.isEmpty();
    }

    private void setupEspresso() {
        new Task.Modal(this.myProject, "Setting up Espresso", false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setText("Adding Espresso dependencies");
                indicator.setIndeterminate(true);
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> {
                    if (!RecordingDialog.this.hasEspressoCoreDependency() && !RecordingDialog.this.hasCustomEspressoDependency()) {
                        RecordingDialog.this.myGradleBuildModel.dependencies().addArtifact("androidTestCompile", new ArtifactDependencySpec(SupportLibrary.ESPRESSO_CORE.getArtifactId(), SupportLibrary.ESPRESSO_CORE.getGroupId(), RecordingDialog.ESPRESSO_VERSION), ESPRESSO_EXCLUDES);
                    }
                    if (RecordingDialog.this.needsEspressoContribDependency() && !RecordingDialog.this.hasEspressoContribDependency()) {
                        RecordingDialog.this.myGradleBuildModel.dependencies().addArtifact("androidTestCompile", new ArtifactDependencySpec(SupportLibrary.ESPRESSO_CONTRIB.getArtifactId(), SupportLibrary.ESPRESSO_CONTRIB.getGroupId(), RecordingDialog.ESPRESSO_VERSION), ESPRESSO_CONTRIB_EXCLUDES);
                    }
                    if (!RecordingDialog.this.hasSetInstrumentationRunner()) {
                        RecordingDialog.this.myGradleBuildModel.android().defaultConfig().setTestInstrumentationRunner(RecordingDialog.TEST_INSTRUMENTATION_RUNNER);
                    }
                    RecordingDialog.this.myGradleBuildModel.applyChanges();
                    GradleProjectImporter.getInstance().requestProjectSync(this.myProject, null);
                });
            }
        }.queue();
    }

    private TestRecorderAssertion buildAssertionForCurrentSelection() {
        UiNode node = (UiNode)this.myAssertionElementComboBox.getSelectedItem();
        String rule = this.myAssertionRuleComboBox.getSelectedItem().toString();
        TestRecorderAssertion assertion = new TestRecorderAssertion(rule);
        this.addElementDescriptors(assertion, node);
        if ("text is".equals(rule)) {
            assertion.setText(this.myAssertionTextField.getText());
        }
        return assertion;
    }

    private void addElementDescriptors(TestRecorderAssertion assertion, UiNode node) {
        if (node == null || assertion.getElementDescriptorsCount() >= 3) {
            return;
        }
        String className = UiAutomatorNodeHelper.getClassName((BasicTreeNode)node);
        String resourceId = UiAutomatorNodeHelper.getResourceId((BasicTreeNode)node);
        String text = UiAutomatorNodeHelper.isTextView((BasicTreeNode)node) ? UiAutomatorNodeHelper.getText((BasicTreeNode)node) : "";
        String contentDescription = UiAutomatorNodeHelper.getContentDescription((BasicTreeNode)node);
        int childPosition = UiAutomatorNodeHelper.getChildPosition((BasicTreeNode)node);
        if (!(className.isEmpty() && resourceId.isEmpty() && text.isEmpty() && contentDescription.isEmpty() && childPosition == -1)) {
            assertion.addElementDescriptor(new ElementDescriptor(className, childPosition, resourceId, contentDescription, text));
            this.addElementDescriptors(assertion, (UiNode)node.getParent());
        }
    }

    protected void setUpEmptyAssertionPanel() {
        this.myAssertionElementComboBox.setModel(this.myElementComboBoxModel);
        this.myAssertionElementComboBox.setSelectedIndex(0);
        this.myAssertionElementComboBox.setForeground((Color)JBColor.BLACK);
        this.myAssertionRuleComboBox.setModel(new DefaultComboBoxModel());
        CardLayout cardLayout = (CardLayout)this.myTextFieldWrapper.getLayout();
        cardLayout.show(this.myTextFieldWrapper, "myPlaceHolder");
        this.mySaveAssertionButton.setEnabled(false);
        this.mySaveAssertionAndAddAnotherButton.setEnabled(false);
    }

    protected void setUpAssertionPanel(BasicTreeNode node) {
        this.myAssertionElementComboBox.setModel(this.myElementComboBoxModel);
        this.myAssertionElementComboBox.setSelectedItem(node);
        this.myAssertionElementComboBox.setForeground((Color)JBColor.BLACK);
        this.mySaveAssertionButton.setEnabled(true);
        this.mySaveAssertionAndAddAnotherButton.setEnabled(true);
        CardLayout cardLayout = (CardLayout)this.myTextFieldWrapper.getLayout();
        if (UiAutomatorNodeHelper.isTextView(node)) {
            cardLayout.show(this.myTextFieldWrapper, "myAssertionTextField");
            this.myAssertionTextField.setText(UiAutomatorNodeHelper.getText(node));
            this.myAssertionRuleComboBox.setModel(new DefaultComboBoxModel<String>(TestRecorderAssertion.ASSERTION_RULES_WITH_TEXT));
        } else {
            cardLayout.show(this.myTextFieldWrapper, "myPlaceHolder");
            this.myAssertionRuleComboBox.setModel(new DefaultComboBoxModel<String>(TestRecorderAssertion.ASSERTION_RULES_WITHOUT_TEXT));
        }
    }

    public boolean isAssertionMode() {
        return this.myAssertionMode;
    }

    @Override
    public void onEvent(final TestRecorderEvent event) {
        if (!TestRecorderEvent.SUPPORTED_EVENTS.contains(event.getEventType())) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (RecordingDialog.this.myEventListModel.isEmpty()) {
                    RecordingDialog.this.myEventListModel.addElement(event);
                } else {
                    Object lastEvent = RecordingDialog.this.myEventListModel.lastElement();
                    if (lastEvent instanceof TestRecorderEvent && ((TestRecorderEvent)lastEvent).canMerge(event)) {
                        ((TestRecorderEvent)lastEvent).setReplacementText(event.getReplacementText());
                        RecordingDialog.this.myEventList.repaint();
                    } else {
                        RecordingDialog.this.myEventListModel.addElement(event);
                    }
                }
                RecordingDialog.this.myEventList.ensureIndexIsVisible(RecordingDialog.this.myEventList.getItemsCount() - 1);
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JTextField jTextField;
        JPanel jPanel;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JComboBox jComboBox2;
        JPanel jPanel2;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        JPanel jPanel3;
        JPanel jPanel4;
        JBList jBList;
        JBScrollPane jBScrollPane;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7;
        this.createUIComponents();
        this.myRootPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myRecordingPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(596, 306), null));
        this.myEventListPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(539, 132), null));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jPanel5.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(238, 128), null));
        this.myEventList = jBList = new JBList();
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
        this.myAssertionPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new CardLayout(0, 0));
        jPanel6.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 2, 1, 3, 0, null, new Dimension(539, 150), null));
        this.myButtonsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, "myButtonsPanel");
        ((CardLayout)jPanel4.getLayout()).show(jPanel4, "myButtonsPanel");
        this.myAddAssertionButton = jButton6 = new JButton();
        jButton6.setText("Add Assertion");
        jPanel3.add((Component)jButton6, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myTakeScreenshotButton = jButton5 = new JButton();
        jButton5.setText("Take Screenshot");
        jPanel3.add((Component)jButton5, new GridConstraints(1, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JEditorPane jEditorPane = this.myDisclaimerPane;
        jEditorPane.setMargin(new Insets(3, 3, 10, 3));
        jPanel3.add((Component)jEditorPane, new GridConstraints(3, 0, 1, 6, 2, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCompleteRecordingButton = jButton4 = new JButton();
        jButton4.setText("Complete Recording");
        jButton4.setMargin(new Insets(2, 14, 2, 14));
        jPanel3.add((Component)jButton4, new GridConstraints(1, 3, 1, 2, 0, 1, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel8, new GridConstraints(0, 1, 1, 4, 1, 1, 3, 0, new Dimension(-1, 5), new Dimension(-1, 5), new Dimension(-1, 5)));
        this.myEditAssertionPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, "myEditAssertionPanel");
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Edit assertion", 0, 0, null, null));
        this.myAssertionRuleComboBox = jComboBox2 = new JComboBox();
        jPanel2.add(jComboBox2, new GridConstraints(1, 0, 1, 1, 8, 1, 2, 0, null, new Dimension(230, 25), null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel9, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(230, 35), null));
        this.mySaveAssertionButton = jButton3 = new JButton();
        jButton3.setText("Save Assertion");
        jPanel9.add((Component)jButton3, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel9.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCancelButton = jButton2 = new JButton();
        jButton2.setText("Cancel");
        jPanel9.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.mySaveAssertionAndAddAnotherButton = jButton = new JButton();
        jButton.setText("Save and Add Another");
        jPanel9.add((Component)jButton, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myTextFieldWrapper = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(230, 24), null));
        this.myAssertionTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, "myAssertionTextField");
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel10, "myPlaceHolder");
        this.myAssertionElementComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, new Dimension(230, 25), null));
        ScreenshotPanel screenshotPanel = this.myScreenshotPanel;
        jPanel7.add((Component)screenshotPanel, new GridConstraints(0, 1, 1, 1, 4, 2, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

