/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.codegen;

import com.android.resources.ResourceType;
import com.android.utils.Pair;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.gct.testrecorder.codegen.MatcherBuilder;
import com.google.gct.testrecorder.event.ElementAction;
import com.google.gct.testrecorder.event.ElementDescriptor;
import com.google.gct.testrecorder.event.TestRecorderAssertion;
import com.google.gct.testrecorder.event.TestRecorderEvent;
import com.google.gct.testrecorder.util.StringHelper;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.Nullable;

public class TestCodeMapper {
    private static final String VIEW_VARIABLE_CLASS_NAME = "ViewInteraction";
    private final String myApplicationId;
    private final boolean myIsUsingCustomEspresso;
    private final Project myProject;
    @Nullable
    private final AndroidTargetData myAndroidTargetData;
    private boolean myIsChildAtPositionAdded;
    private boolean myIsRecyclerViewActionAdded;
    private final Map<String, Integer> myVariableNameIndexes = Maps.newHashMap();

    public TestCodeMapper(String applicationId, boolean isUsingCustomEspresso, Project project, @Nullable AndroidTargetData androidTargetData) {
        this.myApplicationId = applicationId;
        this.myIsUsingCustomEspresso = isUsingCustomEspresso;
        this.myProject = project;
        this.myAndroidTargetData = androidTargetData;
    }

    public List<String> getTestCodeLinesForEvent(TestRecorderEvent event) {
        LinkedList<String> testCodeLines = new LinkedList<String>();
        if (event.isPressBack()) {
            testCodeLines.add("pressBack();");
            return testCodeLines;
        }
        if (event.isViewClick() && this.isOverflowMenuButton(event.getElementClassName())) {
            testCodeLines.add("openActionBarOverflowOrOptionsMenu(getInstrumentation().getTargetContext());");
            return testCodeLines;
        }
        String variableName = this.addViewPickingStatement(event, testCodeLines);
        if (event.isPressEditorAction()) {
            testCodeLines.add(this.createActionStatement(variableName, "pressImeActionButton()", false));
        } else if (event.isClickEvent()) {
            if (event.getRecyclerViewPosition() != -1) {
                this.myIsRecyclerViewActionAdded = true;
                testCodeLines.add(this.createActionStatement(variableName, "actionOnItemAtPosition(" + event.getRecyclerViewPosition() + ", click())", false));
            } else {
                testCodeLines.add(this.createActionStatement(variableName, event.isViewLongClick() ? "longClick()" : "click()", event.canScrollTo()));
            }
        } else if (event.isTextChange()) {
            if (this.myIsUsingCustomEspresso) {
                testCodeLines.add(this.createActionStatement(variableName, "clearText()", event.canScrollTo()));
                testCodeLines.add(this.createActionStatement(variableName, "typeText(\"" + event.getReplacementText() + "\"), closeSoftKeyboard()", false));
            } else {
                testCodeLines.add(this.createActionStatement(variableName, "replaceText(\"" + event.getReplacementText() + "\"), closeSoftKeyboard()", event.canScrollTo()));
            }
        } else {
            throw new RuntimeException("Unsupported event type: " + event.getEventType());
        }
        return testCodeLines;
    }

    private boolean isOverflowMenuButton(String className) {
        if (StringUtils.isEmpty((String)className)) {
            return false;
        }
        return className.startsWith("android.") && className.endsWith(".widget.ActionMenuPresenter.OverflowMenuButton");
    }

    private String createActionStatement(String variableName, String action, boolean addScrollTo) {
        return variableName + ".perform(" + (addScrollTo ? "scrollTo(), " : "") + action + ");";
    }

    public List<String> getTestCodeLinesForAssertion(TestRecorderAssertion assertion) {
        LinkedList<String> testCodeLines = new LinkedList<String>();
        String rule = assertion.getRule();
        String variableName = this.addViewPickingStatement(assertion, testCodeLines);
        if ("does not exist".equals(rule)) {
            testCodeLines.add(variableName + ".check(doesNotExist());");
        } else if ("exists".equals(rule)) {
            testCodeLines.add(variableName + ".check(matches(isDisplayed()));");
        } else if ("text is".equals(rule)) {
            String text = assertion.getText();
            testCodeLines.add(variableName + ".check(matches(withText(\"" + text + "\")));");
        } else {
            throw new RuntimeException("Unsupported assertion rule: " + rule);
        }
        return testCodeLines;
    }

    private String addViewPickingStatement(ElementAction action, List<String> testCodeLines) {
        String variableName = this.generateVariableNameFromElementClassName(action.getElementClassName());
        testCodeLines.add("ViewInteraction " + variableName + " = onView(\n" + this.generateElementHierarchyConditions(action) + ");");
        return variableName;
    }

    private String generateVariableNameFromElementClassName(@Nullable String elementClassName) {
        if (Strings.isNullOrEmpty((String)elementClassName)) {
            return this.generateVariableNameFromTemplate(VIEW_VARIABLE_CLASS_NAME);
        }
        return this.generateVariableNameFromTemplate(StringHelper.getClassName(elementClassName));
    }

    private String generateVariableNameFromTemplate(String template) {
        Integer unusedIndex;
        String variableName = StringHelper.lowerCaseFirstCharacter(template);
        if (JavaLexer.isKeyword((String)variableName, (LanguageLevel)LanguageLevel.HIGHEST)) {
            variableName = variableName + "_";
        }
        if ((unusedIndex = this.myVariableNameIndexes.get(variableName)) == null) {
            this.myVariableNameIndexes.put(variableName, 2);
            return variableName;
        }
        this.myVariableNameIndexes.put(variableName, unusedIndex + 1);
        return variableName + unusedIndex;
    }

    private String generateElementHierarchyConditions(ElementAction action) {
        List<ElementDescriptor> elementDescriptors = action.getElementDescriptorList();
        if (elementDescriptors.isEmpty()) {
            return "UNKNOWN";
        }
        return this.generateElementHierarchyConditionsRecursively(action instanceof TestRecorderAssertion, !action.canScrollTo(), elementDescriptors, 0);
    }

    private String generateElementHierarchyConditionsRecursively(boolean isAssertionConditions, boolean checkIsDisplayed, List<ElementDescriptor> elementDescriptors, int index) {
        boolean addIsDisplayed = checkIsDisplayed && index == 0;
        ElementDescriptor elementDescriptor = elementDescriptors.get(index);
        MatcherBuilder matcherBuilder = new MatcherBuilder(this.myProject);
        int lastIndex = elementDescriptors.size() - 1;
        if (elementDescriptor.isEmpty() || index == lastIndex && elementDescriptor.isEmptyIgnoringChildPosition() || index == 0 && this.isLoginRadioButton(elementDescriptors)) {
            matcherBuilder.addMatcher(MatcherBuilder.Kind.ClassName, elementDescriptor.getClassName(), true, isAssertionConditions);
        } else {
            String resourceId = elementDescriptor.getResourceId();
            if (this.isAndroidFrameworkPrivateId(resourceId)) {
                matcherBuilder.addMatcher(MatcherBuilder.Kind.ClassName, elementDescriptor.getClassName(), true, isAssertionConditions);
            } else {
                matcherBuilder.addMatcher(MatcherBuilder.Kind.Id, this.convertIdToTestCodeFormat(resourceId), false, isAssertionConditions);
            }
            matcherBuilder.addMatcher(MatcherBuilder.Kind.Text, elementDescriptor.getText(), true, isAssertionConditions);
            matcherBuilder.addMatcher(MatcherBuilder.Kind.ContentDescription, elementDescriptor.getContentDescription(), true, isAssertionConditions);
        }
        if (index == lastIndex) {
            if (matcherBuilder.getMatcherCount() > 1 || addIsDisplayed) {
                return "allOf(" + matcherBuilder.getMatchers() + (addIsDisplayed ? ", isDisplayed()" : "") + ")";
            }
            return matcherBuilder.getMatchers();
        }
        boolean addAllOf = matcherBuilder.getMatcherCount() > 0 || addIsDisplayed;
        int childPosition = elementDescriptor.getChildPosition();
        this.myIsChildAtPositionAdded = this.myIsChildAtPositionAdded || childPosition != -1;
        return (addAllOf ? "allOf(" : "") + matcherBuilder.getMatchers() + (matcherBuilder.getMatcherCount() > 0 ? ",\n" : "") + (childPosition != -1 ? "childAtPosition(\n" : "withParent(") + this.generateElementHierarchyConditionsRecursively(isAssertionConditions, checkIsDisplayed, elementDescriptors, index + 1) + (childPosition != -1 ? ",\n" + childPosition : "") + ")" + (addIsDisplayed ? ",\nisDisplayed()" : "") + (addAllOf ? ")" : "");
    }

    private boolean isAndroidFrameworkPrivateId(String resourceId) {
        Pair<String, String> parsedId = StringHelper.parseId(resourceId);
        return this.myAndroidTargetData != null && parsedId != null && "android".equals(parsedId.getFirst()) && !this.myAndroidTargetData.isResourcePublic(ResourceType.ID.getName(), (String)parsedId.getSecond());
    }

    private boolean isLoginRadioButton(List<ElementDescriptor> elementDescriptors) {
        return elementDescriptors.size() > 1 && elementDescriptors.get(0).getClassName().endsWith(".widget.AppCompatRadioButton") && "R.id.welcome_account_list".equals(this.convertIdToTestCodeFormat(elementDescriptors.get(1).getResourceId()));
    }

    private String convertIdToTestCodeFormat(String resourceId) {
        Pair<String, String> parsedId = StringHelper.parseId(resourceId);
        if (parsedId == null) {
            return resourceId;
        }
        String testCodeId = "R.id." + (String)parsedId.getSecond();
        if (!((String)parsedId.getFirst()).equals(this.myApplicationId)) {
            testCodeId = (String)parsedId.getFirst() + "." + testCodeId;
        }
        return testCodeId;
    }

    public boolean isChildAtPositionAdded() {
        return this.myIsChildAtPositionAdded;
    }

    public boolean isRecyclerViewActionAdded() {
        return this.myIsRecyclerViewActionAdded;
    }
}

