
if (CMAKE_VERSION VERSION_LESS 2.8.3)
    message(FATAL_ERROR "Qt 5 requires at least CMake version 2.8.3")
endif()

get_filename_component(_qt53D_install_prefix "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# For backwards compatibility only. Use Qt53D_VERSION instead.
set(Qt53D_VERSION_STRING 5.2.0)

set(Qt53D_LIBRARIES Qt5::3D)

macro(_qt5_3D_check_file_exists file)
    if(NOT EXISTS "${file}" )
        message(FATAL_ERROR "The imported target \"Qt5::3D\" references the file
   \"${file}\"
but this file does not exist.  Possible reasons include:
* The file was deleted, renamed, or moved to another location.
* An install or uninstall procedure did not complete successfully.
* The installation package was faulty and contained
   \"${CMAKE_CURRENT_LIST_FILE}\"
but not all the files it references.
")
    endif()
endmacro()


macro(_populate_3D_target_properties Configuration LIB_LOCATION IMPLIB_LOCATION)
    set_property(TARGET Qt5::3D APPEND PROPERTY IMPORTED_CONFIGURATIONS ${Configuration})

    set(imported_location "${_qt53D_install_prefix}/lib/${LIB_LOCATION}")
    _qt5_3D_check_file_exists(${imported_location})
    set_target_properties(Qt5::3D PROPERTIES
        "IMPORTED_LINK_INTERFACE_LIBRARIES_${Configuration}" "${_Qt53D_LIB_DEPENDENCIES}"
        "IMPORTED_LOCATION_${Configuration}" ${imported_location}
        "IMPORTED_SONAME_${Configuration}" "libQt53D.so.5"
    )

endmacro()

if (NOT TARGET Qt5::3D)

    set(_Qt53D_OWN_INCLUDE_DIRS "${_qt53D_install_prefix}/include/qt/" "${_qt53D_install_prefix}/include/qt/Qt3D")
    set(Qt53D_PRIVATE_INCLUDE_DIRS
        "${_qt53D_install_prefix}/include/qt/Qt3D/${Qt53D_VERSION_STRING}"
        "${_qt53D_install_prefix}/include/qt/Qt3D/${Qt53D_VERSION_STRING}/Qt3D"
    )

    foreach(_dir ${_Qt53D_OWN_INCLUDE_DIRS}
                 ${Qt53D_PRIVATE_INCLUDE_DIRS}
                 )
        _qt5_3D_check_file_exists(${_dir})
    endforeach()

    set(Qt53D_INCLUDE_DIRS ${_Qt53D_OWN_INCLUDE_DIRS})

    set(Qt53D_DEFINITIONS -DQT_3D_LIB)
    set(Qt53D_COMPILE_DEFINITIONS QT_3D_LIB)

    set(_Qt53D_MODULE_DEPENDENCIES "OpenGL;Gui;Core")

    set(_Qt53D_FIND_DEPENDENCIES_REQUIRED)
    if (Qt53D_FIND_REQUIRED)
        set(_Qt53D_FIND_DEPENDENCIES_REQUIRED REQUIRED)
    endif()
    set(_Qt53D_FIND_DEPENDENCIES_QUIET)
    if (Qt53D_FIND_QUIETLY)
        set(_Qt53D_DEPENDENCIES_FIND_QUIET QUIET)
    endif()
    set(_Qt53D_FIND_VERSION_EXACT)
    if (Qt53D_FIND_VERSION_EXACT)
        set(_Qt53D_FIND_VERSION_EXACT EXACT)
    endif()

    foreach(_module_dep ${_Qt53D_MODULE_DEPENDENCIES})
        if (NOT Qt5${_module_dep}_FOUND)
            find_package(Qt5${_module_dep}
                ${Qt53D_VERSION_STRING} ${_Qt53D_FIND_VERSION_EXACT}
                ${_Qt53D_DEPENDENCIES_FIND_QUIET}
                ${_Qt53D_FIND_DEPENDENCIES_REQUIRED}
                PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
            )
        endif()

        if (NOT Qt5${_module_dep}_FOUND)
            set(Qt53D_FOUND False)
            return()
        endif()

        list(APPEND Qt53D_INCLUDE_DIRS "${Qt5${_module_dep}_INCLUDE_DIRS}")
        list(APPEND Qt53D_PRIVATE_INCLUDE_DIRS "${Qt5${_module_dep}_PRIVATE_INCLUDE_DIRS}")
        list(APPEND Qt53D_DEFINITIONS ${Qt5${_module_dep}_DEFINITIONS})
        list(APPEND Qt53D_COMPILE_DEFINITIONS ${Qt5${_module_dep}_COMPILE_DEFINITIONS})
        list(APPEND Qt53D_EXECUTABLE_COMPILE_FLAGS ${Qt5${_module_dep}_EXECUTABLE_COMPILE_FLAGS})
    endforeach()
    list(REMOVE_DUPLICATES Qt53D_INCLUDE_DIRS)
    list(REMOVE_DUPLICATES Qt53D_PRIVATE_INCLUDE_DIRS)
    list(REMOVE_DUPLICATES Qt53D_DEFINITIONS)
    list(REMOVE_DUPLICATES Qt53D_COMPILE_DEFINITIONS)
    if (Qt53D_EXECUTABLE_COMPILE_FLAGS)
        list(REMOVE_DUPLICATES Qt53D_EXECUTABLE_COMPILE_FLAGS)
    endif()

    set(_Qt53D_LIB_DEPENDENCIES "Qt5::OpenGL;Qt5::Gui;Qt5::Core")

    add_library(Qt5::3D SHARED IMPORTED)

    set_property(TARGET Qt5::3D PROPERTY
      INTERFACE_INCLUDE_DIRECTORIES ${_Qt53D_OWN_INCLUDE_DIRS})
    set_property(TARGET Qt5::3D PROPERTY
      INTERFACE_COMPILE_DEFINITIONS QT_3D_LIB)

    _populate_3D_target_properties(RELEASE "libQt53D.so.5.2.0" "" )






_qt5_3D_check_file_exists("${CMAKE_CURRENT_LIST_DIR}/Qt53DConfigVersion.cmake")

endif()
