#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2016 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxuseradd.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT_MIN=3
PARAMS_COUNT_MAX=7

. "${RestrictedDir}"/nxfunct.sh

isRunByServer

if test -x "/usr/sbin/useradd"; then
  COMMAND_USERADD="/usr/sbin/useradd"
else
  errorCommandNotFound "useradd" "1"
fi

if test -x "/usr/sbin/usermod"; then
  COMMAND_USERMOD="/usr/sbin/usermod"
else
  errorCommandNotFound "usermod" "1"
fi

COMMAND_GROUPADD="/usr/sbin/groupadd"

SET_HOME=""

ADD_UID=""

ADD_GID=""

ADD_HOME="-m"

if test "x$7" != "x"; then
  ADD_HOME=""
fi

if test "x$4" != "x"; then
  SET_HOME="-d $4/$3"
fi

if test "x$5" != "x"; then
  ADD_UID="-u $5 -o"
fi

if [[ $3 == guest* ]]; then
  GROUP="guest"
  ADD_GID="-g ${GROUP}"
elif test "x$6" != "x"; then
  GROUP=$6
  ADD_GID="-g ${GROUP}"
fi

if test "x${GROUP}" != "x"; then
  val=`${COMMAND_CAT} /etc/group | ${COMMAND_GREP} ^${GROUP}:`

  if test "x${val}" = "x"; then
    ${COMMAND_GROUPADD} ${GROUP}

    val=`${COMMAND_CAT} /etc/group | ${COMMAND_GREP} ^${GROUP}:`

    if test "x${val}" = "x"; then
      ${COMMAND_ECHO} "Cannot add group: ${GROUP}"
      exit 1
    fi
  fi
fi

${COMMAND_USERADD} ${SET_HOME} ${ADD_GID} ${ADD_UID} ${ADD_HOME} $3

ret=$?
if test ${ret} != 0; then
  exit ${ret}
fi

${COMMAND_USERMOD} -U $3

if test -f /etc/nscd.conf; then
  if test -x "/usr/sbin/nscd"; then
    COMMAND_NSCD="/usr/sbin/nscd"
  else
    errorCommandNotFound "nscd" "1"
  fi
  ${COMMAND_NSCD} -g >/dev/null
  ret=$?
  if test ${ret} != 0;
  then
    exit 0
  else
    ${COMMAND_NSCD} --invalidate=passwd
  fi
fi

exit $?
