#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2016 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxupdate.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT_MIN=8
PARAMS_COUNT_MAX=12

. "${RestrictedDir}"/nxfunct.sh

isRunByServerOrNode

getNXRoot

if test -d "${NX_ROOT}/../MacOS"; then
  COMMAND_NXCLIENT="${NX_ROOT}/bin/nxclient"
else
  COMMAND_NXCLIENT="${NX_ROOT}/bin/nxclient.bin"
fi

if test ! -x "${COMMAND_NXCLIENT}"; then
  errorCommandNotFound "${COMMAND_NXCLIENT}" "1"
fi

export LD_LIBRARY_PATH="${NX_ROOT}/lib"
export NX_SYSTEM="${NX_ROOT}"
export HOME="$3"
export NX_ROOT="$4"
export NX_CONFIG="$4"
export NX_USER="$5"
export NX_GROUP="$6"

if test "x$7" = "xsilent"; then

  export XAUTHORITY="$8"
  export DISPLAY="$9"
  export PATH="${10}"

  if [ "x${11}" = "x" ];
  then
    exec ${COMMAND_NXCLIENT} --update check --silent
  else
    exec ${COMMAND_NXCLIENT} --update check --silent --ignore "${11}"
  fi

else

  if [ "x$8" = "xcheck" ] || [ "x$8" = "xdownload" ] || [ "x$8" = "xinstall" ];
  then
    MODE="$8"

    exec ${COMMAND_NXCLIENT} --update ${MODE} --background

  elif [ "x$8" = "xask" ];
  then
    MODE="$8"
    export PATH="$9"
    ROOT_PATH="${10}"
    export XAUTHORITY="${11}"
    export DISPLAY="${12}"

    exec ${COMMAND_NXCLIENT} --update ${MODE} --background --root "${ROOT_PATH}"

  else
    errorMsg "Wrong parameter mode." "1"
  fi

fi
