#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2016 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxprinterdel.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=4

. "${RestrictedDir}"/nxfunct.sh

isRunByNode

LPADMIN_TIMEOUT=40

USER=$3
NAME=$4

isEnabledCUPSSupport

getCUPSSbin

EXS_USER=`${COMMAND_WHOAMI}`

if test "x${USER}" = "x";
then
  errorMsg "Argument username cannot be empty." "1"
fi

if test "${PARENT_USER}" != "${USER}" -o "${EXS_USER}" != "${USER}"; then
  errorMsg "You can add or delete printer only for yourself." "1"
fi

if test "x${NAME}" = "x";
then
  errorMsg "Argument printer name cannot be empty." "1"
fi

if test $# -eq 6; then

  if test "x${MODEL}" = "x"; then
    errorMsg "Argument driver name cannot be empty." "1"
  fi

  if test "x${PUBLIC}" = "x"; then
    errorMsg "Argument address cannot be empty." "1"
  fi
fi

#export GATEWAY_INTERFACE="CGI/1.1"

${LPADMIN} -x "${NAME}" &
lpPid=$!

(
  i=${LPADMIN_TIMEOUT}
  while [ $i -gt 0 ]; do
    ${COMMAND_KILL} -0 ${lpPid} 2>/dev/null
    if test $? -ne 0; then
      exit
    fi
    i=`${COMMAND_EXPR} $i - 1`
    if test $i -gt 30; then
      ${COMMAND_SLEEP} 0.01
    else
      ${COMMAND_SLEEP} 1
    fi
  done
  errorMsg "Timeout of ${LPADMIN_TIMEOUT} seconds when running lpadmin: killing lpadmin."
  ${COMMAND_KILL} -9 ${lpPid} 2>/dev/null
) &

wait ${lpPid} 2>/dev/null
