#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2016 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxportandcookieget.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=3

. "${RestrictedDir}"/nxfunct.sh


isRunByNodeOrPlayer

DIRECTORY_PATH="$3"

if [ -e "/bin/cat" ];
then
  COMMAND_CAT="/bin/cat"
elif [ -e "/usr/bin/cat" ];
then
  COMMAND_CAT="/usr/bin/cat"
else
  errorMsg "cat command not found." "1"
  exit 1
fi

if test "x${DIRECTORY_PATH}" = "x"; then
  errorMsg "Missing command directory parameter." "1"
  exit 1
fi

if [ ! -e "${DIRECTORY_PATH}" ]; then
  errorMsg "${DIRECTORY_PATH} not found." "1"
  exit 1
fi

if [ ! -e "${DIRECTORY_PATH}/cookie" ]; then
  errorMsg "${DIRECTORY_PATH}/cookie not found." "1"
  exit 1
fi

if [ ! -e "${DIRECTORY_PATH}/port" ]; then
  errorMsg "${DIRECTORY_PATH}/port not found." "1"
  exit 1
fi

${COMMAND_CAT} "${DIRECTORY_PATH}/port"
echo ""
${COMMAND_CAT} "${DIRECTORY_PATH}/cookie"
