#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2016 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxmountdel.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=4

. "${RestrictedDir}"/nxfunct.sh

isRunByNode

if test -x "/bin/umount"; then
  COMMAND_UMOUNT="/bin/umount"
elif test -x "/sbin/umount"; then
  COMMAND_UMOUNT="/sbin/umount"
elif test -x "/usr/sbin/umount"; then
  COMMAND_UMOUNT="/usr/sbin/umount"
elif test -x "/usr/bin/umount"; then
  COMMAND_UMOUNT="/usr/bin/umount"
elif test -x "/usr/local/bin/umount"; then
  COMMAND_UMOUNT="/usr/local/bin/umount"
elif test -x "/usr/local/sbin/umount"; then
  COMMAND_UMOUNT="/usr/local/sbin/umount"
else
  errorCommandNotFound "umount" "1"
fi

MOUNT_DIR=`${COMMAND_ECHO} $3 | ${COMMAND_SED} -e 's/'%28'/\(/g' | ${COMMAND_SED} -e 's/'%29'/\)/g'`
MOUNT_DIR=`${COMMAND_ECHO} ${MOUNT_DIR} | ${COMMAND_SED} -e 's/'%5B'/\[/g' | ${COMMAND_SED} -e 's/'%5D'/\]/g'`

if test "x$4" != "x-l"; then
  exec ${COMMAND_UMOUNT} "${MOUNT_DIR}"
else
  exec ${COMMAND_UMOUNT} -l "${MOUNT_DIR}"
fi
