#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2016 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxcookieget.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=6

. "${RestrictedDir}"/nxfunct.sh


isRunByServerOrNode

COMMAND_XAUTH="$3"
USERNAME="$4"
DISPLAY="$5"
GLOBALXAUTHORITY="$6"

if test "x${COMMAND_XAUTH}" = "x"; then
  errorMsg "Missing command xauth parameter." "1"
fi

if test ! -x "${COMMAND_XAUTH}"; then
  errorCommandNotFound "${COMMAND_XAUTH}" "1"
fi

if test "x${GLOBALXAUTHORITY}" = "xempty"; then
  GLOBALXAUTHORITY=""
fi

if test `${COMMAND_ECHO} "${COMMAND_XAUTH}" | ${COMMAND_GREP} nxauth`; then
  if test "x${GLOBALXAUTHORITY}" != "x"; then
    LD_LIBRARY_PATH="${NX_ROOT}/lib":"${NX_ROOT}/lib/perl":${LD_LIBRARY_PATH} XAUTHORITY=${GLOBALXAUTHORITY} ${COMMAND_XAUTH} -ni list
  else
    ${COMMAND_SU} - ${USERNAME} -c "LD_LIBRARY_PATH=\"${NX_ROOT}/lib\":\"${NX_ROOT}/lib/perl\":${LD_LIBRARY_PATH} ${COMMAND_XAUTH} -ni list :${DISPLAY}"
  fi
else
  if test "x${GLOBALXAUTHORITY}" != "x"; then
    XAUTHORITY=${GLOBALXAUTHORITY} ${COMMAND_XAUTH} -ni list
  else
    ${COMMAND_SU} - ${USERNAME} -c "${COMMAND_XAUTH} -ni list :${DISPLAY}"
  fi
fi
