#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2016 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxamixer.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=5

. "${RestrictedDir}"/nxfunct.sh

isRunByServerOrNode

COMMAND_AMIXER="none"

if [ -x "/bin/amixer" ];
then
  COMMAND_AMIXER="/bin/amixer"
elif [ -x "/usr/bin/amixer" ];
then
  COMMAND_AMIXER="/usr/bin/amixer"
elif [ -x "/usr/sbin/amixer" ];
then
  COMMAND_AMIXER="/usr/sbin/amixer"
elif [ -x "/usr/local/bin/amixer" ];
then
  COMMAND_AMIXER="/usr/local/bin/amixer"
fi

if [ "$COMMAND_AMIXER" = "none" ];
then
  exit 1
fi

ACTION="$3"
IDS="$4"
VOLUMES="$5"

RETIDS=""
RETVOLUMES=""

RET=1

if [ "x$ACTION" = "xmute" ];
then

  for dev in $($COMMAND_LS /dev/snd | $COMMAND_GREP controlC | $COMMAND_SED -e 's/controlC//g');
  do

    AMXOUT=`$COMMAND_AMIXER -c $dev get PCM 2> /dev/null`

    if [ "$?" = "0" ];
    then
      if [ "x$RETIDS" = "x" ];
      then
        RETIDS=$dev
      else
        RETIDS="$RETIDS,$dev"
      fi

      vol=`$COMMAND_ECHO "$AMXOUT" | $COMMAND_GREP -m 1 % | $COMMAND_SED -e 's/%\].*//g' | $COMMAND_SED -e 's/.*Playback.*\[//g'`

      if [ "x$RETVOLUMES" = "x" ];
      then
        RETVOLUMES=$vol
      else
        RETVOLUMES="$RETVOLUMES,$vol"
      fi

      $COMMAND_AMIXER -c $dev set PCM 0% 2>&1 1>/dev/null

      RET=0
    fi

  done

  $COMMAND_ECHO $RETIDS $RETVOLUMES

elif [ "x$ACTION" = "xunmute" ];
then

  COUNT=0
  ARRID[$COUNT]=""

  for id in ${IDS//,/ };
  do
    ARRID[$COUNT]=$id

    COUNT=$((COUNT + 1))
  done

  COUNT=0

  for vol in ${VOLUMES//,/ };
  do
    $COMMAND_AMIXER -c ${ARRID[$COUNT]} set PCM $vol% 2>&1 1>/dev/null

    COUNT=$((COUNT + 1))
  done

  RET=0

fi

exit $RET
