#!/bin/bash
######################################################################
#                                                                    #
#  Copyright (c) 2001, 2016 NoMachine, http://www.nomachine.com.     #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

RunDir=${0%nxgroupadd.sh}
RestrictedDir=$(cd "${RunDir}" && pwd)

PARAMS_COUNT=3

. "${RestrictedDir}"/nxfunct.sh

isRunByServer

COMMAND_NSCD="/usr/sbin/nscd"

COMMAND_GROUPADD="/usr/sbin/groupadd"
if test ! -x ${COMMAND_GROUPADD}; then
  errorCommandNotFound "${COMMAND_GROUPADD}" "1"
fi

${COMMAND_GROUPADD} $3 && exit 1

if test -x ${COMMAND_NSCD}; then
  if test -f /etc/nscd.conf; then
    ${COMMAND_NSCD} -i group
  fi
fi

exit 0
