#!perl
######################################################################
#                                                                    #
#  Copyright (c) 2012, 2016 NoMachine, http://www.nomachine.com.    #
#                                                                    #
#  All rights reserved.                                              #
#                                                                    #
######################################################################

my $weight       = -1;
my $nodeSelected = undef;

if (! @ARGV)
{
  #
  # Return empty message and exit.
  #

  print "\n";
  exit 1;
}


my @nodeList = split(/#/,$ARGV[0]);

foreach my $node (@nodeList)
{
  if (! $node)
  {
    next;
  }
  elsif (! $nodeSelected)
  {
    #
    # Initialize node.
    #
    
    $nodeSelected = (split(/,/,$node))[0] || undef;
  }

  #
  #  $nodeName           - it's the host:port pair qualifying the node
  #                        as it is in output of 'nxserver --nodelist' command
  #  $nodeWeight         - it's the weight, a numeric value, attributed to the node.
  #  $nodeSessionRunning - it's the number of sessions connected to the node.
  #  $nodeConnectionLimit   - it's the maximum number of connections allowed on that node.
  #

  my ($nodeName, $nodeWeight, $nodeSessionRunning, $nodeConnectionLimit) = split(/,/,$node);

  if (($nodeConnectionLimit != 0) && ($nodeSessionRunning >= $nodeConnectionLimit))
  {
    #
    # Ignore the node if maximum number of connections is reached for that 
    # node. Unlimited connections are allowed on that node if variable
    # $nodeConnectionLimit is set to 0. 
    #

    next;
  }

  if ($weight >= ($nodeWeight - $nodeSessionRunning))
  {
    #
    #  Select first node with highest weight.
    #

    next;
  }

  #
  # Count new weight.
  #

  $weight = $nodeWeight - $nodeSessionRunning;

  #
  # Set new node.
  #

  $nodeSelected = $nodeName;
}

if (! $nodeSelected)
{
  print "\n";
  exit 1;
}

#
# Return selected node to nxserver.
#

print "$nodeSelected\n";

exit 0;
