# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.Tpetra is the python interface to the Trilinos linear
algebra services package Tpetra:

    http://trilinos.sandia.gov/packages/tpetra

The purpose of Tpetra is to provide fundamental linear algebra
services to the rest of Trilinos.  These services include parallel
decomposition and communication, vectors and multivectors, graphs,
operators, and dense and sparse matrices.

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Tpetra')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Tpetra')
    _Tpetra = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Tpetra', [dirname(__file__)])
        except ImportError:
            import _Tpetra
            return _Tpetra
        try:
            _mod = imp.load_module('_Tpetra', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Tpetra = swig_import_helper()
    del swig_import_helper
else:
    import _Tpetra
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Tpetra.delete_SwigPyIterator

    def value(self, *args):
        """value(SwigPyIterator self) -> PyObject *"""
        return _Tpetra.SwigPyIterator_value(self, *args)


    def incr(self, *args):
        """incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _Tpetra.SwigPyIterator_incr(self, *args)


    def decr(self, *args):
        """decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _Tpetra.SwigPyIterator_decr(self, *args)


    def distance(self, *args):
        """distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _Tpetra.SwigPyIterator_distance(self, *args)


    def equal(self, *args):
        """equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Tpetra.SwigPyIterator_equal(self, *args)


    def copy(self, *args):
        """copy(SwigPyIterator self) -> SwigPyIterator"""
        return _Tpetra.SwigPyIterator_copy(self, *args)


    def next(self, *args):
        """next(SwigPyIterator self) -> PyObject *"""
        return _Tpetra.SwigPyIterator_next(self, *args)


    def __next__(self, *args):
        """__next__(SwigPyIterator self) -> PyObject *"""
        return _Tpetra.SwigPyIterator___next__(self, *args)


    def previous(self, *args):
        """previous(SwigPyIterator self) -> PyObject *"""
        return _Tpetra.SwigPyIterator_previous(self, *args)


    def advance(self, *args):
        """advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Tpetra.SwigPyIterator_advance(self, *args)


    def __eq__(self, *args):
        """__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Tpetra.SwigPyIterator___eq__(self, *args)


    def __ne__(self, *args):
        """__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Tpetra.SwigPyIterator___ne__(self, *args)


    def __iadd__(self, *args):
        """__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Tpetra.SwigPyIterator___iadd__(self, *args)


    def __isub__(self, *args):
        """__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Tpetra.SwigPyIterator___isub__(self, *args)


    def __add__(self, *args):
        """__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Tpetra.SwigPyIterator___add__(self, *args)


    def __sub__(self, *args):
        """
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _Tpetra.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = _Tpetra.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)


import numpy

import PyTrilinos.Teuchos

def class_array_inplace_op(self, op_str, other):
  in_op = getattr(self.array, "__i"+op_str+"__")
  in_op(other.array)
  return self

def class_array_math_op(self, op_str, other):
# Initialize the result by calling the copy constructor
  result = self.__class__(self)
# Get the equivalent in-place operator for the result
  in_op = getattr(result.array, "__i"+op_str+"__")
  try:
    in_op(other.array)
  except AttributeError:
    in_op(other)
  return result

def class_array_rmath_op(self, op_str, other):
# Initialize the result by calling the copy constructor
  result = self.__class__(self)
  indices = (slice(None),) * len(self.array.shape)
  result.array[indices] = other
  in_op = getattr(result.array, "__i"+op_str+"__")
  in_op(self.array)
  return result

def class_array_add_math_ops(cls, op_str):
  setattr(cls,
          "__i"+op_str+"__",
          lambda self, other: class_array_inplace_op(self, op_str, other))
  setattr(cls,
          "__"+op_str+"__",
          lambda self, other: class_array_math_op(self, op_str, other))
  setattr(cls,
          "__r"+op_str+"__",
          lambda self, other: class_array_rmath_op(self, op_str, other))

def class_array_add_math(cls):
  class_array_add_math_ops(cls, "add")
  class_array_add_math_ops(cls, "sub")
  class_array_add_math_ops(cls, "mul")
  class_array_add_math_ops(cls, "add")

def class_array_comp_op(self, op_str, other):
  comp_op = getattr(self.array, "__"+op_str+"__")
  try:
    return comp_op(other.array)
  except AttributeError:
    return comp_op(other)

def class_array_add_comp_op(cls, op_str):
  setattr(cls,
          "__"+op_str+"__",
          lambda self, other: class_array_comp_op(self, op_str, other))

def class_array_add_comp(cls):
  class_array_add_comp_op(cls, "lt")
  class_array_add_comp_op(cls, "le")
  class_array_add_comp_op(cls, "eq")
  class_array_add_comp_op(cls, "ne")
  class_array_add_comp_op(cls, "gt")
  class_array_add_comp_op(cls, "ge")


KOKKOS_HAVE_CXX11_DISPATCH_LAMBDA = _Tpetra.KOKKOS_HAVE_CXX11_DISPATCH_LAMBDA
KOKKOS_HAVE_PRAGMA_UNROLL = _Tpetra.KOKKOS_HAVE_PRAGMA_UNROLL
KOKKOS_HAVE_PRAGMA_IVDEP = _Tpetra.KOKKOS_HAVE_PRAGMA_IVDEP
KOKKOS_HAVE_PRAGMA_LOOPCOUNT = _Tpetra.KOKKOS_HAVE_PRAGMA_LOOPCOUNT
KOKKOS_HAVE_PRAGMA_VECTOR = _Tpetra.KOKKOS_HAVE_PRAGMA_VECTOR
KOKKOS_HAVE_PRAGMA_SIMD = _Tpetra.KOKKOS_HAVE_PRAGMA_SIMD
TPETRA_THROWS_EFFICIENCY_WARNINGS = _Tpetra.TPETRA_THROWS_EFFICIENCY_WARNINGS
TPETRA_PRINTS_EFFICIENCY_WARNINGS = _Tpetra.TPETRA_PRINTS_EFFICIENCY_WARNINGS
TPETRA_THROWS_ABUSE_WARNINGS = _Tpetra.TPETRA_THROWS_ABUSE_WARNINGS
TPETRA_PRINTS_ABUSE_WARNINGS = _Tpetra.TPETRA_PRINTS_ABUSE_WARNINGS
LocallyReplicated = _Tpetra.LocallyReplicated
GloballyDistributed = _Tpetra.GloballyDistributed
AllIDsPresent = _Tpetra.AllIDsPresent
IDNotPresent = _Tpetra.IDNotPresent
StaticProfile = _Tpetra.StaticProfile
DynamicProfile = _Tpetra.DynamicProfile
DoOptimizeStorage = _Tpetra.DoOptimizeStorage
DoNotOptimizeStorage = _Tpetra.DoNotOptimizeStorage
COMPUTE_VIEW_CONSTRUCTOR = _Tpetra.COMPUTE_VIEW_CONSTRUCTOR
HOST_VIEW_CONSTRUCTOR = _Tpetra.HOST_VIEW_CONSTRUCTOR
Forward = _Tpetra.Forward
Backward = _Tpetra.Backward
Symmetric = _Tpetra.Symmetric
TPETRA_USE_KOKKOS_DISTOBJECT = _Tpetra.TPETRA_USE_KOKKOS_DISTOBJECT
ADD = _Tpetra.ADD
INSERT = _Tpetra.INSERT
REPLACE = _Tpetra.REPLACE
ABSMAX = _Tpetra.ABSMAX
ZERO = _Tpetra.ZERO

def setCombineModeParameter(*args):
    """setCombineModeParameter(ParameterList plist, std::string const & paramName)"""
    return _Tpetra.setCombineModeParameter(*args)

def version(*args):
    """version() -> std::string"""
    return _Tpetra.version(*args)

__version__ = version()

HAVE_TPETRA_FIXED_HASH_TABLE = _Tpetra.HAVE_TPETRA_FIXED_HASH_TABLE
class Map_default(PyTrilinos.Teuchos.Describable):
    """Proxy of C++ Tpetra::Map<(int,long long,DefaultNodeType)> class."""

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.Teuchos.Describable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Map_default, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.Teuchos.Describable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Map_default, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _Tpetra.delete_Map_default

    def isOneToOne(self, *args):
        """isOneToOne(Map_default self) -> bool"""
        return _Tpetra.Map_default_isOneToOne(self, *args)


    def getGlobalNumElements(self, *args):
        """getGlobalNumElements(Map_default self) -> Tpetra::global_size_t"""
        return _Tpetra.Map_default_getGlobalNumElements(self, *args)


    def getNodeNumElements(self, *args):
        """getNodeNumElements(Map_default self) -> size_t"""
        return _Tpetra.Map_default_getNodeNumElements(self, *args)


    def getIndexBase(self, *args):
        """getIndexBase(Map_default self) -> long long"""
        return _Tpetra.Map_default_getIndexBase(self, *args)


    def getMinLocalIndex(self, *args):
        """getMinLocalIndex(Map_default self) -> int"""
        return _Tpetra.Map_default_getMinLocalIndex(self, *args)


    def getMaxLocalIndex(self, *args):
        """getMaxLocalIndex(Map_default self) -> int"""
        return _Tpetra.Map_default_getMaxLocalIndex(self, *args)


    def getMinGlobalIndex(self, *args):
        """getMinGlobalIndex(Map_default self) -> long long"""
        return _Tpetra.Map_default_getMinGlobalIndex(self, *args)


    def getMaxGlobalIndex(self, *args):
        """getMaxGlobalIndex(Map_default self) -> long long"""
        return _Tpetra.Map_default_getMaxGlobalIndex(self, *args)


    def getMinAllGlobalIndex(self, *args):
        """getMinAllGlobalIndex(Map_default self) -> long long"""
        return _Tpetra.Map_default_getMinAllGlobalIndex(self, *args)


    def getMaxAllGlobalIndex(self, *args):
        """getMaxAllGlobalIndex(Map_default self) -> long long"""
        return _Tpetra.Map_default_getMaxAllGlobalIndex(self, *args)


    def getLocalMap(self, *args):
        """getLocalMap(Map_default self) -> Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::local_map_type"""
        return _Tpetra.Map_default_getLocalMap(self, *args)


    def getNodeElementList(self, *args):
        """getNodeElementList(Map_default self) -> Teuchos::ArrayView< long long const >"""
        return _Tpetra.Map_default_getNodeElementList(self, *args)


    def isNodeLocalElement(self, *args):
        """isNodeLocalElement(Map_default self, int localIndex) -> bool"""
        return _Tpetra.Map_default_isNodeLocalElement(self, *args)


    def isNodeGlobalElement(self, *args):
        """isNodeGlobalElement(Map_default self, long long globalIndex) -> bool"""
        return _Tpetra.Map_default_isNodeGlobalElement(self, *args)


    def isUniform(self, *args):
        """isUniform(Map_default self) -> bool"""
        return _Tpetra.Map_default_isUniform(self, *args)


    def isContiguous(self, *args):
        """isContiguous(Map_default self) -> bool"""
        return _Tpetra.Map_default_isContiguous(self, *args)


    def isDistributed(self, *args):
        """isDistributed(Map_default self) -> bool"""
        return _Tpetra.Map_default_isDistributed(self, *args)


    def isCompatible(self, *args):
        """isCompatible(Map_default self, Map_default map) -> bool"""
        return _Tpetra.Map_default_isCompatible(self, *args)


    def isSameAs(self, *args):
        """isSameAs(Map_default self, Map_default map) -> bool"""
        return _Tpetra.Map_default_isSameAs(self, *args)


    def locallySameAs(self, *args):
        """locallySameAs(Map_default self, Map_default map) -> bool"""
        return _Tpetra.Map_default_locallySameAs(self, *args)


    def getComm(self, *args):
        """getComm(Map_default self) -> Teuchos::RCP< Teuchos::Comm< int > const >"""
        return _Tpetra.Map_default_getComm(self, *args)


    def getNode(self, *args):
        """getNode(Map_default self) -> Teuchos::RCP< KokkosClassic::DefaultNode::DefaultNodeType >"""
        return _Tpetra.Map_default_getNode(self, *args)


    def description(self, *args):
        """description(Map_default self) -> std::string"""
        return _Tpetra.Map_default_description(self, *args)


    def describe(self, *args):
        """describe(Map_default self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)"""
        return _Tpetra.Map_default_describe(self, *args)


    def removeEmptyProcesses(self, *args):
        """removeEmptyProcesses(Map_default self) -> RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >"""
        return _Tpetra.Map_default_removeEmptyProcesses(self, *args)


    def replaceCommWithSubset(self, *args):
        """replaceCommWithSubset(Map_default self, Teuchos::RCP< Teuchos::Comm< int > const > const & newComm) -> RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >"""
        return _Tpetra.Map_default_replaceCommWithSubset(self, *args)


    def __str__(self, *args):
        """__str__(Map_default self) -> std::string"""
        return _Tpetra.Map_default___str__(self, *args)

Map_default_swigregister = _Tpetra.Map_default_swigregister
Map_default_swigregister(Map_default)


Map = Map_default

class Transfer_default(PyTrilinos.Teuchos.Describable):
    """Proxy of C++ Tpetra::Details::Transfer<(int,long long,DefaultNodeType)> class."""

    __swig_setmethods__ = {}
    for _s in [PyTrilinos.Teuchos.Describable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Transfer_default, name, value)
    __swig_getmethods__ = {}
    for _s in [PyTrilinos.Teuchos.Describable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Transfer_default, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Tpetra.delete_Transfer_default

    def getNumSameIDs(self, *args):
        """getNumSameIDs(Transfer_default self) -> size_t"""
        return _Tpetra.Transfer_default_getNumSameIDs(self, *args)


    def getNumPermuteIDs(self, *args):
        """getNumPermuteIDs(Transfer_default self) -> size_t"""
        return _Tpetra.Transfer_default_getNumPermuteIDs(self, *args)


    def getPermuteFromLIDs(self, *args):
        """getPermuteFromLIDs(Transfer_default self) -> Teuchos::ArrayView< int const >"""
        return _Tpetra.Transfer_default_getPermuteFromLIDs(self, *args)


    def getPermuteToLIDs(self, *args):
        """getPermuteToLIDs(Transfer_default self) -> Teuchos::ArrayView< int const >"""
        return _Tpetra.Transfer_default_getPermuteToLIDs(self, *args)


    def getNumRemoteIDs(self, *args):
        """getNumRemoteIDs(Transfer_default self) -> size_t"""
        return _Tpetra.Transfer_default_getNumRemoteIDs(self, *args)


    def getRemoteLIDs(self, *args):
        """getRemoteLIDs(Transfer_default self) -> Teuchos::ArrayView< int const >"""
        return _Tpetra.Transfer_default_getRemoteLIDs(self, *args)


    def getNumExportIDs(self, *args):
        """getNumExportIDs(Transfer_default self) -> size_t"""
        return _Tpetra.Transfer_default_getNumExportIDs(self, *args)


    def getExportLIDs(self, *args):
        """getExportLIDs(Transfer_default self) -> Teuchos::ArrayView< int const >"""
        return _Tpetra.Transfer_default_getExportLIDs(self, *args)


    def getExportPIDs(self, *args):
        """getExportPIDs(Transfer_default self) -> Teuchos::ArrayView< int const >"""
        return _Tpetra.Transfer_default_getExportPIDs(self, *args)


    def getSourceMap(self, *args):
        """getSourceMap(Transfer_default self) -> Teuchos::RCP< Tpetra::Details::Transfer< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const >"""
        return _Tpetra.Transfer_default_getSourceMap(self, *args)


    def getTargetMap(self, *args):
        """getTargetMap(Transfer_default self) -> Teuchos::RCP< Tpetra::Details::Transfer< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const >"""
        return _Tpetra.Transfer_default_getTargetMap(self, *args)


    def getDistributor(self, *args):
        """getDistributor(Transfer_default self) -> ::Tpetra::Distributor &"""
        return _Tpetra.Transfer_default_getDistributor(self, *args)

Transfer_default_swigregister = _Tpetra.Transfer_default_swigregister
Transfer_default_swigregister(Transfer_default)

class Export_default(Transfer_default):
    """Proxy of C++ Tpetra::Export<(int,long long,DefaultNodeType)> class."""

    __swig_setmethods__ = {}
    for _s in [Transfer_default]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Export_default, name, value)
    __swig_getmethods__ = {}
    for _s in [Transfer_default]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Export_default, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Tpetra::Export<(int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & source, Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & target) -> Export_default
        __init__(Tpetra::Export<(int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & source, Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & target, RCP< Teuchos::FancyOStream > const & out) -> Export_default
        __init__(Tpetra::Export<(int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & source, Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & target, Teuchos::RCP< Teuchos::ParameterList > const & plist) -> Export_default
        __init__(Tpetra::Export<(int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & source, Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & target, RCP< Teuchos::FancyOStream > const & out, Teuchos::RCP< Teuchos::ParameterList > const & plist) -> Export_default
        __init__(Tpetra::Export<(int,long long,DefaultNodeType)> self, Export_default rhs) -> Export_default
        __init__(Tpetra::Export<(int,long long,DefaultNodeType)> self, Import_default importer) -> Export_default
        """
        this = _Tpetra.new_Export_default(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Tpetra.delete_Export_default

    def setParameterList(self, *args):
        """setParameterList(Export_default self, Teuchos::RCP< Teuchos::ParameterList > const & plist)"""
        return _Tpetra.Export_default_setParameterList(self, *args)


    def getNumSameIDs(self, *args):
        """getNumSameIDs(Export_default self) -> size_t"""
        return _Tpetra.Export_default_getNumSameIDs(self, *args)


    def getNumPermuteIDs(self, *args):
        """getNumPermuteIDs(Export_default self) -> size_t"""
        return _Tpetra.Export_default_getNumPermuteIDs(self, *args)


    def getPermuteFromLIDs(self, *args):
        """getPermuteFromLIDs(Export_default self) -> ArrayView< int const >"""
        return _Tpetra.Export_default_getPermuteFromLIDs(self, *args)


    def getPermuteToLIDs(self, *args):
        """getPermuteToLIDs(Export_default self) -> ArrayView< int const >"""
        return _Tpetra.Export_default_getPermuteToLIDs(self, *args)


    def getNumRemoteIDs(self, *args):
        """getNumRemoteIDs(Export_default self) -> size_t"""
        return _Tpetra.Export_default_getNumRemoteIDs(self, *args)


    def getRemoteLIDs(self, *args):
        """getRemoteLIDs(Export_default self) -> ArrayView< int const >"""
        return _Tpetra.Export_default_getRemoteLIDs(self, *args)


    def getNumExportIDs(self, *args):
        """getNumExportIDs(Export_default self) -> size_t"""
        return _Tpetra.Export_default_getNumExportIDs(self, *args)


    def getExportLIDs(self, *args):
        """getExportLIDs(Export_default self) -> ArrayView< int const >"""
        return _Tpetra.Export_default_getExportLIDs(self, *args)


    def getExportPIDs(self, *args):
        """getExportPIDs(Export_default self) -> ArrayView< int const >"""
        return _Tpetra.Export_default_getExportPIDs(self, *args)


    def getSourceMap(self, *args):
        """getSourceMap(Export_default self) -> Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const >"""
        return _Tpetra.Export_default_getSourceMap(self, *args)


    def getTargetMap(self, *args):
        """getTargetMap(Export_default self) -> Teuchos::RCP< Tpetra::Export< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const >"""
        return _Tpetra.Export_default_getTargetMap(self, *args)


    def getDistributor(self, *args):
        """getDistributor(Export_default self) -> Tpetra::Distributor &"""
        return _Tpetra.Export_default_getDistributor(self, *args)

Export_default_swigregister = _Tpetra.Export_default_swigregister
Export_default_swigregister(Export_default)


Export = Export_default

class Import_default(Transfer_default):
    """Proxy of C++ Tpetra::Import<(int,long long,DefaultNodeType)> class."""

    __swig_setmethods__ = {}
    for _s in [Transfer_default]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Import_default, name, value)
    __swig_getmethods__ = {}
    for _s in [Transfer_default]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Import_default, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Tpetra::Import<(int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & source, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & target) -> Import_default
        __init__(Tpetra::Import<(int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & source, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & target, RCP< Teuchos::FancyOStream > const & out) -> Import_default
        __init__(Tpetra::Import<(int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & source, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & target, Teuchos::RCP< Teuchos::ParameterList > const & plist) -> Import_default
        __init__(Tpetra::Import<(int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & source, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & target, RCP< Teuchos::FancyOStream > const & out, Teuchos::RCP< Teuchos::ParameterList > const & plist) -> Import_default
        __init__(Tpetra::Import<(int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & source, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & target, Teuchos::Array< int > & remotePIDs) -> Import_default
        __init__(Tpetra::Import<(int,long long,DefaultNodeType)> self, Import_default importer) -> Import_default
        __init__(Tpetra::Import<(int,long long,DefaultNodeType)> self, Export_default exporter) -> Import_default
        """
        this = _Tpetra.new_Import_default(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Tpetra.delete_Import_default

    def setParameterList(self, *args):
        """setParameterList(Import_default self, Teuchos::RCP< Teuchos::ParameterList > const & plist)"""
        return _Tpetra.Import_default_setParameterList(self, *args)


    def getNumSameIDs(self, *args):
        """getNumSameIDs(Import_default self) -> size_t"""
        return _Tpetra.Import_default_getNumSameIDs(self, *args)


    def getNumPermuteIDs(self, *args):
        """getNumPermuteIDs(Import_default self) -> size_t"""
        return _Tpetra.Import_default_getNumPermuteIDs(self, *args)


    def getPermuteFromLIDs(self, *args):
        """getPermuteFromLIDs(Import_default self) -> ArrayView< int const >"""
        return _Tpetra.Import_default_getPermuteFromLIDs(self, *args)


    def getPermuteToLIDs(self, *args):
        """getPermuteToLIDs(Import_default self) -> ArrayView< int const >"""
        return _Tpetra.Import_default_getPermuteToLIDs(self, *args)


    def getNumRemoteIDs(self, *args):
        """getNumRemoteIDs(Import_default self) -> size_t"""
        return _Tpetra.Import_default_getNumRemoteIDs(self, *args)


    def getRemoteLIDs(self, *args):
        """getRemoteLIDs(Import_default self) -> ArrayView< int const >"""
        return _Tpetra.Import_default_getRemoteLIDs(self, *args)


    def getNumExportIDs(self, *args):
        """getNumExportIDs(Import_default self) -> size_t"""
        return _Tpetra.Import_default_getNumExportIDs(self, *args)


    def getExportLIDs(self, *args):
        """getExportLIDs(Import_default self) -> ArrayView< int const >"""
        return _Tpetra.Import_default_getExportLIDs(self, *args)


    def getExportPIDs(self, *args):
        """getExportPIDs(Import_default self) -> ArrayView< int const >"""
        return _Tpetra.Import_default_getExportPIDs(self, *args)


    def getSourceMap(self, *args):
        """getSourceMap(Import_default self) -> Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const >"""
        return _Tpetra.Import_default_getSourceMap(self, *args)


    def getTargetMap(self, *args):
        """getTargetMap(Import_default self) -> Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const >"""
        return _Tpetra.Import_default_getTargetMap(self, *args)


    def getDistributor(self, *args):
        """getDistributor(Import_default self) -> Tpetra::Distributor &"""
        return _Tpetra.Import_default_getDistributor(self, *args)


    def setUnion(self, *args):
        """
        setUnion(Import_default self, Import_default rhs) -> Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >
        setUnion(Import_default self) -> Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >
        """
        return _Tpetra.Import_default_setUnion(self, *args)


    def createRemoteOnlyImport(self, *args):
        """createRemoteOnlyImport(Import_default self, Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::map_type const > const & remoteTarget) -> Teuchos::RCP< Tpetra::Import< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >"""
        return _Tpetra.Import_default_createRemoteOnlyImport(self, *args)

Import_default_swigregister = _Tpetra.Import_default_swigregister
Import_default_swigregister(Import_default)


Import = Import_default

class SrcDistObject(_object):
    """Proxy of C++ Tpetra::SrcDistObject class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SrcDistObject, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SrcDistObject, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Tpetra.delete_SrcDistObject

    def __init__(self, *args):
        """__init__(Tpetra::SrcDistObject self) -> SrcDistObject"""
        this = _Tpetra.new_SrcDistObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
SrcDistObject_swigregister = _Tpetra.SrcDistObject_swigregister
SrcDistObject_swigregister(SrcDistObject)


def MultiVector_getattr(self, name):
    if name == "array":
        a = self._extractNumPyArray()
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    else:
        raise AttributeError("'%s' not an attribute of MultiVector" % name)
def MultiVector_setattr(self, name, value):
    if name in ("array", "shape", "dtype"):
        raise AttributeError("Cannot change MultiVector '%s' attribute", name)
    else:
        self.__dict__[name] = value
def MultiVector_getitem(self,i):
    if isinstance(i,int):
        return self.getVectorNonConst(i)
    else:
        return self.array.__getitem__(i)
def upgradeMultiVectorClass(cls):
    cls.__getattr__ = MultiVector_getattr
    cls.__setattr__ = MultiVector_setattr
    cls.__getitem__ = MultiVector_getitem
    cls.__setitem__ = lambda self, i, v: self.array.__setitem__(i,v)
    cls.__len__     = lambda self: self.array.__len__()
    cls.__str__     = lambda self: self.array.__str__()
    cls.copy        = lambda self: cls(self)
    class_array_add_math(cls)
    class_array_add_comp(cls)



def Vector_getattr(self, name):
    if name == "array":
        a = self._extractNumPyArray()
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    else:
        raise AttributeError("'%s' not an attribute of Vector" % name)
def Vector_setattr(self, name, value):
    if name in ("array", "shape", "dtype"):
        raise AttributeError("Cannot change Vector '%s' attribute", name)
    else:
        self.__dict__[name] = value
def upgradeVectorClass(cls):
    cls.__getattr__ = Vector_getattr
    cls.__setattr__ = Vector_setattr
    cls.__getitem__ = lambda self, i: self.array.__getitem__(i)
    cls.__setitem__ = lambda self, i, v: self.array.__setitem__(i,v)
    cls.__len__     = lambda self: self.array.__len__()
    cls.__str__     = lambda self: self.array.__str__()
    cls.copy        = lambda self: cls(self)
    class_array_add_math(cls)
    class_array_add_comp(cls)


class DistObject_int(SrcDistObject, PyTrilinos.Teuchos.Describable):
    """Proxy of C++ Tpetra::DistObject<(int,int,long long,DefaultNodeType)> class."""

    __swig_setmethods__ = {}
    for _s in [SrcDistObject, PyTrilinos.Teuchos.Describable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DistObject_int, name, value)
    __swig_getmethods__ = {}
    for _s in [SrcDistObject, PyTrilinos.Teuchos.Describable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DistObject_int, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Tpetra.delete_DistObject_int

    def doImport(self, *args):
        """
        doImport(DistObject_int self, SrcDistObject source, Import_default importer, Tpetra::CombineMode CM)
        doImport(DistObject_int self, SrcDistObject source, Export_default exporter, Tpetra::CombineMode CM)
        """
        return _Tpetra.DistObject_int_doImport(self, *args)


    def doExport(self, *args):
        """
        doExport(DistObject_int self, SrcDistObject source, Export_default exporter, Tpetra::CombineMode CM)
        doExport(DistObject_int self, SrcDistObject source, Import_default importer, Tpetra::CombineMode CM)
        """
        return _Tpetra.DistObject_int_doExport(self, *args)


    def isDistributed(self, *args):
        """isDistributed(DistObject_int self) -> bool"""
        return _Tpetra.DistObject_int_isDistributed(self, *args)


    def getMap(self, *args):
        """getMap(DistObject_int self) -> Teuchos::RCP< DefaultMapType const >"""
        return _Tpetra.DistObject_int_getMap(self, *args)


    def description(self, *args):
        """description(DistObject_int self) -> std::string"""
        return _Tpetra.DistObject_int_description(self, *args)


    def describe(self, *args):
        """describe(DistObject_int self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)"""
        return _Tpetra.DistObject_int_describe(self, *args)


    def removeEmptyProcessesInPlace(self, *args):
        """removeEmptyProcessesInPlace(DistObject_int self, Teuchos::RCP< DefaultMapType const > const & newMap)"""
        return _Tpetra.DistObject_int_removeEmptyProcessesInPlace(self, *args)

DistObject_int_swigregister = _Tpetra.DistObject_int_swigregister
DistObject_int_swigregister(DistObject_int)

class MultiVector_int(DistObject_int):
    """Proxy of C++ Tpetra::MultiVector<(int,int,long long,DefaultNodeType)> class."""

    __swig_setmethods__ = {}
    for _s in [DistObject_int]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiVector_int, name, value)
    __swig_getmethods__ = {}
    for _s in [DistObject_int]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MultiVector_int, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Tpetra::MultiVector<(int,int,long long,DefaultNodeType)> self) -> MultiVector_int
        __init__(Tpetra::MultiVector<(int,int,long long,DefaultNodeType)> self, Teuchos::RCP< DefaultMapType const > const & map, size_t const numVecs, bool const zeroOut=True) -> MultiVector_int
        __init__(Tpetra::MultiVector<(int,int,long long,DefaultNodeType)> self, MultiVector_int source) -> MultiVector_int
        __init__(Tpetra::MultiVector<(int,int,long long,DefaultNodeType)> self, MultiVector_int source, Teuchos::DataAccess const copyOrView) -> MultiVector_int
        __init__(Tpetra::MultiVector<(int,int,long long,DefaultNodeType)> self, Teuchos::RCP< DefaultMapType const > const & map, Teuchos::ArrayView< int const > const & A, size_t const LDA, size_t const NumVectors) -> MultiVector_int
        __init__(Tpetra::MultiVector<(int,int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & map, Teuchos::ArrayView< Teuchos::ArrayView< int const > const > const & ArrayOfPtrs, size_t const NumVectors) -> MultiVector_int
        """
        this = _Tpetra.new_MultiVector_int(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Tpetra.delete_MultiVector_int

    def replaceGlobalValue(self, *args):
        """replaceGlobalValue(MultiVector_int self, long long globalRow, size_t col, Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)"""
        return _Tpetra.MultiVector_int_replaceGlobalValue(self, *args)


    def sumIntoGlobalValue(self, *args):
        """sumIntoGlobalValue(MultiVector_int self, long long globalRow, size_t col, Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)"""
        return _Tpetra.MultiVector_int_sumIntoGlobalValue(self, *args)


    def replaceLocalValue(self, *args):
        """replaceLocalValue(MultiVector_int self, int localRow, size_t col, Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)"""
        return _Tpetra.MultiVector_int_replaceLocalValue(self, *args)


    def sumIntoLocalValue(self, *args):
        """sumIntoLocalValue(MultiVector_int self, int localRow, size_t col, Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)"""
        return _Tpetra.MultiVector_int_sumIntoLocalValue(self, *args)


    def putScalar(self, *args):
        """putScalar(MultiVector_int self, int const & value)"""
        return _Tpetra.MultiVector_int_putScalar(self, *args)


    def randomize(self, *args):
        """randomize(MultiVector_int self)"""
        return _Tpetra.MultiVector_int_randomize(self, *args)


    def replaceMap(self, *args):
        """replaceMap(MultiVector_int self, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & map)"""
        return _Tpetra.MultiVector_int_replaceMap(self, *args)


    def reduce(self, *args):
        """reduce(MultiVector_int self)"""
        return _Tpetra.MultiVector_int_reduce(self, *args)


    def subCopy(self, *args):
        """
        subCopy(MultiVector_int self, Teuchos::Range1D const & colRng) -> Teuchos::RCP< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >
        subCopy(MultiVector_int self, Teuchos::ArrayView< size_t const > const & cols) -> Teuchos::RCP< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >
        """
        return _Tpetra.MultiVector_int_subCopy(self, *args)


    def subView(self, *args):
        """
        subView(MultiVector_int self, Teuchos::Range1D const & colRng) -> Teuchos::RCP< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >
        subView(MultiVector_int self, Teuchos::ArrayView< size_t const > const & cols) -> Teuchos::RCP< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >
        """
        return _Tpetra.MultiVector_int_subView(self, *args)


    def subViewNonConst(self, *args):
        """
        subViewNonConst(MultiVector_int self, Teuchos::Range1D const & colRng) -> Teuchos::RCP< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >
        subViewNonConst(MultiVector_int self, Teuchos::ArrayView< size_t const > const & cols) -> Teuchos::RCP< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >
        """
        return _Tpetra.MultiVector_int_subViewNonConst(self, *args)


    def offsetViewNonConst(self, *args):
        """offsetViewNonConst(MultiVector_int self, Teuchos::RCP< DefaultMapType const > const & subMap, size_t const offset) -> Teuchos::RCP< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >"""
        return _Tpetra.MultiVector_int_offsetViewNonConst(self, *args)


    def getVector(self, *args):
        """getVector(MultiVector_int self, size_t const j) -> Teuchos::RCP< Tpetra::Vector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >"""
        return _Tpetra.MultiVector_int_getVector(self, *args)


    def getVectorNonConst(self, *args):
        """getVectorNonConst(MultiVector_int self, size_t const j) -> Teuchos::RCP< Tpetra::Vector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >"""
        return _Tpetra.MultiVector_int_getVectorNonConst(self, *args)


    def getData(self, *args):
        """getData(MultiVector_int self, size_t j) -> Teuchos::ArrayRCP< int const >"""
        return _Tpetra.MultiVector_int_getData(self, *args)


    def getDataNonConst(self, *args):
        """getDataNonConst(MultiVector_int self, size_t j) -> Teuchos::ArrayRCP< int >"""
        return _Tpetra.MultiVector_int_getDataNonConst(self, *args)


    def get1dCopy(self, *args):
        """get1dCopy(MultiVector_int self, Teuchos::ArrayView< int > const & A, size_t const LDA)"""
        return _Tpetra.MultiVector_int_get1dCopy(self, *args)


    def get2dCopy(self, *args):
        """get2dCopy(MultiVector_int self, Teuchos::ArrayView< Teuchos::ArrayView< int > const > const & ArrayOfPtrs)"""
        return _Tpetra.MultiVector_int_get2dCopy(self, *args)


    def get1dView(self, *args):
        """get1dView(MultiVector_int self) -> Teuchos::ArrayRCP< int const >"""
        return _Tpetra.MultiVector_int_get1dView(self, *args)


    def get2dView(self, *args):
        """get2dView(MultiVector_int self) -> Teuchos::ArrayRCP< Teuchos::ArrayRCP< int const > >"""
        return _Tpetra.MultiVector_int_get2dView(self, *args)


    def get1dViewNonConst(self, *args):
        """get1dViewNonConst(MultiVector_int self) -> Teuchos::ArrayRCP< int >"""
        return _Tpetra.MultiVector_int_get1dViewNonConst(self, *args)


    def get2dViewNonConst(self, *args):
        """get2dViewNonConst(MultiVector_int self) -> Teuchos::ArrayRCP< Teuchos::ArrayRCP< int > >"""
        return _Tpetra.MultiVector_int_get2dViewNonConst(self, *args)


    def dot(self, *args):
        """
        dot(MultiVector_int self, MultiVector_int A, Teuchos::ArrayView< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::dot_type > const & dots)
        dot(MultiVector_int self, MultiVector_int A, Kokkos::View< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::dot_type *,Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & dots)
        """
        return _Tpetra.MultiVector_int_dot(self, *args)


    def abs(self, *args):
        """abs(MultiVector_int self, MultiVector_int A)"""
        return _Tpetra.MultiVector_int_abs(self, *args)


    def reciprocal(self, *args):
        """reciprocal(MultiVector_int self, MultiVector_int A)"""
        return _Tpetra.MultiVector_int_reciprocal(self, *args)


    def scale(self, *args):
        """
        scale(MultiVector_int self, int const & alpha)
        scale(MultiVector_int self, Teuchos::ArrayView< int const > alpha)
        scale(MultiVector_int self, Kokkos::View< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const *,Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const alpha)
        scale(MultiVector_int self, int const & alpha, MultiVector_int A)
        """
        return _Tpetra.MultiVector_int_scale(self, *args)


    def update(self, *args):
        """
        update(MultiVector_int self, int const & alpha, MultiVector_int A, int const & beta)
        update(MultiVector_int self, int const & alpha, MultiVector_int A, int const & beta, MultiVector_int B, int const & gamma)
        """
        return _Tpetra.MultiVector_int_update(self, *args)


    def norm1(self, *args):
        """
        norm1(MultiVector_int self, Kokkos::View< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type *,Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & norms)
        norm1(MultiVector_int self, Teuchos::ArrayView< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type > const & norms)
        """
        return _Tpetra.MultiVector_int_norm1(self, *args)


    def norm2(self, *args):
        """
        norm2(MultiVector_int self, Kokkos::View< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type *,Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & norms)
        norm2(MultiVector_int self, Teuchos::ArrayView< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type > const & norms)
        """
        return _Tpetra.MultiVector_int_norm2(self, *args)


    def normInf(self, *args):
        """
        normInf(MultiVector_int self, Kokkos::View< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type *,Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & norms)
        normInf(MultiVector_int self, Teuchos::ArrayView< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type > const & norms)
        """
        return _Tpetra.MultiVector_int_normInf(self, *args)


    def meanValue(self, *args):
        """meanValue(MultiVector_int self, Teuchos::ArrayView< Tpetra::MultiVector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type > const & means)"""
        return _Tpetra.MultiVector_int_meanValue(self, *args)


    def multiply(self, *args):
        """multiply(MultiVector_int self, Teuchos::ETransp transA, Teuchos::ETransp transB, int const & alpha, MultiVector_int A, MultiVector_int B, int const & beta)"""
        return _Tpetra.MultiVector_int_multiply(self, *args)


    def elementWiseMultiply(self, *args):
        """elementWiseMultiply(MultiVector_int self, int scalarAB, Vector_int A, MultiVector_int B, int scalarThis)"""
        return _Tpetra.MultiVector_int_elementWiseMultiply(self, *args)


    def getNumVectors(self, *args):
        """getNumVectors(MultiVector_int self) -> size_t"""
        return _Tpetra.MultiVector_int_getNumVectors(self, *args)


    def getLocalLength(self, *args):
        """getLocalLength(MultiVector_int self) -> size_t"""
        return _Tpetra.MultiVector_int_getLocalLength(self, *args)


    def getGlobalLength(self, *args):
        """getGlobalLength(MultiVector_int self) -> Tpetra::global_size_t"""
        return _Tpetra.MultiVector_int_getGlobalLength(self, *args)


    def getStride(self, *args):
        """getStride(MultiVector_int self) -> size_t"""
        return _Tpetra.MultiVector_int_getStride(self, *args)


    def isConstantStride(self, *args):
        """isConstantStride(MultiVector_int self) -> bool"""
        return _Tpetra.MultiVector_int_isConstantStride(self, *args)


    def description(self, *args):
        """description(MultiVector_int self) -> std::string"""
        return _Tpetra.MultiVector_int_description(self, *args)


    def describe(self, *args):
        """describe(MultiVector_int self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)"""
        return _Tpetra.MultiVector_int_describe(self, *args)


    def removeEmptyProcessesInPlace(self, *args):
        """removeEmptyProcessesInPlace(MultiVector_int self, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & newMap)"""
        return _Tpetra.MultiVector_int_removeEmptyProcessesInPlace(self, *args)


    def setCopyOrView(self, *args):
        """setCopyOrView(MultiVector_int self, Teuchos::DataAccess const copyOrView)"""
        return _Tpetra.MultiVector_int_setCopyOrView(self, *args)


    def getCopyOrView(self, *args):
        """getCopyOrView(MultiVector_int self) -> Teuchos::DataAccess"""
        return _Tpetra.MultiVector_int_getCopyOrView(self, *args)


    def assign(self, *args):
        """assign(MultiVector_int self, MultiVector_int src)"""
        return _Tpetra.MultiVector_int_assign(self, *args)


    def _extractNumPyArray(self, *args):
        """_extractNumPyArray(MultiVector_int self) -> PyObject *"""
        return _Tpetra.MultiVector_int__extractNumPyArray(self, *args)


    def __distarray__(self, *args):
        """__distarray__(MultiVector_int self) -> PyObject *"""
        return _Tpetra.MultiVector_int___distarray__(self, *args)

MultiVector_int_swigregister = _Tpetra.MultiVector_int_swigregister
MultiVector_int_swigregister(MultiVector_int)


upgradeMultiVectorClass(MultiVector_int)

class Vector_int(MultiVector_int):
    """Proxy of C++ Tpetra::Vector<(int,int,long long,DefaultNodeType)> class."""

    __swig_setmethods__ = {}
    for _s in [MultiVector_int]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Vector_int, name, value)
    __swig_getmethods__ = {}
    for _s in [MultiVector_int]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Vector_int, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Tpetra::Vector<(int,int,long long,DefaultNodeType)> self, Teuchos::RCP< DefaultMapType const > const & map, bool const zeroOut=True) -> Vector_int
        __init__(Tpetra::Vector<(int,int,long long,DefaultNodeType)> self, Vector_int source) -> Vector_int
        __init__(Tpetra::Vector<(int,int,long long,DefaultNodeType)> self, Vector_int source, Teuchos::DataAccess const copyOrView) -> Vector_int
        """
        this = _Tpetra.new_Vector_int(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Tpetra.delete_Vector_int

    def replaceGlobalValue(self, *args):
        """replaceGlobalValue(Vector_int self, long long globalRow, int const & value)"""
        return _Tpetra.Vector_int_replaceGlobalValue(self, *args)


    def sumIntoGlobalValue(self, *args):
        """sumIntoGlobalValue(Vector_int self, long long globalRow, int const & value)"""
        return _Tpetra.Vector_int_sumIntoGlobalValue(self, *args)


    def replaceLocalValue(self, *args):
        """replaceLocalValue(Vector_int self, int myRow, int const & value)"""
        return _Tpetra.Vector_int_replaceLocalValue(self, *args)


    def sumIntoLocalValue(self, *args):
        """sumIntoLocalValue(Vector_int self, int myRow, int const & value)"""
        return _Tpetra.Vector_int_sumIntoLocalValue(self, *args)


    def get1dCopy(self, *args):
        """
        get1dCopy(Vector_int self)
        get1dCopy(Vector_int self, Teuchos::ArrayView< int > const & A)
        """
        return _Tpetra.Vector_int_get1dCopy(self, *args)


    def getDataNonConst(self, *args):
        """
        getDataNonConst(Vector_int self)
        getDataNonConst(Vector_int self) -> Teuchos::ArrayRCP< int >
        """
        return _Tpetra.Vector_int_getDataNonConst(self, *args)


    def getData(self, *args):
        """
        getData(Vector_int self)
        getData(Vector_int self) -> Teuchos::ArrayRCP< int const >
        """
        return _Tpetra.Vector_int_getData(self, *args)


    def norm2(self, *args):
        """
        norm2(Vector_int self)
        norm2(Vector_int self) -> Tpetra::Vector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type
        """
        return _Tpetra.Vector_int_norm2(self, *args)


    def normInf(self, *args):
        """
        normInf(Vector_int self)
        normInf(Vector_int self) -> Tpetra::Vector< int,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type
        """
        return _Tpetra.Vector_int_normInf(self, *args)


    def meanValue(self, *args):
        """
        meanValue(Vector_int self)
        meanValue(Vector_int self) -> int
        """
        return _Tpetra.Vector_int_meanValue(self, *args)


    def description(self, *args):
        """description(Vector_int self) -> std::string"""
        return _Tpetra.Vector_int_description(self, *args)


    def describe(self, *args):
        """describe(Vector_int self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)"""
        return _Tpetra.Vector_int_describe(self, *args)


    def _extractNumPyArray(self, *args):
        """_extractNumPyArray(Vector_int self) -> PyObject *"""
        return _Tpetra.Vector_int__extractNumPyArray(self, *args)


    def __distarray__(self, *args):
        """__distarray__(Vector_int self) -> PyObject *"""
        return _Tpetra.Vector_int___distarray__(self, *args)

Vector_int_swigregister = _Tpetra.Vector_int_swigregister
Vector_int_swigregister(Vector_int)


upgradeVectorClass(Vector_int)

class DistObject_long(SrcDistObject, PyTrilinos.Teuchos.Describable):
    """Proxy of C++ Tpetra::DistObject<(long long,int,long long,DefaultNodeType)> class."""

    __swig_setmethods__ = {}
    for _s in [SrcDistObject, PyTrilinos.Teuchos.Describable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DistObject_long, name, value)
    __swig_getmethods__ = {}
    for _s in [SrcDistObject, PyTrilinos.Teuchos.Describable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DistObject_long, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Tpetra.delete_DistObject_long

    def doImport(self, *args):
        """
        doImport(DistObject_long self, SrcDistObject source, Import_default importer, Tpetra::CombineMode CM)
        doImport(DistObject_long self, SrcDistObject source, Export_default exporter, Tpetra::CombineMode CM)
        """
        return _Tpetra.DistObject_long_doImport(self, *args)


    def doExport(self, *args):
        """
        doExport(DistObject_long self, SrcDistObject source, Export_default exporter, Tpetra::CombineMode CM)
        doExport(DistObject_long self, SrcDistObject source, Import_default importer, Tpetra::CombineMode CM)
        """
        return _Tpetra.DistObject_long_doExport(self, *args)


    def isDistributed(self, *args):
        """isDistributed(DistObject_long self) -> bool"""
        return _Tpetra.DistObject_long_isDistributed(self, *args)


    def getMap(self, *args):
        """getMap(DistObject_long self) -> Teuchos::RCP< DefaultMapType const >"""
        return _Tpetra.DistObject_long_getMap(self, *args)


    def description(self, *args):
        """description(DistObject_long self) -> std::string"""
        return _Tpetra.DistObject_long_description(self, *args)


    def describe(self, *args):
        """describe(DistObject_long self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)"""
        return _Tpetra.DistObject_long_describe(self, *args)


    def removeEmptyProcessesInPlace(self, *args):
        """removeEmptyProcessesInPlace(DistObject_long self, Teuchos::RCP< DefaultMapType const > const & newMap)"""
        return _Tpetra.DistObject_long_removeEmptyProcessesInPlace(self, *args)

DistObject_long_swigregister = _Tpetra.DistObject_long_swigregister
DistObject_long_swigregister(DistObject_long)

class MultiVector_long(DistObject_long):
    """Proxy of C++ Tpetra::MultiVector<(long long,int,long long,DefaultNodeType)> class."""

    __swig_setmethods__ = {}
    for _s in [DistObject_long]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiVector_long, name, value)
    __swig_getmethods__ = {}
    for _s in [DistObject_long]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MultiVector_long, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Tpetra::MultiVector<(long long,int,long long,DefaultNodeType)> self) -> MultiVector_long
        __init__(Tpetra::MultiVector<(long long,int,long long,DefaultNodeType)> self, Teuchos::RCP< DefaultMapType const > const & map, size_t const numVecs, bool const zeroOut=True) -> MultiVector_long
        __init__(Tpetra::MultiVector<(long long,int,long long,DefaultNodeType)> self, MultiVector_long source) -> MultiVector_long
        __init__(Tpetra::MultiVector<(long long,int,long long,DefaultNodeType)> self, MultiVector_long source, Teuchos::DataAccess const copyOrView) -> MultiVector_long
        __init__(Tpetra::MultiVector<(long long,int,long long,DefaultNodeType)> self, Teuchos::RCP< DefaultMapType const > const & map, Teuchos::ArrayView< long long const > const & A, size_t const LDA, size_t const NumVectors) -> MultiVector_long
        __init__(Tpetra::MultiVector<(long long,int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & map, Teuchos::ArrayView< Teuchos::ArrayView< long long const > const > const & ArrayOfPtrs, size_t const NumVectors) -> MultiVector_long
        """
        this = _Tpetra.new_MultiVector_long(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Tpetra.delete_MultiVector_long

    def replaceGlobalValue(self, *args):
        """replaceGlobalValue(MultiVector_long self, long long globalRow, size_t col, Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)"""
        return _Tpetra.MultiVector_long_replaceGlobalValue(self, *args)


    def sumIntoGlobalValue(self, *args):
        """sumIntoGlobalValue(MultiVector_long self, long long globalRow, size_t col, Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)"""
        return _Tpetra.MultiVector_long_sumIntoGlobalValue(self, *args)


    def replaceLocalValue(self, *args):
        """replaceLocalValue(MultiVector_long self, int localRow, size_t col, Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)"""
        return _Tpetra.MultiVector_long_replaceLocalValue(self, *args)


    def sumIntoLocalValue(self, *args):
        """sumIntoLocalValue(MultiVector_long self, int localRow, size_t col, Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)"""
        return _Tpetra.MultiVector_long_sumIntoLocalValue(self, *args)


    def putScalar(self, *args):
        """putScalar(MultiVector_long self, long long const & value)"""
        return _Tpetra.MultiVector_long_putScalar(self, *args)


    def randomize(self, *args):
        """randomize(MultiVector_long self)"""
        return _Tpetra.MultiVector_long_randomize(self, *args)


    def replaceMap(self, *args):
        """replaceMap(MultiVector_long self, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & map)"""
        return _Tpetra.MultiVector_long_replaceMap(self, *args)


    def reduce(self, *args):
        """reduce(MultiVector_long self)"""
        return _Tpetra.MultiVector_long_reduce(self, *args)


    def subCopy(self, *args):
        """
        subCopy(MultiVector_long self, Teuchos::Range1D const & colRng) -> Teuchos::RCP< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >
        subCopy(MultiVector_long self, Teuchos::ArrayView< size_t const > const & cols) -> Teuchos::RCP< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >
        """
        return _Tpetra.MultiVector_long_subCopy(self, *args)


    def subView(self, *args):
        """
        subView(MultiVector_long self, Teuchos::Range1D const & colRng) -> Teuchos::RCP< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >
        subView(MultiVector_long self, Teuchos::ArrayView< size_t const > const & cols) -> Teuchos::RCP< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >
        """
        return _Tpetra.MultiVector_long_subView(self, *args)


    def subViewNonConst(self, *args):
        """
        subViewNonConst(MultiVector_long self, Teuchos::Range1D const & colRng) -> Teuchos::RCP< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >
        subViewNonConst(MultiVector_long self, Teuchos::ArrayView< size_t const > const & cols) -> Teuchos::RCP< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >
        """
        return _Tpetra.MultiVector_long_subViewNonConst(self, *args)


    def offsetViewNonConst(self, *args):
        """offsetViewNonConst(MultiVector_long self, Teuchos::RCP< DefaultMapType const > const & subMap, size_t const offset) -> Teuchos::RCP< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >"""
        return _Tpetra.MultiVector_long_offsetViewNonConst(self, *args)


    def getVector(self, *args):
        """getVector(MultiVector_long self, size_t const j) -> Teuchos::RCP< Tpetra::Vector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >"""
        return _Tpetra.MultiVector_long_getVector(self, *args)


    def getVectorNonConst(self, *args):
        """getVectorNonConst(MultiVector_long self, size_t const j) -> Teuchos::RCP< Tpetra::Vector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >"""
        return _Tpetra.MultiVector_long_getVectorNonConst(self, *args)


    def getData(self, *args):
        """getData(MultiVector_long self, size_t j) -> Teuchos::ArrayRCP< long long const >"""
        return _Tpetra.MultiVector_long_getData(self, *args)


    def getDataNonConst(self, *args):
        """getDataNonConst(MultiVector_long self, size_t j) -> Teuchos::ArrayRCP< long long >"""
        return _Tpetra.MultiVector_long_getDataNonConst(self, *args)


    def get1dCopy(self, *args):
        """get1dCopy(MultiVector_long self, Teuchos::ArrayView< long long > const & A, size_t const LDA)"""
        return _Tpetra.MultiVector_long_get1dCopy(self, *args)


    def get2dCopy(self, *args):
        """get2dCopy(MultiVector_long self, Teuchos::ArrayView< Teuchos::ArrayView< long long > const > const & ArrayOfPtrs)"""
        return _Tpetra.MultiVector_long_get2dCopy(self, *args)


    def get1dView(self, *args):
        """get1dView(MultiVector_long self) -> Teuchos::ArrayRCP< long long const >"""
        return _Tpetra.MultiVector_long_get1dView(self, *args)


    def get2dView(self, *args):
        """get2dView(MultiVector_long self) -> Teuchos::ArrayRCP< Teuchos::ArrayRCP< long long const > >"""
        return _Tpetra.MultiVector_long_get2dView(self, *args)


    def get1dViewNonConst(self, *args):
        """get1dViewNonConst(MultiVector_long self) -> Teuchos::ArrayRCP< long long >"""
        return _Tpetra.MultiVector_long_get1dViewNonConst(self, *args)


    def get2dViewNonConst(self, *args):
        """get2dViewNonConst(MultiVector_long self) -> Teuchos::ArrayRCP< Teuchos::ArrayRCP< long long > >"""
        return _Tpetra.MultiVector_long_get2dViewNonConst(self, *args)


    def dot(self, *args):
        """
        dot(MultiVector_long self, MultiVector_long A, Teuchos::ArrayView< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::dot_type > const & dots)
        dot(MultiVector_long self, MultiVector_long A, Kokkos::View< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::dot_type *,Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & dots)
        """
        return _Tpetra.MultiVector_long_dot(self, *args)


    def abs(self, *args):
        """abs(MultiVector_long self, MultiVector_long A)"""
        return _Tpetra.MultiVector_long_abs(self, *args)


    def reciprocal(self, *args):
        """reciprocal(MultiVector_long self, MultiVector_long A)"""
        return _Tpetra.MultiVector_long_reciprocal(self, *args)


    def scale(self, *args):
        """
        scale(MultiVector_long self, long long const & alpha)
        scale(MultiVector_long self, Teuchos::ArrayView< long long const > alpha)
        scale(MultiVector_long self, Kokkos::View< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const *,Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const alpha)
        scale(MultiVector_long self, long long const & alpha, MultiVector_long A)
        """
        return _Tpetra.MultiVector_long_scale(self, *args)


    def update(self, *args):
        """
        update(MultiVector_long self, long long const & alpha, MultiVector_long A, long long const & beta)
        update(MultiVector_long self, long long const & alpha, MultiVector_long A, long long const & beta, MultiVector_long B, long long const & gamma)
        """
        return _Tpetra.MultiVector_long_update(self, *args)


    def norm1(self, *args):
        """
        norm1(MultiVector_long self, Kokkos::View< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type *,Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & norms)
        norm1(MultiVector_long self, Teuchos::ArrayView< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type > const & norms)
        """
        return _Tpetra.MultiVector_long_norm1(self, *args)


    def norm2(self, *args):
        """
        norm2(MultiVector_long self, Kokkos::View< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type *,Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & norms)
        norm2(MultiVector_long self, Teuchos::ArrayView< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type > const & norms)
        """
        return _Tpetra.MultiVector_long_norm2(self, *args)


    def normInf(self, *args):
        """
        normInf(MultiVector_long self, Kokkos::View< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type *,Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & norms)
        normInf(MultiVector_long self, Teuchos::ArrayView< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type > const & norms)
        """
        return _Tpetra.MultiVector_long_normInf(self, *args)


    def meanValue(self, *args):
        """meanValue(MultiVector_long self, Teuchos::ArrayView< Tpetra::MultiVector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type > const & means)"""
        return _Tpetra.MultiVector_long_meanValue(self, *args)


    def multiply(self, *args):
        """multiply(MultiVector_long self, Teuchos::ETransp transA, Teuchos::ETransp transB, long long const & alpha, MultiVector_long A, MultiVector_long B, long long const & beta)"""
        return _Tpetra.MultiVector_long_multiply(self, *args)


    def elementWiseMultiply(self, *args):
        """elementWiseMultiply(MultiVector_long self, long long scalarAB, Vector_long A, MultiVector_long B, long long scalarThis)"""
        return _Tpetra.MultiVector_long_elementWiseMultiply(self, *args)


    def getNumVectors(self, *args):
        """getNumVectors(MultiVector_long self) -> size_t"""
        return _Tpetra.MultiVector_long_getNumVectors(self, *args)


    def getLocalLength(self, *args):
        """getLocalLength(MultiVector_long self) -> size_t"""
        return _Tpetra.MultiVector_long_getLocalLength(self, *args)


    def getGlobalLength(self, *args):
        """getGlobalLength(MultiVector_long self) -> Tpetra::global_size_t"""
        return _Tpetra.MultiVector_long_getGlobalLength(self, *args)


    def getStride(self, *args):
        """getStride(MultiVector_long self) -> size_t"""
        return _Tpetra.MultiVector_long_getStride(self, *args)


    def isConstantStride(self, *args):
        """isConstantStride(MultiVector_long self) -> bool"""
        return _Tpetra.MultiVector_long_isConstantStride(self, *args)


    def description(self, *args):
        """description(MultiVector_long self) -> std::string"""
        return _Tpetra.MultiVector_long_description(self, *args)


    def describe(self, *args):
        """describe(MultiVector_long self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)"""
        return _Tpetra.MultiVector_long_describe(self, *args)


    def removeEmptyProcessesInPlace(self, *args):
        """removeEmptyProcessesInPlace(MultiVector_long self, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & newMap)"""
        return _Tpetra.MultiVector_long_removeEmptyProcessesInPlace(self, *args)


    def setCopyOrView(self, *args):
        """setCopyOrView(MultiVector_long self, Teuchos::DataAccess const copyOrView)"""
        return _Tpetra.MultiVector_long_setCopyOrView(self, *args)


    def getCopyOrView(self, *args):
        """getCopyOrView(MultiVector_long self) -> Teuchos::DataAccess"""
        return _Tpetra.MultiVector_long_getCopyOrView(self, *args)


    def assign(self, *args):
        """assign(MultiVector_long self, MultiVector_long src)"""
        return _Tpetra.MultiVector_long_assign(self, *args)


    def _extractNumPyArray(self, *args):
        """_extractNumPyArray(MultiVector_long self) -> PyObject *"""
        return _Tpetra.MultiVector_long__extractNumPyArray(self, *args)


    def __distarray__(self, *args):
        """__distarray__(MultiVector_long self) -> PyObject *"""
        return _Tpetra.MultiVector_long___distarray__(self, *args)

MultiVector_long_swigregister = _Tpetra.MultiVector_long_swigregister
MultiVector_long_swigregister(MultiVector_long)


upgradeMultiVectorClass(MultiVector_long)

class Vector_long(MultiVector_long):
    """Proxy of C++ Tpetra::Vector<(long long,int,long long,DefaultNodeType)> class."""

    __swig_setmethods__ = {}
    for _s in [MultiVector_long]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Vector_long, name, value)
    __swig_getmethods__ = {}
    for _s in [MultiVector_long]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Vector_long, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Tpetra::Vector<(long long,int,long long,DefaultNodeType)> self, Teuchos::RCP< DefaultMapType const > const & map, bool const zeroOut=True) -> Vector_long
        __init__(Tpetra::Vector<(long long,int,long long,DefaultNodeType)> self, Vector_long source) -> Vector_long
        __init__(Tpetra::Vector<(long long,int,long long,DefaultNodeType)> self, Vector_long source, Teuchos::DataAccess const copyOrView) -> Vector_long
        """
        this = _Tpetra.new_Vector_long(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Tpetra.delete_Vector_long

    def replaceGlobalValue(self, *args):
        """replaceGlobalValue(Vector_long self, long long globalRow, long long const & value)"""
        return _Tpetra.Vector_long_replaceGlobalValue(self, *args)


    def sumIntoGlobalValue(self, *args):
        """sumIntoGlobalValue(Vector_long self, long long globalRow, long long const & value)"""
        return _Tpetra.Vector_long_sumIntoGlobalValue(self, *args)


    def replaceLocalValue(self, *args):
        """replaceLocalValue(Vector_long self, int myRow, long long const & value)"""
        return _Tpetra.Vector_long_replaceLocalValue(self, *args)


    def sumIntoLocalValue(self, *args):
        """sumIntoLocalValue(Vector_long self, int myRow, long long const & value)"""
        return _Tpetra.Vector_long_sumIntoLocalValue(self, *args)


    def get1dCopy(self, *args):
        """
        get1dCopy(Vector_long self)
        get1dCopy(Vector_long self, Teuchos::ArrayView< long long > const & A)
        """
        return _Tpetra.Vector_long_get1dCopy(self, *args)


    def getDataNonConst(self, *args):
        """
        getDataNonConst(Vector_long self)
        getDataNonConst(Vector_long self) -> Teuchos::ArrayRCP< long long >
        """
        return _Tpetra.Vector_long_getDataNonConst(self, *args)


    def getData(self, *args):
        """
        getData(Vector_long self)
        getData(Vector_long self) -> Teuchos::ArrayRCP< long long const >
        """
        return _Tpetra.Vector_long_getData(self, *args)


    def norm2(self, *args):
        """
        norm2(Vector_long self)
        norm2(Vector_long self) -> Tpetra::Vector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type
        """
        return _Tpetra.Vector_long_norm2(self, *args)


    def normInf(self, *args):
        """
        normInf(Vector_long self)
        normInf(Vector_long self) -> Tpetra::Vector< long long,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type
        """
        return _Tpetra.Vector_long_normInf(self, *args)


    def meanValue(self, *args):
        """
        meanValue(Vector_long self)
        meanValue(Vector_long self) -> long long
        """
        return _Tpetra.Vector_long_meanValue(self, *args)


    def description(self, *args):
        """description(Vector_long self) -> std::string"""
        return _Tpetra.Vector_long_description(self, *args)


    def describe(self, *args):
        """describe(Vector_long self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)"""
        return _Tpetra.Vector_long_describe(self, *args)


    def _extractNumPyArray(self, *args):
        """_extractNumPyArray(Vector_long self) -> PyObject *"""
        return _Tpetra.Vector_long__extractNumPyArray(self, *args)


    def __distarray__(self, *args):
        """__distarray__(Vector_long self) -> PyObject *"""
        return _Tpetra.Vector_long___distarray__(self, *args)

Vector_long_swigregister = _Tpetra.Vector_long_swigregister
Vector_long_swigregister(Vector_long)


upgradeVectorClass(Vector_long)

class DistObject_double(SrcDistObject, PyTrilinos.Teuchos.Describable):
    """Proxy of C++ Tpetra::DistObject<(double,int,long long,DefaultNodeType)> class."""

    __swig_setmethods__ = {}
    for _s in [SrcDistObject, PyTrilinos.Teuchos.Describable]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DistObject_double, name, value)
    __swig_getmethods__ = {}
    for _s in [SrcDistObject, PyTrilinos.Teuchos.Describable]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DistObject_double, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Tpetra.delete_DistObject_double

    def doImport(self, *args):
        """
        doImport(DistObject_double self, SrcDistObject source, Import_default importer, Tpetra::CombineMode CM)
        doImport(DistObject_double self, SrcDistObject source, Export_default exporter, Tpetra::CombineMode CM)
        """
        return _Tpetra.DistObject_double_doImport(self, *args)


    def doExport(self, *args):
        """
        doExport(DistObject_double self, SrcDistObject source, Export_default exporter, Tpetra::CombineMode CM)
        doExport(DistObject_double self, SrcDistObject source, Import_default importer, Tpetra::CombineMode CM)
        """
        return _Tpetra.DistObject_double_doExport(self, *args)


    def isDistributed(self, *args):
        """isDistributed(DistObject_double self) -> bool"""
        return _Tpetra.DistObject_double_isDistributed(self, *args)


    def getMap(self, *args):
        """getMap(DistObject_double self) -> Teuchos::RCP< DefaultMapType const >"""
        return _Tpetra.DistObject_double_getMap(self, *args)


    def description(self, *args):
        """description(DistObject_double self) -> std::string"""
        return _Tpetra.DistObject_double_description(self, *args)


    def describe(self, *args):
        """describe(DistObject_double self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)"""
        return _Tpetra.DistObject_double_describe(self, *args)


    def removeEmptyProcessesInPlace(self, *args):
        """removeEmptyProcessesInPlace(DistObject_double self, Teuchos::RCP< DefaultMapType const > const & newMap)"""
        return _Tpetra.DistObject_double_removeEmptyProcessesInPlace(self, *args)

DistObject_double_swigregister = _Tpetra.DistObject_double_swigregister
DistObject_double_swigregister(DistObject_double)

class MultiVector_double(DistObject_double):
    """Proxy of C++ Tpetra::MultiVector<(double,int,long long,DefaultNodeType)> class."""

    __swig_setmethods__ = {}
    for _s in [DistObject_double]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiVector_double, name, value)
    __swig_getmethods__ = {}
    for _s in [DistObject_double]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MultiVector_double, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Tpetra::MultiVector<(double,int,long long,DefaultNodeType)> self) -> MultiVector_double
        __init__(Tpetra::MultiVector<(double,int,long long,DefaultNodeType)> self, Teuchos::RCP< DefaultMapType const > const & map, size_t const numVecs, bool const zeroOut=True) -> MultiVector_double
        __init__(Tpetra::MultiVector<(double,int,long long,DefaultNodeType)> self, MultiVector_double source) -> MultiVector_double
        __init__(Tpetra::MultiVector<(double,int,long long,DefaultNodeType)> self, MultiVector_double source, Teuchos::DataAccess const copyOrView) -> MultiVector_double
        __init__(Tpetra::MultiVector<(double,int,long long,DefaultNodeType)> self, Teuchos::RCP< DefaultMapType const > const & map, Teuchos::ArrayView< double const > const & A, size_t const LDA, size_t const NumVectors) -> MultiVector_double
        __init__(Tpetra::MultiVector<(double,int,long long,DefaultNodeType)> self, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & map, Teuchos::ArrayView< Teuchos::ArrayView< double const > const > const & ArrayOfPtrs, size_t const NumVectors) -> MultiVector_double
        """
        this = _Tpetra.new_MultiVector_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Tpetra.delete_MultiVector_double

    def replaceGlobalValue(self, *args):
        """replaceGlobalValue(MultiVector_double self, long long globalRow, size_t col, Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)"""
        return _Tpetra.MultiVector_double_replaceGlobalValue(self, *args)


    def sumIntoGlobalValue(self, *args):
        """sumIntoGlobalValue(MultiVector_double self, long long globalRow, size_t col, Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)"""
        return _Tpetra.MultiVector_double_sumIntoGlobalValue(self, *args)


    def replaceLocalValue(self, *args):
        """replaceLocalValue(MultiVector_double self, int localRow, size_t col, Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)"""
        return _Tpetra.MultiVector_double_replaceLocalValue(self, *args)


    def sumIntoLocalValue(self, *args):
        """sumIntoLocalValue(MultiVector_double self, int localRow, size_t col, Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const & value)"""
        return _Tpetra.MultiVector_double_sumIntoLocalValue(self, *args)


    def putScalar(self, *args):
        """putScalar(MultiVector_double self, double const & value)"""
        return _Tpetra.MultiVector_double_putScalar(self, *args)


    def randomize(self, *args):
        """randomize(MultiVector_double self)"""
        return _Tpetra.MultiVector_double_randomize(self, *args)


    def replaceMap(self, *args):
        """replaceMap(MultiVector_double self, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & map)"""
        return _Tpetra.MultiVector_double_replaceMap(self, *args)


    def reduce(self, *args):
        """reduce(MultiVector_double self)"""
        return _Tpetra.MultiVector_double_reduce(self, *args)


    def subCopy(self, *args):
        """
        subCopy(MultiVector_double self, Teuchos::Range1D const & colRng) -> Teuchos::RCP< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >
        subCopy(MultiVector_double self, Teuchos::ArrayView< size_t const > const & cols) -> Teuchos::RCP< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >
        """
        return _Tpetra.MultiVector_double_subCopy(self, *args)


    def subView(self, *args):
        """
        subView(MultiVector_double self, Teuchos::Range1D const & colRng) -> Teuchos::RCP< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >
        subView(MultiVector_double self, Teuchos::ArrayView< size_t const > const & cols) -> Teuchos::RCP< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >
        """
        return _Tpetra.MultiVector_double_subView(self, *args)


    def subViewNonConst(self, *args):
        """
        subViewNonConst(MultiVector_double self, Teuchos::Range1D const & colRng) -> Teuchos::RCP< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >
        subViewNonConst(MultiVector_double self, Teuchos::ArrayView< size_t const > const & cols) -> Teuchos::RCP< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >
        """
        return _Tpetra.MultiVector_double_subViewNonConst(self, *args)


    def offsetViewNonConst(self, *args):
        """offsetViewNonConst(MultiVector_double self, Teuchos::RCP< DefaultMapType const > const & subMap, size_t const offset) -> Teuchos::RCP< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >"""
        return _Tpetra.MultiVector_double_offsetViewNonConst(self, *args)


    def getVector(self, *args):
        """getVector(MultiVector_double self, size_t const j) -> Teuchos::RCP< Tpetra::Vector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const >"""
        return _Tpetra.MultiVector_double_getVector(self, *args)


    def getVectorNonConst(self, *args):
        """getVectorNonConst(MultiVector_double self, size_t const j) -> Teuchos::RCP< Tpetra::Vector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType > >"""
        return _Tpetra.MultiVector_double_getVectorNonConst(self, *args)


    def getData(self, *args):
        """getData(MultiVector_double self, size_t j) -> Teuchos::ArrayRCP< double const >"""
        return _Tpetra.MultiVector_double_getData(self, *args)


    def getDataNonConst(self, *args):
        """getDataNonConst(MultiVector_double self, size_t j) -> Teuchos::ArrayRCP< double >"""
        return _Tpetra.MultiVector_double_getDataNonConst(self, *args)


    def get1dCopy(self, *args):
        """get1dCopy(MultiVector_double self, Teuchos::ArrayView< double > const & A, size_t const LDA)"""
        return _Tpetra.MultiVector_double_get1dCopy(self, *args)


    def get2dCopy(self, *args):
        """get2dCopy(MultiVector_double self, Teuchos::ArrayView< Teuchos::ArrayView< double > const > const & ArrayOfPtrs)"""
        return _Tpetra.MultiVector_double_get2dCopy(self, *args)


    def get1dView(self, *args):
        """get1dView(MultiVector_double self) -> Teuchos::ArrayRCP< double const >"""
        return _Tpetra.MultiVector_double_get1dView(self, *args)


    def get2dView(self, *args):
        """get2dView(MultiVector_double self) -> Teuchos::ArrayRCP< Teuchos::ArrayRCP< double const > >"""
        return _Tpetra.MultiVector_double_get2dView(self, *args)


    def get1dViewNonConst(self, *args):
        """get1dViewNonConst(MultiVector_double self) -> Teuchos::ArrayRCP< double >"""
        return _Tpetra.MultiVector_double_get1dViewNonConst(self, *args)


    def get2dViewNonConst(self, *args):
        """get2dViewNonConst(MultiVector_double self) -> Teuchos::ArrayRCP< Teuchos::ArrayRCP< double > >"""
        return _Tpetra.MultiVector_double_get2dViewNonConst(self, *args)


    def dot(self, *args):
        """
        dot(MultiVector_double self, MultiVector_double A, Teuchos::ArrayView< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::dot_type > const & dots)
        dot(MultiVector_double self, MultiVector_double A, Kokkos::View< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::dot_type *,Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & dots)
        """
        return _Tpetra.MultiVector_double_dot(self, *args)


    def abs(self, *args):
        """abs(MultiVector_double self, MultiVector_double A)"""
        return _Tpetra.MultiVector_double_abs(self, *args)


    def reciprocal(self, *args):
        """reciprocal(MultiVector_double self, MultiVector_double A)"""
        return _Tpetra.MultiVector_double_reciprocal(self, *args)


    def scale(self, *args):
        """
        scale(MultiVector_double self, double const & alpha)
        scale(MultiVector_double self, Teuchos::ArrayView< double const > alpha)
        scale(MultiVector_double self, Kokkos::View< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type const *,Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const alpha)
        scale(MultiVector_double self, double const & alpha, MultiVector_double A)
        """
        return _Tpetra.MultiVector_double_scale(self, *args)


    def update(self, *args):
        """
        update(MultiVector_double self, double const & alpha, MultiVector_double A, double const & beta)
        update(MultiVector_double self, double const & alpha, MultiVector_double A, double const & beta, MultiVector_double B, double const & gamma)
        """
        return _Tpetra.MultiVector_double_update(self, *args)


    def norm1(self, *args):
        """
        norm1(MultiVector_double self, Kokkos::View< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type *,Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & norms)
        norm1(MultiVector_double self, Teuchos::ArrayView< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type > const & norms)
        """
        return _Tpetra.MultiVector_double_norm1(self, *args)


    def norm2(self, *args):
        """
        norm2(MultiVector_double self, Kokkos::View< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type *,Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & norms)
        norm2(MultiVector_double self, Teuchos::ArrayView< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type > const & norms)
        """
        return _Tpetra.MultiVector_double_norm2(self, *args)


    def normInf(self, *args):
        """
        normInf(MultiVector_double self, Kokkos::View< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type *,Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::execution_space > const & norms)
        normInf(MultiVector_double self, Teuchos::ArrayView< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type > const & norms)
        """
        return _Tpetra.MultiVector_double_normInf(self, *args)


    def meanValue(self, *args):
        """meanValue(MultiVector_double self, Teuchos::ArrayView< Tpetra::MultiVector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::impl_scalar_type > const & means)"""
        return _Tpetra.MultiVector_double_meanValue(self, *args)


    def multiply(self, *args):
        """multiply(MultiVector_double self, Teuchos::ETransp transA, Teuchos::ETransp transB, double const & alpha, MultiVector_double A, MultiVector_double B, double const & beta)"""
        return _Tpetra.MultiVector_double_multiply(self, *args)


    def elementWiseMultiply(self, *args):
        """elementWiseMultiply(MultiVector_double self, double scalarAB, Vector_double A, MultiVector_double B, double scalarThis)"""
        return _Tpetra.MultiVector_double_elementWiseMultiply(self, *args)


    def getNumVectors(self, *args):
        """getNumVectors(MultiVector_double self) -> size_t"""
        return _Tpetra.MultiVector_double_getNumVectors(self, *args)


    def getLocalLength(self, *args):
        """getLocalLength(MultiVector_double self) -> size_t"""
        return _Tpetra.MultiVector_double_getLocalLength(self, *args)


    def getGlobalLength(self, *args):
        """getGlobalLength(MultiVector_double self) -> Tpetra::global_size_t"""
        return _Tpetra.MultiVector_double_getGlobalLength(self, *args)


    def getStride(self, *args):
        """getStride(MultiVector_double self) -> size_t"""
        return _Tpetra.MultiVector_double_getStride(self, *args)


    def isConstantStride(self, *args):
        """isConstantStride(MultiVector_double self) -> bool"""
        return _Tpetra.MultiVector_double_isConstantStride(self, *args)


    def description(self, *args):
        """description(MultiVector_double self) -> std::string"""
        return _Tpetra.MultiVector_double_description(self, *args)


    def describe(self, *args):
        """describe(MultiVector_double self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)"""
        return _Tpetra.MultiVector_double_describe(self, *args)


    def removeEmptyProcessesInPlace(self, *args):
        """removeEmptyProcessesInPlace(MultiVector_double self, Teuchos::RCP< Tpetra::Map< int,long long,KokkosClassic::DefaultNode::DefaultNodeType > const > const & newMap)"""
        return _Tpetra.MultiVector_double_removeEmptyProcessesInPlace(self, *args)


    def setCopyOrView(self, *args):
        """setCopyOrView(MultiVector_double self, Teuchos::DataAccess const copyOrView)"""
        return _Tpetra.MultiVector_double_setCopyOrView(self, *args)


    def getCopyOrView(self, *args):
        """getCopyOrView(MultiVector_double self) -> Teuchos::DataAccess"""
        return _Tpetra.MultiVector_double_getCopyOrView(self, *args)


    def assign(self, *args):
        """assign(MultiVector_double self, MultiVector_double src)"""
        return _Tpetra.MultiVector_double_assign(self, *args)


    def _extractNumPyArray(self, *args):
        """_extractNumPyArray(MultiVector_double self) -> PyObject *"""
        return _Tpetra.MultiVector_double__extractNumPyArray(self, *args)


    def __distarray__(self, *args):
        """__distarray__(MultiVector_double self) -> PyObject *"""
        return _Tpetra.MultiVector_double___distarray__(self, *args)

MultiVector_double_swigregister = _Tpetra.MultiVector_double_swigregister
MultiVector_double_swigregister(MultiVector_double)


upgradeMultiVectorClass(MultiVector_double)

class Vector_double(MultiVector_double):
    """Proxy of C++ Tpetra::Vector<(double,int,long long,DefaultNodeType)> class."""

    __swig_setmethods__ = {}
    for _s in [MultiVector_double]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Vector_double, name, value)
    __swig_getmethods__ = {}
    for _s in [MultiVector_double]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Vector_double, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Tpetra::Vector<(double,int,long long,DefaultNodeType)> self, Teuchos::RCP< DefaultMapType const > const & map, bool const zeroOut=True) -> Vector_double
        __init__(Tpetra::Vector<(double,int,long long,DefaultNodeType)> self, Vector_double source) -> Vector_double
        __init__(Tpetra::Vector<(double,int,long long,DefaultNodeType)> self, Vector_double source, Teuchos::DataAccess const copyOrView) -> Vector_double
        """
        this = _Tpetra.new_Vector_double(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Tpetra.delete_Vector_double

    def replaceGlobalValue(self, *args):
        """replaceGlobalValue(Vector_double self, long long globalRow, double const & value)"""
        return _Tpetra.Vector_double_replaceGlobalValue(self, *args)


    def sumIntoGlobalValue(self, *args):
        """sumIntoGlobalValue(Vector_double self, long long globalRow, double const & value)"""
        return _Tpetra.Vector_double_sumIntoGlobalValue(self, *args)


    def replaceLocalValue(self, *args):
        """replaceLocalValue(Vector_double self, int myRow, double const & value)"""
        return _Tpetra.Vector_double_replaceLocalValue(self, *args)


    def sumIntoLocalValue(self, *args):
        """sumIntoLocalValue(Vector_double self, int myRow, double const & value)"""
        return _Tpetra.Vector_double_sumIntoLocalValue(self, *args)


    def get1dCopy(self, *args):
        """
        get1dCopy(Vector_double self)
        get1dCopy(Vector_double self, Teuchos::ArrayView< double > const & A)
        """
        return _Tpetra.Vector_double_get1dCopy(self, *args)


    def getDataNonConst(self, *args):
        """
        getDataNonConst(Vector_double self)
        getDataNonConst(Vector_double self) -> Teuchos::ArrayRCP< double >
        """
        return _Tpetra.Vector_double_getDataNonConst(self, *args)


    def getData(self, *args):
        """
        getData(Vector_double self)
        getData(Vector_double self) -> Teuchos::ArrayRCP< double const >
        """
        return _Tpetra.Vector_double_getData(self, *args)


    def norm2(self, *args):
        """
        norm2(Vector_double self)
        norm2(Vector_double self) -> Tpetra::Vector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type
        """
        return _Tpetra.Vector_double_norm2(self, *args)


    def normInf(self, *args):
        """
        normInf(Vector_double self)
        normInf(Vector_double self) -> Tpetra::Vector< double,int,long long,KokkosClassic::DefaultNode::DefaultNodeType >::mag_type
        """
        return _Tpetra.Vector_double_normInf(self, *args)


    def meanValue(self, *args):
        """
        meanValue(Vector_double self)
        meanValue(Vector_double self) -> double
        """
        return _Tpetra.Vector_double_meanValue(self, *args)


    def description(self, *args):
        """description(Vector_double self) -> std::string"""
        return _Tpetra.Vector_double_description(self, *args)


    def describe(self, *args):
        """describe(Vector_double self, Teuchos::FancyOStream & out, Teuchos::EVerbosityLevel const verbLevel)"""
        return _Tpetra.Vector_double_describe(self, *args)


    def _extractNumPyArray(self, *args):
        """_extractNumPyArray(Vector_double self) -> PyObject *"""
        return _Tpetra.Vector_double__extractNumPyArray(self, *args)


    def __distarray__(self, *args):
        """__distarray__(Vector_double self) -> PyObject *"""
        return _Tpetra.Vector_double___distarray__(self, *args)

Vector_double_swigregister = _Tpetra.Vector_double_swigregister
Vector_double_swigregister(Vector_double)


upgradeVectorClass(Vector_double)


def MultiVector(*args, **kwargs):
  dtype = None
  if len(args) > 0:
    try:
      dtype = str(args[0].dtype)
    except AttributeError:
      pass
  dtype = kwargs.get("dtype", dtype)
  if dtype is None: dtype = "int64"
  if type(dtype) == str:
    dtype = numpy.dtype(dtype)
  if dtype.type is numpy.int32:
    result = MultiVector_int(*args)
  elif dtype.type is numpy.int64:
    result = MultiVector_long(*args)
#elif dtype.type is numpy.float32:
#  result = MultiVector_float(*args)
  elif dtype.type is numpy.float64:
    result = MultiVector_double(*args)
  else:
    raise TypeError("Unsupported or unrecognized dtype = %s" %
                    str(dtype))
  return result

def Vector(*args, **kwargs):
  dtype = None
  if len(args) > 0:
    try:
      dtype = str(args[0].dtype)
    except AttributeError:
      pass
  dtype = kwargs.get("dtype", dtype)
  if dtype is None: dtype = "int64"
  if type(dtype) == str:
    dtype = numpy.dtype(dtype)
  if dtype.type is numpy.int32:
    result = Vector_int(*args)
  elif dtype.type is numpy.int64:
    result = Vector_long(*args)
#elif dtype.type is numpy.float32:
#  result = Vector_float(*args)
  elif dtype.type is numpy.float64:
    result = Vector_double(*args)
  else:
    raise TypeError("Unsupported or unrecognized dtype = %s" %
                    str(dtype))
  return result

# This file is compatible with both classic and new-style classes.


