# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.NOX.StatusTest is the python interface to the namespace
StatusTest in Trilinos package NOX:

    http://trilinos.sandia.gov/packages/nox

The purpose of NOX.StatusTest is to provide clompletely flexible
specification of stopping tests for NOX algorithms.

NOX.StatusTest provides the following user-level classes:

    * Generic      - Base class for all stopping tests
    * Combo        - Allows combining of stopping tests with AND or OR
    * NormF        - Stopping test based on norm of F
    * NormUpdate   - Stopping test based on norm of update
    * NormWRMS     - Stopping test based on norm of weighted RMS of F
    * MaxIters     - Stopping test based on maximum iterations
    * Stagnation   - Stopping test based on algorithm stagnation
    * FiniteValue  - Stopping test based on detecting NaNs

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_StatusTest')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_StatusTest')
    _StatusTest = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_StatusTest', [dirname(__file__)])
        except ImportError:
            import _StatusTest
            return _StatusTest
        try:
            _mod = imp.load_module('_StatusTest', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _StatusTest = swig_import_helper()
    del swig_import_helper
else:
    import _StatusTest
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _StatusTest.delete_SwigPyIterator

    def value(self):
        """value(SwigPyIterator self) -> PyObject *"""
        return _StatusTest.SwigPyIterator_value(self)


    def incr(self, n=1):
        """
        incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        incr(SwigPyIterator self) -> SwigPyIterator
        """
        return _StatusTest.SwigPyIterator_incr(self, n)


    def decr(self, n=1):
        """
        decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        decr(SwigPyIterator self) -> SwigPyIterator
        """
        return _StatusTest.SwigPyIterator_decr(self, n)


    def distance(self, x):
        """distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _StatusTest.SwigPyIterator_distance(self, x)


    def equal(self, x):
        """equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _StatusTest.SwigPyIterator_equal(self, x)


    def copy(self):
        """copy(SwigPyIterator self) -> SwigPyIterator"""
        return _StatusTest.SwigPyIterator_copy(self)


    def next(self):
        """next(SwigPyIterator self) -> PyObject *"""
        return _StatusTest.SwigPyIterator_next(self)


    def __next__(self):
        """__next__(SwigPyIterator self) -> PyObject *"""
        return _StatusTest.SwigPyIterator___next__(self)


    def previous(self):
        """previous(SwigPyIterator self) -> PyObject *"""
        return _StatusTest.SwigPyIterator_previous(self)


    def advance(self, n):
        """advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _StatusTest.SwigPyIterator_advance(self, n)


    def __eq__(self, x):
        """__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _StatusTest.SwigPyIterator___eq__(self, x)


    def __ne__(self, x):
        """__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _StatusTest.SwigPyIterator___ne__(self, x)


    def __iadd__(self, n):
        """__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _StatusTest.SwigPyIterator___iadd__(self, n)


    def __isub__(self, n):
        """__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _StatusTest.SwigPyIterator___isub__(self, n)


    def __add__(self, n):
        """__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _StatusTest.SwigPyIterator___add__(self, n)


    def __sub__(self, *args):
        """
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _StatusTest.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = _StatusTest.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

import PyTrilinos.Teuchos
Unevaluated = _StatusTest.Unevaluated
Unconverged = _StatusTest.Unconverged
Converged = _StatusTest.Converged
Failed = _StatusTest.Failed
Complete = _StatusTest.Complete
Minimal = _StatusTest.Minimal
StatusTest_None = _StatusTest.StatusTest_None
class Generic(_object):
    """Proxy of C++ NOX::StatusTest::Generic class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Generic, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Generic, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _StatusTest.delete_Generic

    def checkStatus(self, *args):
        """checkStatus(Generic self, NOX::Solver::Generic const & problem, NOX::StatusTest::CheckType checkType) -> NOX::StatusTest::StatusType"""
        return _StatusTest.Generic_checkStatus(self, *args)


    def getStatus(self, *args):
        """getStatus(Generic self) -> NOX::StatusTest::StatusType"""
        return _StatusTest.Generic_getStatus(self, *args)


    def __str__(self, *args):
        """__str__(Generic self) -> std::string"""
        return _StatusTest.Generic___str__(self, *args)

Generic_swigregister = _StatusTest.Generic_swigregister
Generic_swigregister(Generic)


def __lshift__(*args):
    """__lshift__(std::ostream & os, NOX::StatusTest::StatusType type) -> std::ostream &"""
    return _StatusTest.__lshift__(*args)
class Combo(Generic):
    """Proxy of C++ NOX::StatusTest::Combo class."""

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Combo, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Combo, name)
    __repr__ = _swig_repr
    AND = _StatusTest.Combo_AND
    OR = _StatusTest.Combo_OR

    def __init__(self, *args):
        """
        __init__(NOX::StatusTest::Combo self, NOX::StatusTest::Combo::ComboType t, NOX::Utils const * u=None) -> Combo
        __init__(NOX::StatusTest::Combo self, NOX::StatusTest::Combo::ComboType t, Teuchos::RCP< NOX::StatusTest::Generic > const & a, NOX::Utils const * u=None) -> Combo
        __init__(NOX::StatusTest::Combo self, NOX::StatusTest::Combo::ComboType t, Teuchos::RCP< NOX::StatusTest::Generic > const & a, Teuchos::RCP< NOX::StatusTest::Generic > const & b, NOX::Utils const * u=None) -> Combo
        """
        this = _StatusTest.new_Combo(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def addStatusTest(self, *args):
        """addStatusTest(Combo self, Teuchos::RCP< NOX::StatusTest::Generic > const & a) -> Combo"""
        return _StatusTest.Combo_addStatusTest(self, *args)

    __swig_destroy__ = _StatusTest.delete_Combo

    def checkStatus(self, *args):
        """checkStatus(Combo self, NOX::Solver::Generic const & problem, NOX::StatusTest::CheckType checkType) -> NOX::StatusTest::StatusType"""
        return _StatusTest.Combo_checkStatus(self, *args)


    def getStatus(self, *args):
        """getStatus(Combo self) -> NOX::StatusTest::StatusType"""
        return _StatusTest.Combo_getStatus(self, *args)

Combo_swigregister = _StatusTest.Combo_swigregister
Combo_swigregister(Combo)

class NormF(Generic):
    """Proxy of C++ NOX::StatusTest::NormF class."""

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NormF, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NormF, name)
    __repr__ = _swig_repr
    Unscaled = _StatusTest.NormF_Unscaled
    Scaled = _StatusTest.NormF_Scaled
    Relative = _StatusTest.NormF_Relative
    Absolute = _StatusTest.NormF_Absolute

    def __init__(self, *args):
        """
        __init__(NOX::StatusTest::NormF self, double tolerance, NOX::Abstract::Vector::NormType ntype, NOX::StatusTest::NormF::ScaleType stype, NOX::Utils const * u=None) -> NormF
        __init__(NOX::StatusTest::NormF self, double tolerance, NOX::StatusTest::NormF::ScaleType stype, NOX::Utils const * u=None) -> NormF
        __init__(NOX::StatusTest::NormF self, Group initialGuess, double tolerance, NOX::Abstract::Vector::NormType ntype, NOX::StatusTest::NormF::ScaleType stype, NOX::Utils const * u=None) -> NormF
        __init__(NOX::StatusTest::NormF self, Group initialGuess, double tolerance, NOX::StatusTest::NormF::ScaleType stype, NOX::Utils const * u=None) -> NormF
        """
        this = _StatusTest.new_NormF(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _StatusTest.delete_NormF

    def checkStatus(self, *args):
        """checkStatus(NormF self, NOX::Solver::Generic const & problem, NOX::StatusTest::CheckType checkType) -> NOX::StatusTest::StatusType"""
        return _StatusTest.NormF_checkStatus(self, *args)


    def getStatus(self, *args):
        """getStatus(NormF self) -> NOX::StatusTest::StatusType"""
        return _StatusTest.NormF_getStatus(self, *args)


    def reset(self, *args):
        """
        reset(NormF self, double tolerance)
        reset(NormF self, Group initialGuess, double tolerance)
        """
        return _StatusTest.NormF_reset(self, *args)


    def getNormF(self, *args):
        """getNormF(NormF self) -> double"""
        return _StatusTest.NormF_getNormF(self, *args)


    def getTrueTolerance(self, *args):
        """getTrueTolerance(NormF self) -> double"""
        return _StatusTest.NormF_getTrueTolerance(self, *args)


    def getSpecifiedTolerance(self, *args):
        """getSpecifiedTolerance(NormF self) -> double"""
        return _StatusTest.NormF_getSpecifiedTolerance(self, *args)


    def getInitialTolerance(self, *args):
        """getInitialTolerance(NormF self) -> double"""
        return _StatusTest.NormF_getInitialTolerance(self, *args)

NormF_swigregister = _StatusTest.NormF_swigregister
NormF_swigregister(NormF)

class NormUpdate(Generic):
    """Proxy of C++ NOX::StatusTest::NormUpdate class."""

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NormUpdate, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NormUpdate, name)
    __repr__ = _swig_repr
    Unscaled = _StatusTest.NormUpdate_Unscaled
    Scaled = _StatusTest.NormUpdate_Scaled

    def __init__(self, *args):
        """
        __init__(NOX::StatusTest::NormUpdate self, double tolerance, NOX::Abstract::Vector::NormType ntype, NOX::StatusTest::NormUpdate::ScaleType stype) -> NormUpdate
        __init__(NOX::StatusTest::NormUpdate self, double tolerance, NOX::StatusTest::NormUpdate::ScaleType stype) -> NormUpdate
        """
        this = _StatusTest.new_NormUpdate(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _StatusTest.delete_NormUpdate

    def checkStatus(self, *args):
        """checkStatus(NormUpdate self, NOX::Solver::Generic const & problem, NOX::StatusTest::CheckType checkType) -> NOX::StatusTest::StatusType"""
        return _StatusTest.NormUpdate_checkStatus(self, *args)


    def getStatus(self, *args):
        """getStatus(NormUpdate self) -> NOX::StatusTest::StatusType"""
        return _StatusTest.NormUpdate_getStatus(self, *args)


    def getNormUpdate(self, *args):
        """getNormUpdate(NormUpdate self) -> double"""
        return _StatusTest.NormUpdate_getNormUpdate(self, *args)


    def getTolerance(self, *args):
        """getTolerance(NormUpdate self) -> double"""
        return _StatusTest.NormUpdate_getTolerance(self, *args)

NormUpdate_swigregister = _StatusTest.NormUpdate_swigregister
NormUpdate_swigregister(NormUpdate)

class NormWRMS(Generic):
    """Proxy of C++ NOX::StatusTest::NormWRMS class."""

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NormWRMS, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NormWRMS, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(NOX::StatusTest::NormWRMS self, double rtol, double atol, double BDFMultiplier=1.0, double tolerance=1.0, double alpha=1.0, double beta=0.5, bool disable_implicit_weighting=True) -> NormWRMS
        __init__(NOX::StatusTest::NormWRMS self, double rtol, Teuchos::RCP< NOX::Abstract::Vector const > const & atol, double BDFMultiplier=1.0, double tolerance=1.0, double alpha=1.0, double beta=0.5, bool disable_implicit_weighting=True) -> NormWRMS
        """
        this = _StatusTest.new_NormWRMS(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _StatusTest.delete_NormWRMS

    def checkStatus(self, *args):
        """checkStatus(NormWRMS self, NOX::Solver::Generic const & problem, NOX::StatusTest::CheckType checkType) -> NOX::StatusTest::StatusType"""
        return _StatusTest.NormWRMS_checkStatus(self, *args)


    def getStatus(self, *args):
        """getStatus(NormWRMS self) -> NOX::StatusTest::StatusType"""
        return _StatusTest.NormWRMS_getStatus(self, *args)


    def getNormWRMS(self, *args):
        """getNormWRMS(NormWRMS self) -> double"""
        return _StatusTest.NormWRMS_getNormWRMS(self, *args)


    def getTolerance(self, *args):
        """getTolerance(NormWRMS self) -> double"""
        return _StatusTest.NormWRMS_getTolerance(self, *args)


    def getRTOL(self, *args):
        """getRTOL(NormWRMS self) -> double"""
        return _StatusTest.NormWRMS_getRTOL(self, *args)


    def getATOL(self, *args):
        """getATOL(NormWRMS self) -> double"""
        return _StatusTest.NormWRMS_getATOL(self, *args)


    def getBDFMultiplier(self, *args):
        """getBDFMultiplier(NormWRMS self) -> double"""
        return _StatusTest.NormWRMS_getBDFMultiplier(self, *args)


    def getAlpha(self, *args):
        """getAlpha(NormWRMS self) -> double"""
        return _StatusTest.NormWRMS_getAlpha(self, *args)


    def getBeta(self, *args):
        """getBeta(NormWRMS self) -> double"""
        return _StatusTest.NormWRMS_getBeta(self, *args)


    def getDisableImplicitWeighting(self, *args):
        """getDisableImplicitWeighting(NormWRMS self) -> bool"""
        return _StatusTest.NormWRMS_getDisableImplicitWeighting(self, *args)

NormWRMS_swigregister = _StatusTest.NormWRMS_swigregister
NormWRMS_swigregister(NormWRMS)

class MaxIters(Generic):
    """Proxy of C++ NOX::StatusTest::MaxIters class."""

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MaxIters, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MaxIters, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(NOX::StatusTest::MaxIters self, int maxIterations, NOX::Utils const * u=None) -> MaxIters"""
        this = _StatusTest.new_MaxIters(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _StatusTest.delete_MaxIters

    def checkStatus(self, *args):
        """checkStatus(MaxIters self, NOX::Solver::Generic const & problem, NOX::StatusTest::CheckType checkType) -> NOX::StatusTest::StatusType"""
        return _StatusTest.MaxIters_checkStatus(self, *args)


    def getStatus(self, *args):
        """getStatus(MaxIters self) -> NOX::StatusTest::StatusType"""
        return _StatusTest.MaxIters_getStatus(self, *args)


    def getMaxIters(self, *args):
        """getMaxIters(MaxIters self) -> int"""
        return _StatusTest.MaxIters_getMaxIters(self, *args)


    def getNumIters(self, *args):
        """getNumIters(MaxIters self) -> int"""
        return _StatusTest.MaxIters_getNumIters(self, *args)

MaxIters_swigregister = _StatusTest.MaxIters_swigregister
MaxIters_swigregister(MaxIters)

class Stagnation(Generic):
    """Proxy of C++ NOX::StatusTest::Stagnation class."""

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Stagnation, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Stagnation, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(NOX::StatusTest::Stagnation self, int n=50, double tol=1.0) -> Stagnation"""
        this = _StatusTest.new_Stagnation(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _StatusTest.delete_Stagnation

    def checkStatus(self, *args):
        """checkStatus(Stagnation self, NOX::Solver::Generic const & problem, NOX::StatusTest::CheckType checkType) -> NOX::StatusTest::StatusType"""
        return _StatusTest.Stagnation_checkStatus(self, *args)


    def getStatus(self, *args):
        """getStatus(Stagnation self) -> NOX::StatusTest::StatusType"""
        return _StatusTest.Stagnation_getStatus(self, *args)


    def getMaxNumSteps(self, *args):
        """getMaxNumSteps(Stagnation self) -> int"""
        return _StatusTest.Stagnation_getMaxNumSteps(self, *args)


    def getCurrentNumSteps(self, *args):
        """getCurrentNumSteps(Stagnation self) -> int"""
        return _StatusTest.Stagnation_getCurrentNumSteps(self, *args)


    def getTolerance(self, *args):
        """getTolerance(Stagnation self) -> double"""
        return _StatusTest.Stagnation_getTolerance(self, *args)


    def getConvRate(self, *args):
        """getConvRate(Stagnation self) -> double"""
        return _StatusTest.Stagnation_getConvRate(self, *args)

Stagnation_swigregister = _StatusTest.Stagnation_swigregister
Stagnation_swigregister(Stagnation)

class FiniteValue(Generic):
    """Proxy of C++ NOX::StatusTest::FiniteValue class."""

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FiniteValue, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FiniteValue, name)
    __repr__ = _swig_repr
    FVector = _StatusTest.FiniteValue_FVector
    SolutionVector = _StatusTest.FiniteValue_SolutionVector

    def __init__(self, *args):
        """__init__(NOX::StatusTest::FiniteValue self, NOX::StatusTest::FiniteValue::VectorType v, NOX::Abstract::Vector::NormType n) -> FiniteValue"""
        this = _StatusTest.new_FiniteValue(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _StatusTest.delete_FiniteValue

    def checkStatus(self, *args):
        """checkStatus(FiniteValue self, NOX::Solver::Generic const & problem, NOX::StatusTest::CheckType checkType) -> NOX::StatusTest::StatusType"""
        return _StatusTest.FiniteValue_checkStatus(self, *args)


    def getStatus(self, *args):
        """getStatus(FiniteValue self) -> NOX::StatusTest::StatusType"""
        return _StatusTest.FiniteValue_getStatus(self, *args)


    def finiteNumberTest(self, *args):
        """finiteNumberTest(FiniteValue self, double x) -> int"""
        return _StatusTest.FiniteValue_finiteNumberTest(self, *args)

FiniteValue_swigregister = _StatusTest.FiniteValue_swigregister
FiniteValue_swigregister(FiniteValue)

# This file is compatible with both classic and new-style classes.


