# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.NOX.Solver is the python interface to the Solver namespace
of the Trilinos package NOX:

    http://trilinos.sandia.gov/packages/nox

The purpose of NOX.Solver is to provide solver manager classes for
NOX.  NOX.Solver provides the following user-level classes:

    * Generic                  - Base class for solver managers
    * LineSearchBased          - Line-search-based solver manager
    * TrustRegionBased         - Trust-region-based solver manager
    * InexactTrustRegionBased  - Inexact-trust-region-based solver
                                 manager
    * TensorBased              - Tensor-based solver manager

in addition to the following factory function:

    * buildSolver              - Recommended method for creating solver
                                 managers (note that without loss of
                                 functionality, the Factory class is not
                                 currently provided).

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Solver')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Solver')
    _Solver = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Solver', [dirname(__file__)])
        except ImportError:
            import _Solver
            return _Solver
        try:
            _mod = imp.load_module('_Solver', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Solver = swig_import_helper()
    del swig_import_helper
else:
    import _Solver
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos
import PyTrilinos.NOX.Abstract
import PyTrilinos.NOX.StatusTest
class Generic(_object):
    """Proxy of C++ NOX::Solver::Generic class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Generic, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Generic, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Solver.delete_Generic

    def reset(self, *args):
        """
        reset(Generic self, Vector initial_guess)
        reset(Generic self, Vector initial_guess, Teuchos::RCP< NOX::StatusTest::Generic > const & test)
        """
        return _Solver.Generic_reset(self, *args)


    def getStatus(self, *args):
        """getStatus(Generic self) -> NOX::StatusTest::StatusType"""
        return _Solver.Generic_getStatus(self, *args)


    def step(self, *args):
        """step(Generic self) -> NOX::StatusTest::StatusType"""
        return _Solver.Generic_step(self, *args)


    def solve(self, *args):
        """solve(Generic self) -> NOX::StatusTest::StatusType"""
        return _Solver.Generic_solve(self, *args)


    def getNumIterations(self, *args):
        """getNumIterations(Generic self) -> int"""
        return _Solver.Generic_getNumIterations(self, *args)


    def getSolutionGroup(self, *args):
        """getSolutionGroup(Generic self) -> Teuchos::RCP< NOX::Abstract::Group const >"""
        return _Solver.Generic_getSolutionGroup(self, *args)


    def getPreviousSolutionGroup(self, *args):
        """getPreviousSolutionGroup(Generic self) -> Teuchos::RCP< NOX::Abstract::Group const >"""
        return _Solver.Generic_getPreviousSolutionGroup(self, *args)


    def getList(self, *args):
        """getList(Generic self) -> Teuchos::RCP< Teuchos::ParameterList const >"""
        return _Solver.Generic_getList(self, *args)

Generic_swigregister = _Solver.Generic_swigregister
Generic_swigregister(Generic)

class LineSearchBased(Generic):
    """Proxy of C++ NOX::Solver::LineSearchBased class."""

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LineSearchBased, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LineSearchBased, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(NOX::Solver::LineSearchBased self, Teuchos::RCP< NOX::Abstract::Group > const & grp, Teuchos::RCP< NOX::StatusTest::Generic > const & tests, Teuchos::RCP< Teuchos::ParameterList > const & params) -> LineSearchBased"""
        this = _Solver.new_LineSearchBased(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Solver.delete_LineSearchBased

    def reset(self, *args):
        """
        reset(LineSearchBased self, Vector initialGuess, Teuchos::RCP< NOX::StatusTest::Generic > const & tests)
        reset(LineSearchBased self, Vector initialGuess)
        """
        return _Solver.LineSearchBased_reset(self, *args)


    def getStatus(self, *args):
        """getStatus(LineSearchBased self) -> NOX::StatusTest::StatusType"""
        return _Solver.LineSearchBased_getStatus(self, *args)


    def step(self, *args):
        """step(LineSearchBased self) -> NOX::StatusTest::StatusType"""
        return _Solver.LineSearchBased_step(self, *args)


    def solve(self, *args):
        """solve(LineSearchBased self) -> NOX::StatusTest::StatusType"""
        return _Solver.LineSearchBased_solve(self, *args)


    def getNumIterations(self, *args):
        """getNumIterations(LineSearchBased self) -> int"""
        return _Solver.LineSearchBased_getNumIterations(self, *args)


    def getStepSize(self, *args):
        """getStepSize(LineSearchBased self) -> double"""
        return _Solver.LineSearchBased_getStepSize(self, *args)


    def getSolutionGroup(self, *args):
        """getSolutionGroup(LineSearchBased self) -> Teuchos::RCP< NOX::Abstract::Group const >"""
        return _Solver.LineSearchBased_getSolutionGroup(self, *args)


    def getPreviousSolutionGroup(self, *args):
        """getPreviousSolutionGroup(LineSearchBased self) -> Teuchos::RCP< NOX::Abstract::Group const >"""
        return _Solver.LineSearchBased_getPreviousSolutionGroup(self, *args)


    def getList(self, *args):
        """getList(LineSearchBased self) -> Teuchos::RCP< Teuchos::ParameterList const >"""
        return _Solver.LineSearchBased_getList(self, *args)

LineSearchBased_swigregister = _Solver.LineSearchBased_swigregister
LineSearchBased_swigregister(LineSearchBased)

class TrustRegionBased(Generic):
    """Proxy of C++ NOX::Solver::TrustRegionBased class."""

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TrustRegionBased, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TrustRegionBased, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(NOX::Solver::TrustRegionBased self, Teuchos::RCP< NOX::Abstract::Group > const & grp, Teuchos::RCP< NOX::StatusTest::Generic > const & tests, Teuchos::RCP< Teuchos::ParameterList > const & params) -> TrustRegionBased"""
        this = _Solver.new_TrustRegionBased(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Solver.delete_TrustRegionBased

    def reset(self, *args):
        """
        reset(TrustRegionBased self, Vector initialGuess, Teuchos::RCP< NOX::StatusTest::Generic > const & tests)
        reset(TrustRegionBased self, Vector initialGuess)
        """
        return _Solver.TrustRegionBased_reset(self, *args)


    def getStatus(self, *args):
        """getStatus(TrustRegionBased self) -> NOX::StatusTest::StatusType"""
        return _Solver.TrustRegionBased_getStatus(self, *args)


    def step(self, *args):
        """step(TrustRegionBased self) -> NOX::StatusTest::StatusType"""
        return _Solver.TrustRegionBased_step(self, *args)


    def solve(self, *args):
        """solve(TrustRegionBased self) -> NOX::StatusTest::StatusType"""
        return _Solver.TrustRegionBased_solve(self, *args)


    def getNumIterations(self, *args):
        """getNumIterations(TrustRegionBased self) -> int"""
        return _Solver.TrustRegionBased_getNumIterations(self, *args)


    def getSolutionGroup(self, *args):
        """getSolutionGroup(TrustRegionBased self) -> Teuchos::RCP< NOX::Abstract::Group const >"""
        return _Solver.TrustRegionBased_getSolutionGroup(self, *args)


    def getPreviousSolutionGroup(self, *args):
        """getPreviousSolutionGroup(TrustRegionBased self) -> Teuchos::RCP< NOX::Abstract::Group const >"""
        return _Solver.TrustRegionBased_getPreviousSolutionGroup(self, *args)


    def getList(self, *args):
        """getList(TrustRegionBased self) -> Teuchos::RCP< Teuchos::ParameterList const >"""
        return _Solver.TrustRegionBased_getList(self, *args)

TrustRegionBased_swigregister = _Solver.TrustRegionBased_swigregister
TrustRegionBased_swigregister(TrustRegionBased)

class InexactTrustRegionBased(Generic):
    """Proxy of C++ NOX::Solver::InexactTrustRegionBased class."""

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InexactTrustRegionBased, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InexactTrustRegionBased, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(NOX::Solver::InexactTrustRegionBased self, Teuchos::RCP< NOX::Abstract::Group > const & grp, Teuchos::RCP< NOX::StatusTest::Generic > const & tests, Teuchos::RCP< Teuchos::ParameterList > const & params) -> InexactTrustRegionBased"""
        this = _Solver.new_InexactTrustRegionBased(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Solver.delete_InexactTrustRegionBased

    def reset(self, *args):
        """
        reset(InexactTrustRegionBased self, Vector initialGuess, Teuchos::RCP< NOX::StatusTest::Generic > const & tests)
        reset(InexactTrustRegionBased self, Vector initialGuess)
        """
        return _Solver.InexactTrustRegionBased_reset(self, *args)


    def getStatus(self, *args):
        """getStatus(InexactTrustRegionBased self) -> NOX::StatusTest::StatusType"""
        return _Solver.InexactTrustRegionBased_getStatus(self, *args)


    def step(self, *args):
        """step(InexactTrustRegionBased self) -> NOX::StatusTest::StatusType"""
        return _Solver.InexactTrustRegionBased_step(self, *args)


    def solve(self, *args):
        """solve(InexactTrustRegionBased self) -> NOX::StatusTest::StatusType"""
        return _Solver.InexactTrustRegionBased_solve(self, *args)


    def getNumIterations(self, *args):
        """getNumIterations(InexactTrustRegionBased self) -> int"""
        return _Solver.InexactTrustRegionBased_getNumIterations(self, *args)


    def getSolutionGroup(self, *args):
        """getSolutionGroup(InexactTrustRegionBased self) -> Teuchos::RCP< NOX::Abstract::Group const >"""
        return _Solver.InexactTrustRegionBased_getSolutionGroup(self, *args)


    def getPreviousSolutionGroup(self, *args):
        """getPreviousSolutionGroup(InexactTrustRegionBased self) -> Teuchos::RCP< NOX::Abstract::Group const >"""
        return _Solver.InexactTrustRegionBased_getPreviousSolutionGroup(self, *args)


    def getList(self, *args):
        """getList(InexactTrustRegionBased self) -> Teuchos::RCP< Teuchos::ParameterList const >"""
        return _Solver.InexactTrustRegionBased_getList(self, *args)

InexactTrustRegionBased_swigregister = _Solver.InexactTrustRegionBased_swigregister
InexactTrustRegionBased_swigregister(InexactTrustRegionBased)

class TensorBased(Generic):
    """Proxy of C++ NOX::Solver::TensorBased class."""

    __swig_setmethods__ = {}
    for _s in [Generic]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, TensorBased, name, value)
    __swig_getmethods__ = {}
    for _s in [Generic]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, TensorBased, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(NOX::Solver::TensorBased self, Teuchos::RCP< NOX::Abstract::Group > const & grp, Teuchos::RCP< NOX::StatusTest::Generic > const & tests, Teuchos::RCP< Teuchos::ParameterList > const & params) -> TensorBased"""
        this = _Solver.new_TensorBased(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Solver.delete_TensorBased

    def reset(self, *args):
        """
        reset(TensorBased self, Vector initialGuess, Teuchos::RCP< NOX::StatusTest::Generic > const & tests)
        reset(TensorBased self, Vector initialGuess)
        """
        return _Solver.TensorBased_reset(self, *args)


    def getStatus(self, *args):
        """getStatus(TensorBased self) -> NOX::StatusTest::StatusType"""
        return _Solver.TensorBased_getStatus(self, *args)


    def step(self, *args):
        """step(TensorBased self) -> NOX::StatusTest::StatusType"""
        return _Solver.TensorBased_step(self, *args)


    def solve(self, *args):
        """solve(TensorBased self) -> NOX::StatusTest::StatusType"""
        return _Solver.TensorBased_solve(self, *args)


    def getNumIterations(self, *args):
        """getNumIterations(TensorBased self) -> int"""
        return _Solver.TensorBased_getNumIterations(self, *args)


    def getSolutionGroup(self, *args):
        """getSolutionGroup(TensorBased self) -> Teuchos::RCP< NOX::Abstract::Group const >"""
        return _Solver.TensorBased_getSolutionGroup(self, *args)


    def getPreviousSolutionGroup(self, *args):
        """getPreviousSolutionGroup(TensorBased self) -> Teuchos::RCP< NOX::Abstract::Group const >"""
        return _Solver.TensorBased_getPreviousSolutionGroup(self, *args)


    def getList(self, *args):
        """getList(TensorBased self) -> Teuchos::RCP< Teuchos::ParameterList const >"""
        return _Solver.TensorBased_getList(self, *args)

TensorBased_swigregister = _Solver.TensorBased_swigregister
TensorBased_swigregister(TensorBased)


def buildSolver(*args):
    """buildSolver(Teuchos::RCP< NOX::Abstract::Group > const & grp, Teuchos::RCP< NOX::StatusTest::Generic > const & tests, Teuchos::RCP< Teuchos::ParameterList > const & params) -> PyObject *"""
    return _Solver.buildSolver(*args)
# This file is compatible with both classic and new-style classes.


