# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.LOCA.Hopf.MooreSpence is the python interface to namespace
Hopf::MooreSpence of the Trilinos continuation algorithm package LOCA:

    http://trilinos.sandia.gov/packages/nox

The purpose of LOCA.Hopf.MooreSpence is to provide ***.  The python
version of LOCA.Hopf.MooreSpence supports the following classes:

    * AbstractGroup          - Interface to underlying groups for Hopf point
                               calculations using the Moore-Spence formulation
    * ExtendedGroup          - A group representing the Moore-Spence Hopf
                               equations
    * ExtendedMultiVector    - Multi-vector class to hold solution vectors,
                               Newton vectors, etc.for the Moore-Spence Hopf
                               eqautions
    * ExtendedVector         - Vector class to hold solution vectors, Newton
                               vectors, etc. for Moore-Spence Hopf equations
    * FiniteDifferenceGroup  - Concrete class that provides concrete
                               implementations of the derivative computation
                               methods of the LOCA.Hopf.MooreSpence.-
                               AbstractGroup using first-order finite
                               differencing
    * SolverFactory          - Factory for creating solver objects for solving
                               Moore-Spence Hopf equations
    * SolverStrategy         - Abstract strategy for solving the Moore-Spence
                               Hopf equations
    * SalingerBordering      - Moore-Spence Hopf solver strategy based on
                               'Salinger' bordering.  This is the classic 5-
                               solve Hopf bordering method

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_MooreSpence')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_MooreSpence')
    _MooreSpence = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_MooreSpence', [dirname(__file__)])
        except ImportError:
            import _MooreSpence
            return _MooreSpence
        try:
            _mod = imp.load_module('_MooreSpence', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _MooreSpence = swig_import_helper()
    del swig_import_helper
else:
    import _MooreSpence
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos

import sys, os.path as op
parentDir = op.normpath(op.join(op.dirname(op.abspath(__file__)),".."))
if not parentDir in sys.path: sys.path.append(parentDir)
del sys, op

import PyTrilinos.NOX.Abstract
import Extended
import MultiContinuation
import TimeDependent
import TurningPoint.MooreSpence
class AbstractGroup(TurningPoint.MooreSpence.AbstractGroup, TimeDependent.AbstractGroup):
    """Proxy of C++ LOCA::Hopf::MooreSpence::AbstractGroup class."""

    __swig_setmethods__ = {}
    for _s in [TurningPoint.MooreSpence.AbstractGroup, TimeDependent.AbstractGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AbstractGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [TurningPoint.MooreSpence.AbstractGroup, TimeDependent.AbstractGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, AbstractGroup, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _MooreSpence.delete_AbstractGroup

    def isComplex(self, *args):
        """isComplex(AbstractGroup self) -> bool"""
        return _MooreSpence.AbstractGroup_isComplex(self, *args)


    def computeComplex(self, *args):
        """computeComplex(AbstractGroup self, double frequency) -> NOX::Abstract::Group::ReturnType"""
        return _MooreSpence.AbstractGroup_computeComplex(self, *args)


    def applyComplex(self, *args):
        """applyComplex(AbstractGroup self, Vector input_real, Vector input_imag, Vector result_real, Vector result_imag) -> NOX::Abstract::Group::ReturnType"""
        return _MooreSpence.AbstractGroup_applyComplex(self, *args)


    def applyComplexMultiVector(self, *args):
        """applyComplexMultiVector(AbstractGroup self, MultiVector input_real, MultiVector input_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType"""
        return _MooreSpence.AbstractGroup_applyComplexMultiVector(self, *args)


    def applyComplexInverseMultiVector(self, *args):
        """applyComplexInverseMultiVector(AbstractGroup self, ParameterList params, MultiVector input_real, MultiVector input_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType"""
        return _MooreSpence.AbstractGroup_applyComplexInverseMultiVector(self, *args)


    def computeDCeDp(self, *args):
        """computeDCeDp(AbstractGroup self, std::vector< int,std::allocator< int > > const & paramIDs, Vector yVector, Vector zVector, double w, MultiVector result_real, MultiVector result_imag, bool isValid) -> NOX::Abstract::Group::ReturnType"""
        return _MooreSpence.AbstractGroup_computeDCeDp(self, *args)


    def computeDCeDxa(self, *args):
        """
        computeDCeDxa(AbstractGroup self, Vector yVector, Vector zVector, double w, MultiVector aVector, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType
        computeDCeDxa(AbstractGroup self, Vector yVector, Vector zVector, double w, MultiVector aVector, Vector Ce_real, Vector Ce_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType
        """
        return _MooreSpence.AbstractGroup_computeDCeDxa(self, *args)

AbstractGroup_swigregister = _MooreSpence.AbstractGroup_swigregister
AbstractGroup_swigregister(AbstractGroup)

class ExtendedGroup(Extended.MultiAbstractGroup, MultiContinuation.AbstractGroup):
    """Proxy of C++ LOCA::Hopf::MooreSpence::ExtendedGroup class."""

    __swig_setmethods__ = {}
    for _s in [Extended.MultiAbstractGroup, MultiContinuation.AbstractGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExtendedGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [Extended.MultiAbstractGroup, MultiContinuation.AbstractGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ExtendedGroup, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Hopf::MooreSpence::ExtendedGroup self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & hopfParams, Teuchos::RCP< LOCA::Hopf::MooreSpence::AbstractGroup > const & g) -> ExtendedGroup
        __init__(LOCA::Hopf::MooreSpence::ExtendedGroup self, ExtendedGroup source, NOX::CopyType type) -> ExtendedGroup
        """
        this = _MooreSpence.new_ExtendedGroup(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MooreSpence.delete_ExtendedGroup

    def clone(self, *args):
        """clone(ExtendedGroup self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Group >"""
        return _MooreSpence.ExtendedGroup_clone(self, *args)


    def setX(self, *args):
        """setX(ExtendedGroup self, Vector y)"""
        return _MooreSpence.ExtendedGroup_setX(self, *args)


    def computeX(self, *args):
        """computeX(ExtendedGroup self, Group g, Vector d, double step)"""
        return _MooreSpence.ExtendedGroup_computeX(self, *args)


    def computeF(self, *args):
        """computeF(ExtendedGroup self) -> NOX::Abstract::Group::ReturnType"""
        return _MooreSpence.ExtendedGroup_computeF(self, *args)


    def computeJacobian(self, *args):
        """computeJacobian(ExtendedGroup self) -> NOX::Abstract::Group::ReturnType"""
        return _MooreSpence.ExtendedGroup_computeJacobian(self, *args)


    def computeGradient(self, *args):
        """computeGradient(ExtendedGroup self) -> NOX::Abstract::Group::ReturnType"""
        return _MooreSpence.ExtendedGroup_computeGradient(self, *args)


    def computeNewton(self, *args):
        """computeNewton(ExtendedGroup self, ParameterList params) -> NOX::Abstract::Group::ReturnType"""
        return _MooreSpence.ExtendedGroup_computeNewton(self, *args)


    def applyJacobian(self, *args):
        """applyJacobian(ExtendedGroup self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType"""
        return _MooreSpence.ExtendedGroup_applyJacobian(self, *args)


    def applyJacobianTranspose(self, *args):
        """applyJacobianTranspose(ExtendedGroup self, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType"""
        return _MooreSpence.ExtendedGroup_applyJacobianTranspose(self, *args)


    def applyJacobianInverse(self, *args):
        """applyJacobianInverse(ExtendedGroup self, ParameterList params, Vector input, Vector result) -> NOX::Abstract::Group::ReturnType"""
        return _MooreSpence.ExtendedGroup_applyJacobianInverse(self, *args)


    def applyJacobianMultiVector(self, *args):
        """applyJacobianMultiVector(ExtendedGroup self, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType"""
        return _MooreSpence.ExtendedGroup_applyJacobianMultiVector(self, *args)


    def applyJacobianTransposeMultiVector(self, *args):
        """applyJacobianTransposeMultiVector(ExtendedGroup self, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType"""
        return _MooreSpence.ExtendedGroup_applyJacobianTransposeMultiVector(self, *args)


    def applyJacobianInverseMultiVector(self, *args):
        """applyJacobianInverseMultiVector(ExtendedGroup self, ParameterList params, MultiVector input, MultiVector result) -> NOX::Abstract::Group::ReturnType"""
        return _MooreSpence.ExtendedGroup_applyJacobianInverseMultiVector(self, *args)


    def isF(self, *args):
        """isF(ExtendedGroup self) -> bool"""
        return _MooreSpence.ExtendedGroup_isF(self, *args)


    def isJacobian(self, *args):
        """isJacobian(ExtendedGroup self) -> bool"""
        return _MooreSpence.ExtendedGroup_isJacobian(self, *args)


    def isGradient(self, *args):
        """isGradient(ExtendedGroup self) -> bool"""
        return _MooreSpence.ExtendedGroup_isGradient(self, *args)


    def isNewton(self, *args):
        """isNewton(ExtendedGroup self) -> bool"""
        return _MooreSpence.ExtendedGroup_isNewton(self, *args)


    def getNormF(self, *args):
        """getNormF(ExtendedGroup self) -> double"""
        return _MooreSpence.ExtendedGroup_getNormF(self, *args)


    def getX(self, *args):
        """getX(ExtendedGroup self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return _MooreSpence.ExtendedGroup_getX(self, *args)


    def getF(self, *args):
        """getF(ExtendedGroup self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return _MooreSpence.ExtendedGroup_getF(self, *args)


    def getGradient(self, *args):
        """getGradient(ExtendedGroup self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return _MooreSpence.ExtendedGroup_getGradient(self, *args)


    def getNewton(self, *args):
        """getNewton(ExtendedGroup self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return _MooreSpence.ExtendedGroup_getNewton(self, *args)


    def getNormNewtonSolveResidual(self, *args):
        """getNormNewtonSolveResidual(ExtendedGroup self) -> double"""
        return _MooreSpence.ExtendedGroup_getNormNewtonSolveResidual(self, *args)


    def getUnderlyingGroup(self, *args):
        """
        getUnderlyingGroup(ExtendedGroup self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup const >
        getUnderlyingGroup(ExtendedGroup self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup >
        """
        return _MooreSpence.ExtendedGroup_getUnderlyingGroup(self, *args)


    def copy(self, *args):
        """copy(ExtendedGroup self, Group source)"""
        return _MooreSpence.ExtendedGroup_copy(self, *args)


    def setParamsMulti(self, *args):
        """setParamsMulti(ExtendedGroup self, std::vector< int,std::allocator< int > > const & paramIDs, NOX::Abstract::MultiVector::DenseMatrix const & vals)"""
        return _MooreSpence.ExtendedGroup_setParamsMulti(self, *args)


    def setParams(self, *args):
        """setParams(ExtendedGroup self, LOCA::ParameterVector const & p)"""
        return _MooreSpence.ExtendedGroup_setParams(self, *args)


    def setParam(self, *args):
        """
        setParam(ExtendedGroup self, int paramID, double val)
        setParam(ExtendedGroup self, std::string paramID, double val)
        """
        return _MooreSpence.ExtendedGroup_setParam(self, *args)


    def getParams(self, *args):
        """getParams(ExtendedGroup self) -> LOCA::ParameterVector const &"""
        return _MooreSpence.ExtendedGroup_getParams(self, *args)


    def getParam(self, *args):
        """
        getParam(ExtendedGroup self, int paramID) -> double
        getParam(ExtendedGroup self, std::string paramID) -> double
        """
        return _MooreSpence.ExtendedGroup_getParam(self, *args)


    def computeDfDpMulti(self, *args):
        """computeDfDpMulti(ExtendedGroup self, std::vector< int,std::allocator< int > > const & paramIDs, MultiVector dfdp, bool isValidF) -> NOX::Abstract::Group::ReturnType"""
        return _MooreSpence.ExtendedGroup_computeDfDpMulti(self, *args)


    def preProcessContinuationStep(self, *args):
        """preProcessContinuationStep(ExtendedGroup self, LOCA::Abstract::Iterator::StepStatus stepStatus)"""
        return _MooreSpence.ExtendedGroup_preProcessContinuationStep(self, *args)


    def postProcessContinuationStep(self, *args):
        """postProcessContinuationStep(ExtendedGroup self, LOCA::Abstract::Iterator::StepStatus stepStatus)"""
        return _MooreSpence.ExtendedGroup_postProcessContinuationStep(self, *args)


    def projectToDraw(self, *args):
        """projectToDraw(ExtendedGroup self, Vector x, double * px)"""
        return _MooreSpence.ExtendedGroup_projectToDraw(self, *args)


    def projectToDrawDimension(self, *args):
        """projectToDrawDimension(ExtendedGroup self) -> int"""
        return _MooreSpence.ExtendedGroup_projectToDrawDimension(self, *args)


    def printSolution(self, *args):
        """
        printSolution(ExtendedGroup self, double const conParam)
        printSolution(ExtendedGroup self, Vector x_, double const conParam)
        """
        return _MooreSpence.ExtendedGroup_printSolution(self, *args)


    def getBifParam(self, *args):
        """getBifParam(ExtendedGroup self) -> double"""
        return _MooreSpence.ExtendedGroup_getBifParam(self, *args)


    def getFrequency(self, *args):
        """getFrequency(ExtendedGroup self) -> double"""
        return _MooreSpence.ExtendedGroup_getFrequency(self, *args)


    def lTransNorm(self, *args):
        """
        lTransNorm(ExtendedGroup self, Vector z) -> double
        lTransNorm(ExtendedGroup self, MultiVector z, NOX::Abstract::MultiVector::DenseMatrix & result)
        """
        return _MooreSpence.ExtendedGroup_lTransNorm(self, *args)

ExtendedGroup_swigregister = _MooreSpence.ExtendedGroup_swigregister
ExtendedGroup_swigregister(ExtendedGroup)

class ExtendedMultiVector(Extended.MultiVector):
    """Proxy of C++ LOCA::Hopf::MooreSpence::ExtendedMultiVector class."""

    __swig_setmethods__ = {}
    for _s in [Extended.MultiVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExtendedMultiVector, name, value)
    __swig_getmethods__ = {}
    for _s in [Extended.MultiVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ExtendedMultiVector, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Hopf::MooreSpence::ExtendedMultiVector self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Vector cloneVec, int nColumns) -> ExtendedMultiVector
        __init__(LOCA::Hopf::MooreSpence::ExtendedMultiVector self, Teuchos::RCP< LOCA::GlobalData > const & global_data, MultiVector xVec, MultiVector realEigenVec, MultiVector imagEigenVec, NOX::Abstract::MultiVector::DenseMatrix const & freqs, NOX::Abstract::MultiVector::DenseMatrix const & bifParams) -> ExtendedMultiVector
        __init__(LOCA::Hopf::MooreSpence::ExtendedMultiVector self, ExtendedMultiVector source, NOX::CopyType type) -> ExtendedMultiVector
        __init__(LOCA::Hopf::MooreSpence::ExtendedMultiVector self, ExtendedMultiVector source, int nColumns) -> ExtendedMultiVector
        __init__(LOCA::Hopf::MooreSpence::ExtendedMultiVector self, ExtendedMultiVector source, std::vector< int,std::allocator< int > > const & index, bool view) -> ExtendedMultiVector
        """
        this = _MooreSpence.new_ExtendedMultiVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MooreSpence.delete_ExtendedMultiVector

    def clone(self, *args):
        """clone(ExtendedMultiVector self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::MultiVector >"""
        return _MooreSpence.ExtendedMultiVector_clone(self, *args)


    def subCopy(self, *args):
        """subCopy(ExtendedMultiVector self, std::vector< int,std::allocator< int > > const & index) -> Teuchos::RCP< NOX::Abstract::MultiVector >"""
        return _MooreSpence.ExtendedMultiVector_subCopy(self, *args)


    def subView(self, *args):
        """subView(ExtendedMultiVector self, std::vector< int,std::allocator< int > > const & index) -> Teuchos::RCP< NOX::Abstract::MultiVector >"""
        return _MooreSpence.ExtendedMultiVector_subView(self, *args)


    def getXMultiVec(self, *args):
        """
        getXMultiVec(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector const >
        getXMultiVec(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector >
        """
        return _MooreSpence.ExtendedMultiVector_getXMultiVec(self, *args)


    def getRealEigenMultiVec(self, *args):
        """
        getRealEigenMultiVec(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector const >
        getRealEigenMultiVec(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector >
        """
        return _MooreSpence.ExtendedMultiVector_getRealEigenMultiVec(self, *args)


    def getImagEigenMultiVec(self, *args):
        """
        getImagEigenMultiVec(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector const >
        getImagEigenMultiVec(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector >
        """
        return _MooreSpence.ExtendedMultiVector_getImagEigenMultiVec(self, *args)


    def getFrequencies(self, *args):
        """
        getFrequencies(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector::DenseMatrix const >
        getFrequencies(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector::DenseMatrix >
        """
        return _MooreSpence.ExtendedMultiVector_getFrequencies(self, *args)


    def getBifParams(self, *args):
        """
        getBifParams(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector::DenseMatrix const >
        getBifParams(ExtendedMultiVector self) -> Teuchos::RCP< NOX::Abstract::MultiVector::DenseMatrix >
        """
        return _MooreSpence.ExtendedMultiVector_getBifParams(self, *args)


    def getColumn(self, *args):
        """
        getColumn(ExtendedMultiVector self, int i) -> Teuchos::RCP< LOCA::Hopf::MooreSpence::ExtendedVector >
        getColumn(ExtendedMultiVector self, int i) -> Teuchos::RCP< LOCA::Hopf::MooreSpence::ExtendedVector const >
        """
        return _MooreSpence.ExtendedMultiVector_getColumn(self, *args)

ExtendedMultiVector_swigregister = _MooreSpence.ExtendedMultiVector_swigregister
ExtendedMultiVector_swigregister(ExtendedMultiVector)

class ExtendedVector(Extended.Vector):
    """Proxy of C++ LOCA::Hopf::MooreSpence::ExtendedVector class."""

    __swig_setmethods__ = {}
    for _s in [Extended.Vector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExtendedVector, name, value)
    __swig_getmethods__ = {}
    for _s in [Extended.Vector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ExtendedVector, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Hopf::MooreSpence::ExtendedVector self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Vector xVec, Vector realEigenVec, Vector imagEigenVec, double frequency, double bifParam) -> ExtendedVector
        __init__(LOCA::Hopf::MooreSpence::ExtendedVector self, ExtendedVector source, NOX::CopyType type) -> ExtendedVector
        """
        this = _MooreSpence.new_ExtendedVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MooreSpence.delete_ExtendedVector

    def clone(self, *args):
        """clone(ExtendedVector self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Vector >"""
        return _MooreSpence.ExtendedVector_clone(self, *args)


    def setVec(self, *args):
        """setVec(ExtendedVector self, Vector xVec, Vector realEigenVec, Vector imagEigenVec, double frequency, double bifPar)"""
        return _MooreSpence.ExtendedVector_setVec(self, *args)


    def getXVec(self, *args):
        """
        getXVec(ExtendedVector self) -> Teuchos::RCP< NOX::Abstract::Vector const >
        getXVec(ExtendedVector self) -> Teuchos::RCP< NOX::Abstract::Vector >
        """
        return _MooreSpence.ExtendedVector_getXVec(self, *args)


    def getRealEigenVec(self, *args):
        """
        getRealEigenVec(ExtendedVector self) -> Teuchos::RCP< NOX::Abstract::Vector const >
        getRealEigenVec(ExtendedVector self) -> Teuchos::RCP< NOX::Abstract::Vector >
        """
        return _MooreSpence.ExtendedVector_getRealEigenVec(self, *args)


    def getImagEigenVec(self, *args):
        """
        getImagEigenVec(ExtendedVector self) -> Teuchos::RCP< NOX::Abstract::Vector const >
        getImagEigenVec(ExtendedVector self) -> Teuchos::RCP< NOX::Abstract::Vector >
        """
        return _MooreSpence.ExtendedVector_getImagEigenVec(self, *args)

ExtendedVector_swigregister = _MooreSpence.ExtendedVector_swigregister
ExtendedVector_swigregister(ExtendedVector)

class FiniteDifferenceGroup(AbstractGroup, TurningPoint.MooreSpence.FiniteDifferenceGroup):
    """Proxy of C++ LOCA::Hopf::MooreSpence::FiniteDifferenceGroup class."""

    __swig_setmethods__ = {}
    for _s in [AbstractGroup, TurningPoint.MooreSpence.FiniteDifferenceGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FiniteDifferenceGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [AbstractGroup, TurningPoint.MooreSpence.FiniteDifferenceGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FiniteDifferenceGroup, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _MooreSpence.delete_FiniteDifferenceGroup

    def computeDCeDp(self, *args):
        """computeDCeDp(FiniteDifferenceGroup self, std::vector< int,std::allocator< int > > const & paramIDs, Vector yVector, Vector zVector, double w, MultiVector result_real, MultiVector result_imag, bool isValid) -> NOX::Abstract::Group::ReturnType"""
        return _MooreSpence.FiniteDifferenceGroup_computeDCeDp(self, *args)


    def computeDCeDxa(self, *args):
        """
        computeDCeDxa(FiniteDifferenceGroup self, Vector yVector, Vector zVector, double w, MultiVector aVector, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType
        computeDCeDxa(FiniteDifferenceGroup self, Vector yVector, Vector zVector, double w, MultiVector aVector, Vector Ce_real, Vector Ce_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType
        """
        return _MooreSpence.FiniteDifferenceGroup_computeDCeDxa(self, *args)

FiniteDifferenceGroup_swigregister = _MooreSpence.FiniteDifferenceGroup_swigregister
FiniteDifferenceGroup_swigregister(FiniteDifferenceGroup)

class SolverFactory(_object):
    """Proxy of C++ LOCA::Hopf::MooreSpence::SolverFactory class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SolverFactory, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SolverFactory, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(LOCA::Hopf::MooreSpence::SolverFactory self, Teuchos::RCP< LOCA::GlobalData > const & global_data) -> SolverFactory"""
        this = _MooreSpence.new_SolverFactory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MooreSpence.delete_SolverFactory

    def create(self, *args):
        """create(SolverFactory self, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams) -> Teuchos::RCP< LOCA::Hopf::MooreSpence::SolverStrategy >"""
        return _MooreSpence.SolverFactory_create(self, *args)


    def strategyName(self, *args):
        """strategyName(SolverFactory self, ParameterList solverParams) -> std::string const &"""
        return _MooreSpence.SolverFactory_strategyName(self, *args)

SolverFactory_swigregister = _MooreSpence.SolverFactory_swigregister
SolverFactory_swigregister(SolverFactory)

class SolverStrategy(_object):
    """Proxy of C++ LOCA::Hopf::MooreSpence::SolverStrategy class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SolverStrategy, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SolverStrategy, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _MooreSpence.delete_SolverStrategy

    def setBlocks(self, *args):
        """setBlocks(SolverStrategy self, Teuchos::RCP< LOCA::Hopf::MooreSpence::AbstractGroup > const & group, Teuchos::RCP< LOCA::Hopf::MooreSpence::ExtendedGroup > const & hopfGroup, Teuchos::RCP< NOX::Abstract::Vector const > const & yVector, Teuchos::RCP< NOX::Abstract::Vector const > const & zVector, Teuchos::RCP< NOX::Abstract::Vector const > const & CeRealVector, Teuchos::RCP< NOX::Abstract::Vector const > const & CeImagVector, Teuchos::RCP< NOX::Abstract::Vector const > const & dfdp, Teuchos::RCP< NOX::Abstract::Vector const > const & dCedpReal, Teuchos::RCP< NOX::Abstract::Vector const > const & dCedpImag, Teuchos::RCP< NOX::Abstract::Vector const > const & ByVector, Teuchos::RCP< NOX::Abstract::Vector const > const & mBzVector, double w)"""
        return _MooreSpence.SolverStrategy_setBlocks(self, *args)


    def solve(self, *args):
        """solve(SolverStrategy self, ParameterList params, ExtendedMultiVector input, ExtendedMultiVector result) -> NOX::Abstract::Group::ReturnType"""
        return _MooreSpence.SolverStrategy_solve(self, *args)

SolverStrategy_swigregister = _MooreSpence.SolverStrategy_swigregister
SolverStrategy_swigregister(SolverStrategy)

class SalingerBordering(SolverStrategy):
    """Proxy of C++ LOCA::Hopf::MooreSpence::SalingerBordering class."""

    __swig_setmethods__ = {}
    for _s in [SolverStrategy]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SalingerBordering, name, value)
    __swig_getmethods__ = {}
    for _s in [SolverStrategy]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SalingerBordering, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(LOCA::Hopf::MooreSpence::SalingerBordering self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & solverParams) -> SalingerBordering"""
        this = _MooreSpence.new_SalingerBordering(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MooreSpence.delete_SalingerBordering

    def setBlocks(self, *args):
        """setBlocks(SalingerBordering self, Teuchos::RCP< LOCA::Hopf::MooreSpence::AbstractGroup > const & group, Teuchos::RCP< LOCA::Hopf::MooreSpence::ExtendedGroup > const & hopfGroup, Teuchos::RCP< NOX::Abstract::Vector const > const & yVector, Teuchos::RCP< NOX::Abstract::Vector const > const & zVector, Teuchos::RCP< NOX::Abstract::Vector const > const & CeRealVector, Teuchos::RCP< NOX::Abstract::Vector const > const & CeImagVector, Teuchos::RCP< NOX::Abstract::Vector const > const & dfdp, Teuchos::RCP< NOX::Abstract::Vector const > const & dCedpReal, Teuchos::RCP< NOX::Abstract::Vector const > const & dCedpImag, Teuchos::RCP< NOX::Abstract::Vector const > const & ByVector, Teuchos::RCP< NOX::Abstract::Vector const > const & mBzVector, double w)"""
        return _MooreSpence.SalingerBordering_setBlocks(self, *args)


    def solve(self, *args):
        """solve(SalingerBordering self, ParameterList params, ExtendedMultiVector input, ExtendedMultiVector result) -> NOX::Abstract::Group::ReturnType"""
        return _MooreSpence.SalingerBordering_solve(self, *args)

SalingerBordering_swigregister = _MooreSpence.SalingerBordering_swigregister
SalingerBordering_swigregister(SalingerBordering)

# This file is compatible with both classic and new-style classes.


