# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.LOCA.Hopf.MinimallyAugmented is the python interface to
namespace Hopf::MinimallyAugmented of the Trilinos continuation
algorithm package LOCA:

    http://trilinos.sandia.gov/packages/nox

The purpose of LOCA.Hopf.MinimallyAugmented is to provide groups and
vectors for locating Hopf bifurcations using the minimally augmented
Hopf formulation.  The python version of LOCA.Hopf.MinimallyAugmented
supports the following classes:

    * Constraint             - Implementation of LOCA.MultiContinuation.-
                               ConstraintInterfaceMVDX for computing Hopf
                               bifurcations for the minimally augmented Hopf
                               formulation
    * AbstractGroup          - Interface to underlying groups for Hopf
                               calculations using the minimally augmented
                               formulation
    * FiniteDifferenceGroup  - Concrete class that provides concrete
                               implementations of the derivative computation
                               methods of the LOCA.Hopf.MinimallyAugmented.-
                               AbstractGroup using first-order finite
                               differencing
    * ExtendedGroup          - Group representing the minimally augemented Hopf
                               equations

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_MinimallyAugmented')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_MinimallyAugmented')
    _MinimallyAugmented = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_MinimallyAugmented', [dirname(__file__)])
        except ImportError:
            import _MinimallyAugmented
            return _MinimallyAugmented
        try:
            _mod = imp.load_module('_MinimallyAugmented', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _MinimallyAugmented = swig_import_helper()
    del swig_import_helper
else:
    import _MinimallyAugmented
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


import PyTrilinos.Teuchos

import sys, os.path as op
parentDir = op.normpath(op.join(op.dirname(op.abspath(__file__)),".."))
if not parentDir in sys.path: sys.path.append(parentDir)
del sys, op

import PyTrilinos.NOX.Abstract
import BorderedSystem
import Extended
import MultiContinuation
import TimeDependent
import TurningPoint.MooreSpence
import MooreSpence
class Constraint(MultiContinuation.ConstraintInterfaceMVDX):
    """Proxy of C++ LOCA::Hopf::MinimallyAugmented::Constraint class."""

    __swig_setmethods__ = {}
    for _s in [MultiContinuation.ConstraintInterfaceMVDX]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Constraint, name, value)
    __swig_getmethods__ = {}
    for _s in [MultiContinuation.ConstraintInterfaceMVDX]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Constraint, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Hopf::MinimallyAugmented::Constraint self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & hpfParams, Teuchos::RCP< LOCA::Hopf::MinimallyAugmented::AbstractGroup > const & g, bool is_symmetric, Vector a_real, Vector a_imag, Vector b_real, Vector b_imag, int bif_param, double freq) -> Constraint
        __init__(LOCA::Hopf::MinimallyAugmented::Constraint self, Constraint source, NOX::CopyType type) -> Constraint
        """
        if self.__class__ == Constraint:
            _self = None
        else:
            _self = self
        this = _MinimallyAugmented.new_Constraint(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MinimallyAugmented.delete_Constraint

    def setGroup(self, *args):
        """setGroup(Constraint self, Teuchos::RCP< LOCA::Hopf::MinimallyAugmented::AbstractGroup > const & g)"""
        return _MinimallyAugmented.Constraint_setGroup(self, *args)


    def setFrequency(self, *args):
        """setFrequency(Constraint self, double freq)"""
        return _MinimallyAugmented.Constraint_setFrequency(self, *args)


    def getLeftNullVecReal(self, *args):
        """getLeftNullVecReal(Constraint self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return _MinimallyAugmented.Constraint_getLeftNullVecReal(self, *args)


    def getLeftNullVecImag(self, *args):
        """getLeftNullVecImag(Constraint self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return _MinimallyAugmented.Constraint_getLeftNullVecImag(self, *args)


    def getRightNullVecReal(self, *args):
        """getRightNullVecReal(Constraint self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return _MinimallyAugmented.Constraint_getRightNullVecReal(self, *args)


    def getRightNullVecImag(self, *args):
        """getRightNullVecImag(Constraint self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return _MinimallyAugmented.Constraint_getRightNullVecImag(self, *args)


    def getSigmaReal(self, *args):
        """getSigmaReal(Constraint self) -> double"""
        return _MinimallyAugmented.Constraint_getSigmaReal(self, *args)


    def getSigmaImag(self, *args):
        """getSigmaImag(Constraint self) -> double"""
        return _MinimallyAugmented.Constraint_getSigmaImag(self, *args)


    def copy(self, *args):
        """copy(Constraint self, ConstraintInterface source)"""
        return _MinimallyAugmented.Constraint_copy(self, *args)


    def clone(self, *args):
        """clone(Constraint self, NOX::CopyType type) -> Teuchos::RCP< LOCA::MultiContinuation::ConstraintInterface >"""
        return _MinimallyAugmented.Constraint_clone(self, *args)


    def numConstraints(self, *args):
        """numConstraints(Constraint self) -> int"""
        return _MinimallyAugmented.Constraint_numConstraints(self, *args)


    def setX(self, *args):
        """setX(Constraint self, Vector y)"""
        return _MinimallyAugmented.Constraint_setX(self, *args)


    def setParam(self, *args):
        """setParam(Constraint self, int paramID, double val)"""
        return _MinimallyAugmented.Constraint_setParam(self, *args)


    def setParams(self, *args):
        """setParams(Constraint self, std::vector< int,std::allocator< int > > const & paramIDs, NOX::Abstract::MultiVector::DenseMatrix const & vals)"""
        return _MinimallyAugmented.Constraint_setParams(self, *args)


    def computeConstraints(self, *args):
        """computeConstraints(Constraint self) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.Constraint_computeConstraints(self, *args)


    def computeDX(self, *args):
        """computeDX(Constraint self) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.Constraint_computeDX(self, *args)


    def computeDP(self, *args):
        """computeDP(Constraint self, std::vector< int,std::allocator< int > > const & paramIDs, NOX::Abstract::MultiVector::DenseMatrix & dgdp, bool isValidG) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.Constraint_computeDP(self, *args)


    def isConstraints(self, *args):
        """isConstraints(Constraint self) -> bool"""
        return _MinimallyAugmented.Constraint_isConstraints(self, *args)


    def isDX(self, *args):
        """isDX(Constraint self) -> bool"""
        return _MinimallyAugmented.Constraint_isDX(self, *args)


    def getConstraints(self, *args):
        """getConstraints(Constraint self) -> NOX::Abstract::MultiVector::DenseMatrix const &"""
        return _MinimallyAugmented.Constraint_getConstraints(self, *args)


    def getDX(self, *args):
        """getDX(Constraint self) -> MultiVector"""
        return _MinimallyAugmented.Constraint_getDX(self, *args)


    def isDXZero(self, *args):
        """isDXZero(Constraint self) -> bool"""
        return _MinimallyAugmented.Constraint_isDXZero(self, *args)


    def postProcessContinuationStep(self, *args):
        """postProcessContinuationStep(Constraint self, LOCA::Abstract::Iterator::StepStatus stepStatus)"""
        return _MinimallyAugmented.Constraint_postProcessContinuationStep(self, *args)


    def computeDOmega(self, *args):
        """computeDOmega(Constraint self, NOX::Abstract::MultiVector::DenseMatrix & domega) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.Constraint_computeDOmega(self, *args)

    def __disown__(self):
        self.this.disown()
        _MinimallyAugmented.disown_Constraint(self)
        return weakref_proxy(self)
Constraint_swigregister = _MinimallyAugmented.Constraint_swigregister
Constraint_swigregister(Constraint)

class AbstractGroup(MooreSpence.AbstractGroup):
    """Proxy of C++ LOCA::Hopf::MinimallyAugmented::AbstractGroup class."""

    __swig_setmethods__ = {}
    for _s in [MooreSpence.AbstractGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, AbstractGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [MooreSpence.AbstractGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, AbstractGroup, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(LOCA::Hopf::MinimallyAugmented::AbstractGroup self) -> AbstractGroup"""
        if self.__class__ == AbstractGroup:
            _self = None
        else:
            _self = self
        this = _MinimallyAugmented.new_AbstractGroup(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MinimallyAugmented.delete_AbstractGroup

    def applyComplexTranspose(self, *args):
        """applyComplexTranspose(AbstractGroup self, Vector input_real, Vector input_imag, Vector result_real, Vector result_imag) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.AbstractGroup_applyComplexTranspose(self, *args)


    def applyComplexTransposeMultiVector(self, *args):
        """applyComplexTransposeMultiVector(AbstractGroup self, MultiVector input_real, MultiVector input_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.AbstractGroup_applyComplexTransposeMultiVector(self, *args)


    def applyComplexTransposeInverseMultiVector(self, *args):
        """applyComplexTransposeInverseMultiVector(AbstractGroup self, ParameterList params, MultiVector input_real, MultiVector input_imag, MultiVector result_real, MultiVector result_imag) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.AbstractGroup_applyComplexTransposeInverseMultiVector(self, *args)


    def computeDwtCeDp(self, *args):
        """computeDwtCeDp(AbstractGroup self, std::vector< int,std::allocator< int > > const & paramIDs, Vector w1, Vector w2, Vector y, Vector z, double omega, NOX::Abstract::MultiVector::DenseMatrix & result_real, NOX::Abstract::MultiVector::DenseMatrix & result_imag, bool isValid) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.AbstractGroup_computeDwtCeDp(self, *args)


    def computeDwtCeDx(self, *args):
        """computeDwtCeDx(AbstractGroup self, Vector w1, Vector w2, Vector y, Vector z, double omega, Vector result_real, Vector result_imag) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.AbstractGroup_computeDwtCeDx(self, *args)

    def __disown__(self):
        self.this.disown()
        _MinimallyAugmented.disown_AbstractGroup(self)
        return weakref_proxy(self)
AbstractGroup_swigregister = _MinimallyAugmented.AbstractGroup_swigregister
AbstractGroup_swigregister(AbstractGroup)

class FiniteDifferenceGroup(AbstractGroup, MooreSpence.FiniteDifferenceGroup):
    """Proxy of C++ LOCA::Hopf::MinimallyAugmented::FiniteDifferenceGroup class."""

    __swig_setmethods__ = {}
    for _s in [AbstractGroup, MooreSpence.FiniteDifferenceGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FiniteDifferenceGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [AbstractGroup, MooreSpence.FiniteDifferenceGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FiniteDifferenceGroup, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Hopf::MinimallyAugmented::FiniteDifferenceGroup self) -> FiniteDifferenceGroup
        __init__(LOCA::Hopf::MinimallyAugmented::FiniteDifferenceGroup self, FiniteDifferenceGroup source, NOX::CopyType type) -> FiniteDifferenceGroup
        """
        if self.__class__ == FiniteDifferenceGroup:
            _self = None
        else:
            _self = self
        this = _MinimallyAugmented.new_FiniteDifferenceGroup(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MinimallyAugmented.delete_FiniteDifferenceGroup

    def computeDwtCeDp(self, *args):
        """computeDwtCeDp(FiniteDifferenceGroup self, std::vector< int,std::allocator< int > > const & paramIDs, Vector w1, Vector w2, Vector y, Vector x, double omega, NOX::Abstract::MultiVector::DenseMatrix & result_real, NOX::Abstract::MultiVector::DenseMatrix & result_imag, bool isValid) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.FiniteDifferenceGroup_computeDwtCeDp(self, *args)


    def computeDwtCeDx(self, *args):
        """computeDwtCeDx(FiniteDifferenceGroup self, Vector w1, Vector w2, Vector y, Vector z, double omega, Vector result_real, Vector result_imag) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.FiniteDifferenceGroup_computeDwtCeDx(self, *args)

    def __disown__(self):
        self.this.disown()
        _MinimallyAugmented.disown_FiniteDifferenceGroup(self)
        return weakref_proxy(self)
FiniteDifferenceGroup_swigregister = _MinimallyAugmented.FiniteDifferenceGroup_swigregister
FiniteDifferenceGroup_swigregister(FiniteDifferenceGroup)

class ExtendedGroup(Extended.MultiAbstractGroup, MultiContinuation.AbstractGroup, BorderedSystem.AbstractGroup):
    """Proxy of C++ LOCA::Hopf::MinimallyAugmented::ExtendedGroup class."""

    __swig_setmethods__ = {}
    for _s in [Extended.MultiAbstractGroup, MultiContinuation.AbstractGroup, BorderedSystem.AbstractGroup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ExtendedGroup, name, value)
    __swig_getmethods__ = {}
    for _s in [Extended.MultiAbstractGroup, MultiContinuation.AbstractGroup, BorderedSystem.AbstractGroup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ExtendedGroup, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(LOCA::Hopf::MinimallyAugmented::ExtendedGroup self, Teuchos::RCP< LOCA::GlobalData > const & global_data, Teuchos::RCP< LOCA::Parameter::SublistParser > const & topParams, Teuchos::RCP< Teuchos::ParameterList > const & hpfParams, Teuchos::RCP< LOCA::Hopf::MinimallyAugmented::AbstractGroup > const & grp) -> ExtendedGroup
        __init__(LOCA::Hopf::MinimallyAugmented::ExtendedGroup self, ExtendedGroup source, NOX::CopyType type) -> ExtendedGroup
        """
        this = _MinimallyAugmented.new_ExtendedGroup(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _MinimallyAugmented.delete_ExtendedGroup

    def getBifParam(self, *args):
        """getBifParam(ExtendedGroup self) -> double"""
        return _MinimallyAugmented.ExtendedGroup_getBifParam(self, *args)


    def clone(self, *args):
        """clone(ExtendedGroup self, NOX::CopyType type) -> Teuchos::RCP< NOX::Abstract::Group >"""
        return _MinimallyAugmented.ExtendedGroup_clone(self, *args)


    def setX(self, *args):
        """setX(ExtendedGroup self, Vector y)"""
        return _MinimallyAugmented.ExtendedGroup_setX(self, *args)


    def computeX(self, *args):
        """computeX(ExtendedGroup self, Group g, Vector d, double step)"""
        return _MinimallyAugmented.ExtendedGroup_computeX(self, *args)


    def computeF(self, *args):
        """computeF(ExtendedGroup self) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.ExtendedGroup_computeF(self, *args)


    def computeJacobian(self, *args):
        """computeJacobian(ExtendedGroup self) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.ExtendedGroup_computeJacobian(self, *args)


    def computeGradient(self, *args):
        """computeGradient(ExtendedGroup self) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.ExtendedGroup_computeGradient(self, *args)


    def computeNewton(self, *args):
        """computeNewton(ExtendedGroup self, ParameterList params) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.ExtendedGroup_computeNewton(self, *args)


    def applyJacobian(self, *args):
        """applyJacobian(ExtendedGroup self, Vector input, Vector loca_result) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.ExtendedGroup_applyJacobian(self, *args)


    def applyJacobianTranspose(self, *args):
        """applyJacobianTranspose(ExtendedGroup self, Vector input, Vector loca_result) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.ExtendedGroup_applyJacobianTranspose(self, *args)


    def applyJacobianInverse(self, *args):
        """applyJacobianInverse(ExtendedGroup self, ParameterList params, Vector input, Vector loca_result) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.ExtendedGroup_applyJacobianInverse(self, *args)


    def applyJacobianMultiVector(self, *args):
        """applyJacobianMultiVector(ExtendedGroup self, MultiVector input, MultiVector loca_result) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.ExtendedGroup_applyJacobianMultiVector(self, *args)


    def applyJacobianTransposeMultiVector(self, *args):
        """applyJacobianTransposeMultiVector(ExtendedGroup self, MultiVector input, MultiVector loca_result) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.ExtendedGroup_applyJacobianTransposeMultiVector(self, *args)


    def applyJacobianInverseMultiVector(self, *args):
        """applyJacobianInverseMultiVector(ExtendedGroup self, ParameterList params, MultiVector input, MultiVector loca_result) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.ExtendedGroup_applyJacobianInverseMultiVector(self, *args)


    def isF(self, *args):
        """isF(ExtendedGroup self) -> bool"""
        return _MinimallyAugmented.ExtendedGroup_isF(self, *args)


    def isJacobian(self, *args):
        """isJacobian(ExtendedGroup self) -> bool"""
        return _MinimallyAugmented.ExtendedGroup_isJacobian(self, *args)


    def isGradient(self, *args):
        """isGradient(ExtendedGroup self) -> bool"""
        return _MinimallyAugmented.ExtendedGroup_isGradient(self, *args)


    def isNewton(self, *args):
        """isNewton(ExtendedGroup self) -> bool"""
        return _MinimallyAugmented.ExtendedGroup_isNewton(self, *args)


    def getNormF(self, *args):
        """getNormF(ExtendedGroup self) -> double"""
        return _MinimallyAugmented.ExtendedGroup_getNormF(self, *args)


    def getX(self, *args):
        """getX(ExtendedGroup self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return _MinimallyAugmented.ExtendedGroup_getX(self, *args)


    def getF(self, *args):
        """getF(ExtendedGroup self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return _MinimallyAugmented.ExtendedGroup_getF(self, *args)


    def getGradient(self, *args):
        """getGradient(ExtendedGroup self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return _MinimallyAugmented.ExtendedGroup_getGradient(self, *args)


    def getNewton(self, *args):
        """getNewton(ExtendedGroup self) -> Teuchos::RCP< NOX::Abstract::Vector const >"""
        return _MinimallyAugmented.ExtendedGroup_getNewton(self, *args)


    def getNormNewtonSolveResidual(self, *args):
        """getNormNewtonSolveResidual(ExtendedGroup self) -> double"""
        return _MinimallyAugmented.ExtendedGroup_getNormNewtonSolveResidual(self, *args)


    def getUnderlyingGroup(self, *args):
        """
        getUnderlyingGroup(ExtendedGroup self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup const >
        getUnderlyingGroup(ExtendedGroup self) -> Teuchos::RCP< LOCA::MultiContinuation::AbstractGroup >
        """
        return _MinimallyAugmented.ExtendedGroup_getUnderlyingGroup(self, *args)


    def copy(self, *args):
        """copy(ExtendedGroup self, Group source)"""
        return _MinimallyAugmented.ExtendedGroup_copy(self, *args)


    def setParamsMulti(self, *args):
        """setParamsMulti(ExtendedGroup self, std::vector< int,std::allocator< int > > const & paramIDs, NOX::Abstract::MultiVector::DenseMatrix const & vals)"""
        return _MinimallyAugmented.ExtendedGroup_setParamsMulti(self, *args)


    def setParams(self, *args):
        """setParams(ExtendedGroup self, LOCA::ParameterVector const & p)"""
        return _MinimallyAugmented.ExtendedGroup_setParams(self, *args)


    def setParam(self, *args):
        """
        setParam(ExtendedGroup self, int paramID, double val)
        setParam(ExtendedGroup self, std::string paramID, double val)
        """
        return _MinimallyAugmented.ExtendedGroup_setParam(self, *args)


    def getParams(self, *args):
        """getParams(ExtendedGroup self) -> LOCA::ParameterVector const &"""
        return _MinimallyAugmented.ExtendedGroup_getParams(self, *args)


    def getParam(self, *args):
        """
        getParam(ExtendedGroup self, int paramID) -> double
        getParam(ExtendedGroup self, std::string paramID) -> double
        """
        return _MinimallyAugmented.ExtendedGroup_getParam(self, *args)


    def computeDfDpMulti(self, *args):
        """computeDfDpMulti(ExtendedGroup self, std::vector< int,std::allocator< int > > const & paramIDs, MultiVector dfdp, bool isValidF) -> NOX::Abstract::Group::ReturnType"""
        return _MinimallyAugmented.ExtendedGroup_computeDfDpMulti(self, *args)


    def preProcessContinuationStep(self, *args):
        """preProcessContinuationStep(ExtendedGroup self, LOCA::Abstract::Iterator::StepStatus stepStatus)"""
        return _MinimallyAugmented.ExtendedGroup_preProcessContinuationStep(self, *args)


    def postProcessContinuationStep(self, *args):
        """postProcessContinuationStep(ExtendedGroup self, LOCA::Abstract::Iterator::StepStatus stepStatus)"""
        return _MinimallyAugmented.ExtendedGroup_postProcessContinuationStep(self, *args)


    def projectToDraw(self, *args):
        """projectToDraw(ExtendedGroup self, Vector x, double * px)"""
        return _MinimallyAugmented.ExtendedGroup_projectToDraw(self, *args)


    def projectToDrawDimension(self, *args):
        """projectToDrawDimension(ExtendedGroup self) -> int"""
        return _MinimallyAugmented.ExtendedGroup_projectToDrawDimension(self, *args)


    def computeScaledDotProduct(self, *args):
        """computeScaledDotProduct(ExtendedGroup self, Vector a, Vector b) -> double"""
        return _MinimallyAugmented.ExtendedGroup_computeScaledDotProduct(self, *args)


    def printSolution(self, *args):
        """
        printSolution(ExtendedGroup self, double const conParam)
        printSolution(ExtendedGroup self, Vector x, double const conParam)
        """
        return _MinimallyAugmented.ExtendedGroup_printSolution(self, *args)


    def scaleVector(self, *args):
        """scaleVector(ExtendedGroup self, Vector x)"""
        return _MinimallyAugmented.ExtendedGroup_scaleVector(self, *args)


    def getBorderedWidth(self, *args):
        """getBorderedWidth(ExtendedGroup self) -> int"""
        return _MinimallyAugmented.ExtendedGroup_getBorderedWidth(self, *args)


    def getUnborderedGroup(self, *args):
        """getUnborderedGroup(ExtendedGroup self) -> Teuchos::RCP< NOX::Abstract::Group const >"""
        return _MinimallyAugmented.ExtendedGroup_getUnborderedGroup(self, *args)


    def isCombinedAZero(self, *args):
        """isCombinedAZero(ExtendedGroup self) -> bool"""
        return _MinimallyAugmented.ExtendedGroup_isCombinedAZero(self, *args)


    def isCombinedBZero(self, *args):
        """isCombinedBZero(ExtendedGroup self) -> bool"""
        return _MinimallyAugmented.ExtendedGroup_isCombinedBZero(self, *args)


    def isCombinedCZero(self, *args):
        """isCombinedCZero(ExtendedGroup self) -> bool"""
        return _MinimallyAugmented.ExtendedGroup_isCombinedCZero(self, *args)


    def extractSolutionComponent(self, *args):
        """extractSolutionComponent(ExtendedGroup self, MultiVector v, MultiVector v_x)"""
        return _MinimallyAugmented.ExtendedGroup_extractSolutionComponent(self, *args)


    def extractParameterComponent(self, *args):
        """extractParameterComponent(ExtendedGroup self, bool use_transpose, MultiVector v, NOX::Abstract::MultiVector::DenseMatrix & v_p)"""
        return _MinimallyAugmented.ExtendedGroup_extractParameterComponent(self, *args)


    def loadNestedComponents(self, *args):
        """loadNestedComponents(ExtendedGroup self, MultiVector v_x, NOX::Abstract::MultiVector::DenseMatrix const & v_p, MultiVector v)"""
        return _MinimallyAugmented.ExtendedGroup_loadNestedComponents(self, *args)


    def fillA(self, *args):
        """fillA(ExtendedGroup self, MultiVector A)"""
        return _MinimallyAugmented.ExtendedGroup_fillA(self, *args)


    def fillB(self, *args):
        """fillB(ExtendedGroup self, MultiVector B)"""
        return _MinimallyAugmented.ExtendedGroup_fillB(self, *args)


    def fillC(self, *args):
        """fillC(ExtendedGroup self, NOX::Abstract::MultiVector::DenseMatrix & C)"""
        return _MinimallyAugmented.ExtendedGroup_fillC(self, *args)

ExtendedGroup_swigregister = _MinimallyAugmented.ExtendedGroup_swigregister
ExtendedGroup_swigregister(ExtendedGroup)

# This file is compatible with both classic and new-style classes.


