# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.Epetra is the python interface to the Trilinos linear
algebra services package Epetra:

    http://trilinos.sandia.gov/packages/epetra

The purpose of Epetra is to provide fundamental linear algebra
services to the rest of Trilinos.  These services include parallel
decomposition and communication, vectors and multivectors, graphs,
operators, and dense and sparse matrices.  Note that the C++ version
of Epetra uses the prefix 'Epetra_' which has been stripped from the
python version.

Epetra provides the following user-level classes (by category):

    * Communicators: PyComm, SerialComm, MpiComm (if built with mpi
      support)
    * Data distribution maps: Map, BlockMap, LocalMap
    * Vectors: Vector, MultiVector, IntVector
    * Graphs: CrsGraph, FECrsGraph
    * Operators and matrices: Operator, RowMatrix, CrsMatrix,
      FECrsMatrix, VbrMatrix
    * Serial dense objects: SerialDenseVector, SerialDenseMatrix,
      SerialDenseOperator, SerialDenseSolver, IntSerialDenseVector,
      IntSerialDenseMatrix
    * Aggregates: LinearProblem
    * Utilities: Import, Export, Time, MapColoring, Util

For examples of usage, please consult the following scripts in the
example subdirectory of the PyTrilinos package:

    * exEpetra.py
    * exEpetra_Comm.py
    * exEpetra_ImportExport.py
    * exEpetra_CrsMatrix_Easy.py
    * exEpetra_CrsMatrix_Efficient.py
    * exEpetra_FECrsMatrix_Easy.py

The Epetra module has been designed to use and interoperate with the
numpy module, which provides multidimensional array support.  Epetra
class constructors or methods that expect C arrays in C++ can
typically accept numpy arrays in python (or any python sequence that
numpy can convert to an array).  Similarly, methods that return C
arrays in C++ will return numpy arrays in python.  Also, certain
Epetra classes that represent contiguous blocks of homogeneous data
have been given the attributes of numpy arrays: Vector, MultiVector,
IntVector, SerialDenseVector, SerialDenseMatrix, IntSerialDenseVector
and IntSerialDenseMatrix.

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Epetra')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Epetra')
    _Epetra = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Epetra', [dirname(__file__)])
        except ImportError:
            import _Epetra
            return _Epetra
        try:
            _mod = imp.load_module('_Epetra', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Epetra = swig_import_helper()
    del swig_import_helper
else:
    import _Epetra
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_SwigPyIterator

    def value(self, *args):
        """value(SwigPyIterator self) -> PyObject *"""
        return _Epetra.SwigPyIterator_value(self, *args)


    def incr(self, *args):
        """incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _Epetra.SwigPyIterator_incr(self, *args)


    def decr(self, *args):
        """decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _Epetra.SwigPyIterator_decr(self, *args)


    def distance(self, *args):
        """distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _Epetra.SwigPyIterator_distance(self, *args)


    def equal(self, *args):
        """equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Epetra.SwigPyIterator_equal(self, *args)


    def copy(self, *args):
        """copy(SwigPyIterator self) -> SwigPyIterator"""
        return _Epetra.SwigPyIterator_copy(self, *args)


    def next(self, *args):
        """next(SwigPyIterator self) -> PyObject *"""
        return _Epetra.SwigPyIterator_next(self, *args)


    def __next__(self, *args):
        """__next__(SwigPyIterator self) -> PyObject *"""
        return _Epetra.SwigPyIterator___next__(self, *args)


    def previous(self, *args):
        """previous(SwigPyIterator self) -> PyObject *"""
        return _Epetra.SwigPyIterator_previous(self, *args)


    def advance(self, *args):
        """advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Epetra.SwigPyIterator_advance(self, *args)


    def __eq__(self, *args):
        """__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Epetra.SwigPyIterator___eq__(self, *args)


    def __ne__(self, *args):
        """__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Epetra.SwigPyIterator___ne__(self, *args)


    def __iadd__(self, *args):
        """__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Epetra.SwigPyIterator___iadd__(self, *args)


    def __isub__(self, *args):
        """__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Epetra.SwigPyIterator___isub__(self, *args)


    def __add__(self, *args):
        """__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Epetra.SwigPyIterator___add__(self, *args)


    def __sub__(self, *args):
        """
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _Epetra.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = _Epetra.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

SHARED_PTR_DISOWN = _Epetra.SHARED_PTR_DISOWN

# Much of the Epetra module is compatible with the numpy module
import numpy

Error = _Epetra.Error

def class_array_inplace_op(self, op_str, other):
  in_op = getattr(self.array, "__i"+op_str+"__")
  in_op(other.array)
  return self

def class_array_math_op(self, op_str, other):
# Initialize the result by calling the copy constructor
  result = self.__class__(self)
# Get the equivalent in-place operator for the result
  in_op = getattr(result.array, "__i"+op_str+"__")
  try:
    in_op(other.array)
  except AttributeError:
    in_op(other)
  return result

def class_array_rmath_op(self, op_str, other):
# Initialize the result by calling the copy constructor
  result = self.__class__(self)
  indices = (slice(None),) * len(self.array.shape)
  result.array[indices] = other
  in_op = getattr(result.array, "__i"+op_str+"__")
  in_op(self.array)
  return result

def class_array_add_math_ops(cls, op_str):
  setattr(cls,
          "__i"+op_str+"__",
          lambda self, other: class_array_inplace_op(self, op_str, other))
  setattr(cls,
          "__"+op_str+"__",
          lambda self, other: class_array_math_op(self, op_str, other))
  setattr(cls,
          "__r"+op_str+"__",
          lambda self, other: class_array_rmath_op(self, op_str, other))

def class_array_add_math(cls):
  class_array_add_math_ops(cls, "add")
  class_array_add_math_ops(cls, "sub")
  class_array_add_math_ops(cls, "mul")
  class_array_add_math_ops(cls, "add")

def class_array_comp_op(self, op_str, other):
  comp_op = getattr(self.array, "__"+op_str+"__")
  try:
    return comp_op(other.array)
  except AttributeError:
    return comp_op(other)

def class_array_add_comp_op(cls, op_str):
  setattr(cls,
          "__"+op_str+"__",
          lambda self, other: class_array_comp_op(self, op_str, other))

def class_array_add_comp(cls):
  class_array_add_comp_op(cls, "lt")
  class_array_add_comp_op(cls, "le")
  class_array_add_comp_op(cls, "eq")
  class_array_add_comp_op(cls, "ne")
  class_array_add_comp_op(cls, "gt")
  class_array_add_comp_op(cls, "ge")


def Epetra_Version(*args):
    """Epetra_Version() -> std::string"""
    return _Epetra.Epetra_Version(*args)

Version = Epetra_Version
__version__ = Version().split()[2]

Add = _Epetra.Add
Zero = _Epetra.Zero
Insert = _Epetra.Insert
InsertAdd = _Epetra.InsertAdd
Average = _Epetra.Average
Epetra_Max = _Epetra.Epetra_Max
Epetra_Min = _Epetra.Epetra_Min
AbsMax = _Epetra.AbsMax
AbsMin = _Epetra.AbsMin
Epetra_AddLocalAlso = _Epetra.Epetra_AddLocalAlso
Copy = _Epetra.Copy
View = _Epetra.View
class Object(_object):
    """
    The base Epetra class.

    The Epetra_Object class provides capabilities common to all Epetra
    objects, such as a label that identifies an object instance, constant
    definitions, enum types.  In C++, it supports a ``Print()`` method
    that takes an output stream as an argument.  In the python
    implementation for this and all derived classes, this method takes an
    optional file object argument whose default value is standard out.
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Object, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Object, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_Object self, int TracebackModeIn=-1, bool set_label=True) -> Object
        __init__(Epetra_Object self, char const *const Label, int TracebackModeIn=-1) -> Object
        __init__(Epetra_Object self, Object Object) -> Object

        The base Epetra class.

        The Epetra_Object class provides capabilities common to all Epetra
        objects, such as a label that identifies an object instance, constant
        definitions, enum types.  In C++, it supports a ``Print()`` method
        that takes an output stream as an argument.  In the python
        implementation for this and all derived classes, this method takes an
        optional file object argument whose default value is standard out.
        """
        this = _Epetra.new_Object(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_Object

    def SetLabel(self, *args):
        """SetLabel(Object self, char const *const Label)"""
        return _Epetra.Object_SetLabel(self, *args)


    def Label(self, *args):
        """Label(Object self) -> char const *"""
        return _Epetra.Object_Label(self, *args)


    def SetTracebackMode(*args):
        """SetTracebackMode(int TracebackModeValue)"""
        return _Epetra.Object_SetTracebackMode(*args)

    SetTracebackMode = staticmethod(SetTracebackMode)

    def GetTracebackMode(*args):
        """GetTracebackMode() -> int"""
        return _Epetra.Object_GetTracebackMode(*args)

    GetTracebackMode = staticmethod(GetTracebackMode)

    def GetTracebackStream(*args):
        """GetTracebackStream() -> std::ostream &"""
        return _Epetra.Object_GetTracebackStream(*args)

    GetTracebackStream = staticmethod(GetTracebackStream)

    def ReportError(self, *args):
        """ReportError(Object self, std::string const Message, int ErrorCode) -> int"""
        return _Epetra.Object_ReportError(self, *args)

    __swig_setmethods__["TracebackMode"] = _Epetra.Object_TracebackMode_set
    __swig_getmethods__["TracebackMode"] = _Epetra.Object_TracebackMode_get
    if _newclass:
        TracebackMode = _swig_property(_Epetra.Object_TracebackMode_get, _Epetra.Object_TracebackMode_set)

    def __str__(self, *args):
        """
        __str__(Object self) -> PyObject *

        Returns the results of ``Print()`` in a string, so that
        the python ``print`` command will work on ``Epetra`` objects.  The
        ``Print()`` methods are designed to run correctly in parallel, so do
        not execute ``print`` on an Epetra object conditionally on the
        processor number.  For example, do not do

          ``if comm.MyPID() == 0: print epetra_obj``

        or it will hang your code.
        """
        return _Epetra.Object___str__(self, *args)


    def Print(self, *args):
        """Print(Object self, PyObject * pf=None)"""
        return _Epetra.Object_Print(self, *args)

Object_swigregister = _Epetra.Object_swigregister
Object_swigregister(Object)
cvar = _Epetra.cvar
Epetra_MinDouble = cvar.Epetra_MinDouble
Epetra_MaxDouble = cvar.Epetra_MaxDouble
Epetra_Overflow = cvar.Epetra_Overflow
Epetra_Underflow = cvar.Epetra_Underflow
FormatStdout = cvar.FormatStdout
DefaultTracebackMode = cvar.DefaultTracebackMode

def Object_SetTracebackMode(*args):
    """Object_SetTracebackMode(int TracebackModeValue)"""
    return _Epetra.Object_SetTracebackMode(*args)

def Object_GetTracebackMode(*args):
    """Object_GetTracebackMode() -> int"""
    return _Epetra.Object_GetTracebackMode(*args)

def Object_GetTracebackStream(*args):
    """Object_GetTracebackStream() -> std::ostream &"""
    return _Epetra.Object_GetTracebackStream(*args)

class CompObject(_object):
    """Proxy of C++ Epetra_CompObject class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CompObject, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CompObject, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_CompObject self) -> CompObject
        __init__(Epetra_CompObject self, CompObject Source) -> CompObject
        """
        this = _Epetra.new_CompObject(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_CompObject

    def SetFlopCounter(self, *args):
        """
        SetFlopCounter(CompObject self, FLOPS FlopCounter_in)
        SetFlopCounter(CompObject self, CompObject CompObject)
        """
        return _Epetra.CompObject_SetFlopCounter(self, *args)


    def UnsetFlopCounter(self, *args):
        """UnsetFlopCounter(CompObject self)"""
        return _Epetra.CompObject_UnsetFlopCounter(self, *args)


    def GetFlopCounter(self, *args):
        """GetFlopCounter(CompObject self) -> FLOPS"""
        return _Epetra.CompObject_GetFlopCounter(self, *args)


    def ResetFlops(self, *args):
        """ResetFlops(CompObject self)"""
        return _Epetra.CompObject_ResetFlops(self, *args)


    def Flops(self, *args):
        """Flops(CompObject self) -> double"""
        return _Epetra.CompObject_Flops(self, *args)


    def UpdateFlops(self, *args):
        """
        UpdateFlops(CompObject self, long Flops_in)
        UpdateFlops(CompObject self, long long Flops_in)
        UpdateFlops(CompObject self, double Flops_in)
        """
        return _Epetra.CompObject_UpdateFlops(self, *args)

CompObject_swigregister = _Epetra.CompObject_swigregister
CompObject_swigregister(CompObject)

class BLAS(_object):
    """Proxy of C++ Epetra_BLAS class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BLAS, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BLAS, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_BLAS self) -> BLAS
        __init__(Epetra_BLAS self, BLAS BLAS) -> BLAS
        """
        this = _Epetra.new_BLAS(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_BLAS

    def SYRK(self, *args):
        """
        SYRK(BLAS self, char const UPLO, char const TRANS, int const N, int const K, float const ALPHA, float const * A, int const LDA, float const BETA, float * C, int const LDC)
        SYRK(BLAS self, char const UPLO, char const TRANS, int const N, int const K, double const ALPHA, double const * A, int const LDA, double const BETA, double * C, int const LDC)
        """
        return _Epetra.BLAS_SYRK(self, *args)

BLAS_swigregister = _Epetra.BLAS_swigregister
BLAS_swigregister(BLAS)

class LAPACK(_object):
    """Proxy of C++ Epetra_LAPACK class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LAPACK, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LAPACK, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_LAPACK self) -> LAPACK
        __init__(Epetra_LAPACK self, LAPACK LAPACK) -> LAPACK
        """
        this = _Epetra.new_LAPACK(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_LAPACK

    def TRTRS(self, *args):
        """
        TRTRS(LAPACK self, char const UPLO, char const TRANS, char const DIAG, int const N, int const NRHS, float const * A, int const LDA, float * B, int const LDB, int * INFO)
        TRTRS(LAPACK self, char const UPLO, char const TRANS, char const DIAG, int const N, int const NRHS, double const * A, int const LDA, double * B, int const LDB, int * INFO)
        """
        return _Epetra.LAPACK_TRTRS(self, *args)

LAPACK_swigregister = _Epetra.LAPACK_swigregister
LAPACK_swigregister(LAPACK)

class FLOPS(_object):
    """Proxy of C++ Epetra_Flops class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FLOPS, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FLOPS, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_Flops self) -> FLOPS
        __init__(Epetra_Flops self, FLOPS Flops_in) -> FLOPS
        """
        this = _Epetra.new_FLOPS(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def Flops(self, *args):
        """Flops(FLOPS self) -> double"""
        return _Epetra.FLOPS_Flops(self, *args)


    def ResetFlops(self, *args):
        """ResetFlops(FLOPS self)"""
        return _Epetra.FLOPS_ResetFlops(self, *args)

    __swig_destroy__ = _Epetra.delete_FLOPS
FLOPS_swigregister = _Epetra.FLOPS_swigregister
FLOPS_swigregister(FLOPS)

class Time(Object):
    """Proxy of C++ Epetra_Time class."""

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Time, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Time, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_Time self, Comm Comm) -> Time
        __init__(Epetra_Time self, Time Time) -> Time
        """
        this = _Epetra.new_Time(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def WallTime(self, *args):
        """WallTime(Time self) -> double"""
        return _Epetra.Time_WallTime(self, *args)


    def ResetStartTime(self, *args):
        """ResetStartTime(Time self)"""
        return _Epetra.Time_ResetStartTime(self, *args)


    def ElapsedTime(self, *args):
        """ElapsedTime(Time self) -> double"""
        return _Epetra.Time_ElapsedTime(self, *args)

    __swig_destroy__ = _Epetra.delete_Time
Time_swigregister = _Epetra.Time_swigregister
Time_swigregister(Time)


def _extractNumPyArrayFromEpetraIntSerialDenseMatrix(source):
    """_extractNumPyArrayFromEpetraIntSerialDenseMatrix(IntSerialDenseMatrix source) -> PyObject *"""
    return _Epetra._extractNumPyArrayFromEpetraIntSerialDenseMatrix(source)
class IntSerialDenseMatrix(Object):
    """Proxy of C++ Epetra_IntSerialDenseMatrix class."""

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IntSerialDenseMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IntSerialDenseMatrix, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_IntSerialDenseMatrix

    def Shape(self, NumRows, NumCols):
        """Shape(IntSerialDenseMatrix self, int NumRows, int NumCols) -> int"""
        val = _Epetra.IntSerialDenseMatrix_Shape(self, NumRows, NumCols)

        if self.__dict__.has_key("array"): del self.__dict__["array"]


        return val


    def Reshape(self, NumRows, NumCols):
        """Reshape(IntSerialDenseMatrix self, int NumRows, int NumCols) -> int"""
        val = _Epetra.IntSerialDenseMatrix_Reshape(self, NumRows, NumCols)

        if self.__dict__.has_key("array"): del self.__dict__["array"]


        return val


    def OneNorm(self):
        """OneNorm(IntSerialDenseMatrix self) -> int"""
        return _Epetra.IntSerialDenseMatrix_OneNorm(self)


    def InfNorm(self):
        """InfNorm(IntSerialDenseMatrix self) -> int"""
        return _Epetra.IntSerialDenseMatrix_InfNorm(self)


    def __eq__(self, rhs):
        """__eq__(IntSerialDenseMatrix self, IntSerialDenseMatrix rhs) -> bool"""
        return _Epetra.IntSerialDenseMatrix___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(IntSerialDenseMatrix self, IntSerialDenseMatrix rhs) -> bool"""
        return _Epetra.IntSerialDenseMatrix___ne__(self, rhs)


    def __call__(self, RowIndex, ColIndex):
        """__call__(IntSerialDenseMatrix self, int RowIndex, int ColIndex) -> int const &"""
        return _Epetra.IntSerialDenseMatrix___call__(self, RowIndex, ColIndex)


    def Random(self):
        """Random(IntSerialDenseMatrix self) -> int"""
        return _Epetra.IntSerialDenseMatrix_Random(self)


    def M(self):
        """M(IntSerialDenseMatrix self) -> int"""
        return _Epetra.IntSerialDenseMatrix_M(self)


    def N(self):
        """N(IntSerialDenseMatrix self) -> int"""
        return _Epetra.IntSerialDenseMatrix_N(self)


    def A(self):
        """A(IntSerialDenseMatrix self) -> int *"""
        return _Epetra.IntSerialDenseMatrix_A(self)


    def LDA(self):
        """LDA(IntSerialDenseMatrix self) -> int"""
        return _Epetra.IntSerialDenseMatrix_LDA(self)


    def CV(self):
        """CV(IntSerialDenseMatrix self) -> Epetra_DataAccess"""
        return _Epetra.IntSerialDenseMatrix_CV(self)


    def __init__(self, *args):
        """
        __init__(Epetra_IntSerialDenseMatrix self) -> IntSerialDenseMatrix
        __init__(Epetra_IntSerialDenseMatrix self, int NumRows, int NumCols) -> IntSerialDenseMatrix
        __init__(Epetra_IntSerialDenseMatrix self, IntSerialDenseMatrix Source) -> IntSerialDenseMatrix
        __init__(Epetra_IntSerialDenseMatrix self, PyObject * array) -> IntSerialDenseMatrix
        """
        this = _Epetra.new_IntSerialDenseMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
IntSerialDenseMatrix_swigregister = _Epetra.IntSerialDenseMatrix_swigregister
IntSerialDenseMatrix_swigregister(IntSerialDenseMatrix)


def IntSerialDenseMatrix_getattr(self, name):
    if name == "array":
        a = _extractNumPyArrayFromEpetraIntSerialDenseMatrix(self)
#a = a.transpose()
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    raise AttributeError("'%s' not an attribute of IntSerialDenseMatrix" % name)
def IntSerialDenseMatrix_setattr(self, name, value):
    if name == "array":
        raise AttributeError("Cannot change IntSerialDenseMatrix 'array' attribute")
    elif name == "shape":
        self.array.shape = value
    elif name == "dtype":
        raise AttributeError("Cannot change IntSerialDenseMatrix 'dtype' attribute")
    else:
        self.__dict__[name] = value
IntSerialDenseMatrix.__getattr__ = IntSerialDenseMatrix_getattr
IntSerialDenseMatrix.__setattr__ = IntSerialDenseMatrix_setattr
IntSerialDenseMatrix.__getitem__ = lambda self, i: self.array.__getitem__(i)
IntSerialDenseMatrix.__setitem__ = lambda self, i, v: self.array.__setitem__(i,v)
IntSerialDenseMatrix.__len__     = lambda self: self.array.__len__()
IntSerialDenseMatrix.__str__     = lambda self: self.array.__str__()
IntSerialDenseMatrix.A           = lambda self: self.array
class_array_add_math(IntSerialDenseMatrix)
class_array_add_comp(IntSerialDenseMatrix)


def _extractNumPyArrayFromEpetraIntSerialDenseVector(source):
    """_extractNumPyArrayFromEpetraIntSerialDenseVector(IntSerialDenseVector source) -> PyObject *"""
    return _Epetra._extractNumPyArrayFromEpetraIntSerialDenseVector(source)
class IntSerialDenseVector(IntSerialDenseMatrix):
    """Proxy of C++ Epetra_IntSerialDenseVector class."""

    __swig_setmethods__ = {}
    for _s in [IntSerialDenseMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IntSerialDenseVector, name, value)
    __swig_getmethods__ = {}
    for _s in [IntSerialDenseMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IntSerialDenseVector, name)
    __repr__ = _swig_repr

    def Size(self, Length_in):
        """Size(IntSerialDenseVector self, int Length_in) -> int"""
        val = _Epetra.IntSerialDenseVector_Size(self, Length_in)

        if self.__dict__.has_key("array"): del self.__dict__["array"]


        return val


    def Resize(self, Length_in):
        """Resize(IntSerialDenseVector self, int Length_in) -> int"""
        val = _Epetra.IntSerialDenseVector_Resize(self, Length_in)

        if self.__dict__.has_key("array"): del self.__dict__["array"]


        return val

    __swig_destroy__ = _Epetra.delete_IntSerialDenseVector

    def __call__(self, *args):
        """
        __call__(IntSerialDenseVector self, int RowIndex, int ColIndex) -> int const
        __call__(IntSerialDenseVector self, int Index) -> int const &
        """
        return _Epetra.IntSerialDenseVector___call__(self, *args)


    def Random(self):
        """Random(IntSerialDenseVector self) -> int"""
        return _Epetra.IntSerialDenseVector_Random(self)


    def Length(self):
        """Length(IntSerialDenseVector self) -> int"""
        return _Epetra.IntSerialDenseVector_Length(self)


    def CV(self):
        """CV(IntSerialDenseVector self) -> Epetra_DataAccess"""
        return _Epetra.IntSerialDenseVector_CV(self)


    def __init__(self, *args):
        """
        __init__(Epetra_IntSerialDenseVector self) -> IntSerialDenseVector
        __init__(Epetra_IntSerialDenseVector self, int Length_in) -> IntSerialDenseVector
        __init__(Epetra_IntSerialDenseVector self, IntSerialDenseVector Source) -> IntSerialDenseVector
        __init__(Epetra_IntSerialDenseVector self, PyObject * array) -> IntSerialDenseVector
        """
        this = _Epetra.new_IntSerialDenseVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
IntSerialDenseVector_swigregister = _Epetra.IntSerialDenseVector_swigregister
IntSerialDenseVector_swigregister(IntSerialDenseVector)


def IntSerialDenseVector_getattr(self, name):
    if name == "array":
        a = _extractNumPyArrayFromEpetraIntSerialDenseVector(self)
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    raise AttributeError("'%s' not an attribute of IntSerialDenseVector" % name)
def IntSerialDenseVector_setattr(self, name, value):
    if name == "array":
        raise AttributeError("Cannot change IntSerialDenseVector 'array' attribute")
    elif name == "shape":
        self.array.shape = value
    elif name == "dtype":
        raise AttributeError("Cannot change IntSerialDenseVector 'dtype' attribute")
    else:
        self.__dict__[name] = value
IntSerialDenseVector.__getattr__ = IntSerialDenseVector_getattr
IntSerialDenseVector.__setattr__ = IntSerialDenseVector_setattr
IntSerialDenseVector.__getitem__ = lambda self, i: self.array.__getitem__(i)
IntSerialDenseVector.__setitem__ = lambda self, i, v: self.array.__setitem__(i,v)
IntSerialDenseVector.__len__     = lambda self: self.array.__len__()
IntSerialDenseVector.__str__     = lambda self: self.array.__str__()
IntSerialDenseVector.Values      = lambda self: self.array
class_array_add_math(IntSerialDenseVector)
class_array_add_comp(IntSerialDenseVector)


class SerialDenseOperator(_object):
    """Proxy of C++ Epetra_SerialDenseOperator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerialDenseOperator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SerialDenseOperator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_SerialDenseOperator

    def SetUseTranspose(self, UseTranspose):
        """SetUseTranspose(SerialDenseOperator self, bool UseTranspose) -> int"""
        return _Epetra.SerialDenseOperator_SetUseTranspose(self, UseTranspose)


    def Apply(self, X, Y):
        """Apply(SerialDenseOperator self, SerialDenseMatrix X, SerialDenseMatrix Y) -> int"""
        return _Epetra.SerialDenseOperator_Apply(self, X, Y)


    def ApplyInverse(self, X, Y):
        """ApplyInverse(SerialDenseOperator self, SerialDenseMatrix X, SerialDenseMatrix Y) -> int"""
        return _Epetra.SerialDenseOperator_ApplyInverse(self, X, Y)


    def NormInf(self):
        """NormInf(SerialDenseOperator self) -> double"""
        return _Epetra.SerialDenseOperator_NormInf(self)


    def Label(self):
        """Label(SerialDenseOperator self) -> char const *"""
        return _Epetra.SerialDenseOperator_Label(self)


    def UseTranspose(self):
        """UseTranspose(SerialDenseOperator self) -> bool"""
        return _Epetra.SerialDenseOperator_UseTranspose(self)


    def HasNormInf(self):
        """HasNormInf(SerialDenseOperator self) -> bool"""
        return _Epetra.SerialDenseOperator_HasNormInf(self)


    def RowDim(self):
        """RowDim(SerialDenseOperator self) -> int"""
        return _Epetra.SerialDenseOperator_RowDim(self)


    def ColDim(self):
        """ColDim(SerialDenseOperator self) -> int"""
        return _Epetra.SerialDenseOperator_ColDim(self)

SerialDenseOperator_swigregister = _Epetra.SerialDenseOperator_swigregister
SerialDenseOperator_swigregister(SerialDenseOperator)


def _extractNumPyArrayFromEpetraSerialDenseMatrix(source):
    """_extractNumPyArrayFromEpetraSerialDenseMatrix(SerialDenseMatrix source) -> PyObject *"""
    return _Epetra._extractNumPyArrayFromEpetraSerialDenseMatrix(source)
class SerialDenseMatrix(CompObject, Object, SerialDenseOperator, BLAS):
    """Proxy of C++ Epetra_SerialDenseMatrix class."""

    __swig_setmethods__ = {}
    for _s in [CompObject, Object, SerialDenseOperator, BLAS]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerialDenseMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [CompObject, Object, SerialDenseOperator, BLAS]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerialDenseMatrix, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_SerialDenseMatrix

    def Shape(self, NumRows, NumCols):
        """Shape(SerialDenseMatrix self, int NumRows, int NumCols) -> int"""
        val = _Epetra.SerialDenseMatrix_Shape(self, NumRows, NumCols)

        if self.__dict__.has_key("array"): del self.__dict__["array"]


        return val


    def Reshape(self, NumRows, NumCols):
        """Reshape(SerialDenseMatrix self, int NumRows, int NumCols) -> int"""
        val = _Epetra.SerialDenseMatrix_Reshape(self, NumRows, NumCols)

        if self.__dict__.has_key("array"): del self.__dict__["array"]


        return val


    def Multiply(self, *args):
        """
        Multiply(SerialDenseMatrix self, char TransA, char TransB, double ScalarAB, SerialDenseMatrix A, SerialDenseMatrix B, double ScalarThis) -> int
        Multiply(SerialDenseMatrix self, bool transA, SerialDenseMatrix x, SerialDenseMatrix y) -> int
        Multiply(SerialDenseMatrix self, char SideA, double ScalarAB, SerialSymDenseMatrix A, SerialDenseMatrix B, double ScalarThis) -> int
        """
        return _Epetra.SerialDenseMatrix_Multiply(self, *args)


    def Scale(self, ScalarA):
        """Scale(SerialDenseMatrix self, double ScalarA) -> int"""
        return _Epetra.SerialDenseMatrix_Scale(self, ScalarA)


    def NormOne(self):
        """NormOne(SerialDenseMatrix self) -> double"""
        return _Epetra.SerialDenseMatrix_NormOne(self)


    def NormInf(self):
        """NormInf(SerialDenseMatrix self) -> double"""
        return _Epetra.SerialDenseMatrix_NormInf(self)


    def __eq__(self, rhs):
        """__eq__(SerialDenseMatrix self, SerialDenseMatrix rhs) -> bool"""
        return _Epetra.SerialDenseMatrix___eq__(self, rhs)


    def __ne__(self, rhs):
        """__ne__(SerialDenseMatrix self, SerialDenseMatrix rhs) -> bool"""
        return _Epetra.SerialDenseMatrix___ne__(self, rhs)


    def __iadd__(self, Source):
        """__iadd__(SerialDenseMatrix self, SerialDenseMatrix Source) -> SerialDenseMatrix"""
        return _Epetra.SerialDenseMatrix___iadd__(self, Source)


    def __call__(self, RowIndex, ColIndex):
        """__call__(SerialDenseMatrix self, int RowIndex, int ColIndex) -> double const &"""
        return _Epetra.SerialDenseMatrix___call__(self, RowIndex, ColIndex)


    def Random(self):
        """Random(SerialDenseMatrix self) -> int"""
        return _Epetra.SerialDenseMatrix_Random(self)


    def M(self):
        """M(SerialDenseMatrix self) -> int"""
        return _Epetra.SerialDenseMatrix_M(self)


    def N(self):
        """N(SerialDenseMatrix self) -> int"""
        return _Epetra.SerialDenseMatrix_N(self)


    def A(self):
        """A(SerialDenseMatrix self) -> double *"""
        return _Epetra.SerialDenseMatrix_A(self)


    def LDA(self):
        """LDA(SerialDenseMatrix self) -> int"""
        return _Epetra.SerialDenseMatrix_LDA(self)


    def CV(self):
        """CV(SerialDenseMatrix self) -> Epetra_DataAccess"""
        return _Epetra.SerialDenseMatrix_CV(self)


    def OneNorm(self):
        """OneNorm(SerialDenseMatrix self) -> double"""
        return _Epetra.SerialDenseMatrix_OneNorm(self)


    def InfNorm(self):
        """InfNorm(SerialDenseMatrix self) -> double"""
        return _Epetra.SerialDenseMatrix_InfNorm(self)


    def SetUseTranspose(self, UseTranspose_in):
        """SetUseTranspose(SerialDenseMatrix self, bool UseTranspose_in) -> int"""
        return _Epetra.SerialDenseMatrix_SetUseTranspose(self, UseTranspose_in)


    def Apply(self, X, Y):
        """Apply(SerialDenseMatrix self, SerialDenseMatrix X, SerialDenseMatrix Y) -> int"""
        return _Epetra.SerialDenseMatrix_Apply(self, X, Y)


    def ApplyInverse(self, X, Y):
        """ApplyInverse(SerialDenseMatrix self, SerialDenseMatrix X, SerialDenseMatrix Y) -> int"""
        return _Epetra.SerialDenseMatrix_ApplyInverse(self, X, Y)


    def Label(self):
        """Label(SerialDenseMatrix self) -> char const *"""
        return _Epetra.SerialDenseMatrix_Label(self)


    def UseTranspose(self):
        """UseTranspose(SerialDenseMatrix self) -> bool"""
        return _Epetra.SerialDenseMatrix_UseTranspose(self)


    def HasNormInf(self):
        """HasNormInf(SerialDenseMatrix self) -> bool"""
        return _Epetra.SerialDenseMatrix_HasNormInf(self)


    def RowDim(self):
        """RowDim(SerialDenseMatrix self) -> int"""
        return _Epetra.SerialDenseMatrix_RowDim(self)


    def ColDim(self):
        """ColDim(SerialDenseMatrix self) -> int"""
        return _Epetra.SerialDenseMatrix_ColDim(self)


    def __init__(self, *args):
        """
        __init__(Epetra_SerialDenseMatrix self, bool set_object_label=True) -> SerialDenseMatrix
        __init__(Epetra_SerialDenseMatrix self) -> SerialDenseMatrix
        __init__(Epetra_SerialDenseMatrix self, int NumRows, int NumCols, bool set_object_label=True) -> SerialDenseMatrix
        __init__(Epetra_SerialDenseMatrix self, int NumRows, int NumCols) -> SerialDenseMatrix
        __init__(Epetra_SerialDenseMatrix self, Epetra_DataAccess CV, double * A_in, int LDA_in, int NumRows, int NumCols, bool set_object_label=True) -> SerialDenseMatrix
        __init__(Epetra_SerialDenseMatrix self, Epetra_DataAccess CV, double * A_in, int LDA_in, int NumRows, int NumCols) -> SerialDenseMatrix
        __init__(Epetra_SerialDenseMatrix self, SerialDenseMatrix Source) -> SerialDenseMatrix
        __init__(Epetra_SerialDenseMatrix self, PyObject * array, bool set_object_label=True) -> SerialDenseMatrix
        __init__(Epetra_SerialDenseMatrix self, PyObject * array) -> SerialDenseMatrix
        """
        this = _Epetra.new_SerialDenseMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
SerialDenseMatrix_swigregister = _Epetra.SerialDenseMatrix_swigregister
SerialDenseMatrix_swigregister(SerialDenseMatrix)


def SerialDenseMatrix_getattr(self, name):
    if name == "array":
        a = _extractNumPyArrayFromEpetraSerialDenseMatrix(self)
#a = a.transpose()
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    raise AttributeError("'%s' not an attribute of SerialDenseMatrix" % name)
def SerialDenseMatrix_setattr(self, name, value):
    if name == "array":
        raise AttributeError("Cannot change SerialDenseMatrix 'array' attribute")
    elif name == "shape":
        self.array.shape = value
    elif name == "dtype":
        raise AttributeError("Cannot change SerialDenseMatrix 'dtype' attribute")
    else:
        self.__dict__[name] = value
SerialDenseMatrix.__getattr__ = SerialDenseMatrix_getattr
SerialDenseMatrix.__setattr__ = SerialDenseMatrix_setattr
SerialDenseMatrix.__getitem__ = lambda self, i: self.array.__getitem__(i)
SerialDenseMatrix.__setitem__ = lambda self, i, v: self.array.__setitem__(i,v)
SerialDenseMatrix.__len__     = lambda self: self.array.__len__()
SerialDenseMatrix.__str__     = lambda self: self.array.__str__()
SerialDenseMatrix.A           = lambda self: self.array
class_array_add_math(SerialDenseMatrix)
class_array_add_comp(SerialDenseMatrix)


class SerialSymDenseMatrix(SerialDenseMatrix):
    """Proxy of C++ Epetra_SerialSymDenseMatrix class."""

    __swig_setmethods__ = {}
    for _s in [SerialDenseMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerialSymDenseMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [SerialDenseMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerialSymDenseMatrix, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_SerialSymDenseMatrix self) -> SerialSymDenseMatrix
        __init__(Epetra_SerialSymDenseMatrix self, Epetra_DataAccess CV, double * A, int LDA, int NumRowsCols) -> SerialSymDenseMatrix
        __init__(Epetra_SerialSymDenseMatrix self, SerialSymDenseMatrix Source) -> SerialSymDenseMatrix
        """
        this = _Epetra.new_SerialSymDenseMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_SerialSymDenseMatrix

    def Shape(self, *args):
        """
        Shape(SerialSymDenseMatrix self, int NumRows, int NumCols) -> int
        Shape(SerialSymDenseMatrix self, int NumRowsCols) -> int
        """
        val = _Epetra.SerialSymDenseMatrix_Shape(self, *args)

        if self.__dict__.has_key("array"): del self.__dict__["array"]


        return val


    def Reshape(self, *args):
        """
        Reshape(SerialSymDenseMatrix self, int NumRows, int NumCols) -> int
        Reshape(SerialSymDenseMatrix self, int NumRowsCols) -> int
        """
        val = _Epetra.SerialSymDenseMatrix_Reshape(self, *args)

        if self.__dict__.has_key("array"): del self.__dict__["array"]


        return val


    def SetLower(self):
        """SetLower(SerialSymDenseMatrix self)"""
        return _Epetra.SerialSymDenseMatrix_SetLower(self)


    def SetUpper(self):
        """SetUpper(SerialSymDenseMatrix self)"""
        return _Epetra.SerialSymDenseMatrix_SetUpper(self)


    def Upper(self):
        """Upper(SerialSymDenseMatrix self) -> bool"""
        return _Epetra.SerialSymDenseMatrix_Upper(self)


    def UPLO(self):
        """UPLO(SerialSymDenseMatrix self) -> char"""
        return _Epetra.SerialSymDenseMatrix_UPLO(self)


    def Scale(self, ScalarA):
        """Scale(SerialSymDenseMatrix self, double ScalarA) -> int"""
        return _Epetra.SerialSymDenseMatrix_Scale(self, ScalarA)


    def NormOne(self):
        """NormOne(SerialSymDenseMatrix self) -> double"""
        return _Epetra.SerialSymDenseMatrix_NormOne(self)


    def NormInf(self):
        """NormInf(SerialSymDenseMatrix self) -> double"""
        return _Epetra.SerialSymDenseMatrix_NormInf(self)


    def CopyUPLOMat(self, Upper, A, LDA, NumRows):
        """CopyUPLOMat(SerialSymDenseMatrix self, bool Upper, double * A, int LDA, int NumRows)"""
        return _Epetra.SerialSymDenseMatrix_CopyUPLOMat(self, Upper, A, LDA, NumRows)


    def OneNorm(self):
        """OneNorm(SerialSymDenseMatrix self) -> double"""
        return _Epetra.SerialSymDenseMatrix_OneNorm(self)


    def InfNorm(self):
        """InfNorm(SerialSymDenseMatrix self) -> double"""
        return _Epetra.SerialSymDenseMatrix_InfNorm(self)

SerialSymDenseMatrix_swigregister = _Epetra.SerialSymDenseMatrix_swigregister
SerialSymDenseMatrix_swigregister(SerialSymDenseMatrix)


def _extractNumPyArrayFromEpetraSerialDenseVector(source):
    """_extractNumPyArrayFromEpetraSerialDenseVector(SerialDenseVector source) -> PyObject *"""
    return _Epetra._extractNumPyArrayFromEpetraSerialDenseVector(source)
class SerialDenseVector(SerialDenseMatrix):
    """Proxy of C++ Epetra_SerialDenseVector class."""

    __swig_setmethods__ = {}
    for _s in [SerialDenseMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerialDenseVector, name, value)
    __swig_getmethods__ = {}
    for _s in [SerialDenseMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerialDenseVector, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_SerialDenseVector

    def Size(self, Length_in):
        """Size(SerialDenseVector self, int Length_in) -> int"""
        val = _Epetra.SerialDenseVector_Size(self, Length_in)

        if self.__dict__.has_key("array"): del self.__dict__["array"]


        return val


    def Resize(self, Length_in):
        """Resize(SerialDenseVector self, int Length_in) -> int"""
        val = _Epetra.SerialDenseVector_Resize(self, Length_in)

        if self.__dict__.has_key("array"): del self.__dict__["array"]


        return val


    def __call__(self, *args):
        """
        __call__(SerialDenseVector self, int RowIndex, int ColIndex) -> double const
        __call__(SerialDenseVector self, int Index) -> double const &
        """
        return _Epetra.SerialDenseVector___call__(self, *args)


    def Random(self):
        """Random(SerialDenseVector self) -> int"""
        return _Epetra.SerialDenseVector_Random(self)


    def Dot(self, x):
        """Dot(SerialDenseVector self, SerialDenseVector x) -> double"""
        return _Epetra.SerialDenseVector_Dot(self, x)


    def Norm1(self):
        """Norm1(SerialDenseVector self) -> double"""
        return _Epetra.SerialDenseVector_Norm1(self)


    def Norm2(self):
        """Norm2(SerialDenseVector self) -> double"""
        return _Epetra.SerialDenseVector_Norm2(self)


    def NormInf(self):
        """NormInf(SerialDenseVector self) -> double"""
        return _Epetra.SerialDenseVector_NormInf(self)


    def Length(self):
        """Length(SerialDenseVector self) -> int"""
        return _Epetra.SerialDenseVector_Length(self)


    def Values(self):
        """Values(SerialDenseVector self) -> double *"""
        return _Epetra.SerialDenseVector_Values(self)


    def CV(self):
        """CV(SerialDenseVector self) -> Epetra_DataAccess"""
        return _Epetra.SerialDenseVector_CV(self)


    def __init__(self, *args):
        """
        __init__(Epetra_SerialDenseVector self) -> SerialDenseVector
        __init__(Epetra_SerialDenseVector self, int Length) -> SerialDenseVector
        __init__(Epetra_SerialDenseVector self, SerialDenseVector Source) -> SerialDenseVector
        __init__(Epetra_SerialDenseVector self, PyObject * array) -> SerialDenseVector
        """
        this = _Epetra.new_SerialDenseVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
SerialDenseVector_swigregister = _Epetra.SerialDenseVector_swigregister
SerialDenseVector_swigregister(SerialDenseVector)


def SerialDenseVector_getattr(self, name):
    if name == "array":
        a = _extractNumPyArrayFromEpetraSerialDenseVector(self)
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    raise AttributeError("'%s' not an attribute of SerialDenseVector" % name)
def SerialDenseVector_setattr(self, name, value):
    if name == "array":
        raise AttributeError("Cannot change SerialDenseVector 'array' attribute")
    elif name == "shape":
        self.array.shape = value
    elif name == "dtype":
        raise AttributeError("Cannot change SerialDenseVector 'dtype' attribute")
    else:
        self.__dict__[name] = value
SerialDenseVector.__getattr__ = SerialDenseVector_getattr
SerialDenseVector.__setattr__ = SerialDenseVector_setattr
SerialDenseVector.__getitem__ = lambda self, i: self.array.__getitem__(i)
SerialDenseVector.__setitem__ = lambda self, i, v: self.array.__setitem__(i,v)
SerialDenseVector.__len__     = lambda self: self.array.__len__()
SerialDenseVector.__str__     = lambda self: self.array.__str__()
SerialDenseVector.Values      = lambda self: self.array
class_array_add_math(SerialDenseVector)
class_array_add_comp(SerialDenseVector)


class SerialDenseSolver(CompObject, BLAS, LAPACK, Object):
    """Proxy of C++ Epetra_SerialDenseSolver class."""

    __swig_setmethods__ = {}
    for _s in [CompObject, BLAS, LAPACK, Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerialDenseSolver, name, value)
    __swig_getmethods__ = {}
    for _s in [CompObject, BLAS, LAPACK, Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerialDenseSolver, name)
    __repr__ = _swig_repr

    def __init__(self):
        """__init__(Epetra_SerialDenseSolver self) -> SerialDenseSolver"""
        this = _Epetra.new_SerialDenseSolver()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_SerialDenseSolver

    def SetMatrix(self, A):
        """SetMatrix(SerialDenseSolver self, SerialDenseMatrix A) -> int"""
        return _Epetra.SerialDenseSolver_SetMatrix(self, A)


    def SetVectors(self, X, B):
        """SetVectors(SerialDenseSolver self, SerialDenseMatrix X, SerialDenseMatrix B) -> int"""
        return _Epetra.SerialDenseSolver_SetVectors(self, X, B)


    def FactorWithEquilibration(self, Flag):
        """FactorWithEquilibration(SerialDenseSolver self, bool Flag)"""
        return _Epetra.SerialDenseSolver_FactorWithEquilibration(self, Flag)


    def SolveWithTranspose(self, Flag):
        """SolveWithTranspose(SerialDenseSolver self, bool Flag)"""
        return _Epetra.SerialDenseSolver_SolveWithTranspose(self, Flag)


    def SolveToRefinedSolution(self, Flag):
        """SolveToRefinedSolution(SerialDenseSolver self, bool Flag)"""
        return _Epetra.SerialDenseSolver_SolveToRefinedSolution(self, Flag)


    def EstimateSolutionErrors(self, Flag):
        """EstimateSolutionErrors(SerialDenseSolver self, bool Flag)"""
        return _Epetra.SerialDenseSolver_EstimateSolutionErrors(self, Flag)


    def Factor(self):
        """Factor(SerialDenseSolver self) -> int"""
        return _Epetra.SerialDenseSolver_Factor(self)


    def Solve(self):
        """Solve(SerialDenseSolver self) -> int"""
        return _Epetra.SerialDenseSolver_Solve(self)


    def Invert(self):
        """Invert(SerialDenseSolver self) -> int"""
        return _Epetra.SerialDenseSolver_Invert(self)


    def ComputeEquilibrateScaling(self):
        """ComputeEquilibrateScaling(SerialDenseSolver self) -> int"""
        return _Epetra.SerialDenseSolver_ComputeEquilibrateScaling(self)


    def EquilibrateMatrix(self):
        """EquilibrateMatrix(SerialDenseSolver self) -> int"""
        return _Epetra.SerialDenseSolver_EquilibrateMatrix(self)


    def EquilibrateRHS(self):
        """EquilibrateRHS(SerialDenseSolver self) -> int"""
        return _Epetra.SerialDenseSolver_EquilibrateRHS(self)


    def ApplyRefinement(self):
        """ApplyRefinement(SerialDenseSolver self) -> int"""
        return _Epetra.SerialDenseSolver_ApplyRefinement(self)


    def UnequilibrateLHS(self):
        """UnequilibrateLHS(SerialDenseSolver self) -> int"""
        return _Epetra.SerialDenseSolver_UnequilibrateLHS(self)


    def Transpose(self):
        """Transpose(SerialDenseSolver self) -> bool"""
        return _Epetra.SerialDenseSolver_Transpose(self)


    def Factored(self):
        """Factored(SerialDenseSolver self) -> bool"""
        return _Epetra.SerialDenseSolver_Factored(self)


    def A_Equilibrated(self):
        """A_Equilibrated(SerialDenseSolver self) -> bool"""
        return _Epetra.SerialDenseSolver_A_Equilibrated(self)


    def B_Equilibrated(self):
        """B_Equilibrated(SerialDenseSolver self) -> bool"""
        return _Epetra.SerialDenseSolver_B_Equilibrated(self)


    def ShouldEquilibrate(self):
        """ShouldEquilibrate(SerialDenseSolver self) -> bool"""
        return _Epetra.SerialDenseSolver_ShouldEquilibrate(self)


    def SolutionErrorsEstimated(self):
        """SolutionErrorsEstimated(SerialDenseSolver self) -> bool"""
        return _Epetra.SerialDenseSolver_SolutionErrorsEstimated(self)


    def Inverted(self):
        """Inverted(SerialDenseSolver self) -> bool"""
        return _Epetra.SerialDenseSolver_Inverted(self)


    def ReciprocalConditionEstimated(self):
        """ReciprocalConditionEstimated(SerialDenseSolver self) -> bool"""
        return _Epetra.SerialDenseSolver_ReciprocalConditionEstimated(self)


    def Solved(self):
        """Solved(SerialDenseSolver self) -> bool"""
        return _Epetra.SerialDenseSolver_Solved(self)


    def SolutionRefined(self):
        """SolutionRefined(SerialDenseSolver self) -> bool"""
        return _Epetra.SerialDenseSolver_SolutionRefined(self)


    def Matrix(self):
        """Matrix(SerialDenseSolver self) -> SerialDenseMatrix"""
        return _Epetra.SerialDenseSolver_Matrix(self)


    def FactoredMatrix(self):
        """FactoredMatrix(SerialDenseSolver self) -> SerialDenseMatrix"""
        return _Epetra.SerialDenseSolver_FactoredMatrix(self)


    def LHS(self):
        """LHS(SerialDenseSolver self) -> SerialDenseMatrix"""
        return _Epetra.SerialDenseSolver_LHS(self)


    def RHS(self):
        """RHS(SerialDenseSolver self) -> SerialDenseMatrix"""
        return _Epetra.SerialDenseSolver_RHS(self)


    def M(self):
        """M(SerialDenseSolver self) -> int"""
        return _Epetra.SerialDenseSolver_M(self)


    def N(self):
        """N(SerialDenseSolver self) -> int"""
        return _Epetra.SerialDenseSolver_N(self)


    def LDA(self):
        """LDA(SerialDenseSolver self) -> int"""
        return _Epetra.SerialDenseSolver_LDA(self)


    def LDB(self):
        """LDB(SerialDenseSolver self) -> int"""
        return _Epetra.SerialDenseSolver_LDB(self)


    def NRHS(self):
        """NRHS(SerialDenseSolver self) -> int"""
        return _Epetra.SerialDenseSolver_NRHS(self)


    def LDX(self):
        """LDX(SerialDenseSolver self) -> int"""
        return _Epetra.SerialDenseSolver_LDX(self)


    def LDAF(self):
        """LDAF(SerialDenseSolver self) -> int"""
        return _Epetra.SerialDenseSolver_LDAF(self)


    def ANORM(self):
        """ANORM(SerialDenseSolver self) -> double"""
        return _Epetra.SerialDenseSolver_ANORM(self)


    def RCOND(self):
        """RCOND(SerialDenseSolver self) -> double"""
        return _Epetra.SerialDenseSolver_RCOND(self)


    def ROWCND(self):
        """ROWCND(SerialDenseSolver self) -> double"""
        return _Epetra.SerialDenseSolver_ROWCND(self)


    def COLCND(self):
        """COLCND(SerialDenseSolver self) -> double"""
        return _Epetra.SerialDenseSolver_COLCND(self)


    def AMAX(self):
        """AMAX(SerialDenseSolver self) -> double"""
        return _Epetra.SerialDenseSolver_AMAX(self)


    def IPIV(self):
        """IPIV(SerialDenseSolver self) -> PyObject *"""
        return _Epetra.SerialDenseSolver_IPIV(self)


    def A(self):
        """A(SerialDenseSolver self) -> PyObject *"""
        return _Epetra.SerialDenseSolver_A(self)


    def B(self):
        """B(SerialDenseSolver self) -> PyObject *"""
        return _Epetra.SerialDenseSolver_B(self)


    def X(self):
        """X(SerialDenseSolver self) -> PyObject *"""
        return _Epetra.SerialDenseSolver_X(self)


    def AF(self):
        """AF(SerialDenseSolver self) -> PyObject *"""
        return _Epetra.SerialDenseSolver_AF(self)


    def FERR(self):
        """FERR(SerialDenseSolver self) -> PyObject *"""
        return _Epetra.SerialDenseSolver_FERR(self)


    def BERR(self):
        """BERR(SerialDenseSolver self) -> PyObject *"""
        return _Epetra.SerialDenseSolver_BERR(self)


    def R(self):
        """R(SerialDenseSolver self) -> PyObject *"""
        return _Epetra.SerialDenseSolver_R(self)


    def C(self):
        """C(SerialDenseSolver self) -> PyObject *"""
        return _Epetra.SerialDenseSolver_C(self)


    def ReciprocalConditionEstimate(self):
        """ReciprocalConditionEstimate(SerialDenseSolver self) -> double"""
        return _Epetra.SerialDenseSolver_ReciprocalConditionEstimate(self)

SerialDenseSolver_swigregister = _Epetra.SerialDenseSolver_swigregister
SerialDenseSolver_swigregister(SerialDenseSolver)

class SerialDenseSVD(SerialDenseOperator, CompObject, Object, BLAS, LAPACK):
    """Proxy of C++ Epetra_SerialDenseSVD class."""

    __swig_setmethods__ = {}
    for _s in [SerialDenseOperator, CompObject, Object, BLAS, LAPACK]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerialDenseSVD, name, value)
    __swig_getmethods__ = {}
    for _s in [SerialDenseOperator, CompObject, Object, BLAS, LAPACK]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerialDenseSVD, name)
    __repr__ = _swig_repr

    def __init__(self):
        """__init__(Epetra_SerialDenseSVD self) -> SerialDenseSVD"""
        this = _Epetra.new_SerialDenseSVD()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_SerialDenseSVD

    def SetMatrix(self, A):
        """SetMatrix(SerialDenseSVD self, SerialDenseMatrix A) -> int"""
        return _Epetra.SerialDenseSVD_SetMatrix(self, A)


    def SetVectors(self, X, B):
        """SetVectors(SerialDenseSVD self, SerialDenseMatrix X, SerialDenseMatrix B) -> int"""
        return _Epetra.SerialDenseSVD_SetVectors(self, X, B)


    def SolveWithTranspose(self, Flag):
        """SolveWithTranspose(SerialDenseSVD self, bool Flag)"""
        return _Epetra.SerialDenseSVD_SolveWithTranspose(self, Flag)


    def Factor(self):
        """Factor(SerialDenseSVD self) -> int"""
        return _Epetra.SerialDenseSVD_Factor(self)


    def Solve(self):
        """Solve(SerialDenseSVD self) -> int"""
        return _Epetra.SerialDenseSVD_Solve(self)


    def Invert(self, rthresh=0.0, athresh=0.0):
        """
        Invert(SerialDenseSVD self, double rthresh=0.0, double athresh=0.0) -> int
        Invert(SerialDenseSVD self, double rthresh=0.0) -> int
        Invert(SerialDenseSVD self) -> int
        """
        return _Epetra.SerialDenseSVD_Invert(self, rthresh, athresh)


    def Transpose(self):
        """Transpose(SerialDenseSVD self) -> bool"""
        return _Epetra.SerialDenseSVD_Transpose(self)


    def Factored(self):
        """Factored(SerialDenseSVD self) -> bool"""
        return _Epetra.SerialDenseSVD_Factored(self)


    def Inverted(self):
        """Inverted(SerialDenseSVD self) -> bool"""
        return _Epetra.SerialDenseSVD_Inverted(self)


    def Solved(self):
        """Solved(SerialDenseSVD self) -> bool"""
        return _Epetra.SerialDenseSVD_Solved(self)


    def Matrix(self):
        """Matrix(SerialDenseSVD self) -> SerialDenseMatrix"""
        return _Epetra.SerialDenseSVD_Matrix(self)


    def InvertedMatrix(self):
        """InvertedMatrix(SerialDenseSVD self) -> SerialDenseMatrix"""
        return _Epetra.SerialDenseSVD_InvertedMatrix(self)


    def LHS(self):
        """LHS(SerialDenseSVD self) -> SerialDenseMatrix"""
        return _Epetra.SerialDenseSVD_LHS(self)


    def RHS(self):
        """RHS(SerialDenseSVD self) -> SerialDenseMatrix"""
        return _Epetra.SerialDenseSVD_RHS(self)


    def M(self):
        """M(SerialDenseSVD self) -> int"""
        return _Epetra.SerialDenseSVD_M(self)


    def N(self):
        """N(SerialDenseSVD self) -> int"""
        return _Epetra.SerialDenseSVD_N(self)


    def A(self):
        """A(SerialDenseSVD self) -> double *"""
        return _Epetra.SerialDenseSVD_A(self)


    def LDA(self):
        """LDA(SerialDenseSVD self) -> int"""
        return _Epetra.SerialDenseSVD_LDA(self)


    def B(self):
        """B(SerialDenseSVD self) -> double *"""
        return _Epetra.SerialDenseSVD_B(self)


    def LDB(self):
        """LDB(SerialDenseSVD self) -> int"""
        return _Epetra.SerialDenseSVD_LDB(self)


    def NRHS(self):
        """NRHS(SerialDenseSVD self) -> int"""
        return _Epetra.SerialDenseSVD_NRHS(self)


    def X(self):
        """X(SerialDenseSVD self) -> double *"""
        return _Epetra.SerialDenseSVD_X(self)


    def LDX(self):
        """LDX(SerialDenseSVD self) -> int"""
        return _Epetra.SerialDenseSVD_LDX(self)


    def S(self):
        """S(SerialDenseSVD self) -> double *"""
        return _Epetra.SerialDenseSVD_S(self)


    def AI(self):
        """AI(SerialDenseSVD self) -> double *"""
        return _Epetra.SerialDenseSVD_AI(self)


    def LDAI(self):
        """LDAI(SerialDenseSVD self) -> int"""
        return _Epetra.SerialDenseSVD_LDAI(self)


    def ANORM(self):
        """ANORM(SerialDenseSVD self) -> double"""
        return _Epetra.SerialDenseSVD_ANORM(self)


    def SetUseTranspose(self, use_transpose):
        """SetUseTranspose(SerialDenseSVD self, bool use_transpose) -> int"""
        return _Epetra.SerialDenseSVD_SetUseTranspose(self, use_transpose)


    def Apply(self, Xmat, Ymat):
        """Apply(SerialDenseSVD self, SerialDenseMatrix Xmat, SerialDenseMatrix Ymat) -> int"""
        return _Epetra.SerialDenseSVD_Apply(self, Xmat, Ymat)


    def ApplyInverse(self, Xmat, Ymat):
        """ApplyInverse(SerialDenseSVD self, SerialDenseMatrix Xmat, SerialDenseMatrix Ymat) -> int"""
        return _Epetra.SerialDenseSVD_ApplyInverse(self, Xmat, Ymat)


    def NormInf(self):
        """NormInf(SerialDenseSVD self) -> double"""
        return _Epetra.SerialDenseSVD_NormInf(self)


    def Label(self):
        """Label(SerialDenseSVD self) -> char const *"""
        return _Epetra.SerialDenseSVD_Label(self)


    def UseTranspose(self):
        """UseTranspose(SerialDenseSVD self) -> bool"""
        return _Epetra.SerialDenseSVD_UseTranspose(self)


    def HasNormInf(self):
        """HasNormInf(SerialDenseSVD self) -> bool"""
        return _Epetra.SerialDenseSVD_HasNormInf(self)


    def RowDim(self):
        """RowDim(SerialDenseSVD self) -> int"""
        return _Epetra.SerialDenseSVD_RowDim(self)


    def ColDim(self):
        """ColDim(SerialDenseSVD self) -> int"""
        return _Epetra.SerialDenseSVD_ColDim(self)


    def AllocateWORK(self):
        """AllocateWORK(SerialDenseSVD self)"""
        return _Epetra.SerialDenseSVD_AllocateWORK(self)


    def AllocateIWORK(self):
        """AllocateIWORK(SerialDenseSVD self)"""
        return _Epetra.SerialDenseSVD_AllocateIWORK(self)


    def InitPointers(self):
        """InitPointers(SerialDenseSVD self)"""
        return _Epetra.SerialDenseSVD_InitPointers(self)


    def DeleteArrays(self):
        """DeleteArrays(SerialDenseSVD self)"""
        return _Epetra.SerialDenseSVD_DeleteArrays(self)


    def ResetMatrix(self):
        """ResetMatrix(SerialDenseSVD self)"""
        return _Epetra.SerialDenseSVD_ResetMatrix(self)


    def ResetVectors(self):
        """ResetVectors(SerialDenseSVD self)"""
        return _Epetra.SerialDenseSVD_ResetVectors(self)

    __swig_setmethods__["Transpose_"] = _Epetra.SerialDenseSVD_Transpose__set
    __swig_getmethods__["Transpose_"] = _Epetra.SerialDenseSVD_Transpose__get
    if _newclass:
        Transpose_ = _swig_property(_Epetra.SerialDenseSVD_Transpose__get, _Epetra.SerialDenseSVD_Transpose__set)
    __swig_setmethods__["Factored_"] = _Epetra.SerialDenseSVD_Factored__set
    __swig_getmethods__["Factored_"] = _Epetra.SerialDenseSVD_Factored__get
    if _newclass:
        Factored_ = _swig_property(_Epetra.SerialDenseSVD_Factored__get, _Epetra.SerialDenseSVD_Factored__set)
    __swig_setmethods__["Solved_"] = _Epetra.SerialDenseSVD_Solved__set
    __swig_getmethods__["Solved_"] = _Epetra.SerialDenseSVD_Solved__get
    if _newclass:
        Solved_ = _swig_property(_Epetra.SerialDenseSVD_Solved__get, _Epetra.SerialDenseSVD_Solved__set)
    __swig_setmethods__["Inverted_"] = _Epetra.SerialDenseSVD_Inverted__set
    __swig_getmethods__["Inverted_"] = _Epetra.SerialDenseSVD_Inverted__get
    if _newclass:
        Inverted_ = _swig_property(_Epetra.SerialDenseSVD_Inverted__get, _Epetra.SerialDenseSVD_Inverted__set)
    __swig_setmethods__["TRANS_"] = _Epetra.SerialDenseSVD_TRANS__set
    __swig_getmethods__["TRANS_"] = _Epetra.SerialDenseSVD_TRANS__get
    if _newclass:
        TRANS_ = _swig_property(_Epetra.SerialDenseSVD_TRANS__get, _Epetra.SerialDenseSVD_TRANS__set)
    __swig_setmethods__["M_"] = _Epetra.SerialDenseSVD_M__set
    __swig_getmethods__["M_"] = _Epetra.SerialDenseSVD_M__get
    if _newclass:
        M_ = _swig_property(_Epetra.SerialDenseSVD_M__get, _Epetra.SerialDenseSVD_M__set)
    __swig_setmethods__["N_"] = _Epetra.SerialDenseSVD_N__set
    __swig_getmethods__["N_"] = _Epetra.SerialDenseSVD_N__get
    if _newclass:
        N_ = _swig_property(_Epetra.SerialDenseSVD_N__get, _Epetra.SerialDenseSVD_N__set)
    __swig_setmethods__["Min_MN_"] = _Epetra.SerialDenseSVD_Min_MN__set
    __swig_getmethods__["Min_MN_"] = _Epetra.SerialDenseSVD_Min_MN__get
    if _newclass:
        Min_MN_ = _swig_property(_Epetra.SerialDenseSVD_Min_MN__get, _Epetra.SerialDenseSVD_Min_MN__set)
    __swig_setmethods__["NRHS_"] = _Epetra.SerialDenseSVD_NRHS__set
    __swig_getmethods__["NRHS_"] = _Epetra.SerialDenseSVD_NRHS__get
    if _newclass:
        NRHS_ = _swig_property(_Epetra.SerialDenseSVD_NRHS__get, _Epetra.SerialDenseSVD_NRHS__set)
    __swig_setmethods__["LDA_"] = _Epetra.SerialDenseSVD_LDA__set
    __swig_getmethods__["LDA_"] = _Epetra.SerialDenseSVD_LDA__get
    if _newclass:
        LDA_ = _swig_property(_Epetra.SerialDenseSVD_LDA__get, _Epetra.SerialDenseSVD_LDA__set)
    __swig_setmethods__["LDAI_"] = _Epetra.SerialDenseSVD_LDAI__set
    __swig_getmethods__["LDAI_"] = _Epetra.SerialDenseSVD_LDAI__get
    if _newclass:
        LDAI_ = _swig_property(_Epetra.SerialDenseSVD_LDAI__get, _Epetra.SerialDenseSVD_LDAI__set)
    __swig_setmethods__["LDB_"] = _Epetra.SerialDenseSVD_LDB__set
    __swig_getmethods__["LDB_"] = _Epetra.SerialDenseSVD_LDB__get
    if _newclass:
        LDB_ = _swig_property(_Epetra.SerialDenseSVD_LDB__get, _Epetra.SerialDenseSVD_LDB__set)
    __swig_setmethods__["LDX_"] = _Epetra.SerialDenseSVD_LDX__set
    __swig_getmethods__["LDX_"] = _Epetra.SerialDenseSVD_LDX__get
    if _newclass:
        LDX_ = _swig_property(_Epetra.SerialDenseSVD_LDX__get, _Epetra.SerialDenseSVD_LDX__set)
    __swig_setmethods__["INFO_"] = _Epetra.SerialDenseSVD_INFO__set
    __swig_getmethods__["INFO_"] = _Epetra.SerialDenseSVD_INFO__get
    if _newclass:
        INFO_ = _swig_property(_Epetra.SerialDenseSVD_INFO__get, _Epetra.SerialDenseSVD_INFO__set)
    __swig_setmethods__["LWORK_"] = _Epetra.SerialDenseSVD_LWORK__set
    __swig_getmethods__["LWORK_"] = _Epetra.SerialDenseSVD_LWORK__get
    if _newclass:
        LWORK_ = _swig_property(_Epetra.SerialDenseSVD_LWORK__get, _Epetra.SerialDenseSVD_LWORK__set)
    __swig_setmethods__["IWORK_"] = _Epetra.SerialDenseSVD_IWORK__set
    __swig_getmethods__["IWORK_"] = _Epetra.SerialDenseSVD_IWORK__get
    if _newclass:
        IWORK_ = _swig_property(_Epetra.SerialDenseSVD_IWORK__get, _Epetra.SerialDenseSVD_IWORK__set)
    __swig_setmethods__["ANORM_"] = _Epetra.SerialDenseSVD_ANORM__set
    __swig_getmethods__["ANORM_"] = _Epetra.SerialDenseSVD_ANORM__get
    if _newclass:
        ANORM_ = _swig_property(_Epetra.SerialDenseSVD_ANORM__get, _Epetra.SerialDenseSVD_ANORM__set)
    __swig_setmethods__["Matrix_"] = _Epetra.SerialDenseSVD_Matrix__set
    __swig_getmethods__["Matrix_"] = _Epetra.SerialDenseSVD_Matrix__get
    if _newclass:
        Matrix_ = _swig_property(_Epetra.SerialDenseSVD_Matrix__get, _Epetra.SerialDenseSVD_Matrix__set)
    __swig_setmethods__["LHS_"] = _Epetra.SerialDenseSVD_LHS__set
    __swig_getmethods__["LHS_"] = _Epetra.SerialDenseSVD_LHS__get
    if _newclass:
        LHS_ = _swig_property(_Epetra.SerialDenseSVD_LHS__get, _Epetra.SerialDenseSVD_LHS__set)
    __swig_setmethods__["RHS_"] = _Epetra.SerialDenseSVD_RHS__set
    __swig_getmethods__["RHS_"] = _Epetra.SerialDenseSVD_RHS__get
    if _newclass:
        RHS_ = _swig_property(_Epetra.SerialDenseSVD_RHS__get, _Epetra.SerialDenseSVD_RHS__set)
    __swig_setmethods__["Inverse_"] = _Epetra.SerialDenseSVD_Inverse__set
    __swig_getmethods__["Inverse_"] = _Epetra.SerialDenseSVD_Inverse__get
    if _newclass:
        Inverse_ = _swig_property(_Epetra.SerialDenseSVD_Inverse__get, _Epetra.SerialDenseSVD_Inverse__set)
    __swig_setmethods__["A_"] = _Epetra.SerialDenseSVD_A__set
    __swig_getmethods__["A_"] = _Epetra.SerialDenseSVD_A__get
    if _newclass:
        A_ = _swig_property(_Epetra.SerialDenseSVD_A__get, _Epetra.SerialDenseSVD_A__set)
    __swig_setmethods__["AI_"] = _Epetra.SerialDenseSVD_AI__set
    __swig_getmethods__["AI_"] = _Epetra.SerialDenseSVD_AI__get
    if _newclass:
        AI_ = _swig_property(_Epetra.SerialDenseSVD_AI__get, _Epetra.SerialDenseSVD_AI__set)
    __swig_setmethods__["WORK_"] = _Epetra.SerialDenseSVD_WORK__set
    __swig_getmethods__["WORK_"] = _Epetra.SerialDenseSVD_WORK__get
    if _newclass:
        WORK_ = _swig_property(_Epetra.SerialDenseSVD_WORK__get, _Epetra.SerialDenseSVD_WORK__set)
    __swig_setmethods__["U_"] = _Epetra.SerialDenseSVD_U__set
    __swig_getmethods__["U_"] = _Epetra.SerialDenseSVD_U__get
    if _newclass:
        U_ = _swig_property(_Epetra.SerialDenseSVD_U__get, _Epetra.SerialDenseSVD_U__set)
    __swig_setmethods__["S_"] = _Epetra.SerialDenseSVD_S__set
    __swig_getmethods__["S_"] = _Epetra.SerialDenseSVD_S__get
    if _newclass:
        S_ = _swig_property(_Epetra.SerialDenseSVD_S__get, _Epetra.SerialDenseSVD_S__set)
    __swig_setmethods__["Vt_"] = _Epetra.SerialDenseSVD_Vt__set
    __swig_getmethods__["Vt_"] = _Epetra.SerialDenseSVD_Vt__get
    if _newclass:
        Vt_ = _swig_property(_Epetra.SerialDenseSVD_Vt__get, _Epetra.SerialDenseSVD_Vt__set)
    __swig_setmethods__["B_"] = _Epetra.SerialDenseSVD_B__set
    __swig_getmethods__["B_"] = _Epetra.SerialDenseSVD_B__get
    if _newclass:
        B_ = _swig_property(_Epetra.SerialDenseSVD_B__get, _Epetra.SerialDenseSVD_B__set)
    __swig_setmethods__["X_"] = _Epetra.SerialDenseSVD_X__set
    __swig_getmethods__["X_"] = _Epetra.SerialDenseSVD_X__get
    if _newclass:
        X_ = _swig_property(_Epetra.SerialDenseSVD_X__get, _Epetra.SerialDenseSVD_X__set)
    __swig_setmethods__["UseTranspose_"] = _Epetra.SerialDenseSVD_UseTranspose__set
    __swig_getmethods__["UseTranspose_"] = _Epetra.SerialDenseSVD_UseTranspose__get
    if _newclass:
        UseTranspose_ = _swig_property(_Epetra.SerialDenseSVD_UseTranspose__get, _Epetra.SerialDenseSVD_UseTranspose__set)
SerialDenseSVD_swigregister = _Epetra.SerialDenseSVD_swigregister
SerialDenseSVD_swigregister(SerialDenseSVD)

class Comm(_object):
    """Proxy of C++ Epetra_Comm class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Comm, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Comm, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def Clone(self, *args):
        """Clone(Comm self) -> Comm"""
        return _Epetra.Comm_Clone(self, *args)

    __swig_destroy__ = _Epetra.delete_Comm

    def Barrier(self, *args):
        """Barrier(Comm self)"""
        return _Epetra.Comm_Barrier(self, *args)


    def MyPID(self, *args):
        """MyPID(Comm self) -> int"""
        return _Epetra.Comm_MyPID(self, *args)


    def NumProc(self, *args):
        """NumProc(Comm self) -> int"""
        return _Epetra.Comm_NumProc(self, *args)


    def CreateDistributor(self, *args):
        """CreateDistributor(Comm self) -> Distributor"""
        return _Epetra.Comm_CreateDistributor(self, *args)


    def CreateDirectory(self, *args):
        """CreateDirectory(Comm self, BlockMap Map) -> Directory"""
        return _Epetra.Comm_CreateDirectory(self, *args)


    def PrintInfo(self, *args):
        """PrintInfo(Comm self, std::ostream & os)"""
        return _Epetra.Comm_PrintInfo(self, *args)


    def Broadcast(self, *args):
        """
        Broadcast(self, numpy.ndarray myObj, int root)

        Argument myObj must be a numpy array, so that the Broadcast can be
        performed in-place.  Its scalar data type must be int, long, double or
        string.  In C++, this routine has an integer error return code.  In
        python, a non-zero return code is converted to an exception.
        """
        return _Epetra.Comm_Broadcast(self, *args)


    def GatherAll(self, *args):
        """
        GatherAll(Comm self, PyObject * myObj) -> PyObject *

        Argument myObj can be a numpy array or any sequence that can be
        converted to a numpy array.  Its scalar data type must be int, long or
        double.  The return argument is a numpy array of the same type.  In
        C++, this routine has an integer error return code.  In python, a
        non-zero return code is converted to an exception.
        """
        return _Epetra.Comm_GatherAll(self, *args)


    def SumAll(self, *args):
        """
        SumAll(Comm self, PyObject * partialObj) -> PyObject *

        Argument myObj can be a numpy array or any sequence that can be
        converted to a numpy array.  Its scalar data type must be int, long or
        double.  The return argument is a numpy array of the same type.  In
        C++, this routine has an integer error return code.  In python, a
        non-zero return code is converted to an exception.
        """
        return _Epetra.Comm_SumAll(self, *args)


    def MaxAll(self, *args):
        """
        MaxAll(Comm self, PyObject * partialObj) -> PyObject *

        Argument myObj can be a numpy array or any sequence that can be
        converted to a numpy array.  Its scalar data type must be int, long or
        double.  The return argument is a numpy array of the same type.  In
        C++, this routine has an integer error return code.  In python, a
        non-zero return code is converted to an exception.
        """
        return _Epetra.Comm_MaxAll(self, *args)


    def MinAll(self, *args):
        """
        MinAll(Comm self, PyObject * partialObj) -> PyObject *

        Argument myObj can be a numpy array or any sequence that can be
        converted to a numpy array.  Its scalar data type must be int, long or
        double.  The return argument is a numpy array of the same type.  In
        C++, this routine has an integer error return code.  In python, a
        non-zero return code is converted to an exception.
        """
        return _Epetra.Comm_MinAll(self, *args)


    def ScanSum(self, *args):
        """
        ScanSum(Comm self, PyObject * partialObj) -> PyObject *

        Argument myObj can be a numpy array or any sequence that can be
        converted to a numpy array.  Its scalar data type must be int, long or
        double.  The return argument is a numpy array of the same type.  In
        C++, this routine has an integer error return code.  In python, a
        non-zero return code is converted to an exception.
        """
        return _Epetra.Comm_ScanSum(self, *args)

Comm_swigregister = _Epetra.Comm_swigregister
Comm_swigregister(Comm)

class SerialComm(Object, Comm):
    """Proxy of C++ Epetra_SerialComm class."""

    __swig_setmethods__ = {}
    for _s in [Object, Comm]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SerialComm, name, value)
    __swig_getmethods__ = {}
    for _s in [Object, Comm]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SerialComm, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_SerialComm self) -> SerialComm
        __init__(Epetra_SerialComm self, SerialComm Comm) -> SerialComm
        """
        this = _Epetra.new_SerialComm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def Clone(self, *args):
        """Clone(SerialComm self) -> Comm"""
        return _Epetra.SerialComm_Clone(self, *args)

    __swig_destroy__ = _Epetra.delete_SerialComm

    def Barrier(self, *args):
        """Barrier(SerialComm self)"""
        return _Epetra.SerialComm_Barrier(self, *args)


    def MyPID(self, *args):
        """MyPID(SerialComm self) -> int"""
        return _Epetra.SerialComm_MyPID(self, *args)


    def NumProc(self, *args):
        """NumProc(SerialComm self) -> int"""
        return _Epetra.SerialComm_NumProc(self, *args)


    def CreateDistributor(self, *args):
        """CreateDistributor(SerialComm self) -> Distributor"""
        return _Epetra.SerialComm_CreateDistributor(self, *args)


    def CreateDirectory(self, *args):
        """CreateDirectory(SerialComm self, BlockMap Map) -> Directory"""
        return _Epetra.SerialComm_CreateDirectory(self, *args)


    def PrintInfo(self, *args):
        """PrintInfo(SerialComm self, std::ostream & os)"""
        return _Epetra.SerialComm_PrintInfo(self, *args)


    def ReferenceCount(self, *args):
        """ReferenceCount(SerialComm self) -> int"""
        return _Epetra.SerialComm_ReferenceCount(self, *args)


    def DataPtr(self, *args):
        """DataPtr(SerialComm self) -> Epetra_SerialCommData const *"""
        return _Epetra.SerialComm_DataPtr(self, *args)

SerialComm_swigregister = _Epetra.SerialComm_swigregister
SerialComm_swigregister(SerialComm)

class Distributor(_object):
    """Proxy of C++ Epetra_Distributor class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Distributor, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Distributor, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def Clone(self, *args):
        """Clone(Distributor self) -> Distributor"""
        return _Epetra.Distributor_Clone(self, *args)


    def ReverseClone(self, *args):
        """ReverseClone(Distributor self) -> Distributor"""
        return _Epetra.Distributor_ReverseClone(self, *args)

    __swig_destroy__ = _Epetra.delete_Distributor

    def CreateFromSends(self, *args):
        """CreateFromSends(Distributor self, int const & NumExportIDs, int const * ExportPIDs, bool Deterministic, int & NumRemoteIDs) -> int"""
        return _Epetra.Distributor_CreateFromSends(self, *args)


    def CreateFromRecvs(self, *args):
        """
        CreateFromRecvs(Distributor self, int const & NumRemoteIDs, int const * RemoteGIDs, int const * RemotePIDs, bool Deterministic, int & NumExportIDs, int *& ExportGIDs, int *& ExportPIDs) -> int
        CreateFromRecvs(Distributor self, int const & NumRemoteIDs, long long const * RemoteGIDs, int const * RemotePIDs, bool Deterministic, int & NumExportIDs, long long *& ExportGIDs, int *& ExportPIDs) -> int
        """
        return _Epetra.Distributor_CreateFromRecvs(self, *args)


    def DoWaits(self, *args):
        """DoWaits(Distributor self) -> int"""
        return _Epetra.Distributor_DoWaits(self, *args)


    def DoReverseWaits(self, *args):
        """DoReverseWaits(Distributor self) -> int"""
        return _Epetra.Distributor_DoReverseWaits(self, *args)


    def Do(self, *args):
        """
        Do(Distributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        Do(Distributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int
        """
        return _Epetra.Distributor_Do(self, *args)


    def DoReverse(self, *args):
        """
        DoReverse(Distributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        DoReverse(Distributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int
        """
        return _Epetra.Distributor_DoReverse(self, *args)


    def DoPosts(self, *args):
        """
        DoPosts(Distributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        DoPosts(Distributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int
        """
        return _Epetra.Distributor_DoPosts(self, *args)


    def DoReversePosts(self, *args):
        """
        DoReversePosts(Distributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        DoReversePosts(Distributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int
        """
        return _Epetra.Distributor_DoReversePosts(self, *args)

Distributor_swigregister = _Epetra.Distributor_swigregister
Distributor_swigregister(Distributor)

class Epetra_SerialDistributor(Object, Distributor):
    """Proxy of C++ Epetra_SerialDistributor class."""

    __swig_setmethods__ = {}
    for _s in [Object, Distributor]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Epetra_SerialDistributor, name, value)
    __swig_getmethods__ = {}
    for _s in [Object, Distributor]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Epetra_SerialDistributor, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_SerialDistributor self, SerialComm Comm) -> Epetra_SerialDistributor
        __init__(Epetra_SerialDistributor self, Epetra_SerialDistributor Plan) -> Epetra_SerialDistributor
        """
        this = _Epetra.new_Epetra_SerialDistributor(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def Clone(self, *args):
        """Clone(Epetra_SerialDistributor self) -> Distributor"""
        return _Epetra.Epetra_SerialDistributor_Clone(self, *args)


    def ReverseClone(self, *args):
        """ReverseClone(Epetra_SerialDistributor self) -> Distributor"""
        return _Epetra.Epetra_SerialDistributor_ReverseClone(self, *args)

    __swig_destroy__ = _Epetra.delete_Epetra_SerialDistributor

    def CreateFromSends(self, *args):
        """CreateFromSends(Epetra_SerialDistributor self, int const & NumExportIDs, int const * ExportPIDs, bool Deterministic, int & NumRemoteIDs) -> int"""
        return _Epetra.Epetra_SerialDistributor_CreateFromSends(self, *args)


    def CreateFromRecvs(self, *args):
        """
        CreateFromRecvs(Epetra_SerialDistributor self, int const & NumRemoteIDs, int const * RemoteGIDs, int const * RemotePIDs, bool Deterministic, int & NumExportIDs, int *& ExportGIDs, int *& ExportPIDs) -> int
        CreateFromRecvs(Epetra_SerialDistributor self, int const & NumRemoteIDs, long long const * RemoteGIDs, int const * RemotePIDs, bool Deterministic, int & NumExportIDs, long long *& ExportGIDs, int *& ExportPIDs) -> int
        """
        return _Epetra.Epetra_SerialDistributor_CreateFromRecvs(self, *args)


    def DoWaits(self, *args):
        """DoWaits(Epetra_SerialDistributor self) -> int"""
        return _Epetra.Epetra_SerialDistributor_DoWaits(self, *args)


    def DoReverseWaits(self, *args):
        """DoReverseWaits(Epetra_SerialDistributor self) -> int"""
        return _Epetra.Epetra_SerialDistributor_DoReverseWaits(self, *args)


    def Do(self, *args):
        """
        Do(Epetra_SerialDistributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        Do(Epetra_SerialDistributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int
        """
        return _Epetra.Epetra_SerialDistributor_Do(self, *args)


    def DoReverse(self, *args):
        """
        DoReverse(Epetra_SerialDistributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        DoReverse(Epetra_SerialDistributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int
        """
        return _Epetra.Epetra_SerialDistributor_DoReverse(self, *args)


    def DoPosts(self, *args):
        """
        DoPosts(Epetra_SerialDistributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        DoPosts(Epetra_SerialDistributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int
        """
        return _Epetra.Epetra_SerialDistributor_DoPosts(self, *args)


    def DoReversePosts(self, *args):
        """
        DoReversePosts(Epetra_SerialDistributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        DoReversePosts(Epetra_SerialDistributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int
        """
        return _Epetra.Epetra_SerialDistributor_DoReversePosts(self, *args)

Epetra_SerialDistributor_swigregister = _Epetra.Epetra_SerialDistributor_swigregister
Epetra_SerialDistributor_swigregister(Epetra_SerialDistributor)


def Epetra_MPI_Init_Argv(*args):
    """Epetra_MPI_Init_Argv(PyObject * args) -> PyObject *"""
    return _Epetra.Epetra_MPI_Init_Argv(*args)

def Epetra_MPI_Finalize(*args):
    """Epetra_MPI_Finalize() -> PyObject *"""
    return _Epetra.Epetra_MPI_Finalize(*args)


# Call MPI_Init if appropriate
import sys
calledMpiInit = Epetra_MPI_Init_Argv(sys.argv)

# Proceed according to calledMpiInit.  If calledMpiInit is true, then register a
# call to MPI_Finalize() with the atexit module and use the default value for
# mpiCommunicator, equivalent to MPI_COMM_WORLD.  If calledMpiInit is false, try
# to assess what package is responsible for calling MPI_Init(), currently either
# distarray or mpi4py, and extract the appropriate value for mpiCommunicator.
mpiCommunicator = None
if calledMpiInit:
    import atexit
    atexit.register(Epetra_MPI_Finalize)
else:
    if sys.modules.get("distarray.localapi.mpiutils"):
        dlm = sys.modules["distarray.localapi.mpiutils"]
        mpiCommunicator = dlm.get_base_comm()
    elif sys.modules.get("mpi4py.MPI"):
        MPI = sys.modules["mpi4py.MPI"]
        mpiCommunicator = MPI.COMM_WORLD

class MpiComm(Object, Comm):
    """Proxy of C++ Epetra_MpiComm class."""

    __swig_setmethods__ = {}
    for _s in [Object, Comm]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MpiComm, name, value)
    __swig_getmethods__ = {}
    for _s in [Object, Comm]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MpiComm, name)
    __repr__ = _swig_repr

    def Clone(self, *args):
        """Clone(MpiComm self) -> Comm"""
        return _Epetra.MpiComm_Clone(self, *args)

    __swig_destroy__ = _Epetra.delete_MpiComm

    def Barrier(self, *args):
        """Barrier(MpiComm self)"""
        return _Epetra.MpiComm_Barrier(self, *args)


    def Comm(self, *args):
        """Comm(MpiComm self) -> MPI_Comm"""
        return _Epetra.MpiComm_Comm(self, *args)


    def MyPID(self, *args):
        """MyPID(MpiComm self) -> int"""
        return _Epetra.MpiComm_MyPID(self, *args)


    def NumProc(self, *args):
        """NumProc(MpiComm self) -> int"""
        return _Epetra.MpiComm_NumProc(self, *args)


    def CreateDistributor(self, *args):
        """CreateDistributor(MpiComm self) -> Distributor"""
        return _Epetra.MpiComm_CreateDistributor(self, *args)


    def CreateDirectory(self, *args):
        """CreateDirectory(MpiComm self, BlockMap Map) -> Directory"""
        return _Epetra.MpiComm_CreateDirectory(self, *args)


    def GetMpiTag(self, *args):
        """GetMpiTag(MpiComm self) -> int"""
        return _Epetra.MpiComm_GetMpiTag(self, *args)


    def GetMpiComm(self, *args):
        """GetMpiComm(MpiComm self) -> MPI_Comm"""
        return _Epetra.MpiComm_GetMpiComm(self, *args)


    def PrintInfo(self, *args):
        """PrintInfo(MpiComm self, std::ostream & os)"""
        return _Epetra.MpiComm_PrintInfo(self, *args)


    def ReferenceCount(self, *args):
        """ReferenceCount(MpiComm self) -> int"""
        return _Epetra.MpiComm_ReferenceCount(self, *args)


    def DataPtr(self, *args):
        """DataPtr(MpiComm self) -> Epetra_MpiCommData const *"""
        return _Epetra.MpiComm_DataPtr(self, *args)


    def __init__(self, *args):
        """__init__(Epetra_MpiComm self, PyObject * dummy=None) -> MpiComm"""
        this = _Epetra.new_MpiComm(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
MpiComm_swigregister = _Epetra.MpiComm_swigregister
MpiComm_swigregister(MpiComm)

class MpiDistributor(Object, Distributor):
    """Proxy of C++ Epetra_MpiDistributor class."""

    __swig_setmethods__ = {}
    for _s in [Object, Distributor]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MpiDistributor, name, value)
    __swig_getmethods__ = {}
    for _s in [Object, Distributor]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MpiDistributor, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_MpiDistributor self, MpiComm Comm) -> MpiDistributor
        __init__(Epetra_MpiDistributor self, MpiDistributor Distributor) -> MpiDistributor
        """
        this = _Epetra.new_MpiDistributor(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def Clone(self, *args):
        """Clone(MpiDistributor self) -> Distributor"""
        return _Epetra.MpiDistributor_Clone(self, *args)


    def ReverseClone(self, *args):
        """ReverseClone(MpiDistributor self) -> Distributor"""
        return _Epetra.MpiDistributor_ReverseClone(self, *args)

    __swig_destroy__ = _Epetra.delete_MpiDistributor

    def CreateFromSends(self, *args):
        """CreateFromSends(MpiDistributor self, int const & NumExportIDs, int const * ExportPIDs, bool Deterministic, int & NumRemoteIDs) -> int"""
        return _Epetra.MpiDistributor_CreateFromSends(self, *args)


    def CreateFromRecvs(self, *args):
        """
        CreateFromRecvs(MpiDistributor self, int const & NumRemoteIDs, int const * RemoteGIDs, int const * RemotePIDs, bool Deterministic, int & NumExportIDs, int *& ExportGIDs, int *& ExportPIDs) -> int
        CreateFromRecvs(MpiDistributor self, int const & NumRemoteIDs, long long const * RemoteGIDs, int const * RemotePIDs, bool Deterministic, int & NumExportIDs, long long *& ExportGIDs, int *& ExportPIDs) -> int
        """
        return _Epetra.MpiDistributor_CreateFromRecvs(self, *args)


    def CreateFromSendsAndRecvs(self, *args):
        """
        CreateFromSendsAndRecvs(MpiDistributor self, int const & NumExportIDs, int const * ExportPIDs, int const & NumRemoteIDs, int const * RemoteGIDs, int const * RemotePIDs, bool Deterministic) -> int
        CreateFromSendsAndRecvs(MpiDistributor self, int const & NumExportIDs, int const * ExportPIDs, int const & NumRemoteIDs, long long const * RemoteGIDs, int const * RemotePIDs, bool Deterministic) -> int
        """
        return _Epetra.MpiDistributor_CreateFromSendsAndRecvs(self, *args)


    def DoWaits(self, *args):
        """DoWaits(MpiDistributor self) -> int"""
        return _Epetra.MpiDistributor_DoWaits(self, *args)


    def DoReverseWaits(self, *args):
        """DoReverseWaits(MpiDistributor self) -> int"""
        return _Epetra.MpiDistributor_DoReverseWaits(self, *args)


    def Do(self, *args):
        """
        Do(MpiDistributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        Do(MpiDistributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int
        """
        return _Epetra.MpiDistributor_Do(self, *args)


    def DoReverse(self, *args):
        """
        DoReverse(MpiDistributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        DoReverse(MpiDistributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int
        """
        return _Epetra.MpiDistributor_DoReverse(self, *args)


    def DoPosts(self, *args):
        """
        DoPosts(MpiDistributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        DoPosts(MpiDistributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int
        """
        return _Epetra.MpiDistributor_DoPosts(self, *args)


    def DoReversePosts(self, *args):
        """
        DoReversePosts(MpiDistributor self, char * export_objs, int obj_size, int & len_import_objs, char *& import_objs) -> int
        DoReversePosts(MpiDistributor self, char * export_objs, int obj_size, int *& sizes, int & len_import_objs, char *& import_objs) -> int
        """
        return _Epetra.MpiDistributor_DoReversePosts(self, *args)


    def NumReceives(self, *args):
        """NumReceives(MpiDistributor self) -> int"""
        return _Epetra.MpiDistributor_NumReceives(self, *args)


    def NumSends(self, *args):
        """NumSends(MpiDistributor self) -> int"""
        return _Epetra.MpiDistributor_NumSends(self, *args)


    def MaxSendLength(self, *args):
        """MaxSendLength(MpiDistributor self) -> int"""
        return _Epetra.MpiDistributor_MaxSendLength(self, *args)


    def TotalReceiveLength(self, *args):
        """TotalReceiveLength(MpiDistributor self) -> int"""
        return _Epetra.MpiDistributor_TotalReceiveLength(self, *args)


    def ProcsFrom(self, *args):
        """ProcsFrom(MpiDistributor self) -> int const *"""
        return _Epetra.MpiDistributor_ProcsFrom(self, *args)


    def ProcsTo(self, *args):
        """ProcsTo(MpiDistributor self) -> int const *"""
        return _Epetra.MpiDistributor_ProcsTo(self, *args)


    def LengthsFrom(self, *args):
        """LengthsFrom(MpiDistributor self) -> int const *"""
        return _Epetra.MpiDistributor_LengthsFrom(self, *args)


    def LengthsTo(self, *args):
        """LengthsTo(MpiDistributor self) -> int const *"""
        return _Epetra.MpiDistributor_LengthsTo(self, *args)

MpiDistributor_swigregister = _Epetra.MpiDistributor_swigregister
MpiDistributor_swigregister(MpiDistributor)


def PyComm():
    "PyComm() -> Epetra.MpiComm"
    return MpiComm(mpiCommunicator);

class BlockMap(Object):
    """Proxy of C++ Epetra_BlockMap class."""

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BlockMap, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BlockMap, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_BlockMap

    def LID(self, *args):
        """
        LID(BlockMap self, int GID) -> int
        LID(BlockMap self, long long GID) -> int
        """
        return _Epetra.BlockMap_LID(self, *args)


    def GID(self, *args):
        """GID(BlockMap self, int LID) -> int"""
        return _Epetra.BlockMap_GID(self, *args)


    def GID64(self, *args):
        """GID64(BlockMap self, int LID) -> long long"""
        return _Epetra.BlockMap_GID64(self, *args)


    def MyGID(self, *args):
        """
        MyGID(BlockMap self, int GID_in) -> bool
        MyGID(BlockMap self, long long GID_in) -> bool
        """
        return _Epetra.BlockMap_MyGID(self, *args)


    def MyLID(self, *args):
        """MyLID(BlockMap self, int lid) -> bool"""
        return _Epetra.BlockMap_MyLID(self, *args)


    def MinAllGID(self, *args):
        """MinAllGID(BlockMap self) -> int"""
        return _Epetra.BlockMap_MinAllGID(self, *args)


    def MinAllGID64(self, *args):
        """MinAllGID64(BlockMap self) -> long long"""
        return _Epetra.BlockMap_MinAllGID64(self, *args)


    def MaxAllGID(self, *args):
        """MaxAllGID(BlockMap self) -> int"""
        return _Epetra.BlockMap_MaxAllGID(self, *args)


    def MaxAllGID64(self, *args):
        """MaxAllGID64(BlockMap self) -> long long"""
        return _Epetra.BlockMap_MaxAllGID64(self, *args)


    def MinMyGID(self, *args):
        """MinMyGID(BlockMap self) -> int"""
        return _Epetra.BlockMap_MinMyGID(self, *args)


    def MinMyGID64(self, *args):
        """MinMyGID64(BlockMap self) -> long long"""
        return _Epetra.BlockMap_MinMyGID64(self, *args)


    def MaxMyGID(self, *args):
        """MaxMyGID(BlockMap self) -> int"""
        return _Epetra.BlockMap_MaxMyGID(self, *args)


    def MaxMyGID64(self, *args):
        """MaxMyGID64(BlockMap self) -> long long"""
        return _Epetra.BlockMap_MaxMyGID64(self, *args)


    def MinLID(self, *args):
        """MinLID(BlockMap self) -> int"""
        return _Epetra.BlockMap_MinLID(self, *args)


    def MaxLID(self, *args):
        """MaxLID(BlockMap self) -> int"""
        return _Epetra.BlockMap_MaxLID(self, *args)


    def NumGlobalElements(self, *args):
        """NumGlobalElements(BlockMap self) -> int"""
        return _Epetra.BlockMap_NumGlobalElements(self, *args)


    def NumGlobalElements64(self, *args):
        """NumGlobalElements64(BlockMap self) -> long long"""
        return _Epetra.BlockMap_NumGlobalElements64(self, *args)


    def NumMyElements(self, *args):
        """NumMyElements(BlockMap self) -> int"""
        return _Epetra.BlockMap_NumMyElements(self, *args)


    def MyGlobalElementsPtr(self, *args):
        """
        MyGlobalElementsPtr(BlockMap self, int *& MyGlobalElementList) -> int
        MyGlobalElementsPtr(BlockMap self, long long *& MyGlobalElementList) -> int
        """
        return _Epetra.BlockMap_MyGlobalElementsPtr(self, *args)


    def ElementSize(self, *args):
        """
        ElementSize(BlockMap self) -> int
        ElementSize(BlockMap self, int LID) -> int
        """
        return _Epetra.BlockMap_ElementSize(self, *args)


    def FirstPointInElement(self, *args):
        """FirstPointInElement(BlockMap self, int LID) -> int"""
        return _Epetra.BlockMap_FirstPointInElement(self, *args)


    def IndexBase(self, *args):
        """IndexBase(BlockMap self) -> int"""
        return _Epetra.BlockMap_IndexBase(self, *args)


    def IndexBase64(self, *args):
        """IndexBase64(BlockMap self) -> long long"""
        return _Epetra.BlockMap_IndexBase64(self, *args)


    def NumGlobalPoints(self, *args):
        """NumGlobalPoints(BlockMap self) -> int"""
        return _Epetra.BlockMap_NumGlobalPoints(self, *args)


    def NumGlobalPoints64(self, *args):
        """NumGlobalPoints64(BlockMap self) -> long long"""
        return _Epetra.BlockMap_NumGlobalPoints64(self, *args)


    def NumMyPoints(self, *args):
        """NumMyPoints(BlockMap self) -> int"""
        return _Epetra.BlockMap_NumMyPoints(self, *args)


    def MinMyElementSize(self, *args):
        """MinMyElementSize(BlockMap self) -> int"""
        return _Epetra.BlockMap_MinMyElementSize(self, *args)


    def MaxMyElementSize(self, *args):
        """MaxMyElementSize(BlockMap self) -> int"""
        return _Epetra.BlockMap_MaxMyElementSize(self, *args)


    def MinElementSize(self, *args):
        """MinElementSize(BlockMap self) -> int"""
        return _Epetra.BlockMap_MinElementSize(self, *args)


    def MaxElementSize(self, *args):
        """MaxElementSize(BlockMap self) -> int"""
        return _Epetra.BlockMap_MaxElementSize(self, *args)


    def UniqueGIDs(self, *args):
        """UniqueGIDs(BlockMap self) -> bool"""
        return _Epetra.BlockMap_UniqueGIDs(self, *args)


    def GlobalIndicesInt(self, *args):
        """GlobalIndicesInt(BlockMap self) -> bool"""
        return _Epetra.BlockMap_GlobalIndicesInt(self, *args)


    def GlobalIndicesLongLong(self, *args):
        """GlobalIndicesLongLong(BlockMap self) -> bool"""
        return _Epetra.BlockMap_GlobalIndicesLongLong(self, *args)


    def GlobalIndicesTypeValid(self, *args):
        """GlobalIndicesTypeValid(BlockMap self) -> bool"""
        return _Epetra.BlockMap_GlobalIndicesTypeValid(self, *args)


    def GlobalIndicesTypeMatch(self, *args):
        """GlobalIndicesTypeMatch(BlockMap self, BlockMap other) -> bool"""
        return _Epetra.BlockMap_GlobalIndicesTypeMatch(self, *args)


    def ConstantElementSize(self, *args):
        """ConstantElementSize(BlockMap self) -> bool"""
        return _Epetra.BlockMap_ConstantElementSize(self, *args)


    def SameAs(self, *args):
        """SameAs(BlockMap self, BlockMap Map) -> bool"""
        return _Epetra.BlockMap_SameAs(self, *args)


    def PointSameAs(self, *args):
        """PointSameAs(BlockMap self, BlockMap Map) -> bool"""
        return _Epetra.BlockMap_PointSameAs(self, *args)


    def LinearMap(self, *args):
        """LinearMap(BlockMap self) -> bool"""
        return _Epetra.BlockMap_LinearMap(self, *args)


    def DistributedGlobal(self, *args):
        """DistributedGlobal(BlockMap self) -> bool"""
        return _Epetra.BlockMap_DistributedGlobal(self, *args)


    def MyGlobalElements64(self, *args):
        """MyGlobalElements64(BlockMap self) -> long long *"""
        return _Epetra.BlockMap_MyGlobalElements64(self, *args)


    def Comm(self, *args):
        """Comm(BlockMap self) -> Comm"""
        return _Epetra.BlockMap_Comm(self, *args)


    def IsOneToOne(self, *args):
        """IsOneToOne(BlockMap self) -> bool"""
        return _Epetra.BlockMap_IsOneToOne(self, *args)


    def RemoveEmptyProcesses(self, *args):
        """RemoveEmptyProcesses(BlockMap self) -> BlockMap"""
        return _Epetra.BlockMap_RemoveEmptyProcesses(self, *args)


    def ReplaceCommWithSubset(self, *args):
        """ReplaceCommWithSubset(BlockMap self, Comm Comm) -> BlockMap"""
        return _Epetra.BlockMap_ReplaceCommWithSubset(self, *args)


    def __init__(self, *args):
        """

        __init__(self, int numGlobalElements, int elementSize, int indexBase,
             Comm comm) -> BlockMap

        BlockMap constructor with implicit local elements and constant element
        size.  Arguments are:

             numGlobalElements  - Total number of elements over all processors.
                                  Specify -1 to have the constructor compute
                                  the number of global elements
             elementSize        - The number of degrees of freedom associated
                                  with every element.
             indexBase          - The base integer value for indexed array
                                  references.  Typically this is 0 for C/C++ and 1
                                  for Fortran, but it can be set to any integer
                                  value.
             comm               - The Epetra.Comm communicator. This communicator
                                  can in turn be queried for processor rank and
                                  size information.
        __init__(Epetra_BlockMap self, long long NumGlobalElements, int ElementSize, int IndexBase, Comm Comm) -> BlockMap
        __init__(Epetra_BlockMap self, long long NumGlobalElements, int ElementSize, long long IndexBase, Comm Comm) -> BlockMap

        __init__(self, int numGlobalElements, int numMyElements, int elementSize,
             int indexBase, Comm comm) -> BlockMap

        BlockMap constructor with specified number of local elements and
        constant element size.  Arguments are:

             numGlobalElements  - Total number of elements over all processors.
                                  Specify -1 to have the constructor compute
                                  the number of global elements
             numMyElements      - Number of local elements on this processor.
             elementSize        - The number of degrees of freedom associated
                                  with every element.
             indexBase          - The base integer value for indexed array
                                  references.  Typically this is 0 for C/C++ and 1
                                  for Fortran, but it can be set to any integer
                                  value.
             comm               - The Epetra.Comm communicator. This communicator
                                  can in turn be queried for processor rank and
                                  size information.
        __init__(Epetra_BlockMap self, long long NumGlobalElements, int NumMyElements, int ElementSize, int IndexBase, Comm Comm) -> BlockMap
        __init__(Epetra_BlockMap self, long long NumGlobalElements, int NumMyElements, int ElementSize, long long IndexBase, Comm Comm) -> BlockMap

        __init__(self, int numGlobalElements, PySequence myGlobalElements,
             int elementSize, int indexBase, Comm comm) -> BlockMap

        BlockMap constructor with specified list of local elements and
        constant element size.  Arguments are:

             numGlobalElements  - Total number of elements over all processors.
                                  Specify -1 to have the constructor compute
                                  the number of global elements
             myGlobalElements   - A sequence of integers specifying the global
                                  element indexes on this processor.
             elementSize        - The number of degrees of freedom associated
                                  with every element.
             indexBase          - The base integer value for indexed array
                                  references.  Typically this is 0 for C/C++ and 1
                                  for Fortran, but it can be set to any integer
                                  value.
             comm               - The Epetra.Comm communicator. This communicator
                                  can in turn be queried for processor rank and
                                  size information.
        __init__(Epetra_BlockMap self, long long NumGlobalElements, int NumMyElements, long long const * MyGlobalElements, int ElementSize, int IndexBase, Comm Comm) -> BlockMap
        __init__(Epetra_BlockMap self, long long NumGlobalElements, int NumMyElements, long long const * MyGlobalElements, int ElementSize, long long IndexBase, Comm Comm) -> BlockMap
        __init__(Epetra_BlockMap self, long long NumGlobalElements, int NumMyElements, long long const * MyGlobalElements, int const * ElementSizeList, int IndexBase, Comm Comm) -> BlockMap
        __init__(Epetra_BlockMap self, long long NumGlobalElements, int NumMyElements, long long const * MyGlobalElements, int const * ElementSizeList, long long IndexBase, Comm Comm) -> BlockMap
        __init__(Epetra_BlockMap self, long long NumGlobal_Elements, int NumMy_Elements, long long const * myGlobalElements, int ElementSize, int indexBase, Comm comm, bool UserIsDistributedGlobal, long long UserMinAllGID, long long UserMaxAllGID) -> BlockMap
        __init__(Epetra_BlockMap self, long long NumGlobal_Elements, int NumMy_Elements, long long const * myGlobalElements, int ElementSize, long long indexBase, Comm comm, bool UserIsDistributedGlobal, long long UserMinAllGID, long long UserMaxAllGID) -> BlockMap
        __init__(Epetra_BlockMap self, int NumGlobal_Elements, int NumMy_Elements, int const * myGlobalElements, int ElementSize, int indexBase, Comm comm, bool UserIsDistributedGlobal, int UserMinAllGID, int UserMaxAllGID) -> BlockMap

        __init__(self, BlockMap map) -> BlockMap

        BlockMap copy constructor.

        __init__(self, int numGlobalElements, PySequence myGlobalElements,
             PySequence elementsSizes, int indexBase, Comm comm) -> BlockMap

        BlockMap constructor with specified list of local elements and
        specified list of element sizes.  Arguments are:

             numGlobalElements  - Total number of elements over all processors.
                                  Specify -1 to have the constructor compute
                                  the number of global elements
             myGlobalElements   - A sequence of integers specifying the global
                                  element indexes on this processor.
             elementSizes       - A sequence of integers specifying the number of
                                  degrees of freedom associated with each element
                                  on this processor.
             indexBase          - The base integer value for indexed array
                                  references.  Typically this is 0 for C/C++ and 1
                                  for Fortran, but it can be set to any integer
                                  value.
             comm               - The Epetra.Comm communicator. This communicator
                                  can in turn be queried for processor rank and
                                  size information.
        """
        this = _Epetra.new_BlockMap(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def RemoteIDList(self, *args):
        """
        RemoteIDList(BlockMap self, int NumIDs, long long const * GIDList, int * PIDList, int * LIDList) -> int
        RemoteIDList(BlockMap self, int NumIDs, long long const * GIDList, int * PIDList, int * LIDList, int * SizeList) -> int
        RemoteIDList(BlockMap self, PyObject * GIDList) -> PyObject *

        ``GIDList`` is a sequence of integer global IDs, and the return
        argument is the three-tuple ``(PIDList, LIDList, sizeList)``, which
        are ``numpy.ndarray`` objects of integers representing the processor
        IDs, local IDs and element sizes, respectively.
        """
        return _Epetra.BlockMap_RemoteIDList(self, *args)


    def FindLocalElementID(self, *args):
        """
        FindLocalElementID(BlockMap self, int pointID) -> PyObject *

        Returns a tuple containing the local ID of the element that contains
        the given local pointID, and the offset of the point in that element.
        """
        return _Epetra.BlockMap_FindLocalElementID(self, *args)


    def MyGlobalElements(self, *args):
        """
        MyGlobalElements(BlockMap self, long long * MyGlobalElementList) -> int
        MyGlobalElements(BlockMap self, int *& IntGIDs, long long *& LLGIDs)
        MyGlobalElements(BlockMap self) -> PyObject *

        Returns a numpy array of integers specifying the list of global IDs on
        the processor.
        """
        return _Epetra.BlockMap_MyGlobalElements(self, *args)


    def FirstPointInElementList(self, *args):
        """
        FirstPointInElementList(BlockMap self) -> PyObject *

        Returns a numpy array of integer first local point numbers for all of
        the local elements.
        """
        return _Epetra.BlockMap_FirstPointInElementList(self, *args)


    def ElementSizeList(self, *args):
        """
        ElementSizeList(BlockMap self) -> PyObject *

        Returns a numpy array of integer sizes for each local element.
        """
        return _Epetra.BlockMap_ElementSizeList(self, *args)


    def PointToElementList(self, *args):
        """
        PointToElementList(BlockMap self) -> PyObject *

        Returns a numpy array of integers such that for each local point, it
        indicates the local element ID that the point belongs to.
        """
        return _Epetra.BlockMap_PointToElementList(self, *args)

BlockMap_swigregister = _Epetra.BlockMap_swigregister
BlockMap_swigregister(BlockMap)

class Map(BlockMap):
    """Proxy of C++ Epetra_Map class."""

    __swig_setmethods__ = {}
    for _s in [BlockMap]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Map, name, value)
    __swig_getmethods__ = {}
    for _s in [BlockMap]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Map, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """

        __init__(self, int numGlobalElements, int indexBase, Comm comm) -> Map

        Map constructor with implicit number of elements per processor.
        Arguments are:

             numGlobalElements  - Total number of elements over all processors.
                                  Specify -1 to have the constructor compute
                                  the number of global elements
             indexBase          - The base integer value for indexed array
                                  references.  Typically this is 0 for C/C++ and 1
                                  for Fortran, but it can be set to any integer
                                  value.
             comm               - The Epetra.Comm communicator. This communicator
                                  can in turn be queried for processor rank and
                                  size information.
        __init__(Epetra_Map self, long long NumGlobalElements, int IndexBase, Comm Comm) -> Map
        __init__(Epetra_Map self, long long NumGlobalElements, long long IndexBase, Comm Comm) -> Map

        __init__(self, int numGlobalElements, int numMyElements, int indexBase,
             Comm comm) -> Map

        Map constructor with specified number of elements per processor.
        Arguments are:

             numGlobalElements  - Total number of elements over all processors.
                                  Specify -1 to have the constructor compute
                                  the number of global elements
             numMyElements      - Number of local elements on this processor.
             indexBase          - The base integer value for indexed array
                                  references.  Typically this is 0 for C/C++ and 1
                                  for Fortran, but it can be set to any integer
                                  value.
             comm               - The Epetra.Comm communicator. This communicator
                                  can in turn be queried for processor rank and
                                  size information.
        __init__(Epetra_Map self, long long NumGlobalElements, int NumMyElements, int IndexBase, Comm Comm) -> Map
        __init__(Epetra_Map self, long long NumGlobalElements, int NumMyElements, long long IndexBase, Comm Comm) -> Map

        __init__(self, int numGlobalElements, PySequence myGlobalElements,
             int indexBase, Comm comm) -> Map

        Map constructor with specified list of global element IDs for each
        processor.  Arguments are:

             numGlobalElements  - Total number of elements over all processors.
                                  Specify -1 to have the constructor compute
                                  the number of global elements
             myGlobalElements   - A sequence of integers specifying the global
                                  element indexes on this processor.
             indexBase          - The base integer value for indexed array
                                  references.  Typically this is 0 for C/C++ and 1
                                  for Fortran, but it can be set to any integer
                                  value.
             comm               - The Epetra.Comm communicator. This communicator
                                  can in turn be queried for processor rank and
                                  size information.
        __init__(Epetra_Map self, long long NumGlobalElements, int NumMyElements, long long const * MyGlobalElements, int IndexBase, Comm Comm) -> Map
        __init__(Epetra_Map self, long long NumGlobalElements, int NumMyElements, long long const * MyGlobalElements, long long IndexBase, Comm Comm) -> Map
        __init__(Epetra_Map self, long long NumGlobal_Elements, int NumMy_Elements, long long const * myGlobalElements, int indexBase, Comm comm, bool UserIsDistributedGlobal, long long UserMinAllGID, long long UserMaxAllGID) -> Map
        __init__(Epetra_Map self, long long NumGlobal_Elements, int NumMy_Elements, long long const * myGlobalElements, long long indexBase, Comm comm, bool UserIsDistributedGlobal, long long UserMinAllGID, long long UserMaxAllGID) -> Map
        __init__(Epetra_Map self, int NumGlobal_Elements, int NumMy_Elements, int const * myGlobalElements, int indexBase, Comm comm, bool UserIsDistributedGlobal, int UserMinAllGID, int UserMaxAllGID) -> Map

        __init__(self, Map map) -> Map

        Map copy constructor.
        """
        this = _Epetra.new_Map(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_Map

    def RemoveEmptyProcesses(self, *args):
        """RemoveEmptyProcesses(Map self) -> Map"""
        return _Epetra.Map_RemoveEmptyProcesses(self, *args)


    def ReplaceCommWithSubset(self, *args):
        """ReplaceCommWithSubset(Map self, Comm Comm) -> Map"""
        return _Epetra.Map_ReplaceCommWithSubset(self, *args)

Map_swigregister = _Epetra.Map_swigregister
Map_swigregister(Map)

class LocalMap(Map):
    """Proxy of C++ Epetra_LocalMap class."""

    __swig_setmethods__ = {}
    for _s in [Map]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LocalMap, name, value)
    __swig_getmethods__ = {}
    for _s in [Map]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LocalMap, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_LocalMap self, int NumMyElements, int IndexBase, Comm Comm) -> LocalMap
        __init__(Epetra_LocalMap self, long long NumMyElements, int IndexBase, Comm Comm) -> LocalMap
        __init__(Epetra_LocalMap self, long long NumMyElements, long long IndexBase, Comm Comm) -> LocalMap
        __init__(Epetra_LocalMap self, LocalMap map) -> LocalMap
        """
        this = _Epetra.new_LocalMap(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_LocalMap
LocalMap_swigregister = _Epetra.LocalMap_swigregister
LocalMap_swigregister(LocalMap)

class Directory(_object):
    """Proxy of C++ Epetra_Directory class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Directory, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Directory, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_Directory

    def GetDirectoryEntries(self, *args):
        """
        GetDirectoryEntries(Directory self, BlockMap Map, int const NumEntries, int const * GlobalEntries, int * Procs, int * LocalEntries, int * EntrySizes, bool high_rank_sharing_procs=False) -> int
        GetDirectoryEntries(Directory self, BlockMap Map, int const NumEntries, long long const * GlobalEntries, int * Procs, int * LocalEntries, int * EntrySizes, bool high_rank_sharing_procs=False) -> int
        """
        return _Epetra.Directory_GetDirectoryEntries(self, *args)


    def GIDsAllUniquelyOwned(self, *args):
        """GIDsAllUniquelyOwned(Directory self) -> bool"""
        return _Epetra.Directory_GIDsAllUniquelyOwned(self, *args)

Directory_swigregister = _Epetra.Directory_swigregister
Directory_swigregister(Directory)

class BasicDirectory(Directory):
    """Proxy of C++ Epetra_BasicDirectory class."""

    __swig_setmethods__ = {}
    for _s in [Directory]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasicDirectory, name, value)
    __swig_getmethods__ = {}
    for _s in [Directory]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasicDirectory, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_BasicDirectory self, BlockMap Map) -> BasicDirectory
        __init__(Epetra_BasicDirectory self, BasicDirectory Directory) -> BasicDirectory
        """
        this = _Epetra.new_BasicDirectory(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_BasicDirectory

    def GetDirectoryEntries(self, *args):
        """
        GetDirectoryEntries(BasicDirectory self, BlockMap Map, int const NumEntries, int const * GlobalEntries, int * Procs, int * LocalEntries, int * EntrySizes, bool high_rank_sharing_procs=False) -> int
        GetDirectoryEntries(BasicDirectory self, BlockMap Map, int const NumEntries, long long const * GlobalEntries, int * Procs, int * LocalEntries, int * EntrySizes, bool high_rank_sharing_procs=False) -> int
        """
        return _Epetra.BasicDirectory_GetDirectoryEntries(self, *args)


    def GIDsAllUniquelyOwned(self, *args):
        """GIDsAllUniquelyOwned(BasicDirectory self) -> bool"""
        return _Epetra.BasicDirectory_GIDsAllUniquelyOwned(self, *args)

BasicDirectory_swigregister = _Epetra.BasicDirectory_swigregister
BasicDirectory_swigregister(BasicDirectory)

class Import(Object):
    """Proxy of C++ Epetra_Import class."""

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Import, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Import, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_Import self, BlockMap TargetMap, BlockMap SourceMap) -> Import
        __init__(Epetra_Import self, BlockMap TargetMap, BlockMap SourceMap, int NumRemotePIDs, int const * RemotePIDs) -> Import
        __init__(Epetra_Import self, BlockMap TargetMap, BlockMap SourceMap, int NumRemotePIDs, int const * RemotePIDs, int const & NumExportIDs, int const * ExportLIDs, int const * ExportPIDs) -> Import
        __init__(Epetra_Import self, Import Importer) -> Import
        __init__(Epetra_Import self, Export Exporter) -> Import
        """
        this = _Epetra.new_Import(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_Import

    def NumSameIDs(self, *args):
        """NumSameIDs(Import self) -> int"""
        return _Epetra.Import_NumSameIDs(self, *args)


    def NumPermuteIDs(self, *args):
        """NumPermuteIDs(Import self) -> int"""
        return _Epetra.Import_NumPermuteIDs(self, *args)


    def NumRemoteIDs(self, *args):
        """NumRemoteIDs(Import self) -> int"""
        return _Epetra.Import_NumRemoteIDs(self, *args)


    def NumExportIDs(self, *args):
        """NumExportIDs(Import self) -> int"""
        return _Epetra.Import_NumExportIDs(self, *args)


    def NumSend(self, *args):
        """NumSend(Import self) -> int"""
        return _Epetra.Import_NumSend(self, *args)


    def NumRecv(self, *args):
        """NumRecv(Import self) -> int"""
        return _Epetra.Import_NumRecv(self, *args)


    def SourceMap(self, *args):
        """SourceMap(Import self) -> BlockMap"""
        return _Epetra.Import_SourceMap(self, *args)


    def TargetMap(self, *args):
        """TargetMap(Import self) -> BlockMap"""
        return _Epetra.Import_TargetMap(self, *args)


    def Distributor(self, *args):
        """Distributor(Import self) -> Distributor"""
        return _Epetra.Import_Distributor(self, *args)


    def PermuteFromLIDs(self, *args):
        """PermuteFromLIDs(Import self) -> PyObject *"""
        return _Epetra.Import_PermuteFromLIDs(self, *args)


    def PermuteToLIDs(self, *args):
        """PermuteToLIDs(Import self) -> PyObject *"""
        return _Epetra.Import_PermuteToLIDs(self, *args)


    def RemoteLIDs(self, *args):
        """RemoteLIDs(Import self) -> PyObject *"""
        return _Epetra.Import_RemoteLIDs(self, *args)


    def ExportLIDs(self, *args):
        """ExportLIDs(Import self) -> PyObject *"""
        return _Epetra.Import_ExportLIDs(self, *args)


    def ExportPIDs(self, *args):
        """ExportPIDs(Import self) -> PyObject *"""
        return _Epetra.Import_ExportPIDs(self, *args)

Import_swigregister = _Epetra.Import_swigregister
Import_swigregister(Import)

class Export(Object):
    """Proxy of C++ Epetra_Export class."""

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Export, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Export, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_Export self, BlockMap SourceMap, BlockMap TargetMap) -> Export
        __init__(Epetra_Export self, Export Exporter) -> Export
        __init__(Epetra_Export self, Import Exporter) -> Export
        """
        this = _Epetra.new_Export(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_Export

    def NumSameIDs(self, *args):
        """NumSameIDs(Export self) -> int"""
        return _Epetra.Export_NumSameIDs(self, *args)


    def NumPermuteIDs(self, *args):
        """NumPermuteIDs(Export self) -> int"""
        return _Epetra.Export_NumPermuteIDs(self, *args)


    def NumRemoteIDs(self, *args):
        """NumRemoteIDs(Export self) -> int"""
        return _Epetra.Export_NumRemoteIDs(self, *args)


    def NumExportIDs(self, *args):
        """NumExportIDs(Export self) -> int"""
        return _Epetra.Export_NumExportIDs(self, *args)


    def NumSend(self, *args):
        """NumSend(Export self) -> int"""
        return _Epetra.Export_NumSend(self, *args)


    def NumRecv(self, *args):
        """NumRecv(Export self) -> int"""
        return _Epetra.Export_NumRecv(self, *args)


    def SourceMap(self, *args):
        """SourceMap(Export self) -> BlockMap"""
        return _Epetra.Export_SourceMap(self, *args)


    def TargetMap(self, *args):
        """TargetMap(Export self) -> BlockMap"""
        return _Epetra.Export_TargetMap(self, *args)


    def Distributor(self, *args):
        """Distributor(Export self) -> Distributor"""
        return _Epetra.Export_Distributor(self, *args)


    def PermuteFromLIDs(self, *args):
        """PermuteFromLIDs(Export self) -> PyObject *"""
        return _Epetra.Export_PermuteFromLIDs(self, *args)


    def PermuteToLIDs(self, *args):
        """PermuteToLIDs(Export self) -> PyObject *"""
        return _Epetra.Export_PermuteToLIDs(self, *args)


    def RemoteLIDs(self, *args):
        """RemoteLIDs(Export self) -> PyObject *"""
        return _Epetra.Export_RemoteLIDs(self, *args)


    def ExportLIDs(self, *args):
        """ExportLIDs(Export self) -> PyObject *"""
        return _Epetra.Export_ExportLIDs(self, *args)


    def ExportPIDs(self, *args):
        """ExportPIDs(Export self) -> PyObject *"""
        return _Epetra.Export_ExportPIDs(self, *args)

Export_swigregister = _Epetra.Export_swigregister
Export_swigregister(Export)

class SrcDistObject(_object):
    """Proxy of C++ Epetra_SrcDistObject class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SrcDistObject, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SrcDistObject, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_SrcDistObject

    def Map(self, *args):
        """Map(SrcDistObject self) -> BlockMap"""
        return _Epetra.SrcDistObject_Map(self, *args)

SrcDistObject_swigregister = _Epetra.SrcDistObject_swigregister
SrcDistObject_swigregister(SrcDistObject)

class DistObject(Object, SrcDistObject):
    """Proxy of C++ Epetra_DistObject class."""

    __swig_setmethods__ = {}
    for _s in [Object, SrcDistObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, DistObject, name, value)
    __swig_getmethods__ = {}
    for _s in [Object, SrcDistObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, DistObject, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_DistObject

    def Import(self, *args):
        """
        Import(DistObject self, SrcDistObject A, Import Importer, Epetra_CombineMode CombineMode, OffsetIndex Indexor=None) -> int
        Import(DistObject self, SrcDistObject A, Export Exporter, Epetra_CombineMode CombineMode, OffsetIndex Indexor=None) -> int
        """
        return _Epetra.DistObject_Import(self, *args)


    def Export(self, *args):
        """
        Export(DistObject self, SrcDistObject A, Import Importer, Epetra_CombineMode CombineMode, OffsetIndex Indexor=None) -> int
        Export(DistObject self, SrcDistObject A, Export Exporter, Epetra_CombineMode CombineMode, OffsetIndex Indexor=None) -> int
        """
        return _Epetra.DistObject_Export(self, *args)


    def Map(self, *args):
        """Map(DistObject self) -> BlockMap"""
        return _Epetra.DistObject_Map(self, *args)


    def Comm(self, *args):
        """Comm(DistObject self) -> Comm"""
        return _Epetra.DistObject_Comm(self, *args)


    def DistributedGlobal(self, *args):
        """DistributedGlobal(DistObject self) -> bool"""
        return _Epetra.DistObject_DistributedGlobal(self, *args)

DistObject_swigregister = _Epetra.DistObject_swigregister
DistObject_swigregister(DistObject)

class MapColoring(DistObject):
    """Proxy of C++ Epetra_MapColoring class."""

    __swig_setmethods__ = {}
    for _s in [DistObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MapColoring, name, value)
    __swig_getmethods__ = {}
    for _s in [DistObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MapColoring, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_MapColoring

    def __call__(self, *args):
        """
        __call__(MapColoring self, long long GID) -> int
        __call__(MapColoring self, long long GID) -> int const &
        """
        return _Epetra.MapColoring___call__(self, *args)


    def NumColors(self, *args):
        """NumColors(MapColoring self) -> int"""
        return _Epetra.MapColoring_NumColors(self, *args)


    def MaxNumColors(self, *args):
        """MaxNumColors(MapColoring self) -> int"""
        return _Epetra.MapColoring_MaxNumColors(self, *args)


    def DefaultColor(self, *args):
        """DefaultColor(MapColoring self) -> int"""
        return _Epetra.MapColoring_DefaultColor(self, *args)


    def NumElementsWithColor(self, *args):
        """NumElementsWithColor(MapColoring self, int Color) -> int"""
        return _Epetra.MapColoring_NumElementsWithColor(self, *args)


    def GenerateMap(self, *args):
        """GenerateMap(MapColoring self, int Color) -> Map"""
        return _Epetra.MapColoring_GenerateMap(self, *args)


    def GenerateBlockMap(self, *args):
        """GenerateBlockMap(MapColoring self, int Color) -> BlockMap"""
        return _Epetra.MapColoring_GenerateBlockMap(self, *args)


    def __init__(self, *args):
        """
        __init__(Epetra_MapColoring self, BlockMap Map, int const DefaultColor=0) -> MapColoring
        __init__(Epetra_MapColoring self, MapColoring Source) -> MapColoring
        __init__(Epetra_MapColoring self, BlockMap map, int numColors, int const defaultColor=0) -> MapColoring
        """
        this = _Epetra.new_MapColoring(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __getitem__(self, *args):
        """__getitem__(MapColoring self, int i) -> int"""
        return _Epetra.MapColoring___getitem__(self, *args)


    def __setitem__(self, *args):
        """__setitem__(MapColoring self, int i, int color)"""
        return _Epetra.MapColoring___setitem__(self, *args)


    def ListOfColors(self, *args):
        """ListOfColors(MapColoring self) -> PyObject *"""
        return _Epetra.MapColoring_ListOfColors(self, *args)


    def ColorLIDList(self, *args):
        """ColorLIDList(MapColoring self, int color) -> PyObject *"""
        return _Epetra.MapColoring_ColorLIDList(self, *args)


    def ElementColors(self, *args):
        """ElementColors(MapColoring self) -> PyObject *"""
        return _Epetra.MapColoring_ElementColors(self, *args)

MapColoring_swigregister = _Epetra.MapColoring_swigregister
MapColoring_swigregister(MapColoring)


def _extractNumPyArrayFromEpetraIntVector(*args):
    """_extractNumPyArrayFromEpetraIntVector(IntVector source) -> PyObject *"""
    return _Epetra._extractNumPyArrayFromEpetraIntVector(*args)
class IntVector(DistObject):
    """Proxy of C++ Epetra_IntVector class."""

    __swig_setmethods__ = {}
    for _s in [DistObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, IntVector, name, value)
    __swig_getmethods__ = {}
    for _s in [DistObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, IntVector, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_IntVector

    def PutValue(self, *args):
        """PutValue(IntVector self, int Value) -> int"""
        return _Epetra.IntVector_PutValue(self, *args)


    def ExtractCopy(self, *args):
        """ExtractCopy(IntVector self, int * V) -> int"""
        return _Epetra.IntVector_ExtractCopy(self, *args)


    def ExtractView(self, *args):
        """ExtractView(IntVector self, int ** V) -> int"""
        return _Epetra.IntVector_ExtractView(self, *args)


    def MaxValue(self, *args):
        """MaxValue(IntVector self) -> int"""
        return _Epetra.IntVector_MaxValue(self, *args)


    def MinValue(self, *args):
        """MinValue(IntVector self) -> int"""
        return _Epetra.IntVector_MinValue(self, *args)


    def MyLength(self, *args):
        """MyLength(IntVector self) -> int"""
        return _Epetra.IntVector_MyLength(self, *args)


    def GlobalLength(self, *args):
        """GlobalLength(IntVector self) -> int"""
        return _Epetra.IntVector_GlobalLength(self, *args)


    def GlobalLength64(self, *args):
        """GlobalLength64(IntVector self) -> long long"""
        return _Epetra.IntVector_GlobalLength64(self, *args)


    def __init__(self, *args):
        """
        __init__(Epetra_IntVector self, BlockMap Map, bool zeroOut=True) -> IntVector
        __init__(Epetra_IntVector self, IntVector Source) -> IntVector
        __init__(Epetra_IntVector self, Epetra_DataAccess cv, BlockMap map, PyObject * values) -> IntVector
        __init__(Epetra_IntVector self, BlockMap map, PyObject * values) -> IntVector
        __init__(Epetra_IntVector self, PyObject * values) -> IntVector
        """
        this = _Epetra.new_IntVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def __distarray__(self, *args):
        """__distarray__(IntVector self) -> PyObject *"""
        return _Epetra.IntVector___distarray__(self, *args)

IntVector_swigregister = _Epetra.IntVector_swigregister
IntVector_swigregister(IntVector)


def IntVector_getattr(self, name):
    if name == "array":
        a = _extractNumPyArrayFromEpetraIntVector(self)
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    raise AttributeError("'%s' not an attribute of IntVector" % name)
def IntVector_setattr(self, name, value):
    if name == "array":
        raise AttributeError("Cannot change IntVector 'array' attribute")
    elif name == "shape":
        self.array.shape = value
    elif name == "dtype":
        raise AttributeError("Cannot change IntVector 'dtype' attribute")
    else:
        self.__dict__[name] = value
IntVector.__getattr__ = IntVector_getattr
IntVector.__setattr__ = IntVector_setattr
IntVector.__getitem__ = lambda self, i: self.array.__getitem__(i)
IntVector.__setitem__ = lambda self, i, v: self.array.__setitem__(i,v)
IntVector.__len__     = lambda self: self.array.__len__()
IntVector.__str__     = lambda self: self.array.__str__()
IntVector.copy        = lambda self: IntVector(self)
IntVector.ExtractCopy = lambda self: self.array.copy()
IntVector.ExtractView = lambda self: self.array
IntVector.Values      = lambda self: self.array
class_array_add_math(IntVector)
class_array_add_comp(IntVector)


def _extractNumPyArrayFromEpetraMultiVector(*args):
    """_extractNumPyArrayFromEpetraMultiVector(MultiVector source) -> PyObject *"""
    return _Epetra._extractNumPyArrayFromEpetraMultiVector(*args)
class MultiVector(DistObject, CompObject, BLAS):
    """Proxy of C++ Epetra_MultiVector class."""

    __swig_setmethods__ = {}
    for _s in [DistObject, CompObject, BLAS]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiVector, name, value)
    __swig_getmethods__ = {}
    for _s in [DistObject, CompObject, BLAS]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MultiVector, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_MultiVector

    def ReplaceGlobalValue(self, *args):
        """
        ReplaceGlobalValue(MultiVector self, int GlobalRow, int VectorIndex, double ScalarValue) -> int
        ReplaceGlobalValue(MultiVector self, long long GlobalRow, int VectorIndex, double ScalarValue) -> int
        ReplaceGlobalValue(MultiVector self, int GlobalBlockRow, int BlockRowOffset, int VectorIndex, double ScalarValue) -> int
        ReplaceGlobalValue(MultiVector self, long long GlobalBlockRow, int BlockRowOffset, int VectorIndex, double ScalarValue) -> int
        """
        return _Epetra.MultiVector_ReplaceGlobalValue(self, *args)


    def SumIntoGlobalValue(self, *args):
        """
        SumIntoGlobalValue(MultiVector self, int GlobalRow, int VectorIndex, double ScalarValue) -> int
        SumIntoGlobalValue(MultiVector self, long long GlobalRow, int VectorIndex, double ScalarValue) -> int
        SumIntoGlobalValue(MultiVector self, int GlobalBlockRow, int BlockRowOffset, int VectorIndex, double ScalarValue) -> int
        SumIntoGlobalValue(MultiVector self, long long GlobalBlockRow, int BlockRowOffset, int VectorIndex, double ScalarValue) -> int
        """
        return _Epetra.MultiVector_SumIntoGlobalValue(self, *args)


    def ReplaceMyValue(self, *args):
        """
        ReplaceMyValue(MultiVector self, int MyRow, int VectorIndex, double ScalarValue) -> int
        ReplaceMyValue(MultiVector self, int MyBlockRow, int BlockRowOffset, int VectorIndex, double ScalarValue) -> int
        """
        return _Epetra.MultiVector_ReplaceMyValue(self, *args)


    def SumIntoMyValue(self, *args):
        """
        SumIntoMyValue(MultiVector self, int MyRow, int VectorIndex, double ScalarValue) -> int
        SumIntoMyValue(MultiVector self, int MyBlockRow, int BlockRowOffset, int VectorIndex, double ScalarValue) -> int
        """
        return _Epetra.MultiVector_SumIntoMyValue(self, *args)


    def PutScalar(self, *args):
        """PutScalar(MultiVector self, double ScalarConstant) -> int"""
        return _Epetra.MultiVector_PutScalar(self, *args)


    def Random(self, *args):
        """Random(MultiVector self) -> int"""
        return _Epetra.MultiVector_Random(self, *args)


    def Abs(self, *args):
        """Abs(MultiVector self, MultiVector A) -> int"""
        return _Epetra.MultiVector_Abs(self, *args)


    def Reciprocal(self, *args):
        """Reciprocal(MultiVector self, MultiVector A) -> int"""
        return _Epetra.MultiVector_Reciprocal(self, *args)


    def Scale(self, *args):
        """
        Scale(MultiVector self, double ScalarValue) -> int
        Scale(MultiVector self, double ScalarA, MultiVector A) -> int
        """
        return _Epetra.MultiVector_Scale(self, *args)


    def Update(self, *args):
        """
        Update(MultiVector self, double ScalarA, MultiVector A, double ScalarThis) -> int
        Update(MultiVector self, double ScalarA, MultiVector A, double ScalarB, MultiVector B, double ScalarThis) -> int
        """
        return _Epetra.MultiVector_Update(self, *args)


    def Multiply(self, *args):
        """
        Multiply(MultiVector self, char TransA, char TransB, double ScalarAB, MultiVector A, MultiVector B, double ScalarThis) -> int
        Multiply(MultiVector self, double ScalarAB, MultiVector A, MultiVector B, double ScalarThis) -> int
        """
        return _Epetra.MultiVector_Multiply(self, *args)


    def ReciprocalMultiply(self, *args):
        """ReciprocalMultiply(MultiVector self, double ScalarAB, MultiVector A, MultiVector B, double ScalarThis) -> int"""
        return _Epetra.MultiVector_ReciprocalMultiply(self, *args)


    def SetSeed(self, *args):
        """SetSeed(MultiVector self, unsigned int Seed_in) -> int"""
        return _Epetra.MultiVector_SetSeed(self, *args)


    def Seed(self, *args):
        """Seed(MultiVector self) -> unsigned int"""
        return _Epetra.MultiVector_Seed(self, *args)


    def NumVectors(self, *args):
        """NumVectors(MultiVector self) -> int"""
        return _Epetra.MultiVector_NumVectors(self, *args)


    def MyLength(self, *args):
        """MyLength(MultiVector self) -> int"""
        return _Epetra.MultiVector_MyLength(self, *args)


    def GlobalLength(self, *args):
        """GlobalLength(MultiVector self) -> int"""
        return _Epetra.MultiVector_GlobalLength(self, *args)


    def GlobalLength64(self, *args):
        """GlobalLength64(MultiVector self) -> long long"""
        return _Epetra.MultiVector_GlobalLength64(self, *args)


    def Stride(self, *args):
        """Stride(MultiVector self) -> int"""
        return _Epetra.MultiVector_Stride(self, *args)


    def ConstantStride(self, *args):
        """ConstantStride(MultiVector self) -> bool"""
        return _Epetra.MultiVector_ConstantStride(self, *args)


    def ReplaceMap(self, *args):
        """ReplaceMap(MultiVector self, BlockMap map) -> int"""
        return _Epetra.MultiVector_ReplaceMap(self, *args)


    def Values(self, *args):
        """Values(MultiVector self) -> double *"""
        return _Epetra.MultiVector_Values(self, *args)


    def Reduce(self, *args):
        """Reduce(MultiVector self) -> int"""
        return _Epetra.MultiVector_Reduce(self, *args)


    def __init__(self, *args):
        """
        __init__(Epetra_MultiVector self, BlockMap Map, int NumVectors, bool zeroOut=True) -> MultiVector
        __init__(Epetra_MultiVector self, MultiVector Source) -> MultiVector
        __init__(Epetra_MultiVector self, Epetra_DataAccess CV, BlockMap Map, double ** ArrayOfPointers, int NumVectors) -> MultiVector
        __init__(Epetra_MultiVector self, Epetra_DataAccess CV, MultiVector Source, int * Indices) -> MultiVector
        __init__(Epetra_MultiVector self, Epetra_DataAccess CV, MultiVector Source, int StartIndex, int NumVectors) -> MultiVector
        __init__(Epetra_MultiVector self, Epetra_DataAccess cv, BlockMap map, PyObject * values, int numVectors) -> MultiVector
        __init__(Epetra_MultiVector self, BlockMap map, PyObject * obj) -> MultiVector
        __init__(Epetra_MultiVector self, PyObject * obj) -> MultiVector
        __init__(Epetra_MultiVector self, Epetra_DataAccess cv, MultiVector source) -> MultiVector
        """
        this = _Epetra.new_MultiVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def Dot(self, *args):
        """Dot(MultiVector self, MultiVector a) -> PyObject *"""
        return _Epetra.MultiVector_Dot(self, *args)


    def Norm1(self, *args):
        """Norm1(MultiVector self) -> PyObject *"""
        return _Epetra.MultiVector_Norm1(self, *args)


    def Norm2(self, *args):
        """Norm2(MultiVector self) -> PyObject *"""
        return _Epetra.MultiVector_Norm2(self, *args)


    def NormInf(self, *args):
        """NormInf(MultiVector self) -> PyObject *"""
        return _Epetra.MultiVector_NormInf(self, *args)


    def NormWeighted(self, *args):
        """NormWeighted(MultiVector self, MultiVector weights) -> PyObject *"""
        return _Epetra.MultiVector_NormWeighted(self, *args)


    def MinValue(self, *args):
        """MinValue(MultiVector self) -> PyObject *"""
        return _Epetra.MultiVector_MinValue(self, *args)


    def MaxValue(self, *args):
        """MaxValue(MultiVector self) -> PyObject *"""
        return _Epetra.MultiVector_MaxValue(self, *args)


    def MeanValue(self, *args):
        """MeanValue(MultiVector self) -> PyObject *"""
        return _Epetra.MultiVector_MeanValue(self, *args)


    def __call__(self, *args):
        """__call__(MultiVector self, int i) -> Vector"""
        return _Epetra.MultiVector___call__(self, *args)


    def __distarray__(self, *args):
        """__distarray__(MultiVector self) -> PyObject *"""
        return _Epetra.MultiVector___distarray__(self, *args)

MultiVector_swigregister = _Epetra.MultiVector_swigregister
MultiVector_swigregister(MultiVector)


def MultiVector_getattr(self, name):
    if name == "array":
        a = _extractNumPyArrayFromEpetraMultiVector(self)
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    raise AttributeError("'%s' not an attribute of MultiVector" % name)
def MultiVector_setattr(self, name, value):
    if name == "array":
        raise AttributeError("Cannot change MultiVector 'array' attribute")
    elif name == "shape":
        self.array.shape = value
    elif name == "dtype":
        raise AttributeError("Cannot change MultiVector 'dtype' attribute")
    else:
        self.__dict__[name] = value
def MultiVector_getitem(self,i):
    if isinstance(i,int):
        return self.__call__(i)
    else:
        return self.array.__getitem__(i)
MultiVector.__getattr__ = MultiVector_getattr
MultiVector.__setattr__ = MultiVector_setattr
MultiVector.__getitem__ = MultiVector_getitem
MultiVector.__setitem__ = lambda self, i, v: self.array.__setitem__(i,v)
MultiVector.__len__     = lambda self: self.array.__len__()
MultiVector.__str__     = lambda self: self.array.__str__()
MultiVector.copy        = lambda self: MultiVector(self)
MultiVector.ExtractCopy = lambda self: self.array.copy()
MultiVector.ExtractView = lambda self: self.array
class_array_add_math(MultiVector)
class_array_add_comp(MultiVector)


def _extractNumPyArrayFromEpetraVector(*args):
    """_extractNumPyArrayFromEpetraVector(Vector source) -> PyObject *"""
    return _Epetra._extractNumPyArrayFromEpetraVector(*args)
class Vector(MultiVector):
    """Proxy of C++ Epetra_Vector class."""

    __swig_setmethods__ = {}
    for _s in [MultiVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Vector, name, value)
    __swig_getmethods__ = {}
    for _s in [MultiVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Vector, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_Vector

    def __init__(self, *args):
        """
        __init__(Epetra_Vector self, BlockMap Map, bool zeroOut=True) -> Vector
        __init__(Epetra_Vector self, Vector Source) -> Vector
        __init__(Epetra_Vector self, Epetra_DataAccess CV, MultiVector Source, int Index) -> Vector
        __init__(Epetra_Vector self, Epetra_DataAccess cv, BlockMap map, PyObject * values) -> Vector
        __init__(Epetra_Vector self, BlockMap map, PyObject * obj) -> Vector
        __init__(Epetra_Vector self, PyObject * obj) -> Vector
        __init__(Epetra_Vector self, Epetra_DataAccess cv, Vector source) -> Vector
        """
        this = _Epetra.new_Vector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def ReplaceGlobalValues(self, *args):
        """
        ReplaceGlobalValues(Vector self, int NumEntries, double const * Values, int const * Indices) -> int
        ReplaceGlobalValues(Vector self, int NumEntries, double const * Values, long long const * Indices) -> int
        ReplaceGlobalValues(Vector self, int NumEntries, int BlockOffset, double const * Values, int const * Indices) -> int
        ReplaceGlobalValues(Vector self, PyObject * values, PyObject * indices) -> int
        ReplaceGlobalValues(Vector self, int blockOffset, PyObject * values, PyObject * indices) -> int
        """
        return _Epetra.Vector_ReplaceGlobalValues(self, *args)


    def ReplaceMyValues(self, *args):
        """
        ReplaceMyValues(Vector self, int NumEntries, double const * Values, int const * Indices) -> int
        ReplaceMyValues(Vector self, int NumEntries, int BlockOffset, double const * Values, int const * Indices) -> int
        ReplaceMyValues(Vector self, PyObject * values, PyObject * indices) -> int
        ReplaceMyValues(Vector self, int blockOffset, PyObject * values, PyObject * indices) -> int
        """
        return _Epetra.Vector_ReplaceMyValues(self, *args)


    def SumIntoGlobalValues(self, *args):
        """
        SumIntoGlobalValues(Vector self, int NumEntries, double const * Values, int const * Indices) -> int
        SumIntoGlobalValues(Vector self, int NumEntries, int BlockOffset, double const * Values, int const * Indices) -> int
        SumIntoGlobalValues(Vector self, PyObject * values, PyObject * indices) -> int
        SumIntoGlobalValues(Vector self, int blockOffset, PyObject * values, PyObject * indices) -> int
        """
        return _Epetra.Vector_SumIntoGlobalValues(self, *args)


    def SumIntoMyValues(self, *args):
        """
        SumIntoMyValues(Vector self, int NumEntries, double const * Values, int const * Indices) -> int
        SumIntoMyValues(Vector self, int NumEntries, int BlockOffset, double const * Values, int const * Indices) -> int
        SumIntoMyValues(Vector self, PyObject * values, PyObject * indices) -> int
        SumIntoMyValues(Vector self, int blockOffset, PyObject * values, PyObject * indices) -> int
        """
        return _Epetra.Vector_SumIntoMyValues(self, *args)


    def __distarray__(self, *args):
        """__distarray__(Vector self) -> PyObject *"""
        return _Epetra.Vector___distarray__(self, *args)

Vector_swigregister = _Epetra.Vector_swigregister
Vector_swigregister(Vector)


def Vector_getattr(self, name):
    if name == "array":
        a = _extractNumPyArrayFromEpetraVector(self)
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    raise AttributeError("'%s' not an attribute of Vector" % name)
def Vector_setattr(self, name, value):
    if name == "array":
        raise AttributeError("Cannot change Vector 'array' attribute")
    elif name == "shape":
        self.array.shape = value
    elif name == "dtype":
        raise AttributeError("Cannot change Vector 'dtype' attribute")
    else:
        self.__dict__[name] = value
Vector.__getattr__ = Vector_getattr
Vector.__setattr__ = Vector_setattr
Vector.__getitem__ = lambda self, i: self.array.__getitem__(i)
Vector.__setitem__ = lambda self, i, v: self.array.__setitem__(i,v)
Vector.__len__     = lambda self: self.array.__len__()
Vector.__str__     = lambda self: self.array.__str__()
Vector.copy        = lambda self: Vector(self)
Vector.ExtractCopy = lambda self: self.array.copy()
Vector.ExtractView = lambda self: self.array
class_array_add_math(Vector)
class_array_add_comp(Vector)


def _extractNumPyArrayFromEpetraFEVector(*args):
    """_extractNumPyArrayFromEpetraFEVector(FEVector source) -> PyObject *"""
    return _Epetra._extractNumPyArrayFromEpetraFEVector(*args)
class FEVector(MultiVector):
    """Proxy of C++ Epetra_FEVector class."""

    __swig_setmethods__ = {}
    for _s in [MultiVector]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FEVector, name, value)
    __swig_getmethods__ = {}
    for _s in [MultiVector]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FEVector, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_FEVector

    def GlobalAssemble(self, *args):
        """GlobalAssemble(FEVector self, Epetra_CombineMode mode=Add, bool reuse_map_and_exporter=False) -> int"""
        return _Epetra.FEVector_GlobalAssemble(self, *args)


    def setIgnoreNonLocalEntries(self, *args):
        """setIgnoreNonLocalEntries(FEVector self, bool flag)"""
        return _Epetra.FEVector_setIgnoreNonLocalEntries(self, *args)


    def __init__(self, *args):
        """
        __init__(Epetra_FEVector self, BlockMap Map, int numVectors=1, bool ignoreNonLocalEntries=False) -> FEVector
        __init__(Epetra_FEVector self, Epetra_DataAccess CV, BlockMap Map, double ** ArrayOfPointers, int NumVectors, bool ignoreNonLocalEntries=False) -> FEVector
        __init__(Epetra_FEVector self, FEVector source) -> FEVector
        __init__(Epetra_FEVector self, Epetra_DataAccess cv, BlockMap map, PyObject * values, int numVectors, bool ignoreNonLocalEntries=False) -> FEVector
        """
        this = _Epetra.new_FEVector(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def ReplaceGlobalValues(self, *args):
        """
        ReplaceGlobalValues(FEVector self, int numIDs, int const * GIDs, double const * values, int vectorIndex=0) -> int
        ReplaceGlobalValues(FEVector self, int numIDs, long long const * GIDs, double const * values, int vectorIndex=0) -> int
        ReplaceGlobalValues(FEVector self, IntSerialDenseVector GIDs, SerialDenseVector values, int vectorIndex=0) -> int
        ReplaceGlobalValues(FEVector self, Epetra_LongLongSerialDenseVector const & GIDs, SerialDenseVector values, int vectorIndex=0) -> int
        ReplaceGlobalValues(FEVector self, int numIDs, int const * GIDs, int const * numValuesPerID, double const * values, int vectorIndex=0) -> int
        ReplaceGlobalValues(FEVector self, int numIDs, long long const * GIDs, int const * numValuesPerID, double const * values, int vectorIndex=0) -> int
        ReplaceGlobalValues(FEVector self, PyObject * gids, PyObject * values, int vectorId=0) -> int
        """
        return _Epetra.FEVector_ReplaceGlobalValues(self, *args)


    def SumIntoGlobalValues(self, *args):
        """
        SumIntoGlobalValues(FEVector self, int numIDs, int const * GIDs, double const * values, int vectorIndex=0) -> int
        SumIntoGlobalValues(FEVector self, int numIDs, long long const * GIDs, double const * values, int vectorIndex=0) -> int
        SumIntoGlobalValues(FEVector self, IntSerialDenseVector GIDs, SerialDenseVector values, int vectorIndex=0) -> int
        SumIntoGlobalValues(FEVector self, Epetra_LongLongSerialDenseVector const & GIDs, SerialDenseVector values, int vectorIndex=0) -> int
        SumIntoGlobalValues(FEVector self, int numIDs, int const * GIDs, int const * numValuesPerID, double const * values, int vectorIndex=0) -> int
        SumIntoGlobalValues(FEVector self, int numIDs, long long const * GIDs, int const * numValuesPerID, double const * values, int vectorIndex=0) -> int
        SumIntoGlobalValues(FEVector self, PyObject * gids, PyObject * values, int vectorId=0) -> int
        """
        return _Epetra.FEVector_SumIntoGlobalValues(self, *args)


    def __distarray__(self, *args):
        """__distarray__(FEVector self) -> PyObject *"""
        return _Epetra.FEVector___distarray__(self, *args)

FEVector_swigregister = _Epetra.FEVector_swigregister
FEVector_swigregister(FEVector)


def FEVector_getattr(self, name):
    if name == "array":
        a = _extractNumPyArrayFromEpetraFEVector(self)
        self.__dict__["array"] = a
        return a
    elif name == "shape":
        return self.array.shape
    elif name == "dtype":
        return self.array.dtype
    raise AttributeError("'%s' not an attribute of FEVector" % name)
def FEVector_setattr(self, name, value):
    if name == "array":
        raise AttributeError("Cannot change FEVector 'array' attribute")
    elif name == "shape":
        self.array.shape = value
    elif name == "dtype":
        raise AttributeError("Cannot change FEVector 'dtype' attribute")
    else:
        self.__dict__[name] = value
FEVector.__getattr__ = FEVector_getattr
FEVector.__setattr__ = FEVector_setattr
FEVector.__getitem__ = lambda self, i: self.array.__getitem__(i)
FEVector.__setitem__ = lambda self, i, v: self.array.__setitem__(i, v)
FEVector.__len__     = lambda self: self.array.__len__()
FEVector.__str__     = lambda self: self.array.__str__()
FEVector.copy        = lambda self: Vector(self)
FEVector.ExtractCopy = lambda self: self.array.copy()
FEVector.ExtractView = lambda self: self.array
class_array_add_math(FEVector)
class_array_add_comp(FEVector)

class CrsGraph(DistObject):
    """Proxy of C++ Epetra_CrsGraph class."""

    __swig_setmethods__ = {}
    for _s in [DistObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CrsGraph, name, value)
    __swig_getmethods__ = {}
    for _s in [DistObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CrsGraph, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_CrsGraph

    def InsertGlobalIndices(self, *args):
        """
        InsertGlobalIndices(self, int globalRow, PySequence indices) -> int

        Insert a sequence of global indices into the set of nonzero columns
        for the specified global row.  Argument indices can be a numpy array
        of integers or any python sequence that can be converted to a numpy
        array of integers.  The integers represent global IDs that are to be
        inserted into the graph.  An integer error/warning code is returned.

        InsertGlobalIndices(self, int globalRow, PySequence indices) -> int

        Insert a sequence of global indices into the set of nonzero columns
        for the specified global row.  Argument indices can be a numpy array
        of integers or any python sequence that can be converted to a numpy
        array of integers.  The integers represent global IDs that are to be
        inserted into the graph.  An integer error/warning code is returned.

        """
        return _Epetra.CrsGraph_InsertGlobalIndices(self, *args)


    def RemoveGlobalIndices(self, *args):
        """
        RemoveGlobalIndices(self, int globalRow, PySequence indices) -> int

        Remove a sequence of global indices from the set of nonzero columns
        for the specified global row.  Argument indices can be a numpy array
        of integers or any python sequence that can be converted to a numpy
        array of integers.  The integers represent global IDs that are to be
        removed from the graph.  An integer error/warning code is returned.

        RemoveGlobalIndices(CrsGraph self, long long GlobalRow, int NumIndices, long long * Indices) -> int
        RemoveGlobalIndices(CrsGraph self, long long Row) -> int
        """
        return _Epetra.CrsGraph_RemoveGlobalIndices(self, *args)


    def InsertMyIndices(self, *args):
        """
        InsertMyIndices(self, int localRow, PySequence indices) -> int

        Insert a sequence of local indices into the set of nonzero columns for
        the specified local row.  Argument indices can be a numpy array of
        integers or any python sequence that can be converted to a numpy array
        of integers.  The integers represent local IDs that are to be inserted
        into the graph.  An integer error/warning code is returned.

        """
        return _Epetra.CrsGraph_InsertMyIndices(self, *args)


    def RemoveMyIndices(self, *args):
        """
        RemoveMyIndices(self, int localRow, PySequence indices) -> int

        Remove a sequence of local indices from the set of nonzero columns for
        the specified local row.  Argument indices can be a numpy array of
        integers or any python sequence that can be converted to a numpy array
        of integers.  The integers represent local IDs that are to be removed
        from the graph.  An integer error/warning code is returned.

        RemoveMyIndices(CrsGraph self, int Row) -> int
        """
        return _Epetra.CrsGraph_RemoveMyIndices(self, *args)


    def FillComplete(self, *args):
        """
        FillComplete(CrsGraph self) -> int
        FillComplete(CrsGraph self, BlockMap DomainMap, BlockMap RangeMap) -> int
        """
        return _Epetra.CrsGraph_FillComplete(self, *args)


    def OptimizeStorage(self, *args):
        """OptimizeStorage(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_OptimizeStorage(self, *args)


    def ExtractGlobalRowView(self, *args):
        """ExtractGlobalRowView(CrsGraph self, long long GlobalRow, int & NumIndices, long long *& Indices) -> int"""
        return _Epetra.CrsGraph_ExtractGlobalRowView(self, *args)


    def Filled(self, *args):
        """Filled(CrsGraph self) -> bool"""
        return _Epetra.CrsGraph_Filled(self, *args)


    def StorageOptimized(self, *args):
        """StorageOptimized(CrsGraph self) -> bool"""
        return _Epetra.CrsGraph_StorageOptimized(self, *args)


    def IndicesAreGlobal(self, *args):
        """IndicesAreGlobal(CrsGraph self) -> bool"""
        return _Epetra.CrsGraph_IndicesAreGlobal(self, *args)


    def IndicesAreLocal(self, *args):
        """IndicesAreLocal(CrsGraph self) -> bool"""
        return _Epetra.CrsGraph_IndicesAreLocal(self, *args)


    def LowerTriangular(self, *args):
        """LowerTriangular(CrsGraph self) -> bool"""
        return _Epetra.CrsGraph_LowerTriangular(self, *args)


    def UpperTriangular(self, *args):
        """UpperTriangular(CrsGraph self) -> bool"""
        return _Epetra.CrsGraph_UpperTriangular(self, *args)


    def NoDiagonal(self, *args):
        """NoDiagonal(CrsGraph self) -> bool"""
        return _Epetra.CrsGraph_NoDiagonal(self, *args)


    def MyGlobalRow(self, *args):
        """
        MyGlobalRow(CrsGraph self, int GID) -> bool
        MyGlobalRow(CrsGraph self, long long GID) -> bool
        """
        return _Epetra.CrsGraph_MyGlobalRow(self, *args)


    def HaveColMap(self, *args):
        """HaveColMap(CrsGraph self) -> bool"""
        return _Epetra.CrsGraph_HaveColMap(self, *args)


    def NumMyRows(self, *args):
        """NumMyRows(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_NumMyRows(self, *args)


    def NumGlobalRows(self, *args):
        """NumGlobalRows(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_NumGlobalRows(self, *args)


    def NumGlobalRows64(self, *args):
        """NumGlobalRows64(CrsGraph self) -> long long"""
        return _Epetra.CrsGraph_NumGlobalRows64(self, *args)


    def NumMyCols(self, *args):
        """NumMyCols(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_NumMyCols(self, *args)


    def NumGlobalCols(self, *args):
        """NumGlobalCols(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_NumGlobalCols(self, *args)


    def NumGlobalCols64(self, *args):
        """NumGlobalCols64(CrsGraph self) -> long long"""
        return _Epetra.CrsGraph_NumGlobalCols64(self, *args)


    def NumGlobalNonzeros(self, *args):
        """NumGlobalNonzeros(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_NumGlobalNonzeros(self, *args)


    def NumGlobalNonzeros64(self, *args):
        """NumGlobalNonzeros64(CrsGraph self) -> long long"""
        return _Epetra.CrsGraph_NumGlobalNonzeros64(self, *args)


    def NumGlobalDiagonals(self, *args):
        """NumGlobalDiagonals(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_NumGlobalDiagonals(self, *args)


    def NumGlobalDiagonals64(self, *args):
        """NumGlobalDiagonals64(CrsGraph self) -> long long"""
        return _Epetra.CrsGraph_NumGlobalDiagonals64(self, *args)


    def NumMyDiagonals(self, *args):
        """NumMyDiagonals(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_NumMyDiagonals(self, *args)


    def NumMyBlockRows(self, *args):
        """NumMyBlockRows(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_NumMyBlockRows(self, *args)


    def NumGlobalBlockRows(self, *args):
        """NumGlobalBlockRows(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_NumGlobalBlockRows(self, *args)


    def NumGlobalBlockRows64(self, *args):
        """NumGlobalBlockRows64(CrsGraph self) -> long long"""
        return _Epetra.CrsGraph_NumGlobalBlockRows64(self, *args)


    def NumMyBlockCols(self, *args):
        """NumMyBlockCols(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_NumMyBlockCols(self, *args)


    def NumGlobalBlockCols(self, *args):
        """NumGlobalBlockCols(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_NumGlobalBlockCols(self, *args)


    def NumGlobalBlockCols64(self, *args):
        """NumGlobalBlockCols64(CrsGraph self) -> long long"""
        return _Epetra.CrsGraph_NumGlobalBlockCols64(self, *args)


    def NumMyBlockDiagonals(self, *args):
        """NumMyBlockDiagonals(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_NumMyBlockDiagonals(self, *args)


    def NumGlobalBlockDiagonals(self, *args):
        """NumGlobalBlockDiagonals(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_NumGlobalBlockDiagonals(self, *args)


    def NumGlobalBlockDiagonals64(self, *args):
        """NumGlobalBlockDiagonals64(CrsGraph self) -> long long"""
        return _Epetra.CrsGraph_NumGlobalBlockDiagonals64(self, *args)


    def NumGlobalEntries(self, *args):
        """NumGlobalEntries(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_NumGlobalEntries(self, *args)


    def NumGlobalEntries64(self, *args):
        """NumGlobalEntries64(CrsGraph self) -> long long"""
        return _Epetra.CrsGraph_NumGlobalEntries64(self, *args)


    def NumMyEntries(self, *args):
        """NumMyEntries(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_NumMyEntries(self, *args)


    def MaxRowDim(self, *args):
        """MaxRowDim(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_MaxRowDim(self, *args)


    def GlobalMaxRowDim(self, *args):
        """GlobalMaxRowDim(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_GlobalMaxRowDim(self, *args)


    def MaxColDim(self, *args):
        """MaxColDim(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_MaxColDim(self, *args)


    def GlobalMaxColDim(self, *args):
        """GlobalMaxColDim(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_GlobalMaxColDim(self, *args)


    def NumMyNonzeros(self, *args):
        """NumMyNonzeros(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_NumMyNonzeros(self, *args)


    def NumGlobalIndices(self, *args):
        """NumGlobalIndices(CrsGraph self, long long Row) -> int"""
        return _Epetra.CrsGraph_NumGlobalIndices(self, *args)


    def NumAllocatedGlobalIndices(self, *args):
        """NumAllocatedGlobalIndices(CrsGraph self, long long Row) -> int"""
        return _Epetra.CrsGraph_NumAllocatedGlobalIndices(self, *args)


    def MaxNumIndices(self, *args):
        """MaxNumIndices(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_MaxNumIndices(self, *args)


    def GlobalMaxNumIndices(self, *args):
        """GlobalMaxNumIndices(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_GlobalMaxNumIndices(self, *args)


    def MaxNumNonzeros(self, *args):
        """MaxNumNonzeros(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_MaxNumNonzeros(self, *args)


    def GlobalMaxNumNonzeros(self, *args):
        """GlobalMaxNumNonzeros(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_GlobalMaxNumNonzeros(self, *args)


    def NumMyIndices(self, *args):
        """NumMyIndices(CrsGraph self, int Row) -> int"""
        return _Epetra.CrsGraph_NumMyIndices(self, *args)


    def NumAllocatedMyIndices(self, *args):
        """NumAllocatedMyIndices(CrsGraph self, int Row) -> int"""
        return _Epetra.CrsGraph_NumAllocatedMyIndices(self, *args)


    def IndexBase(self, *args):
        """IndexBase(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_IndexBase(self, *args)


    def IndexBase64(self, *args):
        """IndexBase64(CrsGraph self) -> long long"""
        return _Epetra.CrsGraph_IndexBase64(self, *args)


    def RowMap(self, *args):
        """RowMap(CrsGraph self) -> BlockMap"""
        return _Epetra.CrsGraph_RowMap(self, *args)


    def ReplaceRowMap(self, *args):
        """ReplaceRowMap(CrsGraph self, BlockMap newmap) -> int"""
        return _Epetra.CrsGraph_ReplaceRowMap(self, *args)


    def ReplaceColMap(self, *args):
        """ReplaceColMap(CrsGraph self, BlockMap newmap) -> int"""
        return _Epetra.CrsGraph_ReplaceColMap(self, *args)


    def ReplaceDomainMapAndImporter(self, *args):
        """ReplaceDomainMapAndImporter(CrsGraph self, BlockMap NewDomainMap, Import NewImporter) -> int"""
        return _Epetra.CrsGraph_ReplaceDomainMapAndImporter(self, *args)


    def RemoveEmptyProcessesInPlace(self, *args):
        """RemoveEmptyProcessesInPlace(CrsGraph self, BlockMap NewMap) -> int"""
        return _Epetra.CrsGraph_RemoveEmptyProcessesInPlace(self, *args)


    def ColMap(self, *args):
        """ColMap(CrsGraph self) -> BlockMap"""
        return _Epetra.CrsGraph_ColMap(self, *args)


    def DomainMap(self, *args):
        """DomainMap(CrsGraph self) -> BlockMap"""
        return _Epetra.CrsGraph_DomainMap(self, *args)


    def RangeMap(self, *args):
        """RangeMap(CrsGraph self) -> BlockMap"""
        return _Epetra.CrsGraph_RangeMap(self, *args)


    def Importer(self, *args):
        """Importer(CrsGraph self) -> Import"""
        return _Epetra.CrsGraph_Importer(self, *args)


    def Exporter(self, *args):
        """Exporter(CrsGraph self) -> Export"""
        return _Epetra.CrsGraph_Exporter(self, *args)


    def Comm(self, *args):
        """Comm(CrsGraph self) -> Comm"""
        return _Epetra.CrsGraph_Comm(self, *args)


    def LRID(self, *args):
        """
        LRID(CrsGraph self, int GRID_in) -> int
        LRID(CrsGraph self, long long GRID_in) -> int
        """
        return _Epetra.CrsGraph_LRID(self, *args)


    def GRID(self, *args):
        """GRID(CrsGraph self, int LRID_in) -> int"""
        return _Epetra.CrsGraph_GRID(self, *args)


    def GRID64(self, *args):
        """GRID64(CrsGraph self, int LRID_in) -> long long"""
        return _Epetra.CrsGraph_GRID64(self, *args)


    def LCID(self, *args):
        """
        LCID(CrsGraph self, int GCID_in) -> int
        LCID(CrsGraph self, long long GCID_in) -> int
        """
        return _Epetra.CrsGraph_LCID(self, *args)


    def GCID(self, *args):
        """GCID(CrsGraph self, int LCID_in) -> int"""
        return _Epetra.CrsGraph_GCID(self, *args)


    def GCID64(self, *args):
        """GCID64(CrsGraph self, int LCID_in) -> long long"""
        return _Epetra.CrsGraph_GCID64(self, *args)


    def MyGRID(self, *args):
        """
        MyGRID(CrsGraph self, int GRID_in) -> bool
        MyGRID(CrsGraph self, long long GRID_in) -> bool
        """
        return _Epetra.CrsGraph_MyGRID(self, *args)


    def MyLRID(self, *args):
        """MyLRID(CrsGraph self, int LRID_in) -> bool"""
        return _Epetra.CrsGraph_MyLRID(self, *args)


    def MyGCID(self, *args):
        """
        MyGCID(CrsGraph self, int GCID_in) -> bool
        MyGCID(CrsGraph self, long long GCID_in) -> bool
        """
        return _Epetra.CrsGraph_MyGCID(self, *args)


    def MyLCID(self, *args):
        """MyLCID(CrsGraph self, int LCID_in) -> bool"""
        return _Epetra.CrsGraph_MyLCID(self, *args)


    def PrintGraphData(self, *args):
        """
        PrintGraphData(CrsGraph self, std::ostream & os)
        PrintGraphData(CrsGraph self, std::ostream & os, int level)
        """
        return _Epetra.CrsGraph_PrintGraphData(self, *args)


    def ImportMap(self, *args):
        """ImportMap(CrsGraph self) -> BlockMap"""
        return _Epetra.CrsGraph_ImportMap(self, *args)


    def TransformToLocal(self, *args):
        """
        TransformToLocal(CrsGraph self) -> int
        TransformToLocal(CrsGraph self, BlockMap DomainMap, BlockMap RangeMap) -> int
        """
        return _Epetra.CrsGraph_TransformToLocal(self, *args)


    def ReferenceCount(self, *args):
        """ReferenceCount(CrsGraph self) -> int"""
        return _Epetra.CrsGraph_ReferenceCount(self, *args)


    def DataPtr(self, *args):
        """DataPtr(CrsGraph self) -> Epetra_CrsGraphData const *"""
        return _Epetra.CrsGraph_DataPtr(self, *args)


    def SortGhostsAssociatedWithEachProcessor(self, *args):
        """SortGhostsAssociatedWithEachProcessor(CrsGraph self, bool Flag)"""
        return _Epetra.CrsGraph_SortGhostsAssociatedWithEachProcessor(self, *args)


    def __init__(self, *args):
        """

        __init__(self, Epetra_DataAccess CV, BlockMap rowMap, int numIndicesPerRow,
            bool staticProfile=False) -> CrsGraph

          Constructor with implicit column map and constant indices per row.
          Arguments:

            CV                - Epetra.Copy or Epetra.View
            rowMap            - Map describing distribution of rows across processors
            numIndicesPerRow  - Integer number of indices per row
            staticProfile     - Static profile flag

        __init__(self, Epetra_DataAccess CV, BlockMap rowMap, BlockMap colMap,
            int numIndicesPerRow, bool staticProfile=False) -> CrsGraph

          Constructor with specified column map and constant indices per row.
          Arguments:

            CV                - Epetra.Copy or Epetra.View
            rowMap            - Map describing distribution of rows across processors
            colMap            - Map describing distribution of columns across processors
            numIndicesPerRow  - Integer number of indices per row
            staticProfile     - Static profile flag

        __init__(self, CrsGraph graph) -> CrsGraph

          Copy constructor.  Arguments:

            graph - Source graph for copy constructor

        __init__(self, Epetra_DataAccess CV, BlockMap rowMap, PySequence
            numIndicesPerRow, bool staticProfile=False) -> CrsGraph

          Constructor with implicit column map and variable indices per row.
          Arguments:

            CV                - Epetra.Copy or Epetra.View
            rowMap            - Map describing distribution of rows across processors
            numIndicesPerRow  - Sequence of integers representing the number of indices
                                per row
            staticProfile     - Static profile flag

        __init__(self, Epetra_DataAccess CV, BlockMap rowMap, BlockMap colMap,
            PySequence numIndicesPerRow, bool staticProfile=False) -> CrsGraph

          Constructor with specified column map and variable indices per row.
          Arguments:

            CV                - Epetra.Copy or Epetra.View
            rowMap            - Map describing distribution of rows across processors
            colMap            - Map describing distribution of columns across processors
            numIndicesPerRow  - Sequence of integers representing the number of indices
                                per row
            staticProfile     - Static profile flag
        """
        this = _Epetra.new_CrsGraph(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def ExtractGlobalRowCopy(self, *args):
        """
        ExtractGlobalRowCopy(CrsGraph self, long long GlobalRow, int LenOfIndices, int & NumIndices, long long * Indices) -> int
        ExtractGlobalRowCopy(CrsGraph self, int globalRow) -> PyObject *
        """
        return _Epetra.CrsGraph_ExtractGlobalRowCopy(self, *args)


    def __getitem__(self, *args):
        """__getitem__(CrsGraph self, int i) -> int *"""
        return _Epetra.CrsGraph___getitem__(self, *args)


    def ExtractMyRowCopy(self, *args):
        """ExtractMyRowCopy(CrsGraph self, int localRow) -> PyObject *"""
        return _Epetra.CrsGraph_ExtractMyRowCopy(self, *args)

CrsGraph_swigregister = _Epetra.CrsGraph_swigregister
CrsGraph_swigregister(CrsGraph)

class OffsetIndex(Object):
    """Proxy of C++ Epetra_OffsetIndex class."""

    __swig_setmethods__ = {}
    for _s in [Object]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OffsetIndex, name, value)
    __swig_getmethods__ = {}
    for _s in [Object]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OffsetIndex, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_OffsetIndex self, CrsGraph SourceGraph, CrsGraph TargetGraph, Import Importer) -> OffsetIndex
        __init__(Epetra_OffsetIndex self, CrsGraph SourceGraph, CrsGraph TargetGraph, Export Exporter) -> OffsetIndex
        __init__(Epetra_OffsetIndex self, OffsetIndex Indexor) -> OffsetIndex
        """
        this = _Epetra.new_OffsetIndex(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_OffsetIndex

    def SameOffsets(self, *args):
        """SameOffsets(OffsetIndex self) -> int **"""
        return _Epetra.OffsetIndex_SameOffsets(self, *args)


    def PermuteOffsets(self, *args):
        """PermuteOffsets(OffsetIndex self) -> int **"""
        return _Epetra.OffsetIndex_PermuteOffsets(self, *args)


    def RemoteOffsets(self, *args):
        """RemoteOffsets(OffsetIndex self) -> int **"""
        return _Epetra.OffsetIndex_RemoteOffsets(self, *args)

    __swig_setmethods__["NumSame_"] = _Epetra.OffsetIndex_NumSame__set
    __swig_getmethods__["NumSame_"] = _Epetra.OffsetIndex_NumSame__get
    if _newclass:
        NumSame_ = _swig_property(_Epetra.OffsetIndex_NumSame__get, _Epetra.OffsetIndex_NumSame__set)
    __swig_setmethods__["SameOffsets_"] = _Epetra.OffsetIndex_SameOffsets__set
    __swig_getmethods__["SameOffsets_"] = _Epetra.OffsetIndex_SameOffsets__get
    if _newclass:
        SameOffsets_ = _swig_property(_Epetra.OffsetIndex_SameOffsets__get, _Epetra.OffsetIndex_SameOffsets__set)
    __swig_setmethods__["NumPermute_"] = _Epetra.OffsetIndex_NumPermute__set
    __swig_getmethods__["NumPermute_"] = _Epetra.OffsetIndex_NumPermute__get
    if _newclass:
        NumPermute_ = _swig_property(_Epetra.OffsetIndex_NumPermute__get, _Epetra.OffsetIndex_NumPermute__set)
    __swig_setmethods__["PermuteOffsets_"] = _Epetra.OffsetIndex_PermuteOffsets__set
    __swig_getmethods__["PermuteOffsets_"] = _Epetra.OffsetIndex_PermuteOffsets__get
    if _newclass:
        PermuteOffsets_ = _swig_property(_Epetra.OffsetIndex_PermuteOffsets__get, _Epetra.OffsetIndex_PermuteOffsets__set)
    __swig_setmethods__["NumExport_"] = _Epetra.OffsetIndex_NumExport__set
    __swig_getmethods__["NumExport_"] = _Epetra.OffsetIndex_NumExport__get
    if _newclass:
        NumExport_ = _swig_property(_Epetra.OffsetIndex_NumExport__get, _Epetra.OffsetIndex_NumExport__set)
    __swig_setmethods__["NumRemote_"] = _Epetra.OffsetIndex_NumRemote__set
    __swig_getmethods__["NumRemote_"] = _Epetra.OffsetIndex_NumRemote__get
    if _newclass:
        NumRemote_ = _swig_property(_Epetra.OffsetIndex_NumRemote__get, _Epetra.OffsetIndex_NumRemote__set)
    __swig_setmethods__["RemoteOffsets_"] = _Epetra.OffsetIndex_RemoteOffsets__set
    __swig_getmethods__["RemoteOffsets_"] = _Epetra.OffsetIndex_RemoteOffsets__get
    if _newclass:
        RemoteOffsets_ = _swig_property(_Epetra.OffsetIndex_RemoteOffsets__get, _Epetra.OffsetIndex_RemoteOffsets__set)
    __swig_setmethods__["DataOwned_"] = _Epetra.OffsetIndex_DataOwned__set
    __swig_getmethods__["DataOwned_"] = _Epetra.OffsetIndex_DataOwned__get
    if _newclass:
        DataOwned_ = _swig_property(_Epetra.OffsetIndex_DataOwned__get, _Epetra.OffsetIndex_DataOwned__set)
OffsetIndex_swigregister = _Epetra.OffsetIndex_swigregister
OffsetIndex_swigregister(OffsetIndex)

class Operator(_object):
    """

    For cross-language polymorphism to work in python, you must call this
    constructor::

        from PyTrilinos import Epetra
        class MyOperator(Epetra.Operator):
            def __init__(self):
                Epetra.Operator.__init__(self)

    Other than that, the Epetra.Operator class is much more forgiving than
    its C++ counterpart.  Often, you can override just the Label() and
    Apply() methods.

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Operator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Operator, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_Operator

    def SetUseTranspose(self, *args):
        """SetUseTranspose(Operator self, bool UseTranspose) -> int"""
        return _Epetra.Operator_SetUseTranspose(self, *args)


    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        """
        return _Epetra.Operator_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.

        """
        return _Epetra.Operator_ApplyInverse(self, *args)


    def NormInf(self, *args):
        """NormInf(Operator self) -> double"""
        return _Epetra.Operator_NormInf(self, *args)


    def Label(self, *args):
        """Label(Operator self) -> char const *"""
        return _Epetra.Operator_Label(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(Operator self) -> bool"""
        return _Epetra.Operator_UseTranspose(self, *args)


    def HasNormInf(self, *args):
        """HasNormInf(Operator self) -> bool"""
        return _Epetra.Operator_HasNormInf(self, *args)


    def Comm(self, *args):
        """Comm(Operator self) -> Comm"""
        return _Epetra.Operator_Comm(self, *args)


    def OperatorDomainMap(self, *args):
        """OperatorDomainMap(Operator self) -> Map"""
        return _Epetra.Operator_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """OperatorRangeMap(Operator self) -> Map"""
        return _Epetra.Operator_OperatorRangeMap(self, *args)


    def __init__(self, *args):
        """
        __init__(Epetra_Operator self) -> Operator


        For cross-language polymorphism to work in python, you must call this
        constructor::

            from PyTrilinos import Epetra
            class MyOperator(Epetra.Operator):
                def __init__(self):
                    Epetra.Operator.__init__(self)

        Other than that, the Epetra.Operator class is much more forgiving than
        its C++ counterpart.  Often, you can override just the Label() and
        Apply() methods.

        """
        if self.__class__ == Operator:
            _self = None
        else:
            _self = self
        this = _Epetra.new_Operator(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    def __disown__(self):
        self.this.disown()
        _Epetra.disown_Operator(self)
        return weakref_proxy(self)
Operator_swigregister = _Epetra.Operator_swigregister
Operator_swigregister(Operator)

class InvOperator(Operator):
    """Proxy of C++ Epetra_InvOperator class."""

    __swig_setmethods__ = {}
    for _s in [Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, InvOperator, name, value)
    __swig_getmethods__ = {}
    for _s in [Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, InvOperator, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Epetra_InvOperator self, Operator operatorIn) -> InvOperator"""
        if self.__class__ == InvOperator:
            _self = None
        else:
            _self = self
        this = _Epetra.new_InvOperator(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_InvOperator

    def SetUseTranspose(self, *args):
        """SetUseTranspose(InvOperator self, bool UseTranspose_in) -> int"""
        return _Epetra.InvOperator_SetUseTranspose(self, *args)


    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        """
        return _Epetra.InvOperator_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.

        """
        return _Epetra.InvOperator_ApplyInverse(self, *args)


    def NormInf(self, *args):
        """NormInf(InvOperator self) -> double"""
        return _Epetra.InvOperator_NormInf(self, *args)


    def Label(self, *args):
        """Label(InvOperator self) -> char const *"""
        return _Epetra.InvOperator_Label(self, *args)


    def Operator(self, *args):
        """Operator(InvOperator self) -> Operator"""
        return _Epetra.InvOperator_Operator(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(InvOperator self) -> bool"""
        return _Epetra.InvOperator_UseTranspose(self, *args)


    def HasNormInf(self, *args):
        """HasNormInf(InvOperator self) -> bool"""
        return _Epetra.InvOperator_HasNormInf(self, *args)


    def Comm(self, *args):
        """Comm(InvOperator self) -> Comm"""
        return _Epetra.InvOperator_Comm(self, *args)


    def OperatorDomainMap(self, *args):
        """OperatorDomainMap(InvOperator self) -> Map"""
        return _Epetra.InvOperator_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """OperatorRangeMap(InvOperator self) -> Map"""
        return _Epetra.InvOperator_OperatorRangeMap(self, *args)

    def __disown__(self):
        self.this.disown()
        _Epetra.disown_InvOperator(self)
        return weakref_proxy(self)
InvOperator_swigregister = _Epetra.InvOperator_swigregister
InvOperator_swigregister(InvOperator)

class RowMatrix(Operator, SrcDistObject):
    """Proxy of C++ Epetra_RowMatrix class."""

    __swig_setmethods__ = {}
    for _s in [Operator, SrcDistObject]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, RowMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [Operator, SrcDistObject]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, RowMatrix, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_RowMatrix

    def NumMyRowEntries(self, *args):
        """
        NumMyRowEntries(int myRow, numpy.ndarray numEntries) -> int

        In C++, numEntries in an int&.  In python, it is provided to you as a
        numpy array of length one so that you can set its value in-place using
        numEntries[0] = ....
        """
        return _Epetra.RowMatrix_NumMyRowEntries(self, *args)


    def MaxNumEntries(self, *args):
        """MaxNumEntries(RowMatrix self) -> int"""
        return _Epetra.RowMatrix_MaxNumEntries(self, *args)


    def ExtractMyRowCopy(self, *args):
        """
        ExtractMyRowCopy(int myRow, int length, numpy.ndarray numEntries,
            numpy.ndarray values, numpy.ndarray indices) -> int

        In C++, numEntries in an int&.  In python, it is provided to you as a
        numpy array of length one so that you can set its value in-place using
        numEntries[0] = ....

        Arguments values and indices are double* and int*, respectively, in
        C++.  In python, these are provided to you as numpy arrays of the
        given length, so that you may alter their entries in-place.
        """
        return _Epetra.RowMatrix_ExtractMyRowCopy(self, *args)


    def ExtractDiagonalCopy(self, *args):
        """
        ExtractDiagonalCopy(Vector diagonal) -> int

        Argument diagonal is provided to you as a numpy-hybrid Epetra.Vector,
        giving you access to the numpy interface in addition to the
        Epetra_Vector C++ interface.
        """
        return _Epetra.RowMatrix_ExtractDiagonalCopy(self, *args)


    def Multiply(self, *args):
        """
        Multiply(bool useTranspose, MultiVector x, MultiVector y) -> int

        In C++, arguments x and y are Epetra_MultiVectors.  In python, they
        are provided to you as numpy-hybrid Epetra.MultiVectors, giving you
        access to the numpy interface in addition to the Epetra_MultiVector
        C++ interface.
        """
        return _Epetra.RowMatrix_Multiply(self, *args)


    def Solve(self, *args):
        """
        Solve((bool upper, bool trans, bool unitDiagonal, MultiVector x,
            MultiVector y) -> int

        In C++, arguments x and y are Epetra_MultiVectors.  In python, they
        are provided to you as numpy-hybrid Epetra.MultiVectors, giving you
        access to the numpy interface in addition to the Epetra_MultiVector
        C++ interface.
        """
        return _Epetra.RowMatrix_Solve(self, *args)


    def InvRowSums(self, *args):
        """
        InvRowSums(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return _Epetra.RowMatrix_InvRowSums(self, *args)


    def LeftScale(self, *args):
        """
        LeftScale(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return _Epetra.RowMatrix_LeftScale(self, *args)


    def InvColSums(self, *args):
        """
        InvColSums(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return _Epetra.RowMatrix_InvColSums(self, *args)


    def RightScale(self, *args):
        """
        RightScale(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return _Epetra.RowMatrix_RightScale(self, *args)


    def Filled(self, *args):
        """Filled(RowMatrix self) -> bool"""
        return _Epetra.RowMatrix_Filled(self, *args)


    def NormInf(self, *args):
        """NormInf(RowMatrix self) -> double"""
        return _Epetra.RowMatrix_NormInf(self, *args)


    def NormOne(self, *args):
        """NormOne(RowMatrix self) -> double"""
        return _Epetra.RowMatrix_NormOne(self, *args)


    def NumGlobalNonzeros(self, *args):
        """NumGlobalNonzeros(RowMatrix self) -> int"""
        return _Epetra.RowMatrix_NumGlobalNonzeros(self, *args)


    def NumGlobalNonzeros64(self, *args):
        """NumGlobalNonzeros64(RowMatrix self) -> long long"""
        return _Epetra.RowMatrix_NumGlobalNonzeros64(self, *args)


    def NumGlobalRows(self, *args):
        """NumGlobalRows(RowMatrix self) -> int"""
        return _Epetra.RowMatrix_NumGlobalRows(self, *args)


    def NumGlobalRows64(self, *args):
        """NumGlobalRows64(RowMatrix self) -> long long"""
        return _Epetra.RowMatrix_NumGlobalRows64(self, *args)


    def NumGlobalCols(self, *args):
        """NumGlobalCols(RowMatrix self) -> int"""
        return _Epetra.RowMatrix_NumGlobalCols(self, *args)


    def NumGlobalCols64(self, *args):
        """NumGlobalCols64(RowMatrix self) -> long long"""
        return _Epetra.RowMatrix_NumGlobalCols64(self, *args)


    def NumGlobalDiagonals(self, *args):
        """NumGlobalDiagonals(RowMatrix self) -> int"""
        return _Epetra.RowMatrix_NumGlobalDiagonals(self, *args)


    def NumGlobalDiagonals64(self, *args):
        """NumGlobalDiagonals64(RowMatrix self) -> long long"""
        return _Epetra.RowMatrix_NumGlobalDiagonals64(self, *args)


    def NumMyNonzeros(self, *args):
        """NumMyNonzeros(RowMatrix self) -> int"""
        return _Epetra.RowMatrix_NumMyNonzeros(self, *args)


    def NumMyRows(self, *args):
        """NumMyRows(RowMatrix self) -> int"""
        return _Epetra.RowMatrix_NumMyRows(self, *args)


    def NumMyCols(self, *args):
        """NumMyCols(RowMatrix self) -> int"""
        return _Epetra.RowMatrix_NumMyCols(self, *args)


    def NumMyDiagonals(self, *args):
        """NumMyDiagonals(RowMatrix self) -> int"""
        return _Epetra.RowMatrix_NumMyDiagonals(self, *args)


    def LowerTriangular(self, *args):
        """LowerTriangular(RowMatrix self) -> bool"""
        return _Epetra.RowMatrix_LowerTriangular(self, *args)


    def UpperTriangular(self, *args):
        """UpperTriangular(RowMatrix self) -> bool"""
        return _Epetra.RowMatrix_UpperTriangular(self, *args)


    def RowMatrixRowMap(self, *args):
        """RowMatrixRowMap(RowMatrix self) -> Map"""
        return _Epetra.RowMatrix_RowMatrixRowMap(self, *args)


    def RowMatrixColMap(self, *args):
        """RowMatrixColMap(RowMatrix self) -> Map"""
        return _Epetra.RowMatrix_RowMatrixColMap(self, *args)


    def RowMatrixImporter(self, *args):
        """RowMatrixImporter(RowMatrix self) -> Import"""
        return _Epetra.RowMatrix_RowMatrixImporter(self, *args)


    def __init__(self, *args):
        """__init__(Epetra_RowMatrix self) -> RowMatrix"""
        if self.__class__ == RowMatrix:
            _self = None
        else:
            _self = self
        this = _Epetra.new_RowMatrix(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    def __disown__(self):
        self.this.disown()
        _Epetra.disown_RowMatrix(self)
        return weakref_proxy(self)
RowMatrix_swigregister = _Epetra.RowMatrix_swigregister
RowMatrix_swigregister(RowMatrix)

class BasicRowMatrix(CompObject, Object, RowMatrix):
    """Proxy of C++ Epetra_BasicRowMatrix class."""

    __swig_setmethods__ = {}
    for _s in [CompObject, Object, RowMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasicRowMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [CompObject, Object, RowMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasicRowMatrix, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Epetra_BasicRowMatrix self, Comm Comm) -> BasicRowMatrix"""
        if self.__class__ == BasicRowMatrix:
            _self = None
        else:
            _self = self
        this = _Epetra.new_BasicRowMatrix(_self, *args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_BasicRowMatrix

    def SetMaps(self, *args):
        """
        SetMaps(BasicRowMatrix self, Map RowMap, Map ColMap)
        SetMaps(BasicRowMatrix self, Map RowMap, Map ColMap, Map DomainMap, Map RangeMap)
        """
        return _Epetra.BasicRowMatrix_SetMaps(self, *args)


    def ExtractMyRowCopy(self, *args):
        """
        ExtractMyRowCopy(int myRow, int length, numpy.ndarray numEntries,
            numpy.ndarray values, numpy.ndarray indices) -> int

        In C++, numEntries in an int&.  In python, it is provided to you as a
        numpy array of length one so that you can set its value in-place using
        numEntries[0] = ....

        Arguments values and indices are double* and int*, respectively, in
        C++.  In python, these are provided to you as numpy arrays of the
        given length, so that you may alter their entries in-place.
        """
        return _Epetra.BasicRowMatrix_ExtractMyRowCopy(self, *args)


    def ExtractMyEntryView(self, *args):
        """ExtractMyEntryView(BasicRowMatrix self, int CurEntry, double *& Value, int & RowIndex, int & ColIndex) -> int"""
        return _Epetra.BasicRowMatrix_ExtractMyEntryView(self, *args)


    def NumMyRowEntries(self, *args):
        """
        NumMyRowEntries(int myRow, numpy.ndarray numEntries) -> int

        In C++, numEntries in an int&.  In python, it is provided to you as a
        numpy array of length one so that you can set its value in-place using
        numEntries[0] = ....
        """
        return _Epetra.BasicRowMatrix_NumMyRowEntries(self, *args)


    def Multiply(self, *args):
        """
        Multiply(bool useTranspose, MultiVector x, MultiVector y) -> int

        In C++, arguments x and y are Epetra_MultiVectors.  In python, they
        are provided to you as numpy-hybrid Epetra.MultiVectors, giving you
        access to the numpy interface in addition to the Epetra_MultiVector
        C++ interface.
        """
        return _Epetra.BasicRowMatrix_Multiply(self, *args)


    def Solve(self, *args):
        """
        Solve((bool upper, bool trans, bool unitDiagonal, MultiVector x,
            MultiVector y) -> int

        In C++, arguments x and y are Epetra_MultiVectors.  In python, they
        are provided to you as numpy-hybrid Epetra.MultiVectors, giving you
        access to the numpy interface in addition to the Epetra_MultiVector
        C++ interface.
        """
        return _Epetra.BasicRowMatrix_Solve(self, *args)


    def ExtractDiagonalCopy(self, *args):
        """
        ExtractDiagonalCopy(Vector diagonal) -> int

        Argument diagonal is provided to you as a numpy-hybrid Epetra.Vector,
        giving you access to the numpy interface in addition to the
        Epetra_Vector C++ interface.
        """
        return _Epetra.BasicRowMatrix_ExtractDiagonalCopy(self, *args)


    def InvRowSums(self, *args):
        """
        InvRowSums(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return _Epetra.BasicRowMatrix_InvRowSums(self, *args)


    def LeftScale(self, *args):
        """
        LeftScale(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return _Epetra.BasicRowMatrix_LeftScale(self, *args)


    def InvColSums(self, *args):
        """
        InvColSums(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return _Epetra.BasicRowMatrix_InvColSums(self, *args)


    def RightScale(self, *args):
        """
        RightScale(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return _Epetra.BasicRowMatrix_RightScale(self, *args)


    def Filled(self, *args):
        """Filled(BasicRowMatrix self) -> bool"""
        return _Epetra.BasicRowMatrix_Filled(self, *args)


    def LowerTriangular(self, *args):
        """LowerTriangular(BasicRowMatrix self) -> bool"""
        return _Epetra.BasicRowMatrix_LowerTriangular(self, *args)


    def UpperTriangular(self, *args):
        """UpperTriangular(BasicRowMatrix self) -> bool"""
        return _Epetra.BasicRowMatrix_UpperTriangular(self, *args)


    def NormInf(self, *args):
        """NormInf(BasicRowMatrix self) -> double"""
        return _Epetra.BasicRowMatrix_NormInf(self, *args)


    def NormOne(self, *args):
        """NormOne(BasicRowMatrix self) -> double"""
        return _Epetra.BasicRowMatrix_NormOne(self, *args)


    def NumGlobalNonzeros(self, *args):
        """NumGlobalNonzeros(BasicRowMatrix self) -> int"""
        return _Epetra.BasicRowMatrix_NumGlobalNonzeros(self, *args)


    def NumGlobalNonzeros64(self, *args):
        """NumGlobalNonzeros64(BasicRowMatrix self) -> long long"""
        return _Epetra.BasicRowMatrix_NumGlobalNonzeros64(self, *args)


    def NumGlobalRows(self, *args):
        """NumGlobalRows(BasicRowMatrix self) -> int"""
        return _Epetra.BasicRowMatrix_NumGlobalRows(self, *args)


    def NumGlobalRows64(self, *args):
        """NumGlobalRows64(BasicRowMatrix self) -> long long"""
        return _Epetra.BasicRowMatrix_NumGlobalRows64(self, *args)


    def NumGlobalCols(self, *args):
        """NumGlobalCols(BasicRowMatrix self) -> int"""
        return _Epetra.BasicRowMatrix_NumGlobalCols(self, *args)


    def NumGlobalCols64(self, *args):
        """NumGlobalCols64(BasicRowMatrix self) -> long long"""
        return _Epetra.BasicRowMatrix_NumGlobalCols64(self, *args)


    def NumGlobalDiagonals(self, *args):
        """NumGlobalDiagonals(BasicRowMatrix self) -> int"""
        return _Epetra.BasicRowMatrix_NumGlobalDiagonals(self, *args)


    def NumGlobalDiagonals64(self, *args):
        """NumGlobalDiagonals64(BasicRowMatrix self) -> long long"""
        return _Epetra.BasicRowMatrix_NumGlobalDiagonals64(self, *args)


    def NumMyNonzeros(self, *args):
        """NumMyNonzeros(BasicRowMatrix self) -> int"""
        return _Epetra.BasicRowMatrix_NumMyNonzeros(self, *args)


    def NumMyRows(self, *args):
        """NumMyRows(BasicRowMatrix self) -> int"""
        return _Epetra.BasicRowMatrix_NumMyRows(self, *args)


    def NumMyCols(self, *args):
        """NumMyCols(BasicRowMatrix self) -> int"""
        return _Epetra.BasicRowMatrix_NumMyCols(self, *args)


    def NumMyDiagonals(self, *args):
        """NumMyDiagonals(BasicRowMatrix self) -> int"""
        return _Epetra.BasicRowMatrix_NumMyDiagonals(self, *args)


    def MaxNumEntries(self, *args):
        """MaxNumEntries(BasicRowMatrix self) -> int"""
        return _Epetra.BasicRowMatrix_MaxNumEntries(self, *args)


    def OperatorDomainMap(self, *args):
        """OperatorDomainMap(BasicRowMatrix self) -> Map"""
        return _Epetra.BasicRowMatrix_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """OperatorRangeMap(BasicRowMatrix self) -> Map"""
        return _Epetra.BasicRowMatrix_OperatorRangeMap(self, *args)


    def Map(self, *args):
        """Map(BasicRowMatrix self) -> BlockMap"""
        return _Epetra.BasicRowMatrix_Map(self, *args)


    def RowMatrixRowMap(self, *args):
        """RowMatrixRowMap(BasicRowMatrix self) -> Map"""
        return _Epetra.BasicRowMatrix_RowMatrixRowMap(self, *args)


    def RowMatrixColMap(self, *args):
        """RowMatrixColMap(BasicRowMatrix self) -> Map"""
        return _Epetra.BasicRowMatrix_RowMatrixColMap(self, *args)


    def RowMatrixImporter(self, *args):
        """RowMatrixImporter(BasicRowMatrix self) -> Import"""
        return _Epetra.BasicRowMatrix_RowMatrixImporter(self, *args)


    def Comm(self, *args):
        """Comm(BasicRowMatrix self) -> Comm"""
        return _Epetra.BasicRowMatrix_Comm(self, *args)


    def SetUseTranspose(self, *args):
        """SetUseTranspose(BasicRowMatrix self, bool use_transpose) -> int"""
        return _Epetra.BasicRowMatrix_SetUseTranspose(self, *args)


    def Label(self, *args):
        """Label(BasicRowMatrix self) -> char const *"""
        return _Epetra.BasicRowMatrix_Label(self, *args)


    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        """
        return _Epetra.BasicRowMatrix_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.

        """
        return _Epetra.BasicRowMatrix_ApplyInverse(self, *args)


    def HasNormInf(self, *args):
        """HasNormInf(BasicRowMatrix self) -> bool"""
        return _Epetra.BasicRowMatrix_HasNormInf(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(BasicRowMatrix self) -> bool"""
        return _Epetra.BasicRowMatrix_UseTranspose(self, *args)


    def Importer(self, *args):
        """Importer(BasicRowMatrix self) -> Import"""
        return _Epetra.BasicRowMatrix_Importer(self, *args)


    def Exporter(self, *args):
        """Exporter(BasicRowMatrix self) -> Export"""
        return _Epetra.BasicRowMatrix_Exporter(self, *args)


    def ComputeStructureConstants(self, *args):
        """ComputeStructureConstants(BasicRowMatrix self)"""
        return _Epetra.BasicRowMatrix_ComputeStructureConstants(self, *args)


    def ComputeNumericConstants(self, *args):
        """ComputeNumericConstants(BasicRowMatrix self)"""
        return _Epetra.BasicRowMatrix_ComputeNumericConstants(self, *args)

    def __disown__(self):
        self.this.disown()
        _Epetra.disown_BasicRowMatrix(self)
        return weakref_proxy(self)
BasicRowMatrix_swigregister = _Epetra.BasicRowMatrix_swigregister
BasicRowMatrix_swigregister(BasicRowMatrix)

class CrsMatrix(DistObject, CompObject, BLAS, RowMatrix):
    """Proxy of C++ Epetra_CrsMatrix class."""

    __swig_setmethods__ = {}
    for _s in [DistObject, CompObject, BLAS, RowMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CrsMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [DistObject, CompObject, BLAS, RowMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CrsMatrix, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_CrsMatrix

    def PutScalar(self, *args):
        """PutScalar(CrsMatrix self, double ScalarConstant) -> int"""
        return _Epetra.CrsMatrix_PutScalar(self, *args)


    def Scale(self, *args):
        """Scale(CrsMatrix self, double ScalarConstant) -> int"""
        return _Epetra.CrsMatrix_Scale(self, *args)


    def ReplaceDiagonalValues(self, *args):
        """ReplaceDiagonalValues(CrsMatrix self, Vector Diagonal) -> int"""
        return _Epetra.CrsMatrix_ReplaceDiagonalValues(self, *args)


    def FillComplete(self, *args):
        """
        FillComplete(CrsMatrix self, bool OptimizeDataStorage=True) -> int
        FillComplete(CrsMatrix self, Map DomainMap, Map RangeMap, bool OptimizeDataStorage=True) -> int
        """
        return _Epetra.CrsMatrix_FillComplete(self, *args)


    def OptimizeStorage(self, *args):
        """OptimizeStorage(CrsMatrix self) -> int"""
        return _Epetra.CrsMatrix_OptimizeStorage(self, *args)


    def MakeDataContiguous(self, *args):
        """MakeDataContiguous(CrsMatrix self) -> int"""
        return _Epetra.CrsMatrix_MakeDataContiguous(self, *args)


    def ExtractDiagonalCopy(self, *args):
        """
        ExtractDiagonalCopy(Vector diagonal) -> int

        Argument diagonal is provided to you as a numpy-hybrid Epetra.Vector,
        giving you access to the numpy interface in addition to the
        Epetra_Vector C++ interface.
        """
        return _Epetra.CrsMatrix_ExtractDiagonalCopy(self, *args)


    def Multiply(self, *args):
        """
        Multiply(bool useTranspose, MultiVector x, MultiVector y) -> int

        In C++, arguments x and y are Epetra_MultiVectors.  In python, they
        are provided to you as numpy-hybrid Epetra.MultiVectors, giving you
        access to the numpy interface in addition to the Epetra_MultiVector
        C++ interface.
        """
        return _Epetra.CrsMatrix_Multiply(self, *args)


    def Multiply1(self, *args):
        """Multiply1(CrsMatrix self, bool TransA, MultiVector X, MultiVector Y) -> int"""
        return _Epetra.CrsMatrix_Multiply1(self, *args)


    def Solve(self, *args):
        """
        Solve((bool upper, bool trans, bool unitDiagonal, MultiVector x,
            MultiVector y) -> int

        In C++, arguments x and y are Epetra_MultiVectors.  In python, they
        are provided to you as numpy-hybrid Epetra.MultiVectors, giving you
        access to the numpy interface in addition to the Epetra_MultiVector
        C++ interface.
        """
        return _Epetra.CrsMatrix_Solve(self, *args)


    def InvRowSums(self, *args):
        """
        InvRowSums(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return _Epetra.CrsMatrix_InvRowSums(self, *args)


    def InvRowMaxs(self, *args):
        """InvRowMaxs(CrsMatrix self, Vector x) -> int"""
        return _Epetra.CrsMatrix_InvRowMaxs(self, *args)


    def LeftScale(self, *args):
        """
        LeftScale(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return _Epetra.CrsMatrix_LeftScale(self, *args)


    def InvColSums(self, *args):
        """
        InvColSums(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return _Epetra.CrsMatrix_InvColSums(self, *args)


    def InvColMaxs(self, *args):
        """InvColMaxs(CrsMatrix self, Vector x) -> int"""
        return _Epetra.CrsMatrix_InvColMaxs(self, *args)


    def RightScale(self, *args):
        """
        RightScale(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return _Epetra.CrsMatrix_RightScale(self, *args)


    def Filled(self, *args):
        """Filled(CrsMatrix self) -> bool"""
        return _Epetra.CrsMatrix_Filled(self, *args)


    def StorageOptimized(self, *args):
        """StorageOptimized(CrsMatrix self) -> bool"""
        return _Epetra.CrsMatrix_StorageOptimized(self, *args)


    def IndicesAreGlobal(self, *args):
        """IndicesAreGlobal(CrsMatrix self) -> bool"""
        return _Epetra.CrsMatrix_IndicesAreGlobal(self, *args)


    def IndicesAreLocal(self, *args):
        """IndicesAreLocal(CrsMatrix self) -> bool"""
        return _Epetra.CrsMatrix_IndicesAreLocal(self, *args)


    def IndicesAreContiguous(self, *args):
        """IndicesAreContiguous(CrsMatrix self) -> bool"""
        return _Epetra.CrsMatrix_IndicesAreContiguous(self, *args)


    def LowerTriangular(self, *args):
        """LowerTriangular(CrsMatrix self) -> bool"""
        return _Epetra.CrsMatrix_LowerTriangular(self, *args)


    def UpperTriangular(self, *args):
        """UpperTriangular(CrsMatrix self) -> bool"""
        return _Epetra.CrsMatrix_UpperTriangular(self, *args)


    def NoDiagonal(self, *args):
        """NoDiagonal(CrsMatrix self) -> bool"""
        return _Epetra.CrsMatrix_NoDiagonal(self, *args)


    def NormInf(self, *args):
        """NormInf(CrsMatrix self) -> double"""
        return _Epetra.CrsMatrix_NormInf(self, *args)


    def NormOne(self, *args):
        """NormOne(CrsMatrix self) -> double"""
        return _Epetra.CrsMatrix_NormOne(self, *args)


    def NormFrobenius(self, *args):
        """NormFrobenius(CrsMatrix self) -> double"""
        return _Epetra.CrsMatrix_NormFrobenius(self, *args)


    def NumGlobalNonzeros(self, *args):
        """NumGlobalNonzeros(CrsMatrix self) -> int"""
        return _Epetra.CrsMatrix_NumGlobalNonzeros(self, *args)


    def NumGlobalNonzeros64(self, *args):
        """NumGlobalNonzeros64(CrsMatrix self) -> long long"""
        return _Epetra.CrsMatrix_NumGlobalNonzeros64(self, *args)


    def NumGlobalRows(self, *args):
        """NumGlobalRows(CrsMatrix self) -> int"""
        return _Epetra.CrsMatrix_NumGlobalRows(self, *args)


    def NumGlobalRows64(self, *args):
        """NumGlobalRows64(CrsMatrix self) -> long long"""
        return _Epetra.CrsMatrix_NumGlobalRows64(self, *args)


    def NumGlobalCols(self, *args):
        """NumGlobalCols(CrsMatrix self) -> int"""
        return _Epetra.CrsMatrix_NumGlobalCols(self, *args)


    def NumGlobalCols64(self, *args):
        """NumGlobalCols64(CrsMatrix self) -> long long"""
        return _Epetra.CrsMatrix_NumGlobalCols64(self, *args)


    def NumGlobalDiagonals(self, *args):
        """NumGlobalDiagonals(CrsMatrix self) -> int"""
        return _Epetra.CrsMatrix_NumGlobalDiagonals(self, *args)


    def NumGlobalDiagonals64(self, *args):
        """NumGlobalDiagonals64(CrsMatrix self) -> long long"""
        return _Epetra.CrsMatrix_NumGlobalDiagonals64(self, *args)


    def NumMyNonzeros(self, *args):
        """NumMyNonzeros(CrsMatrix self) -> int"""
        return _Epetra.CrsMatrix_NumMyNonzeros(self, *args)


    def NumMyRows(self, *args):
        """NumMyRows(CrsMatrix self) -> int"""
        return _Epetra.CrsMatrix_NumMyRows(self, *args)


    def NumMyCols(self, *args):
        """NumMyCols(CrsMatrix self) -> int"""
        return _Epetra.CrsMatrix_NumMyCols(self, *args)


    def NumMyDiagonals(self, *args):
        """NumMyDiagonals(CrsMatrix self) -> int"""
        return _Epetra.CrsMatrix_NumMyDiagonals(self, *args)


    def NumGlobalEntries(self, *args):
        """NumGlobalEntries(CrsMatrix self, long long Row) -> int"""
        return _Epetra.CrsMatrix_NumGlobalEntries(self, *args)


    def NumAllocatedGlobalEntries(self, *args):
        """NumAllocatedGlobalEntries(CrsMatrix self, int Row) -> int"""
        return _Epetra.CrsMatrix_NumAllocatedGlobalEntries(self, *args)


    def MaxNumEntries(self, *args):
        """MaxNumEntries(CrsMatrix self) -> int"""
        return _Epetra.CrsMatrix_MaxNumEntries(self, *args)


    def GlobalMaxNumEntries(self, *args):
        """GlobalMaxNumEntries(CrsMatrix self) -> int"""
        return _Epetra.CrsMatrix_GlobalMaxNumEntries(self, *args)


    def NumMyEntries(self, *args):
        """NumMyEntries(CrsMatrix self, int Row) -> int"""
        return _Epetra.CrsMatrix_NumMyEntries(self, *args)


    def NumAllocatedMyEntries(self, *args):
        """NumAllocatedMyEntries(CrsMatrix self, int Row) -> int"""
        return _Epetra.CrsMatrix_NumAllocatedMyEntries(self, *args)


    def IndexBase(self, *args):
        """IndexBase(CrsMatrix self) -> int"""
        return _Epetra.CrsMatrix_IndexBase(self, *args)


    def IndexBase64(self, *args):
        """IndexBase64(CrsMatrix self) -> long long"""
        return _Epetra.CrsMatrix_IndexBase64(self, *args)


    def StaticGraph(self, *args):
        """StaticGraph(CrsMatrix self) -> bool"""
        return _Epetra.CrsMatrix_StaticGraph(self, *args)


    def Graph(self, *args):
        """Graph(CrsMatrix self) -> CrsGraph"""
        return _Epetra.CrsMatrix_Graph(self, *args)


    def RowMap(self, *args):
        """RowMap(CrsMatrix self) -> Map"""
        return _Epetra.CrsMatrix_RowMap(self, *args)


    def ReplaceRowMap(self, *args):
        """ReplaceRowMap(CrsMatrix self, BlockMap newmap) -> int"""
        return _Epetra.CrsMatrix_ReplaceRowMap(self, *args)


    def HaveColMap(self, *args):
        """HaveColMap(CrsMatrix self) -> bool"""
        return _Epetra.CrsMatrix_HaveColMap(self, *args)


    def ReplaceColMap(self, *args):
        """ReplaceColMap(CrsMatrix self, BlockMap newmap) -> int"""
        return _Epetra.CrsMatrix_ReplaceColMap(self, *args)


    def ReplaceDomainMapAndImporter(self, *args):
        """ReplaceDomainMapAndImporter(CrsMatrix self, Map NewDomainMap, Import NewImporter) -> int"""
        return _Epetra.CrsMatrix_ReplaceDomainMapAndImporter(self, *args)


    def RemoveEmptyProcessesInPlace(self, *args):
        """RemoveEmptyProcessesInPlace(CrsMatrix self, BlockMap NewMap) -> int"""
        return _Epetra.CrsMatrix_RemoveEmptyProcessesInPlace(self, *args)


    def ColMap(self, *args):
        """ColMap(CrsMatrix self) -> Map"""
        return _Epetra.CrsMatrix_ColMap(self, *args)


    def DomainMap(self, *args):
        """DomainMap(CrsMatrix self) -> Map"""
        return _Epetra.CrsMatrix_DomainMap(self, *args)


    def RangeMap(self, *args):
        """RangeMap(CrsMatrix self) -> Map"""
        return _Epetra.CrsMatrix_RangeMap(self, *args)


    def Importer(self, *args):
        """Importer(CrsMatrix self) -> Import"""
        return _Epetra.CrsMatrix_Importer(self, *args)


    def Exporter(self, *args):
        """Exporter(CrsMatrix self) -> Export"""
        return _Epetra.CrsMatrix_Exporter(self, *args)


    def Comm(self, *args):
        """Comm(CrsMatrix self) -> Comm"""
        return _Epetra.CrsMatrix_Comm(self, *args)


    def LRID(self, *args):
        """
        LRID(CrsMatrix self, int GRID_in) -> int
        LRID(CrsMatrix self, long long GRID_in) -> int
        """
        return _Epetra.CrsMatrix_LRID(self, *args)


    def GRID(self, *args):
        """GRID(CrsMatrix self, int LRID_in) -> int"""
        return _Epetra.CrsMatrix_GRID(self, *args)


    def GRID64(self, *args):
        """GRID64(CrsMatrix self, int LRID_in) -> long long"""
        return _Epetra.CrsMatrix_GRID64(self, *args)


    def LCID(self, *args):
        """
        LCID(CrsMatrix self, int GCID_in) -> int
        LCID(CrsMatrix self, long long GCID_in) -> int
        """
        return _Epetra.CrsMatrix_LCID(self, *args)


    def GCID(self, *args):
        """GCID(CrsMatrix self, int LCID_in) -> int"""
        return _Epetra.CrsMatrix_GCID(self, *args)


    def GCID64(self, *args):
        """GCID64(CrsMatrix self, int LCID_in) -> long long"""
        return _Epetra.CrsMatrix_GCID64(self, *args)


    def MyGRID(self, *args):
        """
        MyGRID(CrsMatrix self, int GRID_in) -> bool
        MyGRID(CrsMatrix self, long long GRID_in) -> bool
        """
        return _Epetra.CrsMatrix_MyGRID(self, *args)


    def MyLRID(self, *args):
        """MyLRID(CrsMatrix self, int LRID_in) -> bool"""
        return _Epetra.CrsMatrix_MyLRID(self, *args)


    def MyGCID(self, *args):
        """
        MyGCID(CrsMatrix self, int GCID_in) -> bool
        MyGCID(CrsMatrix self, long long GCID_in) -> bool
        """
        return _Epetra.CrsMatrix_MyGCID(self, *args)


    def MyLCID(self, *args):
        """MyLCID(CrsMatrix self, int LCID_in) -> bool"""
        return _Epetra.CrsMatrix_MyLCID(self, *args)


    def MyGlobalRow(self, *args):
        """
        MyGlobalRow(CrsMatrix self, int GID) -> bool
        MyGlobalRow(CrsMatrix self, long long GID) -> bool
        """
        return _Epetra.CrsMatrix_MyGlobalRow(self, *args)


    def Label(self, *args):
        """Label(CrsMatrix self) -> char const *"""
        return _Epetra.CrsMatrix_Label(self, *args)


    def SetUseTranspose(self, *args):
        """SetUseTranspose(CrsMatrix self, bool UseTranspose_in) -> int"""
        return _Epetra.CrsMatrix_SetUseTranspose(self, *args)


    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        """
        return _Epetra.CrsMatrix_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.

        """
        return _Epetra.CrsMatrix_ApplyInverse(self, *args)


    def HasNormInf(self, *args):
        """HasNormInf(CrsMatrix self) -> bool"""
        return _Epetra.CrsMatrix_HasNormInf(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(CrsMatrix self) -> bool"""
        return _Epetra.CrsMatrix_UseTranspose(self, *args)


    def OperatorDomainMap(self, *args):
        """OperatorDomainMap(CrsMatrix self) -> Map"""
        return _Epetra.CrsMatrix_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """OperatorRangeMap(CrsMatrix self) -> Map"""
        return _Epetra.CrsMatrix_OperatorRangeMap(self, *args)


    def NumMyRowEntries(self, *args):
        """
        NumMyRowEntries(int myRow, numpy.ndarray numEntries) -> int

        In C++, numEntries in an int&.  In python, it is provided to you as a
        numpy array of length one so that you can set its value in-place using
        numEntries[0] = ....
        """
        return _Epetra.CrsMatrix_NumMyRowEntries(self, *args)


    def Map(self, *args):
        """Map(CrsMatrix self) -> BlockMap"""
        return _Epetra.CrsMatrix_Map(self, *args)


    def RowMatrixRowMap(self, *args):
        """RowMatrixRowMap(CrsMatrix self) -> Map"""
        return _Epetra.CrsMatrix_RowMatrixRowMap(self, *args)


    def RowMatrixColMap(self, *args):
        """RowMatrixColMap(CrsMatrix self) -> Map"""
        return _Epetra.CrsMatrix_RowMatrixColMap(self, *args)


    def RowMatrixImporter(self, *args):
        """RowMatrixImporter(CrsMatrix self) -> Import"""
        return _Epetra.CrsMatrix_RowMatrixImporter(self, *args)


    def ExpertExtractIndexOffset(self, *args):
        """ExpertExtractIndexOffset(CrsMatrix self) -> IntSerialDenseVector"""
        return _Epetra.CrsMatrix_ExpertExtractIndexOffset(self, *args)


    def ExpertExtractIndices(self, *args):
        """ExpertExtractIndices(CrsMatrix self) -> IntSerialDenseVector"""
        return _Epetra.CrsMatrix_ExpertExtractIndices(self, *args)


    def ExpertExtractValues(self, *args):
        """ExpertExtractValues(CrsMatrix self) -> double *&"""
        return _Epetra.CrsMatrix_ExpertExtractValues(self, *args)


    def ExpertStaticFillComplete(self, *args):
        """ExpertStaticFillComplete(CrsMatrix self, Map DomainMap, Map RangeMap, Import Importer=None, Export Exporter=None, int NumMyDiagonals=-1) -> int"""
        return _Epetra.CrsMatrix_ExpertStaticFillComplete(self, *args)


    def ExpertMakeUniqueCrsGraphData(self, *args):
        """ExpertMakeUniqueCrsGraphData(CrsMatrix self) -> int"""
        return _Epetra.CrsMatrix_ExpertMakeUniqueCrsGraphData(self, *args)


    def SortGhostsAssociatedWithEachProcessor(self, *args):
        """SortGhostsAssociatedWithEachProcessor(CrsMatrix self, bool Flag) -> int"""
        return _Epetra.CrsMatrix_SortGhostsAssociatedWithEachProcessor(self, *args)


    def ImportMap(self, *args):
        """ImportMap(CrsMatrix self) -> Map"""
        return _Epetra.CrsMatrix_ImportMap(self, *args)


    def TransformToLocal(self, *args):
        """
        TransformToLocal(CrsMatrix self) -> int
        TransformToLocal(CrsMatrix self, Map DomainMap, Map RangeMap) -> int
        """
        return _Epetra.CrsMatrix_TransformToLocal(self, *args)


    def FusedImport(self, *args):
        """FusedImport(CrsMatrix self, CrsMatrix SourceMatrix, Import RowImporter, Map DomainMap, Map RangeMap, bool RestrictCommunicator)"""
        return _Epetra.CrsMatrix_FusedImport(self, *args)


    def FusedExport(self, *args):
        """FusedExport(CrsMatrix self, CrsMatrix SourceMatrix, Export RowExporter, Map DomainMap, Map RangeMap, bool RestrictCommunicator)"""
        return _Epetra.CrsMatrix_FusedExport(self, *args)


    def InsertGlobalValues(self, *args):
        """
        InsertGlobalValues(self, int globalRow, PySequence values, PySequence
            indices) -> int

          Arguments:

            globalRow - global row index
            values    - a sequence of doubles that represent the values to insert
            indices   - a sequence of integers that represent the indices to insert

        InsertGlobalValues(self, PySequence rows, PySequence cols, PySequence
            values) -> int

          Arguments:

            rows    - a sequence of integers that represent the row indices to insert
            cols    - a sequence of integers that represent the column indices to
                      insert
            values  - a sequence of doubles that represent the values to insert

        """
        return _Epetra.CrsMatrix_InsertGlobalValues(self, *args)


    def ReplaceGlobalValues(self, *args):
        """
        ReplaceGlobalValues(self, int globalRow, PySequence values, PySequence
            indices) -> int

          Arguments:

            globalRow - global row index
            values    - a sequence of doubles that represent the values to replace
            indices   - a sequence of integers that represent the indices to replace

        ReplaceGlobalValues(self, PySequence rows, PySequence cols, PySequence
            values) -> int

          Arguments:

            rows    - a sequence of integers that represent the row indices to replace
            cols    - a sequence of integers that represent the column indices to
                      replace
            values  - a sequence of doubles that represent the values to replace

        """
        return _Epetra.CrsMatrix_ReplaceGlobalValues(self, *args)


    def SumIntoGlobalValues(self, *args):
        """
        SumIntoGlobalValues(self, int globalRow, PySequence values, PySequence
            indices) -> int

          Arguments:

            globalRow - global row index
            values    - a sequence of doubles that represent the values to sum into
            indices   - a sequence of integers that represent the indices to sum into

        SumIntoGlobalValues(self, PySequence rows, PySequence cols, PySequence
            values) -> int

          Arguments:

            rows    - a sequence of integers that represent the row indices to sum into
            cols    - a sequence of integers that represent the column indices to
                      sum into
            values  - a sequence of doubles that represent the values to sum into

        """
        return _Epetra.CrsMatrix_SumIntoGlobalValues(self, *args)


    def InsertMyValues(self, *args):
        """
        InsertMyValues(CrsMatrix self, int MyRow, int NumEntries, double const * Values, int const * Indices) -> int
        InsertMyValues(self, int myRow, PySequence values, PySequence indices) -> int

          Arguments:

            myRow     - local row index
            values    - a sequence of doubles that represent the values to insert
            indices   - a sequence of integers that represent the indices to insert

        InsertMyValues(self, PySequence rows, PySequence cols, PySequence
            values) -> int

          Arguments:

            rows    - a sequence of integers that represent the row indices to insert
            cols    - a sequence of integers that represent the column indices to
                      insert
            values  - a sequence of doubles that represent the values to insert

        """
        return _Epetra.CrsMatrix_InsertMyValues(self, *args)


    def ReplaceMyValues(self, *args):
        """
        ReplaceMyValues(CrsMatrix self, int MyRow, int NumEntries, double const * Values, int const * Indices) -> int
        ReplaceMyValues(self, int myRow, PySequence values, PySequence indices) -> int

          Arguments:

            myRow     - local row index
            values    - a sequence of doubles that represent the values to replace
            indices   - a sequence of integers that represent the indices to replace

        ReplaceMyValues(self, PySequence rows, PySequence cols, PySequence
            values) -> int

          Arguments:

            rows    - a sequence of integers that represent the row indices to replace
            cols    - a sequence of integers that represent the column indices to
                      replace
            values  - a sequence of doubles that represent the values to replace

        """
        return _Epetra.CrsMatrix_ReplaceMyValues(self, *args)


    def SumIntoMyValues(self, *args):
        """
        SumIntoMyValues(CrsMatrix self, int MyRow, int NumEntries, double const * Values, int const * Indices) -> int
        SumIntoMyValues(self, int myRow, PySequence values, PySequence indices) -> int

          Arguments:

            myRow     - local row index
            values    - a sequence of doubles that represent the values to sum into
            indices   - a sequence of integers that represent the indices to sum into

        SumIntoMyValues(CrsMatrix self, PyObject * Rows, PyObject * Cols, PyObject * Values) -> int
        """
        return _Epetra.CrsMatrix_SumIntoMyValues(self, *args)


    def __init__(self, *args):
        """
        __init__(self, Epetra_DataAccess CV, Map rowMap, int numEntriesPerRow, 
            bool staticProfile=False) -> CrsMatrix

          CrsMatrix constructor with implicit column map and constant number
          of entries per row.  Arguments:

            CV                - Epetra.Copy or Epetra.View
            rowMap            - describes distribution of rows across processors
            numEntriesPerRow  - constant number of entries per row
            staticProfile     - static profile flag

        __init__(self, Epetra_DataAccess CV, Map rowMap, Map colMap, int numEntriesPerRow, 
            bool staticProfile=False) -> CrsMatrix

          CrsMatrix constructor with specified column map and constant number
          of entries per row.  Arguments:

            CV                - Epetra.Copy or Epetra.View
            rowMap            - describes distribution of rows across processors
            colMap            - describes distribution of columns across processors
            numEntriesPerRow  - constant number of entries per row
            staticProfile     - static profile flag

        __init__(self, Epetra_DataAccess CV, CrsGraph graph) -> CrsMatrix

          CrsMatrix constructor with CrsGraph.  Arguments:

            CV     - Epetra.Copy or Epetra.View
            graph  - CrsGraph describing structure of matrix

        __init__(Epetra_CrsMatrix self, CrsMatrix SourceMatrix, Import RowImporter, Map DomainMap=None, Map RangeMap=None, bool RestrictCommunicator=False) -> CrsMatrix
        __init__(Epetra_CrsMatrix self, CrsMatrix SourceMatrix, Export RowExporter, Map DomainMap=None, Map RangeMap=None, bool RestrictCommunicator=False) -> CrsMatrix
        __init__(self, CrsMatrix matrix) -> CrsMatrix

          CrsMatrix copy constructor.  Argument:

            matrix  - source CrsMatrix

        __init__(self, Epetra_DataAccess CV, Map rowMap, PySequence numEntriesPerRow, 
            bool staticProfile=False) -> CrsMatrix

          CrsMatrix constructor with implicit column map and variable number
          of entries per row.  Arguments:

            CV                - Epetra.Copy or Epetra.View
            rowMap            - describes distribution of rows across processors
            numEntriesPerRow  - variable number of entries per row
            staticProfile     - static profile flag

        __init__(self, Epetra_DataAccess CV, Map rowMap, Map colMap, PySequence
            numEntriesPerRow, bool staticProfile=False) -> CrsMatrix

          CrsMatrix constructor with specified column map and variable number
          of entries per row.  Arguments:

            CV                - Epetra.Copy or Epetra.View
            rowMap            - describes distribution of rows across processors
            colMap            - describes distribution of columns across processors
            numEntriesPerRow  - variable number of entries per row
            staticProfile     - static profile flag

        """
        this = _Epetra.new_CrsMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def ExtractGlobalRowCopy(self, *args):
        """
        ExtractGlobalRowCopy(self, int globalRow) -> (numpy.ndarray,numpy.ndarray)

          Returns a two-tuple of numpy arrays of the same size; the first is
          an array of integers that represent the nonzero columns on the
          matrix; the second is an array of doubles that represent the values
          of the matrix entries.  The input argument is a global row index.
        """
        return _Epetra.CrsMatrix_ExtractGlobalRowCopy(self, *args)


    def ExtractMyRowCopy(self, *args):
        """
        ExtractMyRowCopy(self, int myRow) -> (numpy.ndarray,numpy.ndarray)

          Returns a two-tuple of numpy arrays of the same size; the first is
          an array of integers that represent the nonzero columns on the
          matrix; the second is an array of doubles that represent the values
          of the matrix entries.  The input argument is a local row index.
        """
        return _Epetra.CrsMatrix_ExtractMyRowCopy(self, *args)


    def __setitem__(self, *args):
        """
        __setitem__(self, PyTuple index, double val)

        The __setitem__() method is called when square-bracket indexing is
        used to set a value of the matrix.  For example, the last line of::

            comm = Epetra.SerialComm()
            m = Epetra.CrsMatrix(9,0,comm)
            m[0,0] = 3.14

        calls::

            m.__setitem__((0,0), 3.14)

        Thus, argument 'index' is a tuple filled with whatever indices you
        give the square-bracket operator when setting.  For __setitem__(),
        this raises an IndexError unless 'index' is a two-tuple of integers.
        Argument 'val' must be convertible to a double.  Under the covers,
        __setitem__() calls ReplaceGlobalValues() or InsertGlobalValues() as
        necessary, so the indices are expected to be global IDs.  Note that if
        you use __setitem__() to insert a new matrix element, you will need to
        call FillComplete() again, whether or not you have called it before.

        """
        return _Epetra.CrsMatrix___setitem__(self, *args)


    def __getitem__(self, *args):
        """

        __getitem__(self, PyTuple index) -> double
        __getitem__(self, int row) -> numpy.ndarray

        The __getitem__() method is called when square-bracket indexing is
        used to get a value from the matrix.  For example, the last two lines
        of::

            comm = Epetra.SerialComm()
            m = Epetra.CrsMatrix(9,0,comm)
            m.InsertGlobalValues(0, [0.0, 1.0, 2.0], [0,1,2])
            diag = m[0,0]
            row  = m[0]

        call::

            m.__getitem__((0,0))
            m.__getitem__(0)

        The __getitem__() method behaves according to the following table:

                            FillComplete()    #    
            Index               called      procs  Return value
            --------------  --------------  -----  ---------------------------
            single integer       true        any   numpy array of doubles
            single integer       false        1    numpy array of doubles
            single integer       false       >1    raise IndexError
            two integers         either      any   double

        You should provide global IDs as the integer indices if FillComplete()
        has been called.  If not, you should provide local IDs.  If you
        reference a matrix element that is off-processor, __getitem__() will
        raise an IndexError.

        Under the covers, __getitem__() will call ExtractGlobalRowView() if
        FillComplete() has been called, or ExtractMyRowView() if it has not.
        If either of these return a non-zero return code, this is converted to
        a python RuntimeError.  The resulting data is copied to the output
        array.

        """
        return _Epetra.CrsMatrix___getitem__(self, *args)

CrsMatrix_swigregister = _Epetra.CrsMatrix_swigregister
CrsMatrix_swigregister(CrsMatrix)

class FECrsMatrix(CrsMatrix):
    """Proxy of C++ Epetra_FECrsMatrix class."""

    __swig_setmethods__ = {}
    for _s in [CrsMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FECrsMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [CrsMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FECrsMatrix, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_FECrsMatrix self, Epetra_DataAccess CV, Map RowMap, int * NumEntriesPerRow, bool ignoreNonLocalEntries=False) -> FECrsMatrix
        __init__(Epetra_FECrsMatrix self, Epetra_DataAccess CV, Map RowMap, int NumEntriesPerRow, bool ignoreNonLocalEntries=False) -> FECrsMatrix
        __init__(Epetra_FECrsMatrix self, Epetra_DataAccess CV, Map RowMap, Map ColMap, int * NumEntriesPerRow, bool ignoreNonLocalEntries=False) -> FECrsMatrix
        __init__(Epetra_FECrsMatrix self, Epetra_DataAccess CV, Map RowMap, Map ColMap, int NumEntriesPerRow, bool ignoreNonLocalEntries=False) -> FECrsMatrix
        __init__(Epetra_FECrsMatrix self, Epetra_DataAccess CV, CrsGraph Graph, bool ignoreNonLocalEntries=False) -> FECrsMatrix
        __init__(Epetra_FECrsMatrix self, Epetra_DataAccess CV, Epetra_FECrsGraph const & Graph, bool ignoreNonLocalEntries=False) -> FECrsMatrix
        __init__(Epetra_FECrsMatrix self, FECrsMatrix src) -> FECrsMatrix
        """
        this = _Epetra.new_FECrsMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_FECrsMatrix
    ROW_MAJOR = _Epetra.FECrsMatrix_ROW_MAJOR
    COLUMN_MAJOR = _Epetra.FECrsMatrix_COLUMN_MAJOR

    def GlobalAssemble(self, *args):
        """
        GlobalAssemble(FECrsMatrix self, bool callFillComplete=True, Epetra_CombineMode combineMode=Add, bool save_off_and_reuse_map_exporter=False) -> int
        GlobalAssemble(FECrsMatrix self, Map domain_map, Map range_map, bool callFillComplete=True, Epetra_CombineMode combineMode=Add, bool save_off_and_reuse_map_exporter=False) -> int
        """
        return _Epetra.FECrsMatrix_GlobalAssemble(self, *args)


    def setIgnoreNonLocalEntries(self, *args):
        """setIgnoreNonLocalEntries(FECrsMatrix self, bool flag)"""
        return _Epetra.FECrsMatrix_setIgnoreNonLocalEntries(self, *args)


    def __setitem__(self, *args):
        """__setitem__(FECrsMatrix self, PyObject * args, double val)"""
        return _Epetra.FECrsMatrix___setitem__(self, *args)


    def __getitem__(self, *args):
        """__getitem__(FECrsMatrix self, PyObject * args) -> PyObject *"""
        return _Epetra.FECrsMatrix___getitem__(self, *args)


    def InsertGlobalValues(self, *args):
        """
        InsertGlobalValues(FECrsMatrix self, int const row, int const size, SerialDenseVector values, IntSerialDenseVector entries) -> int
        InsertGlobalValues(FECrsMatrix self, IntSerialDenseVector rows, IntSerialDenseVector cols, SerialDenseMatrix values, int format) -> int
        """
        return _Epetra.FECrsMatrix_InsertGlobalValues(self, *args)


    def InsertGlobalValue(self, *args):
        """InsertGlobalValue(FECrsMatrix self, int i, int j, double val) -> int"""
        return _Epetra.FECrsMatrix_InsertGlobalValue(self, *args)

FECrsMatrix_swigregister = _Epetra.FECrsMatrix_swigregister
FECrsMatrix_swigregister(FECrsMatrix)

class CrsSingletonFilter(_object):
    """Proxy of C++ Epetra_CrsSingletonFilter class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CrsSingletonFilter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CrsSingletonFilter, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Epetra_CrsSingletonFilter self) -> CrsSingletonFilter"""
        this = _Epetra.new_CrsSingletonFilter(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_CrsSingletonFilter

    def Analyze(self, *args):
        """Analyze(CrsSingletonFilter self, RowMatrix FullMatrix) -> int"""
        return _Epetra.CrsSingletonFilter_Analyze(self, *args)


    def SingletonsDetected(self, *args):
        """SingletonsDetected(CrsSingletonFilter self) -> bool"""
        return _Epetra.CrsSingletonFilter_SingletonsDetected(self, *args)


    def ConstructReducedProblem(self, *args):
        """ConstructReducedProblem(CrsSingletonFilter self, Epetra_LinearProblem Problem) -> int"""
        return _Epetra.CrsSingletonFilter_ConstructReducedProblem(self, *args)


    def UpdateReducedProblem(self, *args):
        """UpdateReducedProblem(CrsSingletonFilter self, Epetra_LinearProblem Problem) -> int"""
        return _Epetra.CrsSingletonFilter_UpdateReducedProblem(self, *args)


    def ComputeFullSolution(self, *args):
        """ComputeFullSolution(CrsSingletonFilter self) -> int"""
        return _Epetra.CrsSingletonFilter_ComputeFullSolution(self, *args)


    def NumRowSingletons(self, *args):
        """NumRowSingletons(CrsSingletonFilter self) -> int"""
        return _Epetra.CrsSingletonFilter_NumRowSingletons(self, *args)


    def NumColSingletons(self, *args):
        """NumColSingletons(CrsSingletonFilter self) -> int"""
        return _Epetra.CrsSingletonFilter_NumColSingletons(self, *args)


    def NumSingletons(self, *args):
        """NumSingletons(CrsSingletonFilter self) -> int"""
        return _Epetra.CrsSingletonFilter_NumSingletons(self, *args)


    def RatioOfDimensions(self, *args):
        """RatioOfDimensions(CrsSingletonFilter self) -> double"""
        return _Epetra.CrsSingletonFilter_RatioOfDimensions(self, *args)


    def RatioOfNonzeros(self, *args):
        """RatioOfNonzeros(CrsSingletonFilter self) -> double"""
        return _Epetra.CrsSingletonFilter_RatioOfNonzeros(self, *args)


    def FullProblem(self, *args):
        """FullProblem(CrsSingletonFilter self) -> Epetra_LinearProblem"""
        return _Epetra.CrsSingletonFilter_FullProblem(self, *args)


    def ReducedProblem(self, *args):
        """ReducedProblem(CrsSingletonFilter self) -> Epetra_LinearProblem"""
        return _Epetra.CrsSingletonFilter_ReducedProblem(self, *args)


    def FullMatrix(self, *args):
        """FullMatrix(CrsSingletonFilter self) -> RowMatrix"""
        return _Epetra.CrsSingletonFilter_FullMatrix(self, *args)


    def ReducedMatrix(self, *args):
        """ReducedMatrix(CrsSingletonFilter self) -> CrsMatrix"""
        return _Epetra.CrsSingletonFilter_ReducedMatrix(self, *args)


    def RowMapColors(self, *args):
        """RowMapColors(CrsSingletonFilter self) -> MapColoring"""
        return _Epetra.CrsSingletonFilter_RowMapColors(self, *args)


    def ColMapColors(self, *args):
        """ColMapColors(CrsSingletonFilter self) -> MapColoring"""
        return _Epetra.CrsSingletonFilter_ColMapColors(self, *args)


    def ReducedMatrixRowMap(self, *args):
        """ReducedMatrixRowMap(CrsSingletonFilter self) -> Map"""
        return _Epetra.CrsSingletonFilter_ReducedMatrixRowMap(self, *args)


    def ReducedMatrixColMap(self, *args):
        """ReducedMatrixColMap(CrsSingletonFilter self) -> Map"""
        return _Epetra.CrsSingletonFilter_ReducedMatrixColMap(self, *args)


    def ReducedMatrixDomainMap(self, *args):
        """ReducedMatrixDomainMap(CrsSingletonFilter self) -> Map"""
        return _Epetra.CrsSingletonFilter_ReducedMatrixDomainMap(self, *args)


    def ReducedMatrixRangeMap(self, *args):
        """ReducedMatrixRangeMap(CrsSingletonFilter self) -> Map"""
        return _Epetra.CrsSingletonFilter_ReducedMatrixRangeMap(self, *args)

CrsSingletonFilter_swigregister = _Epetra.CrsSingletonFilter_swigregister
CrsSingletonFilter_swigregister(CrsSingletonFilter)

class VbrMatrix(DistObject, CompObject, BLAS, RowMatrix):
    """Proxy of C++ Epetra_VbrMatrix class."""

    __swig_setmethods__ = {}
    for _s in [DistObject, CompObject, BLAS, RowMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, VbrMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [DistObject, CompObject, BLAS, RowMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, VbrMatrix, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Epetra.delete_VbrMatrix

    def PutScalar(self, *args):
        """PutScalar(VbrMatrix self, double ScalarConstant) -> int"""
        return _Epetra.VbrMatrix_PutScalar(self, *args)


    def Scale(self, *args):
        """Scale(VbrMatrix self, double ScalarConstant) -> int"""
        return _Epetra.VbrMatrix_Scale(self, *args)


    def DirectSubmitBlockEntry(self, *args):
        """DirectSubmitBlockEntry(VbrMatrix self, int GlobalBlockRow, int GlobalBlockCol, double const * values, int LDA, int NumRows, int NumCols, bool sum_into) -> int"""
        return _Epetra.VbrMatrix_DirectSubmitBlockEntry(self, *args)


    def BeginInsertGlobalValues(self, *args):
        """BeginInsertGlobalValues(VbrMatrix self, int BlockRow, int NumBlockEntries) -> int"""
        return _Epetra.VbrMatrix_BeginInsertGlobalValues(self, *args)


    def BeginInsertMyValues(self, *args):
        """BeginInsertMyValues(VbrMatrix self, int BlockRow, int NumBlockEntries) -> int"""
        return _Epetra.VbrMatrix_BeginInsertMyValues(self, *args)


    def BeginReplaceGlobalValues(self, *args):
        """BeginReplaceGlobalValues(VbrMatrix self, int BlockRow, int NumBlockEntries) -> int"""
        return _Epetra.VbrMatrix_BeginReplaceGlobalValues(self, *args)


    def BeginReplaceMyValues(self, *args):
        """BeginReplaceMyValues(VbrMatrix self, int BlockRow, int NumBlockEntries) -> int"""
        return _Epetra.VbrMatrix_BeginReplaceMyValues(self, *args)


    def BeginSumIntoGlobalValues(self, *args):
        """BeginSumIntoGlobalValues(VbrMatrix self, int BlockRow, int NumBlockEntries) -> int"""
        return _Epetra.VbrMatrix_BeginSumIntoGlobalValues(self, *args)


    def BeginSumIntoMyValues(self, *args):
        """BeginSumIntoMyValues(VbrMatrix self, int BlockRow, int NumBlockEntries) -> int"""
        return _Epetra.VbrMatrix_BeginSumIntoMyValues(self, *args)


    def SubmitBlockEntry(self, *args):
        """
        SubmitBlockEntry(VbrMatrix self, double * Values, int LDA, int NumRows, int NumCols) -> int
        SubmitBlockEntry(VbrMatrix self, SerialDenseMatrix Mat) -> int
        """
        return _Epetra.VbrMatrix_SubmitBlockEntry(self, *args)


    def EndSubmitEntries(self, *args):
        """EndSubmitEntries(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_EndSubmitEntries(self, *args)


    def ReplaceDiagonalValues(self, *args):
        """ReplaceDiagonalValues(VbrMatrix self, Vector Diagonal) -> int"""
        return _Epetra.VbrMatrix_ReplaceDiagonalValues(self, *args)


    def FillComplete(self, *args):
        """
        FillComplete(VbrMatrix self) -> int
        FillComplete(VbrMatrix self, BlockMap DomainMap, BlockMap RangeMap) -> int
        """
        return _Epetra.VbrMatrix_FillComplete(self, *args)


    def Filled(self, *args):
        """Filled(VbrMatrix self) -> bool"""
        return _Epetra.VbrMatrix_Filled(self, *args)


    def ExtractGlobalBlockRowPointers(self, *args):
        """ExtractGlobalBlockRowPointers(VbrMatrix self, int BlockRow, int MaxNumBlockEntries, int & RowDim, int & NumBlockEntries, int * BlockIndices, Epetra_SerialDenseMatrix **& Values) -> int"""
        return _Epetra.VbrMatrix_ExtractGlobalBlockRowPointers(self, *args)


    def ExtractMyBlockRowPointers(self, *args):
        """ExtractMyBlockRowPointers(VbrMatrix self, int BlockRow, int MaxNumBlockEntries, int & RowDim, int & NumBlockEntries, int * BlockIndices, Epetra_SerialDenseMatrix **& Values) -> int"""
        return _Epetra.VbrMatrix_ExtractMyBlockRowPointers(self, *args)


    def BeginExtractGlobalBlockRowCopy(self, *args):
        """BeginExtractGlobalBlockRowCopy(VbrMatrix self, int BlockRow, int MaxNumBlockEntries, int & RowDim, int & NumBlockEntries, int * BlockIndices, int * ColDims) -> int"""
        return _Epetra.VbrMatrix_BeginExtractGlobalBlockRowCopy(self, *args)


    def BeginExtractMyBlockRowCopy(self, *args):
        """BeginExtractMyBlockRowCopy(VbrMatrix self, int BlockRow, int MaxNumBlockEntries, int & RowDim, int & NumBlockEntries, int * BlockIndices, int * ColDims) -> int"""
        return _Epetra.VbrMatrix_BeginExtractMyBlockRowCopy(self, *args)


    def ExtractEntryCopy(self, *args):
        """ExtractEntryCopy(VbrMatrix self, int SizeOfValues, double * Values, int LDA, bool SumInto) -> int"""
        return _Epetra.VbrMatrix_ExtractEntryCopy(self, *args)


    def BeginExtractGlobalBlockRowView(self, *args):
        """BeginExtractGlobalBlockRowView(VbrMatrix self, int BlockRow, int & RowDim, int & NumBlockEntries, int *& BlockIndices) -> int"""
        return _Epetra.VbrMatrix_BeginExtractGlobalBlockRowView(self, *args)


    def BeginExtractMyBlockRowView(self, *args):
        """BeginExtractMyBlockRowView(VbrMatrix self, int BlockRow, int & RowDim, int & NumBlockEntries, int *& BlockIndices) -> int"""
        return _Epetra.VbrMatrix_BeginExtractMyBlockRowView(self, *args)


    def ExtractEntryView(self, *args):
        """ExtractEntryView(VbrMatrix self, Epetra_SerialDenseMatrix *& entry) -> int"""
        return _Epetra.VbrMatrix_ExtractEntryView(self, *args)


    def ExtractGlobalBlockRowView(self, *args):
        """ExtractGlobalBlockRowView(VbrMatrix self, int BlockRow, int & RowDim, int & NumBlockEntries, int *& BlockIndices, Epetra_SerialDenseMatrix **& Values) -> int"""
        return _Epetra.VbrMatrix_ExtractGlobalBlockRowView(self, *args)


    def ExtractMyBlockRowView(self, *args):
        """ExtractMyBlockRowView(VbrMatrix self, int BlockRow, int & RowDim, int & NumBlockEntries, int *& BlockIndices, Epetra_SerialDenseMatrix **& Values) -> int"""
        return _Epetra.VbrMatrix_ExtractMyBlockRowView(self, *args)


    def ExtractDiagonalCopy(self, *args):
        """
        ExtractDiagonalCopy(Vector diagonal) -> int

        Argument diagonal is provided to you as a numpy-hybrid Epetra.Vector,
        giving you access to the numpy interface in addition to the
        Epetra_Vector C++ interface.
        """
        return _Epetra.VbrMatrix_ExtractDiagonalCopy(self, *args)


    def BeginExtractBlockDiagonalCopy(self, *args):
        """BeginExtractBlockDiagonalCopy(VbrMatrix self, int MaxNumBlockDiagonalEntries, int & NumBlockDiagonalEntries, int * RowColDims) -> int"""
        return _Epetra.VbrMatrix_BeginExtractBlockDiagonalCopy(self, *args)


    def ExtractBlockDiagonalEntryCopy(self, *args):
        """ExtractBlockDiagonalEntryCopy(VbrMatrix self, int SizeOfValues, double * Values, int LDA, bool SumInto) -> int"""
        return _Epetra.VbrMatrix_ExtractBlockDiagonalEntryCopy(self, *args)


    def BeginExtractBlockDiagonalView(self, *args):
        """BeginExtractBlockDiagonalView(VbrMatrix self, int & NumBlockDiagonalEntries, int *& RowColDims) -> int"""
        return _Epetra.VbrMatrix_BeginExtractBlockDiagonalView(self, *args)


    def ExtractBlockDiagonalEntryView(self, *args):
        """ExtractBlockDiagonalEntryView(VbrMatrix self, double *& Values, int & LDA) -> int"""
        return _Epetra.VbrMatrix_ExtractBlockDiagonalEntryView(self, *args)


    def Multiply1(self, *args):
        """Multiply1(VbrMatrix self, bool TransA, Vector x, Vector y) -> int"""
        return _Epetra.VbrMatrix_Multiply1(self, *args)


    def Multiply(self, *args):
        """
        Multiply(bool useTranspose, MultiVector x, MultiVector y) -> int

        In C++, arguments x and y are Epetra_MultiVectors.  In python, they
        are provided to you as numpy-hybrid Epetra.MultiVectors, giving you
        access to the numpy interface in addition to the Epetra_MultiVector
        C++ interface.
        """
        return _Epetra.VbrMatrix_Multiply(self, *args)


    def Solve(self, *args):
        """
        Solve((bool upper, bool trans, bool unitDiagonal, MultiVector x,
            MultiVector y) -> int

        In C++, arguments x and y are Epetra_MultiVectors.  In python, they
        are provided to you as numpy-hybrid Epetra.MultiVectors, giving you
        access to the numpy interface in addition to the Epetra_MultiVector
        C++ interface.
        """
        return _Epetra.VbrMatrix_Solve(self, *args)


    def InvRowSums(self, *args):
        """
        InvRowSums(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return _Epetra.VbrMatrix_InvRowSums(self, *args)


    def LeftScale(self, *args):
        """
        LeftScale(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return _Epetra.VbrMatrix_LeftScale(self, *args)


    def InvColSums(self, *args):
        """
        InvColSums(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return _Epetra.VbrMatrix_InvColSums(self, *args)


    def RightScale(self, *args):
        """
        RightScale(Vector x) -> int

        Argument x is provided to you as a numpy-hybrid Epetra.Vector, giving
        you access to the numpy interface in addition to the Epetra_Vector C++
        interface.
        """
        return _Epetra.VbrMatrix_RightScale(self, *args)


    def OptimizeStorage(self, *args):
        """OptimizeStorage(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_OptimizeStorage(self, *args)


    def StorageOptimized(self, *args):
        """StorageOptimized(VbrMatrix self) -> bool"""
        return _Epetra.VbrMatrix_StorageOptimized(self, *args)


    def IndicesAreGlobal(self, *args):
        """IndicesAreGlobal(VbrMatrix self) -> bool"""
        return _Epetra.VbrMatrix_IndicesAreGlobal(self, *args)


    def IndicesAreLocal(self, *args):
        """IndicesAreLocal(VbrMatrix self) -> bool"""
        return _Epetra.VbrMatrix_IndicesAreLocal(self, *args)


    def IndicesAreContiguous(self, *args):
        """IndicesAreContiguous(VbrMatrix self) -> bool"""
        return _Epetra.VbrMatrix_IndicesAreContiguous(self, *args)


    def LowerTriangular(self, *args):
        """LowerTriangular(VbrMatrix self) -> bool"""
        return _Epetra.VbrMatrix_LowerTriangular(self, *args)


    def UpperTriangular(self, *args):
        """UpperTriangular(VbrMatrix self) -> bool"""
        return _Epetra.VbrMatrix_UpperTriangular(self, *args)


    def NoDiagonal(self, *args):
        """NoDiagonal(VbrMatrix self) -> bool"""
        return _Epetra.VbrMatrix_NoDiagonal(self, *args)


    def NormInf(self, *args):
        """NormInf(VbrMatrix self) -> double"""
        return _Epetra.VbrMatrix_NormInf(self, *args)


    def NormOne(self, *args):
        """NormOne(VbrMatrix self) -> double"""
        return _Epetra.VbrMatrix_NormOne(self, *args)


    def NormFrobenius(self, *args):
        """NormFrobenius(VbrMatrix self) -> double"""
        return _Epetra.VbrMatrix_NormFrobenius(self, *args)


    def MaxRowDim(self, *args):
        """MaxRowDim(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_MaxRowDim(self, *args)


    def MaxColDim(self, *args):
        """MaxColDim(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_MaxColDim(self, *args)


    def GlobalMaxRowDim(self, *args):
        """GlobalMaxRowDim(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_GlobalMaxRowDim(self, *args)


    def GlobalMaxColDim(self, *args):
        """GlobalMaxColDim(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_GlobalMaxColDim(self, *args)


    def NumMyRows(self, *args):
        """NumMyRows(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_NumMyRows(self, *args)


    def NumMyCols(self, *args):
        """NumMyCols(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_NumMyCols(self, *args)


    def NumMyNonzeros(self, *args):
        """NumMyNonzeros(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_NumMyNonzeros(self, *args)


    def NumGlobalRows(self, *args):
        """NumGlobalRows(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_NumGlobalRows(self, *args)


    def NumGlobalRows64(self, *args):
        """NumGlobalRows64(VbrMatrix self) -> long long"""
        return _Epetra.VbrMatrix_NumGlobalRows64(self, *args)


    def NumGlobalCols(self, *args):
        """NumGlobalCols(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_NumGlobalCols(self, *args)


    def NumGlobalCols64(self, *args):
        """NumGlobalCols64(VbrMatrix self) -> long long"""
        return _Epetra.VbrMatrix_NumGlobalCols64(self, *args)


    def NumGlobalNonzeros(self, *args):
        """NumGlobalNonzeros(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_NumGlobalNonzeros(self, *args)


    def NumGlobalNonzeros64(self, *args):
        """NumGlobalNonzeros64(VbrMatrix self) -> long long"""
        return _Epetra.VbrMatrix_NumGlobalNonzeros64(self, *args)


    def NumMyBlockRows(self, *args):
        """NumMyBlockRows(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_NumMyBlockRows(self, *args)


    def NumMyBlockCols(self, *args):
        """NumMyBlockCols(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_NumMyBlockCols(self, *args)


    def NumMyBlockDiagonals(self, *args):
        """NumMyBlockDiagonals(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_NumMyBlockDiagonals(self, *args)


    def NumMyDiagonals(self, *args):
        """NumMyDiagonals(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_NumMyDiagonals(self, *args)


    def NumGlobalBlockRows(self, *args):
        """NumGlobalBlockRows(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_NumGlobalBlockRows(self, *args)


    def NumGlobalBlockRows64(self, *args):
        """NumGlobalBlockRows64(VbrMatrix self) -> long long"""
        return _Epetra.VbrMatrix_NumGlobalBlockRows64(self, *args)


    def NumGlobalBlockCols(self, *args):
        """NumGlobalBlockCols(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_NumGlobalBlockCols(self, *args)


    def NumGlobalBlockCols64(self, *args):
        """NumGlobalBlockCols64(VbrMatrix self) -> long long"""
        return _Epetra.VbrMatrix_NumGlobalBlockCols64(self, *args)


    def NumGlobalBlockEntries64(self, *args):
        """NumGlobalBlockEntries64(VbrMatrix self) -> long long"""
        return _Epetra.VbrMatrix_NumGlobalBlockEntries64(self, *args)


    def NumGlobalBlockDiagonals(self, *args):
        """NumGlobalBlockDiagonals(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_NumGlobalBlockDiagonals(self, *args)


    def NumGlobalBlockDiagonals64(self, *args):
        """NumGlobalBlockDiagonals64(VbrMatrix self) -> long long"""
        return _Epetra.VbrMatrix_NumGlobalBlockDiagonals64(self, *args)


    def NumGlobalDiagonals(self, *args):
        """NumGlobalDiagonals(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_NumGlobalDiagonals(self, *args)


    def NumGlobalDiagonals64(self, *args):
        """NumGlobalDiagonals64(VbrMatrix self) -> long long"""
        return _Epetra.VbrMatrix_NumGlobalDiagonals64(self, *args)


    def NumGlobalBlockEntries(self, *args):
        """
        NumGlobalBlockEntries(VbrMatrix self) -> int
        NumGlobalBlockEntries(VbrMatrix self, int Row) -> int
        """
        return _Epetra.VbrMatrix_NumGlobalBlockEntries(self, *args)


    def NumAllocatedGlobalBlockEntries(self, *args):
        """NumAllocatedGlobalBlockEntries(VbrMatrix self, int Row) -> int"""
        return _Epetra.VbrMatrix_NumAllocatedGlobalBlockEntries(self, *args)


    def MaxNumBlockEntries(self, *args):
        """MaxNumBlockEntries(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_MaxNumBlockEntries(self, *args)


    def GlobalMaxNumBlockEntries(self, *args):
        """GlobalMaxNumBlockEntries(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_GlobalMaxNumBlockEntries(self, *args)


    def NumMyBlockEntries(self, *args):
        """
        NumMyBlockEntries(VbrMatrix self) -> int
        NumMyBlockEntries(VbrMatrix self, int Row) -> int
        """
        return _Epetra.VbrMatrix_NumMyBlockEntries(self, *args)


    def NumAllocatedMyBlockEntries(self, *args):
        """NumAllocatedMyBlockEntries(VbrMatrix self, int Row) -> int"""
        return _Epetra.VbrMatrix_NumAllocatedMyBlockEntries(self, *args)


    def MaxNumNonzeros(self, *args):
        """MaxNumNonzeros(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_MaxNumNonzeros(self, *args)


    def GlobalMaxNumNonzeros(self, *args):
        """GlobalMaxNumNonzeros(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_GlobalMaxNumNonzeros(self, *args)


    def IndexBase(self, *args):
        """IndexBase(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_IndexBase(self, *args)


    def IndexBase64(self, *args):
        """IndexBase64(VbrMatrix self) -> long long"""
        return _Epetra.VbrMatrix_IndexBase64(self, *args)


    def Graph(self, *args):
        """Graph(VbrMatrix self) -> CrsGraph"""
        return _Epetra.VbrMatrix_Graph(self, *args)


    def Importer(self, *args):
        """Importer(VbrMatrix self) -> Import"""
        return _Epetra.VbrMatrix_Importer(self, *args)


    def Exporter(self, *args):
        """Exporter(VbrMatrix self) -> Export"""
        return _Epetra.VbrMatrix_Exporter(self, *args)


    def DomainMap(self, *args):
        """DomainMap(VbrMatrix self) -> BlockMap"""
        return _Epetra.VbrMatrix_DomainMap(self, *args)


    def RangeMap(self, *args):
        """RangeMap(VbrMatrix self) -> BlockMap"""
        return _Epetra.VbrMatrix_RangeMap(self, *args)


    def RowMap(self, *args):
        """RowMap(VbrMatrix self) -> BlockMap"""
        return _Epetra.VbrMatrix_RowMap(self, *args)


    def ColMap(self, *args):
        """ColMap(VbrMatrix self) -> BlockMap"""
        return _Epetra.VbrMatrix_ColMap(self, *args)


    def Comm(self, *args):
        """Comm(VbrMatrix self) -> Comm"""
        return _Epetra.VbrMatrix_Comm(self, *args)


    def LRID(self, *args):
        """
        LRID(VbrMatrix self, int GRID_in) -> int
        LRID(VbrMatrix self, long long GRID_in) -> int
        """
        return _Epetra.VbrMatrix_LRID(self, *args)


    def GRID(self, *args):
        """GRID(VbrMatrix self, int LRID_in) -> int"""
        return _Epetra.VbrMatrix_GRID(self, *args)


    def GRID64(self, *args):
        """GRID64(VbrMatrix self, int LRID_in) -> long long"""
        return _Epetra.VbrMatrix_GRID64(self, *args)


    def LCID(self, *args):
        """
        LCID(VbrMatrix self, int GCID_in) -> int
        LCID(VbrMatrix self, long long GCID_in) -> int
        """
        return _Epetra.VbrMatrix_LCID(self, *args)


    def GCID(self, *args):
        """GCID(VbrMatrix self, int LCID_in) -> int"""
        return _Epetra.VbrMatrix_GCID(self, *args)


    def GCID64(self, *args):
        """GCID64(VbrMatrix self, int LCID_in) -> long long"""
        return _Epetra.VbrMatrix_GCID64(self, *args)


    def MyGRID(self, *args):
        """
        MyGRID(VbrMatrix self, int GRID_in) -> bool
        MyGRID(VbrMatrix self, long long GRID_in) -> bool
        """
        return _Epetra.VbrMatrix_MyGRID(self, *args)


    def MyLRID(self, *args):
        """MyLRID(VbrMatrix self, int LRID_in) -> bool"""
        return _Epetra.VbrMatrix_MyLRID(self, *args)


    def MyGCID(self, *args):
        """
        MyGCID(VbrMatrix self, int GCID_in) -> bool
        MyGCID(VbrMatrix self, long long GCID_in) -> bool
        """
        return _Epetra.VbrMatrix_MyGCID(self, *args)


    def MyLCID(self, *args):
        """MyLCID(VbrMatrix self, int LCID_in) -> bool"""
        return _Epetra.VbrMatrix_MyLCID(self, *args)


    def MyGlobalBlockRow(self, *args):
        """
        MyGlobalBlockRow(VbrMatrix self, int GID) -> bool
        MyGlobalBlockRow(VbrMatrix self, long long GID) -> bool
        """
        return _Epetra.VbrMatrix_MyGlobalBlockRow(self, *args)


    def Label(self, *args):
        """Label(VbrMatrix self) -> char const *"""
        return _Epetra.VbrMatrix_Label(self, *args)


    def SetUseTranspose(self, *args):
        """SetUseTranspose(VbrMatrix self, bool UseTranspose_in) -> int"""
        return _Epetra.VbrMatrix_SetUseTranspose(self, *args)


    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        """
        return _Epetra.VbrMatrix_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.

        """
        return _Epetra.VbrMatrix_ApplyInverse(self, *args)


    def HasNormInf(self, *args):
        """HasNormInf(VbrMatrix self) -> bool"""
        return _Epetra.VbrMatrix_HasNormInf(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(VbrMatrix self) -> bool"""
        return _Epetra.VbrMatrix_UseTranspose(self, *args)


    def OperatorDomainMap(self, *args):
        """OperatorDomainMap(VbrMatrix self) -> Map"""
        return _Epetra.VbrMatrix_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """OperatorRangeMap(VbrMatrix self) -> Map"""
        return _Epetra.VbrMatrix_OperatorRangeMap(self, *args)


    def ExtractGlobalRowCopy(self, *args):
        """ExtractGlobalRowCopy(VbrMatrix self, int GlobalRow, int Length, int & NumEntries, double * Values, int * Indices) -> int"""
        return _Epetra.VbrMatrix_ExtractGlobalRowCopy(self, *args)


    def ExtractMyRowCopy(self, *args):
        """
        ExtractMyRowCopy(int myRow, int length, numpy.ndarray numEntries,
            numpy.ndarray values, numpy.ndarray indices) -> int

        In C++, numEntries in an int&.  In python, it is provided to you as a
        numpy array of length one so that you can set its value in-place using
        numEntries[0] = ....

        Arguments values and indices are double* and int*, respectively, in
        C++.  In python, these are provided to you as numpy arrays of the
        given length, so that you may alter their entries in-place.
        """
        return _Epetra.VbrMatrix_ExtractMyRowCopy(self, *args)


    def NumMyRowEntries(self, *args):
        """
        NumMyRowEntries(int myRow, numpy.ndarray numEntries) -> int

        In C++, numEntries in an int&.  In python, it is provided to you as a
        numpy array of length one so that you can set its value in-place using
        numEntries[0] = ....
        """
        return _Epetra.VbrMatrix_NumMyRowEntries(self, *args)


    def MaxNumEntries(self, *args):
        """MaxNumEntries(VbrMatrix self) -> int"""
        return _Epetra.VbrMatrix_MaxNumEntries(self, *args)


    def Map(self, *args):
        """Map(VbrMatrix self) -> BlockMap"""
        return _Epetra.VbrMatrix_Map(self, *args)


    def RowMatrixRowMap(self, *args):
        """RowMatrixRowMap(VbrMatrix self) -> Map"""
        return _Epetra.VbrMatrix_RowMatrixRowMap(self, *args)


    def RowMatrixColMap(self, *args):
        """RowMatrixColMap(VbrMatrix self) -> Map"""
        return _Epetra.VbrMatrix_RowMatrixColMap(self, *args)


    def RowMatrixImporter(self, *args):
        """RowMatrixImporter(VbrMatrix self) -> Import"""
        return _Epetra.VbrMatrix_RowMatrixImporter(self, *args)


    def BlockImportMap(self, *args):
        """BlockImportMap(VbrMatrix self) -> BlockMap"""
        return _Epetra.VbrMatrix_BlockImportMap(self, *args)


    def TransformToLocal(self, *args):
        """
        TransformToLocal(VbrMatrix self) -> int
        TransformToLocal(VbrMatrix self, BlockMap DomainMap, BlockMap RangeMap) -> int
        """
        return _Epetra.VbrMatrix_TransformToLocal(self, *args)


    def __init__(self, *args):
        """

        __init__(self, Epetra_DataAccess CV, BlockMap rowMap, int
            numBlockEntriesPerRow) -> VbrMatrix

          VbrMatrix constructor with implicit column map and constant number
          of block entries per row.


        __init__(self, Epetra_DataAccess CV, BlockMap rowMap, BlockMap colMap,
            int numBlockEntriesPerRow) -> VbrMatrix

          VbrMatrix constructor with specified column map and constant number
          of block entries per row.



        __init__(self, Epetra_DataAccess CV, CrsGraph graph) -> VbrMatrix

          CrsGraph constructor.


        __init__(self, VbrMatrix matrix) -> VbrMatrix

          Copy constructor.


        __init__(self, Epetra_DataAccess CV, BlockMap rowMap, PySequence
            numBlockEntriesPerRow) -> VbrMatrix

          VbrMatrix constructor with implicit column map and variable number
          of block entries per row.



        __init__(self, Epetra_DataAccess CV, BlockMap rowMap, BlockMap colMap,
            PySequence numBlockEntriesPerRow) -> VbrMatrix

          VbrMatrix constructor with specified column map and variable number
          of block entries per row.


        """
        this = _Epetra.new_VbrMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
VbrMatrix_swigregister = _Epetra.VbrMatrix_swigregister
VbrMatrix_swigregister(VbrMatrix)

class FEVbrMatrix(VbrMatrix):
    """Proxy of C++ Epetra_FEVbrMatrix class."""

    __swig_setmethods__ = {}
    for _s in [VbrMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, FEVbrMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [VbrMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, FEVbrMatrix, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_FEVbrMatrix self, Epetra_DataAccess CV, BlockMap RowMap, int * NumBlockEntriesPerRow, bool ignoreNonLocalEntries=False) -> FEVbrMatrix
        __init__(Epetra_FEVbrMatrix self, Epetra_DataAccess CV, BlockMap RowMap, int NumBlockEntriesPerRow, bool ignoreNonLocalEntries=False) -> FEVbrMatrix
        __init__(Epetra_FEVbrMatrix self, Epetra_DataAccess CV, BlockMap RowMap, BlockMap ColMap, int * NumBlockEntriesPerRow, bool ignoreNonLocalEntries=False) -> FEVbrMatrix
        __init__(Epetra_FEVbrMatrix self, Epetra_DataAccess CV, BlockMap RowMap, BlockMap ColMap, int NumBlockEntriesPerRow, bool ignoreNonLocalEntries=False) -> FEVbrMatrix
        __init__(Epetra_FEVbrMatrix self, Epetra_DataAccess CV, CrsGraph Graph, bool ignoreNonLocalEntries=False) -> FEVbrMatrix
        __init__(Epetra_FEVbrMatrix self, FEVbrMatrix src) -> FEVbrMatrix
        """
        this = _Epetra.new_FEVbrMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_FEVbrMatrix

    def PutScalar(self, *args):
        """PutScalar(FEVbrMatrix self, double ScalarConstant) -> int"""
        return _Epetra.FEVbrMatrix_PutScalar(self, *args)


    def BeginInsertGlobalValues(self, *args):
        """BeginInsertGlobalValues(FEVbrMatrix self, int BlockRow, int NumBlockEntries, int * BlockIndices) -> int"""
        return _Epetra.FEVbrMatrix_BeginInsertGlobalValues(self, *args)


    def BeginReplaceGlobalValues(self, *args):
        """BeginReplaceGlobalValues(FEVbrMatrix self, int BlockRow, int NumBlockEntries, int * BlockIndices) -> int"""
        return _Epetra.FEVbrMatrix_BeginReplaceGlobalValues(self, *args)


    def BeginSumIntoGlobalValues(self, *args):
        """BeginSumIntoGlobalValues(FEVbrMatrix self, int BlockRow, int NumBlockEntries, int * BlockIndices) -> int"""
        return _Epetra.FEVbrMatrix_BeginSumIntoGlobalValues(self, *args)


    def SubmitBlockEntry(self, *args):
        """
        SubmitBlockEntry(FEVbrMatrix self, SerialDenseMatrix Mat) -> int
        SubmitBlockEntry(FEVbrMatrix self, double * Values, int LDA, int NumRows, int NumCols) -> int
        """
        return _Epetra.FEVbrMatrix_SubmitBlockEntry(self, *args)


    def EndSubmitEntries(self, *args):
        """EndSubmitEntries(FEVbrMatrix self) -> int"""
        return _Epetra.FEVbrMatrix_EndSubmitEntries(self, *args)


    def GlobalAssemble(self, *args):
        """GlobalAssemble(FEVbrMatrix self, bool callFillComplete=True) -> int"""
        return _Epetra.FEVbrMatrix_GlobalAssemble(self, *args)

FEVbrMatrix_swigregister = _Epetra.FEVbrMatrix_swigregister
FEVbrMatrix_swigregister(FEVbrMatrix)

class JadMatrix(BasicRowMatrix):
    """Proxy of C++ Epetra_JadMatrix class."""

    __swig_setmethods__ = {}
    for _s in [BasicRowMatrix]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, JadMatrix, name, value)
    __swig_getmethods__ = {}
    for _s in [BasicRowMatrix]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, JadMatrix, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Epetra_JadMatrix self, RowMatrix Matrix) -> JadMatrix"""
        this = _Epetra.new_JadMatrix(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_JadMatrix

    def UpdateValues(self, *args):
        """UpdateValues(JadMatrix self, RowMatrix Matrix, bool CheckStructure=False) -> int"""
        return _Epetra.JadMatrix_UpdateValues(self, *args)


    def ExtractMyRowCopy(self, *args):
        """
        ExtractMyRowCopy(int myRow, int length, numpy.ndarray numEntries,
            numpy.ndarray values, numpy.ndarray indices) -> int

        In C++, numEntries in an int&.  In python, it is provided to you as a
        numpy array of length one so that you can set its value in-place using
        numEntries[0] = ....

        Arguments values and indices are double* and int*, respectively, in
        C++.  In python, these are provided to you as numpy arrays of the
        given length, so that you may alter their entries in-place.
        """
        return _Epetra.JadMatrix_ExtractMyRowCopy(self, *args)


    def NumMyRowEntries(self, *args):
        """
        NumMyRowEntries(int myRow, numpy.ndarray numEntries) -> int

        In C++, numEntries in an int&.  In python, it is provided to you as a
        numpy array of length one so that you can set its value in-place using
        numEntries[0] = ....
        """
        return _Epetra.JadMatrix_NumMyRowEntries(self, *args)


    def Multiply(self, *args):
        """
        Multiply(bool useTranspose, MultiVector x, MultiVector y) -> int

        In C++, arguments x and y are Epetra_MultiVectors.  In python, they
        are provided to you as numpy-hybrid Epetra.MultiVectors, giving you
        access to the numpy interface in addition to the Epetra_MultiVector
        C++ interface.
        """
        return _Epetra.JadMatrix_Multiply(self, *args)


    def Solve(self, *args):
        """
        Solve((bool upper, bool trans, bool unitDiagonal, MultiVector x,
            MultiVector y) -> int

        In C++, arguments x and y are Epetra_MultiVectors.  In python, they
        are provided to you as numpy-hybrid Epetra.MultiVectors, giving you
        access to the numpy interface in addition to the Epetra_MultiVector
        C++ interface.
        """
        return _Epetra.JadMatrix_Solve(self, *args)

JadMatrix_swigregister = _Epetra.JadMatrix_swigregister
JadMatrix_swigregister(JadMatrix)

easy = _Epetra.easy
moderate = _Epetra.moderate
hard = _Epetra.hard
unsure = _Epetra.unsure
class Epetra_LinearProblem(_object):
    """Proxy of C++ Epetra_LinearProblem class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Epetra_LinearProblem, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Epetra_LinearProblem, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_LinearProblem self) -> Epetra_LinearProblem
        __init__(Epetra_LinearProblem self, RowMatrix A, MultiVector X, MultiVector B) -> Epetra_LinearProblem
        __init__(Epetra_LinearProblem self, Operator A, MultiVector X, MultiVector B) -> Epetra_LinearProblem
        __init__(Epetra_LinearProblem self, Epetra_LinearProblem Problem) -> Epetra_LinearProblem
        """
        this = _Epetra.new_Epetra_LinearProblem(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_Epetra_LinearProblem

    def CheckInput(self, *args):
        """CheckInput(Epetra_LinearProblem self) -> int"""
        return _Epetra.Epetra_LinearProblem_CheckInput(self, *args)


    def AssertSymmetric(self, *args):
        """AssertSymmetric(Epetra_LinearProblem self)"""
        return _Epetra.Epetra_LinearProblem_AssertSymmetric(self, *args)


    def SetPDL(self, *args):
        """SetPDL(Epetra_LinearProblem self, ProblemDifficultyLevel PDL)"""
        return _Epetra.Epetra_LinearProblem_SetPDL(self, *args)


    def SetOperator(self, *args):
        """
        SetOperator(Epetra_LinearProblem self, RowMatrix A)
        SetOperator(Epetra_LinearProblem self, Operator A)
        """
        return _Epetra.Epetra_LinearProblem_SetOperator(self, *args)


    def SetLHS(self, *args):
        """SetLHS(Epetra_LinearProblem self, MultiVector X)"""
        return _Epetra.Epetra_LinearProblem_SetLHS(self, *args)


    def SetRHS(self, *args):
        """SetRHS(Epetra_LinearProblem self, MultiVector B)"""
        return _Epetra.Epetra_LinearProblem_SetRHS(self, *args)


    def LeftScale(self, *args):
        """LeftScale(Epetra_LinearProblem self, Vector D) -> int"""
        return _Epetra.Epetra_LinearProblem_LeftScale(self, *args)


    def RightScale(self, *args):
        """RightScale(Epetra_LinearProblem self, Vector D) -> int"""
        return _Epetra.Epetra_LinearProblem_RightScale(self, *args)


    def GetOperator(self, *args):
        """GetOperator(Epetra_LinearProblem self) -> Operator"""
        return _Epetra.Epetra_LinearProblem_GetOperator(self, *args)


    def GetMatrix(self, *args):
        """GetMatrix(Epetra_LinearProblem self) -> RowMatrix"""
        return _Epetra.Epetra_LinearProblem_GetMatrix(self, *args)


    def GetLHS(self, *args):
        """GetLHS(Epetra_LinearProblem self) -> MultiVector"""
        return _Epetra.Epetra_LinearProblem_GetLHS(self, *args)


    def GetRHS(self, *args):
        """GetRHS(Epetra_LinearProblem self) -> MultiVector"""
        return _Epetra.Epetra_LinearProblem_GetRHS(self, *args)


    def GetPDL(self, *args):
        """GetPDL(Epetra_LinearProblem self) -> ProblemDifficultyLevel"""
        return _Epetra.Epetra_LinearProblem_GetPDL(self, *args)


    def IsOperatorSymmetric(self, *args):
        """IsOperatorSymmetric(Epetra_LinearProblem self) -> bool"""
        return _Epetra.Epetra_LinearProblem_IsOperatorSymmetric(self, *args)

Epetra_LinearProblem_swigregister = _Epetra.Epetra_LinearProblem_swigregister
Epetra_LinearProblem_swigregister(Epetra_LinearProblem)

class LinearProblem(Epetra_LinearProblem):
    """Proxy of C++ PyTrilinos::LinearProblem class."""

    __swig_setmethods__ = {}
    for _s in [Epetra_LinearProblem]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LinearProblem, name, value)
    __swig_getmethods__ = {}
    for _s in [Epetra_LinearProblem]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LinearProblem, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(PyTrilinos::LinearProblem self) -> LinearProblem
        __init__(PyTrilinos::LinearProblem self, Teuchos::RCP< Epetra_RowMatrix > const matrix, Teuchos::RCP< Epetra_MultiVector > const x, Teuchos::RCP< Epetra_MultiVector > const b) -> LinearProblem
        __init__(PyTrilinos::LinearProblem self, Teuchos::RCP< Epetra_Operator > const op, Teuchos::RCP< Epetra_MultiVector > const x, Teuchos::RCP< Epetra_MultiVector > const b) -> LinearProblem
        __init__(PyTrilinos::LinearProblem self, LinearProblem source) -> LinearProblem
        __init__(PyTrilinos::LinearProblem self, Epetra_LinearProblem source) -> LinearProblem
        """
        this = _Epetra.new_LinearProblem(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_LinearProblem

    def CheckInput(self, *args):
        """CheckInput(LinearProblem self) -> int"""
        return _Epetra.LinearProblem_CheckInput(self, *args)


    def AssertSymmetric(self, *args):
        """AssertSymmetric(LinearProblem self)"""
        return _Epetra.LinearProblem_AssertSymmetric(self, *args)


    def SetPDL(self, *args):
        """SetPDL(LinearProblem self, ProblemDifficultyLevel PDL)"""
        return _Epetra.LinearProblem_SetPDL(self, *args)


    def SetOperator(self, *args):
        """
        SetOperator(LinearProblem self, Teuchos::RCP< Epetra_RowMatrix > & matrix)
        SetOperator(LinearProblem self, Teuchos::RCP< Epetra_Operator > & op)
        """
        return _Epetra.LinearProblem_SetOperator(self, *args)


    def SetLHS(self, *args):
        """SetLHS(LinearProblem self, Teuchos::RCP< Epetra_MultiVector > & x)"""
        return _Epetra.LinearProblem_SetLHS(self, *args)


    def SetRHS(self, *args):
        """SetRHS(LinearProblem self, Teuchos::RCP< Epetra_MultiVector > & b)"""
        return _Epetra.LinearProblem_SetRHS(self, *args)


    def LeftScale(self, *args):
        """LeftScale(LinearProblem self, Vector D) -> int"""
        return _Epetra.LinearProblem_LeftScale(self, *args)


    def RightScale(self, *args):
        """RightScale(LinearProblem self, Vector D) -> int"""
        return _Epetra.LinearProblem_RightScale(self, *args)


    def GetMatrix(self, *args):
        """GetMatrix(LinearProblem self) -> Teuchos::RCP< Epetra_RowMatrix >"""
        return _Epetra.LinearProblem_GetMatrix(self, *args)


    def GetOperator(self, *args):
        """GetOperator(LinearProblem self) -> Teuchos::RCP< Epetra_Operator >"""
        return _Epetra.LinearProblem_GetOperator(self, *args)


    def GetLHS(self, *args):
        """GetLHS(LinearProblem self) -> Teuchos::RCP< Epetra_MultiVector >"""
        return _Epetra.LinearProblem_GetLHS(self, *args)


    def GetRHS(self, *args):
        """GetRHS(LinearProblem self) -> Teuchos::RCP< Epetra_MultiVector >"""
        return _Epetra.LinearProblem_GetRHS(self, *args)


    def GetPDL(self, *args):
        """GetPDL(LinearProblem self) -> ProblemDifficultyLevel"""
        return _Epetra.LinearProblem_GetPDL(self, *args)


    def IsOperatorSymmetric(self, *args):
        """IsOperatorSymmetric(LinearProblem self) -> bool"""
        return _Epetra.LinearProblem_IsOperatorSymmetric(self, *args)

LinearProblem_swigregister = _Epetra.LinearProblem_swigregister
LinearProblem_swigregister(LinearProblem)

class Util(_object):
    """
    Epetra Util Wrapper Class.

    The Epetra.Util class is a collection of useful functions that cut
    across a broad set of other classes.  A random number generator is
    provided, along with methods to set and retrieve the random-number
    seed.

    The random number generator is a multiplicative linear congruential
    generator, with multiplier 16807 and modulus 2^31 - 1. It is based on
    the algorithm described in 'Random Number Generators: Good Ones Are
    Hard To Find', S. K. Park and K. W. Miller, Communications of the ACM,
    vol. 31, no. 10, pp. 1192-1201.

    The C++ Sort() method is not supported in python.

    A static function is provided for creating a new Epetra.Map object
    with 1-to-1 ownership of entries from an existing map which may have
    entries that appear on multiple processors.

    Epetra.Util is a serial interface only.  This is appropriate since the
    standard utilities are only specified for serial execution (or shared
    memory parallel).
    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Util, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Util, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Epetra_Util self) -> Util
        __init__(Epetra_Util self, Util Util) -> Util

        Epetra Util Wrapper Class.

        The Epetra.Util class is a collection of useful functions that cut
        across a broad set of other classes.  A random number generator is
        provided, along with methods to set and retrieve the random-number
        seed.

        The random number generator is a multiplicative linear congruential
        generator, with multiplier 16807 and modulus 2^31 - 1. It is based on
        the algorithm described in 'Random Number Generators: Good Ones Are
        Hard To Find', S. K. Park and K. W. Miller, Communications of the ACM,
        vol. 31, no. 10, pp. 1192-1201.

        The C++ Sort() method is not supported in python.

        A static function is provided for creating a new Epetra.Map object
        with 1-to-1 ownership of entries from an existing map which may have
        entries that appear on multiple processors.

        Epetra.Util is a serial interface only.  This is appropriate since the
        standard utilities are only specified for serial execution (or shared
        memory parallel).
        """
        this = _Epetra.new_Util(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Epetra.delete_Util

    def RandomInt(self, *args):
        """RandomInt(Util self) -> unsigned int"""
        return _Epetra.Util_RandomInt(self, *args)


    def RandomDouble(self, *args):
        """RandomDouble(Util self) -> double"""
        return _Epetra.Util_RandomDouble(self, *args)


    def Seed(self, *args):
        """Seed(Util self) -> unsigned int"""
        return _Epetra.Util_Seed(self, *args)


    def SetSeed(self, *args):
        """SetSeed(Util self, unsigned int Seed_in) -> int"""
        return _Epetra.Util_SetSeed(self, *args)


    def Create_Root_Map(*args):
        """Create_Root_Map(Map usermap, int root=0) -> Map"""
        return _Epetra.Util_Create_Root_Map(*args)

    Create_Root_Map = staticmethod(Create_Root_Map)

    def Create_OneToOne_Map(*args):
        """Create_OneToOne_Map(Map usermap, bool high_rank_proc_owns_shared=False) -> Map"""
        return _Epetra.Util_Create_OneToOne_Map(*args)

    Create_OneToOne_Map = staticmethod(Create_OneToOne_Map)

    def Create_OneToOne_BlockMap(*args):
        """Create_OneToOne_BlockMap(BlockMap usermap, bool high_rank_proc_owns_shared=False) -> BlockMap"""
        return _Epetra.Util_Create_OneToOne_BlockMap(*args)

    Create_OneToOne_BlockMap = staticmethod(Create_OneToOne_BlockMap)

    def SortCrsEntries(*args):
        """SortCrsEntries(int NumRows, int const * CRS_rowptr, int * CRS_colind, double * CRS_vals) -> int"""
        return _Epetra.Util_SortCrsEntries(*args)

    SortCrsEntries = staticmethod(SortCrsEntries)

    def SortAndMergeCrsEntries(*args):
        """SortAndMergeCrsEntries(int NumRows, int * CRS_rowptr, int * CRS_colind, double * CRS_vals) -> int"""
        return _Epetra.Util_SortAndMergeCrsEntries(*args)

    SortAndMergeCrsEntries = staticmethod(SortAndMergeCrsEntries)

    def GetPidGidPairs(*args):
        """
        GetPidGidPairs(Import Importer, std::vector< std::pair< int,int >,std::allocator< std::pair< int,int > > > & gpids, bool use_minus_one_for_local) -> int
        GetPidGidPairs(Import Importer, std::vector< std::pair< int,long long >,std::allocator< std::pair< int,long long > > > & gpids, bool use_minus_one_for_local) -> int
        """
        return _Epetra.Util_GetPidGidPairs(*args)

    GetPidGidPairs = staticmethod(GetPidGidPairs)

    def GetPids(*args):
        """GetPids(Import Importer, std::vector< int,std::allocator< int > > & pids, bool use_minus_one_for_local) -> int"""
        return _Epetra.Util_GetPids(*args)

    GetPids = staticmethod(GetPids)

    def GetRemotePIDs(*args):
        """GetRemotePIDs(Import Importer, std::vector< int,std::allocator< int > > & RemotePIDs) -> int"""
        return _Epetra.Util_GetRemotePIDs(*args)

    GetRemotePIDs = staticmethod(GetRemotePIDs)

    def Chop(*args):
        """Chop(double const & Value) -> double"""
        return _Epetra.Util_Chop(*args)

    Chop = staticmethod(Chop)
Util_swigregister = _Epetra.Util_swigregister
Util_swigregister(Util)

def Util_Create_Root_Map(*args):
    """Util_Create_Root_Map(Map usermap, int root=0) -> Map"""
    return _Epetra.Util_Create_Root_Map(*args)

def Util_Create_OneToOne_Map(*args):
    """Util_Create_OneToOne_Map(Map usermap, bool high_rank_proc_owns_shared=False) -> Map"""
    return _Epetra.Util_Create_OneToOne_Map(*args)

def Util_Create_OneToOne_BlockMap(*args):
    """Util_Create_OneToOne_BlockMap(BlockMap usermap, bool high_rank_proc_owns_shared=False) -> BlockMap"""
    return _Epetra.Util_Create_OneToOne_BlockMap(*args)

def Util_SortCrsEntries(*args):
    """Util_SortCrsEntries(int NumRows, int const * CRS_rowptr, int * CRS_colind, double * CRS_vals) -> int"""
    return _Epetra.Util_SortCrsEntries(*args)

def Util_SortAndMergeCrsEntries(*args):
    """Util_SortAndMergeCrsEntries(int NumRows, int * CRS_rowptr, int * CRS_colind, double * CRS_vals) -> int"""
    return _Epetra.Util_SortAndMergeCrsEntries(*args)

def Util_GetPidGidPairs(*args):
    """
    GetPidGidPairs(Import Importer, std::vector< std::pair< int,int >,std::allocator< std::pair< int,int > > > & gpids, bool use_minus_one_for_local) -> int
    Util_GetPidGidPairs(Import Importer, std::vector< std::pair< int,long long >,std::allocator< std::pair< int,long long > > > & gpids, bool use_minus_one_for_local) -> int
    """
    return _Epetra.Util_GetPidGidPairs(*args)

def Util_GetPids(*args):
    """Util_GetPids(Import Importer, std::vector< int,std::allocator< int > > & pids, bool use_minus_one_for_local) -> int"""
    return _Epetra.Util_GetPids(*args)

def Util_GetRemotePIDs(*args):
    """Util_GetRemotePIDs(Import Importer, std::vector< int,std::allocator< int > > & RemotePIDs) -> int"""
    return _Epetra.Util_GetRemotePIDs(*args)

def Util_Chop(*args):
    """Util_Chop(double const & Value) -> double"""
    return _Epetra.Util_Chop(*args)
Util.chopVal_ = _Epetra.cvar.Util_chopVal_


def Epetra_Util_binary_search(*args):
    """
    Epetra_Util_binary_search(int item, int const * list, int len, int & insertPoint) -> int
    Epetra_Util_binary_search(long long item, long long const * list, int len, int & insertPoint) -> int
    """
    return _Epetra.Epetra_Util_binary_search(*args)

def Epetra_Util_binary_search_aux(*args):
    """
    Epetra_Util_binary_search_aux(int item, int const * list, int const * aux_list, int len, int & insertPoint) -> int
    Epetra_Util_binary_search_aux(long long item, int const * list, long long const * aux_list, int len, int & insertPoint) -> int
    """
    return _Epetra.Epetra_Util_binary_search_aux(*args)

def Epetra_Util_ExtractHbData(*args):
    """Epetra_Util_ExtractHbData(CrsMatrix A, MultiVector LHS, MultiVector RHS, int & M, int & N, int & nz, int *& ptr, int *& ind, double *& val, int & Nrhs, double *& rhs, int & ldrhs, double *& lhs, int & ldlhs) -> int"""
    return _Epetra.Epetra_Util_ExtractHbData(*args)
# This file is compatible with both classic and new-style classes.


