# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""

PyTrilinos.Anasazi is the python interface to the Trilinos eigensolver
package Anasazi:

    http://trilinos.sandia.gov/packages/anasazi

Anasazi is a collection of eigensolver technologies.  The C++ version
makes liberal use of templates to abstract out the scalar type,
multivector type and operator type.  Currently, the python version
supports only an Epetra interface, so that the scalar type is float
(C++ double), the multivector type is Epetra.MultiVector and the
operator type is Epetra.Operator.  The following python factories
produce python wrappers to underlying C++ instances of the given C++
names with concrete Epetra implementations:

    * SortManager
    * BasicSort
    * Eigenproblem
    * BasicEigenproblem
    * StatusTest
    * StatusTestCombo
    * StatusTestMaxIters
    * StatusTestOutput
    * StatusTestResNorm
    * OrthoManager
    * MatOrthoManager
    * SVQBOrthoManager
    * Eigensolver
    * SolverManager
    * BlockDavidson
    * BlockDavidsonSolMgr
    * BlockKrylovSchur
    * BlockKrylovSchurSolMgr
    * LOBPCG
    * LOBPCGSolMgr
    * Eigensolution

For an example of usage of Anasazi to solve an eigenproblem, see the
following script in the example subdirectory of the PyTrilinos
package:

    * exAnasazi_BlockDavidson.py

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Anasazi')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Anasazi')
    _Anasazi = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Anasazi', [dirname(__file__)])
        except ImportError:
            import _Anasazi
            return _Anasazi
        try:
            _mod = imp.load_module('_Anasazi', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Anasazi = swig_import_helper()
    del swig_import_helper
else:
    import _Anasazi
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

try:
    import weakref
    weakref_proxy = weakref.proxy
except __builtin__.Exception:
    weakref_proxy = lambda x: x


HAVE_EPETRA_THYRA = _Anasazi.HAVE_EPETRA_THYRA
class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_SwigPyIterator

    def value(self):
        """value(SwigPyIterator self) -> PyObject *"""
        return _Anasazi.SwigPyIterator_value(self)


    def incr(self, n=1):
        """
        incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        incr(SwigPyIterator self) -> SwigPyIterator
        """
        return _Anasazi.SwigPyIterator_incr(self, n)


    def decr(self, n=1):
        """
        decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator
        decr(SwigPyIterator self) -> SwigPyIterator
        """
        return _Anasazi.SwigPyIterator_decr(self, n)


    def distance(self, x):
        """distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _Anasazi.SwigPyIterator_distance(self, x)


    def equal(self, x):
        """equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Anasazi.SwigPyIterator_equal(self, x)


    def copy(self):
        """copy(SwigPyIterator self) -> SwigPyIterator"""
        return _Anasazi.SwigPyIterator_copy(self)


    def next(self):
        """next(SwigPyIterator self) -> PyObject *"""
        return _Anasazi.SwigPyIterator_next(self)


    def __next__(self):
        """__next__(SwigPyIterator self) -> PyObject *"""
        return _Anasazi.SwigPyIterator___next__(self)


    def previous(self):
        """previous(SwigPyIterator self) -> PyObject *"""
        return _Anasazi.SwigPyIterator_previous(self)


    def advance(self, n):
        """advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Anasazi.SwigPyIterator_advance(self, n)


    def __eq__(self, x):
        """__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Anasazi.SwigPyIterator___eq__(self, x)


    def __ne__(self, x):
        """__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _Anasazi.SwigPyIterator___ne__(self, x)


    def __iadd__(self, n):
        """__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Anasazi.SwigPyIterator___iadd__(self, n)


    def __isub__(self, n):
        """__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Anasazi.SwigPyIterator___isub__(self, n)


    def __add__(self, n):
        """__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _Anasazi.SwigPyIterator___add__(self, n)


    def __sub__(self, *args):
        """
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _Anasazi.SwigPyIterator___sub__(self, *args)

    def __iter__(self):
        return self
SwigPyIterator_swigregister = _Anasazi.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

import PyTrilinos.Teuchos
import PyTrilinos.Epetra

def Anasazi_Version(*args):
    """Anasazi_Version() -> std::string"""
    return _Anasazi.Anasazi_Version(*args)

__version__ = Anasazi_Version().split()[2]

class AnasaziError(_object):
    """Proxy of C++ Anasazi::AnasaziError class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, AnasaziError, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, AnasaziError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::AnasaziError self, std::string const & what_arg) -> AnasaziError"""
        this = _Anasazi.new_AnasaziError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_AnasaziError
AnasaziError_swigregister = _Anasazi.AnasaziError_swigregister
AnasaziError_swigregister(AnasaziError)

Converged = _Anasazi.Converged
Unconverged = _Anasazi.Unconverged
NO_CONJ = _Anasazi.NO_CONJ
CONJ = _Anasazi.CONJ
Passed = _Anasazi.Passed
Failed = _Anasazi.Failed
Undefined = _Anasazi.Undefined
RES_ORTH = _Anasazi.RES_ORTH
RES_2NORM = _Anasazi.RES_2NORM
RITZRES_2NORM = _Anasazi.RITZRES_2NORM
Errors = _Anasazi.Errors
Warnings = _Anasazi.Warnings
IterationDetails = _Anasazi.IterationDetails
OrthoDetails = _Anasazi.OrthoDetails
FinalSummary = _Anasazi.FinalSummary
TimingDetails = _Anasazi.TimingDetails
StatusTestDetails = _Anasazi.StatusTestDetails
Debug = _Anasazi.Debug
class ValueDouble(_object):
    """Proxy of C++ Anasazi::Value<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ValueDouble, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ValueDouble, name)
    __repr__ = _swig_repr
    __swig_setmethods__["realpart"] = _Anasazi.ValueDouble_realpart_set
    __swig_getmethods__["realpart"] = _Anasazi.ValueDouble_realpart_get
    if _newclass:
        realpart = _swig_property(_Anasazi.ValueDouble_realpart_get, _Anasazi.ValueDouble_realpart_set)
    __swig_setmethods__["imagpart"] = _Anasazi.ValueDouble_imagpart_set
    __swig_getmethods__["imagpart"] = _Anasazi.ValueDouble_imagpart_get
    if _newclass:
        imagpart = _swig_property(_Anasazi.ValueDouble_imagpart_get, _Anasazi.ValueDouble_imagpart_set)

    def set(self, *args):
        """set(ValueDouble self, Teuchos::ScalarTraits< double >::magnitudeType const & rp, Teuchos::ScalarTraits< double >::magnitudeType const & ip)"""
        return _Anasazi.ValueDouble_set(self, *args)


    def __str__(self, *args):
        """__str__(ValueDouble self) -> std::string"""
        return _Anasazi.ValueDouble___str__(self, *args)


    def __init__(self, *args):
        """__init__(Anasazi::Value<(double)> self) -> ValueDouble"""
        this = _Anasazi.new_ValueDouble(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_ValueDouble
ValueDouble_swigregister = _Anasazi.ValueDouble_swigregister
ValueDouble_swigregister(ValueDouble)

class OutputManagerDouble(_object):
    """Proxy of C++ Anasazi::OutputManager<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, OutputManagerDouble, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, OutputManagerDouble, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_OutputManagerDouble

    def setVerbosity(self, *args):
        """setVerbosity(OutputManagerDouble self, int vb)"""
        return _Anasazi.OutputManagerDouble_setVerbosity(self, *args)


    def getVerbosity(self, *args):
        """getVerbosity(OutputManagerDouble self) -> int"""
        return _Anasazi.OutputManagerDouble_getVerbosity(self, *args)


    def isVerbosity(self, *args):
        """isVerbosity(OutputManagerDouble self, Anasazi::MsgType type) -> bool"""
        return _Anasazi.OutputManagerDouble_isVerbosity(self, *args)


    def stream(self, *args):
        """stream(OutputManagerDouble self, Anasazi::MsgType type) -> std::ostream &"""
        return _Anasazi.OutputManagerDouble_stream(self, *args)

OutputManagerDouble_swigregister = _Anasazi.OutputManagerDouble_swigregister
OutputManagerDouble_swigregister(OutputManagerDouble)

class BasicOutputManagerDouble(OutputManagerDouble):
    """Proxy of C++ Anasazi::BasicOutputManager<(double)> class."""

    __swig_setmethods__ = {}
    for _s in [OutputManagerDouble]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasicOutputManagerDouble, name, value)
    __swig_getmethods__ = {}
    for _s in [OutputManagerDouble]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasicOutputManagerDouble, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::BasicOutputManager<(double)> self, int vb, Teuchos::RCP< Anasazi::ostream > os, int printingRank=0) -> BasicOutputManagerDouble"""
        this = _Anasazi.new_BasicOutputManagerDouble(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BasicOutputManagerDouble

    def setOStream(self, *args):
        """setOStream(BasicOutputManagerDouble self, Teuchos::RCP< Anasazi::ostream > os)"""
        return _Anasazi.BasicOutputManagerDouble_setOStream(self, *args)


    def getOStream(self, *args):
        """getOStream(BasicOutputManagerDouble self) -> Teuchos::RCP< Anasazi::ostream >"""
        return _Anasazi.BasicOutputManagerDouble_getOStream(self, *args)


    def isVerbosity(self, *args):
        """isVerbosity(BasicOutputManagerDouble self, Anasazi::MsgType type) -> bool"""
        return _Anasazi.BasicOutputManagerDouble_isVerbosity(self, *args)


    def stream(self, *args):
        """stream(BasicOutputManagerDouble self, Anasazi::MsgType type) -> Anasazi::ostream &"""
        return _Anasazi.BasicOutputManagerDouble_stream(self, *args)

BasicOutputManagerDouble_swigregister = _Anasazi.BasicOutputManagerDouble_swigregister
BasicOutputManagerDouble_swigregister(BasicOutputManagerDouble)

class SortManagerError(AnasaziError):
    """Proxy of C++ Anasazi::SortManagerError class."""

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SortManagerError, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SortManagerError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::SortManagerError self, std::string const & what_arg) -> SortManagerError"""
        this = _Anasazi.new_SortManagerError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_SortManagerError
SortManagerError_swigregister = _Anasazi.SortManagerError_swigregister
SortManagerError_swigregister(SortManagerError)

class MultiVecDouble(_object):
    """Proxy of C++ Anasazi::MultiVec<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiVecDouble, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MultiVecDouble, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_MultiVecDouble

    def Clone(self, *args):
        """Clone(MultiVecDouble self, int const numvecs) -> MultiVecDouble"""
        return _Anasazi.MultiVecDouble_Clone(self, *args)


    def CloneCopy(self, *args):
        """
        CloneCopy(MultiVecDouble self) -> MultiVecDouble
        CloneCopy(MultiVecDouble self, VectorInt index) -> MultiVecDouble
        """
        return _Anasazi.MultiVecDouble_CloneCopy(self, *args)


    def CloneViewNonConst(self, *args):
        """CloneViewNonConst(MultiVecDouble self, VectorInt index) -> MultiVecDouble"""
        return _Anasazi.MultiVecDouble_CloneViewNonConst(self, *args)


    def CloneView(self, *args):
        """CloneView(MultiVecDouble self, VectorInt index) -> MultiVecDouble"""
        return _Anasazi.MultiVecDouble_CloneView(self, *args)


    def GetGlobalLength(self, *args):
        """GetGlobalLength(MultiVecDouble self) -> ptrdiff_t"""
        return _Anasazi.MultiVecDouble_GetGlobalLength(self, *args)


    def GetNumberVecs(self, *args):
        """GetNumberVecs(MultiVecDouble self) -> int"""
        return _Anasazi.MultiVecDouble_GetNumberVecs(self, *args)


    def MvTimesMatAddMv(self, *args):
        """MvTimesMatAddMv(MultiVecDouble self, double alpha, MultiVecDouble A, Teuchos::SerialDenseMatrix< int,double > const & B, double beta)"""
        return _Anasazi.MultiVecDouble_MvTimesMatAddMv(self, *args)


    def MvAddMv(self, *args):
        """MvAddMv(MultiVecDouble self, double alpha, MultiVecDouble A, double beta, MultiVecDouble B)"""
        return _Anasazi.MultiVecDouble_MvAddMv(self, *args)


    def MvScale(self, *args):
        """
        MvScale(MultiVecDouble self, double alpha)
        MvScale(MultiVecDouble self, std::vector< double,std::allocator< double > > const & alpha)
        """
        return _Anasazi.MultiVecDouble_MvScale(self, *args)


    def MvTransMv(self, *args):
        """MvTransMv(MultiVecDouble self, double alpha, MultiVecDouble A, Teuchos::SerialDenseMatrix< int,double > & B)"""
        return _Anasazi.MultiVecDouble_MvTransMv(self, *args)


    def MvDot(self, *args):
        """MvDot(MultiVecDouble self, MultiVecDouble A, std::vector< double,std::allocator< double > > & b)"""
        return _Anasazi.MultiVecDouble_MvDot(self, *args)


    def MvNorm(self, *args):
        """MvNorm(MultiVecDouble self, std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > > & normvec)"""
        return _Anasazi.MultiVecDouble_MvNorm(self, *args)


    def SetBlock(self, *args):
        """SetBlock(MultiVecDouble self, MultiVecDouble A, VectorInt index)"""
        return _Anasazi.MultiVecDouble_SetBlock(self, *args)


    def MvRandom(self, *args):
        """MvRandom(MultiVecDouble self)"""
        return _Anasazi.MultiVecDouble_MvRandom(self, *args)


    def MvInit(self, *args):
        """MvInit(MultiVecDouble self, double alpha)"""
        return _Anasazi.MultiVecDouble_MvInit(self, *args)


    def MvPrint(self, *args):
        """MvPrint(MultiVecDouble self, std::ostream & os)"""
        return _Anasazi.MultiVecDouble_MvPrint(self, *args)

MultiVecDouble_swigregister = _Anasazi.MultiVecDouble_swigregister
MultiVecDouble_swigregister(MultiVecDouble)

class OperatorError(AnasaziError):
    """Proxy of C++ Anasazi::OperatorError class."""

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OperatorError, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OperatorError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::OperatorError self, std::string const & what_arg) -> OperatorError"""
        this = _Anasazi.new_OperatorError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_OperatorError
OperatorError_swigregister = _Anasazi.OperatorError_swigregister
OperatorError_swigregister(OperatorError)

class OperatorDouble(_object):
    """Proxy of C++ Anasazi::Operator<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, OperatorDouble, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, OperatorDouble, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_OperatorDouble

    def Apply(self, *args):
        """Apply(OperatorDouble self, MultiVecDouble x, MultiVecDouble y)"""
        return _Anasazi.OperatorDouble_Apply(self, *args)

OperatorDouble_swigregister = _Anasazi.OperatorDouble_swigregister
OperatorDouble_swigregister(OperatorDouble)

class StatusTestError(AnasaziError):
    """Proxy of C++ Anasazi::StatusTestError class."""

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StatusTestError, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, StatusTestError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::StatusTestError self, std::string const & what_arg) -> StatusTestError"""
        this = _Anasazi.new_StatusTestError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_StatusTestError
StatusTestError_swigregister = _Anasazi.StatusTestError_swigregister
StatusTestError_swigregister(StatusTestError)

class ResNormNaNError(AnasaziError):
    """Proxy of C++ Anasazi::ResNormNaNError class."""

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResNormNaNError, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResNormNaNError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::ResNormNaNError self, std::string const & what_arg) -> ResNormNaNError"""
        this = _Anasazi.new_ResNormNaNError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_ResNormNaNError
ResNormNaNError_swigregister = _Anasazi.ResNormNaNError_swigregister
ResNormNaNError_swigregister(ResNormNaNError)

class OrthoError(AnasaziError):
    """Proxy of C++ Anasazi::OrthoError class."""

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthoError, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, OrthoError, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::OrthoError self, std::string const & what_arg) -> OrthoError"""
        this = _Anasazi.new_OrthoError(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_OrthoError
OrthoError_swigregister = _Anasazi.OrthoError_swigregister
OrthoError_swigregister(OrthoError)

class BlockDavidsonInitFailure(AnasaziError):
    """Proxy of C++ Anasazi::BlockDavidsonInitFailure class."""

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BlockDavidsonInitFailure, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BlockDavidsonInitFailure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::BlockDavidsonInitFailure self, std::string const & what_arg) -> BlockDavidsonInitFailure"""
        this = _Anasazi.new_BlockDavidsonInitFailure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BlockDavidsonInitFailure
BlockDavidsonInitFailure_swigregister = _Anasazi.BlockDavidsonInitFailure_swigregister
BlockDavidsonInitFailure_swigregister(BlockDavidsonInitFailure)

class BlockDavidsonOrthoFailure(AnasaziError):
    """Proxy of C++ Anasazi::BlockDavidsonOrthoFailure class."""

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BlockDavidsonOrthoFailure, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BlockDavidsonOrthoFailure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::BlockDavidsonOrthoFailure self, std::string const & what_arg) -> BlockDavidsonOrthoFailure"""
        this = _Anasazi.new_BlockDavidsonOrthoFailure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BlockDavidsonOrthoFailure
BlockDavidsonOrthoFailure_swigregister = _Anasazi.BlockDavidsonOrthoFailure_swigregister
BlockDavidsonOrthoFailure_swigregister(BlockDavidsonOrthoFailure)

class BlockKrylovSchurInitFailure(AnasaziError):
    """Proxy of C++ Anasazi::BlockKrylovSchurInitFailure class."""

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BlockKrylovSchurInitFailure, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BlockKrylovSchurInitFailure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::BlockKrylovSchurInitFailure self, std::string const & what_arg) -> BlockKrylovSchurInitFailure"""
        this = _Anasazi.new_BlockKrylovSchurInitFailure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BlockKrylovSchurInitFailure
BlockKrylovSchurInitFailure_swigregister = _Anasazi.BlockKrylovSchurInitFailure_swigregister
BlockKrylovSchurInitFailure_swigregister(BlockKrylovSchurInitFailure)

class BlockKrylovSchurOrthoFailure(AnasaziError):
    """Proxy of C++ Anasazi::BlockKrylovSchurOrthoFailure class."""

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BlockKrylovSchurOrthoFailure, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BlockKrylovSchurOrthoFailure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::BlockKrylovSchurOrthoFailure self, std::string const & what_arg) -> BlockKrylovSchurOrthoFailure"""
        this = _Anasazi.new_BlockKrylovSchurOrthoFailure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BlockKrylovSchurOrthoFailure
BlockKrylovSchurOrthoFailure_swigregister = _Anasazi.BlockKrylovSchurOrthoFailure_swigregister
BlockKrylovSchurOrthoFailure_swigregister(BlockKrylovSchurOrthoFailure)

class LOBPCGRitzFailure(AnasaziError):
    """Proxy of C++ Anasazi::LOBPCGRitzFailure class."""

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LOBPCGRitzFailure, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LOBPCGRitzFailure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::LOBPCGRitzFailure self, std::string const & what_arg) -> LOBPCGRitzFailure"""
        this = _Anasazi.new_LOBPCGRitzFailure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_LOBPCGRitzFailure
LOBPCGRitzFailure_swigregister = _Anasazi.LOBPCGRitzFailure_swigregister
LOBPCGRitzFailure_swigregister(LOBPCGRitzFailure)

class LOBPCGInitFailure(AnasaziError):
    """Proxy of C++ Anasazi::LOBPCGInitFailure class."""

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LOBPCGInitFailure, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LOBPCGInitFailure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::LOBPCGInitFailure self, std::string const & what_arg) -> LOBPCGInitFailure"""
        this = _Anasazi.new_LOBPCGInitFailure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_LOBPCGInitFailure
LOBPCGInitFailure_swigregister = _Anasazi.LOBPCGInitFailure_swigregister
LOBPCGInitFailure_swigregister(LOBPCGInitFailure)

class LOBPCGOrthoFailure(AnasaziError):
    """Proxy of C++ Anasazi::LOBPCGOrthoFailure class."""

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LOBPCGOrthoFailure, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LOBPCGOrthoFailure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::LOBPCGOrthoFailure self, std::string const & what_arg) -> LOBPCGOrthoFailure"""
        this = _Anasazi.new_LOBPCGOrthoFailure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_LOBPCGOrthoFailure
LOBPCGOrthoFailure_swigregister = _Anasazi.LOBPCGOrthoFailure_swigregister
LOBPCGOrthoFailure_swigregister(LOBPCGOrthoFailure)

class EpetraMultiVecFailure(AnasaziError):
    """Proxy of C++ Anasazi::EpetraMultiVecFailure class."""

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraMultiVecFailure, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraMultiVecFailure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::EpetraMultiVecFailure self, std::string const & what_arg) -> EpetraMultiVecFailure"""
        this = _Anasazi.new_EpetraMultiVecFailure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_EpetraMultiVecFailure
EpetraMultiVecFailure_swigregister = _Anasazi.EpetraMultiVecFailure_swigregister
EpetraMultiVecFailure_swigregister(EpetraMultiVecFailure)

class EpetraOpFailure(AnasaziError):
    """Proxy of C++ Anasazi::EpetraOpFailure class."""

    __swig_setmethods__ = {}
    for _s in [AnasaziError]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraOpFailure, name, value)
    __swig_getmethods__ = {}
    for _s in [AnasaziError]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraOpFailure, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::EpetraOpFailure self, std::string const & what_arg) -> EpetraOpFailure"""
        this = _Anasazi.new_EpetraOpFailure(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_EpetraOpFailure
EpetraOpFailure_swigregister = _Anasazi.EpetraOpFailure_swigregister
EpetraOpFailure_swigregister(EpetraOpFailure)

class EpetraMultiVecAccessor(_object):
    """Proxy of C++ Anasazi::EpetraMultiVecAccessor class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraMultiVecAccessor, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraMultiVecAccessor, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_EpetraMultiVecAccessor

    def GetEpetraMultiVec(self, *args):
        """
        GetEpetraMultiVec(EpetraMultiVecAccessor self) -> MultiVector
        GetEpetraMultiVec(EpetraMultiVecAccessor self) -> MultiVector
        """
        return _Anasazi.EpetraMultiVecAccessor_GetEpetraMultiVec(self, *args)


    def __init__(self, *args):
        """__init__(Anasazi::EpetraMultiVecAccessor self) -> EpetraMultiVecAccessor"""
        this = _Anasazi.new_EpetraMultiVecAccessor(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
EpetraMultiVecAccessor_swigregister = _Anasazi.EpetraMultiVecAccessor_swigregister
EpetraMultiVecAccessor_swigregister(EpetraMultiVecAccessor)

class EpetraMultiVec(MultiVecDouble, PyTrilinos.Epetra.MultiVector, EpetraMultiVecAccessor):
    """Proxy of C++ Anasazi::EpetraMultiVec class."""

    __swig_setmethods__ = {}
    for _s in [MultiVecDouble, PyTrilinos.Epetra.MultiVector, EpetraMultiVecAccessor]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraMultiVec, name, value)
    __swig_getmethods__ = {}
    for _s in [MultiVecDouble, PyTrilinos.Epetra.MultiVector, EpetraMultiVecAccessor]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraMultiVec, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::EpetraMultiVec self, BlockMap Map_in, int const numvecs) -> EpetraMultiVec
        __init__(Anasazi::EpetraMultiVec self, MultiVector P_vec) -> EpetraMultiVec
        __init__(Anasazi::EpetraMultiVec self, BlockMap Map_in, double * array, int const numvecs, int const stride=0) -> EpetraMultiVec
        __init__(Anasazi::EpetraMultiVec self, Epetra_DataAccess CV, MultiVector P_vec, VectorInt index) -> EpetraMultiVec
        """
        this = _Anasazi.new_EpetraMultiVec(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_EpetraMultiVec

    def Clone(self, *args):
        """Clone(EpetraMultiVec self, int const numvecs) -> MultiVecDouble"""
        return _Anasazi.EpetraMultiVec_Clone(self, *args)


    def CloneCopy(self, *args):
        """
        CloneCopy(EpetraMultiVec self) -> MultiVecDouble
        CloneCopy(EpetraMultiVec self, VectorInt index) -> MultiVecDouble
        """
        return _Anasazi.EpetraMultiVec_CloneCopy(self, *args)


    def CloneViewNonConst(self, *args):
        """CloneViewNonConst(EpetraMultiVec self, VectorInt index) -> MultiVecDouble"""
        return _Anasazi.EpetraMultiVec_CloneViewNonConst(self, *args)


    def CloneView(self, *args):
        """CloneView(EpetraMultiVec self, VectorInt index) -> MultiVecDouble"""
        return _Anasazi.EpetraMultiVec_CloneView(self, *args)


    def GetGlobalLength(self, *args):
        """GetGlobalLength(EpetraMultiVec self) -> ptrdiff_t"""
        return _Anasazi.EpetraMultiVec_GetGlobalLength(self, *args)


    def GetNumberVecs(self, *args):
        """GetNumberVecs(EpetraMultiVec self) -> int"""
        return _Anasazi.EpetraMultiVec_GetNumberVecs(self, *args)


    def MvTimesMatAddMv(self, *args):
        """MvTimesMatAddMv(EpetraMultiVec self, double alpha, MultiVecDouble A, Teuchos::SerialDenseMatrix< int,double > const & B, double beta)"""
        return _Anasazi.EpetraMultiVec_MvTimesMatAddMv(self, *args)


    def MvAddMv(self, *args):
        """MvAddMv(EpetraMultiVec self, double alpha, MultiVecDouble A, double beta, MultiVecDouble B)"""
        return _Anasazi.EpetraMultiVec_MvAddMv(self, *args)


    def MvTransMv(self, *args):
        """MvTransMv(EpetraMultiVec self, double alpha, MultiVecDouble A, Teuchos::SerialDenseMatrix< int,double > & B)"""
        return _Anasazi.EpetraMultiVec_MvTransMv(self, *args)


    def MvDot(self, *args):
        """MvDot(EpetraMultiVec self, MultiVecDouble A, std::vector< double,std::allocator< double > > & b)"""
        return _Anasazi.EpetraMultiVec_MvDot(self, *args)


    def MvScale(self, *args):
        """
        MvScale(EpetraMultiVec self, double alpha)
        MvScale(EpetraMultiVec self, std::vector< double,std::allocator< double > > const & alpha)
        """
        return _Anasazi.EpetraMultiVec_MvScale(self, *args)


    def MvNorm(self, *args):
        """MvNorm(EpetraMultiVec self, std::vector< double,std::allocator< double > > & normvec)"""
        return _Anasazi.EpetraMultiVec_MvNorm(self, *args)


    def SetBlock(self, *args):
        """SetBlock(EpetraMultiVec self, MultiVecDouble A, VectorInt index)"""
        return _Anasazi.EpetraMultiVec_SetBlock(self, *args)


    def MvRandom(self, *args):
        """MvRandom(EpetraMultiVec self)"""
        return _Anasazi.EpetraMultiVec_MvRandom(self, *args)


    def MvInit(self, *args):
        """MvInit(EpetraMultiVec self, double alpha)"""
        return _Anasazi.EpetraMultiVec_MvInit(self, *args)


    def GetEpetraMultiVec(self, *args):
        """
        GetEpetraMultiVec(EpetraMultiVec self) -> MultiVector
        GetEpetraMultiVec(EpetraMultiVec self) -> MultiVector
        """
        return _Anasazi.EpetraMultiVec_GetEpetraMultiVec(self, *args)


    def MvPrint(self, *args):
        """MvPrint(EpetraMultiVec self, std::ostream & os)"""
        return _Anasazi.EpetraMultiVec_MvPrint(self, *args)

EpetraMultiVec_swigregister = _Anasazi.EpetraMultiVec_swigregister
EpetraMultiVec_swigregister(EpetraMultiVec)

class EpetraOp(OperatorDouble):
    """Proxy of C++ Anasazi::EpetraOp class."""

    __swig_setmethods__ = {}
    for _s in [OperatorDouble]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraOp, name, value)
    __swig_getmethods__ = {}
    for _s in [OperatorDouble]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraOp, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::EpetraOp self, Teuchos::RCP< Epetra_Operator > const & Op) -> EpetraOp"""
        this = _Anasazi.new_EpetraOp(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_EpetraOp

    def Apply(self, *args):
        """Apply(EpetraOp self, MultiVecDouble X, MultiVecDouble Y)"""
        return _Anasazi.EpetraOp_Apply(self, *args)

EpetraOp_swigregister = _Anasazi.EpetraOp_swigregister
EpetraOp_swigregister(EpetraOp)

class EpetraGenOp(OperatorDouble, PyTrilinos.Epetra.Operator):
    """Proxy of C++ Anasazi::EpetraGenOp class."""

    __swig_setmethods__ = {}
    for _s in [OperatorDouble, PyTrilinos.Epetra.Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraGenOp, name, value)
    __swig_getmethods__ = {}
    for _s in [OperatorDouble, PyTrilinos.Epetra.Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraGenOp, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::EpetraGenOp self, Teuchos::RCP< Epetra_Operator > const & AOp, Teuchos::RCP< Epetra_Operator > const & MOp, bool isAInverse=True) -> EpetraGenOp"""
        this = _Anasazi.new_EpetraGenOp(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_EpetraGenOp

    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        """
        return _Anasazi.EpetraGenOp_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.

        """
        return _Anasazi.EpetraGenOp_ApplyInverse(self, *args)


    def Label(self, *args):
        """Label(EpetraGenOp self) -> char const *"""
        return _Anasazi.EpetraGenOp_Label(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(EpetraGenOp self) -> bool"""
        return _Anasazi.EpetraGenOp_UseTranspose(self, *args)


    def SetUseTranspose(self, *args):
        """SetUseTranspose(EpetraGenOp self, bool arg2) -> int"""
        return _Anasazi.EpetraGenOp_SetUseTranspose(self, *args)


    def HasNormInf(self, *args):
        """HasNormInf(EpetraGenOp self) -> bool"""
        return _Anasazi.EpetraGenOp_HasNormInf(self, *args)


    def NormInf(self, *args):
        """NormInf(EpetraGenOp self) -> double"""
        return _Anasazi.EpetraGenOp_NormInf(self, *args)


    def Comm(self, *args):
        """Comm(EpetraGenOp self) -> Comm"""
        return _Anasazi.EpetraGenOp_Comm(self, *args)


    def OperatorDomainMap(self, *args):
        """OperatorDomainMap(EpetraGenOp self) -> Map"""
        return _Anasazi.EpetraGenOp_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """OperatorRangeMap(EpetraGenOp self) -> Map"""
        return _Anasazi.EpetraGenOp_OperatorRangeMap(self, *args)

EpetraGenOp_swigregister = _Anasazi.EpetraGenOp_swigregister
EpetraGenOp_swigregister(EpetraGenOp)

class EpetraSymOp(OperatorDouble, PyTrilinos.Epetra.Operator):
    """Proxy of C++ Anasazi::EpetraSymOp class."""

    __swig_setmethods__ = {}
    for _s in [OperatorDouble, PyTrilinos.Epetra.Operator]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraSymOp, name, value)
    __swig_getmethods__ = {}
    for _s in [OperatorDouble, PyTrilinos.Epetra.Operator]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraSymOp, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::EpetraSymOp self, Teuchos::RCP< Epetra_Operator > const & Op, bool isTrans=False) -> EpetraSymOp"""
        this = _Anasazi.new_EpetraSymOp(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_EpetraSymOp

    def Apply(self, *args):
        """
        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        Apply(self, MultiVector x, MultiVector y) -> int

        In C++, the Apply() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the Apply() method.  C++ code (e.g., AztecOO
        solvers) can call back to your Apply() method as needed.  You must
        support two arguments, labeled here MultiVector x and MultiVector y.
        These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent Apply() from raising any
        exceptions.  Accidental errors can be prevented by wrapping your code
        in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method Apply:'
                print e
                return -1

        By returning a -1, you inform the calling routine that Apply() was
        unsuccessful.

        """
        return _Anasazi.EpetraSymOp_Apply(self, *args)


    def ApplyInverse(self, *args):
        """
        ApplyInverse(self, MultiVector x, MultiVector y) -> int

        In C++, the ApplyInverse() method is pure virtual, thus intended to be
        overridden by derived classes.  In python, cross-language polymorphism
        is supported, and you are expected to derive classes from this base
        class and redefine the ApplyInverse() method.  C++ code (e.g., AztecOO
        solvers) can call back to your ApplyInverse() method as needed.  You
        must support two arguments, labeled here MultiVector x and MultiVector
        y.  These will be converted from Epetra_MultiVector C++ objects to
        numpy-hybrid Epetra.MultiVector objects before they are passed to you.
        Thus, it is legal to use slice indexing and other numpy features to
        compute y from x.

        If application of your operator is successful, return 0; else return
        some non-zero error code.

        It is strongly suggested that you prevent ApplyInverse() from raising
        any exceptions.  Accidental errors can be prevented by wrapping your
        code in a try block:

            try:
                # Your code goes here...
            except Exception, e:
                print 'A python exception was raised by method ApplyInverse:'
                print e
                return -1

        By returning a -1, you inform the calling routine that ApplyInverse()
        was unsuccessful.

        """
        return _Anasazi.EpetraSymOp_ApplyInverse(self, *args)


    def Label(self, *args):
        """Label(EpetraSymOp self) -> char const *"""
        return _Anasazi.EpetraSymOp_Label(self, *args)


    def UseTranspose(self, *args):
        """UseTranspose(EpetraSymOp self) -> bool"""
        return _Anasazi.EpetraSymOp_UseTranspose(self, *args)


    def SetUseTranspose(self, *args):
        """SetUseTranspose(EpetraSymOp self, bool arg2) -> int"""
        return _Anasazi.EpetraSymOp_SetUseTranspose(self, *args)


    def HasNormInf(self, *args):
        """HasNormInf(EpetraSymOp self) -> bool"""
        return _Anasazi.EpetraSymOp_HasNormInf(self, *args)


    def NormInf(self, *args):
        """NormInf(EpetraSymOp self) -> double"""
        return _Anasazi.EpetraSymOp_NormInf(self, *args)


    def Comm(self, *args):
        """Comm(EpetraSymOp self) -> Comm"""
        return _Anasazi.EpetraSymOp_Comm(self, *args)


    def OperatorDomainMap(self, *args):
        """OperatorDomainMap(EpetraSymOp self) -> Map"""
        return _Anasazi.EpetraSymOp_OperatorDomainMap(self, *args)


    def OperatorRangeMap(self, *args):
        """OperatorRangeMap(EpetraSymOp self) -> Map"""
        return _Anasazi.EpetraSymOp_OperatorRangeMap(self, *args)

EpetraSymOp_swigregister = _Anasazi.EpetraSymOp_swigregister
EpetraSymOp_swigregister(EpetraSymOp)

class EpetraSymMVOp(OperatorDouble):
    """Proxy of C++ Anasazi::EpetraSymMVOp class."""

    __swig_setmethods__ = {}
    for _s in [OperatorDouble]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraSymMVOp, name, value)
    __swig_getmethods__ = {}
    for _s in [OperatorDouble]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraSymMVOp, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::EpetraSymMVOp self, Teuchos::RCP< Epetra_MultiVector const > const & MV, bool isTrans=False) -> EpetraSymMVOp"""
        this = _Anasazi.new_EpetraSymMVOp(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_EpetraSymMVOp

    def Apply(self, *args):
        """Apply(EpetraSymMVOp self, MultiVecDouble X, MultiVecDouble Y)"""
        return _Anasazi.EpetraSymMVOp_Apply(self, *args)

EpetraSymMVOp_swigregister = _Anasazi.EpetraSymMVOp_swigregister
EpetraSymMVOp_swigregister(EpetraSymMVOp)

class EpetraWSymMVOp(OperatorDouble):
    """Proxy of C++ Anasazi::EpetraWSymMVOp class."""

    __swig_setmethods__ = {}
    for _s in [OperatorDouble]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraWSymMVOp, name, value)
    __swig_getmethods__ = {}
    for _s in [OperatorDouble]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraWSymMVOp, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::EpetraWSymMVOp self, Teuchos::RCP< Epetra_MultiVector const > const & MV, Teuchos::RCP< Epetra_Operator > const & OP) -> EpetraWSymMVOp"""
        this = _Anasazi.new_EpetraWSymMVOp(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_EpetraWSymMVOp

    def Apply(self, *args):
        """Apply(EpetraWSymMVOp self, MultiVecDouble X, MultiVecDouble Y)"""
        return _Anasazi.EpetraWSymMVOp_Apply(self, *args)

EpetraWSymMVOp_swigregister = _Anasazi.EpetraWSymMVOp_swigregister
EpetraWSymMVOp_swigregister(EpetraWSymMVOp)

class EpetraW2SymMVOp(OperatorDouble):
    """Proxy of C++ Anasazi::EpetraW2SymMVOp class."""

    __swig_setmethods__ = {}
    for _s in [OperatorDouble]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EpetraW2SymMVOp, name, value)
    __swig_getmethods__ = {}
    for _s in [OperatorDouble]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EpetraW2SymMVOp, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::EpetraW2SymMVOp self, Teuchos::RCP< Epetra_MultiVector const > const & MV, Teuchos::RCP< Epetra_Operator > const & OP) -> EpetraW2SymMVOp"""
        this = _Anasazi.new_EpetraW2SymMVOp(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_EpetraW2SymMVOp

    def Apply(self, *args):
        """Apply(EpetraW2SymMVOp self, MultiVecDouble X, MultiVecDouble Y)"""
        return _Anasazi.EpetraW2SymMVOp_Apply(self, *args)

EpetraW2SymMVOp_swigregister = _Anasazi.EpetraW2SymMVOp_swigregister
EpetraW2SymMVOp_swigregister(EpetraW2SymMVOp)

class SortManagerEpetra(_object):
    """Proxy of C++ Anasazi::SortManager<(double)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SortManagerEpetra, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SortManagerEpetra, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_SortManagerEpetra

    def sort(self, *args):
        """
        sort(SortManagerEpetra self, std::vector< double,std::allocator< double > > & evals, Teuchos::RCP< std::vector< int,std::allocator< int > > > perm, int n=-1)
        sort(SortManagerEpetra self, std::vector< double,std::allocator< double > > & r_evals, std::vector< double,std::allocator< double > > & i_evals, Teuchos::RCP< std::vector< int,std::allocator< int > > > perm, int n=-1)
        """
        return _Anasazi.SortManagerEpetra_sort(self, *args)

SortManagerEpetra_swigregister = _Anasazi.SortManagerEpetra_swigregister
SortManagerEpetra_swigregister(SortManagerEpetra)

class BasicSortEpetra(SortManagerEpetra):
    """Proxy of C++ Anasazi::BasicSort<(double)> class."""

    __swig_setmethods__ = {}
    for _s in [SortManagerEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasicSortEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [SortManagerEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasicSortEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::BasicSort<(double)> self, ParameterList pl) -> BasicSortEpetra
        __init__(Anasazi::BasicSort<(double)> self, std::string const & which) -> BasicSortEpetra
        """
        this = _Anasazi.new_BasicSortEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BasicSortEpetra

    def setSortType(self, *args):
        """setSortType(BasicSortEpetra self, std::string const & which)"""
        return _Anasazi.BasicSortEpetra_setSortType(self, *args)


    def sort(self, *args):
        """
        sort(BasicSortEpetra self, std::vector< double,std::allocator< double > > & evals, Teuchos::RCP< std::vector< int,std::allocator< int > > > perm, int n=-1)
        sort(BasicSortEpetra self, std::vector< double,std::allocator< double > > & r_evals, std::vector< double,std::allocator< double > > & i_evals, Teuchos::RCP< std::vector< int,std::allocator< int > > > perm, int n=-1)
        """
        return _Anasazi.BasicSortEpetra_sort(self, *args)

BasicSortEpetra_swigregister = _Anasazi.BasicSortEpetra_swigregister
BasicSortEpetra_swigregister(BasicSortEpetra)

class MultiVecTraitsEpetra(_object):
    """Proxy of C++ Anasazi::MultiVecTraits<(double,Epetra_MultiVector)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultiVecTraitsEpetra, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MultiVecTraitsEpetra, name)
    __repr__ = _swig_repr

    def Clone(*args):
        """Clone(MultiVector mv, int const outNumVecs) -> Teuchos::RCP< Epetra_MultiVector >"""
        return _Anasazi.MultiVecTraitsEpetra_Clone(*args)

    Clone = staticmethod(Clone)

    def CloneCopy(*args):
        """
        CloneCopy(MultiVector mv) -> Teuchos::RCP< Epetra_MultiVector >
        CloneCopy(MultiVector mv, VectorInt index) -> Teuchos::RCP< Epetra_MultiVector >
        CloneCopy(MultiVector mv, Teuchos::Range1D const & index) -> Teuchos::RCP< Epetra_MultiVector >
        """
        return _Anasazi.MultiVecTraitsEpetra_CloneCopy(*args)

    CloneCopy = staticmethod(CloneCopy)

    def CloneViewNonConst(*args):
        """
        CloneViewNonConst(MultiVector mv, VectorInt index) -> Teuchos::RCP< Epetra_MultiVector >
        CloneViewNonConst(MultiVector mv, Teuchos::Range1D const & index) -> Teuchos::RCP< Epetra_MultiVector >
        """
        return _Anasazi.MultiVecTraitsEpetra_CloneViewNonConst(*args)

    CloneViewNonConst = staticmethod(CloneViewNonConst)

    def CloneView(*args):
        """CloneView(MultiVector mv, Teuchos::Range1D const & index) -> Teuchos::RCP< Epetra_MultiVector >"""
        return _Anasazi.MultiVecTraitsEpetra_CloneView(*args)

    CloneView = staticmethod(CloneView)

    def GetGlobalLength(*args):
        """GetGlobalLength(MultiVector mv) -> ptrdiff_t"""
        return _Anasazi.MultiVecTraitsEpetra_GetGlobalLength(*args)

    GetGlobalLength = staticmethod(GetGlobalLength)

    def GetNumberVecs(*args):
        """GetNumberVecs(MultiVector mv) -> int"""
        return _Anasazi.MultiVecTraitsEpetra_GetNumberVecs(*args)

    GetNumberVecs = staticmethod(GetNumberVecs)

    def HasConstantStride(*args):
        """HasConstantStride(MultiVector mv) -> bool"""
        return _Anasazi.MultiVecTraitsEpetra_HasConstantStride(*args)

    HasConstantStride = staticmethod(HasConstantStride)

    def MvTimesMatAddMv(*args):
        """MvTimesMatAddMv(double alpha, MultiVector A, Teuchos::SerialDenseMatrix< int,double > const & B, double beta, MultiVector mv)"""
        return _Anasazi.MultiVecTraitsEpetra_MvTimesMatAddMv(*args)

    MvTimesMatAddMv = staticmethod(MvTimesMatAddMv)

    def MvAddMv(*args):
        """MvAddMv(double alpha, MultiVector A, double beta, MultiVector B, MultiVector mv)"""
        return _Anasazi.MultiVecTraitsEpetra_MvAddMv(*args)

    MvAddMv = staticmethod(MvAddMv)

    def MvTransMv(*args):
        """MvTransMv(double alpha, MultiVector A, MultiVector mv, Teuchos::SerialDenseMatrix< int,double > & B)"""
        return _Anasazi.MultiVecTraitsEpetra_MvTransMv(*args)

    MvTransMv = staticmethod(MvTransMv)

    def MvDot(*args):
        """MvDot(MultiVector A, MultiVector B, std::vector< double,std::allocator< double > > & b)"""
        return _Anasazi.MultiVecTraitsEpetra_MvDot(*args)

    MvDot = staticmethod(MvDot)

    def MvNorm(*args):
        """MvNorm(MultiVector mv, std::vector< double,std::allocator< double > > & normvec)"""
        return _Anasazi.MultiVecTraitsEpetra_MvNorm(*args)

    MvNorm = staticmethod(MvNorm)

    def SetBlock(*args):
        """
        SetBlock(MultiVector A, VectorInt index, MultiVector mv)
        SetBlock(MultiVector A, Teuchos::Range1D const & index, MultiVector mv)
        """
        return _Anasazi.MultiVecTraitsEpetra_SetBlock(*args)

    SetBlock = staticmethod(SetBlock)

    def Assign(*args):
        """Assign(MultiVector A, MultiVector mv)"""
        return _Anasazi.MultiVecTraitsEpetra_Assign(*args)

    Assign = staticmethod(Assign)

    def MvScale(*args):
        """
        MvScale(MultiVector mv, double alpha)
        MvScale(MultiVector mv, std::vector< double,std::allocator< double > > const & alpha)
        """
        return _Anasazi.MultiVecTraitsEpetra_MvScale(*args)

    MvScale = staticmethod(MvScale)

    def MvRandom(*args):
        """MvRandom(MultiVector mv)"""
        return _Anasazi.MultiVecTraitsEpetra_MvRandom(*args)

    MvRandom = staticmethod(MvRandom)

    def MvInit(*args):
        """MvInit(MultiVector mv, double alpha)"""
        return _Anasazi.MultiVecTraitsEpetra_MvInit(*args)

    MvInit = staticmethod(MvInit)

    def MvPrint(*args):
        """MvPrint(MultiVector mv, std::ostream & os)"""
        return _Anasazi.MultiVecTraitsEpetra_MvPrint(*args)

    MvPrint = staticmethod(MvPrint)

    def __init__(self, *args):
        """__init__(Anasazi::MultiVecTraits<(double,Epetra_MultiVector)> self) -> MultiVecTraitsEpetra"""
        this = _Anasazi.new_MultiVecTraitsEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_MultiVecTraitsEpetra
MultiVecTraitsEpetra_swigregister = _Anasazi.MultiVecTraitsEpetra_swigregister
MultiVecTraitsEpetra_swigregister(MultiVecTraitsEpetra)

def MultiVecTraitsEpetra_Clone(*args):
    """MultiVecTraitsEpetra_Clone(MultiVector mv, int const outNumVecs) -> Teuchos::RCP< Epetra_MultiVector >"""
    return _Anasazi.MultiVecTraitsEpetra_Clone(*args)

def MultiVecTraitsEpetra_CloneCopy(*args):
    """
    CloneCopy(MultiVector mv) -> Teuchos::RCP< Epetra_MultiVector >
    CloneCopy(MultiVector mv, VectorInt index) -> Teuchos::RCP< Epetra_MultiVector >
    MultiVecTraitsEpetra_CloneCopy(MultiVector mv, Teuchos::Range1D const & index) -> Teuchos::RCP< Epetra_MultiVector >
    """
    return _Anasazi.MultiVecTraitsEpetra_CloneCopy(*args)

def MultiVecTraitsEpetra_CloneViewNonConst(*args):
    """
    CloneViewNonConst(MultiVector mv, VectorInt index) -> Teuchos::RCP< Epetra_MultiVector >
    MultiVecTraitsEpetra_CloneViewNonConst(MultiVector mv, Teuchos::Range1D const & index) -> Teuchos::RCP< Epetra_MultiVector >
    """
    return _Anasazi.MultiVecTraitsEpetra_CloneViewNonConst(*args)

def MultiVecTraitsEpetra_CloneView(*args):
    """MultiVecTraitsEpetra_CloneView(MultiVector mv, Teuchos::Range1D const & index) -> Teuchos::RCP< Epetra_MultiVector >"""
    return _Anasazi.MultiVecTraitsEpetra_CloneView(*args)

def MultiVecTraitsEpetra_GetGlobalLength(*args):
    """MultiVecTraitsEpetra_GetGlobalLength(MultiVector mv) -> ptrdiff_t"""
    return _Anasazi.MultiVecTraitsEpetra_GetGlobalLength(*args)

def MultiVecTraitsEpetra_GetNumberVecs(*args):
    """MultiVecTraitsEpetra_GetNumberVecs(MultiVector mv) -> int"""
    return _Anasazi.MultiVecTraitsEpetra_GetNumberVecs(*args)

def MultiVecTraitsEpetra_HasConstantStride(*args):
    """MultiVecTraitsEpetra_HasConstantStride(MultiVector mv) -> bool"""
    return _Anasazi.MultiVecTraitsEpetra_HasConstantStride(*args)

def MultiVecTraitsEpetra_MvTimesMatAddMv(*args):
    """MultiVecTraitsEpetra_MvTimesMatAddMv(double alpha, MultiVector A, Teuchos::SerialDenseMatrix< int,double > const & B, double beta, MultiVector mv)"""
    return _Anasazi.MultiVecTraitsEpetra_MvTimesMatAddMv(*args)

def MultiVecTraitsEpetra_MvAddMv(*args):
    """MultiVecTraitsEpetra_MvAddMv(double alpha, MultiVector A, double beta, MultiVector B, MultiVector mv)"""
    return _Anasazi.MultiVecTraitsEpetra_MvAddMv(*args)

def MultiVecTraitsEpetra_MvTransMv(*args):
    """MultiVecTraitsEpetra_MvTransMv(double alpha, MultiVector A, MultiVector mv, Teuchos::SerialDenseMatrix< int,double > & B)"""
    return _Anasazi.MultiVecTraitsEpetra_MvTransMv(*args)

def MultiVecTraitsEpetra_MvDot(*args):
    """MultiVecTraitsEpetra_MvDot(MultiVector A, MultiVector B, std::vector< double,std::allocator< double > > & b)"""
    return _Anasazi.MultiVecTraitsEpetra_MvDot(*args)

def MultiVecTraitsEpetra_MvNorm(*args):
    """MultiVecTraitsEpetra_MvNorm(MultiVector mv, std::vector< double,std::allocator< double > > & normvec)"""
    return _Anasazi.MultiVecTraitsEpetra_MvNorm(*args)

def MultiVecTraitsEpetra_SetBlock(*args):
    """
    SetBlock(MultiVector A, VectorInt index, MultiVector mv)
    MultiVecTraitsEpetra_SetBlock(MultiVector A, Teuchos::Range1D const & index, MultiVector mv)
    """
    return _Anasazi.MultiVecTraitsEpetra_SetBlock(*args)

def MultiVecTraitsEpetra_Assign(*args):
    """MultiVecTraitsEpetra_Assign(MultiVector A, MultiVector mv)"""
    return _Anasazi.MultiVecTraitsEpetra_Assign(*args)

def MultiVecTraitsEpetra_MvScale(*args):
    """
    MvScale(MultiVector mv, double alpha)
    MultiVecTraitsEpetra_MvScale(MultiVector mv, std::vector< double,std::allocator< double > > const & alpha)
    """
    return _Anasazi.MultiVecTraitsEpetra_MvScale(*args)

def MultiVecTraitsEpetra_MvRandom(*args):
    """MultiVecTraitsEpetra_MvRandom(MultiVector mv)"""
    return _Anasazi.MultiVecTraitsEpetra_MvRandom(*args)

def MultiVecTraitsEpetra_MvInit(*args):
    """MultiVecTraitsEpetra_MvInit(MultiVector mv, double alpha)"""
    return _Anasazi.MultiVecTraitsEpetra_MvInit(*args)

def MultiVecTraitsEpetra_MvPrint(*args):
    """MultiVecTraitsEpetra_MvPrint(MultiVector mv, std::ostream & os)"""
    return _Anasazi.MultiVecTraitsEpetra_MvPrint(*args)

class OperatorTraitsEpetra(_object):
    """Proxy of C++ Anasazi::OperatorTraits<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, OperatorTraitsEpetra, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, OperatorTraitsEpetra, name)
    __repr__ = _swig_repr

    def Apply(*args):
        """Apply(Operator Op, MultiVector x, MultiVector y)"""
        return _Anasazi.OperatorTraitsEpetra_Apply(*args)

    Apply = staticmethod(Apply)

    def __init__(self, *args):
        """__init__(Anasazi::OperatorTraits<(double,Epetra_MultiVector,Epetra_Operator)> self) -> OperatorTraitsEpetra"""
        this = _Anasazi.new_OperatorTraitsEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_OperatorTraitsEpetra
OperatorTraitsEpetra_swigregister = _Anasazi.OperatorTraitsEpetra_swigregister
OperatorTraitsEpetra_swigregister(OperatorTraitsEpetra)

def OperatorTraitsEpetra_Apply(*args):
    """OperatorTraitsEpetra_Apply(Operator Op, MultiVector x, MultiVector y)"""
    return _Anasazi.OperatorTraitsEpetra_Apply(*args)

class EigenproblemEpetra(_object):
    """Proxy of C++ Anasazi::Eigenproblem<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, EigenproblemEpetra, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, EigenproblemEpetra, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_EigenproblemEpetra

    def setOperator(self, *args):
        """setOperator(EigenproblemEpetra self, Teuchos::RCP< Epetra_Operator const > const & Op)"""
        return _Anasazi.EigenproblemEpetra_setOperator(self, *args)


    def setA(self, *args):
        """setA(EigenproblemEpetra self, Teuchos::RCP< Epetra_Operator const > const & A)"""
        return _Anasazi.EigenproblemEpetra_setA(self, *args)


    def setM(self, *args):
        """setM(EigenproblemEpetra self, Teuchos::RCP< Epetra_Operator const > const & M)"""
        return _Anasazi.EigenproblemEpetra_setM(self, *args)


    def setPrec(self, *args):
        """setPrec(EigenproblemEpetra self, Teuchos::RCP< Epetra_Operator const > const & Prec)"""
        return _Anasazi.EigenproblemEpetra_setPrec(self, *args)


    def setInitVec(self, *args):
        """setInitVec(EigenproblemEpetra self, Teuchos::RCP< Epetra_MultiVector > const & InitVec)"""
        return _Anasazi.EigenproblemEpetra_setInitVec(self, *args)


    def setAuxVecs(self, *args):
        """setAuxVecs(EigenproblemEpetra self, Teuchos::RCP< Epetra_MultiVector const > const & AuxVecs)"""
        return _Anasazi.EigenproblemEpetra_setAuxVecs(self, *args)


    def setNEV(self, *args):
        """setNEV(EigenproblemEpetra self, int nev)"""
        return _Anasazi.EigenproblemEpetra_setNEV(self, *args)


    def setHermitian(self, *args):
        """setHermitian(EigenproblemEpetra self, bool isSym)"""
        return _Anasazi.EigenproblemEpetra_setHermitian(self, *args)


    def setProblem(self, *args):
        """setProblem(EigenproblemEpetra self) -> bool"""
        return _Anasazi.EigenproblemEpetra_setProblem(self, *args)


    def setSolution(self, *args):
        """setSolution(EigenproblemEpetra self, EigensolutionEpetra sol)"""
        return _Anasazi.EigenproblemEpetra_setSolution(self, *args)


    def getOperator(self, *args):
        """getOperator(EigenproblemEpetra self) -> Teuchos::RCP< Epetra_Operator const >"""
        return _Anasazi.EigenproblemEpetra_getOperator(self, *args)


    def getA(self, *args):
        """getA(EigenproblemEpetra self) -> Teuchos::RCP< Epetra_Operator const >"""
        return _Anasazi.EigenproblemEpetra_getA(self, *args)


    def getM(self, *args):
        """getM(EigenproblemEpetra self) -> Teuchos::RCP< Epetra_Operator const >"""
        return _Anasazi.EigenproblemEpetra_getM(self, *args)


    def getPrec(self, *args):
        """getPrec(EigenproblemEpetra self) -> Teuchos::RCP< Epetra_Operator const >"""
        return _Anasazi.EigenproblemEpetra_getPrec(self, *args)


    def getInitVec(self, *args):
        """getInitVec(EigenproblemEpetra self) -> Teuchos::RCP< Epetra_MultiVector const >"""
        return _Anasazi.EigenproblemEpetra_getInitVec(self, *args)


    def getAuxVecs(self, *args):
        """getAuxVecs(EigenproblemEpetra self) -> Teuchos::RCP< Epetra_MultiVector const >"""
        return _Anasazi.EigenproblemEpetra_getAuxVecs(self, *args)


    def getNEV(self, *args):
        """getNEV(EigenproblemEpetra self) -> int"""
        return _Anasazi.EigenproblemEpetra_getNEV(self, *args)


    def isHermitian(self, *args):
        """isHermitian(EigenproblemEpetra self) -> bool"""
        return _Anasazi.EigenproblemEpetra_isHermitian(self, *args)


    def isProblemSet(self, *args):
        """isProblemSet(EigenproblemEpetra self) -> bool"""
        return _Anasazi.EigenproblemEpetra_isProblemSet(self, *args)


    def getSolution(self, *args):
        """getSolution(EigenproblemEpetra self) -> EigensolutionEpetra"""
        return _Anasazi.EigenproblemEpetra_getSolution(self, *args)

EigenproblemEpetra_swigregister = _Anasazi.EigenproblemEpetra_swigregister
EigenproblemEpetra_swigregister(EigenproblemEpetra)

class BasicEigenproblemEpetra(EigenproblemEpetra):
    """Proxy of C++ Anasazi::BasicEigenproblem<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    for _s in [EigenproblemEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasicEigenproblemEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [EigenproblemEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasicEigenproblemEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        __init__(Anasazi::BasicEigenproblem<(double,Epetra_MultiVector,Epetra_Operator)> self) -> BasicEigenproblemEpetra
        __init__(Anasazi::BasicEigenproblem<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Epetra_Operator const > const & Op, Teuchos::RCP< Epetra_MultiVector > const & InitVec) -> BasicEigenproblemEpetra
        __init__(Anasazi::BasicEigenproblem<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Epetra_Operator const > const & Op, Teuchos::RCP< Epetra_Operator const > const & B, Teuchos::RCP< Epetra_MultiVector > const & InitVec) -> BasicEigenproblemEpetra
        __init__(Anasazi::BasicEigenproblem<(double,Epetra_MultiVector,Epetra_Operator)> self, BasicEigenproblemEpetra Problem) -> BasicEigenproblemEpetra
        """
        this = _Anasazi.new_BasicEigenproblemEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BasicEigenproblemEpetra

    def setOperator(self, *args):
        """setOperator(BasicEigenproblemEpetra self, Teuchos::RCP< Epetra_Operator const > const & Op)"""
        return _Anasazi.BasicEigenproblemEpetra_setOperator(self, *args)


    def setA(self, *args):
        """setA(BasicEigenproblemEpetra self, Teuchos::RCP< Epetra_Operator const > const & A)"""
        return _Anasazi.BasicEigenproblemEpetra_setA(self, *args)


    def setM(self, *args):
        """setM(BasicEigenproblemEpetra self, Teuchos::RCP< Epetra_Operator const > const & M)"""
        return _Anasazi.BasicEigenproblemEpetra_setM(self, *args)


    def setPrec(self, *args):
        """setPrec(BasicEigenproblemEpetra self, Teuchos::RCP< Epetra_Operator const > const & Prec)"""
        return _Anasazi.BasicEigenproblemEpetra_setPrec(self, *args)


    def setInitVec(self, *args):
        """setInitVec(BasicEigenproblemEpetra self, Teuchos::RCP< Epetra_MultiVector > const & InitVec)"""
        return _Anasazi.BasicEigenproblemEpetra_setInitVec(self, *args)


    def setAuxVecs(self, *args):
        """setAuxVecs(BasicEigenproblemEpetra self, Teuchos::RCP< Epetra_MultiVector const > const & AuxVecs)"""
        return _Anasazi.BasicEigenproblemEpetra_setAuxVecs(self, *args)


    def setNEV(self, *args):
        """setNEV(BasicEigenproblemEpetra self, int nev)"""
        return _Anasazi.BasicEigenproblemEpetra_setNEV(self, *args)


    def setHermitian(self, *args):
        """setHermitian(BasicEigenproblemEpetra self, bool isSym)"""
        return _Anasazi.BasicEigenproblemEpetra_setHermitian(self, *args)


    def setProblem(self, *args):
        """setProblem(BasicEigenproblemEpetra self) -> bool"""
        return _Anasazi.BasicEigenproblemEpetra_setProblem(self, *args)


    def setSolution(self, *args):
        """setSolution(BasicEigenproblemEpetra self, EigensolutionEpetra sol)"""
        return _Anasazi.BasicEigenproblemEpetra_setSolution(self, *args)


    def getOperator(self, *args):
        """getOperator(BasicEigenproblemEpetra self) -> Teuchos::RCP< Epetra_Operator const >"""
        return _Anasazi.BasicEigenproblemEpetra_getOperator(self, *args)


    def getA(self, *args):
        """getA(BasicEigenproblemEpetra self) -> Teuchos::RCP< Epetra_Operator const >"""
        return _Anasazi.BasicEigenproblemEpetra_getA(self, *args)


    def getM(self, *args):
        """getM(BasicEigenproblemEpetra self) -> Teuchos::RCP< Epetra_Operator const >"""
        return _Anasazi.BasicEigenproblemEpetra_getM(self, *args)


    def getPrec(self, *args):
        """getPrec(BasicEigenproblemEpetra self) -> Teuchos::RCP< Epetra_Operator const >"""
        return _Anasazi.BasicEigenproblemEpetra_getPrec(self, *args)


    def getInitVec(self, *args):
        """getInitVec(BasicEigenproblemEpetra self) -> Teuchos::RCP< Epetra_MultiVector const >"""
        return _Anasazi.BasicEigenproblemEpetra_getInitVec(self, *args)


    def getAuxVecs(self, *args):
        """getAuxVecs(BasicEigenproblemEpetra self) -> Teuchos::RCP< Epetra_MultiVector const >"""
        return _Anasazi.BasicEigenproblemEpetra_getAuxVecs(self, *args)


    def getNEV(self, *args):
        """getNEV(BasicEigenproblemEpetra self) -> int"""
        return _Anasazi.BasicEigenproblemEpetra_getNEV(self, *args)


    def isHermitian(self, *args):
        """isHermitian(BasicEigenproblemEpetra self) -> bool"""
        return _Anasazi.BasicEigenproblemEpetra_isHermitian(self, *args)


    def isProblemSet(self, *args):
        """isProblemSet(BasicEigenproblemEpetra self) -> bool"""
        return _Anasazi.BasicEigenproblemEpetra_isProblemSet(self, *args)


    def getSolution(self, *args):
        """getSolution(BasicEigenproblemEpetra self) -> EigensolutionEpetra"""
        return _Anasazi.BasicEigenproblemEpetra_getSolution(self, *args)


    def computeCurrResVec(self, *args):
        """computeCurrResVec(BasicEigenproblemEpetra self) -> Teuchos::RCP< Epetra_MultiVector const >"""
        return _Anasazi.BasicEigenproblemEpetra_computeCurrResVec(self, *args)

BasicEigenproblemEpetra_swigregister = _Anasazi.BasicEigenproblemEpetra_swigregister
BasicEigenproblemEpetra_swigregister(BasicEigenproblemEpetra)

class StatusTestEpetra(_object):
    """Proxy of C++ Anasazi::StatusTest<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, StatusTestEpetra, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, StatusTestEpetra, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_StatusTestEpetra

    def checkStatus(self, *args):
        """checkStatus(StatusTestEpetra self, EigensolverEpetra solver) -> Anasazi::TestStatus"""
        return _Anasazi.StatusTestEpetra_checkStatus(self, *args)


    def getStatus(self, *args):
        """getStatus(StatusTestEpetra self) -> Anasazi::TestStatus"""
        return _Anasazi.StatusTestEpetra_getStatus(self, *args)


    def whichVecs(self, *args):
        """whichVecs(StatusTestEpetra self) -> VectorInt"""
        return _Anasazi.StatusTestEpetra_whichVecs(self, *args)


    def howMany(self, *args):
        """howMany(StatusTestEpetra self) -> int"""
        return _Anasazi.StatusTestEpetra_howMany(self, *args)


    def reset(self, *args):
        """reset(StatusTestEpetra self)"""
        return _Anasazi.StatusTestEpetra_reset(self, *args)


    def clearStatus(self, *args):
        """clearStatus(StatusTestEpetra self)"""
        return _Anasazi.StatusTestEpetra_clearStatus(self, *args)

StatusTestEpetra_swigregister = _Anasazi.StatusTestEpetra_swigregister
StatusTestEpetra_swigregister(StatusTestEpetra)

class StatusTestComboEpetra(StatusTestEpetra):
    """Proxy of C++ Anasazi::StatusTestCombo<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    for _s in [StatusTestEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StatusTestComboEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [StatusTestEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, StatusTestComboEpetra, name)
    __repr__ = _swig_repr
    OR = _Anasazi.StatusTestComboEpetra_OR
    AND = _Anasazi.StatusTestComboEpetra_AND
    SEQOR = _Anasazi.StatusTestComboEpetra_SEQOR
    SEQAND = _Anasazi.StatusTestComboEpetra_SEQAND

    def __init__(self, *args):
        """
        __init__(Anasazi::StatusTestCombo<(double,Epetra_MultiVector,Epetra_Operator)> self) -> StatusTestComboEpetra
        __init__(Anasazi::StatusTestCombo<(double,Epetra_MultiVector,Epetra_Operator)> self, Anasazi::StatusTestCombo< double,Epetra_MultiVector,Epetra_Operator >::ComboType type, Teuchos::Array< Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > > tests) -> StatusTestComboEpetra
        """
        this = _Anasazi.new_StatusTestComboEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_StatusTestComboEpetra

    def checkStatus(self, *args):
        """checkStatus(StatusTestComboEpetra self, EigensolverEpetra solver) -> Anasazi::TestStatus"""
        return _Anasazi.StatusTestComboEpetra_checkStatus(self, *args)


    def getStatus(self, *args):
        """getStatus(StatusTestComboEpetra self) -> Anasazi::TestStatus"""
        return _Anasazi.StatusTestComboEpetra_getStatus(self, *args)


    def whichVecs(self, *args):
        """whichVecs(StatusTestComboEpetra self) -> VectorInt"""
        return _Anasazi.StatusTestComboEpetra_whichVecs(self, *args)


    def howMany(self, *args):
        """howMany(StatusTestComboEpetra self) -> int"""
        return _Anasazi.StatusTestComboEpetra_howMany(self, *args)


    def setComboType(self, *args):
        """setComboType(StatusTestComboEpetra self, Anasazi::StatusTestCombo< double,Epetra_MultiVector,Epetra_Operator >::ComboType type)"""
        return _Anasazi.StatusTestComboEpetra_setComboType(self, *args)


    def getComboType(self, *args):
        """getComboType(StatusTestComboEpetra self) -> Anasazi::StatusTestCombo< double,Epetra_MultiVector,Epetra_Operator >::ComboType"""
        return _Anasazi.StatusTestComboEpetra_getComboType(self, *args)


    def setTests(self, *args):
        """setTests(StatusTestComboEpetra self, Teuchos::Array< Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > > tests)"""
        return _Anasazi.StatusTestComboEpetra_setTests(self, *args)


    def getTests(self, *args):
        """getTests(StatusTestComboEpetra self) -> Teuchos::Array< Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > >"""
        return _Anasazi.StatusTestComboEpetra_getTests(self, *args)


    def addTest(self, *args):
        """addTest(StatusTestComboEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > test)"""
        return _Anasazi.StatusTestComboEpetra_addTest(self, *args)


    def removeTest(self, *args):
        """removeTest(StatusTestComboEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & test)"""
        return _Anasazi.StatusTestComboEpetra_removeTest(self, *args)


    def reset(self, *args):
        """reset(StatusTestComboEpetra self)"""
        return _Anasazi.StatusTestComboEpetra_reset(self, *args)


    def clearStatus(self, *args):
        """clearStatus(StatusTestComboEpetra self)"""
        return _Anasazi.StatusTestComboEpetra_clearStatus(self, *args)

StatusTestComboEpetra_swigregister = _Anasazi.StatusTestComboEpetra_swigregister
StatusTestComboEpetra_swigregister(StatusTestComboEpetra)

class StatusTestMaxItersEpetra(StatusTestEpetra):
    """Proxy of C++ Anasazi::StatusTestMaxIters<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    for _s in [StatusTestEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StatusTestMaxItersEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [StatusTestEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, StatusTestMaxItersEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::StatusTestMaxIters<(double,Epetra_MultiVector,Epetra_Operator)> self, int maxIter, bool negate=False) -> StatusTestMaxItersEpetra"""
        this = _Anasazi.new_StatusTestMaxItersEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_StatusTestMaxItersEpetra

    def checkStatus(self, *args):
        """checkStatus(StatusTestMaxItersEpetra self, EigensolverEpetra solver) -> Anasazi::TestStatus"""
        return _Anasazi.StatusTestMaxItersEpetra_checkStatus(self, *args)


    def getStatus(self, *args):
        """getStatus(StatusTestMaxItersEpetra self) -> Anasazi::TestStatus"""
        return _Anasazi.StatusTestMaxItersEpetra_getStatus(self, *args)


    def whichVecs(self, *args):
        """whichVecs(StatusTestMaxItersEpetra self) -> VectorInt"""
        return _Anasazi.StatusTestMaxItersEpetra_whichVecs(self, *args)


    def howMany(self, *args):
        """howMany(StatusTestMaxItersEpetra self) -> int"""
        return _Anasazi.StatusTestMaxItersEpetra_howMany(self, *args)


    def setMaxIters(self, *args):
        """setMaxIters(StatusTestMaxItersEpetra self, int maxIters)"""
        return _Anasazi.StatusTestMaxItersEpetra_setMaxIters(self, *args)


    def getMaxIters(self, *args):
        """getMaxIters(StatusTestMaxItersEpetra self) -> int"""
        return _Anasazi.StatusTestMaxItersEpetra_getMaxIters(self, *args)


    def setNegate(self, *args):
        """setNegate(StatusTestMaxItersEpetra self, bool negate)"""
        return _Anasazi.StatusTestMaxItersEpetra_setNegate(self, *args)


    def getNegate(self, *args):
        """getNegate(StatusTestMaxItersEpetra self) -> bool"""
        return _Anasazi.StatusTestMaxItersEpetra_getNegate(self, *args)


    def reset(self, *args):
        """reset(StatusTestMaxItersEpetra self)"""
        return _Anasazi.StatusTestMaxItersEpetra_reset(self, *args)


    def clearStatus(self, *args):
        """clearStatus(StatusTestMaxItersEpetra self)"""
        return _Anasazi.StatusTestMaxItersEpetra_clearStatus(self, *args)

StatusTestMaxItersEpetra_swigregister = _Anasazi.StatusTestMaxItersEpetra_swigregister
StatusTestMaxItersEpetra_swigregister(StatusTestMaxItersEpetra)

class StatusTestOutputEpetra(StatusTestEpetra):
    """Proxy of C++ Anasazi::StatusTestOutput<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    for _s in [StatusTestEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StatusTestOutputEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [StatusTestEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, StatusTestOutputEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::StatusTestOutput<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Anasazi::OutputManager< double > > const & printer, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > test, int mod=1, int printStates) -> StatusTestOutputEpetra"""
        this = _Anasazi.new_StatusTestOutputEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_StatusTestOutputEpetra

    def checkStatus(self, *args):
        """checkStatus(StatusTestOutputEpetra self, EigensolverEpetra solver) -> Anasazi::TestStatus"""
        return _Anasazi.StatusTestOutputEpetra_checkStatus(self, *args)


    def getStatus(self, *args):
        """getStatus(StatusTestOutputEpetra self) -> Anasazi::TestStatus"""
        return _Anasazi.StatusTestOutputEpetra_getStatus(self, *args)


    def whichVecs(self, *args):
        """whichVecs(StatusTestOutputEpetra self) -> VectorInt"""
        return _Anasazi.StatusTestOutputEpetra_whichVecs(self, *args)


    def howMany(self, *args):
        """howMany(StatusTestOutputEpetra self) -> int"""
        return _Anasazi.StatusTestOutputEpetra_howMany(self, *args)


    def setChild(self, *args):
        """setChild(StatusTestOutputEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > test)"""
        return _Anasazi.StatusTestOutputEpetra_setChild(self, *args)


    def getChild(self, *args):
        """getChild(StatusTestOutputEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > >"""
        return _Anasazi.StatusTestOutputEpetra_getChild(self, *args)


    def reset(self, *args):
        """reset(StatusTestOutputEpetra self)"""
        return _Anasazi.StatusTestOutputEpetra_reset(self, *args)


    def clearStatus(self, *args):
        """clearStatus(StatusTestOutputEpetra self)"""
        return _Anasazi.StatusTestOutputEpetra_clearStatus(self, *args)

StatusTestOutputEpetra_swigregister = _Anasazi.StatusTestOutputEpetra_swigregister
StatusTestOutputEpetra_swigregister(StatusTestOutputEpetra)

class StatusTestResNormEpetra(StatusTestEpetra):
    """Proxy of C++ Anasazi::StatusTestResNorm<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    for _s in [StatusTestEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StatusTestResNormEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [StatusTestEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, StatusTestResNormEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::StatusTestResNorm<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::ScalarTraits< double >::magnitudeType tol, int quorum=-1, Anasazi::ResType whichNorm, bool scaled=True, bool throwExceptionOnNaN=True) -> StatusTestResNormEpetra"""
        this = _Anasazi.new_StatusTestResNormEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_StatusTestResNormEpetra

    def checkStatus(self, *args):
        """checkStatus(StatusTestResNormEpetra self, EigensolverEpetra solver) -> Anasazi::TestStatus"""
        return _Anasazi.StatusTestResNormEpetra_checkStatus(self, *args)


    def getStatus(self, *args):
        """getStatus(StatusTestResNormEpetra self) -> Anasazi::TestStatus"""
        return _Anasazi.StatusTestResNormEpetra_getStatus(self, *args)


    def whichVecs(self, *args):
        """whichVecs(StatusTestResNormEpetra self) -> VectorInt"""
        return _Anasazi.StatusTestResNormEpetra_whichVecs(self, *args)


    def howMany(self, *args):
        """howMany(StatusTestResNormEpetra self) -> int"""
        return _Anasazi.StatusTestResNormEpetra_howMany(self, *args)


    def setQuorum(self, *args):
        """setQuorum(StatusTestResNormEpetra self, int quorum)"""
        return _Anasazi.StatusTestResNormEpetra_setQuorum(self, *args)


    def getQuorum(self, *args):
        """getQuorum(StatusTestResNormEpetra self) -> int"""
        return _Anasazi.StatusTestResNormEpetra_getQuorum(self, *args)


    def setTolerance(self, *args):
        """setTolerance(StatusTestResNormEpetra self, Teuchos::ScalarTraits< double >::magnitudeType tol)"""
        return _Anasazi.StatusTestResNormEpetra_setTolerance(self, *args)


    def getTolerance(self, *args):
        """getTolerance(StatusTestResNormEpetra self) -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Anasazi.StatusTestResNormEpetra_getTolerance(self, *args)


    def setWhichNorm(self, *args):
        """setWhichNorm(StatusTestResNormEpetra self, Anasazi::ResType whichNorm)"""
        return _Anasazi.StatusTestResNormEpetra_setWhichNorm(self, *args)


    def getWhichNorm(self, *args):
        """getWhichNorm(StatusTestResNormEpetra self) -> Anasazi::ResType"""
        return _Anasazi.StatusTestResNormEpetra_getWhichNorm(self, *args)


    def setScale(self, *args):
        """setScale(StatusTestResNormEpetra self, bool relscale)"""
        return _Anasazi.StatusTestResNormEpetra_setScale(self, *args)


    def getScale(self, *args):
        """getScale(StatusTestResNormEpetra self) -> bool"""
        return _Anasazi.StatusTestResNormEpetra_getScale(self, *args)


    def reset(self, *args):
        """reset(StatusTestResNormEpetra self)"""
        return _Anasazi.StatusTestResNormEpetra_reset(self, *args)


    def clearStatus(self, *args):
        """clearStatus(StatusTestResNormEpetra self)"""
        return _Anasazi.StatusTestResNormEpetra_clearStatus(self, *args)

StatusTestResNormEpetra_swigregister = _Anasazi.StatusTestResNormEpetra_swigregister
StatusTestResNormEpetra_swigregister(StatusTestResNormEpetra)

class OrthoManagerEpetra(_object):
    """Proxy of C++ Anasazi::OrthoManager<(double,Epetra_MultiVector)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, OrthoManagerEpetra, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, OrthoManagerEpetra, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_OrthoManagerEpetra

    def innerProd(self, *args):
        """innerProd(OrthoManagerEpetra self, MultiVector X, MultiVector Y, Teuchos::SerialDenseMatrix< int,double > & Z)"""
        return _Anasazi.OrthoManagerEpetra_innerProd(self, *args)


    def norm(self, *args):
        """norm(OrthoManagerEpetra self, MultiVector X, std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > > & normvec)"""
        return _Anasazi.OrthoManagerEpetra_norm(self, *args)


    def normalize(self, *args):
        """normalize(OrthoManagerEpetra self, MultiVector X, Teuchos::RCP< Teuchos::SerialDenseMatrix< int,double > > B) -> int"""
        return _Anasazi.OrthoManagerEpetra_normalize(self, *args)


    def orthonormError(self, *args):
        """orthonormError(OrthoManagerEpetra self, MultiVector X) -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Anasazi.OrthoManagerEpetra_orthonormError(self, *args)


    def orthogError(self, *args):
        """orthogError(OrthoManagerEpetra self, MultiVector X1, MultiVector X2) -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Anasazi.OrthoManagerEpetra_orthogError(self, *args)

OrthoManagerEpetra_swigregister = _Anasazi.OrthoManagerEpetra_swigregister
OrthoManagerEpetra_swigregister(OrthoManagerEpetra)

class MatOrthoManagerEpetra(OrthoManagerEpetra):
    """Proxy of C++ Anasazi::MatOrthoManager<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    for _s in [OrthoManagerEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MatOrthoManagerEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [OrthoManagerEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MatOrthoManagerEpetra, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_MatOrthoManagerEpetra

    def setOp(self, *args):
        """setOp(MatOrthoManagerEpetra self, Teuchos::RCP< Epetra_Operator const > Op)"""
        return _Anasazi.MatOrthoManagerEpetra_setOp(self, *args)


    def getOp(self, *args):
        """getOp(MatOrthoManagerEpetra self) -> Teuchos::RCP< Epetra_Operator const >"""
        return _Anasazi.MatOrthoManagerEpetra_getOp(self, *args)


    def getOpCounter(self, *args):
        """getOpCounter(MatOrthoManagerEpetra self) -> int"""
        return _Anasazi.MatOrthoManagerEpetra_getOpCounter(self, *args)


    def resetOpCounter(self, *args):
        """resetOpCounter(MatOrthoManagerEpetra self)"""
        return _Anasazi.MatOrthoManagerEpetra_resetOpCounter(self, *args)


    def innerProdMat(self, *args):
        """innerProdMat(MatOrthoManagerEpetra self, MultiVector X, MultiVector Y, Teuchos::SerialDenseMatrix< int,double > & Z, Teuchos::RCP< Epetra_MultiVector const > MX, Teuchos::RCP< Epetra_MultiVector const > MY)"""
        return _Anasazi.MatOrthoManagerEpetra_innerProdMat(self, *args)


    def normMat(self, *args):
        """normMat(MatOrthoManagerEpetra self, MultiVector X, std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > > & normvec, Teuchos::RCP< Epetra_MultiVector const > MX)"""
        return _Anasazi.MatOrthoManagerEpetra_normMat(self, *args)


    def normalizeMat(self, *args):
        """normalizeMat(MatOrthoManagerEpetra self, MultiVector X, Teuchos::RCP< Teuchos::SerialDenseMatrix< int,double > > B, Teuchos::RCP< Epetra_MultiVector > MX) -> int"""
        return _Anasazi.MatOrthoManagerEpetra_normalizeMat(self, *args)


    def orthonormErrorMat(self, *args):
        """orthonormErrorMat(MatOrthoManagerEpetra self, MultiVector X, Teuchos::RCP< Epetra_MultiVector const > MX) -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Anasazi.MatOrthoManagerEpetra_orthonormErrorMat(self, *args)


    def orthogErrorMat(self, *args):
        """orthogErrorMat(MatOrthoManagerEpetra self, MultiVector X, MultiVector Y, Teuchos::RCP< Epetra_MultiVector const > MX, Teuchos::RCP< Epetra_MultiVector const > MY) -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Anasazi.MatOrthoManagerEpetra_orthogErrorMat(self, *args)


    def innerProd(self, *args):
        """innerProd(MatOrthoManagerEpetra self, MultiVector X, MultiVector Y, Teuchos::SerialDenseMatrix< int,double > & Z)"""
        return _Anasazi.MatOrthoManagerEpetra_innerProd(self, *args)


    def norm(self, *args):
        """norm(MatOrthoManagerEpetra self, MultiVector X, std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > > & normvec)"""
        return _Anasazi.MatOrthoManagerEpetra_norm(self, *args)


    def normalize(self, *args):
        """normalize(MatOrthoManagerEpetra self, MultiVector X, Teuchos::RCP< Teuchos::SerialDenseMatrix< int,double > > B) -> int"""
        return _Anasazi.MatOrthoManagerEpetra_normalize(self, *args)


    def orthonormError(self, *args):
        """orthonormError(MatOrthoManagerEpetra self, MultiVector X) -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Anasazi.MatOrthoManagerEpetra_orthonormError(self, *args)


    def orthogError(self, *args):
        """orthogError(MatOrthoManagerEpetra self, MultiVector X1, MultiVector X2) -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Anasazi.MatOrthoManagerEpetra_orthogError(self, *args)

MatOrthoManagerEpetra_swigregister = _Anasazi.MatOrthoManagerEpetra_swigregister
MatOrthoManagerEpetra_swigregister(MatOrthoManagerEpetra)

class BasicOrthoManagerEpetra(MatOrthoManagerEpetra):
    """Proxy of C++ Anasazi::BasicOrthoManager<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    for _s in [MatOrthoManagerEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BasicOrthoManagerEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [MatOrthoManagerEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BasicOrthoManagerEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::BasicOrthoManager<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Epetra_Operator const > Op, Teuchos::ScalarTraits< double >::magnitudeType kappa=1.41421356, Teuchos::ScalarTraits< double >::magnitudeType eps=0.0, Teuchos::ScalarTraits< double >::magnitudeType tol=0.20) -> BasicOrthoManagerEpetra"""
        this = _Anasazi.new_BasicOrthoManagerEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BasicOrthoManagerEpetra

    def orthonormErrorMat(self, *args):
        """orthonormErrorMat(BasicOrthoManagerEpetra self, MultiVector X, Teuchos::RCP< Epetra_MultiVector const > MX) -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Anasazi.BasicOrthoManagerEpetra_orthonormErrorMat(self, *args)


    def orthogErrorMat(self, *args):
        """orthogErrorMat(BasicOrthoManagerEpetra self, MultiVector X1, MultiVector X2, Teuchos::RCP< Epetra_MultiVector const > MX1, Teuchos::RCP< Epetra_MultiVector const > MX2) -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Anasazi.BasicOrthoManagerEpetra_orthogErrorMat(self, *args)


    def setKappa(self, *args):
        """setKappa(BasicOrthoManagerEpetra self, Teuchos::ScalarTraits< double >::magnitudeType kappa)"""
        return _Anasazi.BasicOrthoManagerEpetra_setKappa(self, *args)


    def getKappa(self, *args):
        """getKappa(BasicOrthoManagerEpetra self) -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Anasazi.BasicOrthoManagerEpetra_getKappa(self, *args)

BasicOrthoManagerEpetra_swigregister = _Anasazi.BasicOrthoManagerEpetra_swigregister
BasicOrthoManagerEpetra_swigregister(BasicOrthoManagerEpetra)

class SVQBOrthoManagerEpetra(MatOrthoManagerEpetra):
    """Proxy of C++ Anasazi::SVQBOrthoManager<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    for _s in [MatOrthoManagerEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SVQBOrthoManagerEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [MatOrthoManagerEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SVQBOrthoManagerEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::SVQBOrthoManager<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Epetra_Operator const > Op, bool debug=False) -> SVQBOrthoManagerEpetra"""
        this = _Anasazi.new_SVQBOrthoManagerEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_SVQBOrthoManagerEpetra

    def orthonormErrorMat(self, *args):
        """orthonormErrorMat(SVQBOrthoManagerEpetra self, MultiVector X, Teuchos::RCP< Epetra_MultiVector const > MX) -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Anasazi.SVQBOrthoManagerEpetra_orthonormErrorMat(self, *args)


    def orthogErrorMat(self, *args):
        """orthogErrorMat(SVQBOrthoManagerEpetra self, MultiVector X, MultiVector Y, Teuchos::RCP< Epetra_MultiVector const > MX, Teuchos::RCP< Epetra_MultiVector const > MY) -> Teuchos::ScalarTraits< double >::magnitudeType"""
        return _Anasazi.SVQBOrthoManagerEpetra_orthogErrorMat(self, *args)

SVQBOrthoManagerEpetra_swigregister = _Anasazi.SVQBOrthoManagerEpetra_swigregister
SVQBOrthoManagerEpetra_swigregister(SVQBOrthoManagerEpetra)

class EigensolverEpetra(_object):
    """Proxy of C++ Anasazi::Eigensolver<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, EigensolverEpetra, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, EigensolverEpetra, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_EigensolverEpetra

    def iterate(self, *args):
        """iterate(EigensolverEpetra self)"""
        return _Anasazi.EigensolverEpetra_iterate(self, *args)


    def initialize(self, *args):
        """initialize(EigensolverEpetra self)"""
        return _Anasazi.EigensolverEpetra_initialize(self, *args)


    def getNumIters(self, *args):
        """getNumIters(EigensolverEpetra self) -> int"""
        return _Anasazi.EigensolverEpetra_getNumIters(self, *args)


    def resetNumIters(self, *args):
        """resetNumIters(EigensolverEpetra self)"""
        return _Anasazi.EigensolverEpetra_resetNumIters(self, *args)


    def getRitzVectors(self, *args):
        """getRitzVectors(EigensolverEpetra self) -> Teuchos::RCP< Epetra_MultiVector const >"""
        return _Anasazi.EigensolverEpetra_getRitzVectors(self, *args)


    def getRitzValues(self, *args):
        """getRitzValues(EigensolverEpetra self) -> VectorValueDouble"""
        return _Anasazi.EigensolverEpetra_getRitzValues(self, *args)


    def getRitzIndex(self, *args):
        """getRitzIndex(EigensolverEpetra self) -> VectorInt"""
        return _Anasazi.EigensolverEpetra_getRitzIndex(self, *args)


    def getResNorms(self, *args):
        """getResNorms(EigensolverEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >"""
        return _Anasazi.EigensolverEpetra_getResNorms(self, *args)


    def getRes2Norms(self, *args):
        """getRes2Norms(EigensolverEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >"""
        return _Anasazi.EigensolverEpetra_getRes2Norms(self, *args)


    def getRitzRes2Norms(self, *args):
        """getRitzRes2Norms(EigensolverEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >"""
        return _Anasazi.EigensolverEpetra_getRitzRes2Norms(self, *args)


    def getCurSubspaceDim(self, *args):
        """getCurSubspaceDim(EigensolverEpetra self) -> int"""
        return _Anasazi.EigensolverEpetra_getCurSubspaceDim(self, *args)


    def getMaxSubspaceDim(self, *args):
        """getMaxSubspaceDim(EigensolverEpetra self) -> int"""
        return _Anasazi.EigensolverEpetra_getMaxSubspaceDim(self, *args)


    def setStatusTest(self, *args):
        """setStatusTest(EigensolverEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > test)"""
        return _Anasazi.EigensolverEpetra_setStatusTest(self, *args)


    def getStatusTest(self, *args):
        """getStatusTest(EigensolverEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > >"""
        return _Anasazi.EigensolverEpetra_getStatusTest(self, *args)


    def getProblem(self, *args):
        """getProblem(EigensolverEpetra self) -> EigenproblemEpetra"""
        return _Anasazi.EigensolverEpetra_getProblem(self, *args)


    def getBlockSize(self, *args):
        """getBlockSize(EigensolverEpetra self) -> int"""
        return _Anasazi.EigensolverEpetra_getBlockSize(self, *args)


    def setBlockSize(self, *args):
        """setBlockSize(EigensolverEpetra self, int blockSize)"""
        return _Anasazi.EigensolverEpetra_setBlockSize(self, *args)


    def setAuxVecs(self, *args):
        """setAuxVecs(EigensolverEpetra self, Teuchos::Array< Teuchos::RCP< Epetra_MultiVector const > > const & auxvecs)"""
        return _Anasazi.EigensolverEpetra_setAuxVecs(self, *args)


    def getAuxVecs(self, *args):
        """getAuxVecs(EigensolverEpetra self) -> Teuchos::Array< Teuchos::RCP< Epetra_MultiVector const > >"""
        return _Anasazi.EigensolverEpetra_getAuxVecs(self, *args)


    def isInitialized(self, *args):
        """isInitialized(EigensolverEpetra self) -> bool"""
        return _Anasazi.EigensolverEpetra_isInitialized(self, *args)


    def currentStatus(self, *args):
        """currentStatus(EigensolverEpetra self, std::ostream & os)"""
        return _Anasazi.EigensolverEpetra_currentStatus(self, *args)

EigensolverEpetra_swigregister = _Anasazi.EigensolverEpetra_swigregister
EigensolverEpetra_swigregister(EigensolverEpetra)

class SolverManagerEpetra(_object):
    """Proxy of C++ Anasazi::SolverManager<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SolverManagerEpetra, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SolverManagerEpetra, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Anasazi.delete_SolverManagerEpetra

    def getProblem(self, *args):
        """getProblem(SolverManagerEpetra self) -> EigenproblemEpetra"""
        return _Anasazi.SolverManagerEpetra_getProblem(self, *args)


    def getNumIters(self, *args):
        """getNumIters(SolverManagerEpetra self) -> int"""
        return _Anasazi.SolverManagerEpetra_getNumIters(self, *args)


    def getTimers(self, *args):
        """getTimers(SolverManagerEpetra self) -> Teuchos::Array< Teuchos::RCP< Teuchos::Time > >"""
        return _Anasazi.SolverManagerEpetra_getTimers(self, *args)


    def solve(self, *args):
        """solve(SolverManagerEpetra self) -> Anasazi::ReturnType"""
        return _Anasazi.SolverManagerEpetra_solve(self, *args)

SolverManagerEpetra_swigregister = _Anasazi.SolverManagerEpetra_swigregister
SolverManagerEpetra_swigregister(SolverManagerEpetra)

class BlockDavidsonEpetra(EigensolverEpetra):
    """Proxy of C++ Anasazi::BlockDavidson<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    for _s in [EigensolverEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BlockDavidsonEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [EigensolverEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BlockDavidsonEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::BlockDavidson<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Anasazi::Eigenproblem< double,Epetra_MultiVector,Epetra_Operator > > const & problem, Teuchos::RCP< Anasazi::SortManager< Teuchos::ScalarTraits< double >::magnitudeType > > const & sorter, Teuchos::RCP< Anasazi::OutputManager< double > > const & printer, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & tester, Teuchos::RCP< Anasazi::MatOrthoManager< double,Epetra_MultiVector,Epetra_Operator > > const & ortho, ParameterList params) -> BlockDavidsonEpetra"""
        this = _Anasazi.new_BlockDavidsonEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BlockDavidsonEpetra

    def iterate(self, *args):
        """iterate(BlockDavidsonEpetra self)"""
        return _Anasazi.BlockDavidsonEpetra_iterate(self, *args)


    def initialize(self, *args):
        """
        initialize(BlockDavidsonEpetra self, Anasazi::BlockDavidsonState< double,Epetra_MultiVector > & newstate)
        initialize(BlockDavidsonEpetra self)
        """
        return _Anasazi.BlockDavidsonEpetra_initialize(self, *args)


    def isInitialized(self, *args):
        """isInitialized(BlockDavidsonEpetra self) -> bool"""
        return _Anasazi.BlockDavidsonEpetra_isInitialized(self, *args)


    def getState(self, *args):
        """getState(BlockDavidsonEpetra self) -> Anasazi::BlockDavidsonState< double,Epetra_MultiVector >"""
        return _Anasazi.BlockDavidsonEpetra_getState(self, *args)


    def getNumIters(self, *args):
        """getNumIters(BlockDavidsonEpetra self) -> int"""
        return _Anasazi.BlockDavidsonEpetra_getNumIters(self, *args)


    def resetNumIters(self, *args):
        """resetNumIters(BlockDavidsonEpetra self)"""
        return _Anasazi.BlockDavidsonEpetra_resetNumIters(self, *args)


    def getRitzVectors(self, *args):
        """getRitzVectors(BlockDavidsonEpetra self) -> Teuchos::RCP< Epetra_MultiVector const >"""
        return _Anasazi.BlockDavidsonEpetra_getRitzVectors(self, *args)


    def getRitzValues(self, *args):
        """getRitzValues(BlockDavidsonEpetra self) -> VectorValueDouble"""
        return _Anasazi.BlockDavidsonEpetra_getRitzValues(self, *args)


    def getRitzIndex(self, *args):
        """getRitzIndex(BlockDavidsonEpetra self) -> VectorInt"""
        return _Anasazi.BlockDavidsonEpetra_getRitzIndex(self, *args)


    def getResNorms(self, *args):
        """getResNorms(BlockDavidsonEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >"""
        return _Anasazi.BlockDavidsonEpetra_getResNorms(self, *args)


    def getRes2Norms(self, *args):
        """getRes2Norms(BlockDavidsonEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >"""
        return _Anasazi.BlockDavidsonEpetra_getRes2Norms(self, *args)


    def getRitzRes2Norms(self, *args):
        """getRitzRes2Norms(BlockDavidsonEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >"""
        return _Anasazi.BlockDavidsonEpetra_getRitzRes2Norms(self, *args)


    def getCurSubspaceDim(self, *args):
        """getCurSubspaceDim(BlockDavidsonEpetra self) -> int"""
        return _Anasazi.BlockDavidsonEpetra_getCurSubspaceDim(self, *args)


    def getMaxSubspaceDim(self, *args):
        """getMaxSubspaceDim(BlockDavidsonEpetra self) -> int"""
        return _Anasazi.BlockDavidsonEpetra_getMaxSubspaceDim(self, *args)


    def setStatusTest(self, *args):
        """setStatusTest(BlockDavidsonEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > test)"""
        return _Anasazi.BlockDavidsonEpetra_setStatusTest(self, *args)


    def getStatusTest(self, *args):
        """getStatusTest(BlockDavidsonEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > >"""
        return _Anasazi.BlockDavidsonEpetra_getStatusTest(self, *args)


    def getProblem(self, *args):
        """getProblem(BlockDavidsonEpetra self) -> EigenproblemEpetra"""
        return _Anasazi.BlockDavidsonEpetra_getProblem(self, *args)


    def setBlockSize(self, *args):
        """setBlockSize(BlockDavidsonEpetra self, int blockSize)"""
        return _Anasazi.BlockDavidsonEpetra_setBlockSize(self, *args)


    def getBlockSize(self, *args):
        """getBlockSize(BlockDavidsonEpetra self) -> int"""
        return _Anasazi.BlockDavidsonEpetra_getBlockSize(self, *args)


    def setAuxVecs(self, *args):
        """setAuxVecs(BlockDavidsonEpetra self, Teuchos::Array< Teuchos::RCP< Epetra_MultiVector const > > const & auxvecs)"""
        return _Anasazi.BlockDavidsonEpetra_setAuxVecs(self, *args)


    def getAuxVecs(self, *args):
        """getAuxVecs(BlockDavidsonEpetra self) -> Teuchos::Array< Teuchos::RCP< Epetra_MultiVector const > >"""
        return _Anasazi.BlockDavidsonEpetra_getAuxVecs(self, *args)


    def setSize(self, *args):
        """setSize(BlockDavidsonEpetra self, int blockSize, int numBlocks)"""
        return _Anasazi.BlockDavidsonEpetra_setSize(self, *args)


    def currentStatus(self, *args):
        """currentStatus(BlockDavidsonEpetra self, std::ostream & os)"""
        return _Anasazi.BlockDavidsonEpetra_currentStatus(self, *args)

BlockDavidsonEpetra_swigregister = _Anasazi.BlockDavidsonEpetra_swigregister
BlockDavidsonEpetra_swigregister(BlockDavidsonEpetra)

class BlockDavidsonSolMgrEpetra(SolverManagerEpetra):
    """Proxy of C++ Anasazi::BlockDavidsonSolMgr<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    for _s in [SolverManagerEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BlockDavidsonSolMgrEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [SolverManagerEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BlockDavidsonSolMgrEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::BlockDavidsonSolMgr<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Anasazi::Eigenproblem< double,Epetra_MultiVector,Epetra_Operator > > const & problem, ParameterList pl) -> BlockDavidsonSolMgrEpetra"""
        this = _Anasazi.new_BlockDavidsonSolMgrEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BlockDavidsonSolMgrEpetra

    def getProblem(self, *args):
        """getProblem(BlockDavidsonSolMgrEpetra self) -> EigenproblemEpetra"""
        return _Anasazi.BlockDavidsonSolMgrEpetra_getProblem(self, *args)


    def getNumIters(self, *args):
        """getNumIters(BlockDavidsonSolMgrEpetra self) -> int"""
        return _Anasazi.BlockDavidsonSolMgrEpetra_getNumIters(self, *args)


    def getTimers(self, *args):
        """getTimers(BlockDavidsonSolMgrEpetra self) -> Teuchos::Array< Teuchos::RCP< Teuchos::Time > >"""
        return _Anasazi.BlockDavidsonSolMgrEpetra_getTimers(self, *args)


    def solve(self, *args):
        """solve(BlockDavidsonSolMgrEpetra self) -> Anasazi::ReturnType"""
        return _Anasazi.BlockDavidsonSolMgrEpetra_solve(self, *args)


    def setGlobalStatusTest(self, *args):
        """setGlobalStatusTest(BlockDavidsonSolMgrEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & arg2)"""
        return _Anasazi.BlockDavidsonSolMgrEpetra_setGlobalStatusTest(self, *args)


    def getGlobalStatusTest(self, *args):
        """getGlobalStatusTest(BlockDavidsonSolMgrEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const &"""
        return _Anasazi.BlockDavidsonSolMgrEpetra_getGlobalStatusTest(self, *args)


    def setLockingStatusTest(self, *args):
        """setLockingStatusTest(BlockDavidsonSolMgrEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & locking)"""
        return _Anasazi.BlockDavidsonSolMgrEpetra_setLockingStatusTest(self, *args)


    def getLockingStatusTest(self, *args):
        """getLockingStatusTest(BlockDavidsonSolMgrEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const &"""
        return _Anasazi.BlockDavidsonSolMgrEpetra_getLockingStatusTest(self, *args)


    def setDebugStatusTest(self, *args):
        """setDebugStatusTest(BlockDavidsonSolMgrEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & debug)"""
        return _Anasazi.BlockDavidsonSolMgrEpetra_setDebugStatusTest(self, *args)


    def getDebugStatusTest(self, *args):
        """getDebugStatusTest(BlockDavidsonSolMgrEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const &"""
        return _Anasazi.BlockDavidsonSolMgrEpetra_getDebugStatusTest(self, *args)

BlockDavidsonSolMgrEpetra_swigregister = _Anasazi.BlockDavidsonSolMgrEpetra_swigregister
BlockDavidsonSolMgrEpetra_swigregister(BlockDavidsonSolMgrEpetra)

class BlockKrylovSchurEpetra(EigensolverEpetra):
    """Proxy of C++ Anasazi::BlockKrylovSchur<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    for _s in [EigensolverEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BlockKrylovSchurEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [EigensolverEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BlockKrylovSchurEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::BlockKrylovSchur<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Anasazi::Eigenproblem< double,Epetra_MultiVector,Epetra_Operator > > const & problem, Teuchos::RCP< Anasazi::SortManager< Teuchos::ScalarTraits< double >::magnitudeType > > const & sorter, Teuchos::RCP< Anasazi::OutputManager< double > > const & printer, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & tester, Teuchos::RCP< Anasazi::OrthoManager< double,Epetra_MultiVector > > const & ortho, ParameterList params) -> BlockKrylovSchurEpetra"""
        this = _Anasazi.new_BlockKrylovSchurEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BlockKrylovSchurEpetra

    def iterate(self, *args):
        """iterate(BlockKrylovSchurEpetra self)"""
        return _Anasazi.BlockKrylovSchurEpetra_iterate(self, *args)


    def initialize(self, *args):
        """
        initialize(BlockKrylovSchurEpetra self, Anasazi::BlockKrylovSchurState< double,Epetra_MultiVector > & state)
        initialize(BlockKrylovSchurEpetra self)
        """
        return _Anasazi.BlockKrylovSchurEpetra_initialize(self, *args)


    def isInitialized(self, *args):
        """isInitialized(BlockKrylovSchurEpetra self) -> bool"""
        return _Anasazi.BlockKrylovSchurEpetra_isInitialized(self, *args)


    def getState(self, *args):
        """getState(BlockKrylovSchurEpetra self) -> Anasazi::BlockKrylovSchurState< double,Epetra_MultiVector >"""
        return _Anasazi.BlockKrylovSchurEpetra_getState(self, *args)


    def getNumIters(self, *args):
        """getNumIters(BlockKrylovSchurEpetra self) -> int"""
        return _Anasazi.BlockKrylovSchurEpetra_getNumIters(self, *args)


    def resetNumIters(self, *args):
        """resetNumIters(BlockKrylovSchurEpetra self)"""
        return _Anasazi.BlockKrylovSchurEpetra_resetNumIters(self, *args)


    def getRitzVectors(self, *args):
        """getRitzVectors(BlockKrylovSchurEpetra self) -> Teuchos::RCP< Epetra_MultiVector const >"""
        return _Anasazi.BlockKrylovSchurEpetra_getRitzVectors(self, *args)


    def getRitzValues(self, *args):
        """getRitzValues(BlockKrylovSchurEpetra self) -> VectorValueDouble"""
        return _Anasazi.BlockKrylovSchurEpetra_getRitzValues(self, *args)


    def getRitzIndex(self, *args):
        """getRitzIndex(BlockKrylovSchurEpetra self) -> VectorInt"""
        return _Anasazi.BlockKrylovSchurEpetra_getRitzIndex(self, *args)


    def getResNorms(self, *args):
        """getResNorms(BlockKrylovSchurEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >"""
        return _Anasazi.BlockKrylovSchurEpetra_getResNorms(self, *args)


    def getRes2Norms(self, *args):
        """getRes2Norms(BlockKrylovSchurEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >"""
        return _Anasazi.BlockKrylovSchurEpetra_getRes2Norms(self, *args)


    def getRitzRes2Norms(self, *args):
        """getRitzRes2Norms(BlockKrylovSchurEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >"""
        return _Anasazi.BlockKrylovSchurEpetra_getRitzRes2Norms(self, *args)


    def setStatusTest(self, *args):
        """setStatusTest(BlockKrylovSchurEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > test)"""
        return _Anasazi.BlockKrylovSchurEpetra_setStatusTest(self, *args)


    def getStatusTest(self, *args):
        """getStatusTest(BlockKrylovSchurEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > >"""
        return _Anasazi.BlockKrylovSchurEpetra_getStatusTest(self, *args)


    def getProblem(self, *args):
        """getProblem(BlockKrylovSchurEpetra self) -> EigenproblemEpetra"""
        return _Anasazi.BlockKrylovSchurEpetra_getProblem(self, *args)


    def setSize(self, *args):
        """setSize(BlockKrylovSchurEpetra self, int blockSize, int numBlocks)"""
        return _Anasazi.BlockKrylovSchurEpetra_setSize(self, *args)


    def setBlockSize(self, *args):
        """setBlockSize(BlockKrylovSchurEpetra self, int blockSize)"""
        return _Anasazi.BlockKrylovSchurEpetra_setBlockSize(self, *args)


    def setStepSize(self, *args):
        """setStepSize(BlockKrylovSchurEpetra self, int stepSize)"""
        return _Anasazi.BlockKrylovSchurEpetra_setStepSize(self, *args)


    def setNumRitzVectors(self, *args):
        """setNumRitzVectors(BlockKrylovSchurEpetra self, int numRitzVecs)"""
        return _Anasazi.BlockKrylovSchurEpetra_setNumRitzVectors(self, *args)


    def getStepSize(self, *args):
        """getStepSize(BlockKrylovSchurEpetra self) -> int"""
        return _Anasazi.BlockKrylovSchurEpetra_getStepSize(self, *args)


    def getBlockSize(self, *args):
        """getBlockSize(BlockKrylovSchurEpetra self) -> int"""
        return _Anasazi.BlockKrylovSchurEpetra_getBlockSize(self, *args)


    def getNumRitzVectors(self, *args):
        """getNumRitzVectors(BlockKrylovSchurEpetra self) -> int"""
        return _Anasazi.BlockKrylovSchurEpetra_getNumRitzVectors(self, *args)


    def getCurSubspaceDim(self, *args):
        """getCurSubspaceDim(BlockKrylovSchurEpetra self) -> int"""
        return _Anasazi.BlockKrylovSchurEpetra_getCurSubspaceDim(self, *args)


    def getMaxSubspaceDim(self, *args):
        """getMaxSubspaceDim(BlockKrylovSchurEpetra self) -> int"""
        return _Anasazi.BlockKrylovSchurEpetra_getMaxSubspaceDim(self, *args)


    def setAuxVecs(self, *args):
        """setAuxVecs(BlockKrylovSchurEpetra self, Teuchos::Array< Teuchos::RCP< Epetra_MultiVector const > > const & auxvecs)"""
        return _Anasazi.BlockKrylovSchurEpetra_setAuxVecs(self, *args)


    def getAuxVecs(self, *args):
        """getAuxVecs(BlockKrylovSchurEpetra self) -> Teuchos::Array< Teuchos::RCP< Epetra_MultiVector const > >"""
        return _Anasazi.BlockKrylovSchurEpetra_getAuxVecs(self, *args)


    def currentStatus(self, *args):
        """currentStatus(BlockKrylovSchurEpetra self, std::ostream & os)"""
        return _Anasazi.BlockKrylovSchurEpetra_currentStatus(self, *args)


    def isRitzVecsCurrent(self, *args):
        """isRitzVecsCurrent(BlockKrylovSchurEpetra self) -> bool"""
        return _Anasazi.BlockKrylovSchurEpetra_isRitzVecsCurrent(self, *args)


    def isRitzValsCurrent(self, *args):
        """isRitzValsCurrent(BlockKrylovSchurEpetra self) -> bool"""
        return _Anasazi.BlockKrylovSchurEpetra_isRitzValsCurrent(self, *args)


    def isSchurCurrent(self, *args):
        """isSchurCurrent(BlockKrylovSchurEpetra self) -> bool"""
        return _Anasazi.BlockKrylovSchurEpetra_isSchurCurrent(self, *args)


    def computeRitzVectors(self, *args):
        """computeRitzVectors(BlockKrylovSchurEpetra self)"""
        return _Anasazi.BlockKrylovSchurEpetra_computeRitzVectors(self, *args)


    def computeRitzValues(self, *args):
        """computeRitzValues(BlockKrylovSchurEpetra self)"""
        return _Anasazi.BlockKrylovSchurEpetra_computeRitzValues(self, *args)


    def computeSchurForm(self, *args):
        """computeSchurForm(BlockKrylovSchurEpetra self, bool const sort=True)"""
        return _Anasazi.BlockKrylovSchurEpetra_computeSchurForm(self, *args)

BlockKrylovSchurEpetra_swigregister = _Anasazi.BlockKrylovSchurEpetra_swigregister
BlockKrylovSchurEpetra_swigregister(BlockKrylovSchurEpetra)

class BlockKrylovSchurSolMgrEpetra(SolverManagerEpetra):
    """Proxy of C++ Anasazi::BlockKrylovSchurSolMgr<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    for _s in [SolverManagerEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, BlockKrylovSchurSolMgrEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [SolverManagerEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, BlockKrylovSchurSolMgrEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::BlockKrylovSchurSolMgr<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Anasazi::Eigenproblem< double,Epetra_MultiVector,Epetra_Operator > > const & problem, ParameterList pl) -> BlockKrylovSchurSolMgrEpetra"""
        this = _Anasazi.new_BlockKrylovSchurSolMgrEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_BlockKrylovSchurSolMgrEpetra

    def getProblem(self, *args):
        """getProblem(BlockKrylovSchurSolMgrEpetra self) -> EigenproblemEpetra"""
        return _Anasazi.BlockKrylovSchurSolMgrEpetra_getProblem(self, *args)


    def getNumIters(self, *args):
        """getNumIters(BlockKrylovSchurSolMgrEpetra self) -> int"""
        return _Anasazi.BlockKrylovSchurSolMgrEpetra_getNumIters(self, *args)


    def getRitzValues(self, *args):
        """getRitzValues(BlockKrylovSchurSolMgrEpetra self) -> VectorValueDouble"""
        return _Anasazi.BlockKrylovSchurSolMgrEpetra_getRitzValues(self, *args)


    def getTimers(self, *args):
        """getTimers(BlockKrylovSchurSolMgrEpetra self) -> Teuchos::Array< Teuchos::RCP< Teuchos::Time > >"""
        return _Anasazi.BlockKrylovSchurSolMgrEpetra_getTimers(self, *args)


    def solve(self, *args):
        """solve(BlockKrylovSchurSolMgrEpetra self) -> Anasazi::ReturnType"""
        return _Anasazi.BlockKrylovSchurSolMgrEpetra_solve(self, *args)


    def setGlobalStatusTest(self, *args):
        """setGlobalStatusTest(BlockKrylovSchurSolMgrEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & arg2)"""
        return _Anasazi.BlockKrylovSchurSolMgrEpetra_setGlobalStatusTest(self, *args)


    def getGlobalStatusTest(self, *args):
        """getGlobalStatusTest(BlockKrylovSchurSolMgrEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const &"""
        return _Anasazi.BlockKrylovSchurSolMgrEpetra_getGlobalStatusTest(self, *args)


    def setDebugStatusTest(self, *args):
        """setDebugStatusTest(BlockKrylovSchurSolMgrEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & debug)"""
        return _Anasazi.BlockKrylovSchurSolMgrEpetra_setDebugStatusTest(self, *args)


    def getDebugStatusTest(self, *args):
        """getDebugStatusTest(BlockKrylovSchurSolMgrEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const &"""
        return _Anasazi.BlockKrylovSchurSolMgrEpetra_getDebugStatusTest(self, *args)

BlockKrylovSchurSolMgrEpetra_swigregister = _Anasazi.BlockKrylovSchurSolMgrEpetra_swigregister
BlockKrylovSchurSolMgrEpetra_swigregister(BlockKrylovSchurSolMgrEpetra)

class LOBPCGEpetra(EigensolverEpetra):
    """Proxy of C++ Anasazi::LOBPCG<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    for _s in [EigensolverEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LOBPCGEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [EigensolverEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LOBPCGEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::LOBPCG<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Anasazi::Eigenproblem< double,Epetra_MultiVector,Epetra_Operator > > const & problem, Teuchos::RCP< Anasazi::SortManager< Teuchos::ScalarTraits< double >::magnitudeType > > const & sorter, Teuchos::RCP< Anasazi::OutputManager< double > > const & printer, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & tester, Teuchos::RCP< Anasazi::MatOrthoManager< double,Epetra_MultiVector,Epetra_Operator > > const & ortho, ParameterList params) -> LOBPCGEpetra"""
        this = _Anasazi.new_LOBPCGEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_LOBPCGEpetra

    def iterate(self, *args):
        """iterate(LOBPCGEpetra self)"""
        return _Anasazi.LOBPCGEpetra_iterate(self, *args)


    def initialize(self, *args):
        """
        initialize(LOBPCGEpetra self, Anasazi::LOBPCGState< double,Epetra_MultiVector > & newstate)
        initialize(LOBPCGEpetra self)
        """
        return _Anasazi.LOBPCGEpetra_initialize(self, *args)


    def isInitialized(self, *args):
        """isInitialized(LOBPCGEpetra self) -> bool"""
        return _Anasazi.LOBPCGEpetra_isInitialized(self, *args)


    def getState(self, *args):
        """getState(LOBPCGEpetra self) -> Anasazi::LOBPCGState< double,Epetra_MultiVector >"""
        return _Anasazi.LOBPCGEpetra_getState(self, *args)


    def getNumIters(self, *args):
        """getNumIters(LOBPCGEpetra self) -> int"""
        return _Anasazi.LOBPCGEpetra_getNumIters(self, *args)


    def resetNumIters(self, *args):
        """resetNumIters(LOBPCGEpetra self)"""
        return _Anasazi.LOBPCGEpetra_resetNumIters(self, *args)


    def getRitzVectors(self, *args):
        """getRitzVectors(LOBPCGEpetra self) -> Teuchos::RCP< Epetra_MultiVector const >"""
        return _Anasazi.LOBPCGEpetra_getRitzVectors(self, *args)


    def getRitzValues(self, *args):
        """getRitzValues(LOBPCGEpetra self) -> VectorValueDouble"""
        return _Anasazi.LOBPCGEpetra_getRitzValues(self, *args)


    def getRitzIndex(self, *args):
        """getRitzIndex(LOBPCGEpetra self) -> VectorInt"""
        return _Anasazi.LOBPCGEpetra_getRitzIndex(self, *args)


    def getResNorms(self, *args):
        """getResNorms(LOBPCGEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >"""
        return _Anasazi.LOBPCGEpetra_getResNorms(self, *args)


    def getRes2Norms(self, *args):
        """getRes2Norms(LOBPCGEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >"""
        return _Anasazi.LOBPCGEpetra_getRes2Norms(self, *args)


    def getRitzRes2Norms(self, *args):
        """getRitzRes2Norms(LOBPCGEpetra self) -> std::vector< Teuchos::ScalarTraits< double >::magnitudeType,std::allocator< Teuchos::ScalarTraits< double >::magnitudeType > >"""
        return _Anasazi.LOBPCGEpetra_getRitzRes2Norms(self, *args)


    def getCurSubspaceDim(self, *args):
        """getCurSubspaceDim(LOBPCGEpetra self) -> int"""
        return _Anasazi.LOBPCGEpetra_getCurSubspaceDim(self, *args)


    def getMaxSubspaceDim(self, *args):
        """getMaxSubspaceDim(LOBPCGEpetra self) -> int"""
        return _Anasazi.LOBPCGEpetra_getMaxSubspaceDim(self, *args)


    def setStatusTest(self, *args):
        """setStatusTest(LOBPCGEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > test)"""
        return _Anasazi.LOBPCGEpetra_setStatusTest(self, *args)


    def getStatusTest(self, *args):
        """getStatusTest(LOBPCGEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > >"""
        return _Anasazi.LOBPCGEpetra_getStatusTest(self, *args)


    def getProblem(self, *args):
        """getProblem(LOBPCGEpetra self) -> EigenproblemEpetra"""
        return _Anasazi.LOBPCGEpetra_getProblem(self, *args)


    def setBlockSize(self, *args):
        """setBlockSize(LOBPCGEpetra self, int blockSize)"""
        return _Anasazi.LOBPCGEpetra_setBlockSize(self, *args)


    def getBlockSize(self, *args):
        """getBlockSize(LOBPCGEpetra self) -> int"""
        return _Anasazi.LOBPCGEpetra_getBlockSize(self, *args)


    def setAuxVecs(self, *args):
        """setAuxVecs(LOBPCGEpetra self, Teuchos::Array< Teuchos::RCP< Epetra_MultiVector const > > const & auxvecs)"""
        return _Anasazi.LOBPCGEpetra_setAuxVecs(self, *args)


    def getAuxVecs(self, *args):
        """getAuxVecs(LOBPCGEpetra self) -> Teuchos::Array< Teuchos::RCP< Epetra_MultiVector const > >"""
        return _Anasazi.LOBPCGEpetra_getAuxVecs(self, *args)


    def setFullOrtho(self, *args):
        """setFullOrtho(LOBPCGEpetra self, bool fullOrtho)"""
        return _Anasazi.LOBPCGEpetra_setFullOrtho(self, *args)


    def getFullOrtho(self, *args):
        """getFullOrtho(LOBPCGEpetra self) -> bool"""
        return _Anasazi.LOBPCGEpetra_getFullOrtho(self, *args)


    def hasP(self, *args):
        """hasP(LOBPCGEpetra self) -> bool"""
        return _Anasazi.LOBPCGEpetra_hasP(self, *args)


    def currentStatus(self, *args):
        """currentStatus(LOBPCGEpetra self, std::ostream & os)"""
        return _Anasazi.LOBPCGEpetra_currentStatus(self, *args)

LOBPCGEpetra_swigregister = _Anasazi.LOBPCGEpetra_swigregister
LOBPCGEpetra_swigregister(LOBPCGEpetra)

class LOBPCGSolMgrEpetra(SolverManagerEpetra):
    """Proxy of C++ Anasazi::LOBPCGSolMgr<(double,Epetra_MultiVector,Epetra_Operator)> class."""

    __swig_setmethods__ = {}
    for _s in [SolverManagerEpetra]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LOBPCGSolMgrEpetra, name, value)
    __swig_getmethods__ = {}
    for _s in [SolverManagerEpetra]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LOBPCGSolMgrEpetra, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """__init__(Anasazi::LOBPCGSolMgr<(double,Epetra_MultiVector,Epetra_Operator)> self, Teuchos::RCP< Anasazi::Eigenproblem< double,Epetra_MultiVector,Epetra_Operator > > const & problem, ParameterList pl) -> LOBPCGSolMgrEpetra"""
        this = _Anasazi.new_LOBPCGSolMgrEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_LOBPCGSolMgrEpetra

    def getProblem(self, *args):
        """getProblem(LOBPCGSolMgrEpetra self) -> EigenproblemEpetra"""
        return _Anasazi.LOBPCGSolMgrEpetra_getProblem(self, *args)


    def getNumIters(self, *args):
        """getNumIters(LOBPCGSolMgrEpetra self) -> int"""
        return _Anasazi.LOBPCGSolMgrEpetra_getNumIters(self, *args)


    def getTimers(self, *args):
        """getTimers(LOBPCGSolMgrEpetra self) -> Teuchos::Array< Teuchos::RCP< Teuchos::Time > >"""
        return _Anasazi.LOBPCGSolMgrEpetra_getTimers(self, *args)


    def solve(self, *args):
        """solve(LOBPCGSolMgrEpetra self) -> Anasazi::ReturnType"""
        return _Anasazi.LOBPCGSolMgrEpetra_solve(self, *args)


    def setGlobalStatusTest(self, *args):
        """setGlobalStatusTest(LOBPCGSolMgrEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & arg2)"""
        return _Anasazi.LOBPCGSolMgrEpetra_setGlobalStatusTest(self, *args)


    def getGlobalStatusTest(self, *args):
        """getGlobalStatusTest(LOBPCGSolMgrEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const &"""
        return _Anasazi.LOBPCGSolMgrEpetra_getGlobalStatusTest(self, *args)


    def setLockingStatusTest(self, *args):
        """setLockingStatusTest(LOBPCGSolMgrEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & locking)"""
        return _Anasazi.LOBPCGSolMgrEpetra_setLockingStatusTest(self, *args)


    def getLockingStatusTest(self, *args):
        """getLockingStatusTest(LOBPCGSolMgrEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const &"""
        return _Anasazi.LOBPCGSolMgrEpetra_getLockingStatusTest(self, *args)


    def setDebugStatusTest(self, *args):
        """setDebugStatusTest(LOBPCGSolMgrEpetra self, Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const & debug)"""
        return _Anasazi.LOBPCGSolMgrEpetra_setDebugStatusTest(self, *args)


    def getDebugStatusTest(self, *args):
        """getDebugStatusTest(LOBPCGSolMgrEpetra self) -> Teuchos::RCP< Anasazi::StatusTest< double,Epetra_MultiVector,Epetra_Operator > > const &"""
        return _Anasazi.LOBPCGSolMgrEpetra_getDebugStatusTest(self, *args)

LOBPCGSolMgrEpetra_swigregister = _Anasazi.LOBPCGSolMgrEpetra_swigregister
LOBPCGSolMgrEpetra_swigregister(LOBPCGSolMgrEpetra)

class EigensolutionEpetra(_object):
    """Proxy of C++ Anasazi::Eigensolution<(double,Epetra_MultiVector)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, EigensolutionEpetra, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, EigensolutionEpetra, name)
    __repr__ = _swig_repr
    __swig_setmethods__["index"] = _Anasazi.EigensolutionEpetra_index_set
    __swig_getmethods__["index"] = _Anasazi.EigensolutionEpetra_index_get
    if _newclass:
        index = _swig_property(_Anasazi.EigensolutionEpetra_index_get, _Anasazi.EigensolutionEpetra_index_set)
    __swig_setmethods__["numVecs"] = _Anasazi.EigensolutionEpetra_numVecs_set
    __swig_getmethods__["numVecs"] = _Anasazi.EigensolutionEpetra_numVecs_get
    if _newclass:
        numVecs = _swig_property(_Anasazi.EigensolutionEpetra_numVecs_get, _Anasazi.EigensolutionEpetra_numVecs_set)

    def __init__(self, *args):
        """__init__(Anasazi::Eigensolution<(double,Epetra_MultiVector)> self) -> EigensolutionEpetra"""
        this = _Anasazi.new_EigensolutionEpetra(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _Anasazi.delete_EigensolutionEpetra
EigensolutionEpetra_swigregister = _Anasazi.EigensolutionEpetra_swigregister
EigensolutionEpetra_swigregister(EigensolutionEpetra)

class VectorValueDouble(_object):
    """Proxy of C++ std::vector<(Anasazi::Value<(double)>)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VectorValueDouble, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VectorValueDouble, name)
    __repr__ = _swig_repr

    def iterator(self, *args):
        """iterator(VectorValueDouble self) -> SwigPyIterator"""
        return _Anasazi.VectorValueDouble_iterator(self, *args)

    def __iter__(self):
        return self.iterator()

    def __nonzero__(self, *args):
        """__nonzero__(VectorValueDouble self) -> bool"""
        return _Anasazi.VectorValueDouble___nonzero__(self, *args)


    def __bool__(self, *args):
        """__bool__(VectorValueDouble self) -> bool"""
        return _Anasazi.VectorValueDouble___bool__(self, *args)


    def __len__(self, *args):
        """__len__(VectorValueDouble self) -> std::vector< Anasazi::Value< double > >::size_type"""
        return _Anasazi.VectorValueDouble___len__(self, *args)


    def __getslice__(self, *args):
        """__getslice__(VectorValueDouble self, std::vector< Anasazi::Value< double > >::difference_type i, std::vector< Anasazi::Value< double > >::difference_type j) -> VectorValueDouble"""
        return _Anasazi.VectorValueDouble___getslice__(self, *args)


    def __setslice__(self, *args):
        """
        __setslice__(VectorValueDouble self, std::vector< Anasazi::Value< double > >::difference_type i, std::vector< Anasazi::Value< double > >::difference_type j)
        __setslice__(VectorValueDouble self, std::vector< Anasazi::Value< double > >::difference_type i, std::vector< Anasazi::Value< double > >::difference_type j, VectorValueDouble v)
        """
        return _Anasazi.VectorValueDouble___setslice__(self, *args)


    def __delslice__(self, *args):
        """__delslice__(VectorValueDouble self, std::vector< Anasazi::Value< double > >::difference_type i, std::vector< Anasazi::Value< double > >::difference_type j)"""
        return _Anasazi.VectorValueDouble___delslice__(self, *args)


    def __delitem__(self, *args):
        """
        __delitem__(VectorValueDouble self, std::vector< Anasazi::Value< double > >::difference_type i)
        __delitem__(VectorValueDouble self, PySliceObject * slice)
        """
        return _Anasazi.VectorValueDouble___delitem__(self, *args)


    def __getitem__(self, *args):
        """
        __getitem__(VectorValueDouble self, PySliceObject * slice) -> VectorValueDouble
        __getitem__(VectorValueDouble self, std::vector< Anasazi::Value< double > >::difference_type i) -> ValueDouble
        """
        return _Anasazi.VectorValueDouble___getitem__(self, *args)


    def __setitem__(self, *args):
        """
        __setitem__(VectorValueDouble self, PySliceObject * slice, VectorValueDouble v)
        __setitem__(VectorValueDouble self, PySliceObject * slice)
        __setitem__(VectorValueDouble self, std::vector< Anasazi::Value< double > >::difference_type i, ValueDouble x)
        """
        return _Anasazi.VectorValueDouble___setitem__(self, *args)


    def pop(self, *args):
        """pop(VectorValueDouble self) -> ValueDouble"""
        return _Anasazi.VectorValueDouble_pop(self, *args)


    def append(self, *args):
        """append(VectorValueDouble self, ValueDouble x)"""
        return _Anasazi.VectorValueDouble_append(self, *args)


    def empty(self, *args):
        """empty(VectorValueDouble self) -> bool"""
        return _Anasazi.VectorValueDouble_empty(self, *args)


    def size(self, *args):
        """size(VectorValueDouble self) -> std::vector< Anasazi::Value< double > >::size_type"""
        return _Anasazi.VectorValueDouble_size(self, *args)


    def swap(self, *args):
        """swap(VectorValueDouble self, VectorValueDouble v)"""
        return _Anasazi.VectorValueDouble_swap(self, *args)


    def begin(self, *args):
        """begin(VectorValueDouble self) -> std::vector< Anasazi::Value< double > >::iterator"""
        return _Anasazi.VectorValueDouble_begin(self, *args)


    def end(self, *args):
        """end(VectorValueDouble self) -> std::vector< Anasazi::Value< double > >::iterator"""
        return _Anasazi.VectorValueDouble_end(self, *args)


    def rbegin(self, *args):
        """rbegin(VectorValueDouble self) -> std::vector< Anasazi::Value< double > >::reverse_iterator"""
        return _Anasazi.VectorValueDouble_rbegin(self, *args)


    def rend(self, *args):
        """rend(VectorValueDouble self) -> std::vector< Anasazi::Value< double > >::reverse_iterator"""
        return _Anasazi.VectorValueDouble_rend(self, *args)


    def clear(self, *args):
        """clear(VectorValueDouble self)"""
        return _Anasazi.VectorValueDouble_clear(self, *args)


    def get_allocator(self, *args):
        """get_allocator(VectorValueDouble self) -> std::vector< Anasazi::Value< double > >::allocator_type"""
        return _Anasazi.VectorValueDouble_get_allocator(self, *args)


    def pop_back(self, *args):
        """pop_back(VectorValueDouble self)"""
        return _Anasazi.VectorValueDouble_pop_back(self, *args)


    def erase(self, *args):
        """
        erase(VectorValueDouble self, std::vector< Anasazi::Value< double > >::iterator pos) -> std::vector< Anasazi::Value< double > >::iterator
        erase(VectorValueDouble self, std::vector< Anasazi::Value< double > >::iterator first, std::vector< Anasazi::Value< double > >::iterator last) -> std::vector< Anasazi::Value< double > >::iterator
        """
        return _Anasazi.VectorValueDouble_erase(self, *args)


    def __init__(self, *args):
        """
        __init__(std::vector<(Anasazi::Value<(double)>)> self) -> VectorValueDouble
        __init__(std::vector<(Anasazi::Value<(double)>)> self, VectorValueDouble arg2) -> VectorValueDouble
        __init__(std::vector<(Anasazi::Value<(double)>)> self, std::vector< Anasazi::Value< double > >::size_type size) -> VectorValueDouble
        __init__(std::vector<(Anasazi::Value<(double)>)> self, std::vector< Anasazi::Value< double > >::size_type size, ValueDouble value) -> VectorValueDouble
        """
        this = _Anasazi.new_VectorValueDouble(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, *args):
        """push_back(VectorValueDouble self, ValueDouble x)"""
        return _Anasazi.VectorValueDouble_push_back(self, *args)


    def front(self, *args):
        """front(VectorValueDouble self) -> ValueDouble"""
        return _Anasazi.VectorValueDouble_front(self, *args)


    def back(self, *args):
        """back(VectorValueDouble self) -> ValueDouble"""
        return _Anasazi.VectorValueDouble_back(self, *args)


    def assign(self, *args):
        """assign(VectorValueDouble self, std::vector< Anasazi::Value< double > >::size_type n, ValueDouble x)"""
        return _Anasazi.VectorValueDouble_assign(self, *args)


    def resize(self, *args):
        """
        resize(VectorValueDouble self, std::vector< Anasazi::Value< double > >::size_type new_size)
        resize(VectorValueDouble self, std::vector< Anasazi::Value< double > >::size_type new_size, ValueDouble x)
        """
        return _Anasazi.VectorValueDouble_resize(self, *args)


    def insert(self, *args):
        """
        insert(VectorValueDouble self, std::vector< Anasazi::Value< double > >::iterator pos, ValueDouble x) -> std::vector< Anasazi::Value< double > >::iterator
        insert(VectorValueDouble self, std::vector< Anasazi::Value< double > >::iterator pos, std::vector< Anasazi::Value< double > >::size_type n, ValueDouble x)
        """
        return _Anasazi.VectorValueDouble_insert(self, *args)


    def reserve(self, *args):
        """reserve(VectorValueDouble self, std::vector< Anasazi::Value< double > >::size_type n)"""
        return _Anasazi.VectorValueDouble_reserve(self, *args)


    def capacity(self, *args):
        """capacity(VectorValueDouble self) -> std::vector< Anasazi::Value< double > >::size_type"""
        return _Anasazi.VectorValueDouble_capacity(self, *args)

    __swig_destroy__ = _Anasazi.delete_VectorValueDouble
VectorValueDouble_swigregister = _Anasazi.VectorValueDouble_swigregister
VectorValueDouble_swigregister(VectorValueDouble)

class VectorInt(_object):
    """Proxy of C++ std::vector<(int)> class."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VectorInt, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VectorInt, name)
    __repr__ = _swig_repr

    def iterator(self, *args):
        """iterator(VectorInt self) -> SwigPyIterator"""
        return _Anasazi.VectorInt_iterator(self, *args)

    def __iter__(self):
        return self.iterator()

    def __nonzero__(self, *args):
        """__nonzero__(VectorInt self) -> bool"""
        return _Anasazi.VectorInt___nonzero__(self, *args)


    def __bool__(self, *args):
        """__bool__(VectorInt self) -> bool"""
        return _Anasazi.VectorInt___bool__(self, *args)


    def __len__(self, *args):
        """__len__(VectorInt self) -> std::vector< int >::size_type"""
        return _Anasazi.VectorInt___len__(self, *args)


    def __getslice__(self, *args):
        """__getslice__(VectorInt self, std::vector< int >::difference_type i, std::vector< int >::difference_type j) -> VectorInt"""
        return _Anasazi.VectorInt___getslice__(self, *args)


    def __setslice__(self, *args):
        """
        __setslice__(VectorInt self, std::vector< int >::difference_type i, std::vector< int >::difference_type j)
        __setslice__(VectorInt self, std::vector< int >::difference_type i, std::vector< int >::difference_type j, VectorInt v)
        """
        return _Anasazi.VectorInt___setslice__(self, *args)


    def __delslice__(self, *args):
        """__delslice__(VectorInt self, std::vector< int >::difference_type i, std::vector< int >::difference_type j)"""
        return _Anasazi.VectorInt___delslice__(self, *args)


    def __delitem__(self, *args):
        """
        __delitem__(VectorInt self, std::vector< int >::difference_type i)
        __delitem__(VectorInt self, PySliceObject * slice)
        """
        return _Anasazi.VectorInt___delitem__(self, *args)


    def __getitem__(self, *args):
        """
        __getitem__(VectorInt self, PySliceObject * slice) -> VectorInt
        __getitem__(VectorInt self, std::vector< int >::difference_type i) -> std::vector< int >::value_type const &
        """
        return _Anasazi.VectorInt___getitem__(self, *args)


    def __setitem__(self, *args):
        """
        __setitem__(VectorInt self, PySliceObject * slice, VectorInt v)
        __setitem__(VectorInt self, PySliceObject * slice)
        __setitem__(VectorInt self, std::vector< int >::difference_type i, std::vector< int >::value_type const & x)
        """
        return _Anasazi.VectorInt___setitem__(self, *args)


    def pop(self, *args):
        """pop(VectorInt self) -> std::vector< int >::value_type"""
        return _Anasazi.VectorInt_pop(self, *args)


    def append(self, *args):
        """append(VectorInt self, std::vector< int >::value_type const & x)"""
        return _Anasazi.VectorInt_append(self, *args)


    def empty(self, *args):
        """empty(VectorInt self) -> bool"""
        return _Anasazi.VectorInt_empty(self, *args)


    def size(self, *args):
        """size(VectorInt self) -> std::vector< int >::size_type"""
        return _Anasazi.VectorInt_size(self, *args)


    def swap(self, *args):
        """swap(VectorInt self, VectorInt v)"""
        return _Anasazi.VectorInt_swap(self, *args)


    def begin(self, *args):
        """begin(VectorInt self) -> std::vector< int >::iterator"""
        return _Anasazi.VectorInt_begin(self, *args)


    def end(self, *args):
        """end(VectorInt self) -> std::vector< int >::iterator"""
        return _Anasazi.VectorInt_end(self, *args)


    def rbegin(self, *args):
        """rbegin(VectorInt self) -> std::vector< int >::reverse_iterator"""
        return _Anasazi.VectorInt_rbegin(self, *args)


    def rend(self, *args):
        """rend(VectorInt self) -> std::vector< int >::reverse_iterator"""
        return _Anasazi.VectorInt_rend(self, *args)


    def clear(self, *args):
        """clear(VectorInt self)"""
        return _Anasazi.VectorInt_clear(self, *args)


    def get_allocator(self, *args):
        """get_allocator(VectorInt self) -> std::vector< int >::allocator_type"""
        return _Anasazi.VectorInt_get_allocator(self, *args)


    def pop_back(self, *args):
        """pop_back(VectorInt self)"""
        return _Anasazi.VectorInt_pop_back(self, *args)


    def erase(self, *args):
        """
        erase(VectorInt self, std::vector< int >::iterator pos) -> std::vector< int >::iterator
        erase(VectorInt self, std::vector< int >::iterator first, std::vector< int >::iterator last) -> std::vector< int >::iterator
        """
        return _Anasazi.VectorInt_erase(self, *args)


    def __init__(self, *args):
        """
        __init__(std::vector<(int)> self) -> VectorInt
        __init__(std::vector<(int)> self, VectorInt arg2) -> VectorInt
        __init__(std::vector<(int)> self, std::vector< int >::size_type size) -> VectorInt
        __init__(std::vector<(int)> self, std::vector< int >::size_type size, std::vector< int >::value_type const & value) -> VectorInt
        """
        this = _Anasazi.new_VectorInt(*args)
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this

    def push_back(self, *args):
        """push_back(VectorInt self, std::vector< int >::value_type const & x)"""
        return _Anasazi.VectorInt_push_back(self, *args)


    def front(self, *args):
        """front(VectorInt self) -> std::vector< int >::value_type const &"""
        return _Anasazi.VectorInt_front(self, *args)


    def back(self, *args):
        """back(VectorInt self) -> std::vector< int >::value_type const &"""
        return _Anasazi.VectorInt_back(self, *args)


    def assign(self, *args):
        """assign(VectorInt self, std::vector< int >::size_type n, std::vector< int >::value_type const & x)"""
        return _Anasazi.VectorInt_assign(self, *args)


    def resize(self, *args):
        """
        resize(VectorInt self, std::vector< int >::size_type new_size)
        resize(VectorInt self, std::vector< int >::size_type new_size, std::vector< int >::value_type const & x)
        """
        return _Anasazi.VectorInt_resize(self, *args)


    def insert(self, *args):
        """
        insert(VectorInt self, std::vector< int >::iterator pos, std::vector< int >::value_type const & x) -> std::vector< int >::iterator
        insert(VectorInt self, std::vector< int >::iterator pos, std::vector< int >::size_type n, std::vector< int >::value_type const & x)
        """
        return _Anasazi.VectorInt_insert(self, *args)


    def reserve(self, *args):
        """reserve(VectorInt self, std::vector< int >::size_type n)"""
        return _Anasazi.VectorInt_reserve(self, *args)


    def capacity(self, *args):
        """capacity(VectorInt self) -> std::vector< int >::size_type"""
        return _Anasazi.VectorInt_capacity(self, *args)

    __swig_destroy__ = _Anasazi.delete_VectorInt
VectorInt_swigregister = _Anasazi.VectorInt_swigregister
VectorInt_swigregister(VectorInt)


def Value(*args):
    """
    Factory function for class Value.  Currently, this returns a python
    wrapper around class Value<double>.
    """
    return ValueDouble(*args)


def OutputManager(*args):
    """
    Factory function for class OutputManager.  Currently, this returns a python
    wrapper around class OutputManager<double>.
    """
    return OutputManagerDouble(*args)


def BasicOutputManager(*args):
    """
    Factory function for class BasicOutputManager.  Currently, this returns a python
    wrapper around class BasicOutputManager<double>.
    """
    return BasicOutputManagerDouble(*args)


def MultiVec(*args):
    """
    Factory function for class MultiVec.  Currently, this returns a python
    wrapper around class MultiVec<double>.
    """
    return MultiVecDouble(*args)


def Operator(*args):
    """
    Factory function for class Operator.  Currently, this returns a python
    wrapper around class Operator<double>.
    """
    return OperatorDouble(*args)


def SortManager(*args):
    """
    Factory function for class SortManager.  Currently, this returns a python
    wrapper around class SortManager<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return SortManagerEpetra(*args)


def BasicSort(*args):
    """
    Factory function for class BasicSort.  Currently, this returns a python
    wrapper around class BasicSort<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return BasicSortEpetra(*args)


def MultiVecTraits(*args):
    """
    Factory function for class MultiVecTraits.  Currently, this returns a python
    wrapper around class MultiVecTraits<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return MultiVecTraitsEpetra(*args)


def OperatorTraits(*args):
    """
    Factory function for class OperatorTraits.  Currently, this returns a python
    wrapper around class OperatorTraits<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return OperatorTraitsEpetra(*args)


def Eigenproblem(*args):
    """
    Factory function for class Eigenproblem.  Currently, this returns a python
    wrapper around class Eigenproblem<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return EigenproblemEpetra(*args)


def BasicEigenproblem(*args):
    """
    Factory function for class BasicEigenproblem.  Currently, this returns a python
    wrapper around class BasicEigenproblem<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return BasicEigenproblemEpetra(*args)


def StatusTest(*args):
    """
    Factory function for class StatusTest.  Currently, this returns a python
    wrapper around class StatusTest<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return StatusTestEpetra(*args)


def StatusTestCombo(*args):
    """
    Factory function for class StatusTestCombo.  Currently, this returns a python
    wrapper around class StatusTestCombo<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return StatusTestComboEpetra(*args)


def StatusTestMaxIters(*args):
    """
    Factory function for class StatusTestMaxIters.  Currently, this returns a python
    wrapper around class StatusTestMaxIters<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return StatusTestMaxItersEpetra(*args)


def StatusTestOutput(*args):
    """
    Factory function for class StatusTestOutput.  Currently, this returns a python
    wrapper around class StatusTestOutput<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return StatusTestOutputEpetra(*args)


def StatusTestResNorm(*args):
    """
    Factory function for class StatusTestResNorm.  Currently, this returns a python
    wrapper around class StatusTestResNorm<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return StatusTestResNormEpetra(*args)


def OrthoManager(*args):
    """
    Factory function for class OrthoManager.  Currently, this returns a python
    wrapper around class OrthoManager<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return OrthoManagerEpetra(*args)


def MatOrthoManager(*args):
    """
    Factory function for class MatOrthoManager.  Currently, this returns a python
    wrapper around class MatOrthoManager<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return MatOrthoManagerEpetra(*args)


def SVQBOrthoManager(*args):
    """
    Factory function for class SVQBOrthoManager.  Currently, this returns a python
    wrapper around class SVQBOrthoManager<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return SVQBOrthoManagerEpetra(*args)


def Eigensolver(*args):
    """
    Factory function for class Eigensolver.  Currently, this returns a python
    wrapper around class Eigensolver<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return EigensolverEpetra(*args)


def SolverManager(*args):
    """
    Factory function for class SolverManager.  Currently, this returns a python
    wrapper around class SolverManager<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return SolverManagerEpetra(*args)


def BlockDavidson(*args):
    """
    Factory function for class BlockDavidson.  Currently, this returns a python
    wrapper around class BlockDavidson<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return BlockDavidsonEpetra(*args)


def BlockDavidsonSolMgr(*args):
    """
    Factory function for class BlockDavidsonSolMgr.  Currently, this returns a python
    wrapper around class BlockDavidsonSolMgr<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return BlockDavidsonSolMgrEpetra(*args)


def BlockKrylovSchur(*args):
    """
    Factory function for class BlockKrylovSchur.  Currently, this returns a python
    wrapper around class BlockKrylovSchur<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return BlockKrylovSchurEpetra(*args)


def BlockKrylovSchurSolMgr(*args):
    """
    Factory function for class BlockKrylovSchurSolMgr.  Currently, this returns a python
    wrapper around class BlockKrylovSchurSolMgr<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return BlockKrylovSchurSolMgrEpetra(*args)


def LOBPCG(*args):
    """
    Factory function for class LOBPCG.  Currently, this returns a python
    wrapper around class LOBPCG<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return LOBPCGEpetra(*args)


def LOBPCGSolMgr(*args):
    """
    Factory function for class LOBPCGSolMgr.  Currently, this returns a python
    wrapper around class LOBPCGSolMgr<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return LOBPCGSolMgrEpetra(*args)


def Eigensolution(*args):
    """
    Factory function for class Eigensolution.  Currently, this returns a python
    wrapper around class Eigensolution<double,Epetra_MultiVector,Epetra_Operator>.
    """
    return EigensolutionEpetra(*args)

# This file is compatible with both classic and new-style classes.


