#----------------------------------*-sh-*--------------------------------------
# =========                 |
# \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
#  \\    /   O peration     |
#   \\  /    A nd           | Copyright (C) 2011-2016 OpenFOAM Foundation
#    \\/     M anipulation  |
#------------------------------------------------------------------------------
# License
#     This file is part of OpenFOAM.
#
#     OpenFOAM is free software: you can redistribute it and/or modify it
#     under the terms of the GNU General Public License as published by
#     the Free Software Foundation, either version 3 of the License, or
#     (at your option) any later version.
#
#     OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
#     ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#     FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#     for more details.
#
#     You should have received a copy of the GNU General Public License
#     along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.
#
# File
#     etc/config/aliases.csh
#
# Description
#     Aliases for working with OpenFOAM
#     Sourced from OpenFOAM-<VERSION>/etc/cshrc and/or ~/.cshrc
#
#------------------------------------------------------------------------------

# Change compiled version aliases
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
alias wmSet 'source $WM_PROJECT_DIR/etc/cshrc'
alias wm64 'wmSet WM_ARCH_OPTION=64'
alias wm32 'wmSet WM_ARCH_OPTION=32'
alias wmSP 'wmSet WM_PRECISION_OPTION=SP'
alias wmDP 'wmSet WM_PRECISION_OPTION=DP'

# Refresh the environment
alias wmRefresh 'wmSet $FOAM_SETTINGS'

# Clear env
alias wmUnset 'source $WM_PROJECT_DIR/etc/config/unset.csh'

# Toggle wmakeScheduler on/off
#  - also need to set WM_HOSTS
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
alias wmSchedOn 'setenv WM_SCHEDULER $WM_PROJECT_DIR/wmake/wmakeScheduler'
alias wmSchedOff 'unsetenv WM_SCHEDULER'


# Change directory aliases
# ~~~~~~~~~~~~~~~~~~~~~~~~
alias foam 'cd $WM_PROJECT_DIR'

if ( $?WM_PROJECT_SITE ) then
    alias foamSite 'cd $WM_PROJECT_SITE'
else
    alias foamSite 'cd $WM_PROJECT_INST_DIR/site'
endif

alias src 'cd $FOAM_SRC'
alias lib 'cd $FOAM_LIBBIN'
alias app 'cd $FOAM_APP'
alias sol 'cd $FOAM_SOLVERS'
alias util 'cd $FOAM_UTILITIES'
alias tut 'cd $FOAM_TUTORIALS'
alias run 'cd $FOAM_RUN'


# Change OpenFOAM version
# ~~~~~~~~~~~~~~~~~~~~~~~
alias foamVersion \
    'if ( "\!*" != "" ) source $FOAM_INST_DIR/OpenFOAM-\!*/etc/cshrc; foam; echo OpenFOAM-$WM_PROJECT_VERSION'


# Change ParaView version
# ~~~~~~~~~~~~~~~~~~~~~~~
alias foamPV \
    'source $WM_PROJECT_DIR/etc/config.csh/paraview ParaView_VERSION=\!*; echo paraview-$ParaView_VERSION'


#------------------------------------------------------------------------------
