from conans import ConanFile, CMake, tools


class MercatorConan(ConanFile):
    name = "mercator"
    version = "0.4.0"
    license = "GPL-2.0+"
    author = "Erik Ogenvik <erik@ogenvik.org>"
    homepage = "https://www.worldforge.org"
    url = "https://github.com/worldforge/mercator"
    description = "A terrain generation library for the Worldforge system."
    topics = ("mmorpg", "worldforge")
    settings = "os", "compiler", "build_type", "arch"
    options = {"shared": [False, True]}
    default_options = {"shared": False}
    generators = "cmake"
    requires = "wfmath/1.0.3@worldforge/testing"

    scm = {
        "type": "git",
        "url": "https://github.com/worldforge/mercator.git",
        "revision": "auto"
    }

    def build(self):
        cmake = CMake(self)
        cmake.configure(source_folder=".")
        cmake.build()
        cmake.install()

    def package_info(self):
        self.cpp_info.libs = tools.collect_libs(self)
        self.cpp_info.includedirs = ["include/mercator-0.4"]

    def package(self):
        pass
