/*
  Copyright (C) 2000-2012 Novell, Inc
  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) version 3.0 of the License. This library
  is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
  License for more details. You should have received a copy of the GNU
  Lesser General Public License along with this library; if not, write
  to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
  Floor, Boston, MA 02110-1301 USA
*/


/*-/

  File:		YEmpty.h

  Author:	Stefan Hundhammer <sh@suse.de>

/-*/

#ifndef YEmpty_h
#define YEmpty_h

#include "YWidget.h"
#include "ImplPtr.h"


class YEmptyPrivate;


class YEmpty : public YWidget
{
protected:
    /**
     * Constructor.
     **/
    YEmpty( YWidget * parent );

public:
    /**
     * Destructor.
     **/
    virtual ~YEmpty();

    /**
     * Returns a descriptive name of this widget class for logging,
     * debugging etc.
     **/
    virtual const char * widgetClass() const { return "YEmpty"; }

    /**
     * Preferred width of the widget.
     *
     * Reimplemented from YWidget.
     **/
    virtual int preferredWidth();

    /**
     * Preferred height of the widget.
     *
     * Reimplemented from YWidget.
     **/
    virtual int preferredHeight();

private:

    ImplPtr<YEmptyPrivate> priv;
};


#endif // YEmpty_h
