/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ClientNotifyInformation;
import org.apache.subversion.javahl.DiffSummary;
import org.apache.subversion.javahl.SVNTests;
import org.apache.subversion.javahl.callback.BlameCallback;
import org.apache.subversion.javahl.callback.ClientNotifyCallback;
import org.apache.subversion.javahl.callback.DiffSummaryCallback;
import org.apache.subversion.javahl.callback.InfoCallback;
import org.apache.subversion.javahl.callback.ListCallback;
import org.apache.subversion.javahl.callback.LogMessageCallback;
import org.apache.subversion.javahl.callback.StatusCallback;
import org.apache.subversion.javahl.types.ChangePath;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.DirEntry;
import org.apache.subversion.javahl.types.Info;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.RevisionRange;
import org.apache.subversion.javahl.types.Status;

public class ExceptionTests
extends SVNTests {
    public static final String testName = "exception_test";

    public ExceptionTests() {
        this.init();
    }

    public ExceptionTests(String string) {
        super(string);
        this.init();
    }

    private void init() {
        if (!testName.equals(this.testBaseName)) {
            testCounter = 0;
            this.testBaseName = testName;
        }
    }

    public void testStatusCallback() throws Exception {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        final TestException testException = new TestException("The Exception");
        boolean bl = false;
        try {
            this.client.status(oneTest.getWorkingCopy() + "/A", Depth.immediates, false, true, true, false, false, false, null, new StatusCallback(){

                @Override
                public void doStatus(String string, Status status) {
                    throw new TestException("inner", testException);
                }
            });
        }
        catch (ClientException clientException) {
            if (this.VerifyCause(clientException, testException)) {
                bl = true;
            }
            throw clientException;
        }
        ExceptionTests.assertTrue((boolean)bl);
    }

    public void testInfoCallback() throws Exception {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        final TestException testException = new TestException("The Exception");
        boolean bl = false;
        try {
            this.client.info(oneTest.getWorkingCopy() + "/A", null, null, Depth.immediates, true, true, false, null, new InfoCallback(){

                @Override
                public void singleInfo(Info info) {
                    throw new TestException("inner", testException);
                }
            });
        }
        catch (ClientException clientException) {
            if (this.VerifyCause(clientException, testException)) {
                bl = true;
            }
            throw clientException;
        }
        ExceptionTests.assertTrue((boolean)bl);
    }

    public void testListCallback() throws Exception {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        final TestException testException = new TestException("The Exception");
        boolean bl = false;
        try {
            this.client.list(oneTest.getWorkingCopy() + "/A", null, null, Depth.immediates, 7, false, new ListCallback(){

                @Override
                public void doEntry(DirEntry dirEntry, Lock lock) {
                    throw new TestException("inner", testException);
                }
            });
        }
        catch (ClientException clientException) {
            if (this.VerifyCause(clientException, testException)) {
                bl = true;
            }
            throw clientException;
        }
        ExceptionTests.assertTrue((boolean)bl);
    }

    public void testBlameCallback() throws Exception {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        final TestException testException = new TestException("The Exception");
        boolean bl = false;
        try {
            this.client.blame(oneTest.getWorkingCopy() + "/iota", Revision.getInstance(1L), Revision.getInstance(1L), Revision.getInstance(1L), false, false, new BlameCallback(){

                @Override
                public void singleLine(long l, long l2, Map<String, byte[]> map, long l3, Map<String, byte[]> map2, String string, String string2, boolean bl) {
                    throw new TestException("inner", testException);
                }
            });
        }
        catch (ClientException clientException) {
            if (this.VerifyCause(clientException, testException)) {
                bl = true;
            }
            throw clientException;
        }
        ExceptionTests.assertTrue((boolean)bl);
    }

    public void testLogMessageCallback() throws Exception {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        final TestException testException = new TestException("The Exception");
        boolean bl = false;
        try {
            ArrayList<RevisionRange> arrayList = new ArrayList<RevisionRange>(1);
            arrayList.add(new RevisionRange(null, null));
            this.client.logMessages(oneTest.getWorkingCopy() + "/iota", Revision.getInstance(1L), arrayList, false, false, false, null, 2L, new LogMessageCallback(){

                @Override
                public void singleMessage(Set<ChangePath> set, long l, Map<String, byte[]> map, boolean bl) {
                    throw new TestException("inner", testException);
                }
            });
        }
        catch (ClientException clientException) {
            if (this.VerifyCause(clientException, testException)) {
                bl = true;
            }
            throw clientException;
        }
        ExceptionTests.assertTrue((boolean)bl);
    }

    public void testDiffSummaryReceiver() throws Exception {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        final TestException testException = new TestException("The Exception");
        boolean bl = false;
        try {
            ArrayList<RevisionRange> arrayList = new ArrayList<RevisionRange>(1);
            arrayList.add(new RevisionRange(null, null));
            this.client.diffSummarize(oneTest.getUrl() + "/A", Revision.getInstance(1L), oneTest.getUrl() + "/A", Revision.getInstance(0L), Depth.infinity, null, true, new DiffSummaryCallback(){

                @Override
                public void onSummary(DiffSummary diffSummary) {
                    throw new TestException("inner", testException);
                }
            });
        }
        catch (ClientException clientException) {
            if (this.VerifyCause(clientException, testException)) {
                bl = true;
            }
            throw clientException;
        }
        ExceptionTests.assertTrue((boolean)bl);
    }

    public void testNotify() throws Exception {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        final TestException testException = new TestException("The Exception");
        boolean bl = false;
        try {
            this.client.notification2(new ClientNotifyCallback(){

                @Override
                public void onNotify(ClientNotifyInformation clientNotifyInformation) {
                    throw new TestException("inner", testException);
                }
            });
            this.client.remove(oneTest.getWCPathSet("/A"), false, false, null, null, null);
        }
        catch (ClientException clientException) {
            if (this.VerifyCause(clientException, testException)) {
                bl = true;
            }
            throw clientException;
        }
        ExceptionTests.assertTrue((boolean)bl);
    }

    private boolean VerifyCause(Throwable throwable, Throwable throwable2) {
        if (throwable == throwable2) {
            return true;
        }
        Throwable throwable3 = throwable.getCause();
        if (throwable3 == null) {
            return false;
        }
        return this.VerifyCause(throwable3, throwable2);
    }

    final class TestException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public TestException(String string) {
            super(string);
        }

        public TestException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

