/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ClientNotifyInformation;
import org.apache.subversion.javahl.CommitInfo;
import org.apache.subversion.javahl.CommitItem;
import org.apache.subversion.javahl.ConflictDescriptor;
import org.apache.subversion.javahl.ConflictResult;
import org.apache.subversion.javahl.DiffSummary;
import org.apache.subversion.javahl.JNIError;
import org.apache.subversion.javahl.ProgressEvent;
import org.apache.subversion.javahl.SVNClient;
import org.apache.subversion.javahl.SVNTests;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.WC;
import org.apache.subversion.javahl.callback.BlameCallback;
import org.apache.subversion.javahl.callback.ChangelistCallback;
import org.apache.subversion.javahl.callback.ClientNotifyCallback;
import org.apache.subversion.javahl.callback.CommitCallback;
import org.apache.subversion.javahl.callback.CommitMessageCallback;
import org.apache.subversion.javahl.callback.ConflictResolverCallback;
import org.apache.subversion.javahl.callback.DiffSummaryCallback;
import org.apache.subversion.javahl.callback.InfoCallback;
import org.apache.subversion.javahl.callback.InheritedProplistCallback;
import org.apache.subversion.javahl.callback.ListCallback;
import org.apache.subversion.javahl.callback.LogMessageCallback;
import org.apache.subversion.javahl.callback.PatchCallback;
import org.apache.subversion.javahl.callback.ProgressCallback;
import org.apache.subversion.javahl.callback.ProplistCallback;
import org.apache.subversion.javahl.callback.StatusCallback;
import org.apache.subversion.javahl.callback.TunnelAgent;
import org.apache.subversion.javahl.types.ChangePath;
import org.apache.subversion.javahl.types.CopySource;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.DiffOptions;
import org.apache.subversion.javahl.types.DirEntry;
import org.apache.subversion.javahl.types.ExternalItem;
import org.apache.subversion.javahl.types.Info;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.LogDate;
import org.apache.subversion.javahl.types.Mergeinfo;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.RevisionRange;
import org.apache.subversion.javahl.types.RevisionRangeList;
import org.apache.subversion.javahl.types.RuntimeVersion;
import org.apache.subversion.javahl.types.Status;
import org.apache.subversion.javahl.types.Version;
import org.apache.subversion.javahl.types.VersionExtended;

public class BasicTests
extends SVNTests {
    public static final String testName = "basic_test";

    public BasicTests() {
        this.init();
    }

    public BasicTests(String string) {
        super(string);
        this.init();
    }

    private void init() {
        if (!testName.equals(this.testBaseName)) {
            testCounter = 0;
            this.testBaseName = testName;
        }
    }

    public void testLogDate() throws Throwable {
        LogDate logDate;
        String string = "2007-10-04T03:00:52.134992Z";
        String string2 = "2008-01-14";
        try {
            logDate = new LogDate(string);
            BasicTests.assertEquals((long)1191466852134992L, (long)logDate.getTimeMicros());
        }
        catch (ParseException parseException) {
            BasicTests.fail((String)("Failed to parse date " + string));
        }
        try {
            logDate = new LogDate(string2);
            BasicTests.fail((String)("Failed to throw exception on bad date " + string2));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testVersion() throws Throwable {
        try {
            Version version = this.client.getVersion();
            String string = version.toString();
            if (string == null || string.trim().length() == 0) {
                throw new Exception("Version string empty");
            }
        }
        catch (Exception exception) {
            BasicTests.fail((String)("Version should always be available unless the native libraries failed to initialize: " + exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionExtendedQuiet() throws Throwable {
        VersionExtended versionExtended = null;
        try {
            versionExtended = this.client.getVersionExtended(false);
            String string = versionExtended.getBuildDate();
            if (string == null) {
                throw new Exception("Build date empty");
            }
            string = versionExtended.getBuildTime();
            if (string == null) {
                throw new Exception("Build time empty");
            }
            string = versionExtended.getBuildHost();
            if (string == null || string.trim().length() == 0) {
                throw new Exception("Build host empty");
            }
            string = versionExtended.getCopyright();
            if (string == null || string.trim().length() == 0) {
                throw new Exception("Copyright empty");
            }
        }
        catch (Exception exception) {
            BasicTests.fail((String)("VersionExtended should always be available unless the native libraries failed to initialize: " + exception));
        }
        finally {
            if (versionExtended != null) {
                versionExtended.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionExtendedVerbose() throws Throwable {
        VersionExtended versionExtended = null;
        try {
            Object object;
            versionExtended = this.client.getVersionExtended(true);
            String string = versionExtended.getRuntimeHost();
            if (string == null || string.trim().length() == 0) {
                throw new Exception("Runtime host empty");
            }
            string = versionExtended.getRuntimeOSName();
            if (string != null && string.trim().length() == 0) {
                throw new Exception("Runtime OS name empty");
            }
            Iterator<VersionExtended.LinkedLib> iterator = versionExtended.getLinkedLibs();
            if (iterator.hasNext()) {
                object = iterator.next();
                string = ((VersionExtended.LinkedLib)object).getName();
                if (string == null || string.trim().length() == 0) {
                    throw new Exception("Linked lib name empty");
                }
                string = ((VersionExtended.LinkedLib)object).getCompiledVersion();
                if (string == null || string.trim().length() == 0) {
                    throw new Exception("Linked lib compiled version empty");
                }
                string = ((VersionExtended.LinkedLib)object).getRuntimeVersion();
                if (string != null && string.trim().length() == 0) {
                    throw new Exception("Linked lib runtime version empty");
                }
            }
            if ((object = versionExtended.getLoadedLibs()).hasNext()) {
                VersionExtended.LoadedLib loadedLib = (VersionExtended.LoadedLib)object.next();
                string = loadedLib.getName();
                if (string == null || string.trim().length() == 0) {
                    throw new Exception("Loaded lib name empty");
                }
                string = loadedLib.getVersion();
                if (string != null && string.trim().length() == 0) {
                    throw new Exception("Loaded lib version empty");
                }
            }
        }
        catch (Exception exception) {
            BasicTests.fail((String)("VersionExtended should always be available unless the native libraries failed to initialize: " + exception));
        }
        finally {
            if (versionExtended != null) {
                versionExtended.dispose();
            }
        }
    }

    public void testRuntimeVersion() throws Throwable {
        Object object;
        RuntimeVersion runtimeVersion;
        try {
            runtimeVersion = this.client.getRuntimeVersion();
            object = runtimeVersion.toString();
            if (object == null || ((String)object).trim().length() == 0) {
                throw new Exception("Version string empty");
            }
        }
        catch (Exception exception) {
            BasicTests.fail((String)("RuntimeVersion should always be available unless the native libraries failed to initialize: " + exception));
        }
        runtimeVersion = this.client.getRuntimeVersion();
        object = this.client.getVersion();
        BasicTests.assertTrue((runtimeVersion.getMajor() > ((Version)object).getMajor() || runtimeVersion.getMajor() == ((Version)object).getMajor() && runtimeVersion.getMinor() >= ((Version)object).getMinor() ? 1 : 0) != 0);
    }

    public void testJNIError() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        SVNClient sVNClient = new SVNClient();
        sVNClient.dispose();
        this.addExpectedCommitItem(null, oneTest.getUrl().toString(), "Y", NodeKind.dir, 1);
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(oneTest.getUrl() + "/Y");
        try {
            sVNClient.mkdir(hashSet, false, null, new ConstMsg("log_msg"), null);
        }
        catch (JNIError jNIError) {
            return;
        }
        BasicTests.fail((String)"A JNIError should have been thrown here.");
    }

    public void testMergeinfoParser() throws Throwable {
        String string = "/trunk:1-300,305*,307,400-405*\n/branches/branch:308-400";
        Mergeinfo mergeinfo = new Mergeinfo(string);
        Set<String> set = mergeinfo.getPaths();
        BasicTests.assertEquals((int)2, (int)set.size());
        List<RevisionRange> list = mergeinfo.getRevisionRange("/trunk");
        BasicTests.assertEquals((int)4, (int)list.size());
        BasicTests.assertEquals((String)"1-300", (String)list.get(0).toString());
        BasicTests.assertEquals((String)"305*", (String)list.get(1).toString());
        BasicTests.assertEquals((String)"307", (String)list.get(2).toString());
        BasicTests.assertEquals((String)"400-405*", (String)list.get(3).toString());
        List<RevisionRange> list2 = mergeinfo.getRevisionRange("/branches/branch");
        BasicTests.assertEquals((int)1, (int)list2.size());
    }

    public void testBasicStatus() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        oneTest.getWc().setItemDepth("", Depth.infinity);
        oneTest.getWc().setItemDepth("iota", Depth.unknown);
        oneTest.checkStatus();
        File file = new File(oneTest.getWorkingCopy() + "/A", "foo.c");
        MyStatusCallback myStatusCallback = new MyStatusCallback();
        this.client.status(this.fileToSVNPath(file, false), Depth.unknown, false, true, true, false, false, false, null, myStatusCallback);
        int n = myStatusCallback.getStatusArray().length;
        if (n == 1) {
            Status status = myStatusCallback.getStatusArray()[0];
            if (status.isConflicted() || status.getNodeStatus() != Status.Kind.none || status.getRepositoryNodeStatus() != Status.Kind.none) {
                BasicTests.fail((String)"File foo.c should return empty status.");
            }
        } else if (n > 1) {
            BasicTests.fail((String)"File foo.c should not return more than one status.");
        } else {
            BasicTests.fail((String)"File foo.c should return exactly one empty status.");
        }
    }

    public void testOODStatus() throws SubversionException, IOException {
        long l;
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        long l2 = 2L;
        File file = new File(oneTest.getWorkingCopy(), "A/D/G/rho");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("modification to rho");
        printWriter.close();
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/D/G/rho", NodeKind.file, 4);
        long l3 = this.commit(oneTest, "log msg");
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().setItemWorkingCopyRevision("A/D/G/rho", l3);
        oneTest.getWc().setItemContent("A/D/G/rho", oneTest.getWc().getItemContent("A/D/G/rho") + "modification to rho");
        MyStatusCallback myStatusCallback = new MyStatusCallback();
        this.client.status(oneTest.getWCPath() + "/A/D/G/rho", Depth.immediates, false, true, true, false, false, false, null, myStatusCallback);
        Status status = myStatusCallback.getStatusArray()[0];
        long l4 = status.getLastChangedDate().getTime();
        long l5 = l3;
        String string = status.getLastCommitAuthor();
        this.client.remove(oneTest.getWCPathSet("/A/D/G/pi"), false, false, null, null, null);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/D/G/pi", NodeKind.file, 2);
        l3 = this.commit(oneTest, "log msg");
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().removeItem("A/D/G/pi");
        oneTest.getWc().setItemWorkingCopyRevision("A/D/G", l3);
        BasicTests.assertEquals((String)"wrong revision from update", (long)this.update(oneTest, "/A/D/G"), (long)l3);
        long l6 = l3;
        file = new File(oneTest.getWorkingCopy(), "A/D/G/tau");
        printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("modification to tau");
        printWriter.close();
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/D/G/tau", NodeKind.file, 4);
        l3 = this.commit(oneTest, "log msg");
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().setItemWorkingCopyRevision("A/D/G/tau", l3);
        oneTest.getWc().setItemContent("A/D/G/tau", oneTest.getWc().getItemContent("A/D/G/tau") + "modification to tau");
        myStatusCallback = new MyStatusCallback();
        this.client.status(oneTest.getWCPath() + "/A/D/G/tau", Depth.immediates, false, true, true, false, false, false, null, myStatusCallback);
        status = myStatusCallback.getStatusArray()[0];
        long l7 = status.getLastChangedDate().getTime();
        long l8 = l3;
        String string2 = status.getLastCommitAuthor();
        this.client.remove(oneTest.getWCPathSet("/A/C"), false, false, null, null, null);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/C", NodeKind.dir, 2);
        l3 = this.commit(oneTest, "log msg");
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().removeItem("A/C");
        long l9 = l3;
        File file2 = new File(oneTest.getWorkingCopy(), "A/B/I");
        file2.mkdir();
        this.client.add(file2.getAbsolutePath(), Depth.infinity, false, false, false);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/B/I", NodeKind.dir, 1);
        l3 = this.commit(oneTest, "log msg");
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().addItem("A/B/I", null);
        myStatusCallback = new MyStatusCallback();
        this.client.status(oneTest.getWCPath() + "/A/B/I", Depth.immediates, false, true, true, false, false, false, null, myStatusCallback);
        status = myStatusCallback.getStatusArray()[0];
        long l10 = status.getLastChangedDate().getTime();
        long l11 = l3;
        String string3 = status.getLastCommitAuthor();
        oneTest.getWc().setRevision(l3);
        BasicTests.assertEquals((String)"wrong revision from update", (long)this.update(oneTest), (long)l3);
        oneTest.checkStatus();
        this.setprop(oneTest.getWCPath(), "propname", "propval");
        oneTest.getWc().setItemPropStatus("", Status.Kind.modified);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), null, NodeKind.dir, 8);
        l3 = this.commit(oneTest, "log msg");
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().setItemWorkingCopyRevision("", l3);
        oneTest.getWc().setItemPropStatus("", Status.Kind.normal);
        file = new File(oneTest.getWorkingCopy(), "A/D/H/nu");
        printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.print("This is the file 'nu'.");
        printWriter.close();
        this.client.add(file.getAbsolutePath(), Depth.empty, false, false, false);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/D/H/nu", NodeKind.file, 5);
        l3 = this.commit(oneTest, "log msg");
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().addItem("A/D/H/nu", "This is the file 'nu'.");
        myStatusCallback = new MyStatusCallback();
        this.client.status(oneTest.getWCPath() + "/A/D/H/nu", Depth.immediates, false, true, true, false, false, false, null, myStatusCallback);
        status = myStatusCallback.getStatusArray()[0];
        long l12 = status.getLastChangedDate().getTime();
        long l13 = l3;
        String string4 = status.getLastCommitAuthor();
        this.setprop(oneTest.getWCPath() + "/A/B/F", "propname", "propval");
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/B/F", NodeKind.dir, 8);
        l3 = this.commit(oneTest, "log msg");
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().setItemPropStatus("A/B/F", Status.Kind.normal);
        oneTest.getWc().setItemWorkingCopyRevision("A/B/F", l3);
        myStatusCallback = new MyStatusCallback();
        this.client.status(oneTest.getWCPath() + "/A/B/F", Depth.immediates, false, true, true, false, false, false, null, myStatusCallback);
        status = myStatusCallback.getStatusArray()[0];
        long l14 = status.getLastChangedDate().getTime();
        long l15 = l3;
        String string5 = status.getLastCommitAuthor();
        this.client.remove(oneTest.getWCPathSet("/A/D/H/chi"), false, false, null, null, null);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/D/H/chi", NodeKind.file, 2);
        l3 = this.commit(oneTest, "log msg");
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().removeItem("A/D/G/pi");
        file = new File(oneTest.getWorkingCopy(), "A/D/H/chi");
        printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.print("This is the replacement file 'chi'.");
        printWriter.close();
        this.client.add(file.getAbsolutePath(), Depth.empty, false, false, false);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/D/H/chi", NodeKind.file, 5);
        l3 = this.commit(oneTest, "log msg");
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().addItem("A/D/H/chi", "This is the replacement file 'chi'.");
        myStatusCallback = new MyStatusCallback();
        this.client.status(oneTest.getWCPath() + "/A/D/H/chi", Depth.immediates, false, true, true, false, false, false, null, myStatusCallback);
        status = myStatusCallback.getStatusArray()[0];
        long l16 = status.getLastChangedDate().getTime();
        long l17 = l3;
        String string6 = status.getLastCommitAuthor();
        this.client.remove(oneTest.getWCPathSet("/A/B/E"), false, false, null, null, null);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/B/E", NodeKind.dir, 2);
        l3 = this.commit(oneTest, "log msg");
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().removeItem("A/B/E/alpha");
        oneTest.getWc().removeItem("A/B/E/beta");
        oneTest.getWc().removeItem("A/B/E");
        oneTest.getWc().setItemWorkingCopyRevision("A/B", l3);
        BasicTests.assertEquals((String)"wrong revision from update", (long)this.update(oneTest, "/A/B"), (long)l3);
        Info info = this.collectInfos(oneTest.getWCPath() + "/A/B", null, null, Depth.empty, null)[0];
        long l18 = info.getLastChangedDate().getTime();
        long l19 = l = l3;
        String string7 = info.getLastChangedAuthor();
        this.client.remove(oneTest.getWCPathSet("/A/D/H/psi"), false, false, null, null, null);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/D/H/psi", NodeKind.file, 2);
        l3 = this.commit(oneTest, "log msg");
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().removeItem("A/D/H/psi");
        oneTest.getWc().setRevision(l3);
        BasicTests.assertEquals((String)"wrong revision from update", (long)this.update(oneTest), (long)l3);
        oneTest.getWc().addItem("A/D/H/psi", null);
        file2 = new File(oneTest.getWorkingCopy(), "A/D/H/psi");
        file2.mkdir();
        this.client.add(file2.getAbsolutePath(), Depth.infinity, false, false, false);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/D/H/psi", NodeKind.dir, 1);
        l3 = this.commit(oneTest, "log msg");
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        myStatusCallback = new MyStatusCallback();
        this.client.status(oneTest.getWCPath() + "/A/D/H/psi", Depth.immediates, false, true, true, false, false, false, null, myStatusCallback);
        status = myStatusCallback.getStatusArray()[0];
        long l20 = status.getLastChangedDate().getTime();
        long l21 = l3;
        String string8 = status.getLastCommitAuthor();
        oneTest.checkStatus();
        BasicTests.assertEquals((String)"wrong revision from update", (long)this.client.update(oneTest.getWCPathSet(), Revision.getInstance(1L), Depth.unknown, false, false, false, false)[0], (long)1L);
        oneTest.getWc().setRevision(1L);
        oneTest.getWc().setItemOODInfo("A", l21, string8, l20, NodeKind.dir);
        oneTest.getWc().setItemOODInfo("A/B", l, string7, l18, NodeKind.dir);
        oneTest.getWc().addItem("A/B/I", null);
        oneTest.getWc().setItemOODInfo("A/B/I", l11, string3, l10, NodeKind.dir);
        oneTest.getWc().setItemTextStatus("A/B/I", Status.Kind.none);
        oneTest.getWc().setItemNodeKind("A/B/I", NodeKind.unknown);
        oneTest.getWc().addItem("A/C", null);
        oneTest.getWc().setItemReposLastCmtRevision("A/C", l9);
        oneTest.getWc().setItemReposKind("A/C", NodeKind.dir);
        oneTest.getWc().addItem("A/B/E", null);
        oneTest.getWc().setItemReposLastCmtRevision("A/B/E", l19);
        oneTest.getWc().setItemReposKind("A/B/E", NodeKind.dir);
        oneTest.getWc().addItem("A/B/E/alpha", "This is the file 'alpha'.");
        oneTest.getWc().addItem("A/B/E/beta", "This is the file 'beta'.");
        oneTest.getWc().setItemPropStatus("A/B/F", Status.Kind.none);
        oneTest.getWc().setItemOODInfo("A/B/F", l15, string5, l14, NodeKind.dir);
        oneTest.getWc().setItemOODInfo("A/D", l21, string8, l20, NodeKind.dir);
        oneTest.getWc().setItemOODInfo("A/D/G", l8, string2, l7, NodeKind.dir);
        oneTest.getWc().addItem("A/D/G/pi", "This is the file 'pi'.");
        oneTest.getWc().setItemReposLastCmtRevision("A/D/G/pi", l6);
        oneTest.getWc().setItemReposKind("A/D/G/pi", NodeKind.file);
        oneTest.getWc().setItemContent("A/D/G/rho", "This is the file 'rho'.");
        oneTest.getWc().setItemOODInfo("A/D/G/rho", l5, string, l4, NodeKind.file);
        oneTest.getWc().setItemContent("A/D/G/tau", "This is the file 'tau'.");
        oneTest.getWc().setItemOODInfo("A/D/G/tau", l8, string2, l7, NodeKind.file);
        oneTest.getWc().setItemOODInfo("A/D/H", l21, string8, l20, NodeKind.dir);
        oneTest.getWc().setItemWorkingCopyRevision("A/D/H/nu", -1L);
        oneTest.getWc().setItemTextStatus("A/D/H/nu", Status.Kind.none);
        oneTest.getWc().setItemNodeKind("A/D/H/nu", NodeKind.unknown);
        oneTest.getWc().setItemOODInfo("A/D/H/nu", l13, string4, l12, NodeKind.file);
        oneTest.getWc().setItemContent("A/D/H/chi", "This is the file 'chi'.");
        oneTest.getWc().setItemOODInfo("A/D/H/chi", l17, string6, l16, NodeKind.file);
        oneTest.getWc().removeItem("A/D/H/psi");
        oneTest.getWc().addItem("A/D/H/psi", "This is the file 'psi'.");
        oneTest.getWc().setItemOODInfo("A/D/H/psi", l21, string8, l20, NodeKind.dir);
        oneTest.getWc().setItemPropStatus("", Status.Kind.none);
        oneTest.getWc().setItemOODInfo("", l21, string8, l20, NodeKind.dir);
        oneTest.checkStatus(true);
    }

    public void testExternalStatus() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        this.client.propertySetLocal(oneTest.getWCPathSet(), "svn:externals", "^/A/D/H ADHext".getBytes(), Depth.empty, null, false);
        this.client.update(oneTest.getWCPathSet(), Revision.HEAD, Depth.unknown, false, false, false, false);
        File file = new File(oneTest.getWorkingCopy() + "/ADHext", "psi");
        MyStatusCallback myStatusCallback = new MyStatusCallback();
        this.client.status(this.fileToSVNPath(file, false), Depth.unknown, false, true, true, false, false, false, null, myStatusCallback);
        int n = myStatusCallback.getStatusArray().length;
        if (n == 1) {
            Status status = myStatusCallback.getStatusArray()[0];
            BasicTests.assertFalse((boolean)status.isConflicted());
            BasicTests.assertEquals((Object)((Object)Status.Kind.normal), (Object)((Object)status.getNodeStatus()));
            BasicTests.assertEquals((Object)((Object)NodeKind.file), (Object)((Object)status.getNodeKind()));
        } else if (n > 1) {
            BasicTests.fail((String)"File psi should not return more than one status.");
        } else {
            BasicTests.fail((String)"File psi should return exactly one status.");
        }
    }

    public void testBasicCheckout() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        try {
            this.client.checkout(oneTest.getUrl() + "/A", oneTest.getWCPath(), null, null, Depth.infinity, false, false);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        File file = new File(oneTest.getWorkingCopy(), "A/mu");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("appended mu text");
        printWriter.close();
        oneTest.getWc().setItemTextStatus("A/mu", Status.Kind.modified);
        File file2 = new File(oneTest.getWorkingCopy(), "A/B/lambda");
        file2.delete();
        oneTest.getWc().setItemTextStatus("A/B/lambda", Status.Kind.missing);
        this.client.remove(oneTest.getWCPathSet("/A/D/G"), false, false, null, null, null);
        oneTest.getWc().setItemTextStatus("A/D/G", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/D/G/pi", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/D/G/rho", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/D/G/tau", Status.Kind.deleted);
        oneTest.checkStatus();
        this.client.checkout(oneTest.getUrl().toString(), oneTest.getWCPath(), null, null, Depth.infinity, false, false);
        oneTest.getWc().setItemTextStatus("A/B/lambda", Status.Kind.normal);
        oneTest.checkStatus();
    }

    public void testBasicCommit() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWorkingCopy(), "A/mu");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("appended mu text");
        printWriter.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/mu", 2L);
        oneTest.getWc().setItemContent("A/mu", oneTest.getWc().getItemContent("A/mu") + "appended mu text");
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/mu", NodeKind.file, 4);
        File file2 = new File(oneTest.getWorkingCopy(), "A/D/G/rho");
        PrintWriter printWriter2 = new PrintWriter(new FileOutputStream(file2, true));
        printWriter2.print("new appended text for rho");
        printWriter2.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/D/G/rho", 2L);
        oneTest.getWc().setItemContent("A/D/G/rho", oneTest.getWc().getItemContent("A/D/G/rho") + "new appended text for rho");
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/D/G/rho", NodeKind.file, 4);
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 2L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        oneTest.checkStatus();
    }

    public void testBasicProperties() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        WC wC = oneTest.getWc();
        String string = this.fileToSVNPath(new File(oneTest.getWCPath(), "iota"), false);
        byte[] byArray = new byte[]{-12, -125, -51, 43, 5, 47, 116, -72, -120, 2, -98, -100, -73, 61, 118, 74, 36, 38, 56, 107, 45, 91, 38, 107, -87, 119, -107, -114, -45, -128, -69, 96};
        this.setprop(string, "abc", byArray);
        Map<String, byte[]> map = this.collectProperties(string, null, null, Depth.empty, null);
        BasicTests.assertTrue((boolean)Arrays.equals(byArray, map.get("abc")));
        wC.setItemPropStatus("iota", Status.Kind.modified);
        oneTest.checkStatus();
        string = this.fileToSVNPath(new File(oneTest.getWCPath(), "/A/B/E/alpha"), false);
        String string2 = "qrz";
        this.setprop(string, "cqcq", string2.getBytes());
        final HashMap hashMap = new HashMap();
        this.client.properties(string, null, null, Depth.empty, null, new ProplistCallback(){

            @Override
            public void singlePath(String string, Map<String, byte[]> map) {
                hashMap.put(string, map);
            }
        });
        Map map2 = (Map)hashMap.get(string);
        for (String string3 : map2.keySet()) {
            BasicTests.assertEquals((String)"cqcq", (String)string3);
            BasicTests.assertEquals((String)string2, (String)new String((byte[])map2.get(string3)));
        }
        wC.setItemPropStatus("A/B/E/alpha", Status.Kind.modified);
        oneTest.checkStatus();
    }

    public void testInheritedProperties() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        WC wC = oneTest.getWc();
        String string = this.fileToSVNPath(new File(oneTest.getWCPath(), "/A"), false);
        String string2 = this.fileToSVNPath(new File(oneTest.getWCPath(), "/A/B/E/alpha"), false);
        String string3 = "ybg";
        this.setprop(string, "ahqrtz", string3.getBytes());
        final HashMap hashMap = new HashMap();
        this.client.properties(string2, null, null, Depth.empty, null, new InheritedProplistCallback(){

            @Override
            public void singlePath(String string, Map<String, byte[]> map, Collection<InheritedProplistCallback.InheritedItem> collection) {
                hashMap.put(string, collection);
            }
        });
        Collection collection = (Collection)hashMap.get(string2);
        for (InheritedProplistCallback.InheritedItem inheritedItem : collection) {
            for (String string4 : inheritedItem.properties.keySet()) {
                BasicTests.assertEquals((String)"ahqrtz", (String)string4);
                BasicTests.assertEquals((String)string3, (String)new String(inheritedItem.properties.get(string4)));
            }
        }
        wC.setItemPropStatus("A", Status.Kind.modified);
        oneTest.checkStatus();
    }

    public void testBasicUpdate() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        SVNTests.OneTest oneTest2 = oneTest.copy(".backup");
        File file = new File(oneTest.getWorkingCopy(), "A/mu");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("appended mu text");
        printWriter.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/mu", 2L);
        oneTest.getWc().setItemContent("A/mu", oneTest.getWc().getItemContent("A/mu") + "appended mu text");
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/mu", NodeKind.file, 4);
        File file2 = new File(oneTest.getWorkingCopy(), "A/D/G/rho");
        PrintWriter printWriter2 = new PrintWriter(new FileOutputStream(file2, true));
        printWriter2.print("new appended text for rho");
        printWriter2.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/D/G/rho", 2L);
        oneTest.getWc().setItemContent("A/D/G/rho", oneTest.getWc().getItemContent("A/D/G/rho") + "new appended text for rho");
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/D/G/rho", NodeKind.file, 4);
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 2L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        oneTest.checkStatus();
        BasicTests.assertEquals((String)"wrong revision number from update", (long)this.update(oneTest2), (long)2L);
        oneTest2.getWc().setItemWorkingCopyRevision("A/mu", 2L);
        oneTest2.getWc().setItemContent("A/mu", oneTest2.getWc().getItemContent("A/mu") + "appended mu text");
        oneTest2.getWc().setItemWorkingCopyRevision("A/D/G/rho", 2L);
        oneTest2.getWc().setItemContent("A/D/G/rho", oneTest2.getWc().getItemContent("A/D/G/rho") + "new appended text for rho");
        oneTest2.checkStatus();
    }

    public void testBasicMkdirUrl() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        this.addExpectedCommitItem(null, oneTest.getUrl().toString(), "Y", NodeKind.dir, 1);
        this.addExpectedCommitItem(null, oneTest.getUrl().toString(), "Y/Z", NodeKind.dir, 1);
        HashSet<String> hashSet = new HashSet<String>(2);
        hashSet.add(oneTest.getUrl() + "/Y");
        hashSet.add(oneTest.getUrl() + "/Y/Z");
        this.client.mkdir(hashSet, false, null, new ConstMsg("log_msg"), null);
        oneTest.getWc().addItem("Y", null);
        oneTest.getWc().setItemWorkingCopyRevision("Y", 2L);
        oneTest.getWc().addItem("Y/Z", null);
        oneTest.getWc().setItemWorkingCopyRevision("Y/Z", 2L);
        BasicTests.assertEquals((String)"wrong revision from update", (long)this.update(oneTest), (long)2L);
        oneTest.checkStatus();
    }

    public void testCopy() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        WC wC = oneTest.getWc();
        Revision revision = Revision.getInstance(1L);
        Revision revision2 = null;
        String[] stringArray = new String[]{"alpha", "beta"};
        ArrayList<CopySource> arrayList = new ArrayList<CopySource>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(new CopySource(new File(oneTest.getWorkingCopy(), "A/B/E/" + string).getPath(), revision, revision2));
            wC.addItem("A/B/F/" + string, wC.getItemContent("A/B/E/" + string));
            wC.setItemWorkingCopyRevision("A/B/F/" + string, 2L);
            this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/B/F/" + string, NodeKind.file, 17);
        }
        this.client.copy(arrayList, new File(oneTest.getWorkingCopy(), "A/B/F").getPath(), true, false, false, false, false, null, null, null, null);
        this.checkCommitRevision(oneTest, "Unexpected WC revision number after commit", 2L, oneTest.getWCPathSet(), "Copy files", Depth.infinity, false, false, null, null);
        oneTest.checkStatus();
        this.assertExpectedSuggestion(oneTest.getUrl() + "/A/B/E/alpha", "A/B/F/alpha", oneTest);
        ArrayList arrayList2 = new ArrayList(1);
        arrayList2.add(new CopySource(new File(oneTest.getWorkingCopy(), "A/B").getPath(), Revision.WORKING, Revision.WORKING));
        this.client.copy(arrayList2, oneTest.getUrl() + "/parent/A/B", true, true, false, false, false, null, null, new ConstMsg("Copy WC to URL"), null);
        BasicTests.assertEquals((String)"wrong revision number from update", (long)this.update(oneTest), (long)3L);
    }

    private void setupPinExternalsTest(SVNTests.OneTest oneTest) throws Throwable {
        byte[] byArray = "^/A/D/H ADHext\n^/A/D/H ADHext2\n^/A/D/H@1 peggedADHext\n-r1 ^/A/D/H revvedADHext\n".getBytes();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(oneTest.getWCPath() + "/A/B");
        this.client.propertySetLocal(hashSet, "svn:externals", byArray, Depth.empty, null, false);
        this.client.commit(oneTest.getWCPathSet(), Depth.infinity, false, false, null, null, new ConstMsg("Set svn:externals"), null);
        this.client.update(oneTest.getWCPathSet(), Revision.HEAD, Depth.unknown, false, false, false, false);
    }

    public void testCopyPinExternals_wc2wc() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        this.setupPinExternalsTest(oneTest);
        ArrayList<CopySource> arrayList = new ArrayList<CopySource>(1);
        arrayList.add(new CopySource(oneTest.getWCPath() + "/A/B", null, null));
        String string = oneTest.getWCPath() + "/A/Bcopy";
        this.client.copy(arrayList, string, true, false, false, false, true, null, null, null, null);
        String string2 = "^/A/D/H@2 ADHext\n^/A/D/H@2 ADHext2\n^/A/D/H@1 peggedADHext\n-r1 ^/A/D/H@2 revvedADHext\n";
        String string3 = new String(this.client.propertyGet(string, "svn:externals", null, null));
        BasicTests.assertEquals((String)string2, (String)string3);
    }

    public void testCopyPinExternals_wc2repo() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        this.setupPinExternalsTest(oneTest);
        ArrayList<CopySource> arrayList = new ArrayList<CopySource>(1);
        arrayList.add(new CopySource(oneTest.getWCPath() + "/A/B", null, null));
        String string = oneTest.getUrl() + "/A/Bcopy";
        this.client.copy(arrayList, string, true, false, false, false, true, null, null, new ConstMsg("Copy WC to REPO"), null);
        String string2 = "^/A/D/H@2 ADHext\n^/A/D/H@2 ADHext2\n^/A/D/H@1 peggedADHext\n-r1 ^/A/D/H@2 revvedADHext\n";
        String string3 = new String(this.client.propertyGet(string, "svn:externals", null, null));
        BasicTests.assertEquals((String)string2, (String)string3);
    }

    public void testCopyPinExternals_repo2wc() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        this.setupPinExternalsTest(oneTest);
        ArrayList<CopySource> arrayList = new ArrayList<CopySource>(1);
        arrayList.add(new CopySource(oneTest.getUrl() + "/A/B", null, null));
        String string = oneTest.getWCPath() + "/A/Bcopy";
        this.client.copy(arrayList, string, true, false, false, false, true, null, null, null, null);
        String string2 = "^/A/D/H@2 ADHext\n^/A/D/H@2 ADHext2\n^/A/D/H@1 peggedADHext\n-r1 ^/A/D/H@2 revvedADHext\n";
        String string3 = new String(this.client.propertyGet(string, "svn:externals", null, null));
        BasicTests.assertEquals((String)string2, (String)string3);
    }

    public void testCopyPinExternals_repo2repo() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        this.setupPinExternalsTest(oneTest);
        ArrayList<CopySource> arrayList = new ArrayList<CopySource>(1);
        arrayList.add(new CopySource(oneTest.getUrl() + "/A/B", null, null));
        String string = oneTest.getUrl() + "/A/Bcopy";
        this.client.copy(arrayList, string, true, false, false, false, true, null, null, new ConstMsg("Copy WC to REPO"), null);
        String string2 = "^/A/D/H@2 ADHext\n^/A/D/H@2 ADHext2\n^/A/D/H@1 peggedADHext\n-r1 ^/A/D/H@2 revvedADHext\n";
        String string3 = new String(this.client.propertyGet(string, "svn:externals", null, null));
        BasicTests.assertEquals((String)string2, (String)string3);
    }

    public void testCopyPinExternals_repo2repo_explicit() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        this.setupPinExternalsTest(oneTest);
        String string = oneTest.getUrl() + "/A/B";
        HashMap<String, List<ExternalItem>> hashMap = new HashMap<String, List<ExternalItem>>();
        ArrayList<ExternalItem> arrayList = new ArrayList<ExternalItem>(1);
        arrayList.add(new ExternalItem("ADHext", "^/A/D/H", null, null));
        hashMap.put(string, arrayList);
        ArrayList<CopySource> arrayList2 = new ArrayList<CopySource>(1);
        arrayList2.add(new CopySource(string, null, null));
        String string2 = oneTest.getUrl() + "/A/Bcopy";
        this.client.copy(arrayList2, string2, true, false, false, false, true, hashMap, null, new ConstMsg("Copy WC to REPO"), null);
        String string3 = "^/A/D/H@2 ADHext\n^/A/D/H ADHext2\n^/A/D/H@1 peggedADHext\n-r1 ^/A/D/H revvedADHext\n";
        String string4 = new String(this.client.propertyGet(string2, "svn:externals", null, null));
        BasicTests.assertEquals((String)string3, (String)string4);
    }

    public void testCopyPinExternals_repo2repo_corkscrew() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        this.setupPinExternalsTest(oneTest);
        String string = oneTest.getUrl() + "/A/B";
        HashMap<String, List<ExternalItem>> hashMap = new HashMap<String, List<ExternalItem>>();
        ArrayList<ExternalItem> arrayList = new ArrayList<ExternalItem>(1);
        arrayList.add(new ExternalItem("ADHext", "^/A/D/H", null, null));
        hashMap.put(string + "/A", arrayList);
        ArrayList<CopySource> arrayList2 = new ArrayList<CopySource>(1);
        arrayList2.add(new CopySource(string, null, null));
        String string2 = oneTest.getUrl() + "/A/Bcopy";
        this.client.copy(arrayList2, string2, true, false, false, false, true, hashMap, null, new ConstMsg("Copy WC to REPO"), null);
        String string3 = "^/A/D/H ADHext\n^/A/D/H ADHext2\n^/A/D/H@1 peggedADHext\n-r1 ^/A/D/H revvedADHext\n";
        String string4 = new String(this.client.propertyGet(string2, "svn:externals", null, null));
        BasicTests.assertEquals((String)string3, (String)string4);
    }

    public void testMove() throws SubversionException, IOException {
        String string2;
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        WC wC = oneTest.getWc();
        HashSet<String> hashSet = new HashSet<String>(2);
        hashSet.add("alpha");
        hashSet.add("beta");
        HashSet<String> hashSet2 = new HashSet<String>(2);
        for (String string2 : hashSet) {
            hashSet2.add(new File(oneTest.getWorkingCopy(), "A/B/E/" + string2).getPath());
            wC.addItem("A/B/F/" + string2, wC.getItemContent("A/B/E/" + string2));
            wC.setItemWorkingCopyRevision("A/B/F/" + string2, 2L);
            this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/B/F/" + string2, NodeKind.file, 17);
            wC.removeItem("A/B/E/" + string2);
            this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/B/E/" + string2, NodeKind.file, 2);
        }
        this.client.move(hashSet2, new File(oneTest.getWorkingCopy(), "A/B/F").getPath(), false, true, false, false, false, null, null, null);
        MyStatusCallback myStatusCallback = new MyStatusCallback();
        string2 = this.fileToSVNPath(new File(oneTest.getWCPath() + "/A/B"), true);
        this.client.status(string2, Depth.infinity, false, true, false, false, true, false, null, myStatusCallback);
        Status[] statusArray = myStatusCallback.getStatusArray();
        BasicTests.assertEquals((String)(string2 + "/F/alpha"), (String)statusArray[0].getMovedToAbspath());
        BasicTests.assertEquals((String)(string2 + "/F/beta"), (String)statusArray[1].getMovedToAbspath());
        BasicTests.assertEquals((String)(string2 + "/E/alpha"), (String)statusArray[2].getMovedFromAbspath());
        BasicTests.assertEquals((String)(string2 + "/E/beta"), (String)statusArray[3].getMovedFromAbspath());
        this.checkCommitRevision(oneTest, "Unexpected WC revision number after commit", 2L, oneTest.getWCPathSet(), "Move files", Depth.infinity, false, false, null, null);
        oneTest.checkStatus();
        this.assertExpectedSuggestion(oneTest.getUrl() + "/A/B/E/alpha", "A/B/F/alpha", oneTest);
    }

    public void testCommitPartialMove() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        String string = oneTest.getWorkingCopy().getAbsolutePath();
        ClientException clientException = null;
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string + "/A/B/E/alpha");
        this.client.move(hashSet, string + "/moved-alpha", false, false, false, false, false, null, null, null);
        try {
            this.client.commit(hashSet, Depth.infinity, false, false, null, null, new ConstMsg("Commit half of a move"), null);
        }
        catch (ClientException clientException2) {
            clientException = clientException2;
        }
        BasicTests.assertNotNull((String)"Commit of partial move did not fail", (Object)clientException);
        List<ClientException.ErrorMessage> list = clientException.getAllMessages();
        BasicTests.assertTrue((list.size() >= 3 ? 1 : 0) != 0);
        BasicTests.assertTrue((boolean)list.get(0).getMessage().startsWith("Illegal target"));
        BasicTests.assertTrue((boolean)list.get(1).getMessage().startsWith("Commit failed"));
        BasicTests.assertTrue((boolean)list.get(2).getMessage().startsWith("Cannot commit"));
    }

    private void assertExpectedSuggestion(String string, String string2, SVNTests.OneTest oneTest) throws SubversionException {
        String string3 = this.fileToSVNPath(new File(oneTest.getWCPath(), string2), false);
        Set<String> set = this.client.suggestMergeSources(string3, Revision.WORKING);
        BasicTests.assertNotNull(set);
        BasicTests.assertTrue((set.size() >= 1 ? 1 : 0) != 0);
        BasicTests.assertTrue((String)("Copy source path not found in suggestions: " + string), (boolean)set.contains(string));
        String string4 = oneTest.getUrl() + "/" + string2;
        set = this.client.suggestMergeSources(string4, Revision.HEAD);
        BasicTests.assertNotNull(set);
        BasicTests.assertTrue((set.size() >= 1 ? 1 : 0) != 0);
        BasicTests.assertTrue((String)("Copy source path not found in suggestions: " + string), (boolean)set.contains(string));
    }

    private void assertExpectedMergeRange(long l, long l2, long[] lArray) {
        Arrays.sort(lArray);
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] > l) continue;
            for (int j = i; j < lArray.length; ++j) {
                if (l2 > lArray[j]) continue;
                return;
            }
            BasicTests.fail((String)("End revision: " + l2 + " was not in range: " + lArray[0] + " : " + lArray[lArray.length - 1]));
            return;
        }
        BasicTests.fail((String)("Start revision: " + l + " was not in range: " + lArray[0] + " : " + lArray[lArray.length - 1]));
    }

    public void testBasicMergingUpdate() throws Throwable {
        int n;
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWorkingCopy(), "A/mu");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        String string = oneTest.getWc().getItemContent("A/mu");
        for (int i = 2; i < 11; ++i) {
            printWriter.print("\nThis is line " + i + " in mu");
            string = string + "\nThis is line " + i + " in mu";
        }
        printWriter.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/mu", 2L);
        oneTest.getWc().setItemContent("A/mu", string);
        this.addExpectedCommitItem(oneTest.getWorkingCopy().getAbsolutePath(), oneTest.getUrl().toString(), "A/mu", NodeKind.file, 4);
        File file2 = new File(oneTest.getWorkingCopy(), "A/D/G/rho");
        PrintWriter printWriter2 = new PrintWriter(new FileOutputStream(file2, true));
        String string2 = oneTest.getWc().getItemContent("A/D/G/rho");
        for (int i = 2; i < 11; ++i) {
            printWriter2.print("\nThis is line " + i + " in rho");
            string2 = string2 + "\nThis is line " + i + " in rho";
        }
        printWriter2.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/D/G/rho", 2L);
        oneTest.getWc().setItemContent("A/D/G/rho", string2);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/D/G/rho", NodeKind.file, 4);
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 2L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        oneTest.checkStatus();
        SVNTests.OneTest oneTest2 = oneTest.copy(".backup");
        printWriter = new PrintWriter(new FileOutputStream(file, true));
        string = oneTest.getWc().getItemContent("A/mu");
        printWriter.print(" Appended to line 10 of mu");
        string = string + " Appended to line 10 of mu";
        printWriter.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/mu", 3L);
        oneTest.getWc().setItemContent("A/mu", string);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/mu", NodeKind.file, 4);
        printWriter2 = new PrintWriter(new FileOutputStream(file2, true));
        string2 = oneTest.getWc().getItemContent("A/D/G/rho");
        printWriter2.print(" Appended to line 10 of rho");
        string2 = string2 + " Appended to line 10 of rho";
        printWriter2.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/D/G/rho", 3L);
        oneTest.getWc().setItemContent("A/D/G/rho", string2);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/D/G/rho", NodeKind.file, 4);
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 3L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        oneTest.checkStatus();
        file = new File(oneTest2.getWorkingCopy(), "A/mu");
        printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.print("This is the new line 1 in the backup copy of mu");
        string = "This is the new line 1 in the backup copy of mu";
        for (n = 2; n < 11; ++n) {
            printWriter.print("\nThis is line " + n + " in mu");
            string = string + "\nThis is line " + n + " in mu";
        }
        printWriter.close();
        oneTest2.getWc().setItemWorkingCopyRevision("A/mu", 3L);
        string = string + " Appended to line 10 of mu";
        oneTest2.getWc().setItemContent("A/mu", string);
        oneTest2.getWc().setItemTextStatus("A/mu", Status.Kind.modified);
        file2 = new File(oneTest2.getWorkingCopy(), "A/D/G/rho");
        printWriter2 = new PrintWriter(new FileOutputStream(file2));
        printWriter2.print("This is the new line 1 in the backup copy of rho");
        string2 = "This is the new line 1 in the backup copy of rho";
        for (n = 2; n < 11; ++n) {
            printWriter2.print("\nThis is line " + n + " in rho");
            string2 = string2 + "\nThis is line " + n + " in rho";
        }
        printWriter2.close();
        oneTest2.getWc().setItemWorkingCopyRevision("A/D/G/rho", 3L);
        string2 = string2 + " Appended to line 10 of rho";
        oneTest2.getWc().setItemContent("A/D/G/rho", string2);
        oneTest2.getWc().setItemTextStatus("A/D/G/rho", Status.Kind.modified);
        BasicTests.assertEquals((String)"wrong revision number from update", (long)this.update(oneTest2), (long)3L);
        oneTest2.checkStatus();
    }

    public void testBasicConflict() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        SVNTests.OneTest oneTest2 = oneTest.copy(".backup");
        File file = new File(oneTest.getWorkingCopy(), "A/mu");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        String string = oneTest.getWc().getItemContent("A/mu");
        printWriter.print("\nOriginal appended text for mu");
        string = string + "\nOriginal appended text for mu";
        printWriter.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/mu", 2L);
        oneTest.getWc().setItemContent("A/mu", string);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/mu", NodeKind.file, 4);
        File file2 = new File(oneTest.getWorkingCopy(), "A/D/G/rho");
        PrintWriter printWriter2 = new PrintWriter(new FileOutputStream(file2, true));
        String string2 = oneTest.getWc().getItemContent("A/D/G/rho");
        printWriter2.print("\nOriginal appended text for rho");
        string2 = string2 + "\nOriginal appended text for rho";
        printWriter2.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/D/G/rho", 2L);
        oneTest.getWc().setItemContent("A/D/G/rho", string2);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/D/G/rho", NodeKind.file, 4);
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 2L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        oneTest.checkStatus();
        file = new File(oneTest2.getWorkingCopy(), "A/mu");
        printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("\nConflicting appended text for mu");
        string = "<<<<<<< .mine\nThis is the file 'mu'.\nConflicting appended text for mu=======\nThis is the file 'mu'.\nOriginal appended text for mu>>>>>>> .r2";
        printWriter.close();
        oneTest2.getWc().setItemWorkingCopyRevision("A/mu", 2L);
        oneTest2.getWc().setItemContent("A/mu", string);
        oneTest2.getWc().setItemTextStatus("A/mu", Status.Kind.conflicted);
        oneTest2.getWc().addItem("A/mu.r1", "");
        oneTest2.getWc().setItemNodeKind("A/mu.r1", NodeKind.unknown);
        oneTest2.getWc().setItemTextStatus("A/mu.r1", Status.Kind.unversioned);
        oneTest2.getWc().addItem("A/mu.r2", "");
        oneTest2.getWc().setItemNodeKind("A/mu.r2", NodeKind.unknown);
        oneTest2.getWc().setItemTextStatus("A/mu.r2", Status.Kind.unversioned);
        oneTest2.getWc().addItem("A/mu.mine", "");
        oneTest2.getWc().setItemNodeKind("A/mu.mine", NodeKind.unknown);
        oneTest2.getWc().setItemTextStatus("A/mu.mine", Status.Kind.unversioned);
        file2 = new File(oneTest2.getWorkingCopy(), "A/D/G/rho");
        printWriter2 = new PrintWriter(new FileOutputStream(file2, true));
        printWriter2.print("\nConflicting appended text for rho");
        string2 = "<<<<<<< .mine\nThis is the file 'rho'.\nConflicting appended text for rho=======\nhis is the file 'rho'.\nOriginal appended text for rho>>>>>>> .r2";
        printWriter2.close();
        oneTest2.getWc().setItemWorkingCopyRevision("A/D/G/rho", 2L);
        oneTest2.getWc().setItemContent("A/D/G/rho", string2);
        oneTest2.getWc().setItemTextStatus("A/D/G/rho", Status.Kind.conflicted);
        oneTest2.getWc().addItem("A/D/G/rho.r1", "");
        oneTest2.getWc().setItemNodeKind("A/D/G/rho.r1", NodeKind.unknown);
        oneTest2.getWc().setItemTextStatus("A/D/G/rho.r1", Status.Kind.unversioned);
        oneTest2.getWc().addItem("A/D/G/rho.r2", "");
        oneTest2.getWc().setItemNodeKind("A/D/G/rho.r2", NodeKind.unknown);
        oneTest2.getWc().setItemTextStatus("A/D/G/rho.r2", Status.Kind.unversioned);
        oneTest2.getWc().addItem("A/D/G/rho.mine", "");
        oneTest2.getWc().setItemNodeKind("A/D/G/rho.mine", NodeKind.unknown);
        oneTest2.getWc().setItemTextStatus("A/D/G/rho.mine", Status.Kind.unversioned);
        BasicTests.assertEquals((String)"wrong revision number from update", (long)this.update(oneTest2), (long)2L);
        oneTest2.checkStatus();
        this.client.resolve(oneTest2.getWCPath() + "/A/mu", Depth.empty, ConflictResult.Choice.chooseMerged);
        oneTest2.getWc().setItemTextStatus("A/mu", Status.Kind.modified);
        oneTest2.getWc().removeItem("A/mu.r1");
        oneTest2.getWc().removeItem("A/mu.r2");
        oneTest2.getWc().removeItem("A/mu.mine");
        this.client.resolve(oneTest2.getWCPath() + "/A/D/G/rho", Depth.empty, ConflictResult.Choice.chooseMerged);
        oneTest2.getWc().setItemTextStatus("A/D/G/rho", Status.Kind.modified);
        oneTest2.getWc().removeItem("A/D/G/rho.r1");
        oneTest2.getWc().removeItem("A/D/G/rho.r2");
        oneTest2.getWc().removeItem("A/D/G/rho.mine");
        oneTest2.checkStatus();
    }

    public void testBasicCleanup() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        this.client.cleanup(oneTest.getWCPath());
    }

    public void testBasicRevert() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWorkingCopy(), "A/B/E/beta");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("Added some text to 'beta'.");
        printWriter.close();
        oneTest.getWc().setItemTextStatus("A/B/E/beta", Status.Kind.modified);
        file = new File(oneTest.getWorkingCopy(), "iota");
        printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("Added some text to 'iota'.");
        printWriter.close();
        oneTest.getWc().setItemTextStatus("iota", Status.Kind.modified);
        file = new File(oneTest.getWorkingCopy(), "A/D/G/rho");
        printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("Added some text to 'rho'.");
        printWriter.close();
        oneTest.getWc().setItemTextStatus("A/D/G/rho", Status.Kind.modified);
        file = new File(oneTest.getWorkingCopy(), "A/D/H/zeta");
        printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("Added some text to 'zeta'.");
        printWriter.close();
        oneTest.getWc().addItem("A/D/H/zeta", "Added some text to 'zeta'.");
        oneTest.getWc().setItemTextStatus("A/D/H/zeta", Status.Kind.added);
        this.client.add(file.getAbsolutePath(), Depth.empty, false, false, false);
        oneTest.checkStatus();
        this.client.revert(oneTest.getWCPath() + "/A/B/E/beta", Depth.empty, null);
        oneTest.getWc().setItemTextStatus("A/B/E/beta", Status.Kind.normal);
        this.client.revert(oneTest.getWCPath() + "/iota", Depth.empty, null);
        oneTest.getWc().setItemTextStatus("iota", Status.Kind.normal);
        this.client.revert(oneTest.getWCPath() + "/A/D/G/rho", Depth.empty, null);
        oneTest.getWc().setItemTextStatus("A/D/G/rho", Status.Kind.normal);
        this.client.revert(oneTest.getWCPath() + "/A/D/H/zeta", Depth.empty, null);
        oneTest.getWc().setItemTextStatus("A/D/H/zeta", Status.Kind.unversioned);
        oneTest.getWc().setItemNodeKind("A/D/H/zeta", NodeKind.unknown);
        oneTest.checkStatus();
        file = new File(oneTest.getWorkingCopy(), "A/B/E/beta");
        file.delete();
        this.client.revert(file.getAbsolutePath(), Depth.empty, null);
        BasicTests.assertTrue((String)"reverted file is not readonly", (file.canWrite() && file.canRead() ? 1 : 0) != 0);
        oneTest.checkStatus();
        this.client.mkdir(oneTest.getWCPathSet("/X"), false, null, null, null);
        oneTest.getWc().addItem("X", null);
        oneTest.getWc().setItemTextStatus("X", Status.Kind.added);
        oneTest.checkStatus();
        BasicTests.removeDirOrFile(new File(oneTest.getWorkingCopy(), "X"));
        this.client.revert(oneTest.getWCPath() + "/X", Depth.empty, null);
        oneTest.getWc().removeItem("X");
        oneTest.checkStatus();
        this.client.remove(oneTest.getWCPathSet("/A/B/E"), true, false, null, null, null);
        BasicTests.removeDirOrFile(new File(oneTest.getWorkingCopy(), "A/B/E"));
        oneTest.getWc().setItemTextStatus("A/B/E", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/B/E/alpha", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/B/E/beta", Status.Kind.deleted);
        oneTest.checkStatus();
        this.client.revert(oneTest.getWCPath() + "/A/B/E", Depth.infinity, null);
        oneTest.getWc().setItemTextStatus("A/B/E", Status.Kind.normal);
        oneTest.getWc().setItemTextStatus("A/B/E/alpha", Status.Kind.normal);
        oneTest.getWc().setItemTextStatus("A/B/E/beta", Status.Kind.normal);
        oneTest.checkStatus();
    }

    public void testBasicSwitch() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        String string = oneTest.getWCPath() + "/iota";
        String string2 = oneTest.getUrl() + "/A/D/gamma";
        oneTest.getWc().setItemContent("iota", this.greekWC.getItemContent("A/D/gamma"));
        oneTest.getWc().setItemIsSwitched("iota", true);
        this.client.doSwitch(string, string2, null, Revision.HEAD, Depth.unknown, false, false, false, true);
        oneTest.checkStatus();
        String string3 = oneTest.getWCPath() + "/A/D/H";
        String string4 = oneTest.getUrl() + "/A/D/G";
        oneTest.getWc().setItemIsSwitched("A/D/H", true);
        oneTest.getWc().removeItem("A/D/H/chi");
        oneTest.getWc().removeItem("A/D/H/omega");
        oneTest.getWc().removeItem("A/D/H/psi");
        oneTest.getWc().addItem("A/D/H/pi", oneTest.getWc().getItemContent("A/D/G/pi"));
        oneTest.getWc().addItem("A/D/H/rho", oneTest.getWc().getItemContent("A/D/G/rho"));
        oneTest.getWc().addItem("A/D/H/tau", oneTest.getWc().getItemContent("A/D/G/tau"));
        this.client.doSwitch(string3, string4, null, Revision.HEAD, Depth.files, false, false, false, true);
        oneTest.checkStatus();
    }

    public void testBasicDelete() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWorkingCopy(), "A/D/H/chi");
        HashSet<String> hashSet = new HashSet<String>();
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("added to chi");
        printWriter.close();
        oneTest.getWc().setItemTextStatus("A/D/H/chi", Status.Kind.modified);
        hashSet.clear();
        hashSet.add(oneTest.getWCPath() + "/A/D/G/rho");
        this.client.propertySetLocal(hashSet, "abc", new String("def").getBytes(), Depth.infinity, null, false);
        oneTest.getWc().setItemPropStatus("A/D/G/rho", Status.Kind.modified);
        this.setprop(oneTest.getWCPath() + "/A/B/F", "abc", "def");
        oneTest.getWc().setItemPropStatus("A/B/F", Status.Kind.modified);
        file = new File(oneTest.getWCPath(), "A/C/sigma");
        printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.print("unversioned sigma");
        printWriter.close();
        oneTest.getWc().addItem("A/C/sigma", "unversioned sigma");
        oneTest.getWc().setItemTextStatus("A/C/sigma", Status.Kind.unversioned);
        oneTest.getWc().setItemNodeKind("A/C/sigma", NodeKind.unknown);
        file = new File(oneTest.getWCPath(), "A/C/Q");
        file.mkdir();
        oneTest.getWc().addItem("A/C/Q", null);
        oneTest.getWc().setItemNodeKind("A/C/Q", NodeKind.unknown);
        oneTest.getWc().setItemTextStatus("A/C/Q", Status.Kind.unversioned);
        file = new File(oneTest.getWCPath(), "A/B/X");
        hashSet.clear();
        hashSet.add(file.getAbsolutePath());
        this.client.mkdir(hashSet, false, null, null, null);
        oneTest.getWc().addItem("A/B/X", null);
        oneTest.getWc().setItemTextStatus("A/B/X", Status.Kind.added);
        file = new File(file, "xi");
        printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.print("added xi");
        printWriter.close();
        this.client.add(file.getAbsolutePath(), Depth.empty, false, false, false);
        oneTest.getWc().addItem("A/B/X/xi", "added xi");
        oneTest.getWc().setItemTextStatus("A/B/X/xi", Status.Kind.added);
        file = new File(oneTest.getWCPath(), "A/B/Y");
        hashSet.clear();
        hashSet.add(file.getAbsolutePath());
        this.client.mkdir(hashSet, false, null, null, null);
        oneTest.getWc().addItem("A/B/Y", null);
        oneTest.getWc().setItemTextStatus("A/B/Y", Status.Kind.added);
        oneTest.checkStatus();
        try {
            this.client.remove(oneTest.getWCPathSet("/A/D/H/chi"), false, false, null, null, null);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        try {
            this.client.remove(oneTest.getWCPathSet("/A/D/H"), false, false, null, null, null);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        try {
            this.client.remove(oneTest.getWCPathSet("/A/D/G/rho"), false, false, null, null, null);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        try {
            this.client.remove(oneTest.getWCPathSet("/A/D/G"), false, false, null, null, null);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        try {
            this.client.remove(oneTest.getWCPathSet("/A/B/F"), false, false, null, null, null);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        try {
            this.client.remove(oneTest.getWCPathSet("/A/B"), false, false, null, null, null);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        try {
            this.client.remove(oneTest.getWCPathSet("/A/C/sigma"), false, false, null, null, null);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        try {
            this.client.remove(oneTest.getWCPathSet("/A/C"), false, false, null, null, null);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        try {
            this.client.remove(oneTest.getWCPathSet("/A/B/X"), false, false, null, null, null);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        oneTest.checkStatus();
        this.client.remove(oneTest.getWCPathSet("/A/B/E"), false, false, null, null, null);
        oneTest.getWc().setItemTextStatus("A/B/E", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/B/E/alpha", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/B/E/beta", Status.Kind.deleted);
        this.client.remove(oneTest.getWCPathSet("/A/D/H"), true, false, null, null, null);
        oneTest.getWc().setItemTextStatus("A/D/H", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/D/H/chi", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/D/H/omega", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/D/H/psi", Status.Kind.deleted);
        this.client.remove(oneTest.getWCPathSet("/A/D/G"), true, false, null, null, null);
        oneTest.getWc().setItemTextStatus("A/D/G", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/D/G/rho", Status.Kind.deleted);
        oneTest.getWc().setItemPropStatus("A/D/G/rho", Status.Kind.none);
        oneTest.getWc().setItemTextStatus("A/D/G/pi", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/D/G/tau", Status.Kind.deleted);
        this.client.remove(oneTest.getWCPathSet("/A/B/F"), true, false, null, null, null);
        oneTest.getWc().setItemTextStatus("A/B/F", Status.Kind.deleted);
        oneTest.getWc().setItemPropStatus("A/B/F", Status.Kind.none);
        this.client.remove(oneTest.getWCPathSet("/A/C"), true, false, null, null, null);
        oneTest.getWc().setItemTextStatus("A/C", Status.Kind.deleted);
        this.client.remove(oneTest.getWCPathSet("/A/B/X"), true, false, null, null, null);
        file = new File(oneTest.getWorkingCopy(), "iota");
        file.delete();
        hashSet.clear();
        hashSet.add(file.getAbsolutePath());
        this.client.remove(hashSet, true, false, null, null, null);
        oneTest.getWc().setItemTextStatus("iota", Status.Kind.deleted);
        file = new File(oneTest.getWorkingCopy(), "A/D/gamma");
        file.delete();
        hashSet.clear();
        hashSet.add(file.getAbsolutePath());
        this.client.remove(hashSet, false, false, null, null, null);
        oneTest.getWc().setItemTextStatus("A/D/gamma", Status.Kind.deleted);
        hashSet.clear();
        hashSet.add(file.getAbsolutePath());
        this.client.remove(hashSet, true, false, null, null, null);
        this.client.remove(oneTest.getWCPathSet("/A/B/E"), false, false, null, null, null);
        oneTest.getWc().removeItem("A/B/X");
        oneTest.getWc().removeItem("A/B/X/xi");
        oneTest.getWc().removeItem("A/C/sigma");
        oneTest.getWc().removeItem("A/C/Q");
        oneTest.checkStatus();
        this.client.remove(oneTest.getWCPathSet("/A/D"), true, false, null, null, null);
        oneTest.getWc().setItemTextStatus("A/D", Status.Kind.deleted);
        oneTest.getWc().removeItem("A/D/Y");
        oneTest.checkStatus();
        BasicTests.assertFalse((String)"failed to remove text modified file", (boolean)new File(oneTest.getWorkingCopy(), "A/D/G/rho").exists());
        BasicTests.assertFalse((String)"failed to remove prop modified file", (boolean)new File(oneTest.getWorkingCopy(), "A/D/H/chi").exists());
        BasicTests.assertFalse((String)"failed to remove unversioned file", (boolean)new File(oneTest.getWorkingCopy(), "A/C/sigma").exists());
        BasicTests.assertFalse((String)"failed to remove unmodified file", (boolean)new File(oneTest.getWorkingCopy(), "A/B/E/alpha").exists());
        file = new File(oneTest.getWorkingCopy(), "A/B/F");
        BasicTests.assertFalse((String)"failed to remove versioned dir", (boolean)file.exists());
        BasicTests.assertFalse((String)"failed to remove unversioned dir", (boolean)new File(oneTest.getWorkingCopy(), "A/C/Q").exists());
        BasicTests.assertFalse((String)"failed to remove added dir", (boolean)new File(oneTest.getWorkingCopy(), "A/B/X").exists());
        file = new File(oneTest.getWCPath(), "foo");
        printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.print("unversioned foo");
        printWriter.close();
        hashSet.clear();
        hashSet.add(file.getAbsolutePath());
        this.client.remove(hashSet, true, false, null, null, null);
        BasicTests.assertFalse((String)"failed to remove unversioned file foo", (boolean)file.exists());
        try {
            HashSet<String> hashSet2 = new HashSet<String>(1);
            hashSet2.add(file.getAbsolutePath());
            this.client.remove(hashSet2, true, false, null, null, null);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        this.addExpectedCommitItem(null, oneTest.getUrl().toString(), "iota", NodeKind.none, 2);
        this.client.remove(oneTest.getUrlSet("/iota"), false, false, null, new ConstMsg("delete iota URL"), null);
    }

    public void testBasicCheckoutDeleted() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        this.client.remove(oneTest.getWCPathSet("/A/D"), true, false, null, null, null);
        oneTest.getWc().setItemTextStatus("A/D", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/D/G", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/D/G/rho", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/D/G/pi", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/D/G/tau", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/D/H", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/D/H/chi", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/D/H/psi", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/D/H/omega", Status.Kind.deleted);
        oneTest.getWc().setItemTextStatus("A/D/gamma", Status.Kind.deleted);
        oneTest.checkStatus();
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/D", NodeKind.dir, 2);
        this.checkCommitRevision(oneTest, "wrong revision from commit", 2L, oneTest.getWCPathSet(), "log message", Depth.infinity, false, false, null, null);
        oneTest.getWc().removeItem("A/D");
        oneTest.getWc().removeItem("A/D/G");
        oneTest.getWc().removeItem("A/D/G/rho");
        oneTest.getWc().removeItem("A/D/G/pi");
        oneTest.getWc().removeItem("A/D/G/tau");
        oneTest.getWc().removeItem("A/D/H");
        oneTest.getWc().removeItem("A/D/H/chi");
        oneTest.getWc().removeItem("A/D/H/psi");
        oneTest.getWc().removeItem("A/D/H/omega");
        oneTest.getWc().removeItem("A/D/gamma");
        oneTest.checkStatus();
        this.client.checkout(oneTest.getUrl() + "/A/D", oneTest.getWCPath() + "/new_D", new Revision.Number(1L), new Revision.Number(1L), Depth.infinity, false, false);
    }

    public void testBasicImport() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWCPath(), "new_file");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.print("some text");
        printWriter.close();
        this.addExpectedCommitItem(oneTest.getWCPath(), null, "new_file", NodeKind.none, 1);
        this.client.doImport(file.getAbsolutePath(), oneTest.getUrl() + "/dirA/dirB/new_file", Depth.infinity, false, false, null, new ConstMsg("log message for new import"), null);
        file.delete();
        BasicTests.assertEquals((String)"wrong revision from update", (long)this.update(oneTest), (long)2L);
        oneTest.getWc().addItem("dirA", null);
        oneTest.getWc().setItemWorkingCopyRevision("dirA", 2L);
        oneTest.getWc().addItem("dirA/dirB", null);
        oneTest.getWc().setItemWorkingCopyRevision("dirA/dirB", 2L);
        oneTest.getWc().addItem("dirA/dirB/new_file", "some text");
        oneTest.getWc().setItemWorkingCopyRevision("dirA/dirB/new_file", 2L);
        oneTest.checkStatus();
    }

    public void testBasicCat() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWorkingCopy(), "A/mu");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("some text");
        printWriter.close();
        byte[] byArray = this.client.fileContent(oneTest.getWCPath() + "/A/mu", null, null);
        byte[] byArray2 = oneTest.getWc().getItemContent("A/mu").getBytes();
        BasicTests.assertTrue((String)"content changed", (boolean)Arrays.equals(byArray, byArray2));
    }

    public void testBasicCatStream() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWorkingCopy(), "A/mu");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("some text");
        printWriter.close();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.client.streamFileContent(oneTest.getWCPath() + "/A/mu", null, null, byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byte[] byArray2 = oneTest.getWc().getItemContent("A/mu").getBytes();
        BasicTests.assertTrue((String)"content changed", (boolean)Arrays.equals(byArray, byArray2));
    }

    public void testBasicLs() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        DirEntry[] dirEntryArray = this.collectDirEntries(oneTest.getWCPath(), null, null, Depth.immediates, -1, false);
        oneTest.getWc().check(dirEntryArray, "", false);
        dirEntryArray = this.collectDirEntries(oneTest.getWCPath() + "/A", null, null, Depth.immediates, -1, false);
        oneTest.getWc().check(dirEntryArray, "A", false);
        dirEntryArray = this.collectDirEntries(oneTest.getWCPath() + "/A", Revision.BASE, Revision.BASE, Depth.immediates, -1, false);
        oneTest.getWc().check(dirEntryArray, "A", false);
        dirEntryArray = this.collectDirEntries(oneTest.getWCPath() + "/A/mu", null, null, Depth.immediates, -1, false);
        oneTest.getWc().check(dirEntryArray, "A/mu");
    }

    public void testBasicAddIgnores() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWorkingCopy(), "dir");
        file.mkdir();
        File file2 = new File(file, "foo.c");
        new FileOutputStream(file2).close();
        File file3 = new File(file, "foo.o");
        new FileOutputStream(file3).close();
        this.client.add(file.getAbsolutePath(), Depth.infinity, false, false, false);
        oneTest.getWc().addItem("dir", null);
        oneTest.getWc().setItemTextStatus("dir", Status.Kind.added);
        oneTest.getWc().addItem("dir/foo.c", "");
        oneTest.getWc().setItemTextStatus("dir/foo.c", Status.Kind.added);
        oneTest.getWc().addItem("dir/foo.o", "");
        oneTest.getWc().setItemTextStatus("dir/foo.o", Status.Kind.ignored);
        oneTest.getWc().setItemNodeKind("dir/foo.o", NodeKind.unknown);
        oneTest.checkStatus();
    }

    public void testBasicImportIgnores() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWorkingCopy(), "dir");
        file.mkdir();
        File file2 = new File(file, "foo.c");
        new FileOutputStream(file2).close();
        File file3 = new File(file, "foo.o");
        new FileOutputStream(file3).close();
        this.addExpectedCommitItem(oneTest.getWCPath(), null, "dir", NodeKind.none, 1);
        this.client.doImport(file.getAbsolutePath(), oneTest.getUrl() + "/dir", Depth.infinity, false, false, null, new ConstMsg("log message for import"), null);
        BasicTests.removeDirOrFile(file);
        BasicTests.assertEquals((String)"wrong revision from update", (long)this.update(oneTest), (long)2L);
        oneTest.getWc().addItem("dir", null);
        oneTest.getWc().addItem("dir/foo.c", "");
        oneTest.checkStatus();
    }

    public void testBasicInfo() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        Info info = this.collectInfos(oneTest.getWCPath() + "/A/mu", null, null, Depth.empty, null)[0];
        BasicTests.assertEquals((String)"wrong revision from info", (long)1L, (long)info.getLastChangedRev());
        BasicTests.assertEquals((String)"wrong schedule kind from info", (Object)((Object)Info.ScheduleKind.normal), (Object)((Object)info.getSchedule()));
        BasicTests.assertEquals((String)"wrong node kind from info", (Object)((Object)NodeKind.file), (Object)((Object)info.getKind()));
    }

    public void testBasicLogMessage() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        ArrayList<RevisionRange> arrayList = new ArrayList<RevisionRange>(1);
        arrayList.add(new RevisionRange(null, null));
        LogMessage[] logMessageArray = this.collectLogMessages(oneTest.getWCPath(), null, arrayList, false, true, false, 0L);
        BasicTests.assertEquals((String)"wrong number of objects", (int)1, (int)logMessageArray.length);
        BasicTests.assertEquals((String)"wrong message", (String)"Log Message", (String)logMessageArray[0].getMessage());
        BasicTests.assertEquals((String)"wrong revision", (long)1L, (long)logMessageArray[0].getRevisionNumber());
        BasicTests.assertEquals((String)"wrong user", (String)"jrandom", (String)logMessageArray[0].getAuthor());
        BasicTests.assertNotNull((String)"changed paths set", logMessageArray[0].getChangedPaths());
        Set<ChangePath> set = logMessageArray[0].getChangedPaths();
        BasicTests.assertEquals((String)"wrong number of chang pathes", (int)20, (int)set.size());
        ChangePath changePath = set.toArray(new ChangePath[1])[0];
        BasicTests.assertNotNull((String)"wrong path", (Object)changePath);
        BasicTests.assertEquals((String)"wrong copy source rev", (long)-1L, (long)changePath.getCopySrcRevision());
        BasicTests.assertNull((String)"wrong copy source path", (Object)changePath.getCopySrcPath());
        BasicTests.assertEquals((String)"wrong action", (Object)((Object)ChangePath.Action.add), (Object)((Object)changePath.getAction()));
        BasicTests.assertEquals((String)"wrong time with getTimeMicros()", (long)(logMessageArray[0].getTimeMicros() / 1000L), (long)logMessageArray[0].getDate().getTime());
        BasicTests.assertEquals((String)"wrong time with getTimeMillis()", (long)logMessageArray[0].getTimeMillis(), (long)logMessageArray[0].getDate().getTime());
        BasicTests.assertEquals((String)"wrong date with getTimeMicros()", (Object)logMessageArray[0].getDate(), (Object)new Date(logMessageArray[0].getTimeMicros() / 1000L));
        BasicTests.assertEquals((String)"wrong date with getTimeMillis()", (Object)logMessageArray[0].getDate(), (Object)new Date(logMessageArray[0].getTimeMillis()));
        String string = oneTest.getUrl().toString() + "/";
        LogMessage[] logMessageArray2 = this.collectLogMessages(string, null, arrayList, false, true, false, 0L);
    }

    public void testBasicVersionInfo() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        BasicTests.assertEquals((String)"wrong version info", (String)"1", (String)this.client.getVersionInfo(oneTest.getWCPath(), null, false));
    }

    public void testBasicLocking() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(oneTest.getWCPath() + "/A/mu");
        this.setprop(oneTest.getWCPath() + "/A/mu", "svn:needs-lock", "*");
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/mu", NodeKind.file, 8);
        this.checkCommitRevision(oneTest, "bad revision number on commit", 2L, oneTest.getWCPathSet(), "message", Depth.infinity, false, false, null, null);
        File file = new File(oneTest.getWCPath() + "/A/mu");
        BasicTests.assertEquals((String)"file should be read only now", (boolean)false, (boolean)file.canWrite());
        this.client.lock(hashSet, "comment", false);
        BasicTests.assertEquals((String)"file should be read write now", (boolean)true, (boolean)file.canWrite());
        this.client.unlock(hashSet, false);
        BasicTests.assertEquals((String)"file should be read only now", (boolean)false, (boolean)file.canWrite());
        this.client.lock(hashSet, "comment", false);
        BasicTests.assertEquals((String)"file should be read write now", (boolean)true, (boolean)file.canWrite());
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/mu", NodeKind.file, 0);
        this.checkCommitRevision(oneTest, "rev number from commit", -1L, oneTest.getWCPathSet(), "message", Depth.infinity, false, false, null, null);
        BasicTests.assertEquals((String)"file should be read write now", (boolean)true, (boolean)file.canWrite());
        try {
            this.client.lock(oneTest.getWCPathSet("/A/mu2"), "comment", false);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    public void testBasicInfo2() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        Info[] infoArray = this.collectInfos(oneTest.getWCPath(), null, null, Depth.empty, null);
        BasicTests.assertEquals((String)"Incorrect number of info objects", (int)1, (int)infoArray.length);
        infoArray = this.collectInfos(oneTest.getWCPath(), null, null, Depth.infinity, null);
        BasicTests.assertEquals((String)"Incorrect number of info objects", (int)21, (int)infoArray.length);
        for (Info info : infoArray) {
            BasicTests.assertNull((String)"Unexpected changelist present", (Object)info.getChangelistName());
            boolean bl = info.getKind() == NodeKind.file;
            BasicTests.assertTrue((String)("Unexpected working file size " + info.getWorkingSize() + " for '" + info + '\''), (boolean)(bl ? info.getWorkingSize() > -1L : info.getWorkingSize() == -1L));
            BasicTests.assertEquals((String)("Unexpected repos file size for '" + info + '\''), (long)-1L, (long)info.getReposSize());
            BasicTests.assertEquals((String)("Unexpected depth for '" + info + "'"), (Object)((Object)(bl ? Depth.unknown : Depth.infinity)), (Object)((Object)info.getDepth()));
        }
        String string = oneTest.getWCPath() + ".empty";
        BasicTests.removeDirOrFile(new File(string));
        this.client.checkout(oneTest.getUrl().toString(), string, null, null, Depth.empty, false, true);
        infoArray = this.collectInfos(string, null, null, Depth.empty, null);
        BasicTests.assertEquals((Object)((Object)Depth.empty), (Object)((Object)infoArray[0].getDepth()));
    }

    public void testBasicChangelist() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        String string = "changelist1";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        MyChangelistCallback myChangelistCallback = new MyChangelistCallback();
        String string2 = this.fileToSVNPath(new File(oneTest.getWCPath(), "iota"), true);
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string2);
        this.client.addToChangelist(hashSet, string, Depth.infinity, null);
        this.client.getChangelists(oneTest.getWCPath(), arrayList, Depth.infinity, myChangelistCallback);
        Collection<String> collection = myChangelistCallback.get(string2);
        BasicTests.assertTrue((boolean)arrayList.equals(collection));
        MyStatusCallback myStatusCallback = new MyStatusCallback();
        this.client.status(string2, Depth.immediates, false, true, false, false, false, false, null, myStatusCallback);
        Status[] statusArray = myStatusCallback.getStatusArray();
        BasicTests.assertEquals((String)statusArray[0].getChangelist(), (String)string);
        this.client.removeFromChangelists(hashSet, Depth.infinity, arrayList);
        myChangelistCallback.clear();
        this.client.getChangelists(oneTest.getWCPath(), arrayList, Depth.infinity, myChangelistCallback);
        BasicTests.assertTrue((boolean)myChangelistCallback.isEmpty());
    }

    public void testGetAllChangelists() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        MyChangelistCallback myChangelistCallback = new MyChangelistCallback();
        String string = this.fileToSVNPath(new File(oneTest.getWCPath(), "iota"), true);
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string);
        this.client.addToChangelist(hashSet, "changelist_one", Depth.infinity, null);
        hashSet.remove(string);
        string = this.fileToSVNPath(new File(oneTest.getWCPath(), "A/B/lambda"), true);
        hashSet.add(string);
        this.client.addToChangelist(hashSet, "changelist_too", Depth.infinity, null);
        this.client.getChangelists(oneTest.getWCPath(), null, Depth.infinity, myChangelistCallback);
        Collection<String> collection = myChangelistCallback.getChangelists();
        BasicTests.assertEquals((int)2, (int)collection.size());
        BasicTests.assertTrue((String)"Contains changelist_one", (boolean)collection.contains("changelist_one"));
        BasicTests.assertTrue((String)"Contains changelist_too", (boolean)collection.contains("changelist_too"));
    }

    private void acquireMergeinfoAndAssertEquals(long l, long l2, long l3, long l4, String string, String string2) throws SubversionException {
        Mergeinfo mergeinfo = this.client.getMergeinfo(string, Revision.HEAD);
        BasicTests.assertNotNull((String)("Missing merge info on '" + string + '\''), (Object)mergeinfo);
        List<RevisionRange> list = mergeinfo.getRevisions(string2);
        BasicTests.assertTrue((String)("Missing merge info for source '" + string2 + "' on '" + string + '\''), (list != null && !list.isEmpty() ? 1 : 0) != 0);
        RevisionRange revisionRange = list.get(0);
        String string3 = l + "-" + l2;
        BasicTests.assertEquals((String)("Unexpected first merged revision range for '" + string2 + "' on '" + string + '\''), (String)string3, (String)revisionRange.toString());
        if (l3 > 0L) {
            long[] lArray = this.getMergeinfoRevisions(Mergeinfo.LogKind.eligible, string, Revision.HEAD, string2, Revision.HEAD);
            BasicTests.assertNotNull((String)("Missing eligible merge info on '" + string + '\''), (Object)lArray);
            this.assertExpectedMergeRange(l3, l4, lArray);
        }
    }

    private long[] getMergeinfoRevisions(Mergeinfo.LogKind logKind, String string, Revision revision, String string2, Revision revision2) throws SubversionException {
        final ArrayList arrayList = new ArrayList();
        this.client.getMergeinfoLog(logKind, string, revision, string2, revision2, false, Depth.empty, null, new LogMessageCallback(){

            @Override
            public void singleMessage(Set<ChangePath> set, long l, Map<String, byte[]> map, boolean bl) {
                arrayList.add(new Long(l));
            }
        });
        long[] lArray = new long[arrayList.size()];
        int n = 0;
        for (Long l : arrayList) {
            lArray[n] = l;
            ++n;
        }
        return lArray;
    }

    private File appendText(SVNTests.OneTest oneTest, String string, String string2, int n) throws FileNotFoundException {
        File file = new File(oneTest.getWorkingCopy(), string);
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print(string2);
        printWriter.close();
        if (n > 0) {
            WC wC = oneTest.getWc();
            wC.setItemWorkingCopyRevision(string, n);
            wC.setItemContent(string, wC.getItemContent(string) + string2);
        }
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), string, NodeKind.file, 4);
        return file;
    }

    public void testBasicMerge() throws Throwable {
        SVNTests.OneTest oneTest = this.setupAndPerformMerge();
        Set<String> set = this.client.suggestMergeSources(oneTest.getWCPath() + "/branches/A", Revision.WORKING);
        BasicTests.assertNotNull(set);
        BasicTests.assertEquals((int)1, (int)set.size());
        BasicTests.assertNull((Object)this.client.getMergeinfo(new File(oneTest.getWCPath(), "A").toString(), Revision.HEAD));
        this.appendText(oneTest, "A/mu", "xxx", 4);
        this.appendText(oneTest, "A/D/G/rho", "yyy", 4);
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 4L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        final Revision[] revisionArray = new Revision[2];
        ClientNotifyCallback clientNotifyCallback = new ClientNotifyCallback(){

            @Override
            public void onNotify(ClientNotifyInformation clientNotifyInformation) {
                if (clientNotifyInformation.getAction() == ClientNotifyInformation.Action.merge_begin) {
                    RevisionRange revisionRange = clientNotifyInformation.getMergeRange();
                    revisionArray[0] = revisionRange.getFromRevision();
                    revisionArray[1] = revisionRange.getToRevision();
                }
            }
        };
        this.client.notification2(clientNotifyCallback);
        String string = oneTest.getWCPath() + "/branches/A";
        String string2 = oneTest.getUrl() + "/A";
        this.client.merge(string2, (Revision)new Revision.Number(2L), string2, Revision.HEAD, string, false, Depth.infinity, false, true, false);
        BasicTests.assertEquals((String)"Notification of beginning of merge reported incorrect start revision", (Object)new Revision.Number(2L), (Object)revisionArray[0]);
        BasicTests.assertEquals((String)"Notification of beginning of merge reported incorrect end revision", (Object)new Revision.Number(4L), (Object)revisionArray[1]);
        this.client.merge(string2, (Revision)new Revision.Number(2L), string2, Revision.HEAD, string, false, Depth.infinity, false, false, false);
        BasicTests.assertEquals((String)"Notification of beginning of merge reported incorrect start revision", (Object)new Revision.Number(2L), (Object)revisionArray[0]);
        BasicTests.assertEquals((String)"Notification of beginning of merge reported incorrect end revision", (Object)new Revision.Number(4L), (Object)revisionArray[1]);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "branches/A", NodeKind.dir, 8);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "branches/A/mu", NodeKind.file, 4);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "branches/A/D/G/rho", NodeKind.file, 4);
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 5L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        this.appendText(oneTest, "A/mu", "xxxr6", 6);
        this.appendText(oneTest, "A/D/G/rho", "yyyr6", 6);
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 6L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        String string3 = new File(oneTest.getWCPath(), "branches/A/mu").getPath();
        String string4 = oneTest.getUrl() + "/A/mu";
        this.acquireMergeinfoAndAssertEquals(2L, 4L, 6L, 6L, string3, string4);
        string3 = oneTest.getUrl() + "/branches/A/mu";
        this.acquireMergeinfoAndAssertEquals(2L, 4L, 6L, 6L, string3, string4);
    }

    public void testMergeUsingHistory() throws Throwable {
        SVNTests.OneTest oneTest = this.setupAndPerformMerge();
        BasicTests.assertNull((Object)this.client.getMergeinfo(new File(oneTest.getWCPath(), "A").toString(), Revision.HEAD));
        this.appendText(oneTest, "A/mu", "xxx", 4);
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 4L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        String string = oneTest.getWCPath() + "/branches/A";
        String string2 = oneTest.getUrl() + "/A";
        Revision revision = new Revision(Revision.Kind.unspecified);
        ArrayList<RevisionRange> arrayList = new ArrayList<RevisionRange>(1);
        arrayList.add(new RevisionRange(revision, revision));
        this.client.merge(string2, Revision.HEAD, arrayList, string, true, Depth.infinity, false, false, false);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "branches/A", NodeKind.dir, 8);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "branches/A/mu", NodeKind.file, 4);
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 5L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
    }

    public void testMergeUsingHistoryImpliedRange() throws Throwable {
        SVNTests.OneTest oneTest = this.setupAndPerformMerge();
        BasicTests.assertNull((Object)this.client.getMergeinfo(new File(oneTest.getWCPath(), "A").toString(), Revision.HEAD));
        this.appendText(oneTest, "A/mu", "xxx", 4);
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 4L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        String string = oneTest.getWCPath() + "/branches/A";
        String string2 = oneTest.getUrl() + "/A";
        this.client.merge(string2, Revision.HEAD, null, string, true, Depth.infinity, false, false, false);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "branches/A", NodeKind.dir, 8);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "branches/A/mu", NodeKind.file, 4);
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 5L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
    }

    public void testMergeReintegrate() throws Throwable {
        SVNTests.OneTest oneTest = this.setupAndPerformMerge();
        BasicTests.assertNull((Object)this.client.getMergeinfo(new File(oneTest.getWCPath(), "A").toString(), Revision.HEAD));
        this.appendText(oneTest, "A/mu", "xxx", 4);
        this.checkCommitRevision(oneTest, "wrong revision number from main commit", 4L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        this.appendText(oneTest, "branches/A/D/G/rho", "yyy", -1);
        this.checkCommitRevision(oneTest, "wrong revision number from branch commit", 5L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        this.update(oneTest, "/branches");
        String string = oneTest.getWCPath() + "/branches/A";
        String string2 = oneTest.getUrl() + "/A";
        Revision revision = new Revision(Revision.Kind.unspecified);
        ArrayList<RevisionRange> arrayList = new ArrayList<RevisionRange>(1);
        arrayList.add(new RevisionRange(revision, revision));
        this.client.merge(string2, Revision.HEAD, arrayList, string, true, Depth.infinity, false, false, false);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "branches/A", NodeKind.dir, 8);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "branches/A/mu", NodeKind.file, 4);
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 6L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        String string3 = oneTest.getUrl() + "/branches/A";
        try {
            this.client.mergeReintegrate(string3, Revision.HEAD, oneTest.getWCPath() + "/A", false);
            BasicTests.fail((String)"reintegrate merged into a mixed-revision WC");
        }
        catch (ClientException clientException) {
            this.update(oneTest);
            this.client.mergeReintegrate(string3, Revision.HEAD, oneTest.getWCPath() + "/A", false);
        }
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A", NodeKind.dir, 8);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/D/G/rho", NodeKind.file, 4);
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 7L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
    }

    public void testMergeAutoReintegrate() throws Throwable {
        SVNTests.OneTest oneTest = this.setupAndPerformMerge();
        BasicTests.assertNull((Object)this.client.getMergeinfo(new File(oneTest.getWCPath(), "A").toString(), Revision.HEAD));
        this.appendText(oneTest, "A/mu", "xxx", 4);
        this.checkCommitRevision(oneTest, "wrong revision number from main commit", 4L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        this.appendText(oneTest, "branches/A/D/G/rho", "yyy", -1);
        this.checkCommitRevision(oneTest, "wrong revision number from branch commit", 5L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        this.update(oneTest, "/branches");
        String string = oneTest.getWCPath() + "/branches/A";
        String string2 = oneTest.getUrl() + "/A";
        Revision revision = new Revision(Revision.Kind.unspecified);
        ArrayList<RevisionRange> arrayList = new ArrayList<RevisionRange>(1);
        arrayList.add(new RevisionRange(revision, revision));
        this.client.merge(string2, Revision.HEAD, arrayList, string, true, Depth.infinity, false, false, false);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "branches/A", NodeKind.dir, 8);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "branches/A/mu", NodeKind.file, 4);
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 6L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        String string3 = oneTest.getUrl() + "/branches/A";
        this.client.merge(string3, Revision.HEAD, null, oneTest.getWCPath() + "/A", false, Depth.unknown, false, false, false, false);
        this.update(oneTest);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A", NodeKind.dir, 8);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/D/G/rho", NodeKind.file, 4);
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 7L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
    }

    public void testMergeConflictResolution() throws Throwable {
        this.client.setConflictResolver(new ConflictResolverCallback(){

            @Override
            public ConflictResult resolve(ConflictDescriptor conflictDescriptor) {
                return new ConflictResult(ConflictResult.Choice.chooseTheirsConflict, null);
            }
        });
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        String string = oneTest.getWc().getItemContent("A/mu");
        String string2 = string + "xxx";
        File file = this.appendText(oneTest, "A/mu", "xxx", 2);
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 2L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        this.client.update(oneTest.getWCPathSet(), Revision.getInstance(1L), Depth.unknown, false, false, false, false);
        file = this.appendText(oneTest, "A/mu", "yyy", 1);
        ArrayList<RevisionRange> arrayList = new ArrayList<RevisionRange>(1);
        arrayList.add(new RevisionRange(new Revision.Number(1L), new Revision.Number(2L)));
        this.client.merge(oneTest.getUrl().toString(), Revision.HEAD, arrayList, oneTest.getWCPath(), false, Depth.infinity, false, false, false);
        this.assertFileContentsEquals("Unexpected conflict resolution", string2, file);
    }

    public void testRecordOnlyMerge() throws Throwable {
        SVNTests.OneTest oneTest = this.setupAndPerformMerge();
        Set<String> set = this.client.suggestMergeSources(oneTest.getWCPath() + "/branches/A", Revision.WORKING);
        BasicTests.assertNotNull(set);
        BasicTests.assertEquals((int)1, (int)set.size());
        BasicTests.assertNull((Object)this.client.getMergeinfo(new File(oneTest.getWCPath(), "A").toString(), Revision.HEAD));
        this.appendText(oneTest, "A/mu", "xxx", 4);
        this.appendText(oneTest, "A/D/G/rho", "yyy", 4);
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 4L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        String string = oneTest.getWCPath() + "/branches/A";
        String string2 = oneTest.getUrl() + "/A";
        ArrayList<RevisionRange> arrayList = new ArrayList<RevisionRange>(1);
        arrayList.add(new RevisionRange(new Revision.Number(2L), new Revision.Number(4L)));
        this.client.merge(string2, Revision.HEAD, arrayList, string, true, Depth.infinity, false, false, true);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "branches/A", NodeKind.dir, 8);
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 5L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        String string3 = new File(oneTest.getWCPath(), "branches/A").getPath();
        String string4 = oneTest.getUrl() + "/A";
        this.acquireMergeinfoAndAssertEquals(2L, 4L, 0L, 0L, string3, string4);
    }

    private SVNTests.OneTest setupAndPerformMerge() throws Exception {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        Set<String> set = this.client.suggestMergeSources(oneTest.getWCPath(), Revision.WORKING);
        BasicTests.assertNotNull(set);
        BasicTests.assertEquals((int)0, (int)set.size());
        this.addExpectedCommitItem(null, oneTest.getUrl().toString(), "branches", NodeKind.none, 1);
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(oneTest.getUrl() + "/branches");
        this.client.mkdir(hashSet, false, null, new ConstMsg("log_msg"), null);
        this.addExpectedCommitItem(null, oneTest.getUrl().toString(), "branches/A", NodeKind.none, 1);
        ArrayList<CopySource> arrayList = new ArrayList<CopySource>(1);
        arrayList.add(new CopySource(oneTest.getUrl() + "/A", Revision.HEAD, Revision.HEAD));
        this.client.copy(arrayList, oneTest.getUrl() + "/branches/A", true, false, false, false, false, null, null, new ConstMsg("create A branch"), null);
        this.update(oneTest);
        return oneTest;
    }

    public void testPatch() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest(true);
        File file = new File(this.localTmp, oneTest.testName);
        String string = System.getProperty("line.separator");
        String string2 = "Index: iota" + string + "===================================================================" + string + "--- iota\t(revision 1)" + string + "+++ iota\t(working copy)" + string + "@@ -1 +1,2 @@" + string + " This is the file 'iota'." + string + "+No, this is *really* the file 'iota'." + string;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.print(string2);
        printWriter.flush();
        printWriter.close();
        this.client.patch(file.getAbsolutePath(), oneTest.getWCPath().replace('\\', '/'), false, 0, false, true, true, new PatchCallback(){

            @Override
            public boolean singlePatch(String string, String string2, String string3) {
                return false;
            }
        });
    }

    public void testDiff() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest(true);
        File file = new File(this.localTmp, oneTest.testName);
        String string = System.getProperty("line.separator");
        String string2 = "===================================================================" + string;
        String string3 = "___________________________________________________________________" + string;
        String string4 = "@@ -1 +1 @@" + string + "-This is the file 'iota'." + string + "\\ No newline at end of file" + string + "+This is the file 'mu'." + string + "\\ No newline at end of file" + string;
        String string5 = oneTest.getWCPath().replace('\\', '/') + "/iota";
        String string6 = this.fileToSVNPath(new File(oneTest.getWCPath()), false);
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(string5));
        printWriter.print("This is the file 'mu'.");
        printWriter.flush();
        printWriter.close();
        String string7 = "Index: iota" + string + string2 + "--- iota\t(.../iota)\t(revision 1)" + string + "+++ iota\t(.../A/mu)\t(revision 1)" + string + string4;
        this.client.diff(oneTest.getUrl() + "/iota", Revision.HEAD, oneTest.getUrl() + "/A/mu", Revision.HEAD, null, file.getPath(), Depth.files, null, true, true, false, false);
        this.assertFileContentsEquals("Unexpected diff output in file '" + file.getPath() + '\'', string7, file);
        try {
            this.client.diff(oneTest.getUrl().toString() + "/iota", Revision.HEAD, oneTest.getUrl().toString() + "/A/mu", Revision.HEAD, oneTest.getUrl().toString(), file.getPath(), Depth.infinity, null, true, true, false, false);
            BasicTests.fail((String)"This test should fail because the relativeToDir parameter does not work with URLs");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.client.diff(string5, Revision.BASE, string5, Revision.WORKING, "/non/existent/path", file.getPath(), Depth.infinity, null, true, true, false, false);
            BasicTests.fail((String)"This test should fail because iotaPath is not a child of the relativeToDir parameter");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string8 = this.fileToSVNPath(new File(oneTest.getWCPath() + "/A"), false);
        string7 = "Index: A" + string + string2 + "--- A\t(revision 1)" + string + "+++ A\t(working copy)" + string + string + "Property changes on: A" + string + string3 + "Added: testprop" + string + "## -0,0 +1 ##" + string + "+Test property value." + string;
        this.setprop(string8, "testprop", "Test property value." + string);
        this.client.diff(string8, Revision.BASE, string8, Revision.WORKING, string6, file.getPath(), Depth.infinity, null, true, true, false, false);
        this.assertFileContentsEquals("Unexpected diff output in file '" + file.getPath() + '\'', string7, file);
        string7 = "Index: ." + string + string2 + "--- .\t(revision 1)" + string + "+++ .\t(working copy)" + string + string + "Property changes on: ." + string + string3 + "Added: testprop" + string + "## -0,0 +1 ##" + string + "+Test property value." + string;
        this.setprop(string8, "testprop", "Test property value." + string);
        this.client.diff(string8, Revision.BASE, string8, Revision.WORKING, string8, file.getPath(), Depth.infinity, null, true, true, false, false);
        this.assertFileContentsEquals("Unexpected diff output in file '" + file.getPath() + '\'', string7, file);
        for (int i = 1; i < 3; ++i) {
            String string9 = "While processing operativeRevison=" + i + ". ";
            String string10 = string9 + "Unexpected diff output in file '";
            this.client.revert(string6, Depth.infinity, null);
            if (i == 2) {
                this.setprop(string5, "svn:eol-style", "native");
                HashSet<String> hashSet = new HashSet<String>(1);
                hashSet.add(string5);
                this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "iota", NodeKind.file, 8);
                this.client.commit(hashSet, Depth.empty, false, false, null, null, new ConstMsg("Set svn:eol-style to native"), null);
            }
            printWriter = new PrintWriter(new FileOutputStream(string5));
            printWriter.print("This is the file 'mu'.");
            printWriter.flush();
            printWriter.close();
            string7 = "Index: " + string5 + string + string2 + "--- " + string5 + "\t(revision " + i + ")" + string + "+++ " + string5 + "\t(working copy)" + string + string4;
            try {
                this.client.diff(string5, Revision.BASE, string5, Revision.WORKING, null, file.getPath(), Depth.files, null, true, true, false, false);
                this.assertFileContentsEquals(string10 + file.getPath() + '\'', string7, file);
                file.delete();
            }
            catch (ClientException clientException) {
                BasicTests.fail((String)(string9 + clientException.getMessage()));
            }
            try {
                this.client.diff(oneTest.getUrl() + "/iota", Revision.HEAD, new Revision.Number(i), Revision.HEAD, null, file.getPath(), Depth.files, null, true, true, false, false);
                this.assertFileContentsEquals(string10 + file.getPath() + '\'', "", file);
                file.delete();
            }
            catch (ClientException clientException) {
                BasicTests.fail((String)(string9 + clientException.getMessage()));
            }
            string7 = "Index: iota" + string + string2 + "--- iota\t(revision " + i + ")" + string + "+++ iota\t(working copy)" + string + string4;
            try {
                this.client.diff(string5, Revision.BASE, string5, Revision.WORKING, string6, file.getPath(), Depth.infinity, null, true, true, false, false);
                this.assertFileContentsEquals(string10 + file.getPath() + '\'', string7, file);
                file.delete();
            }
            catch (ClientException clientException) {
                BasicTests.fail((String)(string9 + clientException.getMessage()));
            }
            try {
                this.client.diff(string5, Revision.BASE, string5, Revision.WORKING, string6 + "/", file.getPath(), Depth.infinity, null, true, true, false, false);
                this.assertFileContentsEquals(string10 + file.getPath() + '\'', string7, file);
                file.delete();
                continue;
            }
            catch (ClientException clientException) {
                BasicTests.fail((String)(string9 + clientException.getMessage()));
            }
        }
    }

    public void testDiffOptions() throws SubversionException, IOException {
        String string;
        SVNTests.OneTest oneTest = new SVNTests.OneTest(true);
        File file = new File(this.localTmp, oneTest.testName);
        String string2 = System.getProperty("line.separator");
        String string3 = "===================================================================" + string2;
        String string4 = "___________________________________________________________________" + string2;
        String string5 = oneTest.getWCPath().replace('\\', '/') + "/iota";
        String string6 = this.fileToSVNPath(new File(oneTest.getWCPath()), false);
        String string7 = "Index: iota" + string2 + string3 + "--- iota\t(revision 1)" + string2 + "+++ iota\t(working copy)" + string2;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(string5));
        printWriter.print("This is  the  file 'iota'.");
        printWriter.flush();
        printWriter.close();
        try {
            string = string7 + "@@ -1 +1 @@" + string2 + "-This is the file 'iota'." + string2 + "\\ No newline at end of file" + string2 + "+This is  the  file 'iota'." + string2 + "\\ No newline at end of file" + string2;
            this.client.diff(string5, Revision.BASE, string5, Revision.WORKING, string6, (OutputStream)new FileOutputStream(file.getPath()), Depth.infinity, null, false, false, false, false, false, false, null);
            this.assertFileContentsEquals("Unexpected diff output with no options in file '" + file.getPath() + '\'', string, file);
            file.delete();
        }
        catch (ClientException clientException) {
            BasicTests.fail((String)clientException.getMessage());
        }
        try {
            this.client.diff(string5, Revision.BASE, string5, Revision.WORKING, string6, (OutputStream)new FileOutputStream(file.getPath()), Depth.infinity, null, false, false, false, false, false, false, new DiffOptions(DiffOptions.Flag.IgnoreWhitespace));
            this.assertFileContentsEquals("Unexpected diff output with Flag.IgnoreWhitespace in file '" + file.getPath() + '\'', "", file);
            file.delete();
        }
        catch (ClientException clientException) {
            BasicTests.fail((String)("Using Flag.IgnoreWhitespace: " + clientException.getMessage()));
        }
        try {
            this.client.diff(string5, Revision.BASE, string5, Revision.WORKING, string6, file.getPath(), Depth.infinity, null, false, false, false, false, false, false, new DiffOptions(DiffOptions.Flag.IgnoreSpaceChange));
            this.assertFileContentsEquals("Unexpected diff output with Flag.IgnoreSpaceChange in file '" + file.getPath() + '\'', "", file);
            file.delete();
        }
        catch (ClientException clientException) {
            BasicTests.fail((String)("Using Flag.IgnoreSpaceChange: " + clientException.getMessage()));
        }
        printWriter = new PrintWriter(new FileOutputStream(string5));
        printWriter.print("This is  the  file 'io ta'.");
        printWriter.flush();
        printWriter.close();
        try {
            string = string7 + "@@ -1 +1 @@" + string2 + "-This is the file 'iota'." + string2 + "\\ No newline at end of file" + string2 + "+This is  the  file 'io ta'." + string2 + "\\ No newline at end of file" + string2;
            this.client.diff(string5, Revision.BASE, string5, Revision.WORKING, string6, file.getPath(), Depth.infinity, null, false, false, false, false, false, false, new DiffOptions(DiffOptions.Flag.IgnoreSpaceChange));
            this.assertFileContentsEquals("Unexpected diff output with Flag.IgnoreSpaceChange in file '" + file.getPath() + '\'', string, file);
            file.delete();
        }
        catch (ClientException clientException) {
            BasicTests.fail((String)("Using Flag.IgnoreSpaceChange: " + clientException.getMessage()));
        }
    }

    private void assertFileContentsEquals(String string, String string2, File file) throws IOException {
        int n;
        FileReader fileReader = new FileReader(file);
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = fileReader.read()) != -1) {
            stringBuffer.append((char)n);
        }
        BasicTests.assertEquals((String)string, (String)string2, (String)stringBuffer.toString());
    }

    public void testDiffSummarize() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest(false);
        DiffSummaries diffSummaries = new DiffSummaries();
        this.client.diffSummarize(oneTest.getUrl().toString(), (Revision)new Revision.Number(0L), oneTest.getUrl().toString(), Revision.HEAD, Depth.infinity, null, false, (DiffSummaryCallback)diffSummaries);
        this.assertExpectedDiffSummaries(diffSummaries);
        diffSummaries.clear();
        this.client.diffSummarize(oneTest.getUrl().toString(), Revision.HEAD, new Revision.Number(0L), Revision.HEAD, Depth.infinity, null, false, (DiffSummaryCallback)diffSummaries);
        this.assertExpectedDiffSummaries(diffSummaries);
    }

    private void assertExpectedDiffSummaries(DiffSummaries diffSummaries) {
        BasicTests.assertEquals((String)"Wrong number of diff summary descriptors", (int)20, (int)diffSummaries.size());
        DiffSummary diffSummary = (DiffSummary)diffSummaries.get("A/B/E/beta");
        BasicTests.assertNotNull((String)"No diff summary for A/B/E/beta", (Object)diffSummary);
        BasicTests.assertEquals((String)"Incorrect path for A/B/E/beta", (String)"A/B/E/beta", (String)diffSummary.getPath());
        BasicTests.assertTrue((String)"Incorrect diff kind for A/B/E/beta", (diffSummary.getDiffKind() == DiffSummary.DiffKind.added ? 1 : 0) != 0);
        BasicTests.assertEquals((String)"Incorrect props changed notice for A/B/E/beta", (boolean)false, (boolean)diffSummary.propsChanged());
        BasicTests.assertEquals((String)"Incorrect node kind for A/B/E/beta", (Object)((Object)NodeKind.file), (Object)((Object)diffSummary.getNodeKind()));
    }

    public void testBasicIsAdminDirectory() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        ClientNotifyCallback clientNotifyCallback = new ClientNotifyCallback(){

            @Override
            public void onNotify(ClientNotifyInformation clientNotifyInformation) {
                BasicTests.this.client.isAdminDirectory(".svn");
            }
        };
        this.client.notification2(clientNotifyCallback);
        BasicTests.assertEquals((String)"wrong revision number from update", (long)this.update(oneTest), (long)1L);
    }

    public void testBasicCancelOperation() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        ClientNotifyCallback clientNotifyCallback = new ClientNotifyCallback(){

            @Override
            public void onNotify(ClientNotifyInformation clientNotifyInformation) {
                try {
                    BasicTests.this.client.cancelOperation();
                }
                catch (ClientException clientException) {
                    TestCase.fail((String)clientException.getMessage());
                }
            }
        };
        this.client.notification2(clientNotifyCallback);
        try {
            this.update(oneTest);
            BasicTests.fail((String)"missing exception for canceled operation");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    public void testDataTransferProgressReport() throws Throwable {
        if (SVNTests.rootUrl.startsWith("file://")) {
            return;
        }
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        CountingProgressListener countingProgressListener = new CountingProgressListener();
        this.client.setProgressCallback(countingProgressListener);
        this.update(oneTest);
        if (!countingProgressListener.gotProgress) {
            BasicTests.fail((String)"No progress reported");
        }
    }

    public void testTreeConflict() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        WC wC = oneTest.getWc();
        SVNTests.OneTest oneTest2 = oneTest.copy(".tree-conflict");
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add("alpha");
        HashSet<String> hashSet2 = new HashSet<String>(1);
        for (String object2 : hashSet) {
            hashSet2.add(new File(oneTest.getWorkingCopy(), "A/B/E/" + object2).getPath());
            wC.addItem("A/B/F/" + object2, wC.getItemContent("A/B/E/" + object2));
            wC.setItemWorkingCopyRevision("A/B/F/" + object2, 2L);
            this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/B/F/" + object2, NodeKind.file, 17);
            wC.removeItem("A/B/E/" + object2);
            this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/B/E/" + object2, NodeKind.file, 2);
        }
        this.client.move(hashSet2, new File(oneTest.getWorkingCopy(), "A/B/F").getPath(), false, true, false, false, false, null, null, null);
        this.checkCommitRevision(oneTest, "Unexpected WC revision number after commit", 2L, oneTest.getWCPathSet(), "Move files", Depth.infinity, false, false, null, null);
        oneTest.checkStatus();
        File file = new File(oneTest2.getWorkingCopy(), "A/B/E/alpha");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("appended alpha text");
        printWriter.close();
        BasicTests.assertEquals((String)"wrong revision number from update", (long)this.update(oneTest2), (long)2L);
        oneTest2.getWc().addItem("A/B/F/alpha", oneTest2.getWc().getItemContent("A/B/E/alpha"));
        oneTest2.getWc().setItemWorkingCopyRevision("A/B/F/alpha", 2L);
        oneTest2.getWc().setItemTextStatus("A/B/E/alpha", Status.Kind.added);
        oneTest2.getWc().setItemTextStatus("A/B/F/alpha", Status.Kind.normal);
        oneTest2.checkStatus();
        MyInfoCallback myInfoCallback = new MyInfoCallback();
        this.client.info2(oneTest2.getWCPath() + "/A/B/E/alpha", null, null, Depth.unknown, null, myInfoCallback);
        Set<ConflictDescriptor> set = myInfoCallback.getInfo().getConflicts();
        BasicTests.assertNotNull((String)"Conflict should not be null", set);
        ConflictDescriptor conflictDescriptor = set.iterator().next();
        BasicTests.assertNotNull((String)"Conflict should not be null", (Object)conflictDescriptor);
        BasicTests.assertNotNull((String)"Repository UUID must be set", (Object)conflictDescriptor.getSrcLeftVersion().getReposUUID());
        BasicTests.assertEquals((Object)((Object)conflictDescriptor.getSrcLeftVersion().getNodeKind()), (Object)((Object)NodeKind.file));
        BasicTests.assertEquals((String)(conflictDescriptor.getSrcLeftVersion().getReposURL() + "/" + conflictDescriptor.getSrcLeftVersion().getPathInRepos()), (String)(oneTest2.getUrl() + "/A/B/E/alpha"));
        BasicTests.assertEquals((long)conflictDescriptor.getSrcLeftVersion().getPegRevision(), (long)1L);
        if (conflictDescriptor.getSrcRightVersion() != null) {
            BasicTests.assertEquals((String)conflictDescriptor.getSrcLeftVersion().getReposUUID(), (String)conflictDescriptor.getSrcRightVersion().getReposUUID());
            BasicTests.assertEquals((Object)((Object)conflictDescriptor.getSrcRightVersion().getNodeKind()), (Object)((Object)NodeKind.none));
            BasicTests.assertEquals((String)conflictDescriptor.getSrcRightVersion().getReposURL(), (String)oneTest2.getUrl().toString());
            BasicTests.assertEquals((long)conflictDescriptor.getSrcRightVersion().getPegRevision(), (long)2L);
        }
    }

    public void testPropEdit() throws Throwable {
        byte[] byArray = new String("def").getBytes();
        byte[] byArray2 = new String("newvalue").getBytes();
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.clear();
        hashSet.add(oneTest.getWCPath() + "/A/D/G/rho");
        this.client.propertySetLocal(hashSet, "abc", byArray, Depth.infinity, null, false);
        oneTest.getWc().setItemPropStatus("A/D/G/rho", Status.Kind.modified);
        oneTest.checkStatus();
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 2L, oneTest.getWCPathSet(), "log msg", Depth.infinity, false, false, null, null);
        oneTest.getWc().setItemPropStatus("A/D/G/rho", Status.Kind.normal);
        oneTest.checkStatus();
        long l = 2L;
        this.client.propertySetRemote(oneTest.getUrl() + "/A/D/G/rho", l, "abc", byArray2, new ConstMsg("edit prop"), false, null, null);
        this.client.update(oneTest.getWCPathSet(), Revision.HEAD, Depth.infinity, false, false, false, false);
        byte[] byArray3 = this.client.propertyGet(oneTest.getWCPath() + "/A/D/G/rho", "abc", null, null);
        BasicTests.assertEquals((String)new String(byArray3), (String)new String(byArray2));
    }

    public void testBasicBlame() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        byte[] byArray = this.collectBlameLines(oneTest.getWCPath() + "/iota", Revision.getInstance(1L), Revision.getInstance(1L), Revision.getInstance(1L), false, false);
        BasicTests.assertEquals((String)"     1    jrandom This is the file 'iota'.\n", (String)new String(byArray));
        BlameCallbackImpl blameCallbackImpl = new BlameCallbackImpl();
        this.client.blame(oneTest.getWCPath() + "/iota", Revision.getInstance(1L), Revision.getInstance(1L), Revision.getInstance(1L), false, false, blameCallbackImpl);
        BasicTests.assertEquals((int)1, (int)blameCallbackImpl.numberOfLines());
        BlameCallbackImpl.BlameLine blameLine = blameCallbackImpl.getBlameLine(0);
        BasicTests.assertNotNull((Object)blameLine);
        BasicTests.assertEquals((long)1L, (long)blameLine.getRevision());
        BasicTests.assertEquals((String)"jrandom", (String)blameLine.getAuthor());
        BasicTests.assertEquals((String)"This is the file 'iota'.", (String)blameLine.getLine());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBlameWithDiffOptions() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWorkingCopy(), "iota");
        FileOutputStream fileOutputStream = new FileOutputStream(file, false);
        fileOutputStream.write("This   is   the   file   'iota'.\t".getBytes());
        fileOutputStream.close();
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(oneTest.getWCPath());
        try {
            this.client.username("rayjandom");
            this.client.commit(hashSet, Depth.infinity, false, false, null, null, new ConstMsg("Whitespace-only change in /iota"), null);
        }
        finally {
            this.client.username("jrandom");
        }
        BlameCallbackImpl blameCallbackImpl = new BlameCallbackImpl();
        this.client.blame(oneTest.getWCPath() + "/iota", Revision.HEAD, Revision.getInstance(1L), Revision.HEAD, false, false, blameCallbackImpl, new DiffOptions(DiffOptions.Flag.IgnoreWhitespace));
        BasicTests.assertEquals((int)1, (int)blameCallbackImpl.numberOfLines());
        BlameCallbackImpl.BlameLine blameLine = blameCallbackImpl.getBlameLine(0);
        BasicTests.assertNotNull((Object)blameLine);
        BasicTests.assertEquals((long)1L, (long)blameLine.getRevision());
        BasicTests.assertEquals((String)"jrandom", (String)blameLine.getAuthor());
        BasicTests.assertEquals((String)"This   is   the   file   'iota'.\t", (String)blameLine.getLine());
    }

    public void testCommitRevprops() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWorkingCopy(), "A/mu");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("appended mu text");
        printWriter.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/mu", 2L);
        oneTest.getWc().setItemContent("A/mu", oneTest.getWc().getItemContent("A/mu") + "appended mu text");
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl().toString(), "A/mu", NodeKind.file, 4);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("kfogel", "rockstar");
        hashMap.put("cmpilato", "theman");
        this.checkCommitRevision(oneTest, "wrong revision number from commit", 2L, oneTest.getWCPathSet(), "log msg", Depth.infinity, true, true, null, hashMap);
        oneTest.checkStatus();
        final ArrayList arrayList = new ArrayList();
        HashSet<String> hashSet = new HashSet<String>(2);
        hashSet.add("kfogel");
        hashSet.add("cmpilato");
        this.client.logMessages(oneTest.getWCPath(), Revision.getInstance(2L), this.toRevisionRange(Revision.getInstance(2L), Revision.getInstance(2L)), false, false, false, hashSet, 0L, new LogMessageCallback(){

            @Override
            public void singleMessage(Set<ChangePath> set, long l, Map<String, byte[]> map, boolean bl) {
                arrayList.add(map);
            }
        });
        Map map = (Map)arrayList.get(0);
        BasicTests.assertEquals((String)"wrong number of fetched revprops", (int)hashMap.size(), (int)map.size());
        Set set = map.keySet();
        for (String string : set) {
            BasicTests.assertEquals((String)"revprops check", (String)((String)hashMap.get(string)), (String)new String((byte[])map.get(string)));
        }
    }

    public void testDispose() throws Throwable {
        SVNClient sVNClient = new SVNClient();
        sVNClient.dispose();
    }

    public void testRevisionRangeListRemove() throws Throwable {
        RevisionRangeList revisionRangeList = new RevisionRangeList(new ArrayList<RevisionRange>());
        revisionRangeList.getRanges().add(new RevisionRange(Revision.getInstance(1L), Revision.getInstance(5L), true));
        revisionRangeList.getRanges().add(new RevisionRange(Revision.getInstance(7L), Revision.getInstance(9L), false));
        RevisionRangeList revisionRangeList2 = new RevisionRangeList(new ArrayList<RevisionRange>());
        revisionRangeList2.getRanges().add(new RevisionRange(Revision.getInstance(7L), Revision.getInstance(9L), true));
        List<RevisionRange> list = revisionRangeList.remove(revisionRangeList2, true).getRanges();
        BasicTests.assertEquals((int)2, (int)revisionRangeList.getRanges().size());
        BasicTests.assertEquals((int)1, (int)revisionRangeList2.getRanges().size());
        BasicTests.assertEquals((int)2, (int)list.size());
        list = revisionRangeList.remove(revisionRangeList2.getRanges(), false);
        BasicTests.assertEquals((int)2, (int)revisionRangeList.getRanges().size());
        BasicTests.assertEquals((int)1, (int)revisionRangeList2.getRanges().size());
        BasicTests.assertEquals((int)1, (int)list.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTunnelAgent() throws Throwable {
        byte[] byArray;
        SVNClient sVNClient = new SVNClient();
        try {
            sVNClient.notification2(new SVNTests.MyNotifier());
            if (SVNTests.DefaultAuthn.useDeprecated()) {
                sVNClient.setPrompt(SVNTests.DefaultAuthn.getDeprecated());
            } else {
                sVNClient.setPrompt(SVNTests.DefaultAuthn.getDefault());
            }
            sVNClient.username("jrandom");
            sVNClient.setProgressCallback(new SVNTests.DefaultProgressListener());
            sVNClient.setConfigDirectory(this.conf.getAbsolutePath());
            sVNClient.setTunnelAgent(new Tunnel());
            byArray = sVNClient.revProperty("svn+test://localhost/foo", "svn:log", Revision.getInstance(0L));
        }
        finally {
            sVNClient.dispose();
        }
        BasicTests.assertEquals((String)"fake", (String)new String(byArray));
    }

    private String fileToSVNPath(File file, boolean bl) {
        if (bl) {
            try {
                return file.getCanonicalPath().replace('\\', '/');
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return file.getPath().replace('\\', '/');
    }

    private List<RevisionRange> toRevisionRange(Revision revision, Revision revision2) {
        ArrayList<RevisionRange> arrayList = new ArrayList<RevisionRange>(1);
        arrayList.add(new RevisionRange(revision, revision2));
        return arrayList;
    }

    private void checkCommitRevision(SVNTests.OneTest oneTest, String string, long l, Set<String> set, String string2, Depth depth, boolean bl, boolean bl2, Collection<String> collection, Map<String, String> map) throws ClientException {
        MyCommitCallback myCommitCallback = new MyCommitCallback();
        this.client.commit(set, depth, bl, bl2, collection, map, new ConstMsg(string2), myCommitCallback);
        BasicTests.assertEquals((String)string, (long)myCommitCallback.getRevision(), (long)l);
    }

    private Map<String, byte[]> collectProperties(String string, Revision revision, Revision revision2, Depth depth, Collection<String> collection) throws ClientException {
        final HashMap hashMap = new HashMap();
        this.client.properties(string, revision, revision, depth, collection, new ProplistCallback(){

            @Override
            public void singlePath(String string, Map<String, byte[]> map) {
                hashMap.put(string, map);
            }
        });
        return (Map)hashMap.get(string);
    }

    private DirEntry[] collectDirEntries(String string, Revision revision, Revision revision2, Depth depth, int n, boolean bl) throws ClientException {
        class MyListCallback
        implements ListCallback {
            private List<DirEntry> dirents = new ArrayList<DirEntry>();

            MyListCallback() {
            }

            @Override
            public void doEntry(DirEntry dirEntry, Lock lock) {
                if (dirEntry.getPath().length() == 0) {
                    if (dirEntry.getNodeKind() == NodeKind.file) {
                        String string = dirEntry.getAbsPath();
                        int n = string.lastIndexOf(47);
                        String string2 = string.substring(n, string.length());
                        dirEntry.setPath(string2);
                    } else {
                        return;
                    }
                }
                this.dirents.add(dirEntry);
            }

            public DirEntry[] getDirEntryArray() {
                return this.dirents.toArray(new DirEntry[this.dirents.size()]);
            }
        }
        MyListCallback myListCallback = new MyListCallback();
        this.client.list(string, revision, revision2, depth, n, bl, myListCallback);
        return myListCallback.getDirEntryArray();
    }

    private Info[] collectInfos(String string, Revision revision, Revision revision2, Depth depth, Collection<String> collection) throws ClientException {
        final ArrayList arrayList = new ArrayList();
        this.client.info(string, revision, revision2, depth, true, true, false, collection, new InfoCallback(){

            @Override
            public void singleInfo(Info info) {
                arrayList.add(info);
            }
        });
        return arrayList.toArray(new Info[arrayList.size()]);
    }

    private LogMessage[] collectLogMessages(String string, Revision revision, List<RevisionRange> list, boolean bl, boolean bl2, boolean bl3, long l) throws ClientException {
        class MyLogMessageCallback
        implements LogMessageCallback {
            private List<LogMessage> messages = new ArrayList<LogMessage>();

            MyLogMessageCallback() {
            }

            @Override
            public void singleMessage(Set<ChangePath> set, long l, Map<String, byte[]> map, boolean bl) {
                long l2;
                Object object;
                String string;
                String string2;
                try {
                    string2 = new String(map.get("svn:author"), "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string2 = new String(map.get("svn:author"));
                }
                try {
                    string = new String(map.get("svn:log"), "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string = new String(map.get("svn:log"));
                }
                try {
                    object = new LogDate(new String(map.get("svn:date")));
                    l2 = ((LogDate)object).getTimeMicros();
                }
                catch (ParseException parseException) {
                    l2 = 0L;
                }
                object = new LogMessage(set, l, string2, l2, string);
                if (l != -1L) {
                    this.messages.add((LogMessage)object);
                }
            }

            public LogMessage[] getMessages() {
                return this.messages.toArray(new LogMessage[this.messages.size()]);
            }
        }
        MyLogMessageCallback myLogMessageCallback = new MyLogMessageCallback();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("svn:log");
        hashSet.add("svn:date");
        hashSet.add("svn:author");
        this.client.logMessages(string, revision, list, bl, bl2, bl3, hashSet, l, myLogMessageCallback);
        return myLogMessageCallback.getMessages();
    }

    private byte[] collectBlameLines(String string, Revision revision, Revision revision2, Revision revision3, boolean bl, boolean bl2) throws ClientException {
        BlameCallbackImpl blameCallbackImpl = new BlameCallbackImpl();
        this.client.blame(string, revision, revision2, revision3, bl, bl2, blameCallbackImpl);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < blameCallbackImpl.numberOfLines(); ++i) {
            BlameCallbackImpl.BlameLine blameLine = blameCallbackImpl.getBlameLine(i);
            if (blameLine == null) continue;
            stringBuffer.append(blameLine.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString().getBytes();
    }

    private long update(SVNTests.OneTest oneTest) throws ClientException {
        return this.client.update(oneTest.getWCPathSet(), null, Depth.unknown, false, false, false, false)[0];
    }

    private long update(SVNTests.OneTest oneTest, String string) throws ClientException {
        return this.client.update(oneTest.getWCPathSet(string), null, Depth.unknown, false, false, false, false)[0];
    }

    private void setprop(String string, String string2, String string3) throws ClientException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        this.client.propertySetLocal(hashSet, string2, string3 != null ? string3.getBytes() : null, Depth.empty, null, false);
    }

    private void setprop(String string, String string2, byte[] byArray) throws ClientException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        this.client.propertySetLocal(hashSet, string2, byArray, Depth.empty, null, false);
    }

    private long commit(SVNTests.OneTest oneTest, String string) throws ClientException {
        MyCommitCallback myCommitCallback = new MyCommitCallback();
        this.client.commit(oneTest.getWCPathSet(), Depth.infinity, false, false, null, null, new ConstMsg(string), myCommitCallback);
        return myCommitCallback.getRevision();
    }

    protected class BlameCallbackImpl
    implements BlameCallback {
        private List<BlameLine> lines = new ArrayList<BlameLine>();

        protected BlameCallbackImpl() {
        }

        public void singleLine(Date date, long l, String string, String string2) {
            this.addBlameLine(new BlameLine(l, string, date, string2));
        }

        public void singleLine(Date date, long l, String string, Date date2, long l2, String string2, String string3, String string4) {
            this.addBlameLine(new BlameLine(this.getRevision(l, l2), this.getAuthor(string, string2), this.getDate(date, date2), string4));
        }

        @Override
        public void singleLine(long l, long l2, Map<String, byte[]> map, long l3, Map<String, byte[]> map2, String string, String string2, boolean bl) throws ClientException {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            try {
                this.singleLine(simpleDateFormat.parse(new String(map.get("svn:date"))), l2, new String(map.get("svn:author")), map2 == null ? null : simpleDateFormat.parse(new String(map2.get("svn:date"))), l3, map2 == null ? null : new String(map2.get("svn:author")), string, string2);
            }
            catch (ParseException parseException) {
                throw ClientException.fromException(parseException);
            }
        }

        private Date getDate(Date date, Date date2) {
            return date2 == null ? date : date2;
        }

        private String getAuthor(String string, String string2) {
            return string2 == null ? string : string2;
        }

        private long getRevision(long l, long l2) {
            return l2 == -1L ? l : l2;
        }

        public int numberOfLines() {
            return this.lines.size();
        }

        public BlameLine getBlameLine(int n) {
            if (n >= this.lines.size()) {
                return null;
            }
            return this.lines.get(n);
        }

        protected void addBlameLine(BlameLine blameLine) {
            this.lines.add(blameLine);
        }

        public class BlameLine {
            private long revision;
            private String author;
            private Date changed;
            private String line;

            public BlameLine(long l, String string, Date date, String string2) {
                this.revision = l;
                this.author = string;
                this.changed = date;
                this.line = string2;
            }

            public String getAuthor() {
                return this.author;
            }

            public Date getChanged() {
                return this.changed;
            }

            public String getLine() {
                return this.line;
            }

            public long getRevision() {
                return this.revision;
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.revision > 0L) {
                    this.pad(stringBuffer, Long.toString(this.revision), 6);
                    stringBuffer.append(' ');
                } else {
                    stringBuffer.append("     - ");
                }
                if (this.author != null) {
                    this.pad(stringBuffer, this.author, 10);
                    stringBuffer.append(" ");
                } else {
                    stringBuffer.append("         - ");
                }
                stringBuffer.append(this.line);
                return stringBuffer.toString();
            }

            private void pad(StringBuffer stringBuffer, String string, int n) {
                int n2 = n - string.length();
                for (int i = 0; i < n2; ++i) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(string);
            }
        }
    }

    protected class LogMessage {
        private String message;
        private long timeMicros;
        private Date date;
        private long revision;
        private String author;
        private Set<ChangePath> changedPaths;

        LogMessage(Set<ChangePath> set, long l, String string, long l2, String string2) {
            this.changedPaths = set;
            this.revision = l;
            this.author = string;
            this.timeMicros = l2;
            this.date = null;
            this.message = string2;
        }

        public String getMessage() {
            return this.message;
        }

        public long getTimeMicros() {
            return this.timeMicros;
        }

        public long getTimeMillis() {
            return this.timeMicros / 1000L;
        }

        public Date getDate() {
            if (this.date == null) {
                this.date = new Date(this.timeMicros / 1000L);
            }
            return this.date;
        }

        public long getRevisionNumber() {
            return this.revision;
        }

        public String getAuthor() {
            return this.author;
        }

        public Set<ChangePath> getChangedPaths() {
            return this.changedPaths;
        }
    }

    private class ConstMsg
    implements CommitMessageCallback {
        private String message;

        ConstMsg(String string) {
            this.message = string;
        }

        @Override
        public String getLogMessage(Set<CommitItem> set) {
            return this.message;
        }
    }

    private class MyStatusCallback
    implements StatusCallback {
        private List<Status> statuses = new ArrayList<Status>();

        private MyStatusCallback() {
        }

        @Override
        public void doStatus(String string, Status status) {
            if (status != null) {
                this.statuses.add(status);
            }
        }

        public Status[] getStatusArray() {
            return this.statuses.toArray(new Status[this.statuses.size()]);
        }
    }

    private class MyCommitCallback
    implements CommitCallback {
        private CommitInfo info = null;

        private MyCommitCallback() {
        }

        @Override
        public void commitInfo(CommitInfo commitInfo) {
            this.info = commitInfo;
        }

        public long getRevision() {
            if (this.info != null) {
                return this.info.getRevision();
            }
            return -1L;
        }
    }

    private class MyInfoCallback
    implements InfoCallback {
        private Info info;

        private MyInfoCallback() {
        }

        @Override
        public void singleInfo(Info info) {
            this.info = info;
        }

        public Info getInfo() {
            return this.info;
        }
    }

    private class MyChangelistCallback
    extends HashMap<String, Collection<String>>
    implements ChangelistCallback {
        private static final long serialVersionUID = 1L;
        private HashSet<String> allChangelists = new HashSet();

        private MyChangelistCallback() {
        }

        @Override
        public void doChangelist(String string, String string2) {
            if (string2 != null) {
                this.allChangelists.add(string2);
            }
            if (super.containsKey(string = BasicTests.this.fileToSVNPath(new File(string), true))) {
                Collection collection = (Collection)super.get(string);
                collection.add(string2);
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string2);
                super.put(string, arrayList);
            }
        }

        public Collection<String> get(String string) {
            return (Collection)super.get(string);
        }

        public Collection<String> getChangelists() {
            return this.allChangelists;
        }
    }

    private static class DiffSummaries
    extends HashMap<String, DiffSummary>
    implements DiffSummaryCallback {
        private static final long serialVersionUID = 1L;

        private DiffSummaries() {
        }

        @Override
        public void onSummary(DiffSummary diffSummary) {
            super.put(diffSummary.getPath(), diffSummary);
        }
    }

    private class Tunnel
    extends Thread
    implements TunnelAgent,
    TunnelAgent.CloseTunnelCallback {
        private ReadableByteChannel request;
        private WritableByteChannel response;
        private final byte[][] commands = new byte[][]{"( success ( 2 2 ( ) ( edit-pipeline svndiff1 absent-entries commit-revprops depth log-revprops atomic-revprops partial-replay inherited-props ephemeral-txnprops file-revs-reverse ) ) ) ".getBytes(), "( success ( ( ANONYMOUS EXTERNAL ) 36:e3c8c113-03ba-4ec5-a8e6-8fc555e57b91 ) ) ".getBytes(), "( success ( ) ) ( success ( 36:e3c8c113-03ba-4ec5-a8e6-8fc555e57b91 24:svn+test://localhost/foo ( mergeinfo ) ) ) ".getBytes(), "( success ( ( ) 0: ) ) ( success ( ( 4:fake ) ) ) ".getBytes()};

        private Tunnel() {
        }

        @Override
        public boolean checkTunnel(String string) {
            return string.equals("test");
        }

        @Override
        public TunnelAgent.CloseTunnelCallback openTunnel(ReadableByteChannel readableByteChannel, WritableByteChannel writableByteChannel, String string, String string2, String string3, int n) {
            this.request = readableByteChannel;
            this.response = writableByteChannel;
            this.start();
            return this;
        }

        @Override
        public void closeTunnel() {
            Throwable throwable = null;
            try {
                this.request.close();
                this.join();
                this.response.close();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            TestCase.assertEquals((String)"No exception thrown", null, (Object)throwable);
        }

        @Override
        public void run() {
            int n = 0;
            byte[] byArray = new byte[1024];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            while (n < this.commands.length && this.request.isOpen()) {
                try {
                    byte[] byArray2 = this.commands[n++];
                    this.response.write(ByteBuffer.wrap(byArray2));
                }
                catch (IOException iOException) {
                    break;
                }
                try {
                    byteBuffer.clear();
                    this.request.read(byteBuffer);
                }
                catch (Throwable throwable) {}
            }
            try {
                this.response.close();
                this.request.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class CountingProgressListener
    implements ProgressCallback {
        public boolean gotProgress = false;

        private CountingProgressListener() {
        }

        @Override
        public void onProgress(ProgressEvent progressEvent) {
            this.gotProgress = true;
        }
    }
}

