/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.tigris.subversion.javahl.BlameCallbackImpl;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.ChangelistCallback;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.ConflictDescriptor;
import org.tigris.subversion.javahl.ConflictResolverCallback;
import org.tigris.subversion.javahl.ConflictResult;
import org.tigris.subversion.javahl.CopySource;
import org.tigris.subversion.javahl.DiffSummary;
import org.tigris.subversion.javahl.DiffSummaryReceiver;
import org.tigris.subversion.javahl.DirEntry;
import org.tigris.subversion.javahl.Info;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.InfoCallback;
import org.tigris.subversion.javahl.LogDate;
import org.tigris.subversion.javahl.LogMessage;
import org.tigris.subversion.javahl.LogMessageCallback;
import org.tigris.subversion.javahl.Mergeinfo;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.NotifyInformation;
import org.tigris.subversion.javahl.Path;
import org.tigris.subversion.javahl.ProgressEvent;
import org.tigris.subversion.javahl.ProgressListener;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.ProplistCallbackImpl;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.RevisionRange;
import org.tigris.subversion.javahl.SVNTests;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.javahl.SubversionException;
import org.tigris.subversion.javahl.Version;
import org.tigris.subversion.javahl.WC;

public class BasicTests
extends SVNTests {
    public static final String testName = "basic_test";

    public BasicTests() {
        this.init();
    }

    public BasicTests(String string) {
        super(string);
        this.init();
    }

    private void init() {
        if (!testName.equals(this.testBaseName)) {
            testCounter = 0;
            this.testBaseName = testName;
        }
    }

    public void testLogDate() throws Throwable {
        LogDate logDate;
        String string = "2007-10-04T03:00:52.134992Z";
        String string2 = "2008-01-14";
        try {
            logDate = new LogDate(string);
            BasicTests.assertEquals((long)1191466852134992L, (long)logDate.getTimeMicros());
        }
        catch (ParseException parseException) {
            BasicTests.fail((String)("Failed to parse date " + string));
        }
        try {
            logDate = new LogDate(string2);
            BasicTests.fail((String)("Failed to throw exception on bad date " + string2));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testVersion() throws Throwable {
        try {
            Version version = this.client.getVersion();
            String string = version.toString();
            if (string == null || string.trim().length() == 0) {
                throw new Exception("Version string empty");
            }
        }
        catch (Exception exception) {
            BasicTests.fail((String)("Version should always be available unless the native libraries failed to initialize: " + exception));
        }
    }

    public void testPathValidation() throws Throwable {
        BasicTests.assertFalse((String)"Path validation produced false-positive for null path", (boolean)Path.isValid(null));
        String string = "valid-path";
        BasicTests.assertTrue((String)("Validation check of valid path '" + string + "' should succeed"), (boolean)Path.isValid(string));
        string = "invalid-\u0001-path";
        BasicTests.assertFalse((String)("Validation check of invalid path '" + string + "' (which contains control characters) should fail"), (boolean)Path.isValid(string));
    }

    public void testPathIsURL() throws Throwable {
        int n;
        try {
            Path.isURL(null);
            BasicTests.fail((String)"A null path should raise an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String[] stringArray = new String[]{"/path", "c:\\path"};
        for (n = 0; n < stringArray.length; ++n) {
            BasicTests.assertFalse((String)("'" + stringArray[n] + "' should not be considered a URL"), (boolean)Path.isURL(stringArray[n]));
        }
        stringArray = new String[]{"http://example.com", "svn://example.com", "svn+ssh://example.com", "file:///src/svn/"};
        for (n = 0; n < stringArray.length; ++n) {
            BasicTests.assertTrue((String)("'" + stringArray[n] + "' should be considered a URL"), (boolean)Path.isURL(stringArray[n]));
        }
    }

    public void testMergeinfoParser() throws Throwable {
        String string = "/trunk:1-300,305,307,400-405\n/branches/branch:308-400";
        Mergeinfo mergeinfo = new Mergeinfo(string);
        String[] stringArray = mergeinfo.getPaths();
        BasicTests.assertEquals((int)2, (int)stringArray.length);
        RevisionRange[] revisionRangeArray = mergeinfo.getRevisionRange("/trunk");
        BasicTests.assertEquals((int)4, (int)revisionRangeArray.length);
        BasicTests.assertEquals((String)"1-300", (String)revisionRangeArray[0].toString());
        BasicTests.assertEquals((String)"305", (String)revisionRangeArray[1].toString());
        BasicTests.assertEquals((String)"307", (String)revisionRangeArray[2].toString());
        BasicTests.assertEquals((String)"400-405", (String)revisionRangeArray[3].toString());
        RevisionRange[] revisionRangeArray2 = mergeinfo.getRevisionRange("/branches/branch");
        BasicTests.assertEquals((int)1, (int)revisionRangeArray2.length);
    }

    public void testBasicStatus() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        oneTest.checkStatus();
        File file = new File(oneTest.getWorkingCopy() + "/A", "foo.c");
        Status status = this.client.singleStatus(this.fileToSVNPath(file, false), false);
        if (status != null && (status.hasTreeConflict() || status.getTextStatus() != 0 || status.getPropStatus() != 0 || status.getRepositoryTextStatus() != 0 || status.getRepositoryPropStatus() != 0)) {
            BasicTests.fail((String)"File foo.c should not return a status.");
        }
    }

    public void testOODStatus() throws SubversionException, IOException {
        long l;
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        long l2 = 2L;
        File file = new File(oneTest.getWorkingCopy(), "A/D/G/rho");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("modification to rho");
        printWriter.close();
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/D/G/rho", 1, 4);
        long l3 = this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().setItemWorkingCopyRevision("A/D/G/rho", l3);
        oneTest.getWc().setItemContent("A/D/G/rho", oneTest.getWc().getItemContent("A/D/G/rho") + "modification to rho");
        Status status = this.client.singleStatus(oneTest.getWCPath() + "/A/D/G/rho", false);
        long l4 = status.getLastChangedDate().getTime();
        long l5 = l3;
        String string = status.getLastCommitAuthor();
        this.client.remove(new String[]{oneTest.getWCPath() + "/A/D/G/pi"}, null, false);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/D/G/pi", 1, 2);
        l3 = this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().removeItem("A/D/G/pi");
        oneTest.getWc().setItemWorkingCopyRevision("A/D/G", l3);
        BasicTests.assertEquals((String)"wrong revision from update", (long)this.client.update(oneTest.getWCPath() + "/A/D/G", null, true), (long)l3);
        long l6 = l3;
        file = new File(oneTest.getWorkingCopy(), "A/D/G/tau");
        printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("modification to tau");
        printWriter.close();
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/D/G/tau", 1, 4);
        l3 = this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().setItemWorkingCopyRevision("A/D/G/tau", l3);
        oneTest.getWc().setItemContent("A/D/G/tau", oneTest.getWc().getItemContent("A/D/G/tau") + "modification to tau");
        status = this.client.singleStatus(oneTest.getWCPath() + "/A/D/G/tau", false);
        long l7 = status.getLastChangedDate().getTime();
        long l8 = l3;
        String string2 = status.getLastCommitAuthor();
        this.client.remove(new String[]{oneTest.getWCPath() + "/A/C"}, null, false);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/C", 2, 2);
        l3 = this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().removeItem("A/C");
        long l9 = l3;
        File file2 = new File(oneTest.getWorkingCopy(), "A/B/I");
        file2.mkdir();
        this.client.add(file2.getAbsolutePath(), true);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/B/I", 2, 1);
        l3 = this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().addItem("A/B/I", null);
        status = this.client.singleStatus(oneTest.getWCPath() + "/A/B/I", false);
        long l10 = status.getLastChangedDate().getTime();
        long l11 = l3;
        String string3 = status.getLastCommitAuthor();
        oneTest.getWc().setRevision(l3);
        BasicTests.assertEquals((String)"wrong revision from update", (long)this.client.update(oneTest.getWCPath(), null, true), (long)l3);
        oneTest.checkStatus();
        this.client.propertySet(oneTest.getWCPath(), "propname", "propval", false);
        oneTest.getWc().setItemPropStatus("", 2);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), null, 2, 8);
        l3 = this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().setItemWorkingCopyRevision("", l3);
        oneTest.getWc().setItemPropStatus("", 1);
        file = new File(oneTest.getWorkingCopy(), "A/D/H/nu");
        printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.print("This is the file 'nu'.");
        printWriter.close();
        this.client.add(file.getAbsolutePath(), false);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/D/H/nu", 1, 5);
        l3 = this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().addItem("A/D/H/nu", "This is the file 'nu'.");
        status = this.client.singleStatus(oneTest.getWCPath() + "/A/D/H/nu", false);
        long l12 = status.getLastChangedDate().getTime();
        long l13 = l3;
        String string4 = status.getLastCommitAuthor();
        this.client.propertySet(oneTest.getWCPath() + "/A/B/F", "propname", "propval", false);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/B/F", 2, 8);
        l3 = this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().setItemPropStatus("A/B/F", 1);
        oneTest.getWc().setItemWorkingCopyRevision("A/B/F", l3);
        status = this.client.singleStatus(oneTest.getWCPath() + "/A/B/F", false);
        long l14 = status.getLastChangedDate().getTime();
        long l15 = l3;
        String string5 = status.getLastCommitAuthor();
        this.client.remove(new String[]{oneTest.getWCPath() + "/A/D/H/chi"}, null, false);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/D/H/chi", 1, 2);
        l3 = this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().removeItem("A/D/G/pi");
        file = new File(oneTest.getWorkingCopy(), "A/D/H/chi");
        printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.print("This is the replacement file 'chi'.");
        printWriter.close();
        this.client.add(file.getAbsolutePath(), false);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/D/H/chi", 1, 5);
        l3 = this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().addItem("A/D/H/chi", "This is the replacement file 'chi'.");
        status = this.client.singleStatus(oneTest.getWCPath() + "/A/D/H/chi", false);
        long l16 = status.getLastChangedDate().getTime();
        long l17 = l3;
        String string6 = status.getLastCommitAuthor();
        this.client.remove(new String[]{oneTest.getWCPath() + "/A/B/E"}, null, false);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/B/E", 2, 2);
        l3 = this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().removeItem("A/B/E/alpha");
        oneTest.getWc().removeItem("A/B/E/beta");
        oneTest.getWc().removeItem("A/B/E");
        oneTest.getWc().setItemWorkingCopyRevision("A/B", l3);
        BasicTests.assertEquals((String)"wrong revision from update", (long)this.client.update(oneTest.getWCPath() + "/A/B", null, true), (long)l3);
        Info info = this.client.info(oneTest.getWCPath() + "/A/B");
        long l18 = info.getLastChangedDate().getTime();
        long l19 = l = l3;
        String string7 = info.getAuthor();
        this.client.remove(new String[]{oneTest.getWCPath() + "/A/D/H/psi"}, null, false);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/D/H/psi", 1, 2);
        l3 = this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        oneTest.getWc().removeItem("A/D/H/psi");
        oneTest.getWc().setRevision(l3);
        BasicTests.assertEquals((String)"wrong revision from update", (long)this.client.update(oneTest.getWCPath(), null, true), (long)l3);
        oneTest.getWc().addItem("A/D/H/psi", null);
        file2 = new File(oneTest.getWorkingCopy(), "A/D/H/psi");
        file2.mkdir();
        this.client.add(file2.getAbsolutePath(), true);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/D/H/psi", 2, 1);
        l3 = this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)l3, (long)l2++);
        status = this.client.singleStatus(oneTest.getWCPath() + "/A/D/H/psi", false);
        long l20 = status.getLastChangedDate().getTime();
        long l21 = l3;
        String string8 = status.getLastCommitAuthor();
        oneTest.checkStatus();
        BasicTests.assertEquals((String)"wrong revision from update", (long)this.client.update(oneTest.getWCPath(), Revision.getInstance(1L), true), (long)1L);
        oneTest.getWc().setRevision(1L);
        oneTest.getWc().setItemOODInfo("A", l21, string8, l20, 2);
        oneTest.getWc().setItemOODInfo("A/B", l, string7, l18, 2);
        oneTest.getWc().addItem("A/B/I", null);
        oneTest.getWc().setItemOODInfo("A/B/I", l11, string3, l10, 2);
        oneTest.getWc().setItemTextStatus("A/B/I", 0);
        oneTest.getWc().setItemNodeKind("A/B/I", 3);
        oneTest.getWc().addItem("A/C", null);
        oneTest.getWc().setItemReposLastCmtRevision("A/C", l9);
        oneTest.getWc().setItemReposKind("A/C", 2);
        oneTest.getWc().addItem("A/B/E", null);
        oneTest.getWc().setItemReposLastCmtRevision("A/B/E", l19);
        oneTest.getWc().setItemReposKind("A/B/E", 2);
        oneTest.getWc().addItem("A/B/E/alpha", "This is the file 'alpha'.");
        oneTest.getWc().addItem("A/B/E/beta", "This is the file 'beta'.");
        oneTest.getWc().setItemPropStatus("A/B/F", 0);
        oneTest.getWc().setItemOODInfo("A/B/F", l15, string5, l14, 2);
        oneTest.getWc().setItemOODInfo("A/D", l21, string8, l20, 2);
        oneTest.getWc().setItemOODInfo("A/D/G", l8, string2, l7, 2);
        oneTest.getWc().addItem("A/D/G/pi", "This is the file 'pi'.");
        oneTest.getWc().setItemReposLastCmtRevision("A/D/G/pi", l6);
        oneTest.getWc().setItemReposKind("A/D/G/pi", 1);
        oneTest.getWc().setItemContent("A/D/G/rho", "This is the file 'rho'.");
        oneTest.getWc().setItemOODInfo("A/D/G/rho", l5, string, l4, 1);
        oneTest.getWc().setItemContent("A/D/G/tau", "This is the file 'tau'.");
        oneTest.getWc().setItemOODInfo("A/D/G/tau", l8, string2, l7, 1);
        oneTest.getWc().setItemOODInfo("A/D/H", l21, string8, l20, 2);
        oneTest.getWc().setItemWorkingCopyRevision("A/D/H/nu", -1L);
        oneTest.getWc().setItemTextStatus("A/D/H/nu", 0);
        oneTest.getWc().setItemNodeKind("A/D/H/nu", 3);
        oneTest.getWc().setItemOODInfo("A/D/H/nu", l13, string4, l12, 1);
        oneTest.getWc().setItemContent("A/D/H/chi", "This is the file 'chi'.");
        oneTest.getWc().setItemOODInfo("A/D/H/chi", l17, string6, l16, 1);
        oneTest.getWc().removeItem("A/D/H/psi");
        oneTest.getWc().addItem("A/D/H/psi", "This is the file 'psi'.");
        oneTest.getWc().setItemOODInfo("A/D/H/psi", l21, string8, l20, 2);
        oneTest.getWc().setItemPropStatus("", 0);
        oneTest.getWc().setItemOODInfo("", l21, string8, l20, 2);
        oneTest.checkStatus(true);
    }

    public void testBasicCheckout() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        try {
            this.client.checkout(oneTest.getUrl() + "/A", oneTest.getWCPath(), null, true);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        File file = new File(oneTest.getWorkingCopy(), "A/mu");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("appended mu text");
        printWriter.close();
        oneTest.getWc().setItemTextStatus("A/mu", 2);
        File file2 = new File(oneTest.getWorkingCopy(), "A/B/lambda");
        file2.delete();
        oneTest.getWc().setItemTextStatus("A/B/lambda", 6);
        this.client.remove(new String[]{oneTest.getWCPath() + "/A/D/G"}, null, false);
        oneTest.getWc().setItemTextStatus("A/D/G", 4);
        oneTest.getWc().setItemTextStatus("A/D/G/pi", 4);
        oneTest.getWc().setItemTextStatus("A/D/G/rho", 4);
        oneTest.getWc().setItemTextStatus("A/D/G/tau", 4);
        oneTest.checkStatus();
        this.client.checkout(oneTest.getUrl(), oneTest.getWCPath(), null, true);
        oneTest.getWc().setItemTextStatus("A/B/lambda", 1);
        oneTest.checkStatus();
    }

    public void testBasicCommit() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWorkingCopy(), "A/mu");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("appended mu text");
        printWriter.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/mu", 2L);
        oneTest.getWc().setItemContent("A/mu", oneTest.getWc().getItemContent("A/mu") + "appended mu text");
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/mu", 1, 4);
        File file2 = new File(oneTest.getWorkingCopy(), "A/D/G/rho");
        PrintWriter printWriter2 = new PrintWriter(new FileOutputStream(file2, true));
        printWriter2.print("new appended text for rho");
        printWriter2.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/D/G/rho", 2L);
        oneTest.getWc().setItemContent("A/D/G/rho", oneTest.getWc().getItemContent("A/D/G/rho") + "new appended text for rho");
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/D/G/rho", 1, 4);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true), (long)2L);
        oneTest.checkStatus();
    }

    public void testBasicProperties() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        WC wC = oneTest.getWc();
        String string = this.fileToSVNPath(new File(oneTest.getWCPath(), "iota"), false);
        this.client.propertySet(string, "abc", "def", false);
        PropertyData[] propertyDataArray = this.client.properties(string);
        PropertyData propertyData = propertyDataArray[0];
        BasicTests.assertEquals((String)"abc", (String)propertyData.getName());
        BasicTests.assertEquals((String)"def", (String)propertyData.getValue());
        wC.setItemPropStatus("iota", 2);
        oneTest.checkStatus();
        string = this.fileToSVNPath(new File(oneTest.getWCPath(), "/A/B/E/alpha"), false);
        this.client.propertyCreate(string, "cqcq", "qrz", false, false);
        ProplistCallbackImpl proplistCallbackImpl = new ProplistCallbackImpl();
        this.client.properties(string, null, null, 0, null, proplistCallbackImpl);
        Map<String, String> map = proplistCallbackImpl.getProperties(string);
        for (String string2 : map.keySet()) {
            BasicTests.assertEquals((String)"cqcq", (String)string2);
            BasicTests.assertEquals((String)"qrz", (String)map.get(string2));
        }
        wC.setItemPropStatus("A/B/E/alpha", 2);
        oneTest.checkStatus();
    }

    public void testBasicUpdate() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        SVNTests.OneTest oneTest2 = oneTest.copy(".backup");
        File file = new File(oneTest.getWorkingCopy(), "A/mu");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("appended mu text");
        printWriter.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/mu", 2L);
        oneTest.getWc().setItemContent("A/mu", oneTest.getWc().getItemContent("A/mu") + "appended mu text");
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/mu", 1, 4);
        File file2 = new File(oneTest.getWorkingCopy(), "A/D/G/rho");
        PrintWriter printWriter2 = new PrintWriter(new FileOutputStream(file2, true));
        printWriter2.print("new appended text for rho");
        printWriter2.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/D/G/rho", 2L);
        oneTest.getWc().setItemContent("A/D/G/rho", oneTest.getWc().getItemContent("A/D/G/rho") + "new appended text for rho");
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/D/G/rho", 1, 4);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true), (long)2L);
        oneTest.checkStatus();
        BasicTests.assertEquals((String)"wrong revision number from update", (long)this.client.update(oneTest2.getWCPath(), null, true), (long)2L);
        oneTest2.getWc().setItemWorkingCopyRevision("A/mu", 2L);
        oneTest2.getWc().setItemContent("A/mu", oneTest2.getWc().getItemContent("A/mu") + "appended mu text");
        oneTest2.getWc().setItemWorkingCopyRevision("A/D/G/rho", 2L);
        oneTest2.getWc().setItemContent("A/D/G/rho", oneTest2.getWc().getItemContent("A/D/G/rho") + "new appended text for rho");
        oneTest2.checkStatus();
    }

    public void testBasicMkdirUrl() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        this.addExpectedCommitItem(null, oneTest.getUrl(), "Y", 0, 1);
        this.addExpectedCommitItem(null, oneTest.getUrl(), "Y/Z", 0, 1);
        this.client.mkdir(new String[]{oneTest.getUrl() + "/Y", oneTest.getUrl() + "/Y/Z"}, "log_msg");
        oneTest.getWc().addItem("Y", null);
        oneTest.getWc().setItemWorkingCopyRevision("Y", 2L);
        oneTest.getWc().addItem("Y/Z", null);
        oneTest.getWc().setItemWorkingCopyRevision("Y/Z", 2L);
        BasicTests.assertEquals((String)"wrong revision from update", (long)this.client.update(oneTest.getWCPath(), null, true), (long)2L);
        oneTest.checkStatus();
    }

    public void testCopy() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        WC wC = oneTest.getWc();
        Revision revision = Revision.getInstance(1L);
        Revision revision2 = null;
        String[] stringArray = new String[]{"alpha", "beta"};
        CopySource[] copySourceArray = new CopySource[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            copySourceArray[i] = new CopySource(new File(oneTest.getWorkingCopy(), "A/B/E/" + string).getPath(), revision, revision2);
            wC.addItem("A/B/F/" + string, wC.getItemContent("A/B/E/" + string));
            wC.setItemWorkingCopyRevision("A/B/F/" + string, 2L);
            this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/B/F/" + string, 1, 17);
        }
        this.client.copy(copySourceArray, new File(oneTest.getWorkingCopy(), "A/B/F").getPath(), null, true, false, null);
        BasicTests.assertEquals((String)"Unexpected WC revision number after commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "Copy files", true), (long)2L);
        oneTest.checkStatus();
        this.assertExpectedSuggestion(oneTest.getUrl() + "/A/B/E/alpha", "A/B/F/alpha", oneTest);
        CopySource[] copySourceArray2 = new CopySource[]{new CopySource(new File(oneTest.getWorkingCopy(), "A/B").getPath(), Revision.WORKING, Revision.WORKING)};
        this.client.commitMessageHandler(null);
        this.client.copy(copySourceArray2, oneTest.getUrl() + "/parent/A/B", "Copy WC to URL", true, true, null);
        BasicTests.assertEquals((String)"wrong revision number from update", (long)this.client.update(oneTest.getWCPath(), null, true), (long)3L);
    }

    public void testMove() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        WC wC = oneTest.getWc();
        String[] stringArray = new String[]{"alpha", "beta"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            stringArray[i] = new File(oneTest.getWorkingCopy(), "A/B/E/" + string).getPath();
            wC.addItem("A/B/F/" + string, wC.getItemContent("A/B/E/" + string));
            wC.setItemWorkingCopyRevision("A/B/F/" + string, 2L);
            this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/B/F/" + string, 1, 17);
            wC.removeItem("A/B/E/" + string);
            this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/B/E/" + string, 1, 2);
        }
        this.client.move(stringArray, new File(oneTest.getWorkingCopy(), "A/B/F").getPath(), null, false, true, false, null);
        BasicTests.assertEquals((String)"Unexpected WC revision number after commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "Move files", true), (long)2L);
        oneTest.checkStatus();
        this.assertExpectedSuggestion(oneTest.getUrl() + "/A/B/E/alpha", "A/B/F/alpha", oneTest);
    }

    private void assertExpectedSuggestion(String string, String string2, SVNTests.OneTest oneTest) throws SubversionException {
        String string3 = this.fileToSVNPath(new File(oneTest.getWCPath(), string2), false);
        String[] stringArray = this.client.suggestMergeSources(string3, Revision.WORKING);
        BasicTests.assertNotNull((Object)stringArray);
        BasicTests.assertTrue((stringArray.length >= 1 ? 1 : 0) != 0);
        BasicTests.assertTrue((String)("Unexpected copy source path, expected " + string + ", got " + stringArray[0]), (boolean)string.equals(stringArray[0]));
        String string4 = oneTest.getUrl() + "/" + string2;
        stringArray = this.client.suggestMergeSources(string4, Revision.HEAD);
        BasicTests.assertNotNull((Object)stringArray);
        BasicTests.assertTrue((stringArray.length >= 1 ? 1 : 0) != 0);
        BasicTests.assertTrue((String)("Unexpected copy source path, expected " + string + ", got " + stringArray[0]), (boolean)string.equals(stringArray[0]));
    }

    private void assertExpectedMergeRange(long l, long l2, long[] lArray) {
        Arrays.sort(lArray);
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] > l) continue;
            for (int j = i; j < lArray.length; ++j) {
                if (l2 > lArray[j]) continue;
                return;
            }
            BasicTests.fail((String)("End revision: " + l2 + " was not in range: " + lArray[0] + " : " + lArray[lArray.length - 1]));
            return;
        }
        BasicTests.fail((String)("Start revision: " + l + " was not in range: " + lArray[0] + " : " + lArray[lArray.length - 1]));
    }

    public void testBasicMergingUpdate() throws Throwable {
        int n;
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWorkingCopy(), "A/mu");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        String string = oneTest.getWc().getItemContent("A/mu");
        for (int i = 2; i < 11; ++i) {
            printWriter.print("\nThis is line " + i + " in mu");
            string = string + "\nThis is line " + i + " in mu";
        }
        printWriter.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/mu", 2L);
        oneTest.getWc().setItemContent("A/mu", string);
        this.addExpectedCommitItem(oneTest.getWorkingCopy().getAbsolutePath(), oneTest.getUrl(), "A/mu", 1, 4);
        File file2 = new File(oneTest.getWorkingCopy(), "A/D/G/rho");
        PrintWriter printWriter2 = new PrintWriter(new FileOutputStream(file2, true));
        String string2 = oneTest.getWc().getItemContent("A/D/G/rho");
        for (int i = 2; i < 11; ++i) {
            printWriter2.print("\nThis is line " + i + " in rho");
            string2 = string2 + "\nThis is line " + i + " in rho";
        }
        printWriter2.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/D/G/rho", 2L);
        oneTest.getWc().setItemContent("A/D/G/rho", string2);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/D/G/rho", 1, 4);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true), (long)2L);
        oneTest.checkStatus();
        SVNTests.OneTest oneTest2 = oneTest.copy(".backup");
        printWriter = new PrintWriter(new FileOutputStream(file, true));
        string = oneTest.getWc().getItemContent("A/mu");
        printWriter.print(" Appended to line 10 of mu");
        string = string + " Appended to line 10 of mu";
        printWriter.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/mu", 3L);
        oneTest.getWc().setItemContent("A/mu", string);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/mu", 1, 4);
        printWriter2 = new PrintWriter(new FileOutputStream(file2, true));
        string2 = oneTest.getWc().getItemContent("A/D/G/rho");
        printWriter2.print(" Appended to line 10 of rho");
        string2 = string2 + " Appended to line 10 of rho";
        printWriter2.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/D/G/rho", 3L);
        oneTest.getWc().setItemContent("A/D/G/rho", string2);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/D/G/rho", 1, 4);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true), (long)3L);
        oneTest.checkStatus();
        file = new File(oneTest2.getWorkingCopy(), "A/mu");
        printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.print("This is the new line 1 in the backup copy of mu");
        string = "This is the new line 1 in the backup copy of mu";
        for (n = 2; n < 11; ++n) {
            printWriter.print("\nThis is line " + n + " in mu");
            string = string + "\nThis is line " + n + " in mu";
        }
        printWriter.close();
        oneTest2.getWc().setItemWorkingCopyRevision("A/mu", 3L);
        string = string + " Appended to line 10 of mu";
        oneTest2.getWc().setItemContent("A/mu", string);
        oneTest2.getWc().setItemTextStatus("A/mu", 2);
        file2 = new File(oneTest2.getWorkingCopy(), "A/D/G/rho");
        printWriter2 = new PrintWriter(new FileOutputStream(file2));
        printWriter2.print("This is the new line 1 in the backup copy of rho");
        string2 = "This is the new line 1 in the backup copy of rho";
        for (n = 2; n < 11; ++n) {
            printWriter2.print("\nThis is line " + n + " in rho");
            string2 = string2 + "\nThis is line " + n + " in rho";
        }
        printWriter2.close();
        oneTest2.getWc().setItemWorkingCopyRevision("A/D/G/rho", 3L);
        string2 = string2 + " Appended to line 10 of rho";
        oneTest2.getWc().setItemContent("A/D/G/rho", string2);
        oneTest2.getWc().setItemTextStatus("A/D/G/rho", 2);
        BasicTests.assertEquals((String)"wrong revision number from update", (long)this.client.update(oneTest2.getWCPath(), null, true), (long)3L);
        oneTest2.checkStatus();
    }

    public void testBasicConflict() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        SVNTests.OneTest oneTest2 = oneTest.copy(".backup");
        File file = new File(oneTest.getWorkingCopy(), "A/mu");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        String string = oneTest.getWc().getItemContent("A/mu");
        printWriter.print("\nOriginal appended text for mu");
        string = string + "\nOriginal appended text for mu";
        printWriter.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/mu", 2L);
        oneTest.getWc().setItemContent("A/mu", string);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/mu", 1, 4);
        File file2 = new File(oneTest.getWorkingCopy(), "A/D/G/rho");
        PrintWriter printWriter2 = new PrintWriter(new FileOutputStream(file2, true));
        String string2 = oneTest.getWc().getItemContent("A/D/G/rho");
        printWriter2.print("\nOriginal appended text for rho");
        string2 = string2 + "\nOriginal appended text for rho";
        printWriter2.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/D/G/rho", 2L);
        oneTest.getWc().setItemContent("A/D/G/rho", string2);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/D/G/rho", 1, 4);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true), (long)2L);
        oneTest.checkStatus();
        file = new File(oneTest2.getWorkingCopy(), "A/mu");
        printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("\nConflicting appended text for mu");
        string = "<<<<<<< .mine\nThis is the file 'mu'.\nConflicting appended text for mu=======\nThis is the file 'mu'.\nOriginal appended text for mu>>>>>>> .r2";
        printWriter.close();
        oneTest2.getWc().setItemWorkingCopyRevision("A/mu", 2L);
        oneTest2.getWc().setItemContent("A/mu", string);
        oneTest2.getWc().setItemTextStatus("A/mu", 9);
        oneTest2.getWc().addItem("A/mu.r1", "");
        oneTest2.getWc().setItemNodeKind("A/mu.r1", 3);
        oneTest2.getWc().setItemTextStatus("A/mu.r1", 5);
        oneTest2.getWc().addItem("A/mu.r2", "");
        oneTest2.getWc().setItemNodeKind("A/mu.r2", 3);
        oneTest2.getWc().setItemTextStatus("A/mu.r2", 5);
        oneTest2.getWc().addItem("A/mu.mine", "");
        oneTest2.getWc().setItemNodeKind("A/mu.mine", 3);
        oneTest2.getWc().setItemTextStatus("A/mu.mine", 5);
        file2 = new File(oneTest2.getWorkingCopy(), "A/D/G/rho");
        printWriter2 = new PrintWriter(new FileOutputStream(file2, true));
        printWriter2.print("\nConflicting appended text for rho");
        string2 = "<<<<<<< .mine\nThis is the file 'rho'.\nConflicting appended text for rho=======\nhis is the file 'rho'.\nOriginal appended text for rho>>>>>>> .r2";
        printWriter2.close();
        oneTest2.getWc().setItemWorkingCopyRevision("A/D/G/rho", 2L);
        oneTest2.getWc().setItemContent("A/D/G/rho", string2);
        oneTest2.getWc().setItemTextStatus("A/D/G/rho", 9);
        oneTest2.getWc().addItem("A/D/G/rho.r1", "");
        oneTest2.getWc().setItemNodeKind("A/D/G/rho.r1", 3);
        oneTest2.getWc().setItemTextStatus("A/D/G/rho.r1", 5);
        oneTest2.getWc().addItem("A/D/G/rho.r2", "");
        oneTest2.getWc().setItemNodeKind("A/D/G/rho.r2", 3);
        oneTest2.getWc().setItemTextStatus("A/D/G/rho.r2", 5);
        oneTest2.getWc().addItem("A/D/G/rho.mine", "");
        oneTest2.getWc().setItemNodeKind("A/D/G/rho.mine", 3);
        oneTest2.getWc().setItemTextStatus("A/D/G/rho.mine", 5);
        BasicTests.assertEquals((String)"wrong revision number from update", (long)this.client.update(oneTest2.getWCPath(), null, true), (long)2L);
        oneTest2.checkStatus();
        this.client.resolved(oneTest2.getWCPath() + "/A/mu", false);
        oneTest2.getWc().setItemTextStatus("A/mu", 2);
        oneTest2.getWc().removeItem("A/mu.r1");
        oneTest2.getWc().removeItem("A/mu.r2");
        oneTest2.getWc().removeItem("A/mu.mine");
        this.client.resolved(oneTest2.getWCPath() + "/A/D/G/rho", false);
        oneTest2.getWc().setItemTextStatus("A/D/G/rho", 2);
        oneTest2.getWc().removeItem("A/D/G/rho.r1");
        oneTest2.getWc().removeItem("A/D/G/rho.r2");
        oneTest2.getWc().removeItem("A/D/G/rho.mine");
        oneTest2.checkStatus();
    }

    public void testBasicCleanup() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        this.client.cleanup(oneTest.getWCPath());
    }

    public void testBasicRevert() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWorkingCopy(), "A/B/E/beta");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("Added some text to 'beta'.");
        printWriter.close();
        oneTest.getWc().setItemTextStatus("A/B/E/beta", 2);
        file = new File(oneTest.getWorkingCopy(), "iota");
        printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("Added some text to 'iota'.");
        printWriter.close();
        oneTest.getWc().setItemTextStatus("iota", 2);
        file = new File(oneTest.getWorkingCopy(), "A/D/G/rho");
        printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("Added some text to 'rho'.");
        printWriter.close();
        oneTest.getWc().setItemTextStatus("A/D/G/rho", 2);
        file = new File(oneTest.getWorkingCopy(), "A/D/H/zeta");
        printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("Added some text to 'zeta'.");
        printWriter.close();
        oneTest.getWc().addItem("A/D/H/zeta", "Added some text to 'zeta'.");
        oneTest.getWc().setItemTextStatus("A/D/H/zeta", 3);
        this.client.add(file.getAbsolutePath(), false);
        oneTest.checkStatus();
        this.client.revert(oneTest.getWCPath() + "/A/B/E/beta", false);
        oneTest.getWc().setItemTextStatus("A/B/E/beta", 1);
        this.client.revert(oneTest.getWCPath() + "/iota", false);
        oneTest.getWc().setItemTextStatus("iota", 1);
        this.client.revert(oneTest.getWCPath() + "/A/D/G/rho", false);
        oneTest.getWc().setItemTextStatus("A/D/G/rho", 1);
        this.client.revert(oneTest.getWCPath() + "/A/D/H/zeta", false);
        oneTest.getWc().setItemTextStatus("A/D/H/zeta", 5);
        oneTest.getWc().setItemNodeKind("A/D/H/zeta", 3);
        oneTest.checkStatus();
        file = new File(oneTest.getWorkingCopy(), "A/B/E/beta");
        file.delete();
        this.client.revert(file.getAbsolutePath(), false);
        BasicTests.assertTrue((String)"reverted file is not readonly", (file.canWrite() && file.canRead() ? 1 : 0) != 0);
        oneTest.checkStatus();
        this.client.mkdir(new String[]{oneTest.getWCPath() + "/X"}, null);
        oneTest.getWc().addItem("X", null);
        oneTest.getWc().setItemTextStatus("X", 3);
        oneTest.checkStatus();
        BasicTests.removeDirOrFile(new File(oneTest.getWorkingCopy(), "X"));
        this.client.revert(oneTest.getWCPath() + "/X", false);
        oneTest.getWc().removeItem("X");
        oneTest.checkStatus();
        this.client.remove(new String[]{oneTest.getWCPath() + "/A/B/E"}, null, true);
        BasicTests.removeDirOrFile(new File(oneTest.getWorkingCopy(), "A/B/E"));
        oneTest.getWc().setItemTextStatus("A/B/E", 4);
        oneTest.getWc().setItemTextStatus("A/B/E/alpha", 4);
        oneTest.getWc().setItemTextStatus("A/B/E/beta", 4);
        oneTest.checkStatus();
        this.client.revert(oneTest.getWCPath() + "/A/B/E", true);
        oneTest.getWc().setItemTextStatus("A/B/E", 1);
        oneTest.getWc().setItemTextStatus("A/B/E/alpha", 1);
        oneTest.getWc().setItemTextStatus("A/B/E/beta", 1);
        oneTest.checkStatus();
    }

    public void testBasicSwitch() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        String string = oneTest.getWCPath() + "/iota";
        String string2 = oneTest.getUrl() + "/A/D/gamma";
        oneTest.getWc().setItemContent("iota", this.greekWC.getItemContent("A/D/gamma"));
        oneTest.getWc().setItemIsSwitched("iota", true);
        this.client.doSwitch(string, string2, null, true);
        oneTest.checkStatus();
        String string3 = oneTest.getWCPath() + "/A/D/H";
        String string4 = oneTest.getUrl() + "/A/D/G";
        oneTest.getWc().setItemIsSwitched("A/D/H", true);
        oneTest.getWc().removeItem("A/D/H/chi");
        oneTest.getWc().removeItem("A/D/H/omega");
        oneTest.getWc().removeItem("A/D/H/psi");
        oneTest.getWc().addItem("A/D/H/pi", oneTest.getWc().getItemContent("A/D/G/pi"));
        oneTest.getWc().addItem("A/D/H/rho", oneTest.getWc().getItemContent("A/D/G/rho"));
        oneTest.getWc().addItem("A/D/H/tau", oneTest.getWc().getItemContent("A/D/G/tau"));
        this.client.doSwitch(string3, string4, null, true);
        oneTest.checkStatus();
    }

    public void testBasicDelete() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWorkingCopy(), "A/D/H/chi");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("added to chi");
        printWriter.close();
        oneTest.getWc().setItemTextStatus("A/D/H/chi", 2);
        this.client.propertySet(oneTest.getWCPath() + "/A/D/G/rho", "abc", "def", true);
        oneTest.getWc().setItemPropStatus("A/D/G/rho", 2);
        this.client.propertySet(oneTest.getWCPath() + "/A/B/F", "abc", "def", false);
        oneTest.getWc().setItemPropStatus("A/B/F", 2);
        file = new File(oneTest.getWCPath(), "A/C/sigma");
        printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.print("unversioned sigma");
        printWriter.close();
        oneTest.getWc().addItem("A/C/sigma", "unversioned sigma");
        oneTest.getWc().setItemTextStatus("A/C/sigma", 5);
        oneTest.getWc().setItemNodeKind("A/C/sigma", 3);
        file = new File(oneTest.getWCPath(), "A/C/Q");
        file.mkdir();
        oneTest.getWc().addItem("A/C/Q", null);
        oneTest.getWc().setItemNodeKind("A/C/Q", 3);
        oneTest.getWc().setItemTextStatus("A/C/Q", 5);
        file = new File(oneTest.getWCPath(), "A/B/X");
        this.client.mkdir(new String[]{file.getAbsolutePath()}, null);
        oneTest.getWc().addItem("A/B/X", null);
        oneTest.getWc().setItemTextStatus("A/B/X", 3);
        file = new File(file, "xi");
        printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.print("added xi");
        printWriter.close();
        this.client.add(file.getAbsolutePath(), false);
        oneTest.getWc().addItem("A/B/X/xi", "added xi");
        oneTest.getWc().setItemTextStatus("A/B/X/xi", 3);
        file = new File(oneTest.getWCPath(), "A/B/Y");
        this.client.mkdir(new String[]{file.getAbsolutePath()}, null);
        oneTest.getWc().addItem("A/B/Y", null);
        oneTest.getWc().setItemTextStatus("A/B/Y", 3);
        oneTest.checkStatus();
        try {
            this.client.remove(new String[]{oneTest.getWCPath() + "/A/D/H/chi"}, null, false);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        try {
            this.client.remove(new String[]{oneTest.getWCPath() + "/A/D/H"}, null, false);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        try {
            this.client.remove(new String[]{oneTest.getWCPath() + "/A/D/G/rho"}, null, false);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        try {
            this.client.remove(new String[]{oneTest.getWCPath() + "/A/D/G"}, null, false);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        try {
            this.client.remove(new String[]{oneTest.getWCPath() + "/A/B/F"}, null, false);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        try {
            this.client.remove(new String[]{oneTest.getWCPath() + "/A/B"}, null, false);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        try {
            this.client.remove(new String[]{oneTest.getWCPath() + "/A/C/sigma"}, null, false);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        try {
            this.client.remove(new String[]{oneTest.getWCPath() + "/A/C"}, null, false);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        try {
            this.client.remove(new String[]{oneTest.getWCPath() + "/A/B/X"}, null, false);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        oneTest.checkStatus();
        this.client.remove(new String[]{oneTest.getWCPath() + "/A/B/E"}, null, false);
        oneTest.getWc().setItemTextStatus("A/B/E", 4);
        oneTest.getWc().setItemTextStatus("A/B/E/alpha", 4);
        oneTest.getWc().setItemTextStatus("A/B/E/beta", 4);
        this.client.remove(new String[]{oneTest.getWCPath() + "/A/D/H"}, null, true);
        oneTest.getWc().setItemTextStatus("A/D/H", 4);
        oneTest.getWc().setItemTextStatus("A/D/H/chi", 4);
        oneTest.getWc().setItemTextStatus("A/D/H/omega", 4);
        oneTest.getWc().setItemTextStatus("A/D/H/psi", 4);
        this.client.remove(new String[]{oneTest.getWCPath() + "/A/D/G"}, null, true);
        oneTest.getWc().setItemTextStatus("A/D/G", 4);
        oneTest.getWc().setItemTextStatus("A/D/G/rho", 4);
        oneTest.getWc().setItemPropStatus("A/D/G/rho", 0);
        oneTest.getWc().setItemTextStatus("A/D/G/pi", 4);
        oneTest.getWc().setItemTextStatus("A/D/G/tau", 4);
        this.client.remove(new String[]{oneTest.getWCPath() + "/A/B/F"}, null, true);
        oneTest.getWc().setItemTextStatus("A/B/F", 4);
        oneTest.getWc().setItemPropStatus("A/B/F", 0);
        this.client.remove(new String[]{oneTest.getWCPath() + "/A/C"}, null, true);
        oneTest.getWc().setItemTextStatus("A/C", 4);
        this.client.remove(new String[]{oneTest.getWCPath() + "/A/B/X"}, null, true);
        file = new File(oneTest.getWorkingCopy(), "iota");
        file.delete();
        this.client.remove(new String[]{file.getAbsolutePath()}, null, true);
        oneTest.getWc().setItemTextStatus("iota", 4);
        file = new File(oneTest.getWorkingCopy(), "A/D/gamma");
        file.delete();
        this.client.remove(new String[]{file.getAbsolutePath()}, null, false);
        oneTest.getWc().setItemTextStatus("A/D/gamma", 4);
        this.client.remove(new String[]{file.getAbsolutePath()}, null, true);
        this.client.remove(new String[]{oneTest.getWCPath() + "/A/B/E"}, null, false);
        oneTest.getWc().removeItem("A/B/X");
        oneTest.getWc().removeItem("A/B/X/xi");
        oneTest.getWc().removeItem("A/C/sigma");
        oneTest.getWc().removeItem("A/C/Q");
        oneTest.checkStatus();
        this.client.remove(new String[]{oneTest.getWCPath() + "/A/D"}, null, true);
        oneTest.getWc().setItemTextStatus("A/D", 4);
        oneTest.getWc().removeItem("A/D/Y");
        oneTest.checkStatus();
        BasicTests.assertFalse((String)"failed to remove text modified file", (boolean)new File(oneTest.getWorkingCopy(), "A/D/G/rho").exists());
        BasicTests.assertFalse((String)"failed to remove prop modified file", (boolean)new File(oneTest.getWorkingCopy(), "A/D/H/chi").exists());
        BasicTests.assertFalse((String)"failed to remove unversioned file", (boolean)new File(oneTest.getWorkingCopy(), "A/C/sigma").exists());
        BasicTests.assertFalse((String)"failed to remove unmodified file", (boolean)new File(oneTest.getWorkingCopy(), "A/B/E/alpha").exists());
        file = new File(oneTest.getWorkingCopy(), "A/B/F");
        BasicTests.assertFalse((String)"failed to remove versioned dir", (boolean)file.exists());
        BasicTests.assertFalse((String)"failed to remove unversioned dir", (boolean)new File(oneTest.getWorkingCopy(), "A/C/Q").exists());
        BasicTests.assertFalse((String)"failed to remove added dir", (boolean)new File(oneTest.getWorkingCopy(), "A/B/X").exists());
        file = new File(oneTest.getWCPath(), "foo");
        printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.print("unversioned foo");
        printWriter.close();
        this.client.remove(new String[]{file.getAbsolutePath()}, null, true);
        BasicTests.assertFalse((String)"failed to remove unversioned file foo", (boolean)file.exists());
        try {
            this.client.remove(new String[]{file.getAbsolutePath()}, null, true);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        this.addExpectedCommitItem(null, oneTest.getUrl(), "iota", 0, 2);
        this.client.remove(new String[]{oneTest.getUrl() + "/iota"}, "delete iota URL", false);
    }

    public void testBasicCheckoutDeleted() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        this.client.remove(new String[]{oneTest.getWCPath() + "/A/D"}, null, true);
        oneTest.getWc().setItemTextStatus("A/D", 4);
        oneTest.getWc().setItemTextStatus("A/D/G", 4);
        oneTest.getWc().setItemTextStatus("A/D/G/rho", 4);
        oneTest.getWc().setItemTextStatus("A/D/G/pi", 4);
        oneTest.getWc().setItemTextStatus("A/D/G/tau", 4);
        oneTest.getWc().setItemTextStatus("A/D/H", 4);
        oneTest.getWc().setItemTextStatus("A/D/H/chi", 4);
        oneTest.getWc().setItemTextStatus("A/D/H/psi", 4);
        oneTest.getWc().setItemTextStatus("A/D/H/omega", 4);
        oneTest.getWc().setItemTextStatus("A/D/gamma", 4);
        oneTest.checkStatus();
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/D", 2, 2);
        BasicTests.assertEquals((String)"wrong revision from commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "log message", true), (long)2L);
        oneTest.getWc().removeItem("A/D");
        oneTest.getWc().removeItem("A/D/G");
        oneTest.getWc().removeItem("A/D/G/rho");
        oneTest.getWc().removeItem("A/D/G/pi");
        oneTest.getWc().removeItem("A/D/G/tau");
        oneTest.getWc().removeItem("A/D/H");
        oneTest.getWc().removeItem("A/D/H/chi");
        oneTest.getWc().removeItem("A/D/H/psi");
        oneTest.getWc().removeItem("A/D/H/omega");
        oneTest.getWc().removeItem("A/D/gamma");
        oneTest.checkStatus();
        this.client.checkout(oneTest.getUrl() + "/A/D", oneTest.getWCPath() + "/new_D", new Revision.Number(1L), true);
    }

    public void testBasicImport() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWCPath(), "new_file");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.print("some text");
        printWriter.close();
        this.addExpectedCommitItem(oneTest.getWCPath(), null, "new_file", 0, 1);
        this.client.doImport(file.getAbsolutePath(), oneTest.getUrl() + "/dirA/dirB/new_file", "log message for new import", true);
        file.delete();
        BasicTests.assertEquals((String)"wrong revision from update", (long)this.client.update(oneTest.getWCPath(), null, true), (long)2L);
        oneTest.getWc().addItem("dirA", null);
        oneTest.getWc().setItemWorkingCopyRevision("dirA", 2L);
        oneTest.getWc().addItem("dirA/dirB", null);
        oneTest.getWc().setItemWorkingCopyRevision("dirA/dirB", 2L);
        oneTest.getWc().addItem("dirA/dirB/new_file", "some text");
        oneTest.getWc().setItemWorkingCopyRevision("dirA/dirB/new_file", 2L);
        oneTest.checkStatus();
    }

    public void testBasicCat() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWorkingCopy(), "A/mu");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("some text");
        printWriter.close();
        byte[] byArray = this.client.fileContent(oneTest.getWCPath() + "/A/mu", null);
        byte[] byArray2 = oneTest.getWc().getItemContent("A/mu").getBytes();
        BasicTests.assertTrue((String)"content changed", (boolean)Arrays.equals(byArray, byArray2));
    }

    public void testBasicCatStream() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWorkingCopy(), "A/mu");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("some text");
        printWriter.close();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.client.streamFileContent(oneTest.getWCPath() + "/A/mu", null, null, 100, byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byte[] byArray2 = oneTest.getWc().getItemContent("A/mu").getBytes();
        BasicTests.assertTrue((String)"content changed", (boolean)Arrays.equals(byArray, byArray2));
    }

    public void testBasicLs() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        DirEntry[] dirEntryArray = this.client.list(oneTest.getWCPath(), null, false);
        oneTest.getWc().check(dirEntryArray, "", false);
        dirEntryArray = this.client.list(oneTest.getWCPath() + "/A", null, false);
        oneTest.getWc().check(dirEntryArray, "A", false);
        dirEntryArray = this.client.list(oneTest.getWCPath() + "/A", Revision.BASE, false);
        oneTest.getWc().check(dirEntryArray, "A", false);
        dirEntryArray = this.client.list(oneTest.getWCPath() + "/A/mu", null, false);
        oneTest.getWc().check(dirEntryArray, "A/mu");
    }

    public void testBasicAddIgnores() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWorkingCopy(), "dir");
        file.mkdir();
        File file2 = new File(file, "foo.c");
        new FileOutputStream(file2).close();
        File file3 = new File(file, "foo.o");
        new FileOutputStream(file3).close();
        this.client.add(file.getAbsolutePath(), true);
        oneTest.getWc().addItem("dir", null);
        oneTest.getWc().setItemTextStatus("dir", 3);
        oneTest.getWc().addItem("dir/foo.c", "");
        oneTest.getWc().setItemTextStatus("dir/foo.c", 3);
        oneTest.getWc().addItem("dir/foo.o", "");
        oneTest.getWc().setItemTextStatus("dir/foo.o", 11);
        oneTest.getWc().setItemNodeKind("dir/foo.o", 3);
        oneTest.checkStatus();
    }

    public void testBasicImportIgnores() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWorkingCopy(), "dir");
        file.mkdir();
        File file2 = new File(file, "foo.c");
        new FileOutputStream(file2).close();
        File file3 = new File(file, "foo.o");
        new FileOutputStream(file3).close();
        this.addExpectedCommitItem(oneTest.getWCPath(), null, "dir", 0, 1);
        this.client.doImport(file.getAbsolutePath(), oneTest.getUrl() + "/dir", "log message for import", true);
        BasicTests.removeDirOrFile(file);
        BasicTests.assertEquals((String)"wrong revision from update", (long)2L, (long)this.client.update(oneTest.getWCPath(), null, true));
        oneTest.getWc().addItem("dir", null);
        oneTest.getWc().addItem("dir/foo.c", "");
        oneTest.checkStatus();
    }

    public void testBasicInfo() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        Info info = this.client.info(oneTest.getWCPath() + "/A/mu");
        BasicTests.assertEquals((String)"wrong revision from info", (long)1L, (long)info.getLastChangedRevision());
        BasicTests.assertEquals((String)"wrong schedule kind from info", (int)0, (int)info.getSchedule());
        BasicTests.assertEquals((String)"wrong node kind from info", (int)1, (int)info.getNodeKind());
    }

    public void testBasicLogMessage() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        LogMessage[] logMessageArray = this.client.logMessages(oneTest.getWCPath(), null, null, false, true);
        BasicTests.assertEquals((String)"wrong number of objects", (int)1, (int)logMessageArray.length);
        BasicTests.assertEquals((String)"wrong message", (String)"Log Message", (String)logMessageArray[0].getMessage());
        BasicTests.assertEquals((String)"wrong revision", (long)1L, (long)logMessageArray[0].getRevisionNumber());
        BasicTests.assertEquals((String)"wrong user", (String)"jrandom", (String)logMessageArray[0].getAuthor());
        BasicTests.assertNotNull((String)"changed paths set", (Object)logMessageArray[0].getChangedPaths());
        ChangePath[] changePathArray = logMessageArray[0].getChangedPaths();
        BasicTests.assertEquals((String)"wrong number of chang pathes", (int)20, (int)changePathArray.length);
        BasicTests.assertEquals((String)"wrong path", (String)"/A", (String)changePathArray[0].getPath());
        BasicTests.assertEquals((String)"wrong copy source rev", (long)-1L, (long)changePathArray[0].getCopySrcRevision());
        BasicTests.assertNull((String)"wrong copy source path", (Object)changePathArray[0].getCopySrcPath());
        BasicTests.assertEquals((String)"wrong action", (char)'A', (char)changePathArray[0].getAction());
        BasicTests.assertEquals((String)"wrong time with getTimeMicros()", (long)(logMessageArray[0].getTimeMicros() / 1000L), (long)logMessageArray[0].getDate().getTime());
        BasicTests.assertEquals((String)"wrong time with getTimeMillis()", (long)logMessageArray[0].getTimeMillis(), (long)logMessageArray[0].getDate().getTime());
        BasicTests.assertEquals((String)"wrong date with getTimeMicros()", (Object)logMessageArray[0].getDate(), (Object)new Date(logMessageArray[0].getTimeMicros() / 1000L));
        BasicTests.assertEquals((String)"wrong date with getTimeMillis()", (Object)logMessageArray[0].getDate(), (Object)new Date(logMessageArray[0].getTimeMillis()));
        String string = oneTest.getUrl().toString() + "/";
        LogMessage[] logMessageArray2 = this.client.logMessages(string, null, null, false, true);
    }

    public void testBasicVersionInfo() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        BasicTests.assertEquals((String)"wrong version info", (String)"1", (String)this.client.getVersionInfo(oneTest.getWCPath(), null, false));
    }

    public void testBasicLocking() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        this.client.propertySet(oneTest.getWCPath() + "/A/mu", "svn:needs-lock", "*", false);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/mu", 1, 8);
        BasicTests.assertEquals((String)"bad revision number on commit", (long)2L, (long)this.client.commit(new String[]{oneTest.getWCPath()}, "message", true));
        File file = new File(oneTest.getWCPath() + "/A/mu");
        BasicTests.assertEquals((String)"file should be read only now", (boolean)false, (boolean)file.canWrite());
        this.client.lock(new String[]{oneTest.getWCPath() + "/A/mu"}, "comment", false);
        BasicTests.assertEquals((String)"file should be read write now", (boolean)true, (boolean)file.canWrite());
        this.client.unlock(new String[]{oneTest.getWCPath() + "/A/mu"}, false);
        BasicTests.assertEquals((String)"file should be read only now", (boolean)false, (boolean)file.canWrite());
        this.client.lock(new String[]{oneTest.getWCPath() + "/A/mu"}, "comment", false);
        BasicTests.assertEquals((String)"file should be read write now", (boolean)true, (boolean)file.canWrite());
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/mu", 1, 0);
        BasicTests.assertEquals((String)"rev number from commit", (long)-1L, (long)this.client.commit(new String[]{oneTest.getWCPath()}, "message", true));
        BasicTests.assertEquals((String)"file should be read write now", (boolean)true, (boolean)file.canWrite());
        try {
            this.client.lock(new String[]{oneTest.getWCPath() + "/A/mu2"}, "comment", false);
            BasicTests.fail((String)"missing exception");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    public void testBasicInfo2() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        Info2[] info2Array = this.client.info2(oneTest.getWCPath(), null, null, false);
        BasicTests.assertEquals((String)"Incorrect number of info objects", (int)1, (int)info2Array.length);
        info2Array = this.client.info2(oneTest.getWCPath(), null, null, true);
        BasicTests.assertEquals((String)"Incorrect number of info objects", (int)21, (int)info2Array.length);
        for (int i = 0; i < info2Array.length; ++i) {
            Info2 info2 = info2Array[i];
            BasicTests.assertNull((String)"Unexpected changelist present", (Object)info2.getChangelistName());
            boolean bl = info2.getKind() == 1;
            BasicTests.assertTrue((String)("Unexpected working file size " + info2.getWorkingSize() + " for '" + info2 + '\''), (boolean)(bl ? info2.getWorkingSize() > -1L : info2.getWorkingSize() == -1L));
            BasicTests.assertEquals((String)("Unexpected repos file size for '" + info2 + '\''), (long)-1L, (long)info2.getReposSize());
            BasicTests.assertEquals((String)("Unexpected depth for '" + info2 + "'"), (int)(bl ? -2 : 3), (int)info2.getDepth());
        }
        String string = oneTest.getWCPath() + ".empty";
        BasicTests.removeDirOrFile(new File(string));
        this.client.checkout(oneTest.getUrl(), string, null, null, 0, false, true);
        info2Array = this.client.info2(string, null, null, false);
        BasicTests.assertEquals((int)0, (int)info2Array[0].getDepth());
    }

    public void testBasicChangelist() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        String string = "changelist1";
        Object[] objectArray = new String[]{string};
        MyChangelistCallback myChangelistCallback = new MyChangelistCallback();
        String[] stringArray = new String[]{this.fileToSVNPath(new File(oneTest.getWCPath(), "iota"), true)};
        this.client.addToChangelist(stringArray, string, 3, null);
        Object[] objectArray2 = new String[1];
        this.client.getChangelists(oneTest.getWCPath(), (String[])objectArray, 3, myChangelistCallback);
        objectArray2[0] = (String)myChangelistCallback.get(stringArray[0]).get(0);
        BasicTests.assertTrue((boolean)Arrays.equals(objectArray2, objectArray));
        Status[] statusArray = this.client.status(stringArray[0], false, false, false, false, false);
        BasicTests.assertEquals((String)statusArray[0].getChangelist(), (String)string);
        this.client.removeFromChangelists(stringArray, 3, (String[])objectArray);
        myChangelistCallback.clear();
        this.client.getChangelists(oneTest.getWCPath(), (String[])objectArray, 3, myChangelistCallback);
        BasicTests.assertTrue((boolean)myChangelistCallback.isEmpty());
    }

    private void acquireMergeinfoAndAssertEquals(long l, long l2, long l3, long l4, String string, String string2) throws SubversionException {
        Mergeinfo mergeinfo = this.client.getMergeinfo(string, Revision.HEAD);
        BasicTests.assertNotNull((String)("Missing merge info on '" + string + '\''), (Object)mergeinfo);
        List<RevisionRange> list = mergeinfo.getRevisions(string2);
        BasicTests.assertTrue((String)("Missing merge info for source '" + string2 + "' on '" + string + '\''), (list != null && !list.isEmpty() ? 1 : 0) != 0);
        RevisionRange revisionRange = list.get(0);
        String string3 = l + "-" + l2;
        BasicTests.assertEquals((String)("Unexpected first merged revision range for '" + string2 + "' on '" + string + '\''), (String)string3, (String)revisionRange.toString());
        if (l3 > 0L) {
            long[] lArray = this.getMergeinfoRevisions(0, string, Revision.HEAD, string2, Revision.HEAD);
            BasicTests.assertNotNull((String)("Missing eligible merge info on '" + string + '\''), (Object)lArray);
            this.assertExpectedMergeRange(l3, l4, lArray);
        }
    }

    private long[] getMergeinfoRevisions(int n, String string, Revision revision, String string2, Revision revision2) throws SubversionException {
        class Callback
        implements LogMessageCallback {
            List revList = new ArrayList();

            Callback() {
            }

            @Override
            public void singleMessage(ChangePath[] changePathArray, long l, Map map, boolean bl) {
                this.revList.add(new Long(l));
            }

            public long[] getRevisions() {
                long[] lArray = new long[this.revList.size()];
                int n = 0;
                for (Long l : this.revList) {
                    lArray[n] = l;
                    ++n;
                }
                return lArray;
            }
        }
        Callback callback = new Callback();
        this.client.getMergeinfoLog(n, string, revision, string2, revision2, false, null, callback);
        return callback.getRevisions();
    }

    private File appendText(SVNTests.OneTest oneTest, String string, String string2, int n) throws FileNotFoundException {
        File file = new File(oneTest.getWorkingCopy(), string);
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print(string2);
        printWriter.close();
        if (n > 0) {
            WC wC = oneTest.getWc();
            wC.setItemWorkingCopyRevision(string, n);
            wC.setItemContent(string, wC.getItemContent(string) + string2);
        }
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), string, 1, 4);
        return file;
    }

    public void testBasicMerge() throws Throwable {
        SVNTests.OneTest oneTest = this.setupAndPerformMerge();
        String[] stringArray = this.client.suggestMergeSources(oneTest.getWCPath() + "/branches/A", Revision.WORKING);
        BasicTests.assertNotNull((Object)stringArray);
        BasicTests.assertEquals((int)1, (int)stringArray.length);
        BasicTests.assertNull((Object)this.client.getMergeinfo(new File(oneTest.getWCPath(), "A").toString(), Revision.HEAD));
        this.appendText(oneTest, "A/mu", "xxx", 4);
        this.appendText(oneTest, "A/D/G/rho", "yyy", 4);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true), (long)4L);
        final Revision[] revisionArray = new Revision[2];
        Notify2 notify2 = new Notify2(){

            @Override
            public void onNotify(NotifyInformation notifyInformation) {
                if (notifyInformation.getAction() == 28) {
                    RevisionRange revisionRange = notifyInformation.getMergeRange();
                    revisionArray[0] = revisionRange.getFromRevision();
                    revisionArray[1] = revisionRange.getToRevision();
                }
            }
        };
        this.client.notification2(notify2);
        String string = oneTest.getWCPath() + "/branches/A";
        String string2 = oneTest.getUrl() + "/A";
        this.client.merge(string2, (Revision)new Revision.Number(2L), string2, Revision.HEAD, string, false, true, false, true);
        BasicTests.assertEquals((String)"Notification of beginning of merge reported incorrect start revision", (Object)new Revision.Number(2L), (Object)revisionArray[0]);
        BasicTests.assertEquals((String)"Notification of beginning of merge reported incorrect end revision", (Object)new Revision.Number(4L), (Object)revisionArray[1]);
        this.client.merge(string2, (Revision)new Revision.Number(2L), string2, Revision.HEAD, string, false, true, false, false);
        BasicTests.assertEquals((String)"Notification of beginning of merge reported incorrect start revision", (Object)new Revision.Number(2L), (Object)revisionArray[0]);
        BasicTests.assertEquals((String)"Notification of beginning of merge reported incorrect end revision", (Object)new Revision.Number(4L), (Object)revisionArray[1]);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "branches/A", 2, 8);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "branches/A/mu", 1, 4);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "branches/A/D/G/rho", 1, 4);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true), (long)5L);
        this.appendText(oneTest, "A/mu", "xxxr6", 6);
        this.appendText(oneTest, "A/D/G/rho", "yyyr6", 6);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true), (long)6L);
        String string3 = new File(oneTest.getWCPath(), "branches/A/mu").getPath();
        String string4 = oneTest.getUrl() + "/A/mu";
        this.acquireMergeinfoAndAssertEquals(2L, 4L, 6L, 6L, string3, string4);
        string3 = oneTest.getUrl() + "/branches/A/mu";
        this.acquireMergeinfoAndAssertEquals(2L, 4L, 6L, 6L, string3, string4);
    }

    public void testMergeUsingHistory() throws Throwable {
        SVNTests.OneTest oneTest = this.setupAndPerformMerge();
        BasicTests.assertNull((Object)this.client.getMergeinfo(new File(oneTest.getWCPath(), "A").toString(), Revision.HEAD));
        this.appendText(oneTest, "A/mu", "xxx", 4);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true), (long)4L);
        String string = oneTest.getWCPath() + "/branches/A";
        String string2 = oneTest.getUrl() + "/A";
        Revision revision = new Revision(0);
        this.client.merge(string2, Revision.HEAD, new RevisionRange[]{new RevisionRange(revision, revision)}, string, true, 3, false, false, false);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "branches/A", 2, 8);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "branches/A/mu", 1, 4);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true), (long)5L);
    }

    public void testMergeReintegrate() throws Throwable {
        SVNTests.OneTest oneTest = this.setupAndPerformMerge();
        BasicTests.assertNull((Object)this.client.getMergeinfo(new File(oneTest.getWCPath(), "A").toString(), Revision.HEAD));
        this.appendText(oneTest, "A/mu", "xxx", 4);
        BasicTests.assertEquals((String)"wrong revision number from main commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true), (long)4L);
        this.appendText(oneTest, "branches/A/D/G/rho", "yyy", -1);
        BasicTests.assertEquals((String)"wrong revision number from branch commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true), (long)5L);
        this.client.update(oneTest.getWCPath() + "/branches", Revision.HEAD, true);
        String string = oneTest.getWCPath() + "/branches/A";
        String string2 = oneTest.getUrl() + "/A";
        Revision revision = new Revision(0);
        this.client.merge(string2, Revision.HEAD, new RevisionRange[]{new RevisionRange(revision, revision)}, string, true, 3, false, false, false);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "branches/A", 2, 8);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "branches/A/mu", 1, 4);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true), (long)6L);
        String string3 = oneTest.getUrl() + "/branches/A";
        try {
            this.client.mergeReintegrate(string3, Revision.HEAD, oneTest.getWCPath() + "/A", false);
            BasicTests.fail((String)"reintegrate merged into a mixed-revision WC");
        }
        catch (ClientException clientException) {
            this.client.update(oneTest.getWCPath(), Revision.HEAD, true);
            this.client.mergeReintegrate(string3, Revision.HEAD, oneTest.getWCPath() + "/A", false);
        }
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A", 2, 8);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/D/G/rho", 1, 4);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true), (long)7L);
    }

    public void testMergeConflictResolution() throws Throwable {
        this.client.setConflictResolver(new ConflictResolverCallback(){

            @Override
            public ConflictResult resolve(ConflictDescriptor conflictDescriptor) {
                return new ConflictResult(4, null);
            }
        });
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        String string = oneTest.getWc().getItemContent("A/mu");
        String string2 = string + "xxx";
        File file = this.appendText(oneTest, "A/mu", "xxx", 2);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)2L, (long)this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true));
        this.client.update(oneTest.getWCPath(), Revision.getInstance(1L), true);
        file = this.appendText(oneTest, "A/mu", "yyy", 1);
        RevisionRange[] revisionRangeArray = new RevisionRange[]{new RevisionRange(new Revision.Number(1L), new Revision.Number(2L))};
        this.client.merge(oneTest.getUrl(), Revision.HEAD, revisionRangeArray, oneTest.getWCPath(), false, 3, false, false, false);
        this.assertFileContentsEquals("Unexpected conflict resolution", string2, file);
    }

    public void testRecordOnlyMerge() throws Throwable {
        SVNTests.OneTest oneTest = this.setupAndPerformMerge();
        String[] stringArray = this.client.suggestMergeSources(oneTest.getWCPath() + "/branches/A", Revision.WORKING);
        BasicTests.assertNotNull((Object)stringArray);
        BasicTests.assertEquals((int)1, (int)stringArray.length);
        BasicTests.assertNull((Object)this.client.getMergeinfo(new File(oneTest.getWCPath(), "A").toString(), Revision.HEAD));
        this.appendText(oneTest, "A/mu", "xxx", 4);
        this.appendText(oneTest, "A/D/G/rho", "yyy", 4);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true), (long)4L);
        String string = oneTest.getWCPath() + "/branches/A";
        String string2 = oneTest.getUrl() + "/A";
        RevisionRange[] revisionRangeArray = new RevisionRange[]{new RevisionRange(new Revision.Number(2L), new Revision.Number(4L))};
        this.client.merge(string2, Revision.HEAD, revisionRangeArray, string, true, 3, false, false, true);
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "branches/A", 2, 8);
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", true), (long)5L);
        String string3 = new File(oneTest.getWCPath(), "branches/A").getPath();
        String string4 = oneTest.getUrl() + "/A";
        this.acquireMergeinfoAndAssertEquals(2L, 4L, 0L, 0L, string3, string4);
    }

    private SVNTests.OneTest setupAndPerformMerge() throws Exception {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        String[] stringArray = this.client.suggestMergeSources(oneTest.getWCPath(), Revision.WORKING);
        BasicTests.assertNotNull((Object)stringArray);
        BasicTests.assertEquals((int)0, (int)stringArray.length);
        this.addExpectedCommitItem(null, oneTest.getUrl(), "branches", 0, 1);
        this.client.mkdir(new String[]{oneTest.getUrl() + "/branches"}, "log_msg");
        this.addExpectedCommitItem(null, oneTest.getUrl(), "branches/A", 0, 1);
        this.client.copy(oneTest.getUrl() + "/A", oneTest.getUrl() + "/branches/A", "create A branch", Revision.HEAD);
        this.client.update(oneTest.getWCPath(), Revision.HEAD, true);
        return oneTest;
    }

    public void testDiff() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest(true);
        File file = new File(this.localTmp, oneTest.testName);
        String string = System.getProperty("line.separator");
        String string2 = "===================================================================" + string;
        String string3 = "___________________________________________________________________" + string;
        String string4 = "@@ -1 +1 @@" + string + "-This is the file 'iota'." + string + "\\ No newline at end of file" + string + "+This is the file 'mu'." + string + "\\ No newline at end of file" + string;
        String string5 = oneTest.getWCPath().replace('\\', '/') + "/iota";
        String string6 = this.fileToSVNPath(new File(oneTest.getWCPath()), false);
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(string5));
        printWriter.print("This is the file 'mu'.");
        printWriter.flush();
        printWriter.close();
        String string7 = "Index: iota" + string + string2 + "--- iota\t(.../iota)\t(revision 1)" + string + "+++ iota\t(.../A/mu)\t(revision 1)" + string + string4;
        this.client.diff(oneTest.getUrl() + "/iota", Revision.HEAD, oneTest.getUrl() + "/A/mu", Revision.HEAD, file.getPath(), false, true, true, false);
        this.assertFileContentsEquals("Unexpected diff output in file '" + file.getPath() + '\'', string7, file);
        try {
            this.client.diff(oneTest.getUrl() + "/iota", Revision.HEAD, oneTest.getUrl() + "/A/mu", Revision.HEAD, oneTest.getUrl(), file.getPath(), 3, null, true, true, false);
            BasicTests.fail((String)"This test should fail because the relativeToDir parameter does not work with URLs");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.client.diff(string5, Revision.BASE, string5, Revision.WORKING, "/non/existent/path", file.getPath(), 3, null, true, true, false);
            BasicTests.fail((String)"This test should fail because iotaPath is not a child of the relativeToDir parameter");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string8 = this.fileToSVNPath(new File(oneTest.getWCPath() + "/A"), false);
        string7 = "Index: A" + string + string2 + "--- A\t(revision 1)" + string + "+++ A\t(working copy)" + string + string + "Property changes on: A" + string + string3 + "Added: testprop" + string + "## -0,0 +1 ##" + string + "+Test property value." + string;
        this.client.propertySet(string8, "testprop", "Test property value." + string, false);
        this.client.diff(string8, Revision.BASE, string8, Revision.WORKING, string6, file.getPath(), 3, null, true, true, false);
        this.assertFileContentsEquals("Unexpected diff output in file '" + file.getPath() + '\'', string7, file);
        string7 = "Index: ." + string + string2 + "--- .\t(revision 1)" + string + "+++ .\t(working copy)" + string + string + "Property changes on: ." + string + string3 + "Added: testprop" + string + "## -0,0 +1 ##" + string + "+Test property value." + string;
        this.client.propertySet(string8, "testprop", "Test property value." + string, false);
        this.client.diff(string8, Revision.BASE, string8, Revision.WORKING, string8, file.getPath(), 3, null, true, true, false);
        this.assertFileContentsEquals("Unexpected diff output in file '" + file.getPath() + '\'', string7, file);
        for (int i = 1; i < 3; ++i) {
            String string9 = "While processing operativeRevison=" + i + ". ";
            String string10 = string9 + "Unexpected diff output in file '";
            this.client.revert(string6, true);
            if (i == 2) {
                this.client.propertyCreate(string5, "svn:eol-style", "native", false);
                String[] stringArray = new String[]{string5};
                this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "iota", 1, 8);
                this.client.commit(stringArray, "Set svn:eol-style to native", false);
            }
            printWriter = new PrintWriter(new FileOutputStream(string5));
            printWriter.print("This is the file 'mu'.");
            printWriter.flush();
            printWriter.close();
            string7 = "Index: " + string5 + string + string2 + "--- " + string5 + "\t(revision " + i + ")" + string + "+++ " + string5 + "\t(working copy)" + string + string4;
            try {
                this.client.diff(string5, Revision.BASE, string5, Revision.WORKING, file.getPath(), false, true, true, false);
                this.assertFileContentsEquals(string10 + file.getPath() + '\'', string7, file);
                file.delete();
            }
            catch (ClientException clientException) {
                BasicTests.fail((String)(string9 + clientException.getMessage()));
            }
            try {
                this.client.diff(oneTest.getUrl() + "/iota", Revision.HEAD, new Revision.Number((long)i), Revision.HEAD, file.getPath(), false, true, true, false);
                this.assertFileContentsEquals(string10 + file.getPath() + '\'', "", file);
                file.delete();
            }
            catch (ClientException clientException) {
                BasicTests.fail((String)(string9 + clientException.getMessage()));
            }
            string7 = "Index: iota" + string + string2 + "--- iota\t(revision " + i + ")" + string + "+++ iota\t(working copy)" + string + string4;
            try {
                this.client.diff(string5, Revision.BASE, string5, Revision.WORKING, string6, file.getPath(), 3, null, true, true, false);
                this.assertFileContentsEquals(string10 + file.getPath() + '\'', string7, file);
                file.delete();
            }
            catch (ClientException clientException) {
                BasicTests.fail((String)(string9 + clientException.getMessage()));
            }
            try {
                this.client.diff(string5, Revision.BASE, string5, Revision.WORKING, string6 + "/", file.getPath(), 3, null, true, true, false);
                this.assertFileContentsEquals(string10 + file.getPath() + '\'', string7, file);
                file.delete();
                continue;
            }
            catch (ClientException clientException) {
                BasicTests.fail((String)(string9 + clientException.getMessage()));
            }
        }
    }

    private void assertFileContentsEquals(String string, String string2, File file) throws IOException {
        int n;
        FileReader fileReader = new FileReader(file);
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = fileReader.read()) != -1) {
            stringBuffer.append((char)n);
        }
        BasicTests.assertEquals((String)string, (String)string2, (String)stringBuffer.toString());
    }

    public void testDiffSummarize() throws SubversionException, IOException {
        SVNTests.OneTest oneTest = new SVNTests.OneTest(false);
        DiffSummaries diffSummaries = new DiffSummaries();
        this.client.diffSummarize(oneTest.getUrl(), (Revision)new Revision.Number(0L), oneTest.getUrl(), Revision.HEAD, 3, null, false, (DiffSummaryReceiver)diffSummaries);
        this.assertExpectedDiffSummaries(diffSummaries);
        diffSummaries.clear();
        this.client.diffSummarize(oneTest.getUrl(), Revision.HEAD, new Revision.Number(0L), Revision.HEAD, 3, null, false, (DiffSummaryReceiver)diffSummaries);
        this.assertExpectedDiffSummaries(diffSummaries);
    }

    private void assertExpectedDiffSummaries(DiffSummaries diffSummaries) {
        BasicTests.assertEquals((String)"Wrong number of diff summary descriptors", (int)20, (int)diffSummaries.size());
        DiffSummary diffSummary = (DiffSummary)diffSummaries.get("A/B/E/beta");
        BasicTests.assertNotNull((String)"No diff summary for A/B/E/beta", (Object)diffSummary);
        BasicTests.assertEquals((String)"Incorrect path for A/B/E/beta", (String)"A/B/E/beta", (String)diffSummary.getPath());
        BasicTests.assertTrue((String)"Incorrect diff kind for A/B/E/beta", (boolean)DiffSummary.DiffKind.ADDED.equals(diffSummary.getDiffKind()));
        BasicTests.assertEquals((String)"Incorrect props changed notice for A/B/E/beta", (boolean)false, (boolean)diffSummary.propsChanged());
        BasicTests.assertEquals((String)"Incorrect node kind for A/B/E/beta", (int)1, (int)diffSummary.getNodeKind());
    }

    public void testBasicIsAdminDirectory() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        Notify2 notify2 = new Notify2(){

            @Override
            public void onNotify(NotifyInformation notifyInformation) {
                BasicTests.this.client.isAdminDirectory(".svn");
            }
        };
        this.client.notification2(notify2);
        BasicTests.assertEquals((String)"wrong revision number from update", (long)this.client.update(oneTest.getWCPath(), null, true), (long)1L);
    }

    public void testBasicCancelOperation() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        Notify2 notify2 = new Notify2(){

            @Override
            public void onNotify(NotifyInformation notifyInformation) {
                try {
                    BasicTests.this.client.cancelOperation();
                }
                catch (ClientException clientException) {
                    TestCase.fail((String)clientException.getMessage());
                }
            }
        };
        this.client.notification2(notify2);
        try {
            this.client.update(oneTest.getWCPath(), null, true);
            BasicTests.fail((String)"missing exception for canceled operation");
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    public void testDataTransferProgressReport() throws Throwable {
        if (SVNTests.rootUrl.startsWith("file://")) {
            return;
        }
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        CountingProgressListener countingProgressListener = new CountingProgressListener();
        this.client.setProgressListener(countingProgressListener);
        this.client.update(oneTest.getWCPath(), null, true);
        if (!countingProgressListener.gotProgress) {
            BasicTests.fail((String)"No progress reported");
        }
    }

    public void testTreeConflict() throws Throwable {
        Object object;
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        WC wC = oneTest.getWc();
        SVNTests.OneTest oneTest2 = oneTest.copy(".tree-conflict");
        String[] stringArray = new String[]{"alpha"};
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            stringArray[i] = new File(oneTest.getWorkingCopy(), "A/B/E/" + (String)object).getPath();
            wC.addItem("A/B/F/" + (String)object, wC.getItemContent("A/B/E/" + (String)object));
            wC.setItemWorkingCopyRevision("A/B/F/" + (String)object, 2L);
            this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/B/F/" + (String)object, 1, 17);
            wC.removeItem("A/B/E/" + (String)object);
            this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/B/E/" + (String)object, 1, 2);
        }
        this.client.move(stringArray, new File(oneTest.getWorkingCopy(), "A/B/F").getPath(), null, false, true, false, null);
        BasicTests.assertEquals((String)"Unexpected WC revision number after commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "Move files", true), (long)2L);
        oneTest.checkStatus();
        File file = new File(oneTest2.getWorkingCopy(), "A/B/E/alpha");
        object = new PrintWriter(new FileOutputStream(file, true));
        ((PrintWriter)object).print("appended alpha text");
        ((PrintWriter)object).close();
        BasicTests.assertEquals((String)"wrong revision number from update", (long)this.client.update(oneTest2.getWCPath(), null, true), (long)2L);
        oneTest2.getWc().addItem("A/B/F/alpha", oneTest2.getWc().getItemContent("A/B/E/alpha"));
        oneTest2.getWc().setItemWorkingCopyRevision("A/B/F/alpha", 2L);
        oneTest2.getWc().setItemTextStatus("A/B/E/alpha", 3);
        oneTest2.getWc().setItemTextStatus("A/B/F/alpha", 1);
        oneTest2.checkStatus();
        MyInfoCallback myInfoCallback = new MyInfoCallback();
        this.client.info2(oneTest2.getWCPath() + "/A/B/E/alpha", null, null, -2, null, myInfoCallback);
        ConflictDescriptor conflictDescriptor = myInfoCallback.getInfo().getConflictDescriptor();
        BasicTests.assertNotNull((String)"Conflict should not be null", (Object)conflictDescriptor);
        BasicTests.assertEquals((int)conflictDescriptor.getSrcLeftVersion().getNodeKind(), (int)1);
        BasicTests.assertEquals((String)(conflictDescriptor.getSrcLeftVersion().getReposURL() + "/" + conflictDescriptor.getSrcLeftVersion().getPathInRepos()), (String)(oneTest2.getUrl() + "/A/B/E/alpha"));
        BasicTests.assertEquals((long)conflictDescriptor.getSrcLeftVersion().getPegRevision(), (long)1L);
        if (conflictDescriptor.getSrcRightVersion() != null) {
            BasicTests.assertEquals((int)conflictDescriptor.getSrcRightVersion().getNodeKind(), (int)0);
            BasicTests.assertEquals((String)conflictDescriptor.getSrcRightVersion().getReposURL(), (String)oneTest2.getUrl());
            BasicTests.assertEquals((long)conflictDescriptor.getSrcRightVersion().getPegRevision(), (long)2L);
        }
    }

    public void testBasicBlame() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        byte[] byArray = this.client.blame(oneTest.getWCPath() + "/iota", Revision.getInstance(1L), Revision.getInstance(1L));
        BasicTests.assertEquals((String)"     1    jrandom This is the file 'iota'.\n", (String)new String(byArray));
        BlameCallbackImpl blameCallbackImpl = new BlameCallbackImpl();
        this.client.blame(oneTest.getWCPath() + "/iota", Revision.getInstance(1L), Revision.getInstance(1L), blameCallbackImpl);
        BasicTests.assertEquals((int)1, (int)blameCallbackImpl.numberOfLines());
        BlameCallbackImpl.BlameLine blameLine = blameCallbackImpl.getBlameLine(0);
        if (blameLine != null) {
            BasicTests.assertEquals((long)1L, (long)blameLine.getRevision());
            BasicTests.assertEquals((String)"jrandom", (String)blameLine.getAuthor());
        }
    }

    public void testCommitRevprops() throws Throwable {
        SVNTests.OneTest oneTest = new SVNTests.OneTest();
        File file = new File(oneTest.getWorkingCopy(), "A/mu");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file, true));
        printWriter.print("appended mu text");
        printWriter.close();
        oneTest.getWc().setItemWorkingCopyRevision("A/mu", 2L);
        oneTest.getWc().setItemContent("A/mu", oneTest.getWc().getItemContent("A/mu") + "appended mu text");
        this.addExpectedCommitItem(oneTest.getWCPath(), oneTest.getUrl(), "A/mu", 1, 4);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("kfogel", "rockstar");
        hashMap.put("cmpilato", "theman");
        BasicTests.assertEquals((String)"wrong revision number from commit", (long)this.client.commit(new String[]{oneTest.getWCPath()}, "log msg", 3, true, true, null, hashMap), (long)2L);
        oneTest.checkStatus();
        class RevpropLogCallback
        implements LogMessageCallback {
            Map revprops;

            RevpropLogCallback() {
            }

            @Override
            public void singleMessage(ChangePath[] changePathArray, long l, Map map, boolean bl) {
                this.revprops = map;
            }

            public Map getRevprops() {
                return this.revprops;
            }
        }
        RevpropLogCallback revpropLogCallback = new RevpropLogCallback();
        this.client.logMessages(oneTest.getWCPath(), Revision.getInstance(2L), Revision.getInstance(2L), Revision.getInstance(2L), false, false, false, new String[]{"kfogel", "cmpilato"}, 0L, revpropLogCallback);
        Map map = revpropLogCallback.getRevprops();
        BasicTests.assertEquals((String)"wrong number of fetched revprops", (int)hashMap.size(), (int)map.size());
        Set set = map.keySet();
        for (String string : set) {
            BasicTests.assertEquals((String)"revprops check", hashMap.get(string), map.get(string));
        }
    }

    private String fileToSVNPath(File file, boolean bl) {
        if (bl) {
            try {
                return file.getCanonicalPath().replace('\\', '/');
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return file.getPath().replace('\\', '/');
    }

    private class MyInfoCallback
    implements InfoCallback {
        private Info2 info;

        private MyInfoCallback() {
        }

        @Override
        public void singleInfo(Info2 info2) {
            this.info = info2;
        }

        public Info2 getInfo() {
            return this.info;
        }
    }

    private class MyChangelistCallback
    extends HashMap
    implements ChangelistCallback {
        private static final long serialVersionUID = 1L;

        private MyChangelistCallback() {
        }

        @Override
        public void doChangelist(String string, String string2) {
            if (super.containsKey(string = BasicTests.this.fileToSVNPath(new File(string), true))) {
                List list = (List)super.get(string);
                list.add(string2);
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string2);
                super.put(string, arrayList);
            }
        }

        public List get(String string) {
            return (List)super.get(string);
        }
    }

    private static class DiffSummaries
    extends HashMap
    implements DiffSummaryReceiver {
        private static final long serialVersionUID = 1L;

        private DiffSummaries() {
        }

        @Override
        public void onSummary(DiffSummary diffSummary) {
            super.put(diffSummary.getPath(), diffSummary);
        }
    }

    private static class CountingProgressListener
    implements ProgressListener {
        public boolean gotProgress = false;

        private CountingProgressListener() {
        }

        @Override
        public void onProgress(ProgressEvent progressEvent) {
            this.gotProgress = true;
        }
    }
}

