unit KeyboardDialog_U;
// Description: "Secure Keyboard Entry" Dialog
// By Sarah Dean
// Email: sdean12@mailcity.com
// WWW:   http://www.fortunecity.com/skyscraper/true/882/
//
// -----------------------------------------------------------------------------
// Version history:
// 1.00 - 1st July 1999
//        Initial release


interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TKeyboardDialog = class(TComponent)
  private
    { Private declarations }
  protected
    { Protected declarations }
  public
    Password: string;
    function  Execute(): boolean;
    procedure BlankPassword();
  published
    { Published declarations }
  end;

procedure Register;

implementation

uses KeyboardEntryDlg_U;

procedure Register;
begin
  RegisterComponents('SDeanSecurity', [TKeyboardDialog]);
end;

function TKeyboardDialog.Execute(): boolean;
var
  entryDlg: TKeyboardEntryDlg;
begin
  Result := FALSE;

  entryDlg:= TKeyboardEntryDlg.create(nil);
  try
    if entryDlg.Showmodal()=mrOK then
      begin
      Password := entryDlg.Password;
      entryDlg.BlankPassword();
      Result := TRUE;
      end;
  finally
    entryDlg.Free();
  end;
end;

procedure TKeyboardDialog.BlankPassword();
var
  i: integer;
begin
  randomize;
  for i:=1 to length(Password) do
    begin
    Password[i] := chr(random(255));
    Password[i] := #0;
    end;

  Password := '';
end;


END.

