DIR=$1

[ -d "$DIR" ] || { echo "give the directory where pcmcia lives in" ; exit 1; }

install -m 644 $DIR/cardmgr/probe.c .

for i in i82365.h cirrus.h vg468.h tcic.h; do install -m 644 $DIR/modules/$i . ; done

[ -d pcmcia ] || mkdir pcmcia
install -m 644 $DIR/include/pcmcia/config.h pcmcia

perl -pi -e 's/f?printf/logMessage/g; s/^(int main)/#if 0\n$1/' probe.c

cat <<EOF >>probe.c
#endif
char *pcmciaProbeController(void) {
    int verbose = 0, module = 0;
    ioaddr_t tcic_base = TCIC_BASE;
    if (pci_probe(verbose, module) == 0)
        return "i82365";
    else if (i365_probe(verbose, module) == 0)
        return "i82365";
    else if (tcic_probe(verbose, module, tcic_base) == 0)
        return "tcic";
    else
        return NULL;
}

EOF