unit SDUProgress_U;
// Description: Progress bar dialog
// By Sarah Dean
//
// -----------------------------------------------------------------------------
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls;

type
  TSDUProgress_F = class(TForm)
    pgbOverall: TProgressBar;
    pbCancel: TButton;
    procedure pbCancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    fConfirmCancel: boolean;
    i64MinValue: int64;
    i64MaxValue: int64;
    i64PositionValue: int64;

    procedure UpdateI64ProgressBar();

    procedure iSetMax(max: integer);
    procedure iSetMin(min: integer);
    procedure iSetPosition(position: integer);
    procedure iSetInversePosition(position: integer);

    procedure i64SetMax(max: int64);
    procedure i64SetMin(min: int64);
    procedure i64SetPosition(position: int64);
    procedure i64SetInversePosition(position: int64);
  public
    Cancel: boolean;
    property  Max: integer write iSetMax;
    property  Min: integer write iSetMin;
    property  Position: integer write iSetPosition;
    property  InversePosition: integer write iSetInversePosition;
    procedure IncPosition();

    property  i64Max: int64 write i64SetMax;
    property  i64Min: int64 write i64SetMin;
    property  i64Position: int64 write i64SetPosition;
    property  i64InversePosition: int64 write i64SetInversePosition;
    procedure i64IncPosition();

    property  ConfirmCancel: boolean write fConfirmCancel default TRUE;
  end;


implementation

{$R *.DFM}

uses SDUGeneral,
     math;

procedure TSDUProgress_F.UpdateI64ProgressBar();
var
  barLength: int64;
  barPos: int64;
  percentPos: integer;
begin
  iSetMin(0);
  iSetMax(100);

  barLength := i64MaxValue - i64MinValue;
  barPos := i64PositionValue - i64MinValue;

  if (i64MaxValue<>0) then
    begin
    percentPos := ((barPos*100) div barLength);
    iSetPosition(percentPos);
    end;

end;



procedure TSDUProgress_F.iSetMax(max: integer);
begin
  pgbOverall.Max := max;
end;

procedure TSDUProgress_F.iSetMin(min: integer);
begin
  pgbOverall.Min := min;
end;

procedure TSDUProgress_F.iSetPosition(position: integer);
begin
  if position>pgbOverall.Max then
    begin
    pgbOverall.position := pgbOverall.Max
    end
  else if position<pgbOverall.Min then
    begin
    pgbOverall.position := pgbOverall.Min
    end
  else
    begin
    pgbOverall.position := position;
    end;

  self.refresh;
  Application.ProcessMessages();
end;

procedure TSDUProgress_F.iSetInversePosition(position: integer);
begin
  iSetPosition(pgbOverall.Max-position);

end;

procedure TSDUProgress_F.IncPosition();
begin
  iSetPosition(pgbOverall.Position+1);

end;


procedure TSDUProgress_F.i64SetMax(max: int64);
begin
  i64MaxValue := max;
  UpdateI64ProgressBar();

end;

procedure TSDUProgress_F.i64SetMin(min: int64);
begin
  i64MinValue := min;
  UpdateI64ProgressBar();

end;

procedure TSDUProgress_F.i64SetPosition(position: int64);
begin
  i64PositionValue := position;
  UpdateI64ProgressBar();

end;

procedure TSDUProgress_F.i64SetInversePosition(position: int64);
begin
  i64PositionValue := i64MaxValue-position;
  UpdateI64ProgressBar();

end;

procedure TSDUProgress_F.i64IncPosition();
begin
  i64PositionValue := i64PositionValue + 1;
  UpdateI64ProgressBar();

end;


procedure TSDUProgress_F.pbCancelClick(Sender: TObject);
begin
  Cancel := TRUE;
  pbCancel.Enabled := FALSE;
  if fConfirmCancel then
    begin
    showmessage('Operation cancelled by user');
    end;

end;

procedure TSDUProgress_F.FormCreate(Sender: TObject);
begin
  pbCancel.Enabled := TRUE;
  Cancel := FALSE;

end;

END.

