unit SDULogger_U;

interface

type
  TSDULogger = class
  private
    FFilename: string;

  public
    constructor Create(); overload;
    constructor Create(fname: string); overload;
    destructor  Destroy(); override;


    // Log a message, together with time/date
    // If "timedAt" isn't specified, the current time will be used
    function  LogMessage(msg: string; timedAt: TDateTime = 0): boolean;

  published
    property Filename: string read FFilename write FFilename;
  end;

implementation

uses
  // If this compiler directive is set, then the logger will attempt to send
  // messages to the GExperts debug window
  // See: www.gexperts.org
{$IFDEF _GEXPERTS_DEBUG}
  DbugIntf,
{$ENDIF}
  sysutils;

constructor TSDULogger.Create();
begin
  inherited;
  Filename := '';

end;


constructor TSDULogger.Create(fname: string);
begin
  inherited Create();
  Filename := fname;

end;


destructor TSDULogger.Destroy();
begin
  inherited;

end;


// If "timedAt" isn't specified, the current time will be used
function TSDULogger.LogMessage(msg: string; timedAt: TDateTime = 0): boolean;
var
  logfile: TextFile;
begin
  if Filename<>'' then
    begin

    if timedAt=0 then
      begin
      timedAt := Now();
      end;

    AssignFile(logfile, Filename);
    if FileExists(Filename) then
      begin
      Append(logfile);
      end
    else
      begin
      Rewrite(logfile);
      end;
    Writeln(logfile, '['+DateTimeToStr(timedAt)+'] '+msg);
    CloseFile(logfile);
{$IFDEF _GEXPERTS_DEBUG}
  // Send debug message to GExperts debug window
  SendDebug('['+DateTimeToStr(timedAt)+'] '+msg);
{$ENDIF}

    end;

  Result := TRUE;

end;



END.

