# Copyright 2024-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.0

EAPI=8

CRATES=""
RUST_MIN_VER="1.85.0"

declare -A GIT_CRATES=(
	[libdrm_amdgpu_sys]='https://github.com/Umio-Yasuno/libdrm-amdgpu-sys-rs;8d0029b4cf8f3b995728614f96c03f6e3dcf4f9e;libdrm-amdgpu-sys-rs-%commit%'
)

inherit desktop cargo

DESCRIPTION="Tool to display AMDGPU usage."
HOMEPAGE="https://github.com/Umio-Yasuno/amdgpu_top"
SRC_URI="
	https://github.com/Umio-Yasuno/amdgpu_top/archive/refs/tags/v${PV}.tar.gz -> ${P}.gh.tar.gz
	${CARGO_CRATE_URIS}
	https://github.com/gentoo-crate-dist/${PN}/releases/download/v${PV}/${P}-crates.tar.xz
"

LICENSE="MIT"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 Boost-1.0 CC0-1.0 ISC MIT OFL-1.1 UbuntuFontLicense-1.0
	Unicode-3.0 ZLIB
"
SLOT="0"
KEYWORDS="~amd64 ~arm64"

IUSE="man"

DEPEND="
	x11-libs/libdrm:=[video_cards_amdgpu]
"
RDEPEND="${DEPEND}"
BDEPEND="
	man? (
		|| (
			app-text/lowdown
			virtual/pandoc
		)
	)
"

QA_PREBUILT="/usr/bin/amdgpu_top"

DOCS=(
	README.md
)

src_compile() {
	cargo_src_compile

	if use man; then
		local docgen=lowdown

		# prefer pandoc if it's installed
		has_version virtual/pandoc && docgen=pandoc

		"${docgen}" docs/man.${PN}.md -s -t man -o docs/${PN}.1 \
			|| die "failed to generate man page with ${docgen}"
	fi
}

src_install() {
	cargo_src_install

	use man && doman docs/${PN}.1
	domenu assets/*.desktop
	dodoc "${DOCS[@]}" docs/*
}
