# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

inherit flag-o-matic systemd toolchain-funcs

DESCRIPTION="A software watchdog and /dev/watchdog daemon"
HOMEPAGE="https://sourceforge.net/projects/watchdog/"
SRC_URI="https://downloads.sourceforge.net/${PN}/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~alpha amd64 arm ~arm64 ~hppa ~m68k ~mips ppc ~ppc64 ~riscv ~s390 ~sparc x86"
IUSE="nfs"

RDEPEND="nfs? ( net-libs/libtirpc )"
DEPEND="${RDEPEND}"
BDEPEND="
	virtual/pkgconfig
"

src_configure() {
	if use nfs; then
		append-cppflags "$($(tc-getPKG_CONFIG) libtirpc --cflags)"
		append-libs "$($(tc-getPKG_CONFIG) libtirpc --libs)"
	fi
	econf $(use_enable nfs)
}

src_install() {
	default
	dodoc -r examples

	newconfd "${FILESDIR}"/${PN}-conf.d ${PN}
	newinitd "${FILESDIR}"/${PN}-init.d-r1 ${PN}
	systemd_dounit "${FILESDIR}"/watchdog.service
}
